<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$AWali_list = new AWali_list();

// Run the page
$AWali_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$AWali_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$AWali_list->isExport()) { ?>
<script>
var fAWalilist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fAWalilist = currentForm = new ew.Form("fAWalilist", "list");
	fAWalilist.formKeyCountName = '<?php echo $AWali_list->FormKeyCountName ?>';

	// Validate form
	fAWalilist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($AWali_list->Th_Ak->Required) { ?>
				elm = this.getElements("x" + infix + "_Th_Ak");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Th_Ak->caption(), $AWali_list->Th_Ak->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($AWali_list->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Periode->caption(), $AWali_list->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($AWali_list->Kode_Fak->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_Fak");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Kode_Fak->caption(), $AWali_list->Kode_Fak->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($AWali_list->Kelas->Required) { ?>
				elm = this.getElements("x" + infix + "_Kelas");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Kelas->caption(), $AWali_list->Kelas->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($AWali_list->Semester->Required) { ?>
				elm = this.getElements("x" + infix + "_Semester");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Semester->caption(), $AWali_list->Semester->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($AWali_list->Awal_Perwalian->Required) { ?>
				elm = this.getElements("x" + infix + "_Awal_Perwalian");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Awal_Perwalian->caption(), $AWali_list->Awal_Perwalian->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Awal_Perwalian");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($AWali_list->Awal_Perwalian->errorMessage()) ?>");
			<?php if ($AWali_list->Akhir_Perwalian->Required) { ?>
				elm = this.getElements("x" + infix + "_Akhir_Perwalian");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Akhir_Perwalian->caption(), $AWali_list->Akhir_Perwalian->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Akhir_Perwalian");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($AWali_list->Akhir_Perwalian->errorMessage()) ?>");
			<?php if ($AWali_list->Awal_Perubahan->Required) { ?>
				elm = this.getElements("x" + infix + "_Awal_Perubahan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Awal_Perubahan->caption(), $AWali_list->Awal_Perubahan->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Awal_Perubahan");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($AWali_list->Awal_Perubahan->errorMessage()) ?>");
			<?php if ($AWali_list->Akhir_Perubahan->Required) { ?>
				elm = this.getElements("x" + infix + "_Akhir_Perubahan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $AWali_list->Akhir_Perubahan->caption(), $AWali_list->Akhir_Perubahan->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Akhir_Perubahan");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($AWali_list->Akhir_Perubahan->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fAWalilist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fAWalilist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fAWalilist.lists["x_Th_Ak"] = <?php echo $AWali_list->Th_Ak->Lookup->toClientList($AWali_list) ?>;
	fAWalilist.lists["x_Th_Ak"].options = <?php echo JsonEncode($AWali_list->Th_Ak->lookupOptions()) ?>;
	fAWalilist.lists["x_Periode"] = <?php echo $AWali_list->Periode->Lookup->toClientList($AWali_list) ?>;
	fAWalilist.lists["x_Periode"].options = <?php echo JsonEncode($AWali_list->Periode->options(FALSE, TRUE)) ?>;
	fAWalilist.lists["x_Kode_Fak"] = <?php echo $AWali_list->Kode_Fak->Lookup->toClientList($AWali_list) ?>;
	fAWalilist.lists["x_Kode_Fak"].options = <?php echo JsonEncode($AWali_list->Kode_Fak->lookupOptions()) ?>;
	fAWalilist.lists["x_Kelas"] = <?php echo $AWali_list->Kelas->Lookup->toClientList($AWali_list) ?>;
	fAWalilist.lists["x_Kelas"].options = <?php echo JsonEncode($AWali_list->Kelas->lookupOptions()) ?>;
	fAWalilist.lists["x_Semester"] = <?php echo $AWali_list->Semester->Lookup->toClientList($AWali_list) ?>;
	fAWalilist.lists["x_Semester"].options = <?php echo JsonEncode($AWali_list->Semester->options(FALSE, TRUE)) ?>;
	loadjs.done("fAWalilist");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$AWali_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($AWali_list->TotalRecords > 0 && $AWali_list->ExportOptions->visible()) { ?>
<?php $AWali_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($AWali_list->ImportOptions->visible()) { ?>
<?php $AWali_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$AWali_list->renderOtherOptions();
?>
<?php $AWali_list->showPageHeader(); ?>
<?php
$AWali_list->showMessage();
?>
<?php if ($AWali_list->TotalRecords > 0 || $AWali->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($AWali_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> AWali">
<form name="fAWalilist" id="fAWalilist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="AWali">
<div id="gmp_AWali" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($AWali_list->TotalRecords > 0 || $AWali_list->isGridEdit()) { ?>
<table id="tbl_AWalilist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$AWali->RowType = ROWTYPE_HEADER;

// Render list options
$AWali_list->renderListOptions();

// Render list options (header, left)
$AWali_list->ListOptions->render("header", "left");
?>
<?php if ($AWali_list->Th_Ak->Visible) { // Th_Ak ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Th_Ak) == "") { ?>
		<th data-name="Th_Ak" class="<?php echo $AWali_list->Th_Ak->headerCellClass() ?>"><div id="elh_AWali_Th_Ak" class="AWali_Th_Ak"><div class="ew-table-header-caption"><?php echo $AWali_list->Th_Ak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Th_Ak" class="<?php echo $AWali_list->Th_Ak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Th_Ak) ?>', 1);"><div id="elh_AWali_Th_Ak" class="AWali_Th_Ak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Th_Ak->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Th_Ak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Th_Ak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AWali_list->Periode->Visible) { // Periode ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $AWali_list->Periode->headerCellClass() ?>"><div id="elh_AWali_Periode" class="AWali_Periode"><div class="ew-table-header-caption"><?php echo $AWali_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $AWali_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Periode) ?>', 1);"><div id="elh_AWali_Periode" class="AWali_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AWali_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $AWali_list->Kode_Fak->headerCellClass() ?>"><div id="elh_AWali_Kode_Fak" class="AWali_Kode_Fak"><div class="ew-table-header-caption"><?php echo $AWali_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $AWali_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Kode_Fak) ?>', 1);"><div id="elh_AWali_Kode_Fak" class="AWali_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AWali_list->Kelas->Visible) { // Kelas ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Kelas) == "") { ?>
		<th data-name="Kelas" class="<?php echo $AWali_list->Kelas->headerCellClass() ?>"><div id="elh_AWali_Kelas" class="AWali_Kelas"><div class="ew-table-header-caption"><?php echo $AWali_list->Kelas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas" class="<?php echo $AWali_list->Kelas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Kelas) ?>', 1);"><div id="elh_AWali_Kelas" class="AWali_Kelas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Kelas->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Kelas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Kelas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AWali_list->Semester->Visible) { // Semester ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Semester) == "") { ?>
		<th data-name="Semester" class="<?php echo $AWali_list->Semester->headerCellClass() ?>"><div id="elh_AWali_Semester" class="AWali_Semester"><div class="ew-table-header-caption"><?php echo $AWali_list->Semester->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Semester" class="<?php echo $AWali_list->Semester->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Semester) ?>', 1);"><div id="elh_AWali_Semester" class="AWali_Semester">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Semester->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Semester->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Semester->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AWali_list->Awal_Perwalian->Visible) { // Awal_Perwalian ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Awal_Perwalian) == "") { ?>
		<th data-name="Awal_Perwalian" class="<?php echo $AWali_list->Awal_Perwalian->headerCellClass() ?>"><div id="elh_AWali_Awal_Perwalian" class="AWali_Awal_Perwalian"><div class="ew-table-header-caption"><?php echo $AWali_list->Awal_Perwalian->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Awal_Perwalian" class="<?php echo $AWali_list->Awal_Perwalian->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Awal_Perwalian) ?>', 1);"><div id="elh_AWali_Awal_Perwalian" class="AWali_Awal_Perwalian">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Awal_Perwalian->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Awal_Perwalian->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Awal_Perwalian->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AWali_list->Akhir_Perwalian->Visible) { // Akhir_Perwalian ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Akhir_Perwalian) == "") { ?>
		<th data-name="Akhir_Perwalian" class="<?php echo $AWali_list->Akhir_Perwalian->headerCellClass() ?>"><div id="elh_AWali_Akhir_Perwalian" class="AWali_Akhir_Perwalian"><div class="ew-table-header-caption"><?php echo $AWali_list->Akhir_Perwalian->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Akhir_Perwalian" class="<?php echo $AWali_list->Akhir_Perwalian->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Akhir_Perwalian) ?>', 1);"><div id="elh_AWali_Akhir_Perwalian" class="AWali_Akhir_Perwalian">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Akhir_Perwalian->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Akhir_Perwalian->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Akhir_Perwalian->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AWali_list->Awal_Perubahan->Visible) { // Awal_Perubahan ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Awal_Perubahan) == "") { ?>
		<th data-name="Awal_Perubahan" class="<?php echo $AWali_list->Awal_Perubahan->headerCellClass() ?>"><div id="elh_AWali_Awal_Perubahan" class="AWali_Awal_Perubahan"><div class="ew-table-header-caption"><?php echo $AWali_list->Awal_Perubahan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Awal_Perubahan" class="<?php echo $AWali_list->Awal_Perubahan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Awal_Perubahan) ?>', 1);"><div id="elh_AWali_Awal_Perubahan" class="AWali_Awal_Perubahan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Awal_Perubahan->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Awal_Perubahan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Awal_Perubahan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AWali_list->Akhir_Perubahan->Visible) { // Akhir_Perubahan ?>
	<?php if ($AWali_list->SortUrl($AWali_list->Akhir_Perubahan) == "") { ?>
		<th data-name="Akhir_Perubahan" class="<?php echo $AWali_list->Akhir_Perubahan->headerCellClass() ?>"><div id="elh_AWali_Akhir_Perubahan" class="AWali_Akhir_Perubahan"><div class="ew-table-header-caption"><?php echo $AWali_list->Akhir_Perubahan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Akhir_Perubahan" class="<?php echo $AWali_list->Akhir_Perubahan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AWali_list->SortUrl($AWali_list->Akhir_Perubahan) ?>', 1);"><div id="elh_AWali_Akhir_Perubahan" class="AWali_Akhir_Perubahan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AWali_list->Akhir_Perubahan->caption() ?></span><span class="ew-table-header-sort"><?php if ($AWali_list->Akhir_Perubahan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AWali_list->Akhir_Perubahan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$AWali_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($AWali_list->ExportAll && $AWali_list->isExport()) {
	$AWali_list->StopRecord = $AWali_list->TotalRecords;
} else {

	// Set the last record to display
	if ($AWali_list->TotalRecords > $AWali_list->StartRecord + $AWali_list->DisplayRecords - 1)
		$AWali_list->StopRecord = $AWali_list->StartRecord + $AWali_list->DisplayRecords - 1;
	else
		$AWali_list->StopRecord = $AWali_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($AWali->isConfirm() || $AWali_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($AWali_list->FormKeyCountName) && ($AWali_list->isGridAdd() || $AWali_list->isGridEdit() || $AWali->isConfirm())) {
		$AWali_list->KeyCount = $CurrentForm->getValue($AWali_list->FormKeyCountName);
		$AWali_list->StopRecord = $AWali_list->StartRecord + $AWali_list->KeyCount - 1;
	}
}
$AWali_list->RecordCount = $AWali_list->StartRecord - 1;
if ($AWali_list->Recordset && !$AWali_list->Recordset->EOF) {
	$AWali_list->Recordset->moveFirst();
	$selectLimit = $AWali_list->UseSelectLimit;
	if (!$selectLimit && $AWali_list->StartRecord > 1)
		$AWali_list->Recordset->move($AWali_list->StartRecord - 1);
} elseif (!$AWali->AllowAddDeleteRow && $AWali_list->StopRecord == 0) {
	$AWali_list->StopRecord = $AWali->GridAddRowCount;
}

// Initialize aggregate
$AWali->RowType = ROWTYPE_AGGREGATEINIT;
$AWali->resetAttributes();
$AWali_list->renderRow();
$AWali_list->EditRowCount = 0;
if ($AWali_list->isEdit())
	$AWali_list->RowIndex = 1;
while ($AWali_list->RecordCount < $AWali_list->StopRecord) {
	$AWali_list->RecordCount++;
	if ($AWali_list->RecordCount >= $AWali_list->StartRecord) {
		$AWali_list->RowCount++;

		// Set up key count
		$AWali_list->KeyCount = $AWali_list->RowIndex;

		// Init row class and style
		$AWali->resetAttributes();
		$AWali->CssClass = "";
		if ($AWali_list->isGridAdd()) {
			$AWali_list->loadRowValues(); // Load default values
		} else {
			$AWali_list->loadRowValues($AWali_list->Recordset); // Load row values
		}
		$AWali->RowType = ROWTYPE_VIEW; // Render view
		if ($AWali_list->isEdit()) {
			if ($AWali_list->checkInlineEditKey() && $AWali_list->EditRowCount == 0) { // Inline edit
				$AWali->RowType = ROWTYPE_EDIT; // Render edit
			}
		}
		if ($AWali_list->isEdit() && $AWali->RowType == ROWTYPE_EDIT && $AWali->EventCancelled) { // Update failed
			$CurrentForm->Index = 1;
			$AWali_list->restoreFormValues(); // Restore form values
		}
		if ($AWali->RowType == ROWTYPE_EDIT) // Edit row
			$AWali_list->EditRowCount++;

		// Set up row id / data-rowindex
		$AWali->RowAttrs->merge(["data-rowindex" => $AWali_list->RowCount, "id" => "r" . $AWali_list->RowCount . "_AWali", "data-rowtype" => $AWali->RowType]);

		// Render row
		$AWali_list->renderRow();

		// Render list options
		$AWali_list->renderListOptions();
?>
	<tr <?php echo $AWali->rowAttributes() ?>>
<?php

// Render list options (body, left)
$AWali_list->ListOptions->render("body", "left", $AWali_list->RowCount);
?>
	<?php if ($AWali_list->Th_Ak->Visible) { // Th_Ak ?>
		<td data-name="Th_Ak" <?php echo $AWali_list->Th_Ak->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Th_Ak" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="AWali" data-field="x_Th_Ak" data-value-separator="<?php echo $AWali_list->Th_Ak->displayValueSeparatorAttribute() ?>" id="x<?php echo $AWali_list->RowIndex ?>_Th_Ak" name="x<?php echo $AWali_list->RowIndex ?>_Th_Ak"<?php echo $AWali_list->Th_Ak->editAttributes() ?>>
			<?php echo $AWali_list->Th_Ak->selectOptionListHtml("x{$AWali_list->RowIndex}_Th_Ak") ?>
		</select>
</div>
<?php echo $AWali_list->Th_Ak->Lookup->getParamTag($AWali_list, "p_x" . $AWali_list->RowIndex . "_Th_Ak") ?>
</span>
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Th_Ak">
<span<?php echo $AWali_list->Th_Ak->viewAttributes() ?>><?php echo $AWali_list->Th_Ak->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($AWali_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $AWali_list->Periode->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Periode" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="AWali" data-field="x_Periode" data-value-separator="<?php echo $AWali_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $AWali_list->RowIndex ?>_Periode" name="x<?php echo $AWali_list->RowIndex ?>_Periode"<?php echo $AWali_list->Periode->editAttributes() ?>>
			<?php echo $AWali_list->Periode->selectOptionListHtml("x{$AWali_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Periode">
<span<?php echo $AWali_list->Periode->viewAttributes() ?>><?php echo $AWali_list->Periode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($AWali_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $AWali_list->Kode_Fak->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="AWali" data-field="x_Kode_Fak" data-value-separator="<?php echo $AWali_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x<?php echo $AWali_list->RowIndex ?>_Kode_Fak" name="x<?php echo $AWali_list->RowIndex ?>_Kode_Fak"<?php echo $AWali_list->Kode_Fak->editAttributes() ?>>
			<?php echo $AWali_list->Kode_Fak->selectOptionListHtml("x{$AWali_list->RowIndex}_Kode_Fak") ?>
		</select>
</div>
<?php echo $AWali_list->Kode_Fak->Lookup->getParamTag($AWali_list, "p_x" . $AWali_list->RowIndex . "_Kode_Fak") ?>
<input type="hidden" data-table="AWali" data-field="x_Kode_Fak" name="o<?php echo $AWali_list->RowIndex ?>_Kode_Fak" id="o<?php echo $AWali_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($AWali_list->Kode_Fak->OldValue != null ? $AWali_list->Kode_Fak->OldValue : $AWali_list->Kode_Fak->CurrentValue) ?>">
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Kode_Fak">
<span<?php echo $AWali_list->Kode_Fak->viewAttributes() ?>><?php echo $AWali_list->Kode_Fak->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($AWali_list->Kelas->Visible) { // Kelas ?>
		<td data-name="Kelas" <?php echo $AWali_list->Kelas->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="AWali" data-field="x_Kelas" data-value-separator="<?php echo $AWali_list->Kelas->displayValueSeparatorAttribute() ?>" id="x<?php echo $AWali_list->RowIndex ?>_Kelas" name="x<?php echo $AWali_list->RowIndex ?>_Kelas"<?php echo $AWali_list->Kelas->editAttributes() ?>>
			<?php echo $AWali_list->Kelas->selectOptionListHtml("x{$AWali_list->RowIndex}_Kelas") ?>
		</select>
</div>
<?php echo $AWali_list->Kelas->Lookup->getParamTag($AWali_list, "p_x" . $AWali_list->RowIndex . "_Kelas") ?>
<input type="hidden" data-table="AWali" data-field="x_Kelas" name="o<?php echo $AWali_list->RowIndex ?>_Kelas" id="o<?php echo $AWali_list->RowIndex ?>_Kelas" value="<?php echo HtmlEncode($AWali_list->Kelas->OldValue != null ? $AWali_list->Kelas->OldValue : $AWali_list->Kelas->CurrentValue) ?>">
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Kelas">
<span<?php echo $AWali_list->Kelas->viewAttributes() ?>><?php echo $AWali_list->Kelas->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($AWali_list->Semester->Visible) { // Semester ?>
		<td data-name="Semester" <?php echo $AWali_list->Semester->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Semester" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="AWali" data-field="x_Semester" data-value-separator="<?php echo $AWali_list->Semester->displayValueSeparatorAttribute() ?>" id="x<?php echo $AWali_list->RowIndex ?>_Semester" name="x<?php echo $AWali_list->RowIndex ?>_Semester"<?php echo $AWali_list->Semester->editAttributes() ?>>
			<?php echo $AWali_list->Semester->selectOptionListHtml("x{$AWali_list->RowIndex}_Semester") ?>
		</select>
</div>
</span>
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Semester">
<span<?php echo $AWali_list->Semester->viewAttributes() ?>><?php echo $AWali_list->Semester->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($AWali_list->Awal_Perwalian->Visible) { // Awal_Perwalian ?>
		<td data-name="Awal_Perwalian" <?php echo $AWali_list->Awal_Perwalian->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Awal_Perwalian" class="form-group">
<input type="text" data-table="AWali" data-field="x_Awal_Perwalian" data-format="7" name="x<?php echo $AWali_list->RowIndex ?>_Awal_Perwalian" id="x<?php echo $AWali_list->RowIndex ?>_Awal_Perwalian" maxlength="8" placeholder="<?php echo HtmlEncode($AWali_list->Awal_Perwalian->getPlaceHolder()) ?>" value="<?php echo $AWali_list->Awal_Perwalian->EditValue ?>"<?php echo $AWali_list->Awal_Perwalian->editAttributes() ?>>
<?php if (!$AWali_list->Awal_Perwalian->ReadOnly && !$AWali_list->Awal_Perwalian->Disabled && !isset($AWali_list->Awal_Perwalian->EditAttrs["readonly"]) && !isset($AWali_list->Awal_Perwalian->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fAWalilist", "datetimepicker"], function() {
	ew.createDateTimePicker("fAWalilist", "x<?php echo $AWali_list->RowIndex ?>_Awal_Perwalian", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Awal_Perwalian">
<span<?php echo $AWali_list->Awal_Perwalian->viewAttributes() ?>><?php echo $AWali_list->Awal_Perwalian->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($AWali_list->Akhir_Perwalian->Visible) { // Akhir_Perwalian ?>
		<td data-name="Akhir_Perwalian" <?php echo $AWali_list->Akhir_Perwalian->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Akhir_Perwalian" class="form-group">
<input type="text" data-table="AWali" data-field="x_Akhir_Perwalian" data-format="7" name="x<?php echo $AWali_list->RowIndex ?>_Akhir_Perwalian" id="x<?php echo $AWali_list->RowIndex ?>_Akhir_Perwalian" maxlength="8" placeholder="<?php echo HtmlEncode($AWali_list->Akhir_Perwalian->getPlaceHolder()) ?>" value="<?php echo $AWali_list->Akhir_Perwalian->EditValue ?>"<?php echo $AWali_list->Akhir_Perwalian->editAttributes() ?>>
<?php if (!$AWali_list->Akhir_Perwalian->ReadOnly && !$AWali_list->Akhir_Perwalian->Disabled && !isset($AWali_list->Akhir_Perwalian->EditAttrs["readonly"]) && !isset($AWali_list->Akhir_Perwalian->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fAWalilist", "datetimepicker"], function() {
	ew.createDateTimePicker("fAWalilist", "x<?php echo $AWali_list->RowIndex ?>_Akhir_Perwalian", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Akhir_Perwalian">
<span<?php echo $AWali_list->Akhir_Perwalian->viewAttributes() ?>><?php echo $AWali_list->Akhir_Perwalian->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($AWali_list->Awal_Perubahan->Visible) { // Awal_Perubahan ?>
		<td data-name="Awal_Perubahan" <?php echo $AWali_list->Awal_Perubahan->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Awal_Perubahan" class="form-group">
<input type="text" data-table="AWali" data-field="x_Awal_Perubahan" data-format="7" name="x<?php echo $AWali_list->RowIndex ?>_Awal_Perubahan" id="x<?php echo $AWali_list->RowIndex ?>_Awal_Perubahan" maxlength="8" placeholder="<?php echo HtmlEncode($AWali_list->Awal_Perubahan->getPlaceHolder()) ?>" value="<?php echo $AWali_list->Awal_Perubahan->EditValue ?>"<?php echo $AWali_list->Awal_Perubahan->editAttributes() ?>>
<?php if (!$AWali_list->Awal_Perubahan->ReadOnly && !$AWali_list->Awal_Perubahan->Disabled && !isset($AWali_list->Awal_Perubahan->EditAttrs["readonly"]) && !isset($AWali_list->Awal_Perubahan->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fAWalilist", "datetimepicker"], function() {
	ew.createDateTimePicker("fAWalilist", "x<?php echo $AWali_list->RowIndex ?>_Awal_Perubahan", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Awal_Perubahan">
<span<?php echo $AWali_list->Awal_Perubahan->viewAttributes() ?>><?php echo $AWali_list->Awal_Perubahan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($AWali_list->Akhir_Perubahan->Visible) { // Akhir_Perubahan ?>
		<td data-name="Akhir_Perubahan" <?php echo $AWali_list->Akhir_Perubahan->cellAttributes() ?>>
<?php if ($AWali->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Akhir_Perubahan" class="form-group">
<input type="text" data-table="AWali" data-field="x_Akhir_Perubahan" data-format="7" name="x<?php echo $AWali_list->RowIndex ?>_Akhir_Perubahan" id="x<?php echo $AWali_list->RowIndex ?>_Akhir_Perubahan" maxlength="8" placeholder="<?php echo HtmlEncode($AWali_list->Akhir_Perubahan->getPlaceHolder()) ?>" value="<?php echo $AWali_list->Akhir_Perubahan->EditValue ?>"<?php echo $AWali_list->Akhir_Perubahan->editAttributes() ?>>
<?php if (!$AWali_list->Akhir_Perubahan->ReadOnly && !$AWali_list->Akhir_Perubahan->Disabled && !isset($AWali_list->Akhir_Perubahan->EditAttrs["readonly"]) && !isset($AWali_list->Akhir_Perubahan->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fAWalilist", "datetimepicker"], function() {
	ew.createDateTimePicker("fAWalilist", "x<?php echo $AWali_list->RowIndex ?>_Akhir_Perubahan", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($AWali->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $AWali_list->RowCount ?>_AWali_Akhir_Perubahan">
<span<?php echo $AWali_list->Akhir_Perubahan->viewAttributes() ?>><?php echo $AWali_list->Akhir_Perubahan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$AWali_list->ListOptions->render("body", "right", $AWali_list->RowCount);
?>
	</tr>
<?php if ($AWali->RowType == ROWTYPE_ADD || $AWali->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fAWalilist", "load"], function() {
	fAWalilist.updateLists(<?php echo $AWali_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	if (!$AWali_list->isGridAdd())
		$AWali_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($AWali_list->isEdit()) { ?>
<input type="hidden" name="<?php echo $AWali_list->FormKeyCountName ?>" id="<?php echo $AWali_list->FormKeyCountName ?>" value="<?php echo $AWali_list->KeyCount ?>">
<?php } ?>
<?php if (!$AWali->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($AWali_list->Recordset)
	$AWali_list->Recordset->Close();
?>
<?php if (!$AWali_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$AWali_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $AWali_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $AWali_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($AWali_list->TotalRecords == 0 && !$AWali->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $AWali_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$AWali_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$AWali_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$AWali_list->terminate();
?>