<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$AuditTrail_list = new AuditTrail_list();

// Run the page
$AuditTrail_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$AuditTrail_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$AuditTrail_list->isExport()) { ?>
<script>
var fAuditTraillist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fAuditTraillist = currentForm = new ew.Form("fAuditTraillist", "list");
	fAuditTraillist.formKeyCountName = '<?php echo $AuditTrail_list->FormKeyCountName ?>';
	loadjs.done("fAuditTraillist");
});
var fAuditTraillistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fAuditTraillistsrch = currentSearchForm = new ew.Form("fAuditTraillistsrch");

	// Dynamic selection lists
	// Filters

	fAuditTraillistsrch.filterList = <?php echo $AuditTrail_list->getFilterList() ?>;
	loadjs.done("fAuditTraillistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$AuditTrail_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($AuditTrail_list->TotalRecords > 0 && $AuditTrail_list->ExportOptions->visible()) { ?>
<?php $AuditTrail_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($AuditTrail_list->ImportOptions->visible()) { ?>
<?php $AuditTrail_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($AuditTrail_list->SearchOptions->visible()) { ?>
<?php $AuditTrail_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($AuditTrail_list->FilterOptions->visible()) { ?>
<?php $AuditTrail_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$AuditTrail_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$AuditTrail_list->isExport() && !$AuditTrail->CurrentAction) { ?>
<form name="fAuditTraillistsrch" id="fAuditTraillistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fAuditTraillistsrch-search-panel" class="<?php echo $AuditTrail_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="AuditTrail">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $AuditTrail_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($AuditTrail_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($AuditTrail_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $AuditTrail_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($AuditTrail_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($AuditTrail_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($AuditTrail_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($AuditTrail_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $AuditTrail_list->showPageHeader(); ?>
<?php
$AuditTrail_list->showMessage();
?>
<?php if ($AuditTrail_list->TotalRecords > 0 || $AuditTrail->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($AuditTrail_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> AuditTrail">
<form name="fAuditTraillist" id="fAuditTraillist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="AuditTrail">
<div id="gmp_AuditTrail" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($AuditTrail_list->TotalRecords > 0 || $AuditTrail_list->isGridEdit()) { ?>
<table id="tbl_AuditTraillist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$AuditTrail->RowType = ROWTYPE_HEADER;

// Render list options
$AuditTrail_list->renderListOptions();

// Render list options (header, left)
$AuditTrail_list->ListOptions->render("header", "left");
?>
<?php if ($AuditTrail_list->Id->Visible) { // Id ?>
	<?php if ($AuditTrail_list->SortUrl($AuditTrail_list->Id) == "") { ?>
		<th data-name="Id" class="<?php echo $AuditTrail_list->Id->headerCellClass() ?>"><div id="elh_AuditTrail_Id" class="AuditTrail_Id"><div class="ew-table-header-caption"><?php echo $AuditTrail_list->Id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Id" class="<?php echo $AuditTrail_list->Id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AuditTrail_list->SortUrl($AuditTrail_list->Id) ?>', 1);"><div id="elh_AuditTrail_Id" class="AuditTrail_Id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AuditTrail_list->Id->caption() ?></span><span class="ew-table-header-sort"><?php if ($AuditTrail_list->Id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AuditTrail_list->Id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AuditTrail_list->DateTime->Visible) { // DateTime ?>
	<?php if ($AuditTrail_list->SortUrl($AuditTrail_list->DateTime) == "") { ?>
		<th data-name="DateTime" class="<?php echo $AuditTrail_list->DateTime->headerCellClass() ?>"><div id="elh_AuditTrail_DateTime" class="AuditTrail_DateTime"><div class="ew-table-header-caption"><?php echo $AuditTrail_list->DateTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DateTime" class="<?php echo $AuditTrail_list->DateTime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AuditTrail_list->SortUrl($AuditTrail_list->DateTime) ?>', 1);"><div id="elh_AuditTrail_DateTime" class="AuditTrail_DateTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AuditTrail_list->DateTime->caption() ?></span><span class="ew-table-header-sort"><?php if ($AuditTrail_list->DateTime->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AuditTrail_list->DateTime->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AuditTrail_list->Script->Visible) { // Script ?>
	<?php if ($AuditTrail_list->SortUrl($AuditTrail_list->Script) == "") { ?>
		<th data-name="Script" class="<?php echo $AuditTrail_list->Script->headerCellClass() ?>"><div id="elh_AuditTrail_Script" class="AuditTrail_Script"><div class="ew-table-header-caption"><?php echo $AuditTrail_list->Script->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Script" class="<?php echo $AuditTrail_list->Script->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AuditTrail_list->SortUrl($AuditTrail_list->Script) ?>', 1);"><div id="elh_AuditTrail_Script" class="AuditTrail_Script">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AuditTrail_list->Script->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($AuditTrail_list->Script->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AuditTrail_list->Script->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AuditTrail_list->User->Visible) { // User ?>
	<?php if ($AuditTrail_list->SortUrl($AuditTrail_list->User) == "") { ?>
		<th data-name="User" class="<?php echo $AuditTrail_list->User->headerCellClass() ?>"><div id="elh_AuditTrail_User" class="AuditTrail_User"><div class="ew-table-header-caption"><?php echo $AuditTrail_list->User->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="User" class="<?php echo $AuditTrail_list->User->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AuditTrail_list->SortUrl($AuditTrail_list->User) ?>', 1);"><div id="elh_AuditTrail_User" class="AuditTrail_User">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AuditTrail_list->User->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($AuditTrail_list->User->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AuditTrail_list->User->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AuditTrail_list->_Action->Visible) { // Action ?>
	<?php if ($AuditTrail_list->SortUrl($AuditTrail_list->_Action) == "") { ?>
		<th data-name="_Action" class="<?php echo $AuditTrail_list->_Action->headerCellClass() ?>"><div id="elh_AuditTrail__Action" class="AuditTrail__Action"><div class="ew-table-header-caption"><?php echo $AuditTrail_list->_Action->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Action" class="<?php echo $AuditTrail_list->_Action->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AuditTrail_list->SortUrl($AuditTrail_list->_Action) ?>', 1);"><div id="elh_AuditTrail__Action" class="AuditTrail__Action">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AuditTrail_list->_Action->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($AuditTrail_list->_Action->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AuditTrail_list->_Action->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AuditTrail_list->_Table->Visible) { // Table ?>
	<?php if ($AuditTrail_list->SortUrl($AuditTrail_list->_Table) == "") { ?>
		<th data-name="_Table" class="<?php echo $AuditTrail_list->_Table->headerCellClass() ?>"><div id="elh_AuditTrail__Table" class="AuditTrail__Table"><div class="ew-table-header-caption"><?php echo $AuditTrail_list->_Table->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Table" class="<?php echo $AuditTrail_list->_Table->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AuditTrail_list->SortUrl($AuditTrail_list->_Table) ?>', 1);"><div id="elh_AuditTrail__Table" class="AuditTrail__Table">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AuditTrail_list->_Table->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($AuditTrail_list->_Table->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AuditTrail_list->_Table->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($AuditTrail_list->Field->Visible) { // Field ?>
	<?php if ($AuditTrail_list->SortUrl($AuditTrail_list->Field) == "") { ?>
		<th data-name="Field" class="<?php echo $AuditTrail_list->Field->headerCellClass() ?>"><div id="elh_AuditTrail_Field" class="AuditTrail_Field"><div class="ew-table-header-caption"><?php echo $AuditTrail_list->Field->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Field" class="<?php echo $AuditTrail_list->Field->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $AuditTrail_list->SortUrl($AuditTrail_list->Field) ?>', 1);"><div id="elh_AuditTrail_Field" class="AuditTrail_Field">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $AuditTrail_list->Field->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($AuditTrail_list->Field->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($AuditTrail_list->Field->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$AuditTrail_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($AuditTrail_list->ExportAll && $AuditTrail_list->isExport()) {
	$AuditTrail_list->StopRecord = $AuditTrail_list->TotalRecords;
} else {

	// Set the last record to display
	if ($AuditTrail_list->TotalRecords > $AuditTrail_list->StartRecord + $AuditTrail_list->DisplayRecords - 1)
		$AuditTrail_list->StopRecord = $AuditTrail_list->StartRecord + $AuditTrail_list->DisplayRecords - 1;
	else
		$AuditTrail_list->StopRecord = $AuditTrail_list->TotalRecords;
}
$AuditTrail_list->RecordCount = $AuditTrail_list->StartRecord - 1;
if ($AuditTrail_list->Recordset && !$AuditTrail_list->Recordset->EOF) {
	$AuditTrail_list->Recordset->moveFirst();
	$selectLimit = $AuditTrail_list->UseSelectLimit;
	if (!$selectLimit && $AuditTrail_list->StartRecord > 1)
		$AuditTrail_list->Recordset->move($AuditTrail_list->StartRecord - 1);
} elseif (!$AuditTrail->AllowAddDeleteRow && $AuditTrail_list->StopRecord == 0) {
	$AuditTrail_list->StopRecord = $AuditTrail->GridAddRowCount;
}

// Initialize aggregate
$AuditTrail->RowType = ROWTYPE_AGGREGATEINIT;
$AuditTrail->resetAttributes();
$AuditTrail_list->renderRow();
while ($AuditTrail_list->RecordCount < $AuditTrail_list->StopRecord) {
	$AuditTrail_list->RecordCount++;
	if ($AuditTrail_list->RecordCount >= $AuditTrail_list->StartRecord) {
		$AuditTrail_list->RowCount++;

		// Set up key count
		$AuditTrail_list->KeyCount = $AuditTrail_list->RowIndex;

		// Init row class and style
		$AuditTrail->resetAttributes();
		$AuditTrail->CssClass = "";
		if ($AuditTrail_list->isGridAdd()) {
		} else {
			$AuditTrail_list->loadRowValues($AuditTrail_list->Recordset); // Load row values
		}
		$AuditTrail->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$AuditTrail->RowAttrs->merge(["data-rowindex" => $AuditTrail_list->RowCount, "id" => "r" . $AuditTrail_list->RowCount . "_AuditTrail", "data-rowtype" => $AuditTrail->RowType]);

		// Render row
		$AuditTrail_list->renderRow();

		// Render list options
		$AuditTrail_list->renderListOptions();
?>
	<tr <?php echo $AuditTrail->rowAttributes() ?>>
<?php

// Render list options (body, left)
$AuditTrail_list->ListOptions->render("body", "left", $AuditTrail_list->RowCount);
?>
	<?php if ($AuditTrail_list->Id->Visible) { // Id ?>
		<td data-name="Id" <?php echo $AuditTrail_list->Id->cellAttributes() ?>>
<span id="el<?php echo $AuditTrail_list->RowCount ?>_AuditTrail_Id">
<span<?php echo $AuditTrail_list->Id->viewAttributes() ?>><?php echo $AuditTrail_list->Id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($AuditTrail_list->DateTime->Visible) { // DateTime ?>
		<td data-name="DateTime" <?php echo $AuditTrail_list->DateTime->cellAttributes() ?>>
<span id="el<?php echo $AuditTrail_list->RowCount ?>_AuditTrail_DateTime">
<span<?php echo $AuditTrail_list->DateTime->viewAttributes() ?>><?php echo $AuditTrail_list->DateTime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($AuditTrail_list->Script->Visible) { // Script ?>
		<td data-name="Script" <?php echo $AuditTrail_list->Script->cellAttributes() ?>>
<span id="el<?php echo $AuditTrail_list->RowCount ?>_AuditTrail_Script">
<span<?php echo $AuditTrail_list->Script->viewAttributes() ?>><?php echo $AuditTrail_list->Script->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($AuditTrail_list->User->Visible) { // User ?>
		<td data-name="User" <?php echo $AuditTrail_list->User->cellAttributes() ?>>
<span id="el<?php echo $AuditTrail_list->RowCount ?>_AuditTrail_User">
<span<?php echo $AuditTrail_list->User->viewAttributes() ?>><?php echo $AuditTrail_list->User->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($AuditTrail_list->_Action->Visible) { // Action ?>
		<td data-name="_Action" <?php echo $AuditTrail_list->_Action->cellAttributes() ?>>
<span id="el<?php echo $AuditTrail_list->RowCount ?>_AuditTrail__Action">
<span<?php echo $AuditTrail_list->_Action->viewAttributes() ?>><?php echo $AuditTrail_list->_Action->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($AuditTrail_list->_Table->Visible) { // Table ?>
		<td data-name="_Table" <?php echo $AuditTrail_list->_Table->cellAttributes() ?>>
<span id="el<?php echo $AuditTrail_list->RowCount ?>_AuditTrail__Table">
<span<?php echo $AuditTrail_list->_Table->viewAttributes() ?>><?php echo $AuditTrail_list->_Table->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($AuditTrail_list->Field->Visible) { // Field ?>
		<td data-name="Field" <?php echo $AuditTrail_list->Field->cellAttributes() ?>>
<span id="el<?php echo $AuditTrail_list->RowCount ?>_AuditTrail_Field">
<span<?php echo $AuditTrail_list->Field->viewAttributes() ?>><?php echo $AuditTrail_list->Field->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$AuditTrail_list->ListOptions->render("body", "right", $AuditTrail_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$AuditTrail_list->isGridAdd())
		$AuditTrail_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$AuditTrail->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($AuditTrail_list->Recordset)
	$AuditTrail_list->Recordset->Close();
?>
<?php if (!$AuditTrail_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$AuditTrail_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $AuditTrail_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $AuditTrail_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($AuditTrail_list->TotalRecords == 0 && !$AuditTrail->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $AuditTrail_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$AuditTrail_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$AuditTrail_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$AuditTrail_list->terminate();
?>