<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$AuditTrail_view = new AuditTrail_view();

// Run the page
$AuditTrail_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$AuditTrail_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$AuditTrail_view->isExport()) { ?>
<script>
var fAuditTrailview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fAuditTrailview = currentForm = new ew.Form("fAuditTrailview", "view");
	loadjs.done("fAuditTrailview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$AuditTrail_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $AuditTrail_view->ExportOptions->render("body") ?>
<?php $AuditTrail_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $AuditTrail_view->showPageHeader(); ?>
<?php
$AuditTrail_view->showMessage();
?>
<form name="fAuditTrailview" id="fAuditTrailview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="AuditTrail">
<input type="hidden" name="modal" value="<?php echo (int)$AuditTrail_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($AuditTrail_view->Id->Visible) { // Id ?>
	<tr id="r_Id">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail_Id"><?php echo $AuditTrail_view->Id->caption() ?></span></td>
		<td data-name="Id" <?php echo $AuditTrail_view->Id->cellAttributes() ?>>
<span id="el_AuditTrail_Id">
<span<?php echo $AuditTrail_view->Id->viewAttributes() ?>><?php echo $AuditTrail_view->Id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->DateTime->Visible) { // DateTime ?>
	<tr id="r_DateTime">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail_DateTime"><?php echo $AuditTrail_view->DateTime->caption() ?></span></td>
		<td data-name="DateTime" <?php echo $AuditTrail_view->DateTime->cellAttributes() ?>>
<span id="el_AuditTrail_DateTime">
<span<?php echo $AuditTrail_view->DateTime->viewAttributes() ?>><?php echo $AuditTrail_view->DateTime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->Script->Visible) { // Script ?>
	<tr id="r_Script">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail_Script"><?php echo $AuditTrail_view->Script->caption() ?></span></td>
		<td data-name="Script" <?php echo $AuditTrail_view->Script->cellAttributes() ?>>
<span id="el_AuditTrail_Script">
<span<?php echo $AuditTrail_view->Script->viewAttributes() ?>><?php echo $AuditTrail_view->Script->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->User->Visible) { // User ?>
	<tr id="r_User">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail_User"><?php echo $AuditTrail_view->User->caption() ?></span></td>
		<td data-name="User" <?php echo $AuditTrail_view->User->cellAttributes() ?>>
<span id="el_AuditTrail_User">
<span<?php echo $AuditTrail_view->User->viewAttributes() ?>><?php echo $AuditTrail_view->User->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->_Action->Visible) { // Action ?>
	<tr id="r__Action">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail__Action"><?php echo $AuditTrail_view->_Action->caption() ?></span></td>
		<td data-name="_Action" <?php echo $AuditTrail_view->_Action->cellAttributes() ?>>
<span id="el_AuditTrail__Action">
<span<?php echo $AuditTrail_view->_Action->viewAttributes() ?>><?php echo $AuditTrail_view->_Action->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->_Table->Visible) { // Table ?>
	<tr id="r__Table">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail__Table"><?php echo $AuditTrail_view->_Table->caption() ?></span></td>
		<td data-name="_Table" <?php echo $AuditTrail_view->_Table->cellAttributes() ?>>
<span id="el_AuditTrail__Table">
<span<?php echo $AuditTrail_view->_Table->viewAttributes() ?>><?php echo $AuditTrail_view->_Table->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->Field->Visible) { // Field ?>
	<tr id="r_Field">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail_Field"><?php echo $AuditTrail_view->Field->caption() ?></span></td>
		<td data-name="Field" <?php echo $AuditTrail_view->Field->cellAttributes() ?>>
<span id="el_AuditTrail_Field">
<span<?php echo $AuditTrail_view->Field->viewAttributes() ?>><?php echo $AuditTrail_view->Field->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->KeyValue->Visible) { // KeyValue ?>
	<tr id="r_KeyValue">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail_KeyValue"><?php echo $AuditTrail_view->KeyValue->caption() ?></span></td>
		<td data-name="KeyValue" <?php echo $AuditTrail_view->KeyValue->cellAttributes() ?>>
<span id="el_AuditTrail_KeyValue">
<span<?php echo $AuditTrail_view->KeyValue->viewAttributes() ?>><?php echo $AuditTrail_view->KeyValue->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->OldValue->Visible) { // OldValue ?>
	<tr id="r_OldValue">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail_OldValue"><?php echo $AuditTrail_view->OldValue->caption() ?></span></td>
		<td data-name="OldValue" <?php echo $AuditTrail_view->OldValue->cellAttributes() ?>>
<span id="el_AuditTrail_OldValue">
<span<?php echo $AuditTrail_view->OldValue->viewAttributes() ?>><?php echo $AuditTrail_view->OldValue->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($AuditTrail_view->NewValue->Visible) { // NewValue ?>
	<tr id="r_NewValue">
		<td class="<?php echo $AuditTrail_view->TableLeftColumnClass ?>"><span id="elh_AuditTrail_NewValue"><?php echo $AuditTrail_view->NewValue->caption() ?></span></td>
		<td data-name="NewValue" <?php echo $AuditTrail_view->NewValue->cellAttributes() ?>>
<span id="el_AuditTrail_NewValue">
<span<?php echo $AuditTrail_view->NewValue->viewAttributes() ?>><?php echo $AuditTrail_view->NewValue->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$AuditTrail_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$AuditTrail_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$AuditTrail_view->terminate();
?>