<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$HtblNilai_list = new HtblNilai_list();

// Run the page
$HtblNilai_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$HtblNilai_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$HtblNilai_list->isExport()) { ?>
<script>
var fHtblNilailist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fHtblNilailist = currentForm = new ew.Form("fHtblNilailist", "list");
	fHtblNilailist.formKeyCountName = '<?php echo $HtblNilai_list->FormKeyCountName ?>';
	loadjs.done("fHtblNilailist");
});
var fHtblNilailistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fHtblNilailistsrch = currentSearchForm = new ew.Form("fHtblNilailistsrch");

	// Validate function for search
	fHtblNilailistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";
		elm = this.getElements("x" + infix + "_Kehadiran");
		if (elm && !ew.checkNumber(elm.value))
			return this.onError(elm, "<?php echo JsEncode($HtblNilai_list->Kehadiran->errorMessage()) ?>");

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fHtblNilailistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fHtblNilailistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fHtblNilailistsrch.lists["x_Nim"] = <?php echo $HtblNilai_list->Nim->Lookup->toClientList($HtblNilai_list) ?>;
	fHtblNilailistsrch.lists["x_Nim"].options = <?php echo JsonEncode($HtblNilai_list->Nim->lookupOptions()) ?>;

	// Filters
	fHtblNilailistsrch.filterList = <?php echo $HtblNilai_list->getFilterList() ?>;
	loadjs.done("fHtblNilailistsrch");
});
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script>
loadjs.ready("head", function() {
	ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
	ew.PREVIEW_SINGLE_ROW = false;
	ew.PREVIEW_OVERLAY = false;
	loadjs("js/ewpreview.js", "preview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$HtblNilai_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($HtblNilai_list->TotalRecords > 0 && $HtblNilai_list->ExportOptions->visible()) { ?>
<?php $HtblNilai_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($HtblNilai_list->ImportOptions->visible()) { ?>
<?php $HtblNilai_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($HtblNilai_list->SearchOptions->visible()) { ?>
<?php $HtblNilai_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($HtblNilai_list->FilterOptions->visible()) { ?>
<?php $HtblNilai_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$HtblNilai_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$HtblNilai_list->isExport() && !$HtblNilai->CurrentAction) { ?>
<form name="fHtblNilailistsrch" id="fHtblNilailistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fHtblNilailistsrch-search-panel" class="<?php echo $HtblNilai_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="HtblNilai">
	<div class="ew-extended-search">
<?php

// Render search row
$HtblNilai->RowType = ROWTYPE_SEARCH;
$HtblNilai->resetAttributes();
$HtblNilai_list->renderRow();
?>
<?php if ($HtblNilai_list->Nim->Visible) { // Nim ?>
	<?php
		$HtblNilai_list->SearchColumnCount++;
		if (($HtblNilai_list->SearchColumnCount - 1) % $HtblNilai_list->SearchFieldsPerRow == 0) {
			$HtblNilai_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $HtblNilai_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Nim" class="ew-cell form-group">
		<label for="x_Nim" class="ew-search-caption ew-label"><?php echo $HtblNilai_list->Nim->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Nim" id="z_Nim" value="LIKE">
</span>
		<span id="el_HtblNilai_Nim" class="ew-search-field">
<input type="text" data-table="HtblNilai" data-field="x_Nim" name="x_Nim" id="x_Nim" size="30" placeholder="<?php echo HtmlEncode($HtblNilai_list->Nim->getPlaceHolder()) ?>" value="<?php echo $HtblNilai_list->Nim->EditValue ?>"<?php echo $HtblNilai_list->Nim->editAttributes() ?>>
<?php echo $HtblNilai_list->Nim->Lookup->getParamTag($HtblNilai_list, "p_x_Nim") ?>
</span>
	</div>
	<?php if ($HtblNilai_list->SearchColumnCount % $HtblNilai_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$HtblNilai_list->SearchColumnCount++;
		if (($HtblNilai_list->SearchColumnCount - 1) % $HtblNilai_list->SearchFieldsPerRow == 0) {
			$HtblNilai_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $HtblNilai_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $HtblNilai_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_HtblNilai_Thn_Akademik" class="ew-search-field">
<input type="text" data-table="HtblNilai" data-field="x_Thn_Akademik" name="x_Thn_Akademik" id="x_Thn_Akademik" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($HtblNilai_list->Thn_Akademik->getPlaceHolder()) ?>" value="<?php echo $HtblNilai_list->Thn_Akademik->EditValue ?>"<?php echo $HtblNilai_list->Thn_Akademik->editAttributes() ?>>
</span>
	</div>
	<?php if ($HtblNilai_list->SearchColumnCount % $HtblNilai_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Periode->Visible) { // Periode ?>
	<?php
		$HtblNilai_list->SearchColumnCount++;
		if (($HtblNilai_list->SearchColumnCount - 1) % $HtblNilai_list->SearchFieldsPerRow == 0) {
			$HtblNilai_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $HtblNilai_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $HtblNilai_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_HtblNilai_Periode" class="ew-search-field">
<input type="text" data-table="HtblNilai" data-field="x_Periode" name="x_Periode" id="x_Periode" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($HtblNilai_list->Periode->getPlaceHolder()) ?>" value="<?php echo $HtblNilai_list->Periode->EditValue ?>"<?php echo $HtblNilai_list->Periode->editAttributes() ?>>
</span>
	</div>
	<?php if ($HtblNilai_list->SearchColumnCount % $HtblNilai_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Kehadiran->Visible) { // Kehadiran ?>
	<?php
		$HtblNilai_list->SearchColumnCount++;
		if (($HtblNilai_list->SearchColumnCount - 1) % $HtblNilai_list->SearchFieldsPerRow == 0) {
			$HtblNilai_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $HtblNilai_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kehadiran" class="ew-cell form-group">
		<label for="x_Kehadiran" class="ew-search-caption ew-label"><?php echo $HtblNilai_list->Kehadiran->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("BETWEEN") ?>
<input type="hidden" name="z_Kehadiran" id="z_Kehadiran" value="BETWEEN">
</span>
		<span id="el_HtblNilai_Kehadiran" class="ew-search-field">
<input type="text" data-table="HtblNilai" data-field="x_Kehadiran" name="x_Kehadiran" id="x_Kehadiran" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($HtblNilai_list->Kehadiran->getPlaceHolder()) ?>" value="<?php echo $HtblNilai_list->Kehadiran->EditValue ?>"<?php echo $HtblNilai_list->Kehadiran->editAttributes() ?>>
</span>
		<span class="ew-search-and"><label><?php echo $Language->phrase("AND") ?></label></span>
		<span id="el2_HtblNilai_Kehadiran" class="ew-search-field2">
<input type="text" data-table="HtblNilai" data-field="x_Kehadiran" name="y_Kehadiran" id="y_Kehadiran" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($HtblNilai_list->Kehadiran->getPlaceHolder()) ?>" value="<?php echo $HtblNilai_list->Kehadiran->EditValue2 ?>"<?php echo $HtblNilai_list->Kehadiran->editAttributes() ?>>
</span>
	</div>
	<?php if ($HtblNilai_list->SearchColumnCount % $HtblNilai_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($HtblNilai_list->SearchColumnCount % $HtblNilai_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $HtblNilai_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($HtblNilai_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($HtblNilai_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $HtblNilai_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($HtblNilai_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($HtblNilai_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($HtblNilai_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($HtblNilai_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $HtblNilai_list->showPageHeader(); ?>
<?php
$HtblNilai_list->showMessage();
?>
<?php if ($HtblNilai_list->TotalRecords > 0 || $HtblNilai->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($HtblNilai_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> HtblNilai">
<form name="fHtblNilailist" id="fHtblNilailist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="HtblNilai">
<div id="gmp_HtblNilai" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($HtblNilai_list->TotalRecords > 0 || $HtblNilai_list->isGridEdit()) { ?>
<table id="tbl_HtblNilailist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$HtblNilai->RowType = ROWTYPE_HEADER;

// Render list options
$HtblNilai_list->renderListOptions();

// Render list options (header, left)
$HtblNilai_list->ListOptions->render("header", "left");
?>
<?php if ($HtblNilai_list->Nim->Visible) { // Nim ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $HtblNilai_list->Nim->headerCellClass() ?>"><div id="elh_HtblNilai_Nim" class="HtblNilai_Nim"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $HtblNilai_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Nim) ?>', 1);"><div id="elh_HtblNilai_Nim" class="HtblNilai_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Nim->caption() ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->KelasAkd->Visible) { // KelasAkd ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->KelasAkd) == "") { ?>
		<th data-name="KelasAkd" class="<?php echo $HtblNilai_list->KelasAkd->headerCellClass() ?>"><div id="elh_HtblNilai_KelasAkd" class="HtblNilai_KelasAkd"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->KelasAkd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KelasAkd" class="<?php echo $HtblNilai_list->KelasAkd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->KelasAkd) ?>', 1);"><div id="elh_HtblNilai_KelasAkd" class="HtblNilai_KelasAkd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->KelasAkd->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->KelasAkd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->KelasAkd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $HtblNilai_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_HtblNilai_Thn_Akademik" class="HtblNilai_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $HtblNilai_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Thn_Akademik) ?>', 1);"><div id="elh_HtblNilai_Thn_Akademik" class="HtblNilai_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Thn_Akademik->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Periode->Visible) { // Periode ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $HtblNilai_list->Periode->headerCellClass() ?>"><div id="elh_HtblNilai_Periode" class="HtblNilai_Periode"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $HtblNilai_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Periode) ?>', 1);"><div id="elh_HtblNilai_Periode" class="HtblNilai_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Periode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Kode_MK->Visible) { // Kode_MK ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Kode_MK) == "") { ?>
		<th data-name="Kode_MK" class="<?php echo $HtblNilai_list->Kode_MK->headerCellClass() ?>"><div id="elh_HtblNilai_Kode_MK" class="HtblNilai_Kode_MK"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Kode_MK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_MK" class="<?php echo $HtblNilai_list->Kode_MK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Kode_MK) ?>', 1);"><div id="elh_HtblNilai_Kode_MK" class="HtblNilai_Kode_MK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Kode_MK->caption() ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Kode_MK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Kode_MK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->kls->Visible) { // kls ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->kls) == "") { ?>
		<th data-name="kls" class="<?php echo $HtblNilai_list->kls->headerCellClass() ?>"><div id="elh_HtblNilai_kls" class="HtblNilai_kls"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->kls->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kls" class="<?php echo $HtblNilai_list->kls->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->kls) ?>', 1);"><div id="elh_HtblNilai_kls" class="HtblNilai_kls">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->kls->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->kls->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->kls->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Kehadiran->Visible) { // Kehadiran ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Kehadiran) == "") { ?>
		<th data-name="Kehadiran" class="<?php echo $HtblNilai_list->Kehadiran->headerCellClass() ?>"><div id="elh_HtblNilai_Kehadiran" class="HtblNilai_Kehadiran"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Kehadiran->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kehadiran" class="<?php echo $HtblNilai_list->Kehadiran->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Kehadiran) ?>', 1);"><div id="elh_HtblNilai_Kehadiran" class="HtblNilai_Kehadiran">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Kehadiran->caption() ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Kehadiran->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Kehadiran->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Tugas->Visible) { // Tugas ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Tugas) == "") { ?>
		<th data-name="Tugas" class="<?php echo $HtblNilai_list->Tugas->headerCellClass() ?>"><div id="elh_HtblNilai_Tugas" class="HtblNilai_Tugas"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Tugas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tugas" class="<?php echo $HtblNilai_list->Tugas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Tugas) ?>', 1);"><div id="elh_HtblNilai_Tugas" class="HtblNilai_Tugas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Tugas->caption() ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Tugas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Tugas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->UTS->Visible) { // UTS ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->UTS) == "") { ?>
		<th data-name="UTS" class="<?php echo $HtblNilai_list->UTS->headerCellClass() ?>"><div id="elh_HtblNilai_UTS" class="HtblNilai_UTS"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->UTS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UTS" class="<?php echo $HtblNilai_list->UTS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->UTS) ?>', 1);"><div id="elh_HtblNilai_UTS" class="HtblNilai_UTS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->UTS->caption() ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->UTS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->UTS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->UAS->Visible) { // UAS ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->UAS) == "") { ?>
		<th data-name="UAS" class="<?php echo $HtblNilai_list->UAS->headerCellClass() ?>"><div id="elh_HtblNilai_UAS" class="HtblNilai_UAS"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->UAS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UAS" class="<?php echo $HtblNilai_list->UAS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->UAS) ?>', 1);"><div id="elh_HtblNilai_UAS" class="HtblNilai_UAS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->UAS->caption() ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->UAS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->UAS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Jumlah->Visible) { // Jumlah ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Jumlah) == "") { ?>
		<th data-name="Jumlah" class="<?php echo $HtblNilai_list->Jumlah->headerCellClass() ?>"><div id="elh_HtblNilai_Jumlah" class="HtblNilai_Jumlah"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Jumlah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jumlah" class="<?php echo $HtblNilai_list->Jumlah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Jumlah) ?>', 1);"><div id="elh_HtblNilai_Jumlah" class="HtblNilai_Jumlah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Jumlah->caption() ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Jumlah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Jumlah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Nilai->Visible) { // Nilai ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Nilai) == "") { ?>
		<th data-name="Nilai" class="<?php echo $HtblNilai_list->Nilai->headerCellClass() ?>"><div id="elh_HtblNilai_Nilai" class="HtblNilai_Nilai"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Nilai->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nilai" class="<?php echo $HtblNilai_list->Nilai->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Nilai) ?>', 1);"><div id="elh_HtblNilai_Nilai" class="HtblNilai_Nilai">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Nilai->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Nilai->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Nilai->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($HtblNilai_list->Angka->Visible) { // Angka ?>
	<?php if ($HtblNilai_list->SortUrl($HtblNilai_list->Angka) == "") { ?>
		<th data-name="Angka" class="<?php echo $HtblNilai_list->Angka->headerCellClass() ?>"><div id="elh_HtblNilai_Angka" class="HtblNilai_Angka"><div class="ew-table-header-caption"><?php echo $HtblNilai_list->Angka->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Angka" class="<?php echo $HtblNilai_list->Angka->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $HtblNilai_list->SortUrl($HtblNilai_list->Angka) ?>', 1);"><div id="elh_HtblNilai_Angka" class="HtblNilai_Angka">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $HtblNilai_list->Angka->caption() ?></span><span class="ew-table-header-sort"><?php if ($HtblNilai_list->Angka->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($HtblNilai_list->Angka->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$HtblNilai_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($HtblNilai_list->ExportAll && $HtblNilai_list->isExport()) {
	$HtblNilai_list->StopRecord = $HtblNilai_list->TotalRecords;
} else {

	// Set the last record to display
	if ($HtblNilai_list->TotalRecords > $HtblNilai_list->StartRecord + $HtblNilai_list->DisplayRecords - 1)
		$HtblNilai_list->StopRecord = $HtblNilai_list->StartRecord + $HtblNilai_list->DisplayRecords - 1;
	else
		$HtblNilai_list->StopRecord = $HtblNilai_list->TotalRecords;
}
$HtblNilai_list->RecordCount = $HtblNilai_list->StartRecord - 1;
if ($HtblNilai_list->Recordset && !$HtblNilai_list->Recordset->EOF) {
	$HtblNilai_list->Recordset->moveFirst();
	$selectLimit = $HtblNilai_list->UseSelectLimit;
	if (!$selectLimit && $HtblNilai_list->StartRecord > 1)
		$HtblNilai_list->Recordset->move($HtblNilai_list->StartRecord - 1);
} elseif (!$HtblNilai->AllowAddDeleteRow && $HtblNilai_list->StopRecord == 0) {
	$HtblNilai_list->StopRecord = $HtblNilai->GridAddRowCount;
}

// Initialize aggregate
$HtblNilai->RowType = ROWTYPE_AGGREGATEINIT;
$HtblNilai->resetAttributes();
$HtblNilai_list->renderRow();
while ($HtblNilai_list->RecordCount < $HtblNilai_list->StopRecord) {
	$HtblNilai_list->RecordCount++;
	if ($HtblNilai_list->RecordCount >= $HtblNilai_list->StartRecord) {
		$HtblNilai_list->RowCount++;

		// Set up key count
		$HtblNilai_list->KeyCount = $HtblNilai_list->RowIndex;

		// Init row class and style
		$HtblNilai->resetAttributes();
		$HtblNilai->CssClass = "";
		if ($HtblNilai_list->isGridAdd()) {
		} else {
			$HtblNilai_list->loadRowValues($HtblNilai_list->Recordset); // Load row values
		}
		$HtblNilai->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$HtblNilai->RowAttrs->merge(["data-rowindex" => $HtblNilai_list->RowCount, "id" => "r" . $HtblNilai_list->RowCount . "_HtblNilai", "data-rowtype" => $HtblNilai->RowType]);

		// Render row
		$HtblNilai_list->renderRow();

		// Render list options
		$HtblNilai_list->renderListOptions();
?>
	<tr <?php echo $HtblNilai->rowAttributes() ?>>
<?php

// Render list options (body, left)
$HtblNilai_list->ListOptions->render("body", "left", $HtblNilai_list->RowCount);
?>
	<?php if ($HtblNilai_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $HtblNilai_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Nim">
<span<?php echo $HtblNilai_list->Nim->viewAttributes() ?>><?php echo $HtblNilai_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->KelasAkd->Visible) { // KelasAkd ?>
		<td data-name="KelasAkd" <?php echo $HtblNilai_list->KelasAkd->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_KelasAkd">
<span<?php echo $HtblNilai_list->KelasAkd->viewAttributes() ?>><?php echo $HtblNilai_list->KelasAkd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $HtblNilai_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Thn_Akademik">
<span<?php echo $HtblNilai_list->Thn_Akademik->viewAttributes() ?>><?php echo $HtblNilai_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $HtblNilai_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Periode">
<span<?php echo $HtblNilai_list->Periode->viewAttributes() ?>><?php echo $HtblNilai_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK" <?php echo $HtblNilai_list->Kode_MK->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Kode_MK">
<span<?php echo $HtblNilai_list->Kode_MK->viewAttributes() ?>><?php echo $HtblNilai_list->Kode_MK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->kls->Visible) { // kls ?>
		<td data-name="kls" <?php echo $HtblNilai_list->kls->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_kls">
<span<?php echo $HtblNilai_list->kls->viewAttributes() ?>><?php echo $HtblNilai_list->kls->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->Kehadiran->Visible) { // Kehadiran ?>
		<td data-name="Kehadiran" <?php echo $HtblNilai_list->Kehadiran->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Kehadiran">
<span<?php echo $HtblNilai_list->Kehadiran->viewAttributes() ?>><?php echo $HtblNilai_list->Kehadiran->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->Tugas->Visible) { // Tugas ?>
		<td data-name="Tugas" <?php echo $HtblNilai_list->Tugas->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Tugas">
<span<?php echo $HtblNilai_list->Tugas->viewAttributes() ?>><?php echo $HtblNilai_list->Tugas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->UTS->Visible) { // UTS ?>
		<td data-name="UTS" <?php echo $HtblNilai_list->UTS->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_UTS">
<span<?php echo $HtblNilai_list->UTS->viewAttributes() ?>><?php echo $HtblNilai_list->UTS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->UAS->Visible) { // UAS ?>
		<td data-name="UAS" <?php echo $HtblNilai_list->UAS->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_UAS">
<span<?php echo $HtblNilai_list->UAS->viewAttributes() ?>><?php echo $HtblNilai_list->UAS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->Jumlah->Visible) { // Jumlah ?>
		<td data-name="Jumlah" <?php echo $HtblNilai_list->Jumlah->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Jumlah">
<span<?php echo $HtblNilai_list->Jumlah->viewAttributes() ?>><?php echo $HtblNilai_list->Jumlah->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->Nilai->Visible) { // Nilai ?>
		<td data-name="Nilai" <?php echo $HtblNilai_list->Nilai->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Nilai">
<span<?php echo $HtblNilai_list->Nilai->viewAttributes() ?>><?php echo $HtblNilai_list->Nilai->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($HtblNilai_list->Angka->Visible) { // Angka ?>
		<td data-name="Angka" <?php echo $HtblNilai_list->Angka->cellAttributes() ?>>
<span id="el<?php echo $HtblNilai_list->RowCount ?>_HtblNilai_Angka">
<span<?php echo $HtblNilai_list->Angka->viewAttributes() ?>><?php echo $HtblNilai_list->Angka->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$HtblNilai_list->ListOptions->render("body", "right", $HtblNilai_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$HtblNilai_list->isGridAdd())
		$HtblNilai_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$HtblNilai->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($HtblNilai_list->Recordset)
	$HtblNilai_list->Recordset->Close();
?>
<?php if (!$HtblNilai_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$HtblNilai_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $HtblNilai_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $HtblNilai_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($HtblNilai_list->TotalRecords == 0 && !$HtblNilai->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $HtblNilai_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$HtblNilai_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$HtblNilai_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$HtblNilai_list->terminate();
?>