<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$IM_KeadiranKurang_list = new IM_KeadiranKurang_list();

// Run the page
$IM_KeadiranKurang_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$IM_KeadiranKurang_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$IM_KeadiranKurang_list->isExport()) { ?>
<script>
var fIM_KeadiranKuranglist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fIM_KeadiranKuranglist = currentForm = new ew.Form("fIM_KeadiranKuranglist", "list");
	fIM_KeadiranKuranglist.formKeyCountName = '<?php echo $IM_KeadiranKurang_list->FormKeyCountName ?>';
	loadjs.done("fIM_KeadiranKuranglist");
});
var fIM_KeadiranKuranglistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fIM_KeadiranKuranglistsrch = currentSearchForm = new ew.Form("fIM_KeadiranKuranglistsrch");

	// Validate function for search
	fIM_KeadiranKuranglistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";
		elm = this.getElements("x" + infix + "_Kehadiran");
		if (elm && !ew.checkNumber(elm.value))
			return this.onError(elm, "<?php echo JsEncode($IM_KeadiranKurang_list->Kehadiran->errorMessage()) ?>");
		elm = this.getElements("x" + infix + "_Angka");
		if (elm && !ew.checkNumber(elm.value))
			return this.onError(elm, "<?php echo JsEncode($IM_KeadiranKurang_list->Angka->errorMessage()) ?>");

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fIM_KeadiranKuranglistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fIM_KeadiranKuranglistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fIM_KeadiranKuranglistsrch.lists["x_Kode_jp"] = <?php echo $IM_KeadiranKurang_list->Kode_jp->Lookup->toClientList($IM_KeadiranKurang_list) ?>;
	fIM_KeadiranKuranglistsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($IM_KeadiranKurang_list->Kode_jp->lookupOptions()) ?>;
	fIM_KeadiranKuranglistsrch.lists["x_Thn_Akademik"] = <?php echo $IM_KeadiranKurang_list->Thn_Akademik->Lookup->toClientList($IM_KeadiranKurang_list) ?>;
	fIM_KeadiranKuranglistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($IM_KeadiranKurang_list->Thn_Akademik->lookupOptions()) ?>;
	fIM_KeadiranKuranglistsrch.lists["x_Periode"] = <?php echo $IM_KeadiranKurang_list->Periode->Lookup->toClientList($IM_KeadiranKurang_list) ?>;
	fIM_KeadiranKuranglistsrch.lists["x_Periode"].options = <?php echo JsonEncode($IM_KeadiranKurang_list->Periode->options(FALSE, TRUE)) ?>;

	// Filters
	fIM_KeadiranKuranglistsrch.filterList = <?php echo $IM_KeadiranKurang_list->getFilterList() ?>;
	loadjs.done("fIM_KeadiranKuranglistsrch");
});
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script>
loadjs.ready("head", function() {
	ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
	ew.PREVIEW_SINGLE_ROW = false;
	ew.PREVIEW_OVERLAY = false;
	loadjs("js/ewpreview.js", "preview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$IM_KeadiranKurang_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($IM_KeadiranKurang_list->TotalRecords > 0 && $IM_KeadiranKurang_list->ExportOptions->visible()) { ?>
<?php $IM_KeadiranKurang_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->ImportOptions->visible()) { ?>
<?php $IM_KeadiranKurang_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->SearchOptions->visible()) { ?>
<?php $IM_KeadiranKurang_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->FilterOptions->visible()) { ?>
<?php $IM_KeadiranKurang_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$IM_KeadiranKurang_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$IM_KeadiranKurang_list->isExport() && !$IM_KeadiranKurang->CurrentAction) { ?>
<form name="fIM_KeadiranKuranglistsrch" id="fIM_KeadiranKuranglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fIM_KeadiranKuranglistsrch-search-panel" class="<?php echo $IM_KeadiranKurang_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="IM_KeadiranKurang">
	<div class="ew-extended-search">
<?php

// Render search row
$IM_KeadiranKurang->RowType = ROWTYPE_SEARCH;
$IM_KeadiranKurang->resetAttributes();
$IM_KeadiranKurang_list->renderRow();
?>
<?php if ($IM_KeadiranKurang_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$IM_KeadiranKurang_list->SearchColumnCount++;
		if (($IM_KeadiranKurang_list->SearchColumnCount - 1) % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) {
			$IM_KeadiranKurang_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_KeadiranKurang_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $IM_KeadiranKurang_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_IM_KeadiranKurang_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_KeadiranKurang" data-field="x_Kode_jp" data-value-separator="<?php echo $IM_KeadiranKurang_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $IM_KeadiranKurang_list->Kode_jp->editAttributes() ?>>
			<?php echo $IM_KeadiranKurang_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $IM_KeadiranKurang_list->Kode_jp->Lookup->getParamTag($IM_KeadiranKurang_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($IM_KeadiranKurang_list->SearchColumnCount % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$IM_KeadiranKurang_list->SearchColumnCount++;
		if (($IM_KeadiranKurang_list->SearchColumnCount - 1) % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) {
			$IM_KeadiranKurang_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_KeadiranKurang_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $IM_KeadiranKurang_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_IM_KeadiranKurang_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_KeadiranKurang" data-field="x_Thn_Akademik" data-value-separator="<?php echo $IM_KeadiranKurang_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $IM_KeadiranKurang_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $IM_KeadiranKurang_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $IM_KeadiranKurang_list->Thn_Akademik->Lookup->getParamTag($IM_KeadiranKurang_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($IM_KeadiranKurang_list->SearchColumnCount % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Periode->Visible) { // Periode ?>
	<?php
		$IM_KeadiranKurang_list->SearchColumnCount++;
		if (($IM_KeadiranKurang_list->SearchColumnCount - 1) % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) {
			$IM_KeadiranKurang_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_KeadiranKurang_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $IM_KeadiranKurang_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_IM_KeadiranKurang_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_KeadiranKurang" data-field="x_Periode" data-value-separator="<?php echo $IM_KeadiranKurang_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $IM_KeadiranKurang_list->Periode->editAttributes() ?>>
			<?php echo $IM_KeadiranKurang_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($IM_KeadiranKurang_list->SearchColumnCount % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Kehadiran->Visible) { // Kehadiran ?>
	<?php
		$IM_KeadiranKurang_list->SearchColumnCount++;
		if (($IM_KeadiranKurang_list->SearchColumnCount - 1) % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) {
			$IM_KeadiranKurang_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_KeadiranKurang_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kehadiran" class="ew-cell form-group">
		<label for="x_Kehadiran" class="ew-search-caption ew-label"><?php echo $IM_KeadiranKurang_list->Kehadiran->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("<=") ?>
<input type="hidden" name="z_Kehadiran" id="z_Kehadiran" value="<=">
</span>
		<span id="el_IM_KeadiranKurang_Kehadiran" class="ew-search-field">
<input type="text" data-table="IM_KeadiranKurang" data-field="x_Kehadiran" name="x_Kehadiran" id="x_Kehadiran" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($IM_KeadiranKurang_list->Kehadiran->getPlaceHolder()) ?>" value="<?php echo $IM_KeadiranKurang_list->Kehadiran->EditValue ?>"<?php echo $IM_KeadiranKurang_list->Kehadiran->editAttributes() ?>>
</span>
	</div>
	<?php if ($IM_KeadiranKurang_list->SearchColumnCount % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Angka->Visible) { // Angka ?>
	<?php
		$IM_KeadiranKurang_list->SearchColumnCount++;
		if (($IM_KeadiranKurang_list->SearchColumnCount - 1) % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) {
			$IM_KeadiranKurang_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_KeadiranKurang_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Angka" class="ew-cell form-group">
		<label for="x_Angka" class="ew-search-caption ew-label"><?php echo $IM_KeadiranKurang_list->Angka->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase(">=") ?>
<input type="hidden" name="z_Angka" id="z_Angka" value=">=">
</span>
		<span id="el_IM_KeadiranKurang_Angka" class="ew-search-field">
<input type="text" data-table="IM_KeadiranKurang" data-field="x_Angka" name="x_Angka" id="x_Angka" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($IM_KeadiranKurang_list->Angka->getPlaceHolder()) ?>" value="<?php echo $IM_KeadiranKurang_list->Angka->EditValue ?>"<?php echo $IM_KeadiranKurang_list->Angka->editAttributes() ?>>
</span>
	</div>
	<?php if ($IM_KeadiranKurang_list->SearchColumnCount % $IM_KeadiranKurang_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($IM_KeadiranKurang_list->SearchColumnCount % $IM_KeadiranKurang_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $IM_KeadiranKurang_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($IM_KeadiranKurang_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($IM_KeadiranKurang_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $IM_KeadiranKurang_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($IM_KeadiranKurang_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($IM_KeadiranKurang_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($IM_KeadiranKurang_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($IM_KeadiranKurang_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $IM_KeadiranKurang_list->showPageHeader(); ?>
<?php
$IM_KeadiranKurang_list->showMessage();
?>
<?php if ($IM_KeadiranKurang_list->TotalRecords > 0 || $IM_KeadiranKurang->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($IM_KeadiranKurang_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> IM_KeadiranKurang">
<form name="fIM_KeadiranKuranglist" id="fIM_KeadiranKuranglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="IM_KeadiranKurang">
<div id="gmp_IM_KeadiranKurang" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($IM_KeadiranKurang_list->TotalRecords > 0 || $IM_KeadiranKurang_list->isGridEdit()) { ?>
<table id="tbl_IM_KeadiranKuranglist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$IM_KeadiranKurang->RowType = ROWTYPE_HEADER;

// Render list options
$IM_KeadiranKurang_list->renderListOptions();

// Render list options (header, left)
$IM_KeadiranKurang_list->ListOptions->render("header", "left");
?>
<?php if ($IM_KeadiranKurang_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $IM_KeadiranKurang_list->Kode_Fak->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Kode_Fak" class="IM_KeadiranKurang_Kode_Fak"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $IM_KeadiranKurang_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Kode_Fak) ?>', 1);"><div id="elh_IM_KeadiranKurang_Kode_Fak" class="IM_KeadiranKurang_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $IM_KeadiranKurang_list->Kode_jp->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Kode_jp" class="IM_KeadiranKurang_Kode_jp"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $IM_KeadiranKurang_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Kode_jp) ?>', 1);"><div id="elh_IM_KeadiranKurang_Kode_jp" class="IM_KeadiranKurang_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $IM_KeadiranKurang_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Thn_Akademik" class="IM_KeadiranKurang_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $IM_KeadiranKurang_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Thn_Akademik) ?>', 1);"><div id="elh_IM_KeadiranKurang_Thn_Akademik" class="IM_KeadiranKurang_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Periode->Visible) { // Periode ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $IM_KeadiranKurang_list->Periode->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Periode" class="IM_KeadiranKurang_Periode"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $IM_KeadiranKurang_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Periode) ?>', 1);"><div id="elh_IM_KeadiranKurang_Periode" class="IM_KeadiranKurang_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Nim->Visible) { // Nim ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $IM_KeadiranKurang_list->Nim->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Nim" class="IM_KeadiranKurang_Nim"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $IM_KeadiranKurang_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nim) ?>', 1);"><div id="elh_IM_KeadiranKurang_Nim" class="IM_KeadiranKurang_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IM_KeadiranKurang_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Nama_Mhs" class="IM_KeadiranKurang_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IM_KeadiranKurang_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nama_Mhs) ?>', 1);"><div id="elh_IM_KeadiranKurang_Nama_Mhs" class="IM_KeadiranKurang_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Kode_MK->Visible) { // Kode_MK ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Kode_MK) == "") { ?>
		<th data-name="Kode_MK" class="<?php echo $IM_KeadiranKurang_list->Kode_MK->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Kode_MK" class="IM_KeadiranKurang_Kode_MK"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Kode_MK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_MK" class="<?php echo $IM_KeadiranKurang_list->Kode_MK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Kode_MK) ?>', 1);"><div id="elh_IM_KeadiranKurang_Kode_MK" class="IM_KeadiranKurang_Kode_MK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Kode_MK->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Kode_MK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Kode_MK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nama_Mk_Ind) == "") { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $IM_KeadiranKurang_list->Nama_Mk_Ind->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Nama_Mk_Ind" class="IM_KeadiranKurang_Nama_Mk_Ind"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nama_Mk_Ind->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $IM_KeadiranKurang_list->Nama_Mk_Ind->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nama_Mk_Ind) ?>', 1);"><div id="elh_IM_KeadiranKurang_Nama_Mk_Ind" class="IM_KeadiranKurang_Nama_Mk_Ind">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nama_Mk_Ind->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Nama_Mk_Ind->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Nama_Mk_Ind->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->SKS->Visible) { // SKS ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->SKS) == "") { ?>
		<th data-name="SKS" class="<?php echo $IM_KeadiranKurang_list->SKS->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_SKS" class="IM_KeadiranKurang_SKS"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->SKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SKS" class="<?php echo $IM_KeadiranKurang_list->SKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->SKS) ?>', 1);"><div id="elh_IM_KeadiranKurang_SKS" class="IM_KeadiranKurang_SKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->SKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->SKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->SKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Kehadiran->Visible) { // Kehadiran ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Kehadiran) == "") { ?>
		<th data-name="Kehadiran" class="<?php echo $IM_KeadiranKurang_list->Kehadiran->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Kehadiran" class="IM_KeadiranKurang_Kehadiran"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Kehadiran->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kehadiran" class="<?php echo $IM_KeadiranKurang_list->Kehadiran->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Kehadiran) ?>', 1);"><div id="elh_IM_KeadiranKurang_Kehadiran" class="IM_KeadiranKurang_Kehadiran">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Kehadiran->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Kehadiran->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Kehadiran->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Tugas->Visible) { // Tugas ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Tugas) == "") { ?>
		<th data-name="Tugas" class="<?php echo $IM_KeadiranKurang_list->Tugas->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Tugas" class="IM_KeadiranKurang_Tugas"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Tugas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tugas" class="<?php echo $IM_KeadiranKurang_list->Tugas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Tugas) ?>', 1);"><div id="elh_IM_KeadiranKurang_Tugas" class="IM_KeadiranKurang_Tugas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Tugas->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Tugas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Tugas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->UTS->Visible) { // UTS ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->UTS) == "") { ?>
		<th data-name="UTS" class="<?php echo $IM_KeadiranKurang_list->UTS->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_UTS" class="IM_KeadiranKurang_UTS"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->UTS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UTS" class="<?php echo $IM_KeadiranKurang_list->UTS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->UTS) ?>', 1);"><div id="elh_IM_KeadiranKurang_UTS" class="IM_KeadiranKurang_UTS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->UTS->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->UTS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->UTS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->UAS->Visible) { // UAS ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->UAS) == "") { ?>
		<th data-name="UAS" class="<?php echo $IM_KeadiranKurang_list->UAS->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_UAS" class="IM_KeadiranKurang_UAS"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->UAS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UAS" class="<?php echo $IM_KeadiranKurang_list->UAS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->UAS) ?>', 1);"><div id="elh_IM_KeadiranKurang_UAS" class="IM_KeadiranKurang_UAS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->UAS->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->UAS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->UAS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Jumlah->Visible) { // Jumlah ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Jumlah) == "") { ?>
		<th data-name="Jumlah" class="<?php echo $IM_KeadiranKurang_list->Jumlah->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Jumlah" class="IM_KeadiranKurang_Jumlah"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Jumlah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jumlah" class="<?php echo $IM_KeadiranKurang_list->Jumlah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Jumlah) ?>', 1);"><div id="elh_IM_KeadiranKurang_Jumlah" class="IM_KeadiranKurang_Jumlah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Jumlah->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Jumlah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Jumlah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Nilai->Visible) { // Nilai ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nilai) == "") { ?>
		<th data-name="Nilai" class="<?php echo $IM_KeadiranKurang_list->Nilai->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Nilai" class="IM_KeadiranKurang_Nilai"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nilai->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nilai" class="<?php echo $IM_KeadiranKurang_list->Nilai->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nilai) ?>', 1);"><div id="elh_IM_KeadiranKurang_Nilai" class="IM_KeadiranKurang_Nilai">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nilai->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Nilai->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Nilai->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Angka->Visible) { // Angka ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Angka) == "") { ?>
		<th data-name="Angka" class="<?php echo $IM_KeadiranKurang_list->Angka->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Angka" class="IM_KeadiranKurang_Angka"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Angka->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Angka" class="<?php echo $IM_KeadiranKurang_list->Angka->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Angka) ?>', 1);"><div id="elh_IM_KeadiranKurang_Angka" class="IM_KeadiranKurang_Angka">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Angka->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Angka->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Angka->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Alamat->Visible) { // Alamat ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Alamat) == "") { ?>
		<th data-name="Alamat" class="<?php echo $IM_KeadiranKurang_list->Alamat->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Alamat" class="IM_KeadiranKurang_Alamat"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Alamat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Alamat" class="<?php echo $IM_KeadiranKurang_list->Alamat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Alamat) ?>', 1);"><div id="elh_IM_KeadiranKurang_Alamat" class="IM_KeadiranKurang_Alamat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Alamat->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Alamat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Alamat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Telepon->Visible) { // Telepon ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Telepon) == "") { ?>
		<th data-name="Telepon" class="<?php echo $IM_KeadiranKurang_list->Telepon->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Telepon" class="IM_KeadiranKurang_Telepon"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Telepon->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Telepon" class="<?php echo $IM_KeadiranKurang_list->Telepon->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Telepon) ?>', 1);"><div id="elh_IM_KeadiranKurang_Telepon" class="IM_KeadiranKurang_Telepon">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Telepon->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Telepon->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Telepon->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->_Email->Visible) { // Email ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->_Email) == "") { ?>
		<th data-name="_Email" class="<?php echo $IM_KeadiranKurang_list->_Email->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang__Email" class="IM_KeadiranKurang__Email"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->_Email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Email" class="<?php echo $IM_KeadiranKurang_list->_Email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->_Email) ?>', 1);"><div id="elh_IM_KeadiranKurang__Email" class="IM_KeadiranKurang__Email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->_Email->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->_Email->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->_Email->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->NIDN->Visible) { // NIDN ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $IM_KeadiranKurang_list->NIDN->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_NIDN" class="IM_KeadiranKurang_NIDN"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $IM_KeadiranKurang_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->NIDN) ?>', 1);"><div id="elh_IM_KeadiranKurang_NIDN" class="IM_KeadiranKurang_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_KeadiranKurang_list->Nama->Visible) { // Nama ?>
	<?php if ($IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nama) == "") { ?>
		<th data-name="Nama" class="<?php echo $IM_KeadiranKurang_list->Nama->headerCellClass() ?>"><div id="elh_IM_KeadiranKurang_Nama" class="IM_KeadiranKurang_Nama"><div class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nama->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama" class="<?php echo $IM_KeadiranKurang_list->Nama->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_KeadiranKurang_list->SortUrl($IM_KeadiranKurang_list->Nama) ?>', 1);"><div id="elh_IM_KeadiranKurang_Nama" class="IM_KeadiranKurang_Nama">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_KeadiranKurang_list->Nama->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_KeadiranKurang_list->Nama->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_KeadiranKurang_list->Nama->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$IM_KeadiranKurang_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($IM_KeadiranKurang_list->ExportAll && $IM_KeadiranKurang_list->isExport()) {
	$IM_KeadiranKurang_list->StopRecord = $IM_KeadiranKurang_list->TotalRecords;
} else {

	// Set the last record to display
	if ($IM_KeadiranKurang_list->TotalRecords > $IM_KeadiranKurang_list->StartRecord + $IM_KeadiranKurang_list->DisplayRecords - 1)
		$IM_KeadiranKurang_list->StopRecord = $IM_KeadiranKurang_list->StartRecord + $IM_KeadiranKurang_list->DisplayRecords - 1;
	else
		$IM_KeadiranKurang_list->StopRecord = $IM_KeadiranKurang_list->TotalRecords;
}
$IM_KeadiranKurang_list->RecordCount = $IM_KeadiranKurang_list->StartRecord - 1;
if ($IM_KeadiranKurang_list->Recordset && !$IM_KeadiranKurang_list->Recordset->EOF) {
	$IM_KeadiranKurang_list->Recordset->moveFirst();
	$selectLimit = $IM_KeadiranKurang_list->UseSelectLimit;
	if (!$selectLimit && $IM_KeadiranKurang_list->StartRecord > 1)
		$IM_KeadiranKurang_list->Recordset->move($IM_KeadiranKurang_list->StartRecord - 1);
} elseif (!$IM_KeadiranKurang->AllowAddDeleteRow && $IM_KeadiranKurang_list->StopRecord == 0) {
	$IM_KeadiranKurang_list->StopRecord = $IM_KeadiranKurang->GridAddRowCount;
}

// Initialize aggregate
$IM_KeadiranKurang->RowType = ROWTYPE_AGGREGATEINIT;
$IM_KeadiranKurang->resetAttributes();
$IM_KeadiranKurang_list->renderRow();
while ($IM_KeadiranKurang_list->RecordCount < $IM_KeadiranKurang_list->StopRecord) {
	$IM_KeadiranKurang_list->RecordCount++;
	if ($IM_KeadiranKurang_list->RecordCount >= $IM_KeadiranKurang_list->StartRecord) {
		$IM_KeadiranKurang_list->RowCount++;

		// Set up key count
		$IM_KeadiranKurang_list->KeyCount = $IM_KeadiranKurang_list->RowIndex;

		// Init row class and style
		$IM_KeadiranKurang->resetAttributes();
		$IM_KeadiranKurang->CssClass = "";
		if ($IM_KeadiranKurang_list->isGridAdd()) {
		} else {
			$IM_KeadiranKurang_list->loadRowValues($IM_KeadiranKurang_list->Recordset); // Load row values
		}
		$IM_KeadiranKurang->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$IM_KeadiranKurang->RowAttrs->merge(["data-rowindex" => $IM_KeadiranKurang_list->RowCount, "id" => "r" . $IM_KeadiranKurang_list->RowCount . "_IM_KeadiranKurang", "data-rowtype" => $IM_KeadiranKurang->RowType]);

		// Render row
		$IM_KeadiranKurang_list->renderRow();

		// Render list options
		$IM_KeadiranKurang_list->renderListOptions();
?>
	<tr <?php echo $IM_KeadiranKurang->rowAttributes() ?>>
<?php

// Render list options (body, left)
$IM_KeadiranKurang_list->ListOptions->render("body", "left", $IM_KeadiranKurang_list->RowCount);
?>
	<?php if ($IM_KeadiranKurang_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $IM_KeadiranKurang_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Kode_Fak">
<span<?php echo $IM_KeadiranKurang_list->Kode_Fak->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $IM_KeadiranKurang_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Kode_jp">
<span<?php echo $IM_KeadiranKurang_list->Kode_jp->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $IM_KeadiranKurang_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Thn_Akademik">
<span<?php echo $IM_KeadiranKurang_list->Thn_Akademik->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $IM_KeadiranKurang_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Periode">
<span<?php echo $IM_KeadiranKurang_list->Periode->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $IM_KeadiranKurang_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Nim">
<span<?php echo $IM_KeadiranKurang_list->Nim->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $IM_KeadiranKurang_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Nama_Mhs">
<span<?php echo $IM_KeadiranKurang_list->Nama_Mhs->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK" <?php echo $IM_KeadiranKurang_list->Kode_MK->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Kode_MK">
<span<?php echo $IM_KeadiranKurang_list->Kode_MK->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Kode_MK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
		<td data-name="Nama_Mk_Ind" <?php echo $IM_KeadiranKurang_list->Nama_Mk_Ind->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Nama_Mk_Ind">
<span<?php echo $IM_KeadiranKurang_list->Nama_Mk_Ind->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Nama_Mk_Ind->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS" <?php echo $IM_KeadiranKurang_list->SKS->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_SKS">
<span<?php echo $IM_KeadiranKurang_list->SKS->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->SKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Kehadiran->Visible) { // Kehadiran ?>
		<td data-name="Kehadiran" <?php echo $IM_KeadiranKurang_list->Kehadiran->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Kehadiran">
<span<?php echo $IM_KeadiranKurang_list->Kehadiran->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Kehadiran->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Tugas->Visible) { // Tugas ?>
		<td data-name="Tugas" <?php echo $IM_KeadiranKurang_list->Tugas->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Tugas">
<span<?php echo $IM_KeadiranKurang_list->Tugas->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Tugas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->UTS->Visible) { // UTS ?>
		<td data-name="UTS" <?php echo $IM_KeadiranKurang_list->UTS->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_UTS">
<span<?php echo $IM_KeadiranKurang_list->UTS->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->UTS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->UAS->Visible) { // UAS ?>
		<td data-name="UAS" <?php echo $IM_KeadiranKurang_list->UAS->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_UAS">
<span<?php echo $IM_KeadiranKurang_list->UAS->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->UAS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Jumlah->Visible) { // Jumlah ?>
		<td data-name="Jumlah" <?php echo $IM_KeadiranKurang_list->Jumlah->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Jumlah">
<span<?php echo $IM_KeadiranKurang_list->Jumlah->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Jumlah->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Nilai->Visible) { // Nilai ?>
		<td data-name="Nilai" <?php echo $IM_KeadiranKurang_list->Nilai->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Nilai">
<span<?php echo $IM_KeadiranKurang_list->Nilai->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Nilai->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Angka->Visible) { // Angka ?>
		<td data-name="Angka" <?php echo $IM_KeadiranKurang_list->Angka->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Angka">
<span<?php echo $IM_KeadiranKurang_list->Angka->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Angka->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Alamat->Visible) { // Alamat ?>
		<td data-name="Alamat" <?php echo $IM_KeadiranKurang_list->Alamat->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Alamat">
<span<?php echo $IM_KeadiranKurang_list->Alamat->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Alamat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Telepon->Visible) { // Telepon ?>
		<td data-name="Telepon" <?php echo $IM_KeadiranKurang_list->Telepon->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Telepon">
<span<?php echo $IM_KeadiranKurang_list->Telepon->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Telepon->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->_Email->Visible) { // Email ?>
		<td data-name="_Email" <?php echo $IM_KeadiranKurang_list->_Email->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang__Email">
<span<?php echo $IM_KeadiranKurang_list->_Email->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->_Email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $IM_KeadiranKurang_list->NIDN->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_NIDN">
<span<?php echo $IM_KeadiranKurang_list->NIDN->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->NIDN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_KeadiranKurang_list->Nama->Visible) { // Nama ?>
		<td data-name="Nama" <?php echo $IM_KeadiranKurang_list->Nama->cellAttributes() ?>>
<span id="el<?php echo $IM_KeadiranKurang_list->RowCount ?>_IM_KeadiranKurang_Nama">
<span<?php echo $IM_KeadiranKurang_list->Nama->viewAttributes() ?>><?php echo $IM_KeadiranKurang_list->Nama->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$IM_KeadiranKurang_list->ListOptions->render("body", "right", $IM_KeadiranKurang_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$IM_KeadiranKurang_list->isGridAdd())
		$IM_KeadiranKurang_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$IM_KeadiranKurang->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($IM_KeadiranKurang_list->Recordset)
	$IM_KeadiranKurang_list->Recordset->Close();
?>
<?php if (!$IM_KeadiranKurang_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$IM_KeadiranKurang_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $IM_KeadiranKurang_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $IM_KeadiranKurang_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($IM_KeadiranKurang_list->TotalRecords == 0 && !$IM_KeadiranKurang->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $IM_KeadiranKurang_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$IM_KeadiranKurang_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$IM_KeadiranKurang_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$IM_KeadiranKurang_list->terminate();
?>