<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$IM_Lulusan_list = new IM_Lulusan_list();

// Run the page
$IM_Lulusan_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$IM_Lulusan_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$IM_Lulusan_list->isExport()) { ?>
<script>
var fIM_Lulusanlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fIM_Lulusanlist = currentForm = new ew.Form("fIM_Lulusanlist", "list");
	fIM_Lulusanlist.formKeyCountName = '<?php echo $IM_Lulusan_list->FormKeyCountName ?>';
	loadjs.done("fIM_Lulusanlist");
});
var fIM_Lulusanlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fIM_Lulusanlistsrch = currentSearchForm = new ew.Form("fIM_Lulusanlistsrch");

	// Validate function for search
	fIM_Lulusanlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fIM_Lulusanlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fIM_Lulusanlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fIM_Lulusanlistsrch.lists["x_Kode_Fak"] = <?php echo $IM_Lulusan_list->Kode_Fak->Lookup->toClientList($IM_Lulusan_list) ?>;
	fIM_Lulusanlistsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($IM_Lulusan_list->Kode_Fak->lookupOptions()) ?>;
	fIM_Lulusanlistsrch.lists["x_Kode_jp"] = <?php echo $IM_Lulusan_list->Kode_jp->Lookup->toClientList($IM_Lulusan_list) ?>;
	fIM_Lulusanlistsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($IM_Lulusan_list->Kode_jp->lookupOptions()) ?>;
	fIM_Lulusanlistsrch.lists["x_TaMasuk"] = <?php echo $IM_Lulusan_list->TaMasuk->Lookup->toClientList($IM_Lulusan_list) ?>;
	fIM_Lulusanlistsrch.lists["x_TaMasuk"].options = <?php echo JsonEncode($IM_Lulusan_list->TaMasuk->lookupOptions()) ?>;
	fIM_Lulusanlistsrch.lists["x_PerMasuk"] = <?php echo $IM_Lulusan_list->PerMasuk->Lookup->toClientList($IM_Lulusan_list) ?>;
	fIM_Lulusanlistsrch.lists["x_PerMasuk"].options = <?php echo JsonEncode($IM_Lulusan_list->PerMasuk->options(FALSE, TRUE)) ?>;
	fIM_Lulusanlistsrch.lists["x_TA"] = <?php echo $IM_Lulusan_list->TA->Lookup->toClientList($IM_Lulusan_list) ?>;
	fIM_Lulusanlistsrch.lists["x_TA"].options = <?php echo JsonEncode($IM_Lulusan_list->TA->lookupOptions()) ?>;

	// Filters
	fIM_Lulusanlistsrch.filterList = <?php echo $IM_Lulusan_list->getFilterList() ?>;
	loadjs.done("fIM_Lulusanlistsrch");
});
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script>
loadjs.ready("head", function() {
	ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
	ew.PREVIEW_SINGLE_ROW = false;
	ew.PREVIEW_OVERLAY = false;
	loadjs("js/ewpreview.js", "preview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$IM_Lulusan_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($IM_Lulusan_list->TotalRecords > 0 && $IM_Lulusan_list->ExportOptions->visible()) { ?>
<?php $IM_Lulusan_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Lulusan_list->ImportOptions->visible()) { ?>
<?php $IM_Lulusan_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Lulusan_list->SearchOptions->visible()) { ?>
<?php $IM_Lulusan_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Lulusan_list->FilterOptions->visible()) { ?>
<?php $IM_Lulusan_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$IM_Lulusan_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$IM_Lulusan_list->isExport() && !$IM_Lulusan->CurrentAction) { ?>
<form name="fIM_Lulusanlistsrch" id="fIM_Lulusanlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fIM_Lulusanlistsrch-search-panel" class="<?php echo $IM_Lulusan_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="IM_Lulusan">
	<div class="ew-extended-search">
<?php

// Render search row
$IM_Lulusan->RowType = ROWTYPE_SEARCH;
$IM_Lulusan->resetAttributes();
$IM_Lulusan_list->renderRow();
?>
<?php if ($IM_Lulusan_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$IM_Lulusan_list->SearchColumnCount++;
		if (($IM_Lulusan_list->SearchColumnCount - 1) % $IM_Lulusan_list->SearchFieldsPerRow == 0) {
			$IM_Lulusan_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Lulusan_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $IM_Lulusan_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_IM_Lulusan_Kode_Fak" class="ew-search-field">
<input type="text" data-table="IM_Lulusan" data-field="x_Kode_Fak" name="x_Kode_Fak" id="x_Kode_Fak" size="30" placeholder="<?php echo HtmlEncode($IM_Lulusan_list->Kode_Fak->getPlaceHolder()) ?>" value="<?php echo $IM_Lulusan_list->Kode_Fak->EditValue ?>"<?php echo $IM_Lulusan_list->Kode_Fak->editAttributes() ?>>
<?php echo $IM_Lulusan_list->Kode_Fak->Lookup->getParamTag($IM_Lulusan_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($IM_Lulusan_list->SearchColumnCount % $IM_Lulusan_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$IM_Lulusan_list->SearchColumnCount++;
		if (($IM_Lulusan_list->SearchColumnCount - 1) % $IM_Lulusan_list->SearchFieldsPerRow == 0) {
			$IM_Lulusan_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Lulusan_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $IM_Lulusan_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_IM_Lulusan_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Lulusan" data-field="x_Kode_jp" data-value-separator="<?php echo $IM_Lulusan_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $IM_Lulusan_list->Kode_jp->editAttributes() ?>>
			<?php echo $IM_Lulusan_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $IM_Lulusan_list->Kode_jp->Lookup->getParamTag($IM_Lulusan_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($IM_Lulusan_list->SearchColumnCount % $IM_Lulusan_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php
		$IM_Lulusan_list->SearchColumnCount++;
		if (($IM_Lulusan_list->SearchColumnCount - 1) % $IM_Lulusan_list->SearchFieldsPerRow == 0) {
			$IM_Lulusan_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Lulusan_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_TaMasuk" class="ew-cell form-group">
		<label for="x_TaMasuk" class="ew-search-caption ew-label"><?php echo $IM_Lulusan_list->TaMasuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TaMasuk" id="z_TaMasuk" value="LIKE">
</span>
		<span id="el_IM_Lulusan_TaMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Lulusan" data-field="x_TaMasuk" data-value-separator="<?php echo $IM_Lulusan_list->TaMasuk->displayValueSeparatorAttribute() ?>" id="x_TaMasuk" name="x_TaMasuk"<?php echo $IM_Lulusan_list->TaMasuk->editAttributes() ?>>
			<?php echo $IM_Lulusan_list->TaMasuk->selectOptionListHtml("x_TaMasuk") ?>
		</select>
</div>
<?php echo $IM_Lulusan_list->TaMasuk->Lookup->getParamTag($IM_Lulusan_list, "p_x_TaMasuk") ?>
</span>
	</div>
	<?php if ($IM_Lulusan_list->SearchColumnCount % $IM_Lulusan_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php
		$IM_Lulusan_list->SearchColumnCount++;
		if (($IM_Lulusan_list->SearchColumnCount - 1) % $IM_Lulusan_list->SearchFieldsPerRow == 0) {
			$IM_Lulusan_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Lulusan_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_PerMasuk" class="ew-cell form-group">
		<label for="x_PerMasuk" class="ew-search-caption ew-label"><?php echo $IM_Lulusan_list->PerMasuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PerMasuk" id="z_PerMasuk" value="LIKE">
</span>
		<span id="el_IM_Lulusan_PerMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Lulusan" data-field="x_PerMasuk" data-value-separator="<?php echo $IM_Lulusan_list->PerMasuk->displayValueSeparatorAttribute() ?>" id="x_PerMasuk" name="x_PerMasuk"<?php echo $IM_Lulusan_list->PerMasuk->editAttributes() ?>>
			<?php echo $IM_Lulusan_list->PerMasuk->selectOptionListHtml("x_PerMasuk") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($IM_Lulusan_list->SearchColumnCount % $IM_Lulusan_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->TA->Visible) { // TA ?>
	<?php
		$IM_Lulusan_list->SearchColumnCount++;
		if (($IM_Lulusan_list->SearchColumnCount - 1) % $IM_Lulusan_list->SearchFieldsPerRow == 0) {
			$IM_Lulusan_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Lulusan_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_TA" class="ew-cell form-group">
		<label for="x_TA" class="ew-search-caption ew-label"><?php echo $IM_Lulusan_list->TA->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TA" id="z_TA" value="LIKE">
</span>
		<span id="el_IM_Lulusan_TA" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Lulusan" data-field="x_TA" data-value-separator="<?php echo $IM_Lulusan_list->TA->displayValueSeparatorAttribute() ?>" id="x_TA" name="x_TA"<?php echo $IM_Lulusan_list->TA->editAttributes() ?>>
			<?php echo $IM_Lulusan_list->TA->selectOptionListHtml("x_TA") ?>
		</select>
</div>
<?php echo $IM_Lulusan_list->TA->Lookup->getParamTag($IM_Lulusan_list, "p_x_TA") ?>
</span>
	</div>
	<?php if ($IM_Lulusan_list->SearchColumnCount % $IM_Lulusan_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($IM_Lulusan_list->SearchColumnCount % $IM_Lulusan_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $IM_Lulusan_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($IM_Lulusan_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($IM_Lulusan_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $IM_Lulusan_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($IM_Lulusan_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($IM_Lulusan_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($IM_Lulusan_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($IM_Lulusan_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $IM_Lulusan_list->showPageHeader(); ?>
<?php
$IM_Lulusan_list->showMessage();
?>
<?php if ($IM_Lulusan_list->TotalRecords > 0 || $IM_Lulusan->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($IM_Lulusan_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> IM_Lulusan">
<form name="fIM_Lulusanlist" id="fIM_Lulusanlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="IM_Lulusan">
<div id="gmp_IM_Lulusan" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($IM_Lulusan_list->TotalRecords > 0 || $IM_Lulusan_list->isGridEdit()) { ?>
<table id="tbl_IM_Lulusanlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$IM_Lulusan->RowType = ROWTYPE_HEADER;

// Render list options
$IM_Lulusan_list->renderListOptions();

// Render list options (header, left)
$IM_Lulusan_list->ListOptions->render("header", "left");
?>
<?php if ($IM_Lulusan_list->NIM->Visible) { // NIM ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->NIM) == "") { ?>
		<th data-name="NIM" class="<?php echo $IM_Lulusan_list->NIM->headerCellClass() ?>"><div id="elh_IM_Lulusan_NIM" class="IM_Lulusan_NIM"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->NIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIM" class="<?php echo $IM_Lulusan_list->NIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->NIM) ?>', 1);"><div id="elh_IM_Lulusan_NIM" class="IM_Lulusan_NIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->NIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->NIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->NIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IM_Lulusan_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_IM_Lulusan_Nama_Mhs" class="IM_Lulusan_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IM_Lulusan_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Nama_Mhs) ?>', 1);"><div id="elh_IM_Lulusan_Nama_Mhs" class="IM_Lulusan_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Tmp_Lahir->Visible) { // Tmp_Lahir ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Tmp_Lahir) == "") { ?>
		<th data-name="Tmp_Lahir" class="<?php echo $IM_Lulusan_list->Tmp_Lahir->headerCellClass() ?>"><div id="elh_IM_Lulusan_Tmp_Lahir" class="IM_Lulusan_Tmp_Lahir"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Tmp_Lahir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tmp_Lahir" class="<?php echo $IM_Lulusan_list->Tmp_Lahir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Tmp_Lahir) ?>', 1);"><div id="elh_IM_Lulusan_Tmp_Lahir" class="IM_Lulusan_Tmp_Lahir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Tmp_Lahir->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Tmp_Lahir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Tmp_Lahir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Tgl_Lahir->Visible) { // Tgl_Lahir ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Tgl_Lahir) == "") { ?>
		<th data-name="Tgl_Lahir" class="<?php echo $IM_Lulusan_list->Tgl_Lahir->headerCellClass() ?>"><div id="elh_IM_Lulusan_Tgl_Lahir" class="IM_Lulusan_Tgl_Lahir"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Tgl_Lahir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tgl_Lahir" class="<?php echo $IM_Lulusan_list->Tgl_Lahir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Tgl_Lahir) ?>', 1);"><div id="elh_IM_Lulusan_Tgl_Lahir" class="IM_Lulusan_Tgl_Lahir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Tgl_Lahir->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Tgl_Lahir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Tgl_Lahir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $IM_Lulusan_list->Kode_Fak->headerCellClass() ?>"><div id="elh_IM_Lulusan_Kode_Fak" class="IM_Lulusan_Kode_Fak"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $IM_Lulusan_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Kode_Fak) ?>', 1);"><div id="elh_IM_Lulusan_Kode_Fak" class="IM_Lulusan_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Alamat->Visible) { // Alamat ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Alamat) == "") { ?>
		<th data-name="Alamat" class="<?php echo $IM_Lulusan_list->Alamat->headerCellClass() ?>"><div id="elh_IM_Lulusan_Alamat" class="IM_Lulusan_Alamat"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Alamat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Alamat" class="<?php echo $IM_Lulusan_list->Alamat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Alamat) ?>', 1);"><div id="elh_IM_Lulusan_Alamat" class="IM_Lulusan_Alamat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Alamat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Alamat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Alamat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Telepon->Visible) { // Telepon ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Telepon) == "") { ?>
		<th data-name="Telepon" class="<?php echo $IM_Lulusan_list->Telepon->headerCellClass() ?>"><div id="elh_IM_Lulusan_Telepon" class="IM_Lulusan_Telepon"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Telepon->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Telepon" class="<?php echo $IM_Lulusan_list->Telepon->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Telepon) ?>', 1);"><div id="elh_IM_Lulusan_Telepon" class="IM_Lulusan_Telepon">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Telepon->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Telepon->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Telepon->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->_Email->Visible) { // Email ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->_Email) == "") { ?>
		<th data-name="_Email" class="<?php echo $IM_Lulusan_list->_Email->headerCellClass() ?>"><div id="elh_IM_Lulusan__Email" class="IM_Lulusan__Email"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->_Email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Email" class="<?php echo $IM_Lulusan_list->_Email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->_Email) ?>', 1);"><div id="elh_IM_Lulusan__Email" class="IM_Lulusan__Email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->_Email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->_Email->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->_Email->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $IM_Lulusan_list->Kode_jp->headerCellClass() ?>"><div id="elh_IM_Lulusan_Kode_jp" class="IM_Lulusan_Kode_jp"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $IM_Lulusan_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Kode_jp) ?>', 1);"><div id="elh_IM_Lulusan_Kode_jp" class="IM_Lulusan_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $IM_Lulusan_list->Status_Akd->headerCellClass() ?>"><div id="elh_IM_Lulusan_Status_Akd" class="IM_Lulusan_Status_Akd"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $IM_Lulusan_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Status_Akd) ?>', 1);"><div id="elh_IM_Lulusan_Status_Akd" class="IM_Lulusan_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Status_Akd->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->TaMasuk) == "") { ?>
		<th data-name="TaMasuk" class="<?php echo $IM_Lulusan_list->TaMasuk->headerCellClass() ?>"><div id="elh_IM_Lulusan_TaMasuk" class="IM_Lulusan_TaMasuk"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->TaMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TaMasuk" class="<?php echo $IM_Lulusan_list->TaMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->TaMasuk) ?>', 1);"><div id="elh_IM_Lulusan_TaMasuk" class="IM_Lulusan_TaMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->TaMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->TaMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->TaMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->PerMasuk) == "") { ?>
		<th data-name="PerMasuk" class="<?php echo $IM_Lulusan_list->PerMasuk->headerCellClass() ?>"><div id="elh_IM_Lulusan_PerMasuk" class="IM_Lulusan_PerMasuk"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->PerMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerMasuk" class="<?php echo $IM_Lulusan_list->PerMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->PerMasuk) ?>', 1);"><div id="elh_IM_Lulusan_PerMasuk" class="IM_Lulusan_PerMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->PerMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->PerMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->PerMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->tglmasuk->Visible) { // tglmasuk ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->tglmasuk) == "") { ?>
		<th data-name="tglmasuk" class="<?php echo $IM_Lulusan_list->tglmasuk->headerCellClass() ?>"><div id="elh_IM_Lulusan_tglmasuk" class="IM_Lulusan_tglmasuk"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->tglmasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tglmasuk" class="<?php echo $IM_Lulusan_list->tglmasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->tglmasuk) ?>', 1);"><div id="elh_IM_Lulusan_tglmasuk" class="IM_Lulusan_tglmasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->tglmasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->tglmasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->tglmasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Tgl_Lulus->Visible) { // Tgl_Lulus ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Tgl_Lulus) == "") { ?>
		<th data-name="Tgl_Lulus" class="<?php echo $IM_Lulusan_list->Tgl_Lulus->headerCellClass() ?>"><div id="elh_IM_Lulusan_Tgl_Lulus" class="IM_Lulusan_Tgl_Lulus"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Tgl_Lulus->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tgl_Lulus" class="<?php echo $IM_Lulusan_list->Tgl_Lulus->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Tgl_Lulus) ?>', 1);"><div id="elh_IM_Lulusan_Tgl_Lulus" class="IM_Lulusan_Tgl_Lulus">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Tgl_Lulus->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Tgl_Lulus->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Tgl_Lulus->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->No_Ijazah->Visible) { // No_Ijazah ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->No_Ijazah) == "") { ?>
		<th data-name="No_Ijazah" class="<?php echo $IM_Lulusan_list->No_Ijazah->headerCellClass() ?>"><div id="elh_IM_Lulusan_No_Ijazah" class="IM_Lulusan_No_Ijazah"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->No_Ijazah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="No_Ijazah" class="<?php echo $IM_Lulusan_list->No_Ijazah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->No_Ijazah) ?>', 1);"><div id="elh_IM_Lulusan_No_Ijazah" class="IM_Lulusan_No_Ijazah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->No_Ijazah->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->No_Ijazah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->No_Ijazah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->SK->Visible) { // SK ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->SK) == "") { ?>
		<th data-name="SK" class="<?php echo $IM_Lulusan_list->SK->headerCellClass() ?>"><div id="elh_IM_Lulusan_SK" class="IM_Lulusan_SK"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->SK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SK" class="<?php echo $IM_Lulusan_list->SK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->SK) ?>', 1);"><div id="elh_IM_Lulusan_SK" class="IM_Lulusan_SK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->SK->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->SK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->SK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->TA->Visible) { // TA ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->TA) == "") { ?>
		<th data-name="TA" class="<?php echo $IM_Lulusan_list->TA->headerCellClass() ?>"><div id="elh_IM_Lulusan_TA" class="IM_Lulusan_TA"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->TA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TA" class="<?php echo $IM_Lulusan_list->TA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->TA) ?>', 1);"><div id="elh_IM_Lulusan_TA" class="IM_Lulusan_TA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->TA->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->TA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->TA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->per->Visible) { // per ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->per) == "") { ?>
		<th data-name="per" class="<?php echo $IM_Lulusan_list->per->headerCellClass() ?>"><div id="elh_IM_Lulusan_per" class="IM_Lulusan_per"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->per->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="per" class="<?php echo $IM_Lulusan_list->per->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->per) ?>', 1);"><div id="elh_IM_Lulusan_per" class="IM_Lulusan_per">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->per->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->per->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->per->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Pwl->Visible) { // Pwl ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Pwl) == "") { ?>
		<th data-name="Pwl" class="<?php echo $IM_Lulusan_list->Pwl->headerCellClass() ?>"><div id="elh_IM_Lulusan_Pwl" class="IM_Lulusan_Pwl"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Pwl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Pwl" class="<?php echo $IM_Lulusan_list->Pwl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Pwl) ?>', 1);"><div id="elh_IM_Lulusan_Pwl" class="IM_Lulusan_Pwl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Pwl->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Pwl->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Pwl->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<th>Riwayat</th>
<?php if ($IM_Lulusan_list->Ijazah->Visible) { // Ijazah ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Ijazah) == "") { ?>
		<th data-name="Ijazah" class="<?php echo $IM_Lulusan_list->Ijazah->headerCellClass() ?>"><div id="elh_IM_Lulusan_Ijazah" class="IM_Lulusan_Ijazah"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Ijazah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ijazah" class="<?php echo $IM_Lulusan_list->Ijazah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Ijazah) ?>', 1);"><div id="elh_IM_Lulusan_Ijazah" class="IM_Lulusan_Ijazah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Ijazah->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Ijazah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Ijazah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Ktp->Visible) { // Ktp ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Ktp) == "") { ?>
		<th data-name="Ktp" class="<?php echo $IM_Lulusan_list->Ktp->headerCellClass() ?>"><div id="elh_IM_Lulusan_Ktp" class="IM_Lulusan_Ktp"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Ktp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ktp" class="<?php echo $IM_Lulusan_list->Ktp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Ktp) ?>', 1);"><div id="elh_IM_Lulusan_Ktp" class="IM_Lulusan_Ktp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Ktp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Ktp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Ktp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->KK->Visible) { // KK ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->KK) == "") { ?>
		<th data-name="KK" class="<?php echo $IM_Lulusan_list->KK->headerCellClass() ?>"><div id="elh_IM_Lulusan_KK" class="IM_Lulusan_KK"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->KK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KK" class="<?php echo $IM_Lulusan_list->KK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->KK) ?>', 1);"><div id="elh_IM_Lulusan_KK" class="IM_Lulusan_KK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->KK->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->KK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->KK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->IjazahIM->Visible) { // IjazahIM ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->IjazahIM) == "") { ?>
		<th data-name="IjazahIM" class="<?php echo $IM_Lulusan_list->IjazahIM->headerCellClass() ?>"><div id="elh_IM_Lulusan_IjazahIM" class="IM_Lulusan_IjazahIM"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->IjazahIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IjazahIM" class="<?php echo $IM_Lulusan_list->IjazahIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->IjazahIM) ?>', 1);"><div id="elh_IM_Lulusan_IjazahIM" class="IM_Lulusan_IjazahIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->IjazahIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->IjazahIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->IjazahIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->TranskriptIM->Visible) { // TranskriptIM ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->TranskriptIM) == "") { ?>
		<th data-name="TranskriptIM" class="<?php echo $IM_Lulusan_list->TranskriptIM->headerCellClass() ?>"><div id="elh_IM_Lulusan_TranskriptIM" class="IM_Lulusan_TranskriptIM"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->TranskriptIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TranskriptIM" class="<?php echo $IM_Lulusan_list->TranskriptIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->TranskriptIM) ?>', 1);"><div id="elh_IM_Lulusan_TranskriptIM" class="IM_Lulusan_TranskriptIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->TranskriptIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->TranskriptIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->TranskriptIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Skripsi->Visible) { // Skripsi ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Skripsi) == "") { ?>
		<th data-name="Skripsi" class="<?php echo $IM_Lulusan_list->Skripsi->headerCellClass() ?>"><div id="elh_IM_Lulusan_Skripsi" class="IM_Lulusan_Skripsi"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Skripsi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Skripsi" class="<?php echo $IM_Lulusan_list->Skripsi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Skripsi) ?>', 1);"><div id="elh_IM_Lulusan_Skripsi" class="IM_Lulusan_Skripsi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Skripsi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Skripsi->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Skripsi->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->TASkripsi->Visible) { // TASkripsi ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->TASkripsi) == "") { ?>
		<th data-name="TASkripsi" class="<?php echo $IM_Lulusan_list->TASkripsi->headerCellClass() ?>"><div id="elh_IM_Lulusan_TASkripsi" class="IM_Lulusan_TASkripsi"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->TASkripsi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TASkripsi" class="<?php echo $IM_Lulusan_list->TASkripsi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->TASkripsi) ?>', 1);"><div id="elh_IM_Lulusan_TASkripsi" class="IM_Lulusan_TASkripsi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->TASkripsi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->TASkripsi->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->TASkripsi->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->Plagiat->Visible) { // Plagiat ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->Plagiat) == "") { ?>
		<th data-name="Plagiat" class="<?php echo $IM_Lulusan_list->Plagiat->headerCellClass() ?>"><div id="elh_IM_Lulusan_Plagiat" class="IM_Lulusan_Plagiat"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Plagiat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Plagiat" class="<?php echo $IM_Lulusan_list->Plagiat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->Plagiat) ?>', 1);"><div id="elh_IM_Lulusan_Plagiat" class="IM_Lulusan_Plagiat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->Plagiat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->Plagiat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->Plagiat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->riwayatakademik->Visible) { // riwayatakademik ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->riwayatakademik) == "") { ?>
		<th data-name="riwayatakademik" class="<?php echo $IM_Lulusan_list->riwayatakademik->headerCellClass() ?>"><div id="elh_IM_Lulusan_riwayatakademik" class="IM_Lulusan_riwayatakademik"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->riwayatakademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="riwayatakademik" class="<?php echo $IM_Lulusan_list->riwayatakademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->riwayatakademik) ?>', 1);"><div id="elh_IM_Lulusan_riwayatakademik" class="IM_Lulusan_riwayatakademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->riwayatakademik->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->riwayatakademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->riwayatakademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->keuangan->Visible) { // keuangan ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->keuangan) == "") { ?>
		<th data-name="keuangan" class="<?php echo $IM_Lulusan_list->keuangan->headerCellClass() ?>"><div id="elh_IM_Lulusan_keuangan" class="IM_Lulusan_keuangan"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->keuangan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="keuangan" class="<?php echo $IM_Lulusan_list->keuangan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->keuangan) ?>', 1);"><div id="elh_IM_Lulusan_keuangan" class="IM_Lulusan_keuangan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->keuangan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->keuangan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->keuangan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->pendukung->Visible) { // pendukung ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->pendukung) == "") { ?>
		<th data-name="pendukung" class="<?php echo $IM_Lulusan_list->pendukung->headerCellClass() ?>"><div id="elh_IM_Lulusan_pendukung" class="IM_Lulusan_pendukung"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->pendukung->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pendukung" class="<?php echo $IM_Lulusan_list->pendukung->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->pendukung) ?>', 1);"><div id="elh_IM_Lulusan_pendukung" class="IM_Lulusan_pendukung">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->pendukung->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->pendukung->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->pendukung->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Lulusan_list->lainlain->Visible) { // lainlain ?>
	<?php if ($IM_Lulusan_list->SortUrl($IM_Lulusan_list->lainlain) == "") { ?>
		<th data-name="lainlain" class="<?php echo $IM_Lulusan_list->lainlain->headerCellClass() ?>"><div id="elh_IM_Lulusan_lainlain" class="IM_Lulusan_lainlain"><div class="ew-table-header-caption"><?php echo $IM_Lulusan_list->lainlain->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lainlain" class="<?php echo $IM_Lulusan_list->lainlain->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Lulusan_list->SortUrl($IM_Lulusan_list->lainlain) ?>', 1);"><div id="elh_IM_Lulusan_lainlain" class="IM_Lulusan_lainlain">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Lulusan_list->lainlain->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Lulusan_list->lainlain->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Lulusan_list->lainlain->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$IM_Lulusan_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($IM_Lulusan_list->ExportAll && $IM_Lulusan_list->isExport()) {
	$IM_Lulusan_list->StopRecord = $IM_Lulusan_list->TotalRecords;
} else {

	// Set the last record to display
	if ($IM_Lulusan_list->TotalRecords > $IM_Lulusan_list->StartRecord + $IM_Lulusan_list->DisplayRecords - 1)
		$IM_Lulusan_list->StopRecord = $IM_Lulusan_list->StartRecord + $IM_Lulusan_list->DisplayRecords - 1;
	else
		$IM_Lulusan_list->StopRecord = $IM_Lulusan_list->TotalRecords;
}
$IM_Lulusan_list->RecordCount = $IM_Lulusan_list->StartRecord - 1;
if ($IM_Lulusan_list->Recordset && !$IM_Lulusan_list->Recordset->EOF) {
	$IM_Lulusan_list->Recordset->moveFirst();
	$selectLimit = $IM_Lulusan_list->UseSelectLimit;
	if (!$selectLimit && $IM_Lulusan_list->StartRecord > 1)
		$IM_Lulusan_list->Recordset->move($IM_Lulusan_list->StartRecord - 1);
} elseif (!$IM_Lulusan->AllowAddDeleteRow && $IM_Lulusan_list->StopRecord == 0) {
	$IM_Lulusan_list->StopRecord = $IM_Lulusan->GridAddRowCount;
}

// Initialize aggregate
$IM_Lulusan->RowType = ROWTYPE_AGGREGATEINIT;
$IM_Lulusan->resetAttributes();
$IM_Lulusan_list->renderRow();
while ($IM_Lulusan_list->RecordCount < $IM_Lulusan_list->StopRecord) {
	$IM_Lulusan_list->RecordCount++;
	if ($IM_Lulusan_list->RecordCount >= $IM_Lulusan_list->StartRecord) {
		$IM_Lulusan_list->RowCount++;

		// Set up key count
		$IM_Lulusan_list->KeyCount = $IM_Lulusan_list->RowIndex;

		// Init row class and style
		$IM_Lulusan->resetAttributes();
		$IM_Lulusan->CssClass = "";
		if ($IM_Lulusan_list->isGridAdd()) {
		} else {
			$IM_Lulusan_list->loadRowValues($IM_Lulusan_list->Recordset); // Load row values
		}
		$IM_Lulusan->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$IM_Lulusan->RowAttrs->merge(["data-rowindex" => $IM_Lulusan_list->RowCount, "id" => "r" . $IM_Lulusan_list->RowCount . "_IM_Lulusan", "data-rowtype" => $IM_Lulusan->RowType]);

		// Render row
		$IM_Lulusan_list->renderRow();

		// Render list options
		$IM_Lulusan_list->renderListOptions();
?>
	<tr <?php echo $IM_Lulusan->rowAttributes() ?>>
<?php

// Render list options (body, left)
$IM_Lulusan_list->ListOptions->render("body", "left", $IM_Lulusan_list->RowCount);
?>
	<?php if ($IM_Lulusan_list->NIM->Visible) { // NIM ?>
		<td data-name="NIM" <?php echo $IM_Lulusan_list->NIM->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_NIM">
<span<?php echo $IM_Lulusan_list->NIM->viewAttributes() ?>><?php echo $IM_Lulusan_list->NIM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $IM_Lulusan_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Nama_Mhs">
<span<?php echo $IM_Lulusan_list->Nama_Mhs->viewAttributes() ?>><?php echo $IM_Lulusan_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Tmp_Lahir->Visible) { // Tmp_Lahir ?>
		<td data-name="Tmp_Lahir" <?php echo $IM_Lulusan_list->Tmp_Lahir->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Tmp_Lahir">
<span<?php echo $IM_Lulusan_list->Tmp_Lahir->viewAttributes() ?>><?php echo $IM_Lulusan_list->Tmp_Lahir->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Tgl_Lahir->Visible) { // Tgl_Lahir ?>
		<td data-name="Tgl_Lahir" <?php echo $IM_Lulusan_list->Tgl_Lahir->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Tgl_Lahir">
<span<?php echo $IM_Lulusan_list->Tgl_Lahir->viewAttributes() ?>><?php echo $IM_Lulusan_list->Tgl_Lahir->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $IM_Lulusan_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Kode_Fak">
<span<?php echo $IM_Lulusan_list->Kode_Fak->viewAttributes() ?>><?php echo $IM_Lulusan_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Alamat->Visible) { // Alamat ?>
		<td data-name="Alamat" <?php echo $IM_Lulusan_list->Alamat->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Alamat">
<span<?php echo $IM_Lulusan_list->Alamat->viewAttributes() ?>><?php echo $IM_Lulusan_list->Alamat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Telepon->Visible) { // Telepon ?>
		<td data-name="Telepon" <?php echo $IM_Lulusan_list->Telepon->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Telepon">
<span<?php echo $IM_Lulusan_list->Telepon->viewAttributes() ?>><?php echo $IM_Lulusan_list->Telepon->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->_Email->Visible) { // Email ?>
		<td data-name="_Email" <?php echo $IM_Lulusan_list->_Email->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan__Email">
<span<?php echo $IM_Lulusan_list->_Email->viewAttributes() ?>><?php echo $IM_Lulusan_list->_Email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $IM_Lulusan_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Kode_jp">
<span<?php echo $IM_Lulusan_list->Kode_jp->viewAttributes() ?>><?php echo $IM_Lulusan_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $IM_Lulusan_list->Status_Akd->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Status_Akd">
<span<?php echo $IM_Lulusan_list->Status_Akd->viewAttributes() ?>><?php echo $IM_Lulusan_list->Status_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->TaMasuk->Visible) { // TaMasuk ?>
		<td data-name="TaMasuk" <?php echo $IM_Lulusan_list->TaMasuk->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_TaMasuk">
<span<?php echo $IM_Lulusan_list->TaMasuk->viewAttributes() ?>><?php echo $IM_Lulusan_list->TaMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->PerMasuk->Visible) { // PerMasuk ?>
		<td data-name="PerMasuk" <?php echo $IM_Lulusan_list->PerMasuk->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_PerMasuk">
<span<?php echo $IM_Lulusan_list->PerMasuk->viewAttributes() ?>><?php echo $IM_Lulusan_list->PerMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->tglmasuk->Visible) { // tglmasuk ?>
		<td data-name="tglmasuk" <?php echo $IM_Lulusan_list->tglmasuk->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_tglmasuk">
<span<?php echo $IM_Lulusan_list->tglmasuk->viewAttributes() ?>><?php echo $IM_Lulusan_list->tglmasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Tgl_Lulus->Visible) { // Tgl_Lulus ?>
		<td data-name="Tgl_Lulus" <?php echo $IM_Lulusan_list->Tgl_Lulus->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Tgl_Lulus">
<span<?php echo $IM_Lulusan_list->Tgl_Lulus->viewAttributes() ?>><?php echo $IM_Lulusan_list->Tgl_Lulus->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->No_Ijazah->Visible) { // No_Ijazah ?>
		<td data-name="No_Ijazah" <?php echo $IM_Lulusan_list->No_Ijazah->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_No_Ijazah">
<span<?php echo $IM_Lulusan_list->No_Ijazah->viewAttributes() ?>><?php echo $IM_Lulusan_list->No_Ijazah->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->SK->Visible) { // SK ?>
		<td data-name="SK" <?php echo $IM_Lulusan_list->SK->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_SK">
<span<?php echo $IM_Lulusan_list->SK->viewAttributes() ?>><?php echo $IM_Lulusan_list->SK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->TA->Visible) { // TA ?>
		<td data-name="TA" <?php echo $IM_Lulusan_list->TA->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_TA">
<span<?php echo $IM_Lulusan_list->TA->viewAttributes() ?>><?php echo $IM_Lulusan_list->TA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->per->Visible) { // per ?>
		<td data-name="per" <?php echo $IM_Lulusan_list->per->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_per">
<span<?php echo $IM_Lulusan_list->per->viewAttributes() ?>><?php echo $IM_Lulusan_list->per->getViewValue() ?></span>
</span>
</td>
	<?php } 
	$salt = "86458762398576twuitrweu@#UTUY&*%&****trwerutUTUYT";
	$id=md5($salt . rtrim($IM_Lulusan_list->NIM->getViewValue()));	
	?>
	<td>
		<a class="btn btn-primary btn-sm" href="custom/ekpt.php?nim=<?php echo rtrim($IM_Lulusan_list->NIM->getViewValue()) ?>&id=<?php echo $id; ?>" role="button" target="_blank">Riwayat</a>   
	</td> 
	<?php if ($IM_Lulusan_list->Pwl->Visible) { // Pwl ?>
		<td data-name="Pwl" <?php echo $IM_Lulusan_list->Pwl->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Pwl">
<span<?php echo $IM_Lulusan_list->Pwl->viewAttributes() ?>><?php echo $IM_Lulusan_list->Pwl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>

	<?php if ($IM_Lulusan_list->Ijazah->Visible) { // Ijazah ?>
		<td data-name="Ijazah" <?php echo $IM_Lulusan_list->Ijazah->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Ijazah">
<span<?php echo $IM_Lulusan_list->Ijazah->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->Ijazah->getViewValue()) && $IM_Lulusan_list->Ijazah->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->Ijazah->linkAttributes() ?>><?php echo $IM_Lulusan_list->Ijazah->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->Ijazah->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Ktp->Visible) { // Ktp ?>
		<td data-name="Ktp" <?php echo $IM_Lulusan_list->Ktp->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Ktp">
<span<?php echo $IM_Lulusan_list->Ktp->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->Ktp->getViewValue()) && $IM_Lulusan_list->Ktp->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->Ktp->linkAttributes() ?>><?php echo $IM_Lulusan_list->Ktp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->Ktp->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->KK->Visible) { // KK ?>
		<td data-name="KK" <?php echo $IM_Lulusan_list->KK->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_KK">
<span<?php echo $IM_Lulusan_list->KK->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->KK->getViewValue()) && $IM_Lulusan_list->KK->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->KK->linkAttributes() ?>><?php echo $IM_Lulusan_list->KK->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->KK->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->IjazahIM->Visible) { // IjazahIM ?>
		<td data-name="IjazahIM" <?php echo $IM_Lulusan_list->IjazahIM->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_IjazahIM">
<span<?php echo $IM_Lulusan_list->IjazahIM->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->IjazahIM->getViewValue()) && $IM_Lulusan_list->IjazahIM->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->IjazahIM->linkAttributes() ?>><?php echo $IM_Lulusan_list->IjazahIM->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->IjazahIM->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->TranskriptIM->Visible) { // TranskriptIM ?>
		<td data-name="TranskriptIM" <?php echo $IM_Lulusan_list->TranskriptIM->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_TranskriptIM">
<span<?php echo $IM_Lulusan_list->TranskriptIM->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->TranskriptIM->getViewValue()) && $IM_Lulusan_list->TranskriptIM->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->TranskriptIM->linkAttributes() ?>><?php echo $IM_Lulusan_list->TranskriptIM->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->TranskriptIM->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Skripsi->Visible) { // Skripsi ?>
		<td data-name="Skripsi" <?php echo $IM_Lulusan_list->Skripsi->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Skripsi">
<span<?php echo $IM_Lulusan_list->Skripsi->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->Skripsi->getViewValue()) && $IM_Lulusan_list->Skripsi->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->Skripsi->linkAttributes() ?>><?php echo $IM_Lulusan_list->Skripsi->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->Skripsi->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->TASkripsi->Visible) { // TASkripsi ?>
		<td data-name="TASkripsi" <?php echo $IM_Lulusan_list->TASkripsi->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_TASkripsi">
<span<?php echo $IM_Lulusan_list->TASkripsi->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->TASkripsi->getViewValue()) && $IM_Lulusan_list->TASkripsi->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->TASkripsi->linkAttributes() ?>><?php echo $IM_Lulusan_list->TASkripsi->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->TASkripsi->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->Plagiat->Visible) { // Plagiat ?>
		<td data-name="Plagiat" <?php echo $IM_Lulusan_list->Plagiat->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_Plagiat">
<span<?php echo $IM_Lulusan_list->Plagiat->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->Plagiat->getViewValue()) && $IM_Lulusan_list->Plagiat->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->Plagiat->linkAttributes() ?>><?php echo $IM_Lulusan_list->Plagiat->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->Plagiat->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->riwayatakademik->Visible) { // riwayatakademik ?>
		<td data-name="riwayatakademik" <?php echo $IM_Lulusan_list->riwayatakademik->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_riwayatakademik">
<span<?php echo $IM_Lulusan_list->riwayatakademik->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->riwayatakademik->getViewValue()) && $IM_Lulusan_list->riwayatakademik->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->riwayatakademik->linkAttributes() ?>><?php echo $IM_Lulusan_list->riwayatakademik->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->riwayatakademik->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->keuangan->Visible) { // keuangan ?>
		<td data-name="keuangan" <?php echo $IM_Lulusan_list->keuangan->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_keuangan">
<span<?php echo $IM_Lulusan_list->keuangan->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->keuangan->getViewValue()) && $IM_Lulusan_list->keuangan->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->keuangan->linkAttributes() ?>><?php echo $IM_Lulusan_list->keuangan->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->keuangan->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->pendukung->Visible) { // pendukung ?>
		<td data-name="pendukung" <?php echo $IM_Lulusan_list->pendukung->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_pendukung">
<span<?php echo $IM_Lulusan_list->pendukung->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->pendukung->getViewValue()) && $IM_Lulusan_list->pendukung->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->pendukung->linkAttributes() ?>><?php echo $IM_Lulusan_list->pendukung->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->pendukung->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Lulusan_list->lainlain->Visible) { // lainlain ?>
		<td data-name="lainlain" <?php echo $IM_Lulusan_list->lainlain->cellAttributes() ?>>
<span id="el<?php echo $IM_Lulusan_list->RowCount ?>_IM_Lulusan_lainlain">
<span<?php echo $IM_Lulusan_list->lainlain->viewAttributes() ?>><?php if (!EmptyString($IM_Lulusan_list->lainlain->getViewValue()) && $IM_Lulusan_list->lainlain->linkAttributes() != "") { ?>
<a<?php echo $IM_Lulusan_list->lainlain->linkAttributes() ?>><?php echo $IM_Lulusan_list->lainlain->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Lulusan_list->lainlain->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$IM_Lulusan_list->ListOptions->render("body", "right", $IM_Lulusan_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$IM_Lulusan_list->isGridAdd())
		$IM_Lulusan_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$IM_Lulusan->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($IM_Lulusan_list->Recordset)
	$IM_Lulusan_list->Recordset->Close();
?>
<?php if (!$IM_Lulusan_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$IM_Lulusan_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $IM_Lulusan_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $IM_Lulusan_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($IM_Lulusan_list->TotalRecords == 0 && !$IM_Lulusan->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $IM_Lulusan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$IM_Lulusan_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$IM_Lulusan_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$IM_Lulusan_list->terminate();
?>