<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$IM_Mhs_list = new IM_Mhs_list();

// Run the page
$IM_Mhs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$IM_Mhs_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$IM_Mhs_list->isExport()) { ?>
<script>
var fIM_Mhslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fIM_Mhslist = currentForm = new ew.Form("fIM_Mhslist", "list");
	fIM_Mhslist.formKeyCountName = '<?php echo $IM_Mhs_list->FormKeyCountName ?>';
	loadjs.done("fIM_Mhslist");
});
var fIM_Mhslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fIM_Mhslistsrch = currentSearchForm = new ew.Form("fIM_Mhslistsrch");

	// Validate function for search
	fIM_Mhslistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fIM_Mhslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fIM_Mhslistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fIM_Mhslistsrch.lists["x_Status_Akd"] = <?php echo $IM_Mhs_list->Status_Akd->Lookup->toClientList($IM_Mhs_list) ?>;
	fIM_Mhslistsrch.lists["x_Status_Akd"].options = <?php echo JsonEncode($IM_Mhs_list->Status_Akd->lookupOptions()) ?>;
	fIM_Mhslistsrch.lists["x_Kode_jp"] = <?php echo $IM_Mhs_list->Kode_jp->Lookup->toClientList($IM_Mhs_list) ?>;
	fIM_Mhslistsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($IM_Mhs_list->Kode_jp->lookupOptions()) ?>;
	fIM_Mhslistsrch.lists["x_TaMasuk"] = <?php echo $IM_Mhs_list->TaMasuk->Lookup->toClientList($IM_Mhs_list) ?>;
	fIM_Mhslistsrch.lists["x_TaMasuk"].options = <?php echo JsonEncode($IM_Mhs_list->TaMasuk->lookupOptions()) ?>;
	fIM_Mhslistsrch.lists["x_PerMasuk"] = <?php echo $IM_Mhs_list->PerMasuk->Lookup->toClientList($IM_Mhs_list) ?>;
	fIM_Mhslistsrch.lists["x_PerMasuk"].options = <?php echo JsonEncode($IM_Mhs_list->PerMasuk->options(FALSE, TRUE)) ?>;
	fIM_Mhslistsrch.lists["x_Status_Masuk"] = <?php echo $IM_Mhs_list->Status_Masuk->Lookup->toClientList($IM_Mhs_list) ?>;
	fIM_Mhslistsrch.lists["x_Status_Masuk"].options = <?php echo JsonEncode($IM_Mhs_list->Status_Masuk->options(FALSE, TRUE)) ?>;

	// Filters
	fIM_Mhslistsrch.filterList = <?php echo $IM_Mhs_list->getFilterList() ?>;
	loadjs.done("fIM_Mhslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$IM_Mhs_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($IM_Mhs_list->TotalRecords > 0 && $IM_Mhs_list->ExportOptions->visible()) { ?>
<?php $IM_Mhs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Mhs_list->ImportOptions->visible()) { ?>
<?php $IM_Mhs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Mhs_list->SearchOptions->visible()) { ?>
<?php $IM_Mhs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Mhs_list->FilterOptions->visible()) { ?>
<?php $IM_Mhs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$IM_Mhs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$IM_Mhs_list->isExport() && !$IM_Mhs->CurrentAction) { ?>
<form name="fIM_Mhslistsrch" id="fIM_Mhslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fIM_Mhslistsrch-search-panel" class="<?php echo $IM_Mhs_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="IM_Mhs">
	<div class="ew-extended-search">
<?php

// Render search row
$IM_Mhs->RowType = ROWTYPE_SEARCH;
$IM_Mhs->resetAttributes();
$IM_Mhs_list->renderRow();
?>
<?php if ($IM_Mhs_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php
		$IM_Mhs_list->SearchColumnCount++;
		if (($IM_Mhs_list->SearchColumnCount - 1) % $IM_Mhs_list->SearchFieldsPerRow == 0) {
			$IM_Mhs_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Mhs_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Akd" class="ew-cell form-group">
		<label for="x_Status_Akd" class="ew-search-caption ew-label"><?php echo $IM_Mhs_list->Status_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Akd" id="z_Status_Akd" value="LIKE">
</span>
		<span id="el_IM_Mhs_Status_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Mhs" data-field="x_Status_Akd" data-value-separator="<?php echo $IM_Mhs_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $IM_Mhs_list->Status_Akd->editAttributes() ?>>
			<?php echo $IM_Mhs_list->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $IM_Mhs_list->Status_Akd->Lookup->getParamTag($IM_Mhs_list, "p_x_Status_Akd") ?>
</span>
	</div>
	<?php if ($IM_Mhs_list->SearchColumnCount % $IM_Mhs_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$IM_Mhs_list->SearchColumnCount++;
		if (($IM_Mhs_list->SearchColumnCount - 1) % $IM_Mhs_list->SearchFieldsPerRow == 0) {
			$IM_Mhs_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Mhs_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $IM_Mhs_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_IM_Mhs_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Mhs" data-field="x_Kode_jp" data-value-separator="<?php echo $IM_Mhs_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $IM_Mhs_list->Kode_jp->editAttributes() ?>>
			<?php echo $IM_Mhs_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $IM_Mhs_list->Kode_jp->Lookup->getParamTag($IM_Mhs_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($IM_Mhs_list->SearchColumnCount % $IM_Mhs_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php
		$IM_Mhs_list->SearchColumnCount++;
		if (($IM_Mhs_list->SearchColumnCount - 1) % $IM_Mhs_list->SearchFieldsPerRow == 0) {
			$IM_Mhs_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Mhs_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_TaMasuk" class="ew-cell form-group">
		<label for="x_TaMasuk" class="ew-search-caption ew-label"><?php echo $IM_Mhs_list->TaMasuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TaMasuk" id="z_TaMasuk" value="LIKE">
</span>
		<span id="el_IM_Mhs_TaMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Mhs" data-field="x_TaMasuk" data-value-separator="<?php echo $IM_Mhs_list->TaMasuk->displayValueSeparatorAttribute() ?>" id="x_TaMasuk" name="x_TaMasuk"<?php echo $IM_Mhs_list->TaMasuk->editAttributes() ?>>
			<?php echo $IM_Mhs_list->TaMasuk->selectOptionListHtml("x_TaMasuk") ?>
		</select>
</div>
<?php echo $IM_Mhs_list->TaMasuk->Lookup->getParamTag($IM_Mhs_list, "p_x_TaMasuk") ?>
</span>
	</div>
	<?php if ($IM_Mhs_list->SearchColumnCount % $IM_Mhs_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php
		$IM_Mhs_list->SearchColumnCount++;
		if (($IM_Mhs_list->SearchColumnCount - 1) % $IM_Mhs_list->SearchFieldsPerRow == 0) {
			$IM_Mhs_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Mhs_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_PerMasuk" class="ew-cell form-group">
		<label for="x_PerMasuk" class="ew-search-caption ew-label"><?php echo $IM_Mhs_list->PerMasuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PerMasuk" id="z_PerMasuk" value="LIKE">
</span>
		<span id="el_IM_Mhs_PerMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Mhs" data-field="x_PerMasuk" data-value-separator="<?php echo $IM_Mhs_list->PerMasuk->displayValueSeparatorAttribute() ?>" id="x_PerMasuk" name="x_PerMasuk"<?php echo $IM_Mhs_list->PerMasuk->editAttributes() ?>>
			<?php echo $IM_Mhs_list->PerMasuk->selectOptionListHtml("x_PerMasuk") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($IM_Mhs_list->SearchColumnCount % $IM_Mhs_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Status_Masuk->Visible) { // Status_Masuk ?>
	<?php
		$IM_Mhs_list->SearchColumnCount++;
		if (($IM_Mhs_list->SearchColumnCount - 1) % $IM_Mhs_list->SearchFieldsPerRow == 0) {
			$IM_Mhs_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Mhs_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Masuk" class="ew-cell form-group">
		<label for="x_Status_Masuk" class="ew-search-caption ew-label"><?php echo $IM_Mhs_list->Status_Masuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Masuk" id="z_Status_Masuk" value="LIKE">
</span>
		<span id="el_IM_Mhs_Status_Masuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Mhs" data-field="x_Status_Masuk" data-value-separator="<?php echo $IM_Mhs_list->Status_Masuk->displayValueSeparatorAttribute() ?>" id="x_Status_Masuk" name="x_Status_Masuk"<?php echo $IM_Mhs_list->Status_Masuk->editAttributes() ?>>
			<?php echo $IM_Mhs_list->Status_Masuk->selectOptionListHtml("x_Status_Masuk") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($IM_Mhs_list->SearchColumnCount % $IM_Mhs_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($IM_Mhs_list->SearchColumnCount % $IM_Mhs_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $IM_Mhs_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($IM_Mhs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($IM_Mhs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $IM_Mhs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($IM_Mhs_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($IM_Mhs_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($IM_Mhs_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($IM_Mhs_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $IM_Mhs_list->showPageHeader(); ?>
<?php
$IM_Mhs_list->showMessage();
?>
<?php if ($IM_Mhs_list->TotalRecords > 0 || $IM_Mhs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($IM_Mhs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> IM_Mhs">
<form name="fIM_Mhslist" id="fIM_Mhslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="IM_Mhs">
<div id="gmp_IM_Mhs" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($IM_Mhs_list->TotalRecords > 0 || $IM_Mhs_list->isGridEdit()) { ?>
<table id="tbl_IM_Mhslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$IM_Mhs->RowType = ROWTYPE_HEADER;

// Render list options
$IM_Mhs_list->renderListOptions();

// Render list options (header, left)
$IM_Mhs_list->ListOptions->render("header", "left");
?>
<th>Riwayat</th>
<?php if ($IM_Mhs_list->Nim->Visible) { // Nim ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $IM_Mhs_list->Nim->headerCellClass() ?>"><div id="elh_IM_Mhs_Nim" class="IM_Mhs_Nim"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $IM_Mhs_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Nim) ?>', 1);"><div id="elh_IM_Mhs_Nim" class="IM_Mhs_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IM_Mhs_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_IM_Mhs_Nama_Mhs" class="IM_Mhs_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IM_Mhs_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Nama_Mhs) ?>', 1);"><div id="elh_IM_Mhs_Nama_Mhs" class="IM_Mhs_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Tmp_Lahir->Visible) { // Tmp_Lahir ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Tmp_Lahir) == "") { ?>
		<th data-name="Tmp_Lahir" class="<?php echo $IM_Mhs_list->Tmp_Lahir->headerCellClass() ?>"><div id="elh_IM_Mhs_Tmp_Lahir" class="IM_Mhs_Tmp_Lahir"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Tmp_Lahir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tmp_Lahir" class="<?php echo $IM_Mhs_list->Tmp_Lahir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Tmp_Lahir) ?>', 1);"><div id="elh_IM_Mhs_Tmp_Lahir" class="IM_Mhs_Tmp_Lahir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Tmp_Lahir->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Tmp_Lahir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Tmp_Lahir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Tgl_Lahir->Visible) { // Tgl_Lahir ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Tgl_Lahir) == "") { ?>
		<th data-name="Tgl_Lahir" class="<?php echo $IM_Mhs_list->Tgl_Lahir->headerCellClass() ?>"><div id="elh_IM_Mhs_Tgl_Lahir" class="IM_Mhs_Tgl_Lahir"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Tgl_Lahir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tgl_Lahir" class="<?php echo $IM_Mhs_list->Tgl_Lahir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Tgl_Lahir) ?>', 1);"><div id="elh_IM_Mhs_Tgl_Lahir" class="IM_Mhs_Tgl_Lahir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Tgl_Lahir->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Tgl_Lahir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Tgl_Lahir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $IM_Mhs_list->Status_Akd->headerCellClass() ?>"><div id="elh_IM_Mhs_Status_Akd" class="IM_Mhs_Status_Akd"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $IM_Mhs_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Status_Akd) ?>', 1);"><div id="elh_IM_Mhs_Status_Akd" class="IM_Mhs_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $IM_Mhs_list->Kode_Fak->headerCellClass() ?>"><div id="elh_IM_Mhs_Kode_Fak" class="IM_Mhs_Kode_Fak"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $IM_Mhs_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Kode_Fak) ?>', 1);"><div id="elh_IM_Mhs_Kode_Fak" class="IM_Mhs_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $IM_Mhs_list->Kode_jp->headerCellClass() ?>"><div id="elh_IM_Mhs_Kode_jp" class="IM_Mhs_Kode_jp"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $IM_Mhs_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Kode_jp) ?>', 1);"><div id="elh_IM_Mhs_Kode_jp" class="IM_Mhs_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->TaMasuk) == "") { ?>
		<th data-name="TaMasuk" class="<?php echo $IM_Mhs_list->TaMasuk->headerCellClass() ?>"><div id="elh_IM_Mhs_TaMasuk" class="IM_Mhs_TaMasuk"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->TaMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TaMasuk" class="<?php echo $IM_Mhs_list->TaMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->TaMasuk) ?>', 1);"><div id="elh_IM_Mhs_TaMasuk" class="IM_Mhs_TaMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->TaMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->TaMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->TaMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->PerMasuk) == "") { ?>
		<th data-name="PerMasuk" class="<?php echo $IM_Mhs_list->PerMasuk->headerCellClass() ?>"><div id="elh_IM_Mhs_PerMasuk" class="IM_Mhs_PerMasuk"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->PerMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerMasuk" class="<?php echo $IM_Mhs_list->PerMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->PerMasuk) ?>', 1);"><div id="elh_IM_Mhs_PerMasuk" class="IM_Mhs_PerMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->PerMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->PerMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->PerMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->SemesterMulai->Visible) { // SemesterMulai ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->SemesterMulai) == "") { ?>
		<th data-name="SemesterMulai" class="<?php echo $IM_Mhs_list->SemesterMulai->headerCellClass() ?>"><div id="elh_IM_Mhs_SemesterMulai" class="IM_Mhs_SemesterMulai"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->SemesterMulai->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SemesterMulai" class="<?php echo $IM_Mhs_list->SemesterMulai->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->SemesterMulai) ?>', 1);"><div id="elh_IM_Mhs_SemesterMulai" class="IM_Mhs_SemesterMulai">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->SemesterMulai->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->SemesterMulai->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->SemesterMulai->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->tglmasuk->Visible) { // tglmasuk ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->tglmasuk) == "") { ?>
		<th data-name="tglmasuk" class="<?php echo $IM_Mhs_list->tglmasuk->headerCellClass() ?>"><div id="elh_IM_Mhs_tglmasuk" class="IM_Mhs_tglmasuk"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->tglmasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tglmasuk" class="<?php echo $IM_Mhs_list->tglmasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->tglmasuk) ?>', 1);"><div id="elh_IM_Mhs_tglmasuk" class="IM_Mhs_tglmasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->tglmasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->tglmasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->tglmasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Status->Visible) { // Status ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Status) == "") { ?>
		<th data-name="Status" class="<?php echo $IM_Mhs_list->Status->headerCellClass() ?>"><div id="elh_IM_Mhs_Status" class="IM_Mhs_Status"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status" class="<?php echo $IM_Mhs_list->Status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Status) ?>', 1);"><div id="elh_IM_Mhs_Status" class="IM_Mhs_Status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Status->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->StatusAkhir->Visible) { // StatusAkhir ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->StatusAkhir) == "") { ?>
		<th data-name="StatusAkhir" class="<?php echo $IM_Mhs_list->StatusAkhir->headerCellClass() ?>"><div id="elh_IM_Mhs_StatusAkhir" class="IM_Mhs_StatusAkhir"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->StatusAkhir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="StatusAkhir" class="<?php echo $IM_Mhs_list->StatusAkhir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->StatusAkhir) ?>', 1);"><div id="elh_IM_Mhs_StatusAkhir" class="IM_Mhs_StatusAkhir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->StatusAkhir->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->StatusAkhir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->StatusAkhir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->SemesterKeluar_Lulus->Visible) { // SemesterKeluar_Lulus ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->SemesterKeluar_Lulus) == "") { ?>
		<th data-name="SemesterKeluar_Lulus" class="<?php echo $IM_Mhs_list->SemesterKeluar_Lulus->headerCellClass() ?>"><div id="elh_IM_Mhs_SemesterKeluar_Lulus" class="IM_Mhs_SemesterKeluar_Lulus"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->SemesterKeluar_Lulus->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SemesterKeluar_Lulus" class="<?php echo $IM_Mhs_list->SemesterKeluar_Lulus->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->SemesterKeluar_Lulus) ?>', 1);"><div id="elh_IM_Mhs_SemesterKeluar_Lulus" class="IM_Mhs_SemesterKeluar_Lulus">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->SemesterKeluar_Lulus->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->SemesterKeluar_Lulus->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->SemesterKeluar_Lulus->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Status_Masuk->Visible) { // Status_Masuk ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Status_Masuk) == "") { ?>
		<th data-name="Status_Masuk" class="<?php echo $IM_Mhs_list->Status_Masuk->headerCellClass() ?>"><div id="elh_IM_Mhs_Status_Masuk" class="IM_Mhs_Status_Masuk"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Status_Masuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Masuk" class="<?php echo $IM_Mhs_list->Status_Masuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Status_Masuk) ?>', 1);"><div id="elh_IM_Mhs_Status_Masuk" class="IM_Mhs_Status_Masuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Status_Masuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Status_Masuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Status_Masuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->AwalPendaftaran->Visible) { // AwalPendaftaran ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->AwalPendaftaran) == "") { ?>
		<th data-name="AwalPendaftaran" class="<?php echo $IM_Mhs_list->AwalPendaftaran->headerCellClass() ?>"><div id="elh_IM_Mhs_AwalPendaftaran" class="IM_Mhs_AwalPendaftaran"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->AwalPendaftaran->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AwalPendaftaran" class="<?php echo $IM_Mhs_list->AwalPendaftaran->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->AwalPendaftaran) ?>', 1);"><div id="elh_IM_Mhs_AwalPendaftaran" class="IM_Mhs_AwalPendaftaran">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->AwalPendaftaran->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->AwalPendaftaran->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->AwalPendaftaran->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Pwl->Visible) { // Pwl ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Pwl) == "") { ?>
		<th data-name="Pwl" class="<?php echo $IM_Mhs_list->Pwl->headerCellClass() ?>"><div id="elh_IM_Mhs_Pwl" class="IM_Mhs_Pwl"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Pwl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Pwl" class="<?php echo $IM_Mhs_list->Pwl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Pwl) ?>', 1);"><div id="elh_IM_Mhs_Pwl" class="IM_Mhs_Pwl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Pwl->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Pwl->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Pwl->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Ijazah->Visible) { // Ijazah ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Ijazah) == "") { ?>
		<th data-name="Ijazah" class="<?php echo $IM_Mhs_list->Ijazah->headerCellClass() ?>"><div id="elh_IM_Mhs_Ijazah" class="IM_Mhs_Ijazah"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Ijazah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ijazah" class="<?php echo $IM_Mhs_list->Ijazah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Ijazah) ?>', 1);"><div id="elh_IM_Mhs_Ijazah" class="IM_Mhs_Ijazah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Ijazah->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Ijazah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Ijazah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Ktp->Visible) { // Ktp ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Ktp) == "") { ?>
		<th data-name="Ktp" class="<?php echo $IM_Mhs_list->Ktp->headerCellClass() ?>"><div id="elh_IM_Mhs_Ktp" class="IM_Mhs_Ktp"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Ktp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ktp" class="<?php echo $IM_Mhs_list->Ktp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Ktp) ?>', 1);"><div id="elh_IM_Mhs_Ktp" class="IM_Mhs_Ktp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Ktp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Ktp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Ktp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->KK->Visible) { // KK ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->KK) == "") { ?>
		<th data-name="KK" class="<?php echo $IM_Mhs_list->KK->headerCellClass() ?>"><div id="elh_IM_Mhs_KK" class="IM_Mhs_KK"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->KK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KK" class="<?php echo $IM_Mhs_list->KK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->KK) ?>', 1);"><div id="elh_IM_Mhs_KK" class="IM_Mhs_KK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->KK->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->KK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->KK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->IjazahIM->Visible) { // IjazahIM ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->IjazahIM) == "") { ?>
		<th data-name="IjazahIM" class="<?php echo $IM_Mhs_list->IjazahIM->headerCellClass() ?>"><div id="elh_IM_Mhs_IjazahIM" class="IM_Mhs_IjazahIM"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->IjazahIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IjazahIM" class="<?php echo $IM_Mhs_list->IjazahIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->IjazahIM) ?>', 1);"><div id="elh_IM_Mhs_IjazahIM" class="IM_Mhs_IjazahIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->IjazahIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->IjazahIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->IjazahIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->TranskriptIM->Visible) { // TranskriptIM ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->TranskriptIM) == "") { ?>
		<th data-name="TranskriptIM" class="<?php echo $IM_Mhs_list->TranskriptIM->headerCellClass() ?>"><div id="elh_IM_Mhs_TranskriptIM" class="IM_Mhs_TranskriptIM"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->TranskriptIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TranskriptIM" class="<?php echo $IM_Mhs_list->TranskriptIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->TranskriptIM) ?>', 1);"><div id="elh_IM_Mhs_TranskriptIM" class="IM_Mhs_TranskriptIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->TranskriptIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->TranskriptIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->TranskriptIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Skripsi->Visible) { // Skripsi ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Skripsi) == "") { ?>
		<th data-name="Skripsi" class="<?php echo $IM_Mhs_list->Skripsi->headerCellClass() ?>"><div id="elh_IM_Mhs_Skripsi" class="IM_Mhs_Skripsi"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Skripsi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Skripsi" class="<?php echo $IM_Mhs_list->Skripsi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Skripsi) ?>', 1);"><div id="elh_IM_Mhs_Skripsi" class="IM_Mhs_Skripsi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Skripsi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Skripsi->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Skripsi->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->TASkripsi->Visible) { // TASkripsi ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->TASkripsi) == "") { ?>
		<th data-name="TASkripsi" class="<?php echo $IM_Mhs_list->TASkripsi->headerCellClass() ?>"><div id="elh_IM_Mhs_TASkripsi" class="IM_Mhs_TASkripsi"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->TASkripsi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TASkripsi" class="<?php echo $IM_Mhs_list->TASkripsi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->TASkripsi) ?>', 1);"><div id="elh_IM_Mhs_TASkripsi" class="IM_Mhs_TASkripsi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->TASkripsi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->TASkripsi->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->TASkripsi->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Plagiat->Visible) { // Plagiat ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Plagiat) == "") { ?>
		<th data-name="Plagiat" class="<?php echo $IM_Mhs_list->Plagiat->headerCellClass() ?>"><div id="elh_IM_Mhs_Plagiat" class="IM_Mhs_Plagiat"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Plagiat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Plagiat" class="<?php echo $IM_Mhs_list->Plagiat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Plagiat) ?>', 1);"><div id="elh_IM_Mhs_Plagiat" class="IM_Mhs_Plagiat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Plagiat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Plagiat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Plagiat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->riwayatakademik->Visible) { // riwayatakademik ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->riwayatakademik) == "") { ?>
		<th data-name="riwayatakademik" class="<?php echo $IM_Mhs_list->riwayatakademik->headerCellClass() ?>"><div id="elh_IM_Mhs_riwayatakademik" class="IM_Mhs_riwayatakademik"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->riwayatakademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="riwayatakademik" class="<?php echo $IM_Mhs_list->riwayatakademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->riwayatakademik) ?>', 1);"><div id="elh_IM_Mhs_riwayatakademik" class="IM_Mhs_riwayatakademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->riwayatakademik->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->riwayatakademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->riwayatakademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->keuangan->Visible) { // keuangan ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->keuangan) == "") { ?>
		<th data-name="keuangan" class="<?php echo $IM_Mhs_list->keuangan->headerCellClass() ?>"><div id="elh_IM_Mhs_keuangan" class="IM_Mhs_keuangan"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->keuangan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="keuangan" class="<?php echo $IM_Mhs_list->keuangan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->keuangan) ?>', 1);"><div id="elh_IM_Mhs_keuangan" class="IM_Mhs_keuangan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->keuangan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->keuangan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->keuangan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->pendukung->Visible) { // pendukung ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->pendukung) == "") { ?>
		<th data-name="pendukung" class="<?php echo $IM_Mhs_list->pendukung->headerCellClass() ?>"><div id="elh_IM_Mhs_pendukung" class="IM_Mhs_pendukung"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->pendukung->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pendukung" class="<?php echo $IM_Mhs_list->pendukung->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->pendukung) ?>', 1);"><div id="elh_IM_Mhs_pendukung" class="IM_Mhs_pendukung">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->pendukung->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->pendukung->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->pendukung->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->lainlain->Visible) { // lainlain ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->lainlain) == "") { ?>
		<th data-name="lainlain" class="<?php echo $IM_Mhs_list->lainlain->headerCellClass() ?>"><div id="elh_IM_Mhs_lainlain" class="IM_Mhs_lainlain"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->lainlain->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lainlain" class="<?php echo $IM_Mhs_list->lainlain->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->lainlain) ?>', 1);"><div id="elh_IM_Mhs_lainlain" class="IM_Mhs_lainlain">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->lainlain->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->lainlain->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->lainlain->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Mhs_list->Ferval->Visible) { // Ferval ?>
	<?php if ($IM_Mhs_list->SortUrl($IM_Mhs_list->Ferval) == "") { ?>
		<th data-name="Ferval" class="<?php echo $IM_Mhs_list->Ferval->headerCellClass() ?>"><div id="elh_IM_Mhs_Ferval" class="IM_Mhs_Ferval"><div class="ew-table-header-caption"><?php echo $IM_Mhs_list->Ferval->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ferval" class="<?php echo $IM_Mhs_list->Ferval->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Mhs_list->SortUrl($IM_Mhs_list->Ferval) ?>', 1);"><div id="elh_IM_Mhs_Ferval" class="IM_Mhs_Ferval">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Mhs_list->Ferval->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Mhs_list->Ferval->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Mhs_list->Ferval->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$IM_Mhs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($IM_Mhs_list->ExportAll && $IM_Mhs_list->isExport()) {
	$IM_Mhs_list->StopRecord = $IM_Mhs_list->TotalRecords;
} else {

	// Set the last record to display
	if ($IM_Mhs_list->TotalRecords > $IM_Mhs_list->StartRecord + $IM_Mhs_list->DisplayRecords - 1)
		$IM_Mhs_list->StopRecord = $IM_Mhs_list->StartRecord + $IM_Mhs_list->DisplayRecords - 1;
	else
		$IM_Mhs_list->StopRecord = $IM_Mhs_list->TotalRecords;
}
$IM_Mhs_list->RecordCount = $IM_Mhs_list->StartRecord - 1;
if ($IM_Mhs_list->Recordset && !$IM_Mhs_list->Recordset->EOF) {
	$IM_Mhs_list->Recordset->moveFirst();
	$selectLimit = $IM_Mhs_list->UseSelectLimit;
	if (!$selectLimit && $IM_Mhs_list->StartRecord > 1)
		$IM_Mhs_list->Recordset->move($IM_Mhs_list->StartRecord - 1);
} elseif (!$IM_Mhs->AllowAddDeleteRow && $IM_Mhs_list->StopRecord == 0) {
	$IM_Mhs_list->StopRecord = $IM_Mhs->GridAddRowCount;
}

// Initialize aggregate
$IM_Mhs->RowType = ROWTYPE_AGGREGATEINIT;
$IM_Mhs->resetAttributes();
$IM_Mhs_list->renderRow();
while ($IM_Mhs_list->RecordCount < $IM_Mhs_list->StopRecord) {
	$IM_Mhs_list->RecordCount++;
	if ($IM_Mhs_list->RecordCount >= $IM_Mhs_list->StartRecord) {
		$IM_Mhs_list->RowCount++;

		// Set up key count
		$IM_Mhs_list->KeyCount = $IM_Mhs_list->RowIndex;

		// Init row class and style
		$IM_Mhs->resetAttributes();
		$IM_Mhs->CssClass = "";
		if ($IM_Mhs_list->isGridAdd()) {
		} else {
			$IM_Mhs_list->loadRowValues($IM_Mhs_list->Recordset); // Load row values
		}
		$IM_Mhs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$IM_Mhs->RowAttrs->merge(["data-rowindex" => $IM_Mhs_list->RowCount, "id" => "r" . $IM_Mhs_list->RowCount . "_IM_Mhs", "data-rowtype" => $IM_Mhs->RowType]);

		// Render row
		$IM_Mhs_list->renderRow();

		// Render list options
		$IM_Mhs_list->renderListOptions();
?>
	<tr <?php echo $IM_Mhs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$IM_Mhs_list->ListOptions->render("body", "left", $IM_Mhs_list->RowCount);
$salt = "86458762398576twuitrweu@#UTUY&*%&****trwerutUTUYT";
$id=md5($salt . rtrim($IM_Mhs_list->Nim->getViewValue()));
?>
<td>
  <a class="btn btn-primary btn-sm" href="custom/ekpt.php?nim=<?php echo rtrim($IM_Mhs_list->Nim->getViewValue()) ?>&id=<?php echo $id; ?>" role="button" target="_blank">Riwayat</a>   
</td>
	<?php if ($IM_Mhs_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $IM_Mhs_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Nim">
<span<?php echo $IM_Mhs_list->Nim->viewAttributes() ?>><?php echo $IM_Mhs_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $IM_Mhs_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Nama_Mhs">
<span<?php echo $IM_Mhs_list->Nama_Mhs->viewAttributes() ?>><?php echo $IM_Mhs_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Tmp_Lahir->Visible) { // Tmp_Lahir ?>
		<td data-name="Tmp_Lahir" <?php echo $IM_Mhs_list->Tmp_Lahir->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Tmp_Lahir">
<span<?php echo $IM_Mhs_list->Tmp_Lahir->viewAttributes() ?>><?php echo $IM_Mhs_list->Tmp_Lahir->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Tgl_Lahir->Visible) { // Tgl_Lahir ?>
		<td data-name="Tgl_Lahir" <?php echo $IM_Mhs_list->Tgl_Lahir->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Tgl_Lahir">
<span<?php echo $IM_Mhs_list->Tgl_Lahir->viewAttributes() ?>><?php echo $IM_Mhs_list->Tgl_Lahir->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $IM_Mhs_list->Status_Akd->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Status_Akd">
<span<?php echo $IM_Mhs_list->Status_Akd->viewAttributes() ?>><?php echo $IM_Mhs_list->Status_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $IM_Mhs_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Kode_Fak">
<span<?php echo $IM_Mhs_list->Kode_Fak->viewAttributes() ?>><?php echo $IM_Mhs_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $IM_Mhs_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Kode_jp">
<span<?php echo $IM_Mhs_list->Kode_jp->viewAttributes() ?>><?php echo $IM_Mhs_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->TaMasuk->Visible) { // TaMasuk ?>
		<td data-name="TaMasuk" <?php echo $IM_Mhs_list->TaMasuk->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_TaMasuk">
<span<?php echo $IM_Mhs_list->TaMasuk->viewAttributes() ?>><?php echo $IM_Mhs_list->TaMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->PerMasuk->Visible) { // PerMasuk ?>
		<td data-name="PerMasuk" <?php echo $IM_Mhs_list->PerMasuk->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_PerMasuk">
<span<?php echo $IM_Mhs_list->PerMasuk->viewAttributes() ?>><?php echo $IM_Mhs_list->PerMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->SemesterMulai->Visible) { // SemesterMulai ?>
		<td data-name="SemesterMulai" <?php echo $IM_Mhs_list->SemesterMulai->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_SemesterMulai">
<span<?php echo $IM_Mhs_list->SemesterMulai->viewAttributes() ?>><?php echo $IM_Mhs_list->SemesterMulai->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->tglmasuk->Visible) { // tglmasuk ?>
		<td data-name="tglmasuk" <?php echo $IM_Mhs_list->tglmasuk->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_tglmasuk">
<span<?php echo $IM_Mhs_list->tglmasuk->viewAttributes() ?>><?php echo $IM_Mhs_list->tglmasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Status->Visible) { // Status ?>
		<td data-name="Status" <?php echo $IM_Mhs_list->Status->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Status">
<span<?php echo $IM_Mhs_list->Status->viewAttributes() ?>><?php echo $IM_Mhs_list->Status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->StatusAkhir->Visible) { // StatusAkhir ?>
		<td data-name="StatusAkhir" <?php echo $IM_Mhs_list->StatusAkhir->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_StatusAkhir">
<span<?php echo $IM_Mhs_list->StatusAkhir->viewAttributes() ?>><?php echo $IM_Mhs_list->StatusAkhir->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->SemesterKeluar_Lulus->Visible) { // SemesterKeluar_Lulus ?>
		<td data-name="SemesterKeluar_Lulus" <?php echo $IM_Mhs_list->SemesterKeluar_Lulus->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_SemesterKeluar_Lulus">
<span<?php echo $IM_Mhs_list->SemesterKeluar_Lulus->viewAttributes() ?>><?php echo $IM_Mhs_list->SemesterKeluar_Lulus->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Status_Masuk->Visible) { // Status_Masuk ?>
		<td data-name="Status_Masuk" <?php echo $IM_Mhs_list->Status_Masuk->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Status_Masuk">
<span<?php echo $IM_Mhs_list->Status_Masuk->viewAttributes() ?>><?php echo $IM_Mhs_list->Status_Masuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->AwalPendaftaran->Visible) { // AwalPendaftaran ?>
		<td data-name="AwalPendaftaran" <?php echo $IM_Mhs_list->AwalPendaftaran->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_AwalPendaftaran">
<span<?php echo $IM_Mhs_list->AwalPendaftaran->viewAttributes() ?>><?php echo $IM_Mhs_list->AwalPendaftaran->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Pwl->Visible) { // Pwl ?>
		<td data-name="Pwl" <?php echo $IM_Mhs_list->Pwl->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Pwl">
<span<?php echo $IM_Mhs_list->Pwl->viewAttributes() ?>><?php echo $IM_Mhs_list->Pwl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Ijazah->Visible) { // Ijazah ?>
		<td data-name="Ijazah" <?php echo $IM_Mhs_list->Ijazah->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Ijazah">
<span<?php echo $IM_Mhs_list->Ijazah->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->Ijazah->getViewValue()) && $IM_Mhs_list->Ijazah->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->Ijazah->linkAttributes() ?>><?php echo $IM_Mhs_list->Ijazah->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->Ijazah->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Ktp->Visible) { // Ktp ?>
		<td data-name="Ktp" <?php echo $IM_Mhs_list->Ktp->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Ktp">
<span<?php echo $IM_Mhs_list->Ktp->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->Ktp->getViewValue()) && $IM_Mhs_list->Ktp->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->Ktp->linkAttributes() ?>><?php echo $IM_Mhs_list->Ktp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->Ktp->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->KK->Visible) { // KK ?>
		<td data-name="KK" <?php echo $IM_Mhs_list->KK->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_KK">
<span<?php echo $IM_Mhs_list->KK->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->KK->getViewValue()) && $IM_Mhs_list->KK->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->KK->linkAttributes() ?>><?php echo $IM_Mhs_list->KK->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->KK->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->IjazahIM->Visible) { // IjazahIM ?>
		<td data-name="IjazahIM" <?php echo $IM_Mhs_list->IjazahIM->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_IjazahIM">
<span<?php echo $IM_Mhs_list->IjazahIM->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->IjazahIM->getViewValue()) && $IM_Mhs_list->IjazahIM->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->IjazahIM->linkAttributes() ?>><?php echo $IM_Mhs_list->IjazahIM->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->IjazahIM->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->TranskriptIM->Visible) { // TranskriptIM ?>
		<td data-name="TranskriptIM" <?php echo $IM_Mhs_list->TranskriptIM->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_TranskriptIM">
<span<?php echo $IM_Mhs_list->TranskriptIM->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->TranskriptIM->getViewValue()) && $IM_Mhs_list->TranskriptIM->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->TranskriptIM->linkAttributes() ?>><?php echo $IM_Mhs_list->TranskriptIM->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->TranskriptIM->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Skripsi->Visible) { // Skripsi ?>
		<td data-name="Skripsi" <?php echo $IM_Mhs_list->Skripsi->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Skripsi">
<span<?php echo $IM_Mhs_list->Skripsi->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->Skripsi->getViewValue()) && $IM_Mhs_list->Skripsi->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->Skripsi->linkAttributes() ?>><?php echo $IM_Mhs_list->Skripsi->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->Skripsi->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->TASkripsi->Visible) { // TASkripsi ?>
		<td data-name="TASkripsi" <?php echo $IM_Mhs_list->TASkripsi->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_TASkripsi">
<span<?php echo $IM_Mhs_list->TASkripsi->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->TASkripsi->getViewValue()) && $IM_Mhs_list->TASkripsi->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->TASkripsi->linkAttributes() ?>><?php echo $IM_Mhs_list->TASkripsi->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->TASkripsi->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Plagiat->Visible) { // Plagiat ?>
		<td data-name="Plagiat" <?php echo $IM_Mhs_list->Plagiat->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Plagiat">
<span<?php echo $IM_Mhs_list->Plagiat->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->Plagiat->getViewValue()) && $IM_Mhs_list->Plagiat->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->Plagiat->linkAttributes() ?>><?php echo $IM_Mhs_list->Plagiat->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->Plagiat->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->riwayatakademik->Visible) { // riwayatakademik ?>
		<td data-name="riwayatakademik" <?php echo $IM_Mhs_list->riwayatakademik->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_riwayatakademik">
<span<?php echo $IM_Mhs_list->riwayatakademik->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->riwayatakademik->getViewValue()) && $IM_Mhs_list->riwayatakademik->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->riwayatakademik->linkAttributes() ?>><?php echo $IM_Mhs_list->riwayatakademik->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->riwayatakademik->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->keuangan->Visible) { // keuangan ?>
		<td data-name="keuangan" <?php echo $IM_Mhs_list->keuangan->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_keuangan">
<span<?php echo $IM_Mhs_list->keuangan->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->keuangan->getViewValue()) && $IM_Mhs_list->keuangan->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->keuangan->linkAttributes() ?>><?php echo $IM_Mhs_list->keuangan->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->keuangan->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->pendukung->Visible) { // pendukung ?>
		<td data-name="pendukung" <?php echo $IM_Mhs_list->pendukung->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_pendukung">
<span<?php echo $IM_Mhs_list->pendukung->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->pendukung->getViewValue()) && $IM_Mhs_list->pendukung->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->pendukung->linkAttributes() ?>><?php echo $IM_Mhs_list->pendukung->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->pendukung->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->lainlain->Visible) { // lainlain ?>
		<td data-name="lainlain" <?php echo $IM_Mhs_list->lainlain->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_lainlain">
<span<?php echo $IM_Mhs_list->lainlain->viewAttributes() ?>><?php if (!EmptyString($IM_Mhs_list->lainlain->getViewValue()) && $IM_Mhs_list->lainlain->linkAttributes() != "") { ?>
<a<?php echo $IM_Mhs_list->lainlain->linkAttributes() ?>><?php echo $IM_Mhs_list->lainlain->getViewValue() ?></a>
<?php } else { ?>
<?php echo $IM_Mhs_list->lainlain->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Mhs_list->Ferval->Visible) { // Ferval ?>
		<td data-name="Ferval" <?php echo $IM_Mhs_list->Ferval->cellAttributes() ?>>
<span id="el<?php echo $IM_Mhs_list->RowCount ?>_IM_Mhs_Ferval">
<span<?php echo $IM_Mhs_list->Ferval->viewAttributes() ?>><?php echo $IM_Mhs_list->Ferval->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$IM_Mhs_list->ListOptions->render("body", "right", $IM_Mhs_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$IM_Mhs_list->isGridAdd())
		$IM_Mhs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$IM_Mhs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($IM_Mhs_list->Recordset)
	$IM_Mhs_list->Recordset->Close();
?>
<?php if (!$IM_Mhs_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$IM_Mhs_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $IM_Mhs_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $IM_Mhs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($IM_Mhs_list->TotalRecords == 0 && !$IM_Mhs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $IM_Mhs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$IM_Mhs_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$IM_Mhs_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$IM_Mhs_list->terminate();
?>