<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$IM_Periode3_list = new IM_Periode3_list();

// Run the page
$IM_Periode3_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$IM_Periode3_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$IM_Periode3_list->isExport()) { ?>
<script>
var fIM_Periode3list, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fIM_Periode3list = currentForm = new ew.Form("fIM_Periode3list", "list");
	fIM_Periode3list.formKeyCountName = '<?php echo $IM_Periode3_list->FormKeyCountName ?>';
	loadjs.done("fIM_Periode3list");
});
var fIM_Periode3listsrch;
loadjs.ready("head", function() {

	// Form object for search
	fIM_Periode3listsrch = currentSearchForm = new ew.Form("fIM_Periode3listsrch");

	// Validate function for search
	fIM_Periode3listsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";
		elm = this.getElements("x" + infix + "_TSKS");
		if (elm && !ew.checkInteger(elm.value))
			return this.onError(elm, "<?php echo JsEncode($IM_Periode3_list->TSKS->errorMessage()) ?>");

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fIM_Periode3listsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fIM_Periode3listsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fIM_Periode3listsrch.lists["x_Kode_Fak"] = <?php echo $IM_Periode3_list->Kode_Fak->Lookup->toClientList($IM_Periode3_list) ?>;
	fIM_Periode3listsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($IM_Periode3_list->Kode_Fak->lookupOptions()) ?>;
	fIM_Periode3listsrch.lists["x_Kode_jp"] = <?php echo $IM_Periode3_list->Kode_jp->Lookup->toClientList($IM_Periode3_list) ?>;
	fIM_Periode3listsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($IM_Periode3_list->Kode_jp->lookupOptions()) ?>;
	fIM_Periode3listsrch.lists["x_Thn_Akademik"] = <?php echo $IM_Periode3_list->Thn_Akademik->Lookup->toClientList($IM_Periode3_list) ?>;
	fIM_Periode3listsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($IM_Periode3_list->Thn_Akademik->lookupOptions()) ?>;
	fIM_Periode3listsrch.lists["x_Periode"] = <?php echo $IM_Periode3_list->Periode->Lookup->toClientList($IM_Periode3_list) ?>;
	fIM_Periode3listsrch.lists["x_Periode"].options = <?php echo JsonEncode($IM_Periode3_list->Periode->options(FALSE, TRUE)) ?>;

	// Filters
	fIM_Periode3listsrch.filterList = <?php echo $IM_Periode3_list->getFilterList() ?>;
	loadjs.done("fIM_Periode3listsrch");
});
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script>
loadjs.ready("head", function() {
	ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
	ew.PREVIEW_SINGLE_ROW = false;
	ew.PREVIEW_OVERLAY = false;
	loadjs("js/ewpreview.js", "preview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$IM_Periode3_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($IM_Periode3_list->TotalRecords > 0 && $IM_Periode3_list->ExportOptions->visible()) { ?>
<?php $IM_Periode3_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Periode3_list->ImportOptions->visible()) { ?>
<?php $IM_Periode3_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Periode3_list->SearchOptions->visible()) { ?>
<?php $IM_Periode3_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($IM_Periode3_list->FilterOptions->visible()) { ?>
<?php $IM_Periode3_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$IM_Periode3_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$IM_Periode3_list->isExport() && !$IM_Periode3->CurrentAction) { ?>
<form name="fIM_Periode3listsrch" id="fIM_Periode3listsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fIM_Periode3listsrch-search-panel" class="<?php echo $IM_Periode3_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="IM_Periode3">
	<div class="ew-extended-search">
<?php

// Render search row
$IM_Periode3->RowType = ROWTYPE_SEARCH;
$IM_Periode3->resetAttributes();
$IM_Periode3_list->renderRow();
?>
<?php if ($IM_Periode3_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$IM_Periode3_list->SearchColumnCount++;
		if (($IM_Periode3_list->SearchColumnCount - 1) % $IM_Periode3_list->SearchFieldsPerRow == 0) {
			$IM_Periode3_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Periode3_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $IM_Periode3_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_IM_Periode3_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Periode3" data-field="x_Kode_Fak" data-value-separator="<?php echo $IM_Periode3_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $IM_Periode3_list->Kode_Fak->editAttributes() ?>>
			<?php echo $IM_Periode3_list->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $IM_Periode3_list->Kode_Fak->Lookup->getParamTag($IM_Periode3_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($IM_Periode3_list->SearchColumnCount % $IM_Periode3_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$IM_Periode3_list->SearchColumnCount++;
		if (($IM_Periode3_list->SearchColumnCount - 1) % $IM_Periode3_list->SearchFieldsPerRow == 0) {
			$IM_Periode3_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Periode3_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $IM_Periode3_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_IM_Periode3_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Periode3" data-field="x_Kode_jp" data-value-separator="<?php echo $IM_Periode3_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $IM_Periode3_list->Kode_jp->editAttributes() ?>>
			<?php echo $IM_Periode3_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $IM_Periode3_list->Kode_jp->Lookup->getParamTag($IM_Periode3_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($IM_Periode3_list->SearchColumnCount % $IM_Periode3_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$IM_Periode3_list->SearchColumnCount++;
		if (($IM_Periode3_list->SearchColumnCount - 1) % $IM_Periode3_list->SearchFieldsPerRow == 0) {
			$IM_Periode3_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Periode3_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $IM_Periode3_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_IM_Periode3_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Periode3" data-field="x_Thn_Akademik" data-value-separator="<?php echo $IM_Periode3_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $IM_Periode3_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $IM_Periode3_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $IM_Periode3_list->Thn_Akademik->Lookup->getParamTag($IM_Periode3_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($IM_Periode3_list->SearchColumnCount % $IM_Periode3_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Periode->Visible) { // Periode ?>
	<?php
		$IM_Periode3_list->SearchColumnCount++;
		if (($IM_Periode3_list->SearchColumnCount - 1) % $IM_Periode3_list->SearchFieldsPerRow == 0) {
			$IM_Periode3_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Periode3_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $IM_Periode3_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_IM_Periode3_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IM_Periode3" data-field="x_Periode" data-value-separator="<?php echo $IM_Periode3_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $IM_Periode3_list->Periode->editAttributes() ?>>
			<?php echo $IM_Periode3_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($IM_Periode3_list->SearchColumnCount % $IM_Periode3_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->TSKS->Visible) { // TSKS ?>
	<?php
		$IM_Periode3_list->SearchColumnCount++;
		if (($IM_Periode3_list->SearchColumnCount - 1) % $IM_Periode3_list->SearchFieldsPerRow == 0) {
			$IM_Periode3_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IM_Periode3_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_TSKS" class="ew-cell form-group">
		<label for="x_TSKS" class="ew-search-caption ew-label"><?php echo $IM_Periode3_list->TSKS->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase(">=") ?>
<input type="hidden" name="z_TSKS" id="z_TSKS" value=">=">
</span>
		<span id="el_IM_Periode3_TSKS" class="ew-search-field">
<input type="text" data-table="IM_Periode3" data-field="x_TSKS" name="x_TSKS" id="x_TSKS" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($IM_Periode3_list->TSKS->getPlaceHolder()) ?>" value="<?php echo $IM_Periode3_list->TSKS->EditValue ?>"<?php echo $IM_Periode3_list->TSKS->editAttributes() ?>>
</span>
	</div>
	<?php if ($IM_Periode3_list->SearchColumnCount % $IM_Periode3_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($IM_Periode3_list->SearchColumnCount % $IM_Periode3_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $IM_Periode3_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($IM_Periode3_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($IM_Periode3_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $IM_Periode3_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($IM_Periode3_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($IM_Periode3_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($IM_Periode3_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($IM_Periode3_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $IM_Periode3_list->showPageHeader(); ?>
<?php
$IM_Periode3_list->showMessage();
?>
<?php if ($IM_Periode3_list->TotalRecords > 0 || $IM_Periode3->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($IM_Periode3_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> IM_Periode3">
<form name="fIM_Periode3list" id="fIM_Periode3list" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="IM_Periode3">
<div id="gmp_IM_Periode3" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($IM_Periode3_list->TotalRecords > 0 || $IM_Periode3_list->isGridEdit()) { ?>
<table id="tbl_IM_Periode3list" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$IM_Periode3->RowType = ROWTYPE_HEADER;

// Render list options
$IM_Periode3_list->renderListOptions();

// Render list options (header, left)
$IM_Periode3_list->ListOptions->render("header", "left");
?>
<?php if ($IM_Periode3_list->Nim->Visible) { // Nim ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $IM_Periode3_list->Nim->headerCellClass() ?>"><div id="elh_IM_Periode3_Nim" class="IM_Periode3_Nim"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $IM_Periode3_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->Nim) ?>', 1);"><div id="elh_IM_Periode3_Nim" class="IM_Periode3_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IM_Periode3_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_IM_Periode3_Nama_Mhs" class="IM_Periode3_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IM_Periode3_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->Nama_Mhs) ?>', 1);"><div id="elh_IM_Periode3_Nama_Mhs" class="IM_Periode3_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $IM_Periode3_list->Kode_Fak->headerCellClass() ?>"><div id="elh_IM_Periode3_Kode_Fak" class="IM_Periode3_Kode_Fak"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $IM_Periode3_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->Kode_Fak) ?>', 1);"><div id="elh_IM_Periode3_Kode_Fak" class="IM_Periode3_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $IM_Periode3_list->Kode_jp->headerCellClass() ?>"><div id="elh_IM_Periode3_Kode_jp" class="IM_Periode3_Kode_jp"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $IM_Periode3_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->Kode_jp) ?>', 1);"><div id="elh_IM_Periode3_Kode_jp" class="IM_Periode3_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $IM_Periode3_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_IM_Periode3_Thn_Akademik" class="IM_Periode3_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $IM_Periode3_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->Thn_Akademik) ?>', 1);"><div id="elh_IM_Periode3_Thn_Akademik" class="IM_Periode3_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Periode->Visible) { // Periode ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $IM_Periode3_list->Periode->headerCellClass() ?>"><div id="elh_IM_Periode3_Periode" class="IM_Periode3_Periode"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $IM_Periode3_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->Periode) ?>', 1);"><div id="elh_IM_Periode3_Periode" class="IM_Periode3_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->TSKS->Visible) { // TSKS ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->TSKS) == "") { ?>
		<th data-name="TSKS" class="<?php echo $IM_Periode3_list->TSKS->headerCellClass() ?>"><div id="elh_IM_Periode3_TSKS" class="IM_Periode3_TSKS"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->TSKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TSKS" class="<?php echo $IM_Periode3_list->TSKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->TSKS) ?>', 1);"><div id="elh_IM_Periode3_TSKS" class="IM_Periode3_TSKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->TSKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->TSKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->TSKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Alamat->Visible) { // Alamat ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->Alamat) == "") { ?>
		<th data-name="Alamat" class="<?php echo $IM_Periode3_list->Alamat->headerCellClass() ?>"><div id="elh_IM_Periode3_Alamat" class="IM_Periode3_Alamat"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->Alamat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Alamat" class="<?php echo $IM_Periode3_list->Alamat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->Alamat) ?>', 1);"><div id="elh_IM_Periode3_Alamat" class="IM_Periode3_Alamat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->Alamat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->Alamat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->Alamat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->Telepon->Visible) { // Telepon ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->Telepon) == "") { ?>
		<th data-name="Telepon" class="<?php echo $IM_Periode3_list->Telepon->headerCellClass() ?>"><div id="elh_IM_Periode3_Telepon" class="IM_Periode3_Telepon"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->Telepon->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Telepon" class="<?php echo $IM_Periode3_list->Telepon->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->Telepon) ?>', 1);"><div id="elh_IM_Periode3_Telepon" class="IM_Periode3_Telepon">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->Telepon->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->Telepon->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->Telepon->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IM_Periode3_list->_Email->Visible) { // Email ?>
	<?php if ($IM_Periode3_list->SortUrl($IM_Periode3_list->_Email) == "") { ?>
		<th data-name="_Email" class="<?php echo $IM_Periode3_list->_Email->headerCellClass() ?>"><div id="elh_IM_Periode3__Email" class="IM_Periode3__Email"><div class="ew-table-header-caption"><?php echo $IM_Periode3_list->_Email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Email" class="<?php echo $IM_Periode3_list->_Email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IM_Periode3_list->SortUrl($IM_Periode3_list->_Email) ?>', 1);"><div id="elh_IM_Periode3__Email" class="IM_Periode3__Email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IM_Periode3_list->_Email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IM_Periode3_list->_Email->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IM_Periode3_list->_Email->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$IM_Periode3_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($IM_Periode3_list->ExportAll && $IM_Periode3_list->isExport()) {
	$IM_Periode3_list->StopRecord = $IM_Periode3_list->TotalRecords;
} else {

	// Set the last record to display
	if ($IM_Periode3_list->TotalRecords > $IM_Periode3_list->StartRecord + $IM_Periode3_list->DisplayRecords - 1)
		$IM_Periode3_list->StopRecord = $IM_Periode3_list->StartRecord + $IM_Periode3_list->DisplayRecords - 1;
	else
		$IM_Periode3_list->StopRecord = $IM_Periode3_list->TotalRecords;
}
$IM_Periode3_list->RecordCount = $IM_Periode3_list->StartRecord - 1;
if ($IM_Periode3_list->Recordset && !$IM_Periode3_list->Recordset->EOF) {
	$IM_Periode3_list->Recordset->moveFirst();
	$selectLimit = $IM_Periode3_list->UseSelectLimit;
	if (!$selectLimit && $IM_Periode3_list->StartRecord > 1)
		$IM_Periode3_list->Recordset->move($IM_Periode3_list->StartRecord - 1);
} elseif (!$IM_Periode3->AllowAddDeleteRow && $IM_Periode3_list->StopRecord == 0) {
	$IM_Periode3_list->StopRecord = $IM_Periode3->GridAddRowCount;
}

// Initialize aggregate
$IM_Periode3->RowType = ROWTYPE_AGGREGATEINIT;
$IM_Periode3->resetAttributes();
$IM_Periode3_list->renderRow();
while ($IM_Periode3_list->RecordCount < $IM_Periode3_list->StopRecord) {
	$IM_Periode3_list->RecordCount++;
	if ($IM_Periode3_list->RecordCount >= $IM_Periode3_list->StartRecord) {
		$IM_Periode3_list->RowCount++;

		// Set up key count
		$IM_Periode3_list->KeyCount = $IM_Periode3_list->RowIndex;

		// Init row class and style
		$IM_Periode3->resetAttributes();
		$IM_Periode3->CssClass = "";
		if ($IM_Periode3_list->isGridAdd()) {
		} else {
			$IM_Periode3_list->loadRowValues($IM_Periode3_list->Recordset); // Load row values
		}
		$IM_Periode3->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$IM_Periode3->RowAttrs->merge(["data-rowindex" => $IM_Periode3_list->RowCount, "id" => "r" . $IM_Periode3_list->RowCount . "_IM_Periode3", "data-rowtype" => $IM_Periode3->RowType]);

		// Render row
		$IM_Periode3_list->renderRow();

		// Render list options
		$IM_Periode3_list->renderListOptions();
?>
	<tr <?php echo $IM_Periode3->rowAttributes() ?>>
<?php

// Render list options (body, left)
$IM_Periode3_list->ListOptions->render("body", "left", $IM_Periode3_list->RowCount);
?>
	<?php if ($IM_Periode3_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $IM_Periode3_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_Nim">
<span<?php echo $IM_Periode3_list->Nim->viewAttributes() ?>><?php echo $IM_Periode3_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $IM_Periode3_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_Nama_Mhs">
<span<?php echo $IM_Periode3_list->Nama_Mhs->viewAttributes() ?>><?php echo $IM_Periode3_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $IM_Periode3_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_Kode_Fak">
<span<?php echo $IM_Periode3_list->Kode_Fak->viewAttributes() ?>><?php echo $IM_Periode3_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $IM_Periode3_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_Kode_jp">
<span<?php echo $IM_Periode3_list->Kode_jp->viewAttributes() ?>><?php echo $IM_Periode3_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $IM_Periode3_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_Thn_Akademik">
<span<?php echo $IM_Periode3_list->Thn_Akademik->viewAttributes() ?>><?php echo $IM_Periode3_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $IM_Periode3_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_Periode">
<span<?php echo $IM_Periode3_list->Periode->viewAttributes() ?>><?php echo $IM_Periode3_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->TSKS->Visible) { // TSKS ?>
		<td data-name="TSKS" <?php echo $IM_Periode3_list->TSKS->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_TSKS">
<span<?php echo $IM_Periode3_list->TSKS->viewAttributes() ?>><?php echo $IM_Periode3_list->TSKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->Alamat->Visible) { // Alamat ?>
		<td data-name="Alamat" <?php echo $IM_Periode3_list->Alamat->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_Alamat">
<span<?php echo $IM_Periode3_list->Alamat->viewAttributes() ?>><?php echo $IM_Periode3_list->Alamat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->Telepon->Visible) { // Telepon ?>
		<td data-name="Telepon" <?php echo $IM_Periode3_list->Telepon->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3_Telepon">
<span<?php echo $IM_Periode3_list->Telepon->viewAttributes() ?>><?php echo $IM_Periode3_list->Telepon->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IM_Periode3_list->_Email->Visible) { // Email ?>
		<td data-name="_Email" <?php echo $IM_Periode3_list->_Email->cellAttributes() ?>>
<span id="el<?php echo $IM_Periode3_list->RowCount ?>_IM_Periode3__Email">
<span<?php echo $IM_Periode3_list->_Email->viewAttributes() ?>><?php echo $IM_Periode3_list->_Email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$IM_Periode3_list->ListOptions->render("body", "right", $IM_Periode3_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$IM_Periode3_list->isGridAdd())
		$IM_Periode3_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$IM_Periode3->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($IM_Periode3_list->Recordset)
	$IM_Periode3_list->Recordset->Close();
?>
<?php if (!$IM_Periode3_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$IM_Periode3_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $IM_Periode3_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $IM_Periode3_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($IM_Periode3_list->TotalRecords == 0 && !$IM_Periode3->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $IM_Periode3_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$IM_Periode3_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$IM_Periode3_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$IM_Periode3_list->terminate();
?>