<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$IPSIPK_list = new IPSIPK_list();

// Run the page
$IPSIPK_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$IPSIPK_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$IPSIPK_list->isExport()) { ?>
<script>
var fIPSIPKlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fIPSIPKlist = currentForm = new ew.Form("fIPSIPKlist", "list");
	fIPSIPKlist.formKeyCountName = '<?php echo $IPSIPK_list->FormKeyCountName ?>';
	loadjs.done("fIPSIPKlist");
});
var fIPSIPKlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fIPSIPKlistsrch = currentSearchForm = new ew.Form("fIPSIPKlistsrch");

	// Validate function for search
	fIPSIPKlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fIPSIPKlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fIPSIPKlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fIPSIPKlistsrch.lists["x_Thn_Akademik"] = <?php echo $IPSIPK_list->Thn_Akademik->Lookup->toClientList($IPSIPK_list) ?>;
	fIPSIPKlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($IPSIPK_list->Thn_Akademik->lookupOptions()) ?>;
	fIPSIPKlistsrch.lists["x_Periode"] = <?php echo $IPSIPK_list->Periode->Lookup->toClientList($IPSIPK_list) ?>;
	fIPSIPKlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($IPSIPK_list->Periode->options(FALSE, TRUE)) ?>;
	fIPSIPKlistsrch.lists["x_Kode_jp"] = <?php echo $IPSIPK_list->Kode_jp->Lookup->toClientList($IPSIPK_list) ?>;
	fIPSIPKlistsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($IPSIPK_list->Kode_jp->lookupOptions()) ?>;
	fIPSIPKlistsrch.lists["x_Status_Akd"] = <?php echo $IPSIPK_list->Status_Akd->Lookup->toClientList($IPSIPK_list) ?>;
	fIPSIPKlistsrch.lists["x_Status_Akd"].options = <?php echo JsonEncode($IPSIPK_list->Status_Akd->lookupOptions()) ?>;

	// Filters
	fIPSIPKlistsrch.filterList = <?php echo $IPSIPK_list->getFilterList() ?>;
	loadjs.done("fIPSIPKlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$IPSIPK_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($IPSIPK_list->TotalRecords > 0 && $IPSIPK_list->ExportOptions->visible()) { ?>
<?php $IPSIPK_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($IPSIPK_list->ImportOptions->visible()) { ?>
<?php $IPSIPK_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($IPSIPK_list->SearchOptions->visible()) { ?>
<?php $IPSIPK_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($IPSIPK_list->FilterOptions->visible()) { ?>
<?php $IPSIPK_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$IPSIPK_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$IPSIPK_list->isExport() && !$IPSIPK->CurrentAction) { ?>
<form name="fIPSIPKlistsrch" id="fIPSIPKlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fIPSIPKlistsrch-search-panel" class="<?php echo $IPSIPK_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="IPSIPK">
	<div class="ew-extended-search">
<?php

// Render search row
$IPSIPK->RowType = ROWTYPE_SEARCH;
$IPSIPK->resetAttributes();
$IPSIPK_list->renderRow();
?>
<?php if ($IPSIPK_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$IPSIPK_list->SearchColumnCount++;
		if (($IPSIPK_list->SearchColumnCount - 1) % $IPSIPK_list->SearchFieldsPerRow == 0) {
			$IPSIPK_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IPSIPK_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $IPSIPK_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_IPSIPK_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IPSIPK" data-field="x_Thn_Akademik" data-value-separator="<?php echo $IPSIPK_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $IPSIPK_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $IPSIPK_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $IPSIPK_list->Thn_Akademik->Lookup->getParamTag($IPSIPK_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($IPSIPK_list->SearchColumnCount % $IPSIPK_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Periode->Visible) { // Periode ?>
	<?php
		$IPSIPK_list->SearchColumnCount++;
		if (($IPSIPK_list->SearchColumnCount - 1) % $IPSIPK_list->SearchFieldsPerRow == 0) {
			$IPSIPK_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IPSIPK_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $IPSIPK_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_IPSIPK_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IPSIPK" data-field="x_Periode" data-value-separator="<?php echo $IPSIPK_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $IPSIPK_list->Periode->editAttributes() ?>>
			<?php echo $IPSIPK_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($IPSIPK_list->SearchColumnCount % $IPSIPK_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$IPSIPK_list->SearchColumnCount++;
		if (($IPSIPK_list->SearchColumnCount - 1) % $IPSIPK_list->SearchFieldsPerRow == 0) {
			$IPSIPK_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IPSIPK_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $IPSIPK_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_IPSIPK_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IPSIPK" data-field="x_Kode_jp" data-value-separator="<?php echo $IPSIPK_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $IPSIPK_list->Kode_jp->editAttributes() ?>>
			<?php echo $IPSIPK_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $IPSIPK_list->Kode_jp->Lookup->getParamTag($IPSIPK_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($IPSIPK_list->SearchColumnCount % $IPSIPK_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php
		$IPSIPK_list->SearchColumnCount++;
		if (($IPSIPK_list->SearchColumnCount - 1) % $IPSIPK_list->SearchFieldsPerRow == 0) {
			$IPSIPK_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $IPSIPK_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Akd" class="ew-cell form-group">
		<label for="x_Status_Akd" class="ew-search-caption ew-label"><?php echo $IPSIPK_list->Status_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Akd" id="z_Status_Akd" value="LIKE">
</span>
		<span id="el_IPSIPK_Status_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="IPSIPK" data-field="x_Status_Akd" data-value-separator="<?php echo $IPSIPK_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $IPSIPK_list->Status_Akd->editAttributes() ?>>
			<?php echo $IPSIPK_list->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $IPSIPK_list->Status_Akd->Lookup->getParamTag($IPSIPK_list, "p_x_Status_Akd") ?>
</span>
	</div>
	<?php if ($IPSIPK_list->SearchColumnCount % $IPSIPK_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($IPSIPK_list->SearchColumnCount % $IPSIPK_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $IPSIPK_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($IPSIPK_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($IPSIPK_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $IPSIPK_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($IPSIPK_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($IPSIPK_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($IPSIPK_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($IPSIPK_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $IPSIPK_list->showPageHeader(); ?>
<?php
$IPSIPK_list->showMessage();
?>
<?php if ($IPSIPK_list->TotalRecords > 0 || $IPSIPK->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($IPSIPK_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> IPSIPK">
<form name="fIPSIPKlist" id="fIPSIPKlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="IPSIPK">
<div id="gmp_IPSIPK" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($IPSIPK_list->TotalRecords > 0 || $IPSIPK_list->isGridEdit()) { ?>
<table id="tbl_IPSIPKlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$IPSIPK->RowType = ROWTYPE_HEADER;

// Render list options
$IPSIPK_list->renderListOptions();

// Render list options (header, left)
$IPSIPK_list->ListOptions->render("header", "left");
?>
<?php if ($IPSIPK_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $IPSIPK_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_IPSIPK_Thn_Akademik" class="IPSIPK_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $IPSIPK_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->Thn_Akademik) ?>', 1);"><div id="elh_IPSIPK_Thn_Akademik" class="IPSIPK_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Periode->Visible) { // Periode ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $IPSIPK_list->Periode->headerCellClass() ?>"><div id="elh_IPSIPK_Periode" class="IPSIPK_Periode"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $IPSIPK_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->Periode) ?>', 1);"><div id="elh_IPSIPK_Periode" class="IPSIPK_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $IPSIPK_list->Kode_jp->headerCellClass() ?>"><div id="elh_IPSIPK_Kode_jp" class="IPSIPK_Kode_jp"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $IPSIPK_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->Kode_jp) ?>', 1);"><div id="elh_IPSIPK_Kode_jp" class="IPSIPK_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $IPSIPK_list->Status_Akd->headerCellClass() ?>"><div id="elh_IPSIPK_Status_Akd" class="IPSIPK_Status_Akd"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $IPSIPK_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->Status_Akd) ?>', 1);"><div id="elh_IPSIPK_Status_Akd" class="IPSIPK_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Nim->Visible) { // Nim ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $IPSIPK_list->Nim->headerCellClass() ?>"><div id="elh_IPSIPK_Nim" class="IPSIPK_Nim"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $IPSIPK_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->Nim) ?>', 1);"><div id="elh_IPSIPK_Nim" class="IPSIPK_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IPSIPK_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_IPSIPK_Nama_Mhs" class="IPSIPK_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $IPSIPK_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->Nama_Mhs) ?>', 1);"><div id="elh_IPSIPK_Nama_Mhs" class="IPSIPK_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->ThMasuk->Visible) { // ThMasuk ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->ThMasuk) == "") { ?>
		<th data-name="ThMasuk" class="<?php echo $IPSIPK_list->ThMasuk->headerCellClass() ?>"><div id="elh_IPSIPK_ThMasuk" class="IPSIPK_ThMasuk"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->ThMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ThMasuk" class="<?php echo $IPSIPK_list->ThMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->ThMasuk) ?>', 1);"><div id="elh_IPSIPK_ThMasuk" class="IPSIPK_ThMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->ThMasuk->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->ThMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->ThMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->TSKS->Visible) { // TSKS ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->TSKS) == "") { ?>
		<th data-name="TSKS" class="<?php echo $IPSIPK_list->TSKS->headerCellClass() ?>"><div id="elh_IPSIPK_TSKS" class="IPSIPK_TSKS"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->TSKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TSKS" class="<?php echo $IPSIPK_list->TSKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->TSKS) ?>', 1);"><div id="elh_IPSIPK_TSKS" class="IPSIPK_TSKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->TSKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->TSKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->TSKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->ips->Visible) { // ips ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->ips) == "") { ?>
		<th data-name="ips" class="<?php echo $IPSIPK_list->ips->headerCellClass() ?>"><div id="elh_IPSIPK_ips" class="IPSIPK_ips"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->ips->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ips" class="<?php echo $IPSIPK_list->ips->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->ips) ?>', 1);"><div id="elh_IPSIPK_ips" class="IPSIPK_ips">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->ips->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->ips->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->ips->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->TTSKS->Visible) { // TTSKS ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->TTSKS) == "") { ?>
		<th data-name="TTSKS" class="<?php echo $IPSIPK_list->TTSKS->headerCellClass() ?>"><div id="elh_IPSIPK_TTSKS" class="IPSIPK_TTSKS"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->TTSKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TTSKS" class="<?php echo $IPSIPK_list->TTSKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->TTSKS) ?>', 1);"><div id="elh_IPSIPK_TTSKS" class="IPSIPK_TTSKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->TTSKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->TTSKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->TTSKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->IPK->Visible) { // IPK ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->IPK) == "") { ?>
		<th data-name="IPK" class="<?php echo $IPSIPK_list->IPK->headerCellClass() ?>"><div id="elh_IPSIPK_IPK" class="IPSIPK_IPK"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->IPK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IPK" class="<?php echo $IPSIPK_list->IPK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->IPK) ?>', 1);"><div id="elh_IPSIPK_IPK" class="IPSIPK_IPK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->IPK->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->IPK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->IPK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($IPSIPK_list->Biaya->Visible) { // Biaya ?>
	<?php if ($IPSIPK_list->SortUrl($IPSIPK_list->Biaya) == "") { ?>
		<th data-name="Biaya" class="<?php echo $IPSIPK_list->Biaya->headerCellClass() ?>"><div id="elh_IPSIPK_Biaya" class="IPSIPK_Biaya"><div class="ew-table-header-caption"><?php echo $IPSIPK_list->Biaya->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Biaya" class="<?php echo $IPSIPK_list->Biaya->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $IPSIPK_list->SortUrl($IPSIPK_list->Biaya) ?>', 1);"><div id="elh_IPSIPK_Biaya" class="IPSIPK_Biaya">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $IPSIPK_list->Biaya->caption() ?></span><span class="ew-table-header-sort"><?php if ($IPSIPK_list->Biaya->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($IPSIPK_list->Biaya->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$IPSIPK_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($IPSIPK_list->ExportAll && $IPSIPK_list->isExport()) {
	$IPSIPK_list->StopRecord = $IPSIPK_list->TotalRecords;
} else {

	// Set the last record to display
	if ($IPSIPK_list->TotalRecords > $IPSIPK_list->StartRecord + $IPSIPK_list->DisplayRecords - 1)
		$IPSIPK_list->StopRecord = $IPSIPK_list->StartRecord + $IPSIPK_list->DisplayRecords - 1;
	else
		$IPSIPK_list->StopRecord = $IPSIPK_list->TotalRecords;
}
$IPSIPK_list->RecordCount = $IPSIPK_list->StartRecord - 1;
if ($IPSIPK_list->Recordset && !$IPSIPK_list->Recordset->EOF) {
	$IPSIPK_list->Recordset->moveFirst();
	$selectLimit = $IPSIPK_list->UseSelectLimit;
	if (!$selectLimit && $IPSIPK_list->StartRecord > 1)
		$IPSIPK_list->Recordset->move($IPSIPK_list->StartRecord - 1);
} elseif (!$IPSIPK->AllowAddDeleteRow && $IPSIPK_list->StopRecord == 0) {
	$IPSIPK_list->StopRecord = $IPSIPK->GridAddRowCount;
}

// Initialize aggregate
$IPSIPK->RowType = ROWTYPE_AGGREGATEINIT;
$IPSIPK->resetAttributes();
$IPSIPK_list->renderRow();
while ($IPSIPK_list->RecordCount < $IPSIPK_list->StopRecord) {
	$IPSIPK_list->RecordCount++;
	if ($IPSIPK_list->RecordCount >= $IPSIPK_list->StartRecord) {
		$IPSIPK_list->RowCount++;

		// Set up key count
		$IPSIPK_list->KeyCount = $IPSIPK_list->RowIndex;

		// Init row class and style
		$IPSIPK->resetAttributes();
		$IPSIPK->CssClass = "";
		if ($IPSIPK_list->isGridAdd()) {
		} else {
			$IPSIPK_list->loadRowValues($IPSIPK_list->Recordset); // Load row values
		}
		$IPSIPK->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$IPSIPK->RowAttrs->merge(["data-rowindex" => $IPSIPK_list->RowCount, "id" => "r" . $IPSIPK_list->RowCount . "_IPSIPK", "data-rowtype" => $IPSIPK->RowType]);

		// Render row
		$IPSIPK_list->renderRow();

		// Render list options
		$IPSIPK_list->renderListOptions();
?>
	<tr <?php echo $IPSIPK->rowAttributes() ?>>
<?php

// Render list options (body, left)
$IPSIPK_list->ListOptions->render("body", "left", $IPSIPK_list->RowCount);
?>
	<?php if ($IPSIPK_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $IPSIPK_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_Thn_Akademik">
<span<?php echo $IPSIPK_list->Thn_Akademik->viewAttributes() ?>><?php echo $IPSIPK_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $IPSIPK_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_Periode">
<span<?php echo $IPSIPK_list->Periode->viewAttributes() ?>><?php echo $IPSIPK_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $IPSIPK_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_Kode_jp">
<span<?php echo $IPSIPK_list->Kode_jp->viewAttributes() ?>><?php echo $IPSIPK_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $IPSIPK_list->Status_Akd->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_Status_Akd">
<span<?php echo $IPSIPK_list->Status_Akd->viewAttributes() ?>><?php echo $IPSIPK_list->Status_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $IPSIPK_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_Nim">
<span<?php echo $IPSIPK_list->Nim->viewAttributes() ?>><?php echo $IPSIPK_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $IPSIPK_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_Nama_Mhs">
<span<?php echo $IPSIPK_list->Nama_Mhs->viewAttributes() ?>><?php echo $IPSIPK_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->ThMasuk->Visible) { // ThMasuk ?>
		<td data-name="ThMasuk" <?php echo $IPSIPK_list->ThMasuk->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_ThMasuk">
<span<?php echo $IPSIPK_list->ThMasuk->viewAttributes() ?>><?php echo $IPSIPK_list->ThMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->TSKS->Visible) { // TSKS ?>
		<td data-name="TSKS" <?php echo $IPSIPK_list->TSKS->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_TSKS">
<span<?php echo $IPSIPK_list->TSKS->viewAttributes() ?>><?php echo $IPSIPK_list->TSKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->ips->Visible) { // ips ?>
		<td data-name="ips" <?php echo $IPSIPK_list->ips->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_ips">
<span<?php echo $IPSIPK_list->ips->viewAttributes() ?>><?php echo $IPSIPK_list->ips->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->TTSKS->Visible) { // TTSKS ?>
		<td data-name="TTSKS" <?php echo $IPSIPK_list->TTSKS->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_TTSKS">
<span<?php echo $IPSIPK_list->TTSKS->viewAttributes() ?>><?php echo $IPSIPK_list->TTSKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->IPK->Visible) { // IPK ?>
		<td data-name="IPK" <?php echo $IPSIPK_list->IPK->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_IPK">
<span<?php echo $IPSIPK_list->IPK->viewAttributes() ?>><?php echo $IPSIPK_list->IPK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($IPSIPK_list->Biaya->Visible) { // Biaya ?>
		<td data-name="Biaya" <?php echo $IPSIPK_list->Biaya->cellAttributes() ?>>
<span id="el<?php echo $IPSIPK_list->RowCount ?>_IPSIPK_Biaya">
<span<?php echo $IPSIPK_list->Biaya->viewAttributes() ?>><?php echo $IPSIPK_list->Biaya->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$IPSIPK_list->ListOptions->render("body", "right", $IPSIPK_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$IPSIPK_list->isGridAdd())
		$IPSIPK_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$IPSIPK->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($IPSIPK_list->Recordset)
	$IPSIPK_list->Recordset->Close();
?>
<?php if (!$IPSIPK_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$IPSIPK_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $IPSIPK_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $IPSIPK_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($IPSIPK_list->TotalRecords == 0 && !$IPSIPK->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $IPSIPK_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$IPSIPK_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$IPSIPK_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$IPSIPK_list->terminate();
?>