<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$PMB_Doc_add = new PMB_Doc_add();

// Run the page
$PMB_Doc_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$PMB_Doc_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fPMB_Docadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fPMB_Docadd = currentForm = new ew.Form("fPMB_Docadd", "add");

	// Validate form
	fPMB_Docadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($PMB_Doc_add->JudulDoc->Required) { ?>
				elm = this.getElements("x" + infix + "_JudulDoc");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $PMB_Doc_add->JudulDoc->caption(), $PMB_Doc_add->JudulDoc->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($PMB_Doc_add->IdKelompok->Required) { ?>
				elm = this.getElements("x" + infix + "_IdKelompok");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $PMB_Doc_add->IdKelompok->caption(), $PMB_Doc_add->IdKelompok->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($PMB_Doc_add->Tanggal->Required) { ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $PMB_Doc_add->Tanggal->caption(), $PMB_Doc_add->Tanggal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($PMB_Doc_add->Tanggal->errorMessage()) ?>");
			<?php if ($PMB_Doc_add->Catatan->Required) { ?>
				elm = this.getElements("x" + infix + "_Catatan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $PMB_Doc_add->Catatan->caption(), $PMB_Doc_add->Catatan->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fPMB_Docadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fPMB_Docadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fPMB_Docadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $PMB_Doc_add->showPageHeader(); ?>
<?php
$PMB_Doc_add->showMessage();
?>
<form name="fPMB_Docadd" id="fPMB_Docadd" class="<?php echo $PMB_Doc_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="PMB_Doc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$PMB_Doc_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($PMB_Doc_add->JudulDoc->Visible) { // JudulDoc ?>
	<div id="r_JudulDoc" class="form-group row">
		<label id="elh_PMB_Doc_JudulDoc" for="x_JudulDoc" class="<?php echo $PMB_Doc_add->LeftColumnClass ?>"><?php echo $PMB_Doc_add->JudulDoc->caption() ?><?php echo $PMB_Doc_add->JudulDoc->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $PMB_Doc_add->RightColumnClass ?>"><div <?php echo $PMB_Doc_add->JudulDoc->cellAttributes() ?>>
<span id="el_PMB_Doc_JudulDoc">
<input type="text" data-table="PMB_Doc" data-field="x_JudulDoc" name="x_JudulDoc" id="x_JudulDoc" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($PMB_Doc_add->JudulDoc->getPlaceHolder()) ?>" value="<?php echo $PMB_Doc_add->JudulDoc->EditValue ?>"<?php echo $PMB_Doc_add->JudulDoc->editAttributes() ?>>
</span>
<?php echo $PMB_Doc_add->JudulDoc->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($PMB_Doc_add->IdKelompok->Visible) { // IdKelompok ?>
	<div id="r_IdKelompok" class="form-group row">
		<label id="elh_PMB_Doc_IdKelompok" for="x_IdKelompok" class="<?php echo $PMB_Doc_add->LeftColumnClass ?>"><?php echo $PMB_Doc_add->IdKelompok->caption() ?><?php echo $PMB_Doc_add->IdKelompok->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $PMB_Doc_add->RightColumnClass ?>"><div <?php echo $PMB_Doc_add->IdKelompok->cellAttributes() ?>>
<span id="el_PMB_Doc_IdKelompok">
<input type="text" data-table="PMB_Doc" data-field="x_IdKelompok" name="x_IdKelompok" id="x_IdKelompok" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($PMB_Doc_add->IdKelompok->getPlaceHolder()) ?>" value="<?php echo $PMB_Doc_add->IdKelompok->EditValue ?>"<?php echo $PMB_Doc_add->IdKelompok->editAttributes() ?>>
</span>
<?php echo $PMB_Doc_add->IdKelompok->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($PMB_Doc_add->Tanggal->Visible) { // Tanggal ?>
	<div id="r_Tanggal" class="form-group row">
		<label id="elh_PMB_Doc_Tanggal" for="x_Tanggal" class="<?php echo $PMB_Doc_add->LeftColumnClass ?>"><?php echo $PMB_Doc_add->Tanggal->caption() ?><?php echo $PMB_Doc_add->Tanggal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $PMB_Doc_add->RightColumnClass ?>"><div <?php echo $PMB_Doc_add->Tanggal->cellAttributes() ?>>
<span id="el_PMB_Doc_Tanggal">
<input type="text" data-table="PMB_Doc" data-field="x_Tanggal" name="x_Tanggal" id="x_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($PMB_Doc_add->Tanggal->getPlaceHolder()) ?>" value="<?php echo $PMB_Doc_add->Tanggal->EditValue ?>"<?php echo $PMB_Doc_add->Tanggal->editAttributes() ?>>
<?php if (!$PMB_Doc_add->Tanggal->ReadOnly && !$PMB_Doc_add->Tanggal->Disabled && !isset($PMB_Doc_add->Tanggal->EditAttrs["readonly"]) && !isset($PMB_Doc_add->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fPMB_Docadd", "datetimepicker"], function() {
	ew.createDateTimePicker("fPMB_Docadd", "x_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $PMB_Doc_add->Tanggal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($PMB_Doc_add->Catatan->Visible) { // Catatan ?>
	<div id="r_Catatan" class="form-group row">
		<label id="elh_PMB_Doc_Catatan" for="x_Catatan" class="<?php echo $PMB_Doc_add->LeftColumnClass ?>"><?php echo $PMB_Doc_add->Catatan->caption() ?><?php echo $PMB_Doc_add->Catatan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $PMB_Doc_add->RightColumnClass ?>"><div <?php echo $PMB_Doc_add->Catatan->cellAttributes() ?>>
<span id="el_PMB_Doc_Catatan">
<input type="text" data-table="PMB_Doc" data-field="x_Catatan" name="x_Catatan" id="x_Catatan" size="30" placeholder="<?php echo HtmlEncode($PMB_Doc_add->Catatan->getPlaceHolder()) ?>" value="<?php echo $PMB_Doc_add->Catatan->EditValue ?>"<?php echo $PMB_Doc_add->Catatan->editAttributes() ?>>
</span>
<?php echo $PMB_Doc_add->Catatan->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$PMB_Doc_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $PMB_Doc_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $PMB_Doc_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$PMB_Doc_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$PMB_Doc_add->terminate();
?>