<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$PMB_Doc_list = new PMB_Doc_list();

// Run the page
$PMB_Doc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$PMB_Doc_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$PMB_Doc_list->isExport()) { ?>
<script>
var fPMB_Doclist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fPMB_Doclist = currentForm = new ew.Form("fPMB_Doclist", "list");
	fPMB_Doclist.formKeyCountName = '<?php echo $PMB_Doc_list->FormKeyCountName ?>';
	loadjs.done("fPMB_Doclist");
});
var fPMB_Doclistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fPMB_Doclistsrch = currentSearchForm = new ew.Form("fPMB_Doclistsrch");

	// Dynamic selection lists
	// Filters

	fPMB_Doclistsrch.filterList = <?php echo $PMB_Doc_list->getFilterList() ?>;
	loadjs.done("fPMB_Doclistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$PMB_Doc_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($PMB_Doc_list->TotalRecords > 0 && $PMB_Doc_list->ExportOptions->visible()) { ?>
<?php $PMB_Doc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($PMB_Doc_list->ImportOptions->visible()) { ?>
<?php $PMB_Doc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($PMB_Doc_list->SearchOptions->visible()) { ?>
<?php $PMB_Doc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($PMB_Doc_list->FilterOptions->visible()) { ?>
<?php $PMB_Doc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$PMB_Doc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$PMB_Doc_list->isExport() && !$PMB_Doc->CurrentAction) { ?>
<form name="fPMB_Doclistsrch" id="fPMB_Doclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fPMB_Doclistsrch-search-panel" class="<?php echo $PMB_Doc_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="PMB_Doc">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $PMB_Doc_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($PMB_Doc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($PMB_Doc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $PMB_Doc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($PMB_Doc_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($PMB_Doc_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($PMB_Doc_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($PMB_Doc_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $PMB_Doc_list->showPageHeader(); ?>
<?php
$PMB_Doc_list->showMessage();
?>
<?php if ($PMB_Doc_list->TotalRecords > 0 || $PMB_Doc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($PMB_Doc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> PMB_Doc">
<form name="fPMB_Doclist" id="fPMB_Doclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="PMB_Doc">
<div id="gmp_PMB_Doc" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($PMB_Doc_list->TotalRecords > 0 || $PMB_Doc_list->isGridEdit()) { ?>
<table id="tbl_PMB_Doclist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$PMB_Doc->RowType = ROWTYPE_HEADER;

// Render list options
$PMB_Doc_list->renderListOptions();

// Render list options (header, left)
$PMB_Doc_list->ListOptions->render("header", "left");
?>
<?php if ($PMB_Doc_list->idDoc->Visible) { // idDoc ?>
	<?php if ($PMB_Doc_list->SortUrl($PMB_Doc_list->idDoc) == "") { ?>
		<th data-name="idDoc" class="<?php echo $PMB_Doc_list->idDoc->headerCellClass() ?>"><div id="elh_PMB_Doc_idDoc" class="PMB_Doc_idDoc"><div class="ew-table-header-caption"><?php echo $PMB_Doc_list->idDoc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idDoc" class="<?php echo $PMB_Doc_list->idDoc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $PMB_Doc_list->SortUrl($PMB_Doc_list->idDoc) ?>', 1);"><div id="elh_PMB_Doc_idDoc" class="PMB_Doc_idDoc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $PMB_Doc_list->idDoc->caption() ?></span><span class="ew-table-header-sort"><?php if ($PMB_Doc_list->idDoc->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($PMB_Doc_list->idDoc->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($PMB_Doc_list->JudulDoc->Visible) { // JudulDoc ?>
	<?php if ($PMB_Doc_list->SortUrl($PMB_Doc_list->JudulDoc) == "") { ?>
		<th data-name="JudulDoc" class="<?php echo $PMB_Doc_list->JudulDoc->headerCellClass() ?>"><div id="elh_PMB_Doc_JudulDoc" class="PMB_Doc_JudulDoc"><div class="ew-table-header-caption"><?php echo $PMB_Doc_list->JudulDoc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JudulDoc" class="<?php echo $PMB_Doc_list->JudulDoc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $PMB_Doc_list->SortUrl($PMB_Doc_list->JudulDoc) ?>', 1);"><div id="elh_PMB_Doc_JudulDoc" class="PMB_Doc_JudulDoc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $PMB_Doc_list->JudulDoc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($PMB_Doc_list->JudulDoc->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($PMB_Doc_list->JudulDoc->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($PMB_Doc_list->IdKelompok->Visible) { // IdKelompok ?>
	<?php if ($PMB_Doc_list->SortUrl($PMB_Doc_list->IdKelompok) == "") { ?>
		<th data-name="IdKelompok" class="<?php echo $PMB_Doc_list->IdKelompok->headerCellClass() ?>"><div id="elh_PMB_Doc_IdKelompok" class="PMB_Doc_IdKelompok"><div class="ew-table-header-caption"><?php echo $PMB_Doc_list->IdKelompok->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IdKelompok" class="<?php echo $PMB_Doc_list->IdKelompok->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $PMB_Doc_list->SortUrl($PMB_Doc_list->IdKelompok) ?>', 1);"><div id="elh_PMB_Doc_IdKelompok" class="PMB_Doc_IdKelompok">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $PMB_Doc_list->IdKelompok->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($PMB_Doc_list->IdKelompok->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($PMB_Doc_list->IdKelompok->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($PMB_Doc_list->Tanggal->Visible) { // Tanggal ?>
	<?php if ($PMB_Doc_list->SortUrl($PMB_Doc_list->Tanggal) == "") { ?>
		<th data-name="Tanggal" class="<?php echo $PMB_Doc_list->Tanggal->headerCellClass() ?>"><div id="elh_PMB_Doc_Tanggal" class="PMB_Doc_Tanggal"><div class="ew-table-header-caption"><?php echo $PMB_Doc_list->Tanggal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tanggal" class="<?php echo $PMB_Doc_list->Tanggal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $PMB_Doc_list->SortUrl($PMB_Doc_list->Tanggal) ?>', 1);"><div id="elh_PMB_Doc_Tanggal" class="PMB_Doc_Tanggal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $PMB_Doc_list->Tanggal->caption() ?></span><span class="ew-table-header-sort"><?php if ($PMB_Doc_list->Tanggal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($PMB_Doc_list->Tanggal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($PMB_Doc_list->Catatan->Visible) { // Catatan ?>
	<?php if ($PMB_Doc_list->SortUrl($PMB_Doc_list->Catatan) == "") { ?>
		<th data-name="Catatan" class="<?php echo $PMB_Doc_list->Catatan->headerCellClass() ?>"><div id="elh_PMB_Doc_Catatan" class="PMB_Doc_Catatan"><div class="ew-table-header-caption"><?php echo $PMB_Doc_list->Catatan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Catatan" class="<?php echo $PMB_Doc_list->Catatan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $PMB_Doc_list->SortUrl($PMB_Doc_list->Catatan) ?>', 1);"><div id="elh_PMB_Doc_Catatan" class="PMB_Doc_Catatan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $PMB_Doc_list->Catatan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($PMB_Doc_list->Catatan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($PMB_Doc_list->Catatan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$PMB_Doc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($PMB_Doc_list->ExportAll && $PMB_Doc_list->isExport()) {
	$PMB_Doc_list->StopRecord = $PMB_Doc_list->TotalRecords;
} else {

	// Set the last record to display
	if ($PMB_Doc_list->TotalRecords > $PMB_Doc_list->StartRecord + $PMB_Doc_list->DisplayRecords - 1)
		$PMB_Doc_list->StopRecord = $PMB_Doc_list->StartRecord + $PMB_Doc_list->DisplayRecords - 1;
	else
		$PMB_Doc_list->StopRecord = $PMB_Doc_list->TotalRecords;
}
$PMB_Doc_list->RecordCount = $PMB_Doc_list->StartRecord - 1;
if ($PMB_Doc_list->Recordset && !$PMB_Doc_list->Recordset->EOF) {
	$PMB_Doc_list->Recordset->moveFirst();
	$selectLimit = $PMB_Doc_list->UseSelectLimit;
	if (!$selectLimit && $PMB_Doc_list->StartRecord > 1)
		$PMB_Doc_list->Recordset->move($PMB_Doc_list->StartRecord - 1);
} elseif (!$PMB_Doc->AllowAddDeleteRow && $PMB_Doc_list->StopRecord == 0) {
	$PMB_Doc_list->StopRecord = $PMB_Doc->GridAddRowCount;
}

// Initialize aggregate
$PMB_Doc->RowType = ROWTYPE_AGGREGATEINIT;
$PMB_Doc->resetAttributes();
$PMB_Doc_list->renderRow();
while ($PMB_Doc_list->RecordCount < $PMB_Doc_list->StopRecord) {
	$PMB_Doc_list->RecordCount++;
	if ($PMB_Doc_list->RecordCount >= $PMB_Doc_list->StartRecord) {
		$PMB_Doc_list->RowCount++;

		// Set up key count
		$PMB_Doc_list->KeyCount = $PMB_Doc_list->RowIndex;

		// Init row class and style
		$PMB_Doc->resetAttributes();
		$PMB_Doc->CssClass = "";
		if ($PMB_Doc_list->isGridAdd()) {
		} else {
			$PMB_Doc_list->loadRowValues($PMB_Doc_list->Recordset); // Load row values
		}
		$PMB_Doc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$PMB_Doc->RowAttrs->merge(["data-rowindex" => $PMB_Doc_list->RowCount, "id" => "r" . $PMB_Doc_list->RowCount . "_PMB_Doc", "data-rowtype" => $PMB_Doc->RowType]);

		// Render row
		$PMB_Doc_list->renderRow();

		// Render list options
		$PMB_Doc_list->renderListOptions();
?>
	<tr <?php echo $PMB_Doc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$PMB_Doc_list->ListOptions->render("body", "left", $PMB_Doc_list->RowCount);
?>
	<?php if ($PMB_Doc_list->idDoc->Visible) { // idDoc ?>
		<td data-name="idDoc" <?php echo $PMB_Doc_list->idDoc->cellAttributes() ?>>
<span id="el<?php echo $PMB_Doc_list->RowCount ?>_PMB_Doc_idDoc">
<span<?php echo $PMB_Doc_list->idDoc->viewAttributes() ?>><?php echo $PMB_Doc_list->idDoc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($PMB_Doc_list->JudulDoc->Visible) { // JudulDoc ?>
		<td data-name="JudulDoc" <?php echo $PMB_Doc_list->JudulDoc->cellAttributes() ?>>
<span id="el<?php echo $PMB_Doc_list->RowCount ?>_PMB_Doc_JudulDoc">
<span<?php echo $PMB_Doc_list->JudulDoc->viewAttributes() ?>><?php echo $PMB_Doc_list->JudulDoc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($PMB_Doc_list->IdKelompok->Visible) { // IdKelompok ?>
		<td data-name="IdKelompok" <?php echo $PMB_Doc_list->IdKelompok->cellAttributes() ?>>
<span id="el<?php echo $PMB_Doc_list->RowCount ?>_PMB_Doc_IdKelompok">
<span<?php echo $PMB_Doc_list->IdKelompok->viewAttributes() ?>><?php echo $PMB_Doc_list->IdKelompok->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($PMB_Doc_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal" <?php echo $PMB_Doc_list->Tanggal->cellAttributes() ?>>
<span id="el<?php echo $PMB_Doc_list->RowCount ?>_PMB_Doc_Tanggal">
<span<?php echo $PMB_Doc_list->Tanggal->viewAttributes() ?>><?php echo $PMB_Doc_list->Tanggal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($PMB_Doc_list->Catatan->Visible) { // Catatan ?>
		<td data-name="Catatan" <?php echo $PMB_Doc_list->Catatan->cellAttributes() ?>>
<span id="el<?php echo $PMB_Doc_list->RowCount ?>_PMB_Doc_Catatan">
<span<?php echo $PMB_Doc_list->Catatan->viewAttributes() ?>><?php echo $PMB_Doc_list->Catatan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$PMB_Doc_list->ListOptions->render("body", "right", $PMB_Doc_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$PMB_Doc_list->isGridAdd())
		$PMB_Doc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$PMB_Doc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($PMB_Doc_list->Recordset)
	$PMB_Doc_list->Recordset->Close();
?>
<?php if (!$PMB_Doc_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$PMB_Doc_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $PMB_Doc_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $PMB_Doc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($PMB_Doc_list->TotalRecords == 0 && !$PMB_Doc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $PMB_Doc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$PMB_Doc_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$PMB_Doc_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$PMB_Doc_list->terminate();
?>