<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$Perwalian_add = new Perwalian_add();

// Run the page
$Perwalian_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Perwalian_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fPerwalianadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fPerwalianadd = currentForm = new ew.Form("fPerwalianadd", "add");

	// Validate form
	fPerwalianadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($Perwalian_add->Thn_Akademik->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Akademik");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->Thn_Akademik->caption(), $Perwalian_add->Thn_Akademik->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_add->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->Periode->caption(), $Perwalian_add->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_add->Nim->Required) { ?>
				elm = this.getElements("x" + infix + "_Nim");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->Nim->caption(), $Perwalian_add->Nim->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_add->Sem->Required) { ?>
				elm = this.getElements("x" + infix + "_Sem");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->Sem->caption(), $Perwalian_add->Sem->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_add->GenapGanjil->Required) { ?>
				elm = this.getElements("x" + infix + "_GenapGanjil");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->GenapGanjil->caption(), $Perwalian_add->GenapGanjil->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_add->Tgl_Prw->Required) { ?>
				elm = this.getElements("x" + infix + "_Tgl_Prw");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->Tgl_Prw->caption(), $Perwalian_add->Tgl_Prw->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tgl_Prw");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($Perwalian_add->Tgl_Prw->errorMessage()) ?>");
			<?php if ($Perwalian_add->TSKSB->Required) { ?>
				elm = this.getElements("x" + infix + "_TSKSB");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->TSKSB->caption(), $Perwalian_add->TSKSB->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_TSKSB");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($Perwalian_add->TSKSB->errorMessage()) ?>");
			<?php if ($Perwalian_add->CatatanDosenWali->Required) { ?>
				elm = this.getElements("x" + infix + "_CatatanDosenWali");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->CatatanDosenWali->caption(), $Perwalian_add->CatatanDosenWali->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_add->Keterangan->Required) { ?>
				elm = this.getElements("x" + infix + "_Keterangan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_add->Keterangan->caption(), $Perwalian_add->Keterangan->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fPerwalianadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fPerwalianadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fPerwalianadd.lists["x_Thn_Akademik"] = <?php echo $Perwalian_add->Thn_Akademik->Lookup->toClientList($Perwalian_add) ?>;
	fPerwalianadd.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($Perwalian_add->Thn_Akademik->lookupOptions()) ?>;
	fPerwalianadd.lists["x_Periode"] = <?php echo $Perwalian_add->Periode->Lookup->toClientList($Perwalian_add) ?>;
	fPerwalianadd.lists["x_Periode"].options = <?php echo JsonEncode($Perwalian_add->Periode->options(FALSE, TRUE)) ?>;
	fPerwalianadd.lists["x_Nim"] = <?php echo $Perwalian_add->Nim->Lookup->toClientList($Perwalian_add) ?>;
	fPerwalianadd.lists["x_Nim"].options = <?php echo JsonEncode($Perwalian_add->Nim->lookupOptions()) ?>;
	loadjs.done("fPerwalianadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $Perwalian_add->showPageHeader(); ?>
<?php
$Perwalian_add->showMessage();
?>
<form name="fPerwalianadd" id="fPerwalianadd" class="<?php echo $Perwalian_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="Perwalian">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$Perwalian_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Perwalian_add->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<div id="r_Thn_Akademik" class="form-group row">
		<label id="elh_Perwalian_Thn_Akademik" for="x_Thn_Akademik" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->Thn_Akademik->caption() ?><?php echo $Perwalian_add->Thn_Akademik->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->Thn_Akademik->cellAttributes() ?>>
<span id="el_Perwalian_Thn_Akademik">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Perwalian" data-field="x_Thn_Akademik" data-value-separator="<?php echo $Perwalian_add->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $Perwalian_add->Thn_Akademik->editAttributes() ?>>
			<?php echo $Perwalian_add->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $Perwalian_add->Thn_Akademik->Lookup->getParamTag($Perwalian_add, "p_x_Thn_Akademik") ?>
</span>
<?php echo $Perwalian_add->Thn_Akademik->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_add->Periode->Visible) { // Periode ?>
	<div id="r_Periode" class="form-group row">
		<label id="elh_Perwalian_Periode" for="x_Periode" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->Periode->caption() ?><?php echo $Perwalian_add->Periode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->Periode->cellAttributes() ?>>
<span id="el_Perwalian_Periode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Perwalian" data-field="x_Periode" data-value-separator="<?php echo $Perwalian_add->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $Perwalian_add->Periode->editAttributes() ?>>
			<?php echo $Perwalian_add->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
<?php echo $Perwalian_add->Periode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_add->Nim->Visible) { // Nim ?>
	<div id="r_Nim" class="form-group row">
		<label id="elh_Perwalian_Nim" for="x_Nim" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->Nim->caption() ?><?php echo $Perwalian_add->Nim->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->Nim->cellAttributes() ?>>
<span id="el_Perwalian_Nim">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_Nim"><?php echo EmptyValue(strval($Perwalian_add->Nim->ViewValue)) ? $Language->phrase("PleaseSelect") : $Perwalian_add->Nim->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($Perwalian_add->Nim->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($Perwalian_add->Nim->ReadOnly || $Perwalian_add->Nim->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_Nim',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $Perwalian_add->Nim->Lookup->getParamTag($Perwalian_add, "p_x_Nim") ?>
<input type="hidden" data-table="Perwalian" data-field="x_Nim" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Perwalian_add->Nim->displayValueSeparatorAttribute() ?>" name="x_Nim" id="x_Nim" value="<?php echo $Perwalian_add->Nim->CurrentValue ?>"<?php echo $Perwalian_add->Nim->editAttributes() ?>>
</span>
<?php echo $Perwalian_add->Nim->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_add->Sem->Visible) { // Sem ?>
	<div id="r_Sem" class="form-group row">
		<label id="elh_Perwalian_Sem" for="x_Sem" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->Sem->caption() ?><?php echo $Perwalian_add->Sem->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->Sem->cellAttributes() ?>>
<span id="el_Perwalian_Sem">
<input type="text" data-table="Perwalian" data-field="x_Sem" name="x_Sem" id="x_Sem" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($Perwalian_add->Sem->getPlaceHolder()) ?>" value="<?php echo $Perwalian_add->Sem->EditValue ?>"<?php echo $Perwalian_add->Sem->editAttributes() ?>>
</span>
<?php echo $Perwalian_add->Sem->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_add->GenapGanjil->Visible) { // GenapGanjil ?>
	<div id="r_GenapGanjil" class="form-group row">
		<label id="elh_Perwalian_GenapGanjil" for="x_GenapGanjil" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->GenapGanjil->caption() ?><?php echo $Perwalian_add->GenapGanjil->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->GenapGanjil->cellAttributes() ?>>
<span id="el_Perwalian_GenapGanjil">
<input type="text" data-table="Perwalian" data-field="x_GenapGanjil" name="x_GenapGanjil" id="x_GenapGanjil" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($Perwalian_add->GenapGanjil->getPlaceHolder()) ?>" value="<?php echo $Perwalian_add->GenapGanjil->EditValue ?>"<?php echo $Perwalian_add->GenapGanjil->editAttributes() ?>>
</span>
<?php echo $Perwalian_add->GenapGanjil->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_add->Tgl_Prw->Visible) { // Tgl_Prw ?>
	<div id="r_Tgl_Prw" class="form-group row">
		<label id="elh_Perwalian_Tgl_Prw" for="x_Tgl_Prw" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->Tgl_Prw->caption() ?><?php echo $Perwalian_add->Tgl_Prw->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->Tgl_Prw->cellAttributes() ?>>
<span id="el_Perwalian_Tgl_Prw">
<input type="text" data-table="Perwalian" data-field="x_Tgl_Prw" data-format="7" name="x_Tgl_Prw" id="x_Tgl_Prw" maxlength="8" placeholder="<?php echo HtmlEncode($Perwalian_add->Tgl_Prw->getPlaceHolder()) ?>" value="<?php echo $Perwalian_add->Tgl_Prw->EditValue ?>"<?php echo $Perwalian_add->Tgl_Prw->editAttributes() ?>>
<?php if (!$Perwalian_add->Tgl_Prw->ReadOnly && !$Perwalian_add->Tgl_Prw->Disabled && !isset($Perwalian_add->Tgl_Prw->EditAttrs["readonly"]) && !isset($Perwalian_add->Tgl_Prw->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fPerwalianadd", "datetimepicker"], function() {
	ew.createDateTimePicker("fPerwalianadd", "x_Tgl_Prw", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $Perwalian_add->Tgl_Prw->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_add->TSKSB->Visible) { // TSKSB ?>
	<div id="r_TSKSB" class="form-group row">
		<label id="elh_Perwalian_TSKSB" for="x_TSKSB" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->TSKSB->caption() ?><?php echo $Perwalian_add->TSKSB->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->TSKSB->cellAttributes() ?>>
<span id="el_Perwalian_TSKSB">
<input type="text" data-table="Perwalian" data-field="x_TSKSB" name="x_TSKSB" id="x_TSKSB" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($Perwalian_add->TSKSB->getPlaceHolder()) ?>" value="<?php echo $Perwalian_add->TSKSB->EditValue ?>"<?php echo $Perwalian_add->TSKSB->editAttributes() ?>>
</span>
<?php echo $Perwalian_add->TSKSB->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_add->CatatanDosenWali->Visible) { // CatatanDosenWali ?>
	<div id="r_CatatanDosenWali" class="form-group row">
		<label id="elh_Perwalian_CatatanDosenWali" for="x_CatatanDosenWali" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->CatatanDosenWali->caption() ?><?php echo $Perwalian_add->CatatanDosenWali->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->CatatanDosenWali->cellAttributes() ?>>
<span id="el_Perwalian_CatatanDosenWali">
<input type="text" data-table="Perwalian" data-field="x_CatatanDosenWali" name="x_CatatanDosenWali" id="x_CatatanDosenWali" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($Perwalian_add->CatatanDosenWali->getPlaceHolder()) ?>" value="<?php echo $Perwalian_add->CatatanDosenWali->EditValue ?>"<?php echo $Perwalian_add->CatatanDosenWali->editAttributes() ?>>
</span>
<?php echo $Perwalian_add->CatatanDosenWali->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_add->Keterangan->Visible) { // Keterangan ?>
	<div id="r_Keterangan" class="form-group row">
		<label id="elh_Perwalian_Keterangan" for="x_Keterangan" class="<?php echo $Perwalian_add->LeftColumnClass ?>"><?php echo $Perwalian_add->Keterangan->caption() ?><?php echo $Perwalian_add->Keterangan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_add->RightColumnClass ?>"><div <?php echo $Perwalian_add->Keterangan->cellAttributes() ?>>
<span id="el_Perwalian_Keterangan">
<input type="text" data-table="Perwalian" data-field="x_Keterangan" name="x_Keterangan" id="x_Keterangan" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($Perwalian_add->Keterangan->getPlaceHolder()) ?>" value="<?php echo $Perwalian_add->Keterangan->EditValue ?>"<?php echo $Perwalian_add->Keterangan->editAttributes() ?>>
</span>
<?php echo $Perwalian_add->Keterangan->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("tblNilai", explode(",", $Perwalian->getCurrentDetailTable())) && $tblNilai->DetailAdd) {
?>
<?php if ($Perwalian->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("tblNilai", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "tblNilaigrid.php" ?>
<?php } ?>
<?php if (!$Perwalian_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $Perwalian_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $Perwalian_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$Perwalian_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$Perwalian_add->terminate();
?>