<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$Perwalian_edit = new Perwalian_edit();

// Run the page
$Perwalian_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Perwalian_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fPerwalianedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fPerwalianedit = currentForm = new ew.Form("fPerwalianedit", "edit");

	// Validate form
	fPerwalianedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($Perwalian_edit->Thn_Akademik->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Akademik");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->Thn_Akademik->caption(), $Perwalian_edit->Thn_Akademik->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_edit->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->Periode->caption(), $Perwalian_edit->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_edit->Nim->Required) { ?>
				elm = this.getElements("x" + infix + "_Nim");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->Nim->caption(), $Perwalian_edit->Nim->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_edit->Sem->Required) { ?>
				elm = this.getElements("x" + infix + "_Sem");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->Sem->caption(), $Perwalian_edit->Sem->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_edit->GenapGanjil->Required) { ?>
				elm = this.getElements("x" + infix + "_GenapGanjil");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->GenapGanjil->caption(), $Perwalian_edit->GenapGanjil->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_edit->Tgl_Prw->Required) { ?>
				elm = this.getElements("x" + infix + "_Tgl_Prw");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->Tgl_Prw->caption(), $Perwalian_edit->Tgl_Prw->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tgl_Prw");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($Perwalian_edit->Tgl_Prw->errorMessage()) ?>");
			<?php if ($Perwalian_edit->TSKSB->Required) { ?>
				elm = this.getElements("x" + infix + "_TSKSB");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->TSKSB->caption(), $Perwalian_edit->TSKSB->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_TSKSB");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($Perwalian_edit->TSKSB->errorMessage()) ?>");
			<?php if ($Perwalian_edit->CatatanDosenWali->Required) { ?>
				elm = this.getElements("x" + infix + "_CatatanDosenWali");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->CatatanDosenWali->caption(), $Perwalian_edit->CatatanDosenWali->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($Perwalian_edit->Keterangan->Required) { ?>
				elm = this.getElements("x" + infix + "_Keterangan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $Perwalian_edit->Keterangan->caption(), $Perwalian_edit->Keterangan->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fPerwalianedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fPerwalianedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fPerwalianedit.lists["x_Thn_Akademik"] = <?php echo $Perwalian_edit->Thn_Akademik->Lookup->toClientList($Perwalian_edit) ?>;
	fPerwalianedit.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($Perwalian_edit->Thn_Akademik->lookupOptions()) ?>;
	fPerwalianedit.lists["x_Periode"] = <?php echo $Perwalian_edit->Periode->Lookup->toClientList($Perwalian_edit) ?>;
	fPerwalianedit.lists["x_Periode"].options = <?php echo JsonEncode($Perwalian_edit->Periode->options(FALSE, TRUE)) ?>;
	fPerwalianedit.lists["x_Nim"] = <?php echo $Perwalian_edit->Nim->Lookup->toClientList($Perwalian_edit) ?>;
	fPerwalianedit.lists["x_Nim"].options = <?php echo JsonEncode($Perwalian_edit->Nim->lookupOptions()) ?>;
	loadjs.done("fPerwalianedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $Perwalian_edit->showPageHeader(); ?>
<?php
$Perwalian_edit->showMessage();
?>
<form name="fPerwalianedit" id="fPerwalianedit" class="<?php echo $Perwalian_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="Perwalian">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$Perwalian_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Perwalian_edit->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<div id="r_Thn_Akademik" class="form-group row">
		<label id="elh_Perwalian_Thn_Akademik" for="x_Thn_Akademik" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->Thn_Akademik->caption() ?><?php echo $Perwalian_edit->Thn_Akademik->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->Thn_Akademik->cellAttributes() ?>>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Perwalian" data-field="x_Thn_Akademik" data-value-separator="<?php echo $Perwalian_edit->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $Perwalian_edit->Thn_Akademik->editAttributes() ?>>
			<?php echo $Perwalian_edit->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $Perwalian_edit->Thn_Akademik->Lookup->getParamTag($Perwalian_edit, "p_x_Thn_Akademik") ?>
<input type="hidden" data-table="Perwalian" data-field="x_Thn_Akademik" name="o_Thn_Akademik" id="o_Thn_Akademik" value="<?php echo HtmlEncode($Perwalian_edit->Thn_Akademik->OldValue != null ? $Perwalian_edit->Thn_Akademik->OldValue : $Perwalian_edit->Thn_Akademik->CurrentValue) ?>">
<?php echo $Perwalian_edit->Thn_Akademik->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_edit->Periode->Visible) { // Periode ?>
	<div id="r_Periode" class="form-group row">
		<label id="elh_Perwalian_Periode" for="x_Periode" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->Periode->caption() ?><?php echo $Perwalian_edit->Periode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->Periode->cellAttributes() ?>>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Perwalian" data-field="x_Periode" data-value-separator="<?php echo $Perwalian_edit->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $Perwalian_edit->Periode->editAttributes() ?>>
			<?php echo $Perwalian_edit->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
<input type="hidden" data-table="Perwalian" data-field="x_Periode" name="o_Periode" id="o_Periode" value="<?php echo HtmlEncode($Perwalian_edit->Periode->OldValue != null ? $Perwalian_edit->Periode->OldValue : $Perwalian_edit->Periode->CurrentValue) ?>">
<?php echo $Perwalian_edit->Periode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_edit->Nim->Visible) { // Nim ?>
	<div id="r_Nim" class="form-group row">
		<label id="elh_Perwalian_Nim" for="x_Nim" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->Nim->caption() ?><?php echo $Perwalian_edit->Nim->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->Nim->cellAttributes() ?>>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_Nim"><?php echo EmptyValue(strval($Perwalian_edit->Nim->ViewValue)) ? $Language->phrase("PleaseSelect") : $Perwalian_edit->Nim->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($Perwalian_edit->Nim->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($Perwalian_edit->Nim->ReadOnly || $Perwalian_edit->Nim->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_Nim',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $Perwalian_edit->Nim->Lookup->getParamTag($Perwalian_edit, "p_x_Nim") ?>
<input type="hidden" data-table="Perwalian" data-field="x_Nim" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Perwalian_edit->Nim->displayValueSeparatorAttribute() ?>" name="x_Nim" id="x_Nim" value="<?php echo $Perwalian_edit->Nim->CurrentValue ?>"<?php echo $Perwalian_edit->Nim->editAttributes() ?>>
<input type="hidden" data-table="Perwalian" data-field="x_Nim" name="o_Nim" id="o_Nim" value="<?php echo HtmlEncode($Perwalian_edit->Nim->OldValue != null ? $Perwalian_edit->Nim->OldValue : $Perwalian_edit->Nim->CurrentValue) ?>">
<?php echo $Perwalian_edit->Nim->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_edit->Sem->Visible) { // Sem ?>
	<div id="r_Sem" class="form-group row">
		<label id="elh_Perwalian_Sem" for="x_Sem" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->Sem->caption() ?><?php echo $Perwalian_edit->Sem->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->Sem->cellAttributes() ?>>
<span id="el_Perwalian_Sem">
<input type="text" data-table="Perwalian" data-field="x_Sem" name="x_Sem" id="x_Sem" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($Perwalian_edit->Sem->getPlaceHolder()) ?>" value="<?php echo $Perwalian_edit->Sem->EditValue ?>"<?php echo $Perwalian_edit->Sem->editAttributes() ?>>
</span>
<?php echo $Perwalian_edit->Sem->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_edit->GenapGanjil->Visible) { // GenapGanjil ?>
	<div id="r_GenapGanjil" class="form-group row">
		<label id="elh_Perwalian_GenapGanjil" for="x_GenapGanjil" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->GenapGanjil->caption() ?><?php echo $Perwalian_edit->GenapGanjil->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->GenapGanjil->cellAttributes() ?>>
<span id="el_Perwalian_GenapGanjil">
<input type="text" data-table="Perwalian" data-field="x_GenapGanjil" name="x_GenapGanjil" id="x_GenapGanjil" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($Perwalian_edit->GenapGanjil->getPlaceHolder()) ?>" value="<?php echo $Perwalian_edit->GenapGanjil->EditValue ?>"<?php echo $Perwalian_edit->GenapGanjil->editAttributes() ?>>
</span>
<?php echo $Perwalian_edit->GenapGanjil->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_edit->Tgl_Prw->Visible) { // Tgl_Prw ?>
	<div id="r_Tgl_Prw" class="form-group row">
		<label id="elh_Perwalian_Tgl_Prw" for="x_Tgl_Prw" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->Tgl_Prw->caption() ?><?php echo $Perwalian_edit->Tgl_Prw->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->Tgl_Prw->cellAttributes() ?>>
<span id="el_Perwalian_Tgl_Prw">
<input type="text" data-table="Perwalian" data-field="x_Tgl_Prw" data-format="7" name="x_Tgl_Prw" id="x_Tgl_Prw" maxlength="8" placeholder="<?php echo HtmlEncode($Perwalian_edit->Tgl_Prw->getPlaceHolder()) ?>" value="<?php echo $Perwalian_edit->Tgl_Prw->EditValue ?>"<?php echo $Perwalian_edit->Tgl_Prw->editAttributes() ?>>
<?php if (!$Perwalian_edit->Tgl_Prw->ReadOnly && !$Perwalian_edit->Tgl_Prw->Disabled && !isset($Perwalian_edit->Tgl_Prw->EditAttrs["readonly"]) && !isset($Perwalian_edit->Tgl_Prw->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fPerwalianedit", "datetimepicker"], function() {
	ew.createDateTimePicker("fPerwalianedit", "x_Tgl_Prw", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $Perwalian_edit->Tgl_Prw->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_edit->TSKSB->Visible) { // TSKSB ?>
	<div id="r_TSKSB" class="form-group row">
		<label id="elh_Perwalian_TSKSB" for="x_TSKSB" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->TSKSB->caption() ?><?php echo $Perwalian_edit->TSKSB->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->TSKSB->cellAttributes() ?>>
<span id="el_Perwalian_TSKSB">
<input type="text" data-table="Perwalian" data-field="x_TSKSB" name="x_TSKSB" id="x_TSKSB" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($Perwalian_edit->TSKSB->getPlaceHolder()) ?>" value="<?php echo $Perwalian_edit->TSKSB->EditValue ?>"<?php echo $Perwalian_edit->TSKSB->editAttributes() ?>>
</span>
<?php echo $Perwalian_edit->TSKSB->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_edit->CatatanDosenWali->Visible) { // CatatanDosenWali ?>
	<div id="r_CatatanDosenWali" class="form-group row">
		<label id="elh_Perwalian_CatatanDosenWali" for="x_CatatanDosenWali" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->CatatanDosenWali->caption() ?><?php echo $Perwalian_edit->CatatanDosenWali->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->CatatanDosenWali->cellAttributes() ?>>
<span id="el_Perwalian_CatatanDosenWali">
<input type="text" data-table="Perwalian" data-field="x_CatatanDosenWali" name="x_CatatanDosenWali" id="x_CatatanDosenWali" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($Perwalian_edit->CatatanDosenWali->getPlaceHolder()) ?>" value="<?php echo $Perwalian_edit->CatatanDosenWali->EditValue ?>"<?php echo $Perwalian_edit->CatatanDosenWali->editAttributes() ?>>
</span>
<?php echo $Perwalian_edit->CatatanDosenWali->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($Perwalian_edit->Keterangan->Visible) { // Keterangan ?>
	<div id="r_Keterangan" class="form-group row">
		<label id="elh_Perwalian_Keterangan" for="x_Keterangan" class="<?php echo $Perwalian_edit->LeftColumnClass ?>"><?php echo $Perwalian_edit->Keterangan->caption() ?><?php echo $Perwalian_edit->Keterangan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $Perwalian_edit->RightColumnClass ?>"><div <?php echo $Perwalian_edit->Keterangan->cellAttributes() ?>>
<span id="el_Perwalian_Keterangan">
<input type="text" data-table="Perwalian" data-field="x_Keterangan" name="x_Keterangan" id="x_Keterangan" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($Perwalian_edit->Keterangan->getPlaceHolder()) ?>" value="<?php echo $Perwalian_edit->Keterangan->EditValue ?>"<?php echo $Perwalian_edit->Keterangan->editAttributes() ?>>
</span>
<?php echo $Perwalian_edit->Keterangan->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("tblNilai", explode(",", $Perwalian->getCurrentDetailTable())) && $tblNilai->DetailEdit) {
?>
<?php if ($Perwalian->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("tblNilai", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "tblNilaigrid.php" ?>
<?php } ?>
<?php if (!$Perwalian_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $Perwalian_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $Perwalian_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$Perwalian_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$Perwalian_edit->terminate();
?>