<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$Perwalian_list = new Perwalian_list();

// Run the page
$Perwalian_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Perwalian_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$Perwalian_list->isExport()) { ?>
<script>
var fPerwalianlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fPerwalianlist = currentForm = new ew.Form("fPerwalianlist", "list");
	fPerwalianlist.formKeyCountName = '<?php echo $Perwalian_list->FormKeyCountName ?>';
	loadjs.done("fPerwalianlist");
});
var fPerwalianlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fPerwalianlistsrch = currentSearchForm = new ew.Form("fPerwalianlistsrch");

	// Validate function for search
	fPerwalianlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fPerwalianlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fPerwalianlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fPerwalianlistsrch.lists["x_Thn_Akademik"] = <?php echo $Perwalian_list->Thn_Akademik->Lookup->toClientList($Perwalian_list) ?>;
	fPerwalianlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($Perwalian_list->Thn_Akademik->lookupOptions()) ?>;
	fPerwalianlistsrch.lists["x_Periode"] = <?php echo $Perwalian_list->Periode->Lookup->toClientList($Perwalian_list) ?>;
	fPerwalianlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($Perwalian_list->Periode->options(FALSE, TRUE)) ?>;

	// Filters
	fPerwalianlistsrch.filterList = <?php echo $Perwalian_list->getFilterList() ?>;
	loadjs.done("fPerwalianlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$Perwalian_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Perwalian_list->TotalRecords > 0 && $Perwalian_list->ExportOptions->visible()) { ?>
<?php $Perwalian_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Perwalian_list->ImportOptions->visible()) { ?>
<?php $Perwalian_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Perwalian_list->SearchOptions->visible()) { ?>
<?php $Perwalian_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Perwalian_list->FilterOptions->visible()) { ?>
<?php $Perwalian_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$Perwalian_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$Perwalian_list->isExport() && !$Perwalian->CurrentAction) { ?>
<form name="fPerwalianlistsrch" id="fPerwalianlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fPerwalianlistsrch-search-panel" class="<?php echo $Perwalian_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="Perwalian">
	<div class="ew-extended-search">
<?php

// Render search row
$Perwalian->RowType = ROWTYPE_SEARCH;
$Perwalian->resetAttributes();
$Perwalian_list->renderRow();
?>
<?php if ($Perwalian_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$Perwalian_list->SearchColumnCount++;
		if (($Perwalian_list->SearchColumnCount - 1) % $Perwalian_list->SearchFieldsPerRow == 0) {
			$Perwalian_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $Perwalian_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $Perwalian_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_Perwalian_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Perwalian" data-field="x_Thn_Akademik" data-value-separator="<?php echo $Perwalian_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $Perwalian_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $Perwalian_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $Perwalian_list->Thn_Akademik->Lookup->getParamTag($Perwalian_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($Perwalian_list->SearchColumnCount % $Perwalian_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($Perwalian_list->Periode->Visible) { // Periode ?>
	<?php
		$Perwalian_list->SearchColumnCount++;
		if (($Perwalian_list->SearchColumnCount - 1) % $Perwalian_list->SearchFieldsPerRow == 0) {
			$Perwalian_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $Perwalian_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $Perwalian_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_Perwalian_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Perwalian" data-field="x_Periode" data-value-separator="<?php echo $Perwalian_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $Perwalian_list->Periode->editAttributes() ?>>
			<?php echo $Perwalian_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($Perwalian_list->SearchColumnCount % $Perwalian_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($Perwalian_list->SearchColumnCount % $Perwalian_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $Perwalian_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($Perwalian_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($Perwalian_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $Perwalian_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($Perwalian_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($Perwalian_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($Perwalian_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($Perwalian_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $Perwalian_list->showPageHeader(); ?>
<?php
$Perwalian_list->showMessage();
?>
<?php if ($Perwalian_list->TotalRecords > 0 || $Perwalian->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($Perwalian_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> Perwalian">
<form name="fPerwalianlist" id="fPerwalianlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="Perwalian">
<div id="gmp_Perwalian" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($Perwalian_list->TotalRecords > 0 || $Perwalian_list->isGridEdit()) { ?>
<table id="tbl_Perwalianlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$Perwalian->RowType = ROWTYPE_HEADER;

// Render list options
$Perwalian_list->renderListOptions();

// Render list options (header, left)
$Perwalian_list->ListOptions->render("header", "left");
?>
<?php if ($Perwalian_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($Perwalian_list->SortUrl($Perwalian_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $Perwalian_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_Perwalian_Thn_Akademik" class="Perwalian_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $Perwalian_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $Perwalian_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Perwalian_list->SortUrl($Perwalian_list->Thn_Akademik) ?>', 1);"><div id="elh_Perwalian_Thn_Akademik" class="Perwalian_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Perwalian_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($Perwalian_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Perwalian_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Perwalian_list->Periode->Visible) { // Periode ?>
	<?php if ($Perwalian_list->SortUrl($Perwalian_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $Perwalian_list->Periode->headerCellClass() ?>"><div id="elh_Perwalian_Periode" class="Perwalian_Periode"><div class="ew-table-header-caption"><?php echo $Perwalian_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $Perwalian_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Perwalian_list->SortUrl($Perwalian_list->Periode) ?>', 1);"><div id="elh_Perwalian_Periode" class="Perwalian_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Perwalian_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($Perwalian_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Perwalian_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Perwalian_list->Nim->Visible) { // Nim ?>
	<?php if ($Perwalian_list->SortUrl($Perwalian_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $Perwalian_list->Nim->headerCellClass() ?>"><div id="elh_Perwalian_Nim" class="Perwalian_Nim"><div class="ew-table-header-caption"><?php echo $Perwalian_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $Perwalian_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Perwalian_list->SortUrl($Perwalian_list->Nim) ?>', 1);"><div id="elh_Perwalian_Nim" class="Perwalian_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Perwalian_list->Nim->caption() ?></span><span class="ew-table-header-sort"><?php if ($Perwalian_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Perwalian_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Perwalian_list->Tgl_Prw->Visible) { // Tgl_Prw ?>
	<?php if ($Perwalian_list->SortUrl($Perwalian_list->Tgl_Prw) == "") { ?>
		<th data-name="Tgl_Prw" class="<?php echo $Perwalian_list->Tgl_Prw->headerCellClass() ?>"><div id="elh_Perwalian_Tgl_Prw" class="Perwalian_Tgl_Prw"><div class="ew-table-header-caption"><?php echo $Perwalian_list->Tgl_Prw->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tgl_Prw" class="<?php echo $Perwalian_list->Tgl_Prw->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Perwalian_list->SortUrl($Perwalian_list->Tgl_Prw) ?>', 1);"><div id="elh_Perwalian_Tgl_Prw" class="Perwalian_Tgl_Prw">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Perwalian_list->Tgl_Prw->caption() ?></span><span class="ew-table-header-sort"><?php if ($Perwalian_list->Tgl_Prw->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Perwalian_list->Tgl_Prw->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Perwalian_list->CatatanDosenWali->Visible) { // CatatanDosenWali ?>
	<?php if ($Perwalian_list->SortUrl($Perwalian_list->CatatanDosenWali) == "") { ?>
		<th data-name="CatatanDosenWali" class="<?php echo $Perwalian_list->CatatanDosenWali->headerCellClass() ?>"><div id="elh_Perwalian_CatatanDosenWali" class="Perwalian_CatatanDosenWali"><div class="ew-table-header-caption"><?php echo $Perwalian_list->CatatanDosenWali->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CatatanDosenWali" class="<?php echo $Perwalian_list->CatatanDosenWali->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Perwalian_list->SortUrl($Perwalian_list->CatatanDosenWali) ?>', 1);"><div id="elh_Perwalian_CatatanDosenWali" class="Perwalian_CatatanDosenWali">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Perwalian_list->CatatanDosenWali->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($Perwalian_list->CatatanDosenWali->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Perwalian_list->CatatanDosenWali->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Perwalian_list->Keterangan->Visible) { // Keterangan ?>
	<?php if ($Perwalian_list->SortUrl($Perwalian_list->Keterangan) == "") { ?>
		<th data-name="Keterangan" class="<?php echo $Perwalian_list->Keterangan->headerCellClass() ?>"><div id="elh_Perwalian_Keterangan" class="Perwalian_Keterangan"><div class="ew-table-header-caption"><?php echo $Perwalian_list->Keterangan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Keterangan" class="<?php echo $Perwalian_list->Keterangan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Perwalian_list->SortUrl($Perwalian_list->Keterangan) ?>', 1);"><div id="elh_Perwalian_Keterangan" class="Perwalian_Keterangan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Perwalian_list->Keterangan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($Perwalian_list->Keterangan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Perwalian_list->Keterangan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$Perwalian_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($Perwalian_list->ExportAll && $Perwalian_list->isExport()) {
	$Perwalian_list->StopRecord = $Perwalian_list->TotalRecords;
} else {

	// Set the last record to display
	if ($Perwalian_list->TotalRecords > $Perwalian_list->StartRecord + $Perwalian_list->DisplayRecords - 1)
		$Perwalian_list->StopRecord = $Perwalian_list->StartRecord + $Perwalian_list->DisplayRecords - 1;
	else
		$Perwalian_list->StopRecord = $Perwalian_list->TotalRecords;
}
$Perwalian_list->RecordCount = $Perwalian_list->StartRecord - 1;
if ($Perwalian_list->Recordset && !$Perwalian_list->Recordset->EOF) {
	$Perwalian_list->Recordset->moveFirst();
	$selectLimit = $Perwalian_list->UseSelectLimit;
	if (!$selectLimit && $Perwalian_list->StartRecord > 1)
		$Perwalian_list->Recordset->move($Perwalian_list->StartRecord - 1);
} elseif (!$Perwalian->AllowAddDeleteRow && $Perwalian_list->StopRecord == 0) {
	$Perwalian_list->StopRecord = $Perwalian->GridAddRowCount;
}

// Initialize aggregate
$Perwalian->RowType = ROWTYPE_AGGREGATEINIT;
$Perwalian->resetAttributes();
$Perwalian_list->renderRow();
while ($Perwalian_list->RecordCount < $Perwalian_list->StopRecord) {
	$Perwalian_list->RecordCount++;
	if ($Perwalian_list->RecordCount >= $Perwalian_list->StartRecord) {
		$Perwalian_list->RowCount++;

		// Set up key count
		$Perwalian_list->KeyCount = $Perwalian_list->RowIndex;

		// Init row class and style
		$Perwalian->resetAttributes();
		$Perwalian->CssClass = "";
		if ($Perwalian_list->isGridAdd()) {
		} else {
			$Perwalian_list->loadRowValues($Perwalian_list->Recordset); // Load row values
		}
		$Perwalian->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$Perwalian->RowAttrs->merge(["data-rowindex" => $Perwalian_list->RowCount, "id" => "r" . $Perwalian_list->RowCount . "_Perwalian", "data-rowtype" => $Perwalian->RowType]);

		// Render row
		$Perwalian_list->renderRow();

		// Render list options
		$Perwalian_list->renderListOptions();
?>
	<tr <?php echo $Perwalian->rowAttributes() ?>>
<?php

// Render list options (body, left)
$Perwalian_list->ListOptions->render("body", "left", $Perwalian_list->RowCount);
?>
	<?php if ($Perwalian_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $Perwalian_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $Perwalian_list->RowCount ?>_Perwalian_Thn_Akademik">
<span<?php echo $Perwalian_list->Thn_Akademik->viewAttributes() ?>><?php echo $Perwalian_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Perwalian_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $Perwalian_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $Perwalian_list->RowCount ?>_Perwalian_Periode">
<span<?php echo $Perwalian_list->Periode->viewAttributes() ?>><?php echo $Perwalian_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Perwalian_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $Perwalian_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $Perwalian_list->RowCount ?>_Perwalian_Nim">
<span<?php echo $Perwalian_list->Nim->viewAttributes() ?>><?php echo $Perwalian_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Perwalian_list->Tgl_Prw->Visible) { // Tgl_Prw ?>
		<td data-name="Tgl_Prw" <?php echo $Perwalian_list->Tgl_Prw->cellAttributes() ?>>
<span id="el<?php echo $Perwalian_list->RowCount ?>_Perwalian_Tgl_Prw">
<span<?php echo $Perwalian_list->Tgl_Prw->viewAttributes() ?>><?php echo $Perwalian_list->Tgl_Prw->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Perwalian_list->CatatanDosenWali->Visible) { // CatatanDosenWali ?>
		<td data-name="CatatanDosenWali" <?php echo $Perwalian_list->CatatanDosenWali->cellAttributes() ?>>
<span id="el<?php echo $Perwalian_list->RowCount ?>_Perwalian_CatatanDosenWali">
<span<?php echo $Perwalian_list->CatatanDosenWali->viewAttributes() ?>><?php echo $Perwalian_list->CatatanDosenWali->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Perwalian_list->Keterangan->Visible) { // Keterangan ?>
		<td data-name="Keterangan" <?php echo $Perwalian_list->Keterangan->cellAttributes() ?>>
<span id="el<?php echo $Perwalian_list->RowCount ?>_Perwalian_Keterangan">
<span<?php echo $Perwalian_list->Keterangan->viewAttributes() ?>><?php echo $Perwalian_list->Keterangan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$Perwalian_list->ListOptions->render("body", "right", $Perwalian_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$Perwalian_list->isGridAdd())
		$Perwalian_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Perwalian->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($Perwalian_list->Recordset)
	$Perwalian_list->Recordset->Close();
?>
<?php if (!$Perwalian_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Perwalian_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $Perwalian_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $Perwalian_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($Perwalian_list->TotalRecords == 0 && !$Perwalian->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $Perwalian_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$Perwalian_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$Perwalian_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$Perwalian_list->terminate();
?>