<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$QBeasiswa_Penerima_list = new QBeasiswa_Penerima_list();

// Run the page
$QBeasiswa_Penerima_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$QBeasiswa_Penerima_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$QBeasiswa_Penerima_list->isExport()) { ?>
<script>
var fQBeasiswa_Penerimalist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fQBeasiswa_Penerimalist = currentForm = new ew.Form("fQBeasiswa_Penerimalist", "list");
	fQBeasiswa_Penerimalist.formKeyCountName = '<?php echo $QBeasiswa_Penerima_list->FormKeyCountName ?>';
	loadjs.done("fQBeasiswa_Penerimalist");
});
var fQBeasiswa_Penerimalistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fQBeasiswa_Penerimalistsrch = currentSearchForm = new ew.Form("fQBeasiswa_Penerimalistsrch");

	// Validate function for search
	fQBeasiswa_Penerimalistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";
		elm = this.getElements("x" + infix + "_IDBeasiswa");
		if (elm && !ew.checkInteger(elm.value))
			return this.onError(elm, "<?php echo JsEncode($QBeasiswa_Penerima_list->IDBeasiswa->errorMessage()) ?>");

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fQBeasiswa_Penerimalistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fQBeasiswa_Penerimalistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fQBeasiswa_Penerimalistsrch.lists["x_Kode_Fak"] = <?php echo $QBeasiswa_Penerima_list->Kode_Fak->Lookup->toClientList($QBeasiswa_Penerima_list) ?>;
	fQBeasiswa_Penerimalistsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($QBeasiswa_Penerima_list->Kode_Fak->lookupOptions()) ?>;
	fQBeasiswa_Penerimalistsrch.lists["x_Tahun_Akademik"] = <?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->Lookup->toClientList($QBeasiswa_Penerima_list) ?>;
	fQBeasiswa_Penerimalistsrch.lists["x_Tahun_Akademik"].options = <?php echo JsonEncode($QBeasiswa_Penerima_list->Tahun_Akademik->lookupOptions()) ?>;
	fQBeasiswa_Penerimalistsrch.lists["x_Periode"] = <?php echo $QBeasiswa_Penerima_list->Periode->Lookup->toClientList($QBeasiswa_Penerima_list) ?>;
	fQBeasiswa_Penerimalistsrch.lists["x_Periode"].options = <?php echo JsonEncode($QBeasiswa_Penerima_list->Periode->options(FALSE, TRUE)) ?>;

	// Filters
	fQBeasiswa_Penerimalistsrch.filterList = <?php echo $QBeasiswa_Penerima_list->getFilterList() ?>;
	loadjs.done("fQBeasiswa_Penerimalistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$QBeasiswa_Penerima_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($QBeasiswa_Penerima_list->TotalRecords > 0 && $QBeasiswa_Penerima_list->ExportOptions->visible()) { ?>
<?php $QBeasiswa_Penerima_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->ImportOptions->visible()) { ?>
<?php $QBeasiswa_Penerima_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->SearchOptions->visible()) { ?>
<?php $QBeasiswa_Penerima_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->FilterOptions->visible()) { ?>
<?php $QBeasiswa_Penerima_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$QBeasiswa_Penerima_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$QBeasiswa_Penerima_list->isExport() && !$QBeasiswa_Penerima->CurrentAction) { ?>
<form name="fQBeasiswa_Penerimalistsrch" id="fQBeasiswa_Penerimalistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fQBeasiswa_Penerimalistsrch-search-panel" class="<?php echo $QBeasiswa_Penerima_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="QBeasiswa_Penerima">
	<div class="ew-extended-search">
<?php

// Render search row
$QBeasiswa_Penerima->RowType = ROWTYPE_SEARCH;
$QBeasiswa_Penerima->resetAttributes();
$QBeasiswa_Penerima_list->renderRow();
?>
<?php if ($QBeasiswa_Penerima_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$QBeasiswa_Penerima_list->SearchColumnCount++;
		if (($QBeasiswa_Penerima_list->SearchColumnCount - 1) % $QBeasiswa_Penerima_list->SearchFieldsPerRow == 0) {
			$QBeasiswa_Penerima_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QBeasiswa_Penerima_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $QBeasiswa_Penerima_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_QBeasiswa_Penerima_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QBeasiswa_Penerima" data-field="x_Kode_Fak" data-value-separator="<?php echo $QBeasiswa_Penerima_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $QBeasiswa_Penerima_list->Kode_Fak->editAttributes() ?>>
			<?php echo $QBeasiswa_Penerima_list->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $QBeasiswa_Penerima_list->Kode_Fak->Lookup->getParamTag($QBeasiswa_Penerima_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($QBeasiswa_Penerima_list->SearchColumnCount % $QBeasiswa_Penerima_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
	<?php
		$QBeasiswa_Penerima_list->SearchColumnCount++;
		if (($QBeasiswa_Penerima_list->SearchColumnCount - 1) % $QBeasiswa_Penerima_list->SearchFieldsPerRow == 0) {
			$QBeasiswa_Penerima_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QBeasiswa_Penerima_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Tahun_Akademik" class="ew-cell form-group">
		<label for="x_Tahun_Akademik" class="ew-search-caption ew-label"><?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Tahun_Akademik" id="z_Tahun_Akademik" value="LIKE">
</span>
		<span id="el_QBeasiswa_Penerima_Tahun_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QBeasiswa_Penerima" data-field="x_Tahun_Akademik" data-value-separator="<?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->displayValueSeparatorAttribute() ?>" id="x_Tahun_Akademik" name="x_Tahun_Akademik"<?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->editAttributes() ?>>
			<?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->selectOptionListHtml("x_Tahun_Akademik") ?>
		</select>
</div>
<?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->Lookup->getParamTag($QBeasiswa_Penerima_list, "p_x_Tahun_Akademik") ?>
</span>
	</div>
	<?php if ($QBeasiswa_Penerima_list->SearchColumnCount % $QBeasiswa_Penerima_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Periode->Visible) { // Periode ?>
	<?php
		$QBeasiswa_Penerima_list->SearchColumnCount++;
		if (($QBeasiswa_Penerima_list->SearchColumnCount - 1) % $QBeasiswa_Penerima_list->SearchFieldsPerRow == 0) {
			$QBeasiswa_Penerima_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QBeasiswa_Penerima_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $QBeasiswa_Penerima_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_QBeasiswa_Penerima_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QBeasiswa_Penerima" data-field="x_Periode" data-value-separator="<?php echo $QBeasiswa_Penerima_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $QBeasiswa_Penerima_list->Periode->editAttributes() ?>>
			<?php echo $QBeasiswa_Penerima_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($QBeasiswa_Penerima_list->SearchColumnCount % $QBeasiswa_Penerima_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->IDBeasiswa->Visible) { // IDBeasiswa ?>
	<?php
		$QBeasiswa_Penerima_list->SearchColumnCount++;
		if (($QBeasiswa_Penerima_list->SearchColumnCount - 1) % $QBeasiswa_Penerima_list->SearchFieldsPerRow == 0) {
			$QBeasiswa_Penerima_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QBeasiswa_Penerima_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_IDBeasiswa" class="ew-cell form-group">
		<label for="x_IDBeasiswa" class="ew-search-caption ew-label"><?php echo $QBeasiswa_Penerima_list->IDBeasiswa->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("=") ?>
<input type="hidden" name="z_IDBeasiswa" id="z_IDBeasiswa" value="=">
</span>
		<span id="el_QBeasiswa_Penerima_IDBeasiswa" class="ew-search-field">
<input type="text" data-table="QBeasiswa_Penerima" data-field="x_IDBeasiswa" name="x_IDBeasiswa" id="x_IDBeasiswa" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($QBeasiswa_Penerima_list->IDBeasiswa->getPlaceHolder()) ?>" value="<?php echo $QBeasiswa_Penerima_list->IDBeasiswa->EditValue ?>"<?php echo $QBeasiswa_Penerima_list->IDBeasiswa->editAttributes() ?>>
</span>
	</div>
	<?php if ($QBeasiswa_Penerima_list->SearchColumnCount % $QBeasiswa_Penerima_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->SearchColumnCount % $QBeasiswa_Penerima_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $QBeasiswa_Penerima_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($QBeasiswa_Penerima_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($QBeasiswa_Penerima_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $QBeasiswa_Penerima_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($QBeasiswa_Penerima_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($QBeasiswa_Penerima_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($QBeasiswa_Penerima_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($QBeasiswa_Penerima_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $QBeasiswa_Penerima_list->showPageHeader(); ?>
<?php
$QBeasiswa_Penerima_list->showMessage();
?>
<?php if ($QBeasiswa_Penerima_list->TotalRecords > 0 || $QBeasiswa_Penerima->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($QBeasiswa_Penerima_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> QBeasiswa_Penerima">
<form name="fQBeasiswa_Penerimalist" id="fQBeasiswa_Penerimalist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="QBeasiswa_Penerima">
<div id="gmp_QBeasiswa_Penerima" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($QBeasiswa_Penerima_list->TotalRecords > 0 || $QBeasiswa_Penerima_list->isGridEdit()) { ?>
<table id="tbl_QBeasiswa_Penerimalist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$QBeasiswa_Penerima->RowType = ROWTYPE_HEADER;

// Render list options
$QBeasiswa_Penerima_list->renderListOptions();

// Render list options (header, left)
$QBeasiswa_Penerima_list->ListOptions->render("header", "left");
?>
<?php if ($QBeasiswa_Penerima_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $QBeasiswa_Penerima_list->Kode_Fak->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_Kode_Fak" class="QBeasiswa_Penerima_Kode_Fak"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $QBeasiswa_Penerima_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Kode_Fak) ?>', 1);"><div id="elh_QBeasiswa_Penerima_Kode_Fak" class="QBeasiswa_Penerima_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Tahun_Akademik) == "") { ?>
		<th data-name="Tahun_Akademik" class="<?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_Tahun_Akademik" class="QBeasiswa_Penerima_Tahun_Akademik"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tahun_Akademik" class="<?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Tahun_Akademik) ?>', 1);"><div id="elh_QBeasiswa_Penerima_Tahun_Akademik" class="QBeasiswa_Penerima_Tahun_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->Tahun_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->Tahun_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Periode->Visible) { // Periode ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $QBeasiswa_Penerima_list->Periode->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_Periode" class="QBeasiswa_Penerima_Periode"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $QBeasiswa_Penerima_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Periode) ?>', 1);"><div id="elh_QBeasiswa_Penerima_Periode" class="QBeasiswa_Penerima_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Nim->Visible) { // Nim ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $QBeasiswa_Penerima_list->Nim->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_Nim" class="QBeasiswa_Penerima_Nim"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $QBeasiswa_Penerima_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Nim) ?>', 1);"><div id="elh_QBeasiswa_Penerima_Nim" class="QBeasiswa_Penerima_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $QBeasiswa_Penerima_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_Nama_Mhs" class="QBeasiswa_Penerima_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $QBeasiswa_Penerima_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Nama_Mhs) ?>', 1);"><div id="elh_QBeasiswa_Penerima_Nama_Mhs" class="QBeasiswa_Penerima_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Jurusan->Visible) { // Jurusan ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Jurusan) == "") { ?>
		<th data-name="Jurusan" class="<?php echo $QBeasiswa_Penerima_list->Jurusan->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_Jurusan" class="QBeasiswa_Penerima_Jurusan"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Jurusan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jurusan" class="<?php echo $QBeasiswa_Penerima_list->Jurusan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Jurusan) ?>', 1);"><div id="elh_QBeasiswa_Penerima_Jurusan" class="QBeasiswa_Penerima_Jurusan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Jurusan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->Jurusan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->Jurusan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Program->Visible) { // Program ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Program) == "") { ?>
		<th data-name="Program" class="<?php echo $QBeasiswa_Penerima_list->Program->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_Program" class="QBeasiswa_Penerima_Program"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Program->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Program" class="<?php echo $QBeasiswa_Penerima_list->Program->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Program) ?>', 1);"><div id="elh_QBeasiswa_Penerima_Program" class="QBeasiswa_Penerima_Program">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Program->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->Program->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->Program->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->IDBeasiswa->Visible) { // IDBeasiswa ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->IDBeasiswa) == "") { ?>
		<th data-name="IDBeasiswa" class="<?php echo $QBeasiswa_Penerima_list->IDBeasiswa->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_IDBeasiswa" class="QBeasiswa_Penerima_IDBeasiswa"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->IDBeasiswa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IDBeasiswa" class="<?php echo $QBeasiswa_Penerima_list->IDBeasiswa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->IDBeasiswa) ?>', 1);"><div id="elh_QBeasiswa_Penerima_IDBeasiswa" class="QBeasiswa_Penerima_IDBeasiswa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->IDBeasiswa->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->IDBeasiswa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->IDBeasiswa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->Status->Visible) { // Status ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Status) == "") { ?>
		<th data-name="Status" class="<?php echo $QBeasiswa_Penerima_list->Status->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_Status" class="QBeasiswa_Penerima_Status"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status" class="<?php echo $QBeasiswa_Penerima_list->Status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->Status) ?>', 1);"><div id="elh_QBeasiswa_Penerima_Status" class="QBeasiswa_Penerima_Status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->Status->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->Status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->Status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->IPK->Visible) { // IPK ?>
	<?php if ($QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->IPK) == "") { ?>
		<th data-name="IPK" class="<?php echo $QBeasiswa_Penerima_list->IPK->headerCellClass() ?>"><div id="elh_QBeasiswa_Penerima_IPK" class="QBeasiswa_Penerima_IPK"><div class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->IPK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IPK" class="<?php echo $QBeasiswa_Penerima_list->IPK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_Penerima_list->SortUrl($QBeasiswa_Penerima_list->IPK) ?>', 1);"><div id="elh_QBeasiswa_Penerima_IPK" class="QBeasiswa_Penerima_IPK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_Penerima_list->IPK->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_Penerima_list->IPK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_Penerima_list->IPK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$QBeasiswa_Penerima_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($QBeasiswa_Penerima_list->ExportAll && $QBeasiswa_Penerima_list->isExport()) {
	$QBeasiswa_Penerima_list->StopRecord = $QBeasiswa_Penerima_list->TotalRecords;
} else {

	// Set the last record to display
	if ($QBeasiswa_Penerima_list->TotalRecords > $QBeasiswa_Penerima_list->StartRecord + $QBeasiswa_Penerima_list->DisplayRecords - 1)
		$QBeasiswa_Penerima_list->StopRecord = $QBeasiswa_Penerima_list->StartRecord + $QBeasiswa_Penerima_list->DisplayRecords - 1;
	else
		$QBeasiswa_Penerima_list->StopRecord = $QBeasiswa_Penerima_list->TotalRecords;
}
$QBeasiswa_Penerima_list->RecordCount = $QBeasiswa_Penerima_list->StartRecord - 1;
if ($QBeasiswa_Penerima_list->Recordset && !$QBeasiswa_Penerima_list->Recordset->EOF) {
	$QBeasiswa_Penerima_list->Recordset->moveFirst();
	$selectLimit = $QBeasiswa_Penerima_list->UseSelectLimit;
	if (!$selectLimit && $QBeasiswa_Penerima_list->StartRecord > 1)
		$QBeasiswa_Penerima_list->Recordset->move($QBeasiswa_Penerima_list->StartRecord - 1);
} elseif (!$QBeasiswa_Penerima->AllowAddDeleteRow && $QBeasiswa_Penerima_list->StopRecord == 0) {
	$QBeasiswa_Penerima_list->StopRecord = $QBeasiswa_Penerima->GridAddRowCount;
}

// Initialize aggregate
$QBeasiswa_Penerima->RowType = ROWTYPE_AGGREGATEINIT;
$QBeasiswa_Penerima->resetAttributes();
$QBeasiswa_Penerima_list->renderRow();
while ($QBeasiswa_Penerima_list->RecordCount < $QBeasiswa_Penerima_list->StopRecord) {
	$QBeasiswa_Penerima_list->RecordCount++;
	if ($QBeasiswa_Penerima_list->RecordCount >= $QBeasiswa_Penerima_list->StartRecord) {
		$QBeasiswa_Penerima_list->RowCount++;

		// Set up key count
		$QBeasiswa_Penerima_list->KeyCount = $QBeasiswa_Penerima_list->RowIndex;

		// Init row class and style
		$QBeasiswa_Penerima->resetAttributes();
		$QBeasiswa_Penerima->CssClass = "";
		if ($QBeasiswa_Penerima_list->isGridAdd()) {
		} else {
			$QBeasiswa_Penerima_list->loadRowValues($QBeasiswa_Penerima_list->Recordset); // Load row values
		}
		$QBeasiswa_Penerima->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$QBeasiswa_Penerima->RowAttrs->merge(["data-rowindex" => $QBeasiswa_Penerima_list->RowCount, "id" => "r" . $QBeasiswa_Penerima_list->RowCount . "_QBeasiswa_Penerima", "data-rowtype" => $QBeasiswa_Penerima->RowType]);

		// Render row
		$QBeasiswa_Penerima_list->renderRow();

		// Render list options
		$QBeasiswa_Penerima_list->renderListOptions();
?>
	<tr <?php echo $QBeasiswa_Penerima->rowAttributes() ?>>
<?php

// Render list options (body, left)
$QBeasiswa_Penerima_list->ListOptions->render("body", "left", $QBeasiswa_Penerima_list->RowCount);
?>
	<?php if ($QBeasiswa_Penerima_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $QBeasiswa_Penerima_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_Kode_Fak">
<span<?php echo $QBeasiswa_Penerima_list->Kode_Fak->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
		<td data-name="Tahun_Akademik" <?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_Tahun_Akademik">
<span<?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->Tahun_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $QBeasiswa_Penerima_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_Periode">
<span<?php echo $QBeasiswa_Penerima_list->Periode->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $QBeasiswa_Penerima_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_Nim">
<span<?php echo $QBeasiswa_Penerima_list->Nim->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $QBeasiswa_Penerima_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_Nama_Mhs">
<span<?php echo $QBeasiswa_Penerima_list->Nama_Mhs->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->Jurusan->Visible) { // Jurusan ?>
		<td data-name="Jurusan" <?php echo $QBeasiswa_Penerima_list->Jurusan->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_Jurusan">
<span<?php echo $QBeasiswa_Penerima_list->Jurusan->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->Jurusan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->Program->Visible) { // Program ?>
		<td data-name="Program" <?php echo $QBeasiswa_Penerima_list->Program->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_Program">
<span<?php echo $QBeasiswa_Penerima_list->Program->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->Program->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->IDBeasiswa->Visible) { // IDBeasiswa ?>
		<td data-name="IDBeasiswa" <?php echo $QBeasiswa_Penerima_list->IDBeasiswa->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_IDBeasiswa">
<span<?php echo $QBeasiswa_Penerima_list->IDBeasiswa->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->IDBeasiswa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->Status->Visible) { // Status ?>
		<td data-name="Status" <?php echo $QBeasiswa_Penerima_list->Status->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_Status">
<span<?php echo $QBeasiswa_Penerima_list->Status->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->Status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_Penerima_list->IPK->Visible) { // IPK ?>
		<td data-name="IPK" <?php echo $QBeasiswa_Penerima_list->IPK->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_Penerima_list->RowCount ?>_QBeasiswa_Penerima_IPK">
<span<?php echo $QBeasiswa_Penerima_list->IPK->viewAttributes() ?>><?php echo $QBeasiswa_Penerima_list->IPK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$QBeasiswa_Penerima_list->ListOptions->render("body", "right", $QBeasiswa_Penerima_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$QBeasiswa_Penerima_list->isGridAdd())
		$QBeasiswa_Penerima_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$QBeasiswa_Penerima->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($QBeasiswa_Penerima_list->Recordset)
	$QBeasiswa_Penerima_list->Recordset->Close();
?>
<?php if (!$QBeasiswa_Penerima_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$QBeasiswa_Penerima_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $QBeasiswa_Penerima_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $QBeasiswa_Penerima_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($QBeasiswa_Penerima_list->TotalRecords == 0 && !$QBeasiswa_Penerima->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $QBeasiswa_Penerima_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$QBeasiswa_Penerima_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$QBeasiswa_Penerima_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$QBeasiswa_Penerima_list->terminate();
?>