<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$QBeasiswa_list = new QBeasiswa_list();

// Run the page
$QBeasiswa_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$QBeasiswa_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$QBeasiswa_list->isExport()) { ?>
<script>
var fQBeasiswalist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fQBeasiswalist = currentForm = new ew.Form("fQBeasiswalist", "list");
	fQBeasiswalist.formKeyCountName = '<?php echo $QBeasiswa_list->FormKeyCountName ?>';
	loadjs.done("fQBeasiswalist");
});
var fQBeasiswalistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fQBeasiswalistsrch = currentSearchForm = new ew.Form("fQBeasiswalistsrch");

	// Validate function for search
	fQBeasiswalistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fQBeasiswalistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fQBeasiswalistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fQBeasiswalistsrch.lists["x_Tahun_Akademik"] = <?php echo $QBeasiswa_list->Tahun_Akademik->Lookup->toClientList($QBeasiswa_list) ?>;
	fQBeasiswalistsrch.lists["x_Tahun_Akademik"].options = <?php echo JsonEncode($QBeasiswa_list->Tahun_Akademik->lookupOptions()) ?>;
	fQBeasiswalistsrch.lists["x_Periode"] = <?php echo $QBeasiswa_list->Periode->Lookup->toClientList($QBeasiswa_list) ?>;
	fQBeasiswalistsrch.lists["x_Periode"].options = <?php echo JsonEncode($QBeasiswa_list->Periode->options(FALSE, TRUE)) ?>;
	fQBeasiswalistsrch.lists["x_IDBeasiswa"] = <?php echo $QBeasiswa_list->IDBeasiswa->Lookup->toClientList($QBeasiswa_list) ?>;
	fQBeasiswalistsrch.lists["x_IDBeasiswa"].options = <?php echo JsonEncode($QBeasiswa_list->IDBeasiswa->lookupOptions()) ?>;
	fQBeasiswalistsrch.lists["x_Kode_jp"] = <?php echo $QBeasiswa_list->Kode_jp->Lookup->toClientList($QBeasiswa_list) ?>;
	fQBeasiswalistsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($QBeasiswa_list->Kode_jp->lookupOptions()) ?>;

	// Filters
	fQBeasiswalistsrch.filterList = <?php echo $QBeasiswa_list->getFilterList() ?>;
	loadjs.done("fQBeasiswalistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$QBeasiswa_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($QBeasiswa_list->TotalRecords > 0 && $QBeasiswa_list->ExportOptions->visible()) { ?>
<?php $QBeasiswa_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($QBeasiswa_list->ImportOptions->visible()) { ?>
<?php $QBeasiswa_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($QBeasiswa_list->SearchOptions->visible()) { ?>
<?php $QBeasiswa_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($QBeasiswa_list->FilterOptions->visible()) { ?>
<?php $QBeasiswa_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$QBeasiswa_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$QBeasiswa_list->isExport() && !$QBeasiswa->CurrentAction) { ?>
<form name="fQBeasiswalistsrch" id="fQBeasiswalistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fQBeasiswalistsrch-search-panel" class="<?php echo $QBeasiswa_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="QBeasiswa">
	<div class="ew-extended-search">
<?php

// Render search row
$QBeasiswa->RowType = ROWTYPE_SEARCH;
$QBeasiswa->resetAttributes();
$QBeasiswa_list->renderRow();
?>
<?php if ($QBeasiswa_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
	<?php
		$QBeasiswa_list->SearchColumnCount++;
		if (($QBeasiswa_list->SearchColumnCount - 1) % $QBeasiswa_list->SearchFieldsPerRow == 0) {
			$QBeasiswa_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QBeasiswa_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Tahun_Akademik" class="ew-cell form-group">
		<label for="x_Tahun_Akademik" class="ew-search-caption ew-label"><?php echo $QBeasiswa_list->Tahun_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Tahun_Akademik" id="z_Tahun_Akademik" value="LIKE">
</span>
		<span id="el_QBeasiswa_Tahun_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QBeasiswa" data-field="x_Tahun_Akademik" data-value-separator="<?php echo $QBeasiswa_list->Tahun_Akademik->displayValueSeparatorAttribute() ?>" id="x_Tahun_Akademik" name="x_Tahun_Akademik"<?php echo $QBeasiswa_list->Tahun_Akademik->editAttributes() ?>>
			<?php echo $QBeasiswa_list->Tahun_Akademik->selectOptionListHtml("x_Tahun_Akademik") ?>
		</select>
</div>
<?php echo $QBeasiswa_list->Tahun_Akademik->Lookup->getParamTag($QBeasiswa_list, "p_x_Tahun_Akademik") ?>
</span>
	</div>
	<?php if ($QBeasiswa_list->SearchColumnCount % $QBeasiswa_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Periode->Visible) { // Periode ?>
	<?php
		$QBeasiswa_list->SearchColumnCount++;
		if (($QBeasiswa_list->SearchColumnCount - 1) % $QBeasiswa_list->SearchFieldsPerRow == 0) {
			$QBeasiswa_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QBeasiswa_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $QBeasiswa_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_QBeasiswa_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QBeasiswa" data-field="x_Periode" data-value-separator="<?php echo $QBeasiswa_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $QBeasiswa_list->Periode->editAttributes() ?>>
			<?php echo $QBeasiswa_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($QBeasiswa_list->SearchColumnCount % $QBeasiswa_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->IDBeasiswa->Visible) { // IDBeasiswa ?>
	<?php
		$QBeasiswa_list->SearchColumnCount++;
		if (($QBeasiswa_list->SearchColumnCount - 1) % $QBeasiswa_list->SearchFieldsPerRow == 0) {
			$QBeasiswa_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QBeasiswa_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_IDBeasiswa" class="ew-cell form-group">
		<label for="x_IDBeasiswa" class="ew-search-caption ew-label"><?php echo $QBeasiswa_list->IDBeasiswa->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("=") ?>
<input type="hidden" name="z_IDBeasiswa" id="z_IDBeasiswa" value="=">
</span>
		<span id="el_QBeasiswa_IDBeasiswa" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QBeasiswa" data-field="x_IDBeasiswa" data-value-separator="<?php echo $QBeasiswa_list->IDBeasiswa->displayValueSeparatorAttribute() ?>" id="x_IDBeasiswa" name="x_IDBeasiswa"<?php echo $QBeasiswa_list->IDBeasiswa->editAttributes() ?>>
			<?php echo $QBeasiswa_list->IDBeasiswa->selectOptionListHtml("x_IDBeasiswa") ?>
		</select>
</div>
<?php echo $QBeasiswa_list->IDBeasiswa->Lookup->getParamTag($QBeasiswa_list, "p_x_IDBeasiswa") ?>
</span>
	</div>
	<?php if ($QBeasiswa_list->SearchColumnCount % $QBeasiswa_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$QBeasiswa_list->SearchColumnCount++;
		if (($QBeasiswa_list->SearchColumnCount - 1) % $QBeasiswa_list->SearchFieldsPerRow == 0) {
			$QBeasiswa_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QBeasiswa_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $QBeasiswa_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_QBeasiswa_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QBeasiswa" data-field="x_Kode_jp" data-value-separator="<?php echo $QBeasiswa_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $QBeasiswa_list->Kode_jp->editAttributes() ?>>
			<?php echo $QBeasiswa_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $QBeasiswa_list->Kode_jp->Lookup->getParamTag($QBeasiswa_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($QBeasiswa_list->SearchColumnCount % $QBeasiswa_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($QBeasiswa_list->SearchColumnCount % $QBeasiswa_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $QBeasiswa_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($QBeasiswa_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($QBeasiswa_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $QBeasiswa_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($QBeasiswa_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($QBeasiswa_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($QBeasiswa_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($QBeasiswa_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $QBeasiswa_list->showPageHeader(); ?>
<?php
$QBeasiswa_list->showMessage();
?>
<?php if ($QBeasiswa_list->TotalRecords > 0 || $QBeasiswa->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($QBeasiswa_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> QBeasiswa">
<form name="fQBeasiswalist" id="fQBeasiswalist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="QBeasiswa">
<div id="gmp_QBeasiswa" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($QBeasiswa_list->TotalRecords > 0 || $QBeasiswa_list->isGridEdit()) { ?>
<table id="tbl_QBeasiswalist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$QBeasiswa->RowType = ROWTYPE_HEADER;

// Render list options
$QBeasiswa_list->renderListOptions();

// Render list options (header, left)
$QBeasiswa_list->ListOptions->render("header", "left");
?>
<?php if ($QBeasiswa_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Tahun_Akademik) == "") { ?>
		<th data-name="Tahun_Akademik" class="<?php echo $QBeasiswa_list->Tahun_Akademik->headerCellClass() ?>"><div id="elh_QBeasiswa_Tahun_Akademik" class="QBeasiswa_Tahun_Akademik"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Tahun_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tahun_Akademik" class="<?php echo $QBeasiswa_list->Tahun_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Tahun_Akademik) ?>', 1);"><div id="elh_QBeasiswa_Tahun_Akademik" class="QBeasiswa_Tahun_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Tahun_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Tahun_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Tahun_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Periode->Visible) { // Periode ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $QBeasiswa_list->Periode->headerCellClass() ?>"><div id="elh_QBeasiswa_Periode" class="QBeasiswa_Periode"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $QBeasiswa_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Periode) ?>', 1);"><div id="elh_QBeasiswa_Periode" class="QBeasiswa_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->IDBeasiswa->Visible) { // IDBeasiswa ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->IDBeasiswa) == "") { ?>
		<th data-name="IDBeasiswa" class="<?php echo $QBeasiswa_list->IDBeasiswa->headerCellClass() ?>"><div id="elh_QBeasiswa_IDBeasiswa" class="QBeasiswa_IDBeasiswa"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->IDBeasiswa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IDBeasiswa" class="<?php echo $QBeasiswa_list->IDBeasiswa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->IDBeasiswa) ?>', 1);"><div id="elh_QBeasiswa_IDBeasiswa" class="QBeasiswa_IDBeasiswa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->IDBeasiswa->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->IDBeasiswa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->IDBeasiswa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Nim->Visible) { // Nim ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $QBeasiswa_list->Nim->headerCellClass() ?>"><div id="elh_QBeasiswa_Nim" class="QBeasiswa_Nim"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $QBeasiswa_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Nim) ?>', 1);"><div id="elh_QBeasiswa_Nim" class="QBeasiswa_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $QBeasiswa_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_QBeasiswa_Nama_Mhs" class="QBeasiswa_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $QBeasiswa_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Nama_Mhs) ?>', 1);"><div id="elh_QBeasiswa_Nama_Mhs" class="QBeasiswa_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $QBeasiswa_list->Kode_jp->headerCellClass() ?>"><div id="elh_QBeasiswa_Kode_jp" class="QBeasiswa_Kode_jp"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $QBeasiswa_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Kode_jp) ?>', 1);"><div id="elh_QBeasiswa_Kode_jp" class="QBeasiswa_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Tlp_Mhs) == "") { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $QBeasiswa_list->Tlp_Mhs->headerCellClass() ?>"><div id="elh_QBeasiswa_Tlp_Mhs" class="QBeasiswa_Tlp_Mhs"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Tlp_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $QBeasiswa_list->Tlp_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Tlp_Mhs) ?>', 1);"><div id="elh_QBeasiswa_Tlp_Mhs" class="QBeasiswa_Tlp_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Tlp_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Tlp_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Tlp_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $QBeasiswa_list->Status_Akd->headerCellClass() ?>"><div id="elh_QBeasiswa_Status_Akd" class="QBeasiswa_Status_Akd"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $QBeasiswa_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Status_Akd) ?>', 1);"><div id="elh_QBeasiswa_Status_Akd" class="QBeasiswa_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Status_Akd->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->JmlSemester->Visible) { // JmlSemester ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->JmlSemester) == "") { ?>
		<th data-name="JmlSemester" class="<?php echo $QBeasiswa_list->JmlSemester->headerCellClass() ?>"><div id="elh_QBeasiswa_JmlSemester" class="QBeasiswa_JmlSemester"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->JmlSemester->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JmlSemester" class="<?php echo $QBeasiswa_list->JmlSemester->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->JmlSemester) ?>', 1);"><div id="elh_QBeasiswa_JmlSemester" class="QBeasiswa_JmlSemester">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->JmlSemester->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->JmlSemester->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->JmlSemester->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->BiayaPerSemester->Visible) { // BiayaPerSemester ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->BiayaPerSemester) == "") { ?>
		<th data-name="BiayaPerSemester" class="<?php echo $QBeasiswa_list->BiayaPerSemester->headerCellClass() ?>"><div id="elh_QBeasiswa_BiayaPerSemester" class="QBeasiswa_BiayaPerSemester"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->BiayaPerSemester->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BiayaPerSemester" class="<?php echo $QBeasiswa_list->BiayaPerSemester->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->BiayaPerSemester) ?>', 1);"><div id="elh_QBeasiswa_BiayaPerSemester" class="QBeasiswa_BiayaPerSemester">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->BiayaPerSemester->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->BiayaPerSemester->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->BiayaPerSemester->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->TSKS->Visible) { // TSKS ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->TSKS) == "") { ?>
		<th data-name="TSKS" class="<?php echo $QBeasiswa_list->TSKS->headerCellClass() ?>"><div id="elh_QBeasiswa_TSKS" class="QBeasiswa_TSKS"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->TSKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TSKS" class="<?php echo $QBeasiswa_list->TSKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->TSKS) ?>', 1);"><div id="elh_QBeasiswa_TSKS" class="QBeasiswa_TSKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->TSKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->TSKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->TSKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Ipk->Visible) { // Ipk ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Ipk) == "") { ?>
		<th data-name="Ipk" class="<?php echo $QBeasiswa_list->Ipk->headerCellClass() ?>"><div id="elh_QBeasiswa_Ipk" class="QBeasiswa_Ipk"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Ipk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ipk" class="<?php echo $QBeasiswa_list->Ipk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Ipk) ?>', 1);"><div id="elh_QBeasiswa_Ipk" class="QBeasiswa_Ipk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Ipk->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Ipk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Ipk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QBeasiswa_list->Status->Visible) { // Status ?>
	<?php if ($QBeasiswa_list->SortUrl($QBeasiswa_list->Status) == "") { ?>
		<th data-name="Status" class="<?php echo $QBeasiswa_list->Status->headerCellClass() ?>"><div id="elh_QBeasiswa_Status" class="QBeasiswa_Status"><div class="ew-table-header-caption"><?php echo $QBeasiswa_list->Status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status" class="<?php echo $QBeasiswa_list->Status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QBeasiswa_list->SortUrl($QBeasiswa_list->Status) ?>', 1);"><div id="elh_QBeasiswa_Status" class="QBeasiswa_Status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QBeasiswa_list->Status->caption() ?></span><span class="ew-table-header-sort"><?php if ($QBeasiswa_list->Status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QBeasiswa_list->Status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$QBeasiswa_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($QBeasiswa_list->ExportAll && $QBeasiswa_list->isExport()) {
	$QBeasiswa_list->StopRecord = $QBeasiswa_list->TotalRecords;
} else {

	// Set the last record to display
	if ($QBeasiswa_list->TotalRecords > $QBeasiswa_list->StartRecord + $QBeasiswa_list->DisplayRecords - 1)
		$QBeasiswa_list->StopRecord = $QBeasiswa_list->StartRecord + $QBeasiswa_list->DisplayRecords - 1;
	else
		$QBeasiswa_list->StopRecord = $QBeasiswa_list->TotalRecords;
}
$QBeasiswa_list->RecordCount = $QBeasiswa_list->StartRecord - 1;
if ($QBeasiswa_list->Recordset && !$QBeasiswa_list->Recordset->EOF) {
	$QBeasiswa_list->Recordset->moveFirst();
	$selectLimit = $QBeasiswa_list->UseSelectLimit;
	if (!$selectLimit && $QBeasiswa_list->StartRecord > 1)
		$QBeasiswa_list->Recordset->move($QBeasiswa_list->StartRecord - 1);
} elseif (!$QBeasiswa->AllowAddDeleteRow && $QBeasiswa_list->StopRecord == 0) {
	$QBeasiswa_list->StopRecord = $QBeasiswa->GridAddRowCount;
}

// Initialize aggregate
$QBeasiswa->RowType = ROWTYPE_AGGREGATEINIT;
$QBeasiswa->resetAttributes();
$QBeasiswa_list->renderRow();
while ($QBeasiswa_list->RecordCount < $QBeasiswa_list->StopRecord) {
	$QBeasiswa_list->RecordCount++;
	if ($QBeasiswa_list->RecordCount >= $QBeasiswa_list->StartRecord) {
		$QBeasiswa_list->RowCount++;

		// Set up key count
		$QBeasiswa_list->KeyCount = $QBeasiswa_list->RowIndex;

		// Init row class and style
		$QBeasiswa->resetAttributes();
		$QBeasiswa->CssClass = "";
		if ($QBeasiswa_list->isGridAdd()) {
		} else {
			$QBeasiswa_list->loadRowValues($QBeasiswa_list->Recordset); // Load row values
		}
		$QBeasiswa->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$QBeasiswa->RowAttrs->merge(["data-rowindex" => $QBeasiswa_list->RowCount, "id" => "r" . $QBeasiswa_list->RowCount . "_QBeasiswa", "data-rowtype" => $QBeasiswa->RowType]);

		// Render row
		$QBeasiswa_list->renderRow();

		// Render list options
		$QBeasiswa_list->renderListOptions();
?>
	<tr <?php echo $QBeasiswa->rowAttributes() ?>>
<?php

// Render list options (body, left)
$QBeasiswa_list->ListOptions->render("body", "left", $QBeasiswa_list->RowCount);
?>
	<?php if ($QBeasiswa_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
		<td data-name="Tahun_Akademik" <?php echo $QBeasiswa_list->Tahun_Akademik->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Tahun_Akademik">
<span<?php echo $QBeasiswa_list->Tahun_Akademik->viewAttributes() ?>><?php echo $QBeasiswa_list->Tahun_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $QBeasiswa_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Periode">
<span<?php echo $QBeasiswa_list->Periode->viewAttributes() ?>><?php echo $QBeasiswa_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->IDBeasiswa->Visible) { // IDBeasiswa ?>
		<td data-name="IDBeasiswa" <?php echo $QBeasiswa_list->IDBeasiswa->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_IDBeasiswa">
<span<?php echo $QBeasiswa_list->IDBeasiswa->viewAttributes() ?>><?php echo $QBeasiswa_list->IDBeasiswa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $QBeasiswa_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Nim">
<span<?php echo $QBeasiswa_list->Nim->viewAttributes() ?>><?php echo $QBeasiswa_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $QBeasiswa_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Nama_Mhs">
<span<?php echo $QBeasiswa_list->Nama_Mhs->viewAttributes() ?>><?php echo $QBeasiswa_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $QBeasiswa_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Kode_jp">
<span<?php echo $QBeasiswa_list->Kode_jp->viewAttributes() ?>><?php echo $QBeasiswa_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
		<td data-name="Tlp_Mhs" <?php echo $QBeasiswa_list->Tlp_Mhs->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Tlp_Mhs">
<span<?php echo $QBeasiswa_list->Tlp_Mhs->viewAttributes() ?>><?php if (!EmptyString($QBeasiswa_list->Tlp_Mhs->getViewValue()) && $QBeasiswa_list->Tlp_Mhs->linkAttributes() != "") { ?>
<a<?php echo $QBeasiswa_list->Tlp_Mhs->linkAttributes() ?>><?php echo $QBeasiswa_list->Tlp_Mhs->getViewValue() ?></a>
<?php } else { ?>
<?php echo $QBeasiswa_list->Tlp_Mhs->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $QBeasiswa_list->Status_Akd->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Status_Akd">
<span<?php echo $QBeasiswa_list->Status_Akd->viewAttributes() ?>><?php echo $QBeasiswa_list->Status_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->JmlSemester->Visible) { // JmlSemester ?>
		<td data-name="JmlSemester" <?php echo $QBeasiswa_list->JmlSemester->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_JmlSemester">
<span<?php echo $QBeasiswa_list->JmlSemester->viewAttributes() ?>><?php echo $QBeasiswa_list->JmlSemester->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->BiayaPerSemester->Visible) { // BiayaPerSemester ?>
		<td data-name="BiayaPerSemester" <?php echo $QBeasiswa_list->BiayaPerSemester->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_BiayaPerSemester">
<span<?php echo $QBeasiswa_list->BiayaPerSemester->viewAttributes() ?>><?php echo $QBeasiswa_list->BiayaPerSemester->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->TSKS->Visible) { // TSKS ?>
		<td data-name="TSKS" <?php echo $QBeasiswa_list->TSKS->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_TSKS">
<span<?php echo $QBeasiswa_list->TSKS->viewAttributes() ?>><?php echo $QBeasiswa_list->TSKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->Ipk->Visible) { // Ipk ?>
		<td data-name="Ipk" <?php echo $QBeasiswa_list->Ipk->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Ipk">
<span<?php echo $QBeasiswa_list->Ipk->viewAttributes() ?>><?php echo $QBeasiswa_list->Ipk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QBeasiswa_list->Status->Visible) { // Status ?>
		<td data-name="Status" <?php echo $QBeasiswa_list->Status->cellAttributes() ?>>
<span id="el<?php echo $QBeasiswa_list->RowCount ?>_QBeasiswa_Status">
<span<?php echo $QBeasiswa_list->Status->viewAttributes() ?>><?php echo $QBeasiswa_list->Status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$QBeasiswa_list->ListOptions->render("body", "right", $QBeasiswa_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$QBeasiswa_list->isGridAdd())
		$QBeasiswa_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$QBeasiswa->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($QBeasiswa_list->Recordset)
	$QBeasiswa_list->Recordset->Close();
?>
<?php if (!$QBeasiswa_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$QBeasiswa_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $QBeasiswa_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $QBeasiswa_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($QBeasiswa_list->TotalRecords == 0 && !$QBeasiswa->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $QBeasiswa_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$QBeasiswa_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$QBeasiswa_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$QBeasiswa_list->terminate();
?>