<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$QFak_list = new QFak_list();

// Run the page
$QFak_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$QFak_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$QFak_list->isExport()) { ?>
<script>
var fQFaklist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fQFaklist = currentForm = new ew.Form("fQFaklist", "list");
	fQFaklist.formKeyCountName = '<?php echo $QFak_list->FormKeyCountName ?>';
	loadjs.done("fQFaklist");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$QFak_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($QFak_list->TotalRecords > 0 && $QFak_list->ExportOptions->visible()) { ?>
<?php $QFak_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($QFak_list->ImportOptions->visible()) { ?>
<?php $QFak_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$QFak_list->renderOtherOptions();
?>
<?php $QFak_list->showPageHeader(); ?>
<?php
$QFak_list->showMessage();
?>
<?php if ($QFak_list->TotalRecords > 0 || $QFak->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($QFak_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> QFak">
<form name="fQFaklist" id="fQFaklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="QFak">
<div id="gmp_QFak" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($QFak_list->TotalRecords > 0 || $QFak_list->isGridEdit()) { ?>
<table id="tbl_QFaklist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$QFak->RowType = ROWTYPE_HEADER;

// Render list options
$QFak_list->renderListOptions();

// Render list options (header, left)
$QFak_list->ListOptions->render("header", "left");
?>
<?php if ($QFak_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($QFak_list->SortUrl($QFak_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $QFak_list->Kode_Fak->headerCellClass() ?>"><div id="elh_QFak_Kode_Fak" class="QFak_Kode_Fak"><div class="ew-table-header-caption"><?php echo $QFak_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $QFak_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QFak_list->SortUrl($QFak_list->Kode_Fak) ?>', 1);"><div id="elh_QFak_Kode_Fak" class="QFak_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QFak_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($QFak_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QFak_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QFak_list->Nama_Panjang->Visible) { // Nama_Panjang ?>
	<?php if ($QFak_list->SortUrl($QFak_list->Nama_Panjang) == "") { ?>
		<th data-name="Nama_Panjang" class="<?php echo $QFak_list->Nama_Panjang->headerCellClass() ?>"><div id="elh_QFak_Nama_Panjang" class="QFak_Nama_Panjang"><div class="ew-table-header-caption"><?php echo $QFak_list->Nama_Panjang->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Panjang" class="<?php echo $QFak_list->Nama_Panjang->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QFak_list->SortUrl($QFak_list->Nama_Panjang) ?>', 1);"><div id="elh_QFak_Nama_Panjang" class="QFak_Nama_Panjang">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QFak_list->Nama_Panjang->caption() ?></span><span class="ew-table-header-sort"><?php if ($QFak_list->Nama_Panjang->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QFak_list->Nama_Panjang->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QFak_list->Nama_Fak->Visible) { // Nama_Fak ?>
	<?php if ($QFak_list->SortUrl($QFak_list->Nama_Fak) == "") { ?>
		<th data-name="Nama_Fak" class="<?php echo $QFak_list->Nama_Fak->headerCellClass() ?>"><div id="elh_QFak_Nama_Fak" class="QFak_Nama_Fak"><div class="ew-table-header-caption"><?php echo $QFak_list->Nama_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Fak" class="<?php echo $QFak_list->Nama_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QFak_list->SortUrl($QFak_list->Nama_Fak) ?>', 1);"><div id="elh_QFak_Nama_Fak" class="QFak_Nama_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QFak_list->Nama_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($QFak_list->Nama_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QFak_list->Nama_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$QFak_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($QFak_list->ExportAll && $QFak_list->isExport()) {
	$QFak_list->StopRecord = $QFak_list->TotalRecords;
} else {

	// Set the last record to display
	if ($QFak_list->TotalRecords > $QFak_list->StartRecord + $QFak_list->DisplayRecords - 1)
		$QFak_list->StopRecord = $QFak_list->StartRecord + $QFak_list->DisplayRecords - 1;
	else
		$QFak_list->StopRecord = $QFak_list->TotalRecords;
}
$QFak_list->RecordCount = $QFak_list->StartRecord - 1;
if ($QFak_list->Recordset && !$QFak_list->Recordset->EOF) {
	$QFak_list->Recordset->moveFirst();
	$selectLimit = $QFak_list->UseSelectLimit;
	if (!$selectLimit && $QFak_list->StartRecord > 1)
		$QFak_list->Recordset->move($QFak_list->StartRecord - 1);
} elseif (!$QFak->AllowAddDeleteRow && $QFak_list->StopRecord == 0) {
	$QFak_list->StopRecord = $QFak->GridAddRowCount;
}

// Initialize aggregate
$QFak->RowType = ROWTYPE_AGGREGATEINIT;
$QFak->resetAttributes();
$QFak_list->renderRow();
while ($QFak_list->RecordCount < $QFak_list->StopRecord) {
	$QFak_list->RecordCount++;
	if ($QFak_list->RecordCount >= $QFak_list->StartRecord) {
		$QFak_list->RowCount++;

		// Set up key count
		$QFak_list->KeyCount = $QFak_list->RowIndex;

		// Init row class and style
		$QFak->resetAttributes();
		$QFak->CssClass = "";
		if ($QFak_list->isGridAdd()) {
		} else {
			$QFak_list->loadRowValues($QFak_list->Recordset); // Load row values
		}
		$QFak->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$QFak->RowAttrs->merge(["data-rowindex" => $QFak_list->RowCount, "id" => "r" . $QFak_list->RowCount . "_QFak", "data-rowtype" => $QFak->RowType]);

		// Render row
		$QFak_list->renderRow();

		// Render list options
		$QFak_list->renderListOptions();
?>
	<tr <?php echo $QFak->rowAttributes() ?>>
<?php

// Render list options (body, left)
$QFak_list->ListOptions->render("body", "left", $QFak_list->RowCount);
?>
	<?php if ($QFak_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $QFak_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $QFak_list->RowCount ?>_QFak_Kode_Fak">
<span<?php echo $QFak_list->Kode_Fak->viewAttributes() ?>><?php echo $QFak_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QFak_list->Nama_Panjang->Visible) { // Nama_Panjang ?>
		<td data-name="Nama_Panjang" <?php echo $QFak_list->Nama_Panjang->cellAttributes() ?>>
<span id="el<?php echo $QFak_list->RowCount ?>_QFak_Nama_Panjang">
<span<?php echo $QFak_list->Nama_Panjang->viewAttributes() ?>><?php echo $QFak_list->Nama_Panjang->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QFak_list->Nama_Fak->Visible) { // Nama_Fak ?>
		<td data-name="Nama_Fak" <?php echo $QFak_list->Nama_Fak->cellAttributes() ?>>
<span id="el<?php echo $QFak_list->RowCount ?>_QFak_Nama_Fak">
<span<?php echo $QFak_list->Nama_Fak->viewAttributes() ?>><?php echo $QFak_list->Nama_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$QFak_list->ListOptions->render("body", "right", $QFak_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$QFak_list->isGridAdd())
		$QFak_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$QFak->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($QFak_list->Recordset)
	$QFak_list->Recordset->Close();
?>
<?php if (!$QFak_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$QFak_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $QFak_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $QFak_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($QFak_list->TotalRecords == 0 && !$QFak->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $QFak_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$QFak_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$QFak_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$QFak_list->terminate();
?>