<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$QPerawali_list = new QPerawali_list();

// Run the page
$QPerawali_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$QPerawali_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$QPerawali_list->isExport()) { ?>
<script>
var fQPerawalilist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fQPerawalilist = currentForm = new ew.Form("fQPerawalilist", "list");
	fQPerawalilist.formKeyCountName = '<?php echo $QPerawali_list->FormKeyCountName ?>';
	loadjs.done("fQPerawalilist");
});
var fQPerawalilistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fQPerawalilistsrch = currentSearchForm = new ew.Form("fQPerawalilistsrch");

	// Dynamic selection lists
	// Filters

	fQPerawalilistsrch.filterList = <?php echo $QPerawali_list->getFilterList() ?>;
	loadjs.done("fQPerawalilistsrch");
});
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script>
loadjs.ready("head", function() {
	ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
	ew.PREVIEW_SINGLE_ROW = false;
	ew.PREVIEW_OVERLAY = false;
	loadjs("js/ewpreview.js", "preview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$QPerawali_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($QPerawali_list->TotalRecords > 0 && $QPerawali_list->ExportOptions->visible()) { ?>
<?php $QPerawali_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($QPerawali_list->ImportOptions->visible()) { ?>
<?php $QPerawali_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($QPerawali_list->SearchOptions->visible()) { ?>
<?php $QPerawali_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($QPerawali_list->FilterOptions->visible()) { ?>
<?php $QPerawali_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$QPerawali_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$QPerawali_list->isExport() && !$QPerawali->CurrentAction) { ?>
<form name="fQPerawalilistsrch" id="fQPerawalilistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fQPerawalilistsrch-search-panel" class="<?php echo $QPerawali_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="QPerawali">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $QPerawali_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($QPerawali_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($QPerawali_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $QPerawali_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($QPerawali_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($QPerawali_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($QPerawali_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($QPerawali_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $QPerawali_list->showPageHeader(); ?>
<?php
$QPerawali_list->showMessage();
?>
<?php if ($QPerawali_list->TotalRecords > 0 || $QPerawali->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($QPerawali_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> QPerawali">
<form name="fQPerawalilist" id="fQPerawalilist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="QPerawali">
<div id="gmp_QPerawali" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($QPerawali_list->TotalRecords > 0 || $QPerawali_list->isGridEdit()) { ?>
<table id="tbl_QPerawalilist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$QPerawali->RowType = ROWTYPE_HEADER;

// Render list options
$QPerawali_list->renderListOptions();

// Render list options (header, left)
$QPerawali_list->ListOptions->render("header", "left");
?>
<?php if ($QPerawali_list->Periode->Visible) { // Periode ?>
	<?php if ($QPerawali_list->SortUrl($QPerawali_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $QPerawali_list->Periode->headerCellClass() ?>"><div id="elh_QPerawali_Periode" class="QPerawali_Periode"><div class="ew-table-header-caption"><?php echo $QPerawali_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $QPerawali_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QPerawali_list->SortUrl($QPerawali_list->Periode) ?>', 1);"><div id="elh_QPerawali_Periode" class="QPerawali_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QPerawali_list->Periode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QPerawali_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QPerawali_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$QPerawali_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($QPerawali_list->ExportAll && $QPerawali_list->isExport()) {
	$QPerawali_list->StopRecord = $QPerawali_list->TotalRecords;
} else {

	// Set the last record to display
	if ($QPerawali_list->TotalRecords > $QPerawali_list->StartRecord + $QPerawali_list->DisplayRecords - 1)
		$QPerawali_list->StopRecord = $QPerawali_list->StartRecord + $QPerawali_list->DisplayRecords - 1;
	else
		$QPerawali_list->StopRecord = $QPerawali_list->TotalRecords;
}
$QPerawali_list->RecordCount = $QPerawali_list->StartRecord - 1;
if ($QPerawali_list->Recordset && !$QPerawali_list->Recordset->EOF) {
	$QPerawali_list->Recordset->moveFirst();
	$selectLimit = $QPerawali_list->UseSelectLimit;
	if (!$selectLimit && $QPerawali_list->StartRecord > 1)
		$QPerawali_list->Recordset->move($QPerawali_list->StartRecord - 1);
} elseif (!$QPerawali->AllowAddDeleteRow && $QPerawali_list->StopRecord == 0) {
	$QPerawali_list->StopRecord = $QPerawali->GridAddRowCount;
}

// Initialize aggregate
$QPerawali->RowType = ROWTYPE_AGGREGATEINIT;
$QPerawali->resetAttributes();
$QPerawali_list->renderRow();
while ($QPerawali_list->RecordCount < $QPerawali_list->StopRecord) {
	$QPerawali_list->RecordCount++;
	if ($QPerawali_list->RecordCount >= $QPerawali_list->StartRecord) {
		$QPerawali_list->RowCount++;

		// Set up key count
		$QPerawali_list->KeyCount = $QPerawali_list->RowIndex;

		// Init row class and style
		$QPerawali->resetAttributes();
		$QPerawali->CssClass = "";
		if ($QPerawali_list->isGridAdd()) {
		} else {
			$QPerawali_list->loadRowValues($QPerawali_list->Recordset); // Load row values
		}
		$QPerawali->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$QPerawali->RowAttrs->merge(["data-rowindex" => $QPerawali_list->RowCount, "id" => "r" . $QPerawali_list->RowCount . "_QPerawali", "data-rowtype" => $QPerawali->RowType]);

		// Render row
		$QPerawali_list->renderRow();

		// Render list options
		$QPerawali_list->renderListOptions();
?>
	<tr <?php echo $QPerawali->rowAttributes() ?>>
<?php

// Render list options (body, left)
$QPerawali_list->ListOptions->render("body", "left", $QPerawali_list->RowCount);
?>
	<?php if ($QPerawali_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $QPerawali_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $QPerawali_list->RowCount ?>_QPerawali_Periode">
<span<?php echo $QPerawali_list->Periode->viewAttributes() ?>><?php echo $QPerawali_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$QPerawali_list->ListOptions->render("body", "right", $QPerawali_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$QPerawali_list->isGridAdd())
		$QPerawali_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$QPerawali->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($QPerawali_list->Recordset)
	$QPerawali_list->Recordset->Close();
?>
<?php if (!$QPerawali_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$QPerawali_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $QPerawali_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $QPerawali_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($QPerawali_list->TotalRecords == 0 && !$QPerawali->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $QPerawali_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$QPerawali_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$QPerawali_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$QPerawali_list->terminate();
?>