<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$QThawali_list = new QThawali_list();

// Run the page
$QThawali_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$QThawali_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$QThawali_list->isExport()) { ?>
<script>
var fQThawalilist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fQThawalilist = currentForm = new ew.Form("fQThawalilist", "list");
	fQThawalilist.formKeyCountName = '<?php echo $QThawali_list->FormKeyCountName ?>';
	loadjs.done("fQThawalilist");
});
var fQThawalilistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fQThawalilistsrch = currentSearchForm = new ew.Form("fQThawalilistsrch");

	// Dynamic selection lists
	// Filters

	fQThawalilistsrch.filterList = <?php echo $QThawali_list->getFilterList() ?>;
	loadjs.done("fQThawalilistsrch");
});
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script>
loadjs.ready("head", function() {
	ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
	ew.PREVIEW_SINGLE_ROW = false;
	ew.PREVIEW_OVERLAY = false;
	loadjs("js/ewpreview.js", "preview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$QThawali_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($QThawali_list->TotalRecords > 0 && $QThawali_list->ExportOptions->visible()) { ?>
<?php $QThawali_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($QThawali_list->ImportOptions->visible()) { ?>
<?php $QThawali_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($QThawali_list->SearchOptions->visible()) { ?>
<?php $QThawali_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($QThawali_list->FilterOptions->visible()) { ?>
<?php $QThawali_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$QThawali_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$QThawali_list->isExport() && !$QThawali->CurrentAction) { ?>
<form name="fQThawalilistsrch" id="fQThawalilistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fQThawalilistsrch-search-panel" class="<?php echo $QThawali_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="QThawali">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $QThawali_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($QThawali_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($QThawali_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $QThawali_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($QThawali_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($QThawali_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($QThawali_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($QThawali_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $QThawali_list->showPageHeader(); ?>
<?php
$QThawali_list->showMessage();
?>
<?php if ($QThawali_list->TotalRecords > 0 || $QThawali->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($QThawali_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> QThawali">
<form name="fQThawalilist" id="fQThawalilist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="QThawali">
<div id="gmp_QThawali" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($QThawali_list->TotalRecords > 0 || $QThawali_list->isGridEdit()) { ?>
<table id="tbl_QThawalilist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$QThawali->RowType = ROWTYPE_HEADER;

// Render list options
$QThawali_list->renderListOptions();

// Render list options (header, left)
$QThawali_list->ListOptions->render("header", "left");
?>
<?php if ($QThawali_list->Th_Ak->Visible) { // Th_Ak ?>
	<?php if ($QThawali_list->SortUrl($QThawali_list->Th_Ak) == "") { ?>
		<th data-name="Th_Ak" class="<?php echo $QThawali_list->Th_Ak->headerCellClass() ?>"><div id="elh_QThawali_Th_Ak" class="QThawali_Th_Ak"><div class="ew-table-header-caption"><?php echo $QThawali_list->Th_Ak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Th_Ak" class="<?php echo $QThawali_list->Th_Ak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QThawali_list->SortUrl($QThawali_list->Th_Ak) ?>', 1);"><div id="elh_QThawali_Th_Ak" class="QThawali_Th_Ak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QThawali_list->Th_Ak->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QThawali_list->Th_Ak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QThawali_list->Th_Ak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$QThawali_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($QThawali_list->ExportAll && $QThawali_list->isExport()) {
	$QThawali_list->StopRecord = $QThawali_list->TotalRecords;
} else {

	// Set the last record to display
	if ($QThawali_list->TotalRecords > $QThawali_list->StartRecord + $QThawali_list->DisplayRecords - 1)
		$QThawali_list->StopRecord = $QThawali_list->StartRecord + $QThawali_list->DisplayRecords - 1;
	else
		$QThawali_list->StopRecord = $QThawali_list->TotalRecords;
}
$QThawali_list->RecordCount = $QThawali_list->StartRecord - 1;
if ($QThawali_list->Recordset && !$QThawali_list->Recordset->EOF) {
	$QThawali_list->Recordset->moveFirst();
	$selectLimit = $QThawali_list->UseSelectLimit;
	if (!$selectLimit && $QThawali_list->StartRecord > 1)
		$QThawali_list->Recordset->move($QThawali_list->StartRecord - 1);
} elseif (!$QThawali->AllowAddDeleteRow && $QThawali_list->StopRecord == 0) {
	$QThawali_list->StopRecord = $QThawali->GridAddRowCount;
}

// Initialize aggregate
$QThawali->RowType = ROWTYPE_AGGREGATEINIT;
$QThawali->resetAttributes();
$QThawali_list->renderRow();
while ($QThawali_list->RecordCount < $QThawali_list->StopRecord) {
	$QThawali_list->RecordCount++;
	if ($QThawali_list->RecordCount >= $QThawali_list->StartRecord) {
		$QThawali_list->RowCount++;

		// Set up key count
		$QThawali_list->KeyCount = $QThawali_list->RowIndex;

		// Init row class and style
		$QThawali->resetAttributes();
		$QThawali->CssClass = "";
		if ($QThawali_list->isGridAdd()) {
		} else {
			$QThawali_list->loadRowValues($QThawali_list->Recordset); // Load row values
		}
		$QThawali->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$QThawali->RowAttrs->merge(["data-rowindex" => $QThawali_list->RowCount, "id" => "r" . $QThawali_list->RowCount . "_QThawali", "data-rowtype" => $QThawali->RowType]);

		// Render row
		$QThawali_list->renderRow();

		// Render list options
		$QThawali_list->renderListOptions();
?>
	<tr <?php echo $QThawali->rowAttributes() ?>>
<?php

// Render list options (body, left)
$QThawali_list->ListOptions->render("body", "left", $QThawali_list->RowCount);
?>
	<?php if ($QThawali_list->Th_Ak->Visible) { // Th_Ak ?>
		<td data-name="Th_Ak" <?php echo $QThawali_list->Th_Ak->cellAttributes() ?>>
<span id="el<?php echo $QThawali_list->RowCount ?>_QThawali_Th_Ak">
<span<?php echo $QThawali_list->Th_Ak->viewAttributes() ?>><?php echo $QThawali_list->Th_Ak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$QThawali_list->ListOptions->render("body", "right", $QThawali_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$QThawali_list->isGridAdd())
		$QThawali_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$QThawali->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($QThawali_list->Recordset)
	$QThawali_list->Recordset->Close();
?>
<?php if (!$QThawali_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$QThawali_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $QThawali_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $QThawali_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($QThawali_list->TotalRecords == 0 && !$QThawali->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $QThawali_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$QThawali_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$QThawali_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$QThawali_list->terminate();
?>