<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$QmhsAktif_list = new QmhsAktif_list();

// Run the page
$QmhsAktif_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$QmhsAktif_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$QmhsAktif_list->isExport()) { ?>
<script>
var fQmhsAktiflist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fQmhsAktiflist = currentForm = new ew.Form("fQmhsAktiflist", "list");
	fQmhsAktiflist.formKeyCountName = '<?php echo $QmhsAktif_list->FormKeyCountName ?>';
	loadjs.done("fQmhsAktiflist");
});
var fQmhsAktiflistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fQmhsAktiflistsrch = currentSearchForm = new ew.Form("fQmhsAktiflistsrch");

	// Validate function for search
	fQmhsAktiflistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fQmhsAktiflistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fQmhsAktiflistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fQmhsAktiflistsrch.lists["x_Kode_Fak"] = <?php echo $QmhsAktif_list->Kode_Fak->Lookup->toClientList($QmhsAktif_list) ?>;
	fQmhsAktiflistsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($QmhsAktif_list->Kode_Fak->lookupOptions()) ?>;
	fQmhsAktiflistsrch.lists["x_Thn_Akademik"] = <?php echo $QmhsAktif_list->Thn_Akademik->Lookup->toClientList($QmhsAktif_list) ?>;
	fQmhsAktiflistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($QmhsAktif_list->Thn_Akademik->lookupOptions()) ?>;
	fQmhsAktiflistsrch.lists["x_Periode"] = <?php echo $QmhsAktif_list->Periode->Lookup->toClientList($QmhsAktif_list) ?>;
	fQmhsAktiflistsrch.lists["x_Periode"].options = <?php echo JsonEncode($QmhsAktif_list->Periode->options(FALSE, TRUE)) ?>;
	fQmhsAktiflistsrch.lists["x_Kode_jp"] = <?php echo $QmhsAktif_list->Kode_jp->Lookup->toClientList($QmhsAktif_list) ?>;
	fQmhsAktiflistsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($QmhsAktif_list->Kode_jp->lookupOptions()) ?>;

	// Filters
	fQmhsAktiflistsrch.filterList = <?php echo $QmhsAktif_list->getFilterList() ?>;
	loadjs.done("fQmhsAktiflistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$QmhsAktif_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($QmhsAktif_list->TotalRecords > 0 && $QmhsAktif_list->ExportOptions->visible()) { ?>
<?php $QmhsAktif_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($QmhsAktif_list->ImportOptions->visible()) { ?>
<?php $QmhsAktif_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($QmhsAktif_list->SearchOptions->visible()) { ?>
<?php $QmhsAktif_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($QmhsAktif_list->FilterOptions->visible()) { ?>
<?php $QmhsAktif_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$QmhsAktif_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$QmhsAktif_list->isExport() && !$QmhsAktif->CurrentAction) { ?>
<form name="fQmhsAktiflistsrch" id="fQmhsAktiflistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fQmhsAktiflistsrch-search-panel" class="<?php echo $QmhsAktif_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="QmhsAktif">
	<div class="ew-extended-search">
<?php

// Render search row
$QmhsAktif->RowType = ROWTYPE_SEARCH;
$QmhsAktif->resetAttributes();
$QmhsAktif_list->renderRow();
?>
<?php if ($QmhsAktif_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$QmhsAktif_list->SearchColumnCount++;
		if (($QmhsAktif_list->SearchColumnCount - 1) % $QmhsAktif_list->SearchFieldsPerRow == 0) {
			$QmhsAktif_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QmhsAktif_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $QmhsAktif_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_QmhsAktif_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QmhsAktif" data-field="x_Kode_Fak" data-value-separator="<?php echo $QmhsAktif_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $QmhsAktif_list->Kode_Fak->editAttributes() ?>>
			<?php echo $QmhsAktif_list->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $QmhsAktif_list->Kode_Fak->Lookup->getParamTag($QmhsAktif_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($QmhsAktif_list->SearchColumnCount % $QmhsAktif_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$QmhsAktif_list->SearchColumnCount++;
		if (($QmhsAktif_list->SearchColumnCount - 1) % $QmhsAktif_list->SearchFieldsPerRow == 0) {
			$QmhsAktif_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QmhsAktif_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $QmhsAktif_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_QmhsAktif_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QmhsAktif" data-field="x_Thn_Akademik" data-value-separator="<?php echo $QmhsAktif_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $QmhsAktif_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $QmhsAktif_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $QmhsAktif_list->Thn_Akademik->Lookup->getParamTag($QmhsAktif_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($QmhsAktif_list->SearchColumnCount % $QmhsAktif_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Periode->Visible) { // Periode ?>
	<?php
		$QmhsAktif_list->SearchColumnCount++;
		if (($QmhsAktif_list->SearchColumnCount - 1) % $QmhsAktif_list->SearchFieldsPerRow == 0) {
			$QmhsAktif_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QmhsAktif_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $QmhsAktif_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_QmhsAktif_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QmhsAktif" data-field="x_Periode" data-value-separator="<?php echo $QmhsAktif_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $QmhsAktif_list->Periode->editAttributes() ?>>
			<?php echo $QmhsAktif_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($QmhsAktif_list->SearchColumnCount % $QmhsAktif_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$QmhsAktif_list->SearchColumnCount++;
		if (($QmhsAktif_list->SearchColumnCount - 1) % $QmhsAktif_list->SearchFieldsPerRow == 0) {
			$QmhsAktif_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $QmhsAktif_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $QmhsAktif_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_QmhsAktif_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="QmhsAktif" data-field="x_Kode_jp" data-value-separator="<?php echo $QmhsAktif_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $QmhsAktif_list->Kode_jp->editAttributes() ?>>
			<?php echo $QmhsAktif_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $QmhsAktif_list->Kode_jp->Lookup->getParamTag($QmhsAktif_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($QmhsAktif_list->SearchColumnCount % $QmhsAktif_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($QmhsAktif_list->SearchColumnCount % $QmhsAktif_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $QmhsAktif_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($QmhsAktif_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($QmhsAktif_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $QmhsAktif_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($QmhsAktif_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($QmhsAktif_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($QmhsAktif_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($QmhsAktif_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $QmhsAktif_list->showPageHeader(); ?>
<?php
$QmhsAktif_list->showMessage();
?>
<?php if ($QmhsAktif_list->TotalRecords > 0 || $QmhsAktif->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($QmhsAktif_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> QmhsAktif">
<form name="fQmhsAktiflist" id="fQmhsAktiflist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="QmhsAktif">
<div id="gmp_QmhsAktif" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($QmhsAktif_list->TotalRecords > 0 || $QmhsAktif_list->isGridEdit()) { ?>
<table id="tbl_QmhsAktiflist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$QmhsAktif->RowType = ROWTYPE_HEADER;

// Render list options
$QmhsAktif_list->renderListOptions();

// Render list options (header, left)
$QmhsAktif_list->ListOptions->render("header", "left");
?>
<?php if ($QmhsAktif_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($QmhsAktif_list->SortUrl($QmhsAktif_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $QmhsAktif_list->Kode_Fak->headerCellClass() ?>"><div id="elh_QmhsAktif_Kode_Fak" class="QmhsAktif_Kode_Fak"><div class="ew-table-header-caption"><?php echo $QmhsAktif_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $QmhsAktif_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QmhsAktif_list->SortUrl($QmhsAktif_list->Kode_Fak) ?>', 1);"><div id="elh_QmhsAktif_Kode_Fak" class="QmhsAktif_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QmhsAktif_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($QmhsAktif_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QmhsAktif_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($QmhsAktif_list->SortUrl($QmhsAktif_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $QmhsAktif_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_QmhsAktif_Thn_Akademik" class="QmhsAktif_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $QmhsAktif_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $QmhsAktif_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QmhsAktif_list->SortUrl($QmhsAktif_list->Thn_Akademik) ?>', 1);"><div id="elh_QmhsAktif_Thn_Akademik" class="QmhsAktif_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QmhsAktif_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($QmhsAktif_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QmhsAktif_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Periode->Visible) { // Periode ?>
	<?php if ($QmhsAktif_list->SortUrl($QmhsAktif_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $QmhsAktif_list->Periode->headerCellClass() ?>"><div id="elh_QmhsAktif_Periode" class="QmhsAktif_Periode"><div class="ew-table-header-caption"><?php echo $QmhsAktif_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $QmhsAktif_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QmhsAktif_list->SortUrl($QmhsAktif_list->Periode) ?>', 1);"><div id="elh_QmhsAktif_Periode" class="QmhsAktif_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QmhsAktif_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($QmhsAktif_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QmhsAktif_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Nim->Visible) { // Nim ?>
	<?php if ($QmhsAktif_list->SortUrl($QmhsAktif_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $QmhsAktif_list->Nim->headerCellClass() ?>"><div id="elh_QmhsAktif_Nim" class="QmhsAktif_Nim"><div class="ew-table-header-caption"><?php echo $QmhsAktif_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $QmhsAktif_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QmhsAktif_list->SortUrl($QmhsAktif_list->Nim) ?>', 1);"><div id="elh_QmhsAktif_Nim" class="QmhsAktif_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QmhsAktif_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QmhsAktif_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QmhsAktif_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($QmhsAktif_list->SortUrl($QmhsAktif_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $QmhsAktif_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_QmhsAktif_Nama_Mhs" class="QmhsAktif_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $QmhsAktif_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $QmhsAktif_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QmhsAktif_list->SortUrl($QmhsAktif_list->Nama_Mhs) ?>', 1);"><div id="elh_QmhsAktif_Nama_Mhs" class="QmhsAktif_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QmhsAktif_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QmhsAktif_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QmhsAktif_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($QmhsAktif_list->SortUrl($QmhsAktif_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $QmhsAktif_list->Kode_jp->headerCellClass() ?>"><div id="elh_QmhsAktif_Kode_jp" class="QmhsAktif_Kode_jp"><div class="ew-table-header-caption"><?php echo $QmhsAktif_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $QmhsAktif_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QmhsAktif_list->SortUrl($QmhsAktif_list->Kode_jp) ?>', 1);"><div id="elh_QmhsAktif_Kode_jp" class="QmhsAktif_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QmhsAktif_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($QmhsAktif_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QmhsAktif_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($QmhsAktif_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
	<?php if ($QmhsAktif_list->SortUrl($QmhsAktif_list->Tlp_Mhs) == "") { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $QmhsAktif_list->Tlp_Mhs->headerCellClass() ?>"><div id="elh_QmhsAktif_Tlp_Mhs" class="QmhsAktif_Tlp_Mhs"><div class="ew-table-header-caption"><?php echo $QmhsAktif_list->Tlp_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $QmhsAktif_list->Tlp_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $QmhsAktif_list->SortUrl($QmhsAktif_list->Tlp_Mhs) ?>', 1);"><div id="elh_QmhsAktif_Tlp_Mhs" class="QmhsAktif_Tlp_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $QmhsAktif_list->Tlp_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($QmhsAktif_list->Tlp_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($QmhsAktif_list->Tlp_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$QmhsAktif_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($QmhsAktif_list->ExportAll && $QmhsAktif_list->isExport()) {
	$QmhsAktif_list->StopRecord = $QmhsAktif_list->TotalRecords;
} else {

	// Set the last record to display
	if ($QmhsAktif_list->TotalRecords > $QmhsAktif_list->StartRecord + $QmhsAktif_list->DisplayRecords - 1)
		$QmhsAktif_list->StopRecord = $QmhsAktif_list->StartRecord + $QmhsAktif_list->DisplayRecords - 1;
	else
		$QmhsAktif_list->StopRecord = $QmhsAktif_list->TotalRecords;
}
$QmhsAktif_list->RecordCount = $QmhsAktif_list->StartRecord - 1;
if ($QmhsAktif_list->Recordset && !$QmhsAktif_list->Recordset->EOF) {
	$QmhsAktif_list->Recordset->moveFirst();
	$selectLimit = $QmhsAktif_list->UseSelectLimit;
	if (!$selectLimit && $QmhsAktif_list->StartRecord > 1)
		$QmhsAktif_list->Recordset->move($QmhsAktif_list->StartRecord - 1);
} elseif (!$QmhsAktif->AllowAddDeleteRow && $QmhsAktif_list->StopRecord == 0) {
	$QmhsAktif_list->StopRecord = $QmhsAktif->GridAddRowCount;
}

// Initialize aggregate
$QmhsAktif->RowType = ROWTYPE_AGGREGATEINIT;
$QmhsAktif->resetAttributes();
$QmhsAktif_list->renderRow();
while ($QmhsAktif_list->RecordCount < $QmhsAktif_list->StopRecord) {
	$QmhsAktif_list->RecordCount++;
	if ($QmhsAktif_list->RecordCount >= $QmhsAktif_list->StartRecord) {
		$QmhsAktif_list->RowCount++;

		// Set up key count
		$QmhsAktif_list->KeyCount = $QmhsAktif_list->RowIndex;

		// Init row class and style
		$QmhsAktif->resetAttributes();
		$QmhsAktif->CssClass = "";
		if ($QmhsAktif_list->isGridAdd()) {
		} else {
			$QmhsAktif_list->loadRowValues($QmhsAktif_list->Recordset); // Load row values
		}
		$QmhsAktif->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$QmhsAktif->RowAttrs->merge(["data-rowindex" => $QmhsAktif_list->RowCount, "id" => "r" . $QmhsAktif_list->RowCount . "_QmhsAktif", "data-rowtype" => $QmhsAktif->RowType]);

		// Render row
		$QmhsAktif_list->renderRow();

		// Render list options
		$QmhsAktif_list->renderListOptions();
?>
	<tr <?php echo $QmhsAktif->rowAttributes() ?>>
<?php

// Render list options (body, left)
$QmhsAktif_list->ListOptions->render("body", "left", $QmhsAktif_list->RowCount);
?>
	<?php if ($QmhsAktif_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $QmhsAktif_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $QmhsAktif_list->RowCount ?>_QmhsAktif_Kode_Fak">
<span<?php echo $QmhsAktif_list->Kode_Fak->viewAttributes() ?>><?php echo $QmhsAktif_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QmhsAktif_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $QmhsAktif_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $QmhsAktif_list->RowCount ?>_QmhsAktif_Thn_Akademik">
<span<?php echo $QmhsAktif_list->Thn_Akademik->viewAttributes() ?>><?php echo $QmhsAktif_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QmhsAktif_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $QmhsAktif_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $QmhsAktif_list->RowCount ?>_QmhsAktif_Periode">
<span<?php echo $QmhsAktif_list->Periode->viewAttributes() ?>><?php echo $QmhsAktif_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QmhsAktif_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $QmhsAktif_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $QmhsAktif_list->RowCount ?>_QmhsAktif_Nim">
<span<?php echo $QmhsAktif_list->Nim->viewAttributes() ?>><?php echo $QmhsAktif_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QmhsAktif_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $QmhsAktif_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $QmhsAktif_list->RowCount ?>_QmhsAktif_Nama_Mhs">
<span<?php echo $QmhsAktif_list->Nama_Mhs->viewAttributes() ?>><?php echo $QmhsAktif_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QmhsAktif_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $QmhsAktif_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $QmhsAktif_list->RowCount ?>_QmhsAktif_Kode_jp">
<span<?php echo $QmhsAktif_list->Kode_jp->viewAttributes() ?>><?php echo $QmhsAktif_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($QmhsAktif_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
		<td data-name="Tlp_Mhs" <?php echo $QmhsAktif_list->Tlp_Mhs->cellAttributes() ?>>
<span id="el<?php echo $QmhsAktif_list->RowCount ?>_QmhsAktif_Tlp_Mhs">
<span<?php echo $QmhsAktif_list->Tlp_Mhs->viewAttributes() ?>><?php if (!EmptyString($QmhsAktif_list->Tlp_Mhs->getViewValue()) && $QmhsAktif_list->Tlp_Mhs->linkAttributes() != "") { ?>
<a<?php echo $QmhsAktif_list->Tlp_Mhs->linkAttributes() ?>><?php echo $QmhsAktif_list->Tlp_Mhs->getViewValue() ?></a>
<?php } else { ?>
<?php echo $QmhsAktif_list->Tlp_Mhs->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$QmhsAktif_list->ListOptions->render("body", "right", $QmhsAktif_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$QmhsAktif_list->isGridAdd())
		$QmhsAktif_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$QmhsAktif->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($QmhsAktif_list->Recordset)
	$QmhsAktif_list->Recordset->Close();
?>
<?php if (!$QmhsAktif_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$QmhsAktif_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $QmhsAktif_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $QmhsAktif_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($QmhsAktif_list->TotalRecords == 0 && !$QmhsAktif->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $QmhsAktif_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$QmhsAktif_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$QmhsAktif_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$QmhsAktif_list->terminate();
?>