<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$TBKOD_list = new TBKOD_list();

// Run the page
$TBKOD_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$TBKOD_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$TBKOD_list->isExport()) { ?>
<script>
var fTBKODlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fTBKODlist = currentForm = new ew.Form("fTBKODlist", "list");
	fTBKODlist.formKeyCountName = '<?php echo $TBKOD_list->FormKeyCountName ?>';
	loadjs.done("fTBKODlist");
});
var fTBKODlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fTBKODlistsrch = currentSearchForm = new ew.Form("fTBKODlistsrch");

	// Dynamic selection lists
	// Filters

	fTBKODlistsrch.filterList = <?php echo $TBKOD_list->getFilterList() ?>;
	loadjs.done("fTBKODlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$TBKOD_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($TBKOD_list->TotalRecords > 0 && $TBKOD_list->ExportOptions->visible()) { ?>
<?php $TBKOD_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($TBKOD_list->ImportOptions->visible()) { ?>
<?php $TBKOD_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($TBKOD_list->SearchOptions->visible()) { ?>
<?php $TBKOD_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($TBKOD_list->FilterOptions->visible()) { ?>
<?php $TBKOD_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$TBKOD_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$TBKOD_list->isExport() && !$TBKOD->CurrentAction) { ?>
<form name="fTBKODlistsrch" id="fTBKODlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fTBKODlistsrch-search-panel" class="<?php echo $TBKOD_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="TBKOD">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $TBKOD_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($TBKOD_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($TBKOD_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $TBKOD_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($TBKOD_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($TBKOD_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($TBKOD_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($TBKOD_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $TBKOD_list->showPageHeader(); ?>
<?php
$TBKOD_list->showMessage();
?>
<?php if ($TBKOD_list->TotalRecords > 0 || $TBKOD->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($TBKOD_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> TBKOD">
<form name="fTBKODlist" id="fTBKODlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="TBKOD">
<div id="gmp_TBKOD" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($TBKOD_list->TotalRecords > 0 || $TBKOD_list->isGridEdit()) { ?>
<table id="tbl_TBKODlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$TBKOD->RowType = ROWTYPE_HEADER;

// Render list options
$TBKOD_list->renderListOptions();

// Render list options (header, left)
$TBKOD_list->ListOptions->render("header", "left");
?>
<?php if ($TBKOD_list->KDAPLTBKOD->Visible) { // KDAPLTBKOD ?>
	<?php if ($TBKOD_list->SortUrl($TBKOD_list->KDAPLTBKOD) == "") { ?>
		<th data-name="KDAPLTBKOD" class="<?php echo $TBKOD_list->KDAPLTBKOD->headerCellClass() ?>"><div id="elh_TBKOD_KDAPLTBKOD" class="TBKOD_KDAPLTBKOD"><div class="ew-table-header-caption"><?php echo $TBKOD_list->KDAPLTBKOD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KDAPLTBKOD" class="<?php echo $TBKOD_list->KDAPLTBKOD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $TBKOD_list->SortUrl($TBKOD_list->KDAPLTBKOD) ?>', 1);"><div id="elh_TBKOD_KDAPLTBKOD" class="TBKOD_KDAPLTBKOD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $TBKOD_list->KDAPLTBKOD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($TBKOD_list->KDAPLTBKOD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($TBKOD_list->KDAPLTBKOD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($TBKOD_list->KETERTBKOD->Visible) { // KETERTBKOD ?>
	<?php if ($TBKOD_list->SortUrl($TBKOD_list->KETERTBKOD) == "") { ?>
		<th data-name="KETERTBKOD" class="<?php echo $TBKOD_list->KETERTBKOD->headerCellClass() ?>"><div id="elh_TBKOD_KETERTBKOD" class="TBKOD_KETERTBKOD"><div class="ew-table-header-caption"><?php echo $TBKOD_list->KETERTBKOD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KETERTBKOD" class="<?php echo $TBKOD_list->KETERTBKOD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $TBKOD_list->SortUrl($TBKOD_list->KETERTBKOD) ?>', 1);"><div id="elh_TBKOD_KETERTBKOD" class="TBKOD_KETERTBKOD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $TBKOD_list->KETERTBKOD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($TBKOD_list->KETERTBKOD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($TBKOD_list->KETERTBKOD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($TBKOD_list->KDKODTBKOD->Visible) { // KDKODTBKOD ?>
	<?php if ($TBKOD_list->SortUrl($TBKOD_list->KDKODTBKOD) == "") { ?>
		<th data-name="KDKODTBKOD" class="<?php echo $TBKOD_list->KDKODTBKOD->headerCellClass() ?>"><div id="elh_TBKOD_KDKODTBKOD" class="TBKOD_KDKODTBKOD"><div class="ew-table-header-caption"><?php echo $TBKOD_list->KDKODTBKOD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KDKODTBKOD" class="<?php echo $TBKOD_list->KDKODTBKOD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $TBKOD_list->SortUrl($TBKOD_list->KDKODTBKOD) ?>', 1);"><div id="elh_TBKOD_KDKODTBKOD" class="TBKOD_KDKODTBKOD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $TBKOD_list->KDKODTBKOD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($TBKOD_list->KDKODTBKOD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($TBKOD_list->KDKODTBKOD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($TBKOD_list->NMKODTBKOD->Visible) { // NMKODTBKOD ?>
	<?php if ($TBKOD_list->SortUrl($TBKOD_list->NMKODTBKOD) == "") { ?>
		<th data-name="NMKODTBKOD" class="<?php echo $TBKOD_list->NMKODTBKOD->headerCellClass() ?>"><div id="elh_TBKOD_NMKODTBKOD" class="TBKOD_NMKODTBKOD"><div class="ew-table-header-caption"><?php echo $TBKOD_list->NMKODTBKOD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NMKODTBKOD" class="<?php echo $TBKOD_list->NMKODTBKOD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $TBKOD_list->SortUrl($TBKOD_list->NMKODTBKOD) ?>', 1);"><div id="elh_TBKOD_NMKODTBKOD" class="TBKOD_NMKODTBKOD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $TBKOD_list->NMKODTBKOD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($TBKOD_list->NMKODTBKOD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($TBKOD_list->NMKODTBKOD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$TBKOD_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($TBKOD_list->ExportAll && $TBKOD_list->isExport()) {
	$TBKOD_list->StopRecord = $TBKOD_list->TotalRecords;
} else {

	// Set the last record to display
	if ($TBKOD_list->TotalRecords > $TBKOD_list->StartRecord + $TBKOD_list->DisplayRecords - 1)
		$TBKOD_list->StopRecord = $TBKOD_list->StartRecord + $TBKOD_list->DisplayRecords - 1;
	else
		$TBKOD_list->StopRecord = $TBKOD_list->TotalRecords;
}
$TBKOD_list->RecordCount = $TBKOD_list->StartRecord - 1;
if ($TBKOD_list->Recordset && !$TBKOD_list->Recordset->EOF) {
	$TBKOD_list->Recordset->moveFirst();
	$selectLimit = $TBKOD_list->UseSelectLimit;
	if (!$selectLimit && $TBKOD_list->StartRecord > 1)
		$TBKOD_list->Recordset->move($TBKOD_list->StartRecord - 1);
} elseif (!$TBKOD->AllowAddDeleteRow && $TBKOD_list->StopRecord == 0) {
	$TBKOD_list->StopRecord = $TBKOD->GridAddRowCount;
}

// Initialize aggregate
$TBKOD->RowType = ROWTYPE_AGGREGATEINIT;
$TBKOD->resetAttributes();
$TBKOD_list->renderRow();
while ($TBKOD_list->RecordCount < $TBKOD_list->StopRecord) {
	$TBKOD_list->RecordCount++;
	if ($TBKOD_list->RecordCount >= $TBKOD_list->StartRecord) {
		$TBKOD_list->RowCount++;

		// Set up key count
		$TBKOD_list->KeyCount = $TBKOD_list->RowIndex;

		// Init row class and style
		$TBKOD->resetAttributes();
		$TBKOD->CssClass = "";
		if ($TBKOD_list->isGridAdd()) {
		} else {
			$TBKOD_list->loadRowValues($TBKOD_list->Recordset); // Load row values
		}
		$TBKOD->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$TBKOD->RowAttrs->merge(["data-rowindex" => $TBKOD_list->RowCount, "id" => "r" . $TBKOD_list->RowCount . "_TBKOD", "data-rowtype" => $TBKOD->RowType]);

		// Render row
		$TBKOD_list->renderRow();

		// Render list options
		$TBKOD_list->renderListOptions();
?>
	<tr <?php echo $TBKOD->rowAttributes() ?>>
<?php

// Render list options (body, left)
$TBKOD_list->ListOptions->render("body", "left", $TBKOD_list->RowCount);
?>
	<?php if ($TBKOD_list->KDAPLTBKOD->Visible) { // KDAPLTBKOD ?>
		<td data-name="KDAPLTBKOD" <?php echo $TBKOD_list->KDAPLTBKOD->cellAttributes() ?>>
<span id="el<?php echo $TBKOD_list->RowCount ?>_TBKOD_KDAPLTBKOD">
<span<?php echo $TBKOD_list->KDAPLTBKOD->viewAttributes() ?>><?php echo $TBKOD_list->KDAPLTBKOD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($TBKOD_list->KETERTBKOD->Visible) { // KETERTBKOD ?>
		<td data-name="KETERTBKOD" <?php echo $TBKOD_list->KETERTBKOD->cellAttributes() ?>>
<span id="el<?php echo $TBKOD_list->RowCount ?>_TBKOD_KETERTBKOD">
<span<?php echo $TBKOD_list->KETERTBKOD->viewAttributes() ?>><?php echo $TBKOD_list->KETERTBKOD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($TBKOD_list->KDKODTBKOD->Visible) { // KDKODTBKOD ?>
		<td data-name="KDKODTBKOD" <?php echo $TBKOD_list->KDKODTBKOD->cellAttributes() ?>>
<span id="el<?php echo $TBKOD_list->RowCount ?>_TBKOD_KDKODTBKOD">
<span<?php echo $TBKOD_list->KDKODTBKOD->viewAttributes() ?>><?php echo $TBKOD_list->KDKODTBKOD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($TBKOD_list->NMKODTBKOD->Visible) { // NMKODTBKOD ?>
		<td data-name="NMKODTBKOD" <?php echo $TBKOD_list->NMKODTBKOD->cellAttributes() ?>>
<span id="el<?php echo $TBKOD_list->RowCount ?>_TBKOD_NMKODTBKOD">
<span<?php echo $TBKOD_list->NMKODTBKOD->viewAttributes() ?>><?php echo $TBKOD_list->NMKODTBKOD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$TBKOD_list->ListOptions->render("body", "right", $TBKOD_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$TBKOD_list->isGridAdd())
		$TBKOD_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$TBKOD->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($TBKOD_list->Recordset)
	$TBKOD_list->Recordset->Close();
?>
<?php if (!$TBKOD_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$TBKOD_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $TBKOD_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $TBKOD_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($TBKOD_list->TotalRecords == 0 && !$TBKOD->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $TBKOD_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$TBKOD_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$TBKOD_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$TBKOD_list->terminate();
?>