<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$VJadwalKuliah_list = new VJadwalKuliah_list();

// Run the page
$VJadwalKuliah_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$VJadwalKuliah_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$VJadwalKuliah_list->isExport()) { ?>
<script>
var fVJadwalKuliahlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fVJadwalKuliahlist = currentForm = new ew.Form("fVJadwalKuliahlist", "list");
	fVJadwalKuliahlist.formKeyCountName = '<?php echo $VJadwalKuliah_list->FormKeyCountName ?>';
	loadjs.done("fVJadwalKuliahlist");
});
var fVJadwalKuliahlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fVJadwalKuliahlistsrch = currentSearchForm = new ew.Form("fVJadwalKuliahlistsrch");

	// Validate function for search
	fVJadwalKuliahlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fVJadwalKuliahlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fVJadwalKuliahlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fVJadwalKuliahlistsrch.lists["x_Thn_Akademik"] = <?php echo $VJadwalKuliah_list->Thn_Akademik->Lookup->toClientList($VJadwalKuliah_list) ?>;
	fVJadwalKuliahlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($VJadwalKuliah_list->Thn_Akademik->lookupOptions()) ?>;
	fVJadwalKuliahlistsrch.lists["x_Periode"] = <?php echo $VJadwalKuliah_list->Periode->Lookup->toClientList($VJadwalKuliah_list) ?>;
	fVJadwalKuliahlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($VJadwalKuliah_list->Periode->options(FALSE, TRUE)) ?>;
	fVJadwalKuliahlistsrch.lists["x_Kelas_Akd"] = <?php echo $VJadwalKuliah_list->Kelas_Akd->Lookup->toClientList($VJadwalKuliah_list) ?>;
	fVJadwalKuliahlistsrch.lists["x_Kelas_Akd"].options = <?php echo JsonEncode($VJadwalKuliah_list->Kelas_Akd->lookupOptions()) ?>;
	fVJadwalKuliahlistsrch.lists["x_Kode_Jp"] = <?php echo $VJadwalKuliah_list->Kode_Jp->Lookup->toClientList($VJadwalKuliah_list) ?>;
	fVJadwalKuliahlistsrch.lists["x_Kode_Jp"].options = <?php echo JsonEncode($VJadwalKuliah_list->Kode_Jp->lookupOptions()) ?>;

	// Filters
	fVJadwalKuliahlistsrch.filterList = <?php echo $VJadwalKuliah_list->getFilterList() ?>;
	loadjs.done("fVJadwalKuliahlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$VJadwalKuliah_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($VJadwalKuliah_list->TotalRecords > 0 && $VJadwalKuliah_list->ExportOptions->visible()) { ?>
<?php $VJadwalKuliah_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->ImportOptions->visible()) { ?>
<?php $VJadwalKuliah_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->SearchOptions->visible()) { ?>
<?php $VJadwalKuliah_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->FilterOptions->visible()) { ?>
<?php $VJadwalKuliah_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$VJadwalKuliah_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$VJadwalKuliah_list->isExport() && !$VJadwalKuliah->CurrentAction) { ?>
<form name="fVJadwalKuliahlistsrch" id="fVJadwalKuliahlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fVJadwalKuliahlistsrch-search-panel" class="<?php echo $VJadwalKuliah_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="VJadwalKuliah">
	<div class="ew-extended-search">
<?php

// Render search row
$VJadwalKuliah->RowType = ROWTYPE_SEARCH;
$VJadwalKuliah->resetAttributes();
$VJadwalKuliah_list->renderRow();
?>
<?php if ($VJadwalKuliah_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$VJadwalKuliah_list->SearchColumnCount++;
		if (($VJadwalKuliah_list->SearchColumnCount - 1) % $VJadwalKuliah_list->SearchFieldsPerRow == 0) {
			$VJadwalKuliah_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $VJadwalKuliah_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $VJadwalKuliah_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_VJadwalKuliah_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="VJadwalKuliah" data-field="x_Thn_Akademik" data-value-separator="<?php echo $VJadwalKuliah_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $VJadwalKuliah_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $VJadwalKuliah_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $VJadwalKuliah_list->Thn_Akademik->Lookup->getParamTag($VJadwalKuliah_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($VJadwalKuliah_list->SearchColumnCount % $VJadwalKuliah_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Periode->Visible) { // Periode ?>
	<?php
		$VJadwalKuliah_list->SearchColumnCount++;
		if (($VJadwalKuliah_list->SearchColumnCount - 1) % $VJadwalKuliah_list->SearchFieldsPerRow == 0) {
			$VJadwalKuliah_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $VJadwalKuliah_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $VJadwalKuliah_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_VJadwalKuliah_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="VJadwalKuliah" data-field="x_Periode" data-value-separator="<?php echo $VJadwalKuliah_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $VJadwalKuliah_list->Periode->editAttributes() ?>>
			<?php echo $VJadwalKuliah_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($VJadwalKuliah_list->SearchColumnCount % $VJadwalKuliah_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
	<?php
		$VJadwalKuliah_list->SearchColumnCount++;
		if (($VJadwalKuliah_list->SearchColumnCount - 1) % $VJadwalKuliah_list->SearchFieldsPerRow == 0) {
			$VJadwalKuliah_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $VJadwalKuliah_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kelas_Akd" class="ew-cell form-group">
		<label for="x_Kelas_Akd" class="ew-search-caption ew-label"><?php echo $VJadwalKuliah_list->Kelas_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kelas_Akd" id="z_Kelas_Akd" value="LIKE">
</span>
		<span id="el_VJadwalKuliah_Kelas_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="VJadwalKuliah" data-field="x_Kelas_Akd" data-value-separator="<?php echo $VJadwalKuliah_list->Kelas_Akd->displayValueSeparatorAttribute() ?>" id="x_Kelas_Akd" name="x_Kelas_Akd"<?php echo $VJadwalKuliah_list->Kelas_Akd->editAttributes() ?>>
			<?php echo $VJadwalKuliah_list->Kelas_Akd->selectOptionListHtml("x_Kelas_Akd") ?>
		</select>
</div>
<?php echo $VJadwalKuliah_list->Kelas_Akd->Lookup->getParamTag($VJadwalKuliah_list, "p_x_Kelas_Akd") ?>
</span>
	</div>
	<?php if ($VJadwalKuliah_list->SearchColumnCount % $VJadwalKuliah_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php
		$VJadwalKuliah_list->SearchColumnCount++;
		if (($VJadwalKuliah_list->SearchColumnCount - 1) % $VJadwalKuliah_list->SearchFieldsPerRow == 0) {
			$VJadwalKuliah_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $VJadwalKuliah_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Jp" class="ew-cell form-group">
		<label for="x_Kode_Jp" class="ew-search-caption ew-label"><?php echo $VJadwalKuliah_list->Kode_Jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Jp" id="z_Kode_Jp" value="LIKE">
</span>
		<span id="el_VJadwalKuliah_Kode_Jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="VJadwalKuliah" data-field="x_Kode_Jp" data-value-separator="<?php echo $VJadwalKuliah_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x_Kode_Jp" name="x_Kode_Jp"<?php echo $VJadwalKuliah_list->Kode_Jp->editAttributes() ?>>
			<?php echo $VJadwalKuliah_list->Kode_Jp->selectOptionListHtml("x_Kode_Jp") ?>
		</select>
</div>
<?php echo $VJadwalKuliah_list->Kode_Jp->Lookup->getParamTag($VJadwalKuliah_list, "p_x_Kode_Jp") ?>
</span>
	</div>
	<?php if ($VJadwalKuliah_list->SearchColumnCount % $VJadwalKuliah_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($VJadwalKuliah_list->SearchColumnCount % $VJadwalKuliah_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $VJadwalKuliah_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($VJadwalKuliah_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($VJadwalKuliah_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $VJadwalKuliah_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($VJadwalKuliah_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($VJadwalKuliah_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($VJadwalKuliah_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($VJadwalKuliah_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $VJadwalKuliah_list->showPageHeader(); ?>
<?php
$VJadwalKuliah_list->showMessage();
?>
<?php if ($VJadwalKuliah_list->TotalRecords > 0 || $VJadwalKuliah->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($VJadwalKuliah_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> VJadwalKuliah">
<form name="fVJadwalKuliahlist" id="fVJadwalKuliahlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="VJadwalKuliah">
<div id="gmp_VJadwalKuliah" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($VJadwalKuliah_list->TotalRecords > 0 || $VJadwalKuliah_list->isGridEdit()) { ?>
<table id="tbl_VJadwalKuliahlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$VJadwalKuliah->RowType = ROWTYPE_HEADER;

// Render list options
$VJadwalKuliah_list->renderListOptions();

// Render list options (header, left)
$VJadwalKuliah_list->ListOptions->render("header", "left");
?>
<?php if ($VJadwalKuliah_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $VJadwalKuliah_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_VJadwalKuliah_Thn_Akademik" class="VJadwalKuliah_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $VJadwalKuliah_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Thn_Akademik) ?>', 1);"><div id="elh_VJadwalKuliah_Thn_Akademik" class="VJadwalKuliah_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Periode->Visible) { // Periode ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $VJadwalKuliah_list->Periode->headerCellClass() ?>"><div id="elh_VJadwalKuliah_Periode" class="VJadwalKuliah_Periode"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $VJadwalKuliah_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Periode) ?>', 1);"><div id="elh_VJadwalKuliah_Periode" class="VJadwalKuliah_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Kelas_Akd) == "") { ?>
		<th data-name="Kelas_Akd" class="<?php echo $VJadwalKuliah_list->Kelas_Akd->headerCellClass() ?>"><div id="elh_VJadwalKuliah_Kelas_Akd" class="VJadwalKuliah_Kelas_Akd"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Kelas_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas_Akd" class="<?php echo $VJadwalKuliah_list->Kelas_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Kelas_Akd) ?>', 1);"><div id="elh_VJadwalKuliah_Kelas_Akd" class="VJadwalKuliah_Kelas_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Kelas_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->Kelas_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->Kelas_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Kode_Jp) == "") { ?>
		<th data-name="Kode_Jp" class="<?php echo $VJadwalKuliah_list->Kode_Jp->headerCellClass() ?>"><div id="elh_VJadwalKuliah_Kode_Jp" class="VJadwalKuliah_Kode_Jp"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Kode_Jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Jp" class="<?php echo $VJadwalKuliah_list->Kode_Jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Kode_Jp) ?>', 1);"><div id="elh_VJadwalKuliah_Kode_Jp" class="VJadwalKuliah_Kode_Jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Kode_Jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->Kode_Jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->Kode_Jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Kode_Mk->Visible) { // Kode_Mk ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Kode_Mk) == "") { ?>
		<th data-name="Kode_Mk" class="<?php echo $VJadwalKuliah_list->Kode_Mk->headerCellClass() ?>"><div id="elh_VJadwalKuliah_Kode_Mk" class="VJadwalKuliah_Kode_Mk"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Kode_Mk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Mk" class="<?php echo $VJadwalKuliah_list->Kode_Mk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Kode_Mk) ?>', 1);"><div id="elh_VJadwalKuliah_Kode_Mk" class="VJadwalKuliah_Kode_Mk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Kode_Mk->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->Kode_Mk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->Kode_Mk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Matakuliah->Visible) { // Matakuliah ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Matakuliah) == "") { ?>
		<th data-name="Matakuliah" class="<?php echo $VJadwalKuliah_list->Matakuliah->headerCellClass() ?>"><div id="elh_VJadwalKuliah_Matakuliah" class="VJadwalKuliah_Matakuliah"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Matakuliah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Matakuliah" class="<?php echo $VJadwalKuliah_list->Matakuliah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Matakuliah) ?>', 1);"><div id="elh_VJadwalKuliah_Matakuliah" class="VJadwalKuliah_Matakuliah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Matakuliah->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->Matakuliah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->Matakuliah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->SKS->Visible) { // SKS ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->SKS) == "") { ?>
		<th data-name="SKS" class="<?php echo $VJadwalKuliah_list->SKS->headerCellClass() ?>"><div id="elh_VJadwalKuliah_SKS" class="VJadwalKuliah_SKS"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->SKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SKS" class="<?php echo $VJadwalKuliah_list->SKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->SKS) ?>', 1);"><div id="elh_VJadwalKuliah_SKS" class="VJadwalKuliah_SKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->SKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->SKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->SKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->Kelas->Visible) { // Kelas ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Kelas) == "") { ?>
		<th data-name="Kelas" class="<?php echo $VJadwalKuliah_list->Kelas->headerCellClass() ?>"><div id="elh_VJadwalKuliah_Kelas" class="VJadwalKuliah_Kelas"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Kelas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas" class="<?php echo $VJadwalKuliah_list->Kelas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->Kelas) ?>', 1);"><div id="elh_VJadwalKuliah_Kelas" class="VJadwalKuliah_Kelas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->Kelas->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->Kelas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->Kelas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->NIDN->Visible) { // NIDN ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $VJadwalKuliah_list->NIDN->headerCellClass() ?>"><div id="elh_VJadwalKuliah_NIDN" class="VJadwalKuliah_NIDN"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $VJadwalKuliah_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->NIDN) ?>', 1);"><div id="elh_VJadwalKuliah_NIDN" class="VJadwalKuliah_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->NIDN1->Visible) { // NIDN1 ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->NIDN1) == "") { ?>
		<th data-name="NIDN1" class="<?php echo $VJadwalKuliah_list->NIDN1->headerCellClass() ?>"><div id="elh_VJadwalKuliah_NIDN1" class="VJadwalKuliah_NIDN1"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->NIDN1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN1" class="<?php echo $VJadwalKuliah_list->NIDN1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->NIDN1) ?>', 1);"><div id="elh_VJadwalKuliah_NIDN1" class="VJadwalKuliah_NIDN1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->NIDN1->caption() ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->NIDN1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->NIDN1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($VJadwalKuliah_list->id_feedkelas->Visible) { // id_feedkelas ?>
	<?php if ($VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->id_feedkelas) == "") { ?>
		<th data-name="id_feedkelas" class="<?php echo $VJadwalKuliah_list->id_feedkelas->headerCellClass() ?>"><div id="elh_VJadwalKuliah_id_feedkelas" class="VJadwalKuliah_id_feedkelas"><div class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->id_feedkelas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_feedkelas" class="<?php echo $VJadwalKuliah_list->id_feedkelas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $VJadwalKuliah_list->SortUrl($VJadwalKuliah_list->id_feedkelas) ?>', 1);"><div id="elh_VJadwalKuliah_id_feedkelas" class="VJadwalKuliah_id_feedkelas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $VJadwalKuliah_list->id_feedkelas->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($VJadwalKuliah_list->id_feedkelas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($VJadwalKuliah_list->id_feedkelas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$VJadwalKuliah_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($VJadwalKuliah_list->ExportAll && $VJadwalKuliah_list->isExport()) {
	$VJadwalKuliah_list->StopRecord = $VJadwalKuliah_list->TotalRecords;
} else {

	// Set the last record to display
	if ($VJadwalKuliah_list->TotalRecords > $VJadwalKuliah_list->StartRecord + $VJadwalKuliah_list->DisplayRecords - 1)
		$VJadwalKuliah_list->StopRecord = $VJadwalKuliah_list->StartRecord + $VJadwalKuliah_list->DisplayRecords - 1;
	else
		$VJadwalKuliah_list->StopRecord = $VJadwalKuliah_list->TotalRecords;
}
$VJadwalKuliah_list->RecordCount = $VJadwalKuliah_list->StartRecord - 1;
if ($VJadwalKuliah_list->Recordset && !$VJadwalKuliah_list->Recordset->EOF) {
	$VJadwalKuliah_list->Recordset->moveFirst();
	$selectLimit = $VJadwalKuliah_list->UseSelectLimit;
	if (!$selectLimit && $VJadwalKuliah_list->StartRecord > 1)
		$VJadwalKuliah_list->Recordset->move($VJadwalKuliah_list->StartRecord - 1);
} elseif (!$VJadwalKuliah->AllowAddDeleteRow && $VJadwalKuliah_list->StopRecord == 0) {
	$VJadwalKuliah_list->StopRecord = $VJadwalKuliah->GridAddRowCount;
}

// Initialize aggregate
$VJadwalKuliah->RowType = ROWTYPE_AGGREGATEINIT;
$VJadwalKuliah->resetAttributes();
$VJadwalKuliah_list->renderRow();
while ($VJadwalKuliah_list->RecordCount < $VJadwalKuliah_list->StopRecord) {
	$VJadwalKuliah_list->RecordCount++;
	if ($VJadwalKuliah_list->RecordCount >= $VJadwalKuliah_list->StartRecord) {
		$VJadwalKuliah_list->RowCount++;

		// Set up key count
		$VJadwalKuliah_list->KeyCount = $VJadwalKuliah_list->RowIndex;

		// Init row class and style
		$VJadwalKuliah->resetAttributes();
		$VJadwalKuliah->CssClass = "";
		if ($VJadwalKuliah_list->isGridAdd()) {
		} else {
			$VJadwalKuliah_list->loadRowValues($VJadwalKuliah_list->Recordset); // Load row values
		}
		$VJadwalKuliah->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$VJadwalKuliah->RowAttrs->merge(["data-rowindex" => $VJadwalKuliah_list->RowCount, "id" => "r" . $VJadwalKuliah_list->RowCount . "_VJadwalKuliah", "data-rowtype" => $VJadwalKuliah->RowType]);

		// Render row
		$VJadwalKuliah_list->renderRow();

		// Render list options
		$VJadwalKuliah_list->renderListOptions();
?>
	<tr <?php echo $VJadwalKuliah->rowAttributes() ?>>
<?php

// Render list options (body, left)
$VJadwalKuliah_list->ListOptions->render("body", "left", $VJadwalKuliah_list->RowCount);
?>
	<?php if ($VJadwalKuliah_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $VJadwalKuliah_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_Thn_Akademik">
<span<?php echo $VJadwalKuliah_list->Thn_Akademik->viewAttributes() ?>><?php echo $VJadwalKuliah_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $VJadwalKuliah_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_Periode">
<span<?php echo $VJadwalKuliah_list->Periode->viewAttributes() ?>><?php echo $VJadwalKuliah_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
		<td data-name="Kelas_Akd" <?php echo $VJadwalKuliah_list->Kelas_Akd->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_Kelas_Akd">
<span<?php echo $VJadwalKuliah_list->Kelas_Akd->viewAttributes() ?>><?php echo $VJadwalKuliah_list->Kelas_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp" <?php echo $VJadwalKuliah_list->Kode_Jp->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_Kode_Jp">
<span<?php echo $VJadwalKuliah_list->Kode_Jp->viewAttributes() ?>><?php echo $VJadwalKuliah_list->Kode_Jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->Kode_Mk->Visible) { // Kode_Mk ?>
		<td data-name="Kode_Mk" <?php echo $VJadwalKuliah_list->Kode_Mk->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_Kode_Mk">
<span<?php echo $VJadwalKuliah_list->Kode_Mk->viewAttributes() ?>><?php echo $VJadwalKuliah_list->Kode_Mk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->Matakuliah->Visible) { // Matakuliah ?>
		<td data-name="Matakuliah" <?php echo $VJadwalKuliah_list->Matakuliah->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_Matakuliah">
<span<?php echo $VJadwalKuliah_list->Matakuliah->viewAttributes() ?>><?php echo $VJadwalKuliah_list->Matakuliah->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS" <?php echo $VJadwalKuliah_list->SKS->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_SKS">
<span<?php echo $VJadwalKuliah_list->SKS->viewAttributes() ?>><?php echo $VJadwalKuliah_list->SKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->Kelas->Visible) { // Kelas ?>
		<td data-name="Kelas" <?php echo $VJadwalKuliah_list->Kelas->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_Kelas">
<span<?php echo $VJadwalKuliah_list->Kelas->viewAttributes() ?>><?php echo $VJadwalKuliah_list->Kelas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $VJadwalKuliah_list->NIDN->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_NIDN">
<span<?php echo $VJadwalKuliah_list->NIDN->viewAttributes() ?>><?php echo $VJadwalKuliah_list->NIDN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->NIDN1->Visible) { // NIDN1 ?>
		<td data-name="NIDN1" <?php echo $VJadwalKuliah_list->NIDN1->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_NIDN1">
<span<?php echo $VJadwalKuliah_list->NIDN1->viewAttributes() ?>><?php echo $VJadwalKuliah_list->NIDN1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($VJadwalKuliah_list->id_feedkelas->Visible) { // id_feedkelas ?>
		<td data-name="id_feedkelas" <?php echo $VJadwalKuliah_list->id_feedkelas->cellAttributes() ?>>
<span id="el<?php echo $VJadwalKuliah_list->RowCount ?>_VJadwalKuliah_id_feedkelas">
<span<?php echo $VJadwalKuliah_list->id_feedkelas->viewAttributes() ?>><?php echo $VJadwalKuliah_list->id_feedkelas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$VJadwalKuliah_list->ListOptions->render("body", "right", $VJadwalKuliah_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$VJadwalKuliah_list->isGridAdd())
		$VJadwalKuliah_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$VJadwalKuliah->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($VJadwalKuliah_list->Recordset)
	$VJadwalKuliah_list->Recordset->Close();
?>
<?php if (!$VJadwalKuliah_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$VJadwalKuliah_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $VJadwalKuliah_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $VJadwalKuliah_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($VJadwalKuliah_list->TotalRecords == 0 && !$VJadwalKuliah->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $VJadwalKuliah_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$VJadwalKuliah_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$VJadwalKuliah_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$VJadwalKuliah_list->terminate();
?>