<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$V_LMHS_list = new V_LMHS_list();

// Run the page
$V_LMHS_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$V_LMHS_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$V_LMHS_list->isExport()) { ?>
<script>
var fV_LMHSlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fV_LMHSlist = currentForm = new ew.Form("fV_LMHSlist", "list");
	fV_LMHSlist.formKeyCountName = '<?php echo $V_LMHS_list->FormKeyCountName ?>';
	loadjs.done("fV_LMHSlist");
});
var fV_LMHSlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fV_LMHSlistsrch = currentSearchForm = new ew.Form("fV_LMHSlistsrch");

	// Validate function for search
	fV_LMHSlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fV_LMHSlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fV_LMHSlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fV_LMHSlistsrch.lists["x_Kode_jp"] = <?php echo $V_LMHS_list->Kode_jp->Lookup->toClientList($V_LMHS_list) ?>;
	fV_LMHSlistsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($V_LMHS_list->Kode_jp->lookupOptions()) ?>;
	fV_LMHSlistsrch.lists["x_TaMasuk"] = <?php echo $V_LMHS_list->TaMasuk->Lookup->toClientList($V_LMHS_list) ?>;
	fV_LMHSlistsrch.lists["x_TaMasuk"].options = <?php echo JsonEncode($V_LMHS_list->TaMasuk->lookupOptions()) ?>;
	fV_LMHSlistsrch.lists["x_PerMasuk"] = <?php echo $V_LMHS_list->PerMasuk->Lookup->toClientList($V_LMHS_list) ?>;
	fV_LMHSlistsrch.lists["x_PerMasuk"].options = <?php echo JsonEncode($V_LMHS_list->PerMasuk->options(FALSE, TRUE)) ?>;
	fV_LMHSlistsrch.lists["x_Status_Akd"] = <?php echo $V_LMHS_list->Status_Akd->Lookup->toClientList($V_LMHS_list) ?>;
	fV_LMHSlistsrch.lists["x_Status_Akd"].options = <?php echo JsonEncode($V_LMHS_list->Status_Akd->lookupOptions()) ?>;

	// Filters
	fV_LMHSlistsrch.filterList = <?php echo $V_LMHS_list->getFilterList() ?>;
	loadjs.done("fV_LMHSlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$V_LMHS_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($V_LMHS_list->TotalRecords > 0 && $V_LMHS_list->ExportOptions->visible()) { ?>
<?php $V_LMHS_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($V_LMHS_list->ImportOptions->visible()) { ?>
<?php $V_LMHS_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($V_LMHS_list->SearchOptions->visible()) { ?>
<?php $V_LMHS_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($V_LMHS_list->FilterOptions->visible()) { ?>
<?php $V_LMHS_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$V_LMHS_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$V_LMHS_list->isExport() && !$V_LMHS->CurrentAction) { ?>
<form name="fV_LMHSlistsrch" id="fV_LMHSlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fV_LMHSlistsrch-search-panel" class="<?php echo $V_LMHS_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="V_LMHS">
	<div class="ew-extended-search">
<?php

// Render search row
$V_LMHS->RowType = ROWTYPE_SEARCH;
$V_LMHS->resetAttributes();
$V_LMHS_list->renderRow();
?>
<?php if ($V_LMHS_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$V_LMHS_list->SearchColumnCount++;
		if (($V_LMHS_list->SearchColumnCount - 1) % $V_LMHS_list->SearchFieldsPerRow == 0) {
			$V_LMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $V_LMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $V_LMHS_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_V_LMHS_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="V_LMHS" data-field="x_Kode_jp" data-value-separator="<?php echo $V_LMHS_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $V_LMHS_list->Kode_jp->editAttributes() ?>>
			<?php echo $V_LMHS_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $V_LMHS_list->Kode_jp->Lookup->getParamTag($V_LMHS_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($V_LMHS_list->SearchColumnCount % $V_LMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php
		$V_LMHS_list->SearchColumnCount++;
		if (($V_LMHS_list->SearchColumnCount - 1) % $V_LMHS_list->SearchFieldsPerRow == 0) {
			$V_LMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $V_LMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_TaMasuk" class="ew-cell form-group">
		<label for="x_TaMasuk" class="ew-search-caption ew-label"><?php echo $V_LMHS_list->TaMasuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TaMasuk" id="z_TaMasuk" value="LIKE">
</span>
		<span id="el_V_LMHS_TaMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="V_LMHS" data-field="x_TaMasuk" data-value-separator="<?php echo $V_LMHS_list->TaMasuk->displayValueSeparatorAttribute() ?>" id="x_TaMasuk" name="x_TaMasuk"<?php echo $V_LMHS_list->TaMasuk->editAttributes() ?>>
			<?php echo $V_LMHS_list->TaMasuk->selectOptionListHtml("x_TaMasuk") ?>
		</select>
</div>
<?php echo $V_LMHS_list->TaMasuk->Lookup->getParamTag($V_LMHS_list, "p_x_TaMasuk") ?>
</span>
	</div>
	<?php if ($V_LMHS_list->SearchColumnCount % $V_LMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php
		$V_LMHS_list->SearchColumnCount++;
		if (($V_LMHS_list->SearchColumnCount - 1) % $V_LMHS_list->SearchFieldsPerRow == 0) {
			$V_LMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $V_LMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_PerMasuk" class="ew-cell form-group">
		<label for="x_PerMasuk" class="ew-search-caption ew-label"><?php echo $V_LMHS_list->PerMasuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PerMasuk" id="z_PerMasuk" value="LIKE">
</span>
		<span id="el_V_LMHS_PerMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="V_LMHS" data-field="x_PerMasuk" data-value-separator="<?php echo $V_LMHS_list->PerMasuk->displayValueSeparatorAttribute() ?>" id="x_PerMasuk" name="x_PerMasuk"<?php echo $V_LMHS_list->PerMasuk->editAttributes() ?>>
			<?php echo $V_LMHS_list->PerMasuk->selectOptionListHtml("x_PerMasuk") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($V_LMHS_list->SearchColumnCount % $V_LMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php
		$V_LMHS_list->SearchColumnCount++;
		if (($V_LMHS_list->SearchColumnCount - 1) % $V_LMHS_list->SearchFieldsPerRow == 0) {
			$V_LMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $V_LMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Akd" class="ew-cell form-group">
		<label for="x_Status_Akd" class="ew-search-caption ew-label"><?php echo $V_LMHS_list->Status_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Akd" id="z_Status_Akd" value="LIKE">
</span>
		<span id="el_V_LMHS_Status_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="V_LMHS" data-field="x_Status_Akd" data-value-separator="<?php echo $V_LMHS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $V_LMHS_list->Status_Akd->editAttributes() ?>>
			<?php echo $V_LMHS_list->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $V_LMHS_list->Status_Akd->Lookup->getParamTag($V_LMHS_list, "p_x_Status_Akd") ?>
</span>
	</div>
	<?php if ($V_LMHS_list->SearchColumnCount % $V_LMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($V_LMHS_list->SearchColumnCount % $V_LMHS_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $V_LMHS_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($V_LMHS_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($V_LMHS_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $V_LMHS_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($V_LMHS_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($V_LMHS_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($V_LMHS_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($V_LMHS_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $V_LMHS_list->showPageHeader(); ?>
<?php
$V_LMHS_list->showMessage();
?>
<?php if ($V_LMHS_list->TotalRecords > 0 || $V_LMHS->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($V_LMHS_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> V_LMHS">
<form name="fV_LMHSlist" id="fV_LMHSlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="V_LMHS">
<div id="gmp_V_LMHS" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($V_LMHS_list->TotalRecords > 0 || $V_LMHS_list->isGridEdit()) { ?>
<table id="tbl_V_LMHSlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$V_LMHS->RowType = ROWTYPE_HEADER;

// Render list options
$V_LMHS_list->renderListOptions();

// Render list options (header, left)
$V_LMHS_list->ListOptions->render("header", "left");
?>
<?php if ($V_LMHS_list->Nim->Visible) { // Nim ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $V_LMHS_list->Nim->headerCellClass() ?>"><div id="elh_V_LMHS_Nim" class="V_LMHS_Nim"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $V_LMHS_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->Nim) ?>', 1);"><div id="elh_V_LMHS_Nim" class="V_LMHS_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $V_LMHS_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_V_LMHS_Nama_Mhs" class="V_LMHS_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $V_LMHS_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->Nama_Mhs) ?>', 1);"><div id="elh_V_LMHS_Nama_Mhs" class="V_LMHS_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->Status_Masuk->Visible) { // Status_Masuk ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->Status_Masuk) == "") { ?>
		<th data-name="Status_Masuk" class="<?php echo $V_LMHS_list->Status_Masuk->headerCellClass() ?>"><div id="elh_V_LMHS_Status_Masuk" class="V_LMHS_Status_Masuk"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->Status_Masuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Masuk" class="<?php echo $V_LMHS_list->Status_Masuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->Status_Masuk) ?>', 1);"><div id="elh_V_LMHS_Status_Masuk" class="V_LMHS_Status_Masuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->Status_Masuk->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->Status_Masuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->Status_Masuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->Tlp_Mhs) == "") { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $V_LMHS_list->Tlp_Mhs->headerCellClass() ?>"><div id="elh_V_LMHS_Tlp_Mhs" class="V_LMHS_Tlp_Mhs"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->Tlp_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $V_LMHS_list->Tlp_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->Tlp_Mhs) ?>', 1);"><div id="elh_V_LMHS_Tlp_Mhs" class="V_LMHS_Tlp_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->Tlp_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->Tlp_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->Tlp_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $V_LMHS_list->Kode_jp->headerCellClass() ?>"><div id="elh_V_LMHS_Kode_jp" class="V_LMHS_Kode_jp"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $V_LMHS_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->Kode_jp) ?>', 1);"><div id="elh_V_LMHS_Kode_jp" class="V_LMHS_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->TaMasuk) == "") { ?>
		<th data-name="TaMasuk" class="<?php echo $V_LMHS_list->TaMasuk->headerCellClass() ?>"><div id="elh_V_LMHS_TaMasuk" class="V_LMHS_TaMasuk"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->TaMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TaMasuk" class="<?php echo $V_LMHS_list->TaMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->TaMasuk) ?>', 1);"><div id="elh_V_LMHS_TaMasuk" class="V_LMHS_TaMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->TaMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->TaMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->TaMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->PerMasuk) == "") { ?>
		<th data-name="PerMasuk" class="<?php echo $V_LMHS_list->PerMasuk->headerCellClass() ?>"><div id="elh_V_LMHS_PerMasuk" class="V_LMHS_PerMasuk"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->PerMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerMasuk" class="<?php echo $V_LMHS_list->PerMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->PerMasuk) ?>', 1);"><div id="elh_V_LMHS_PerMasuk" class="V_LMHS_PerMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->PerMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->PerMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->PerMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $V_LMHS_list->Status_Akd->headerCellClass() ?>"><div id="elh_V_LMHS_Status_Akd" class="V_LMHS_Status_Akd"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $V_LMHS_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->Status_Akd) ?>', 1);"><div id="elh_V_LMHS_Status_Akd" class="V_LMHS_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->JalurMasuk->Visible) { // JalurMasuk ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->JalurMasuk) == "") { ?>
		<th data-name="JalurMasuk" class="<?php echo $V_LMHS_list->JalurMasuk->headerCellClass() ?>"><div id="elh_V_LMHS_JalurMasuk" class="V_LMHS_JalurMasuk"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->JalurMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JalurMasuk" class="<?php echo $V_LMHS_list->JalurMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->JalurMasuk) ?>', 1);"><div id="elh_V_LMHS_JalurMasuk" class="V_LMHS_JalurMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->JalurMasuk->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->JalurMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->JalurMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->IPK->Visible) { // IPK ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->IPK) == "") { ?>
		<th data-name="IPK" class="<?php echo $V_LMHS_list->IPK->headerCellClass() ?>"><div id="elh_V_LMHS_IPK" class="V_LMHS_IPK"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->IPK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IPK" class="<?php echo $V_LMHS_list->IPK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->IPK) ?>', 1);"><div id="elh_V_LMHS_IPK" class="V_LMHS_IPK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->IPK->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->IPK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->IPK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_LMHS_list->id_feedmhs->Visible) { // id_feedmhs ?>
	<?php if ($V_LMHS_list->SortUrl($V_LMHS_list->id_feedmhs) == "") { ?>
		<th data-name="id_feedmhs" class="<?php echo $V_LMHS_list->id_feedmhs->headerCellClass() ?>"><div id="elh_V_LMHS_id_feedmhs" class="V_LMHS_id_feedmhs"><div class="ew-table-header-caption"><?php echo $V_LMHS_list->id_feedmhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_feedmhs" class="<?php echo $V_LMHS_list->id_feedmhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_LMHS_list->SortUrl($V_LMHS_list->id_feedmhs) ?>', 1);"><div id="elh_V_LMHS_id_feedmhs" class="V_LMHS_id_feedmhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_LMHS_list->id_feedmhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_LMHS_list->id_feedmhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_LMHS_list->id_feedmhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$V_LMHS_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($V_LMHS_list->ExportAll && $V_LMHS_list->isExport()) {
	$V_LMHS_list->StopRecord = $V_LMHS_list->TotalRecords;
} else {

	// Set the last record to display
	if ($V_LMHS_list->TotalRecords > $V_LMHS_list->StartRecord + $V_LMHS_list->DisplayRecords - 1)
		$V_LMHS_list->StopRecord = $V_LMHS_list->StartRecord + $V_LMHS_list->DisplayRecords - 1;
	else
		$V_LMHS_list->StopRecord = $V_LMHS_list->TotalRecords;
}
$V_LMHS_list->RecordCount = $V_LMHS_list->StartRecord - 1;
if ($V_LMHS_list->Recordset && !$V_LMHS_list->Recordset->EOF) {
	$V_LMHS_list->Recordset->moveFirst();
	$selectLimit = $V_LMHS_list->UseSelectLimit;
	if (!$selectLimit && $V_LMHS_list->StartRecord > 1)
		$V_LMHS_list->Recordset->move($V_LMHS_list->StartRecord - 1);
} elseif (!$V_LMHS->AllowAddDeleteRow && $V_LMHS_list->StopRecord == 0) {
	$V_LMHS_list->StopRecord = $V_LMHS->GridAddRowCount;
}

// Initialize aggregate
$V_LMHS->RowType = ROWTYPE_AGGREGATEINIT;
$V_LMHS->resetAttributes();
$V_LMHS_list->renderRow();
while ($V_LMHS_list->RecordCount < $V_LMHS_list->StopRecord) {
	$V_LMHS_list->RecordCount++;
	if ($V_LMHS_list->RecordCount >= $V_LMHS_list->StartRecord) {
		$V_LMHS_list->RowCount++;

		// Set up key count
		$V_LMHS_list->KeyCount = $V_LMHS_list->RowIndex;

		// Init row class and style
		$V_LMHS->resetAttributes();
		$V_LMHS->CssClass = "";
		if ($V_LMHS_list->isGridAdd()) {
		} else {
			$V_LMHS_list->loadRowValues($V_LMHS_list->Recordset); // Load row values
		}
		$V_LMHS->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$V_LMHS->RowAttrs->merge(["data-rowindex" => $V_LMHS_list->RowCount, "id" => "r" . $V_LMHS_list->RowCount . "_V_LMHS", "data-rowtype" => $V_LMHS->RowType]);

		// Render row
		$V_LMHS_list->renderRow();

		// Render list options
		$V_LMHS_list->renderListOptions();
?>
	<tr <?php echo $V_LMHS->rowAttributes() ?>>
<?php

// Render list options (body, left)
$V_LMHS_list->ListOptions->render("body", "left", $V_LMHS_list->RowCount);
?>
	<?php if ($V_LMHS_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $V_LMHS_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_Nim">
<span<?php echo $V_LMHS_list->Nim->viewAttributes() ?>><?php echo $V_LMHS_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $V_LMHS_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_Nama_Mhs">
<span<?php echo $V_LMHS_list->Nama_Mhs->viewAttributes() ?>><?php echo $V_LMHS_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->Status_Masuk->Visible) { // Status_Masuk ?>
		<td data-name="Status_Masuk" <?php echo $V_LMHS_list->Status_Masuk->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_Status_Masuk">
<span<?php echo $V_LMHS_list->Status_Masuk->viewAttributes() ?>><?php echo $V_LMHS_list->Status_Masuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
		<td data-name="Tlp_Mhs" <?php echo $V_LMHS_list->Tlp_Mhs->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_Tlp_Mhs">
<span<?php echo $V_LMHS_list->Tlp_Mhs->viewAttributes() ?>><?php echo $V_LMHS_list->Tlp_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $V_LMHS_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_Kode_jp">
<span<?php echo $V_LMHS_list->Kode_jp->viewAttributes() ?>><?php echo $V_LMHS_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->TaMasuk->Visible) { // TaMasuk ?>
		<td data-name="TaMasuk" <?php echo $V_LMHS_list->TaMasuk->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_TaMasuk">
<span<?php echo $V_LMHS_list->TaMasuk->viewAttributes() ?>><?php echo $V_LMHS_list->TaMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->PerMasuk->Visible) { // PerMasuk ?>
		<td data-name="PerMasuk" <?php echo $V_LMHS_list->PerMasuk->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_PerMasuk">
<span<?php echo $V_LMHS_list->PerMasuk->viewAttributes() ?>><?php echo $V_LMHS_list->PerMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $V_LMHS_list->Status_Akd->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_Status_Akd">
<span<?php echo $V_LMHS_list->Status_Akd->viewAttributes() ?>><?php echo $V_LMHS_list->Status_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->JalurMasuk->Visible) { // JalurMasuk ?>
		<td data-name="JalurMasuk" <?php echo $V_LMHS_list->JalurMasuk->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_JalurMasuk">
<span<?php echo $V_LMHS_list->JalurMasuk->viewAttributes() ?>><?php echo $V_LMHS_list->JalurMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->IPK->Visible) { // IPK ?>
		<td data-name="IPK" <?php echo $V_LMHS_list->IPK->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_IPK">
<span<?php echo $V_LMHS_list->IPK->viewAttributes() ?>><?php echo $V_LMHS_list->IPK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_LMHS_list->id_feedmhs->Visible) { // id_feedmhs ?>
		<td data-name="id_feedmhs" <?php echo $V_LMHS_list->id_feedmhs->cellAttributes() ?>>
<span id="el<?php echo $V_LMHS_list->RowCount ?>_V_LMHS_id_feedmhs">
<span<?php echo $V_LMHS_list->id_feedmhs->viewAttributes() ?>><?php echo $V_LMHS_list->id_feedmhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$V_LMHS_list->ListOptions->render("body", "right", $V_LMHS_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$V_LMHS_list->isGridAdd())
		$V_LMHS_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$V_LMHS->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($V_LMHS_list->Recordset)
	$V_LMHS_list->Recordset->Close();
?>
<?php if (!$V_LMHS_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$V_LMHS_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $V_LMHS_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $V_LMHS_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($V_LMHS_list->TotalRecords == 0 && !$V_LMHS->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $V_LMHS_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$V_LMHS_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$V_LMHS_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$V_LMHS_list->terminate();
?>