<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$V_NilaiMhs_list = new V_NilaiMhs_list();

// Run the page
$V_NilaiMhs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$V_NilaiMhs_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$V_NilaiMhs_list->isExport()) { ?>
<script>
var fV_NilaiMhslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fV_NilaiMhslist = currentForm = new ew.Form("fV_NilaiMhslist", "list");
	fV_NilaiMhslist.formKeyCountName = '<?php echo $V_NilaiMhs_list->FormKeyCountName ?>';
	loadjs.done("fV_NilaiMhslist");
});
var fV_NilaiMhslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fV_NilaiMhslistsrch = currentSearchForm = new ew.Form("fV_NilaiMhslistsrch");

	// Dynamic selection lists
	// Filters

	fV_NilaiMhslistsrch.filterList = <?php echo $V_NilaiMhs_list->getFilterList() ?>;
	loadjs.done("fV_NilaiMhslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$V_NilaiMhs_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($V_NilaiMhs_list->TotalRecords > 0 && $V_NilaiMhs_list->ExportOptions->visible()) { ?>
<?php $V_NilaiMhs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->ImportOptions->visible()) { ?>
<?php $V_NilaiMhs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->SearchOptions->visible()) { ?>
<?php $V_NilaiMhs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->FilterOptions->visible()) { ?>
<?php $V_NilaiMhs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$V_NilaiMhs_list->isExport() || Config("EXPORT_MASTER_RECORD") && $V_NilaiMhs_list->isExport("print")) { ?>
<?php
if ($V_NilaiMhs_list->DbMasterFilter != "" && $V_NilaiMhs->getCurrentMasterTable() == "VJadwalKuliah") {
	if ($V_NilaiMhs_list->MasterRecordExists) {
		include_once "VJadwalKuliahmaster.php";
	}
}
?>
<?php } ?>
<?php
$V_NilaiMhs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$V_NilaiMhs_list->isExport() && !$V_NilaiMhs->CurrentAction) { ?>
<form name="fV_NilaiMhslistsrch" id="fV_NilaiMhslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fV_NilaiMhslistsrch-search-panel" class="<?php echo $V_NilaiMhs_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="V_NilaiMhs">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $V_NilaiMhs_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($V_NilaiMhs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($V_NilaiMhs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $V_NilaiMhs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($V_NilaiMhs_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($V_NilaiMhs_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($V_NilaiMhs_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($V_NilaiMhs_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $V_NilaiMhs_list->showPageHeader(); ?>
<?php
$V_NilaiMhs_list->showMessage();
?>
<?php if ($V_NilaiMhs_list->TotalRecords > 0 || $V_NilaiMhs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($V_NilaiMhs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> V_NilaiMhs">
<form name="fV_NilaiMhslist" id="fV_NilaiMhslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="V_NilaiMhs">
<?php if ($V_NilaiMhs->getCurrentMasterTable() == "VJadwalKuliah" && $V_NilaiMhs->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="VJadwalKuliah">
<input type="hidden" name="fk_Thn_Akademik" value="<?php echo HtmlEncode($V_NilaiMhs_list->Thn_Akademik->getSessionValue()) ?>">
<input type="hidden" name="fk_Periode" value="<?php echo HtmlEncode($V_NilaiMhs_list->Periode->getSessionValue()) ?>">
<input type="hidden" name="fk_Kelas_Akd" value="<?php echo HtmlEncode($V_NilaiMhs_list->Status_Akd->getSessionValue()) ?>">
<input type="hidden" name="fk_Kode_Mk" value="<?php echo HtmlEncode($V_NilaiMhs_list->Kode_MK->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_V_NilaiMhs" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($V_NilaiMhs_list->TotalRecords > 0 || $V_NilaiMhs_list->isGridEdit()) { ?>
<table id="tbl_V_NilaiMhslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$V_NilaiMhs->RowType = ROWTYPE_HEADER;

// Render list options
$V_NilaiMhs_list->renderListOptions();

// Render list options (header, left)
$V_NilaiMhs_list->ListOptions->render("header", "left");
?>
<th>Sync</th>
<?php if ($V_NilaiMhs_list->IDTahun->Visible) { // IDTahun ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->IDTahun) == "") { ?>
		<th data-name="IDTahun" class="<?php echo $V_NilaiMhs_list->IDTahun->headerCellClass() ?>"><div id="elh_V_NilaiMhs_IDTahun" class="V_NilaiMhs_IDTahun"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->IDTahun->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IDTahun" class="<?php echo $V_NilaiMhs_list->IDTahun->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->IDTahun) ?>', 1);"><div id="elh_V_NilaiMhs_IDTahun" class="V_NilaiMhs_IDTahun">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->IDTahun->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->IDTahun->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->IDTahun->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->Kode_MK->Visible) { // Kode_MK ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Kode_MK) == "") { ?>
		<th data-name="Kode_MK" class="<?php echo $V_NilaiMhs_list->Kode_MK->headerCellClass() ?>"><div id="elh_V_NilaiMhs_Kode_MK" class="V_NilaiMhs_Kode_MK"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Kode_MK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_MK" class="<?php echo $V_NilaiMhs_list->Kode_MK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Kode_MK) ?>', 1);"><div id="elh_V_NilaiMhs_Kode_MK" class="V_NilaiMhs_Kode_MK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Kode_MK->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->Kode_MK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->Kode_MK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->Nim->Visible) { // Nim ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $V_NilaiMhs_list->Nim->headerCellClass() ?>"><div id="elh_V_NilaiMhs_Nim" class="V_NilaiMhs_Nim"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $V_NilaiMhs_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Nim) ?>', 1);"><div id="elh_V_NilaiMhs_Nim" class="V_NilaiMhs_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $V_NilaiMhs_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_V_NilaiMhs_Nama_Mhs" class="V_NilaiMhs_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $V_NilaiMhs_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Nama_Mhs) ?>', 1);"><div id="elh_V_NilaiMhs_Nama_Mhs" class="V_NilaiMhs_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->Kehadiran->Visible) { // Kehadiran ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Kehadiran) == "") { ?>
		<th data-name="Kehadiran" class="<?php echo $V_NilaiMhs_list->Kehadiran->headerCellClass() ?>"><div id="elh_V_NilaiMhs_Kehadiran" class="V_NilaiMhs_Kehadiran"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Kehadiran->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kehadiran" class="<?php echo $V_NilaiMhs_list->Kehadiran->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Kehadiran) ?>', 1);"><div id="elh_V_NilaiMhs_Kehadiran" class="V_NilaiMhs_Kehadiran">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Kehadiran->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->Kehadiran->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->Kehadiran->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->Tugas->Visible) { // Tugas ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Tugas) == "") { ?>
		<th data-name="Tugas" class="<?php echo $V_NilaiMhs_list->Tugas->headerCellClass() ?>"><div id="elh_V_NilaiMhs_Tugas" class="V_NilaiMhs_Tugas"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Tugas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tugas" class="<?php echo $V_NilaiMhs_list->Tugas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Tugas) ?>', 1);"><div id="elh_V_NilaiMhs_Tugas" class="V_NilaiMhs_Tugas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Tugas->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->Tugas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->Tugas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->UTS->Visible) { // UTS ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->UTS) == "") { ?>
		<th data-name="UTS" class="<?php echo $V_NilaiMhs_list->UTS->headerCellClass() ?>"><div id="elh_V_NilaiMhs_UTS" class="V_NilaiMhs_UTS"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->UTS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UTS" class="<?php echo $V_NilaiMhs_list->UTS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->UTS) ?>', 1);"><div id="elh_V_NilaiMhs_UTS" class="V_NilaiMhs_UTS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->UTS->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->UTS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->UTS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->UAS->Visible) { // UAS ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->UAS) == "") { ?>
		<th data-name="UAS" class="<?php echo $V_NilaiMhs_list->UAS->headerCellClass() ?>"><div id="elh_V_NilaiMhs_UAS" class="V_NilaiMhs_UAS"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->UAS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UAS" class="<?php echo $V_NilaiMhs_list->UAS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->UAS) ?>', 1);"><div id="elh_V_NilaiMhs_UAS" class="V_NilaiMhs_UAS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->UAS->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->UAS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->UAS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->Jumlah->Visible) { // Jumlah ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Jumlah) == "") { ?>
		<th data-name="Jumlah" class="<?php echo $V_NilaiMhs_list->Jumlah->headerCellClass() ?>"><div id="elh_V_NilaiMhs_Jumlah" class="V_NilaiMhs_Jumlah"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Jumlah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jumlah" class="<?php echo $V_NilaiMhs_list->Jumlah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Jumlah) ?>', 1);"><div id="elh_V_NilaiMhs_Jumlah" class="V_NilaiMhs_Jumlah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Jumlah->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->Jumlah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->Jumlah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->Nilai->Visible) { // Nilai ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Nilai) == "") { ?>
		<th data-name="Nilai" class="<?php echo $V_NilaiMhs_list->Nilai->headerCellClass() ?>"><div id="elh_V_NilaiMhs_Nilai" class="V_NilaiMhs_Nilai"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Nilai->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nilai" class="<?php echo $V_NilaiMhs_list->Nilai->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Nilai) ?>', 1);"><div id="elh_V_NilaiMhs_Nilai" class="V_NilaiMhs_Nilai">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Nilai->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->Nilai->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->Nilai->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->Angka->Visible) { // Angka ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Angka) == "") { ?>
		<th data-name="Angka" class="<?php echo $V_NilaiMhs_list->Angka->headerCellClass() ?>"><div id="elh_V_NilaiMhs_Angka" class="V_NilaiMhs_Angka"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Angka->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Angka" class="<?php echo $V_NilaiMhs_list->Angka->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->Angka) ?>', 1);"><div id="elh_V_NilaiMhs_Angka" class="V_NilaiMhs_Angka">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->Angka->caption() ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->Angka->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->Angka->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->id_feedmhs->Visible) { // id_feedmhs ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->id_feedmhs) == "") { ?>
		<th data-name="id_feedmhs" class="<?php echo $V_NilaiMhs_list->id_feedmhs->headerCellClass() ?>"><div id="elh_V_NilaiMhs_id_feedmhs" class="V_NilaiMhs_id_feedmhs"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->id_feedmhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_feedmhs" class="<?php echo $V_NilaiMhs_list->id_feedmhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->id_feedmhs) ?>', 1);"><div id="elh_V_NilaiMhs_id_feedmhs" class="V_NilaiMhs_id_feedmhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->id_feedmhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->id_feedmhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->id_feedmhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($V_NilaiMhs_list->stat_feeder->Visible) { // stat_feeder ?>
	<?php if ($V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->stat_feeder) == "") { ?>
		<th data-name="stat_feeder" class="<?php echo $V_NilaiMhs_list->stat_feeder->headerCellClass() ?>"><div id="elh_V_NilaiMhs_stat_feeder" class="V_NilaiMhs_stat_feeder"><div class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->stat_feeder->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stat_feeder" class="<?php echo $V_NilaiMhs_list->stat_feeder->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $V_NilaiMhs_list->SortUrl($V_NilaiMhs_list->stat_feeder) ?>', 1);"><div id="elh_V_NilaiMhs_stat_feeder" class="V_NilaiMhs_stat_feeder">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $V_NilaiMhs_list->stat_feeder->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($V_NilaiMhs_list->stat_feeder->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($V_NilaiMhs_list->stat_feeder->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$V_NilaiMhs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($V_NilaiMhs_list->ExportAll && $V_NilaiMhs_list->isExport()) {
	$V_NilaiMhs_list->StopRecord = $V_NilaiMhs_list->TotalRecords;
} else {

	// Set the last record to display
	if ($V_NilaiMhs_list->TotalRecords > $V_NilaiMhs_list->StartRecord + $V_NilaiMhs_list->DisplayRecords - 1)
		$V_NilaiMhs_list->StopRecord = $V_NilaiMhs_list->StartRecord + $V_NilaiMhs_list->DisplayRecords - 1;
	else
		$V_NilaiMhs_list->StopRecord = $V_NilaiMhs_list->TotalRecords;
}
$V_NilaiMhs_list->RecordCount = $V_NilaiMhs_list->StartRecord - 1;
if ($V_NilaiMhs_list->Recordset && !$V_NilaiMhs_list->Recordset->EOF) {
	$V_NilaiMhs_list->Recordset->moveFirst();
	$selectLimit = $V_NilaiMhs_list->UseSelectLimit;
	if (!$selectLimit && $V_NilaiMhs_list->StartRecord > 1)
		$V_NilaiMhs_list->Recordset->move($V_NilaiMhs_list->StartRecord - 1);
} elseif (!$V_NilaiMhs->AllowAddDeleteRow && $V_NilaiMhs_list->StopRecord == 0) {
	$V_NilaiMhs_list->StopRecord = $V_NilaiMhs->GridAddRowCount;
}

// Initialize aggregate
$V_NilaiMhs->RowType = ROWTYPE_AGGREGATEINIT;
$V_NilaiMhs->resetAttributes();
$V_NilaiMhs_list->renderRow();
while ($V_NilaiMhs_list->RecordCount < $V_NilaiMhs_list->StopRecord) {
	$V_NilaiMhs_list->RecordCount++;
	if ($V_NilaiMhs_list->RecordCount >= $V_NilaiMhs_list->StartRecord) {
		$V_NilaiMhs_list->RowCount++;

		// Set up key count
		$V_NilaiMhs_list->KeyCount = $V_NilaiMhs_list->RowIndex;

		// Init row class and style
		$V_NilaiMhs->resetAttributes();
		$V_NilaiMhs->CssClass = "";
		if ($V_NilaiMhs_list->isGridAdd()) {
		} else {
			$V_NilaiMhs_list->loadRowValues($V_NilaiMhs_list->Recordset); // Load row values
		}
		$V_NilaiMhs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$V_NilaiMhs->RowAttrs->merge(["data-rowindex" => $V_NilaiMhs_list->RowCount, "id" => "r" . $V_NilaiMhs_list->RowCount . "_V_NilaiMhs", "data-rowtype" => $V_NilaiMhs->RowType]);

		// Render row
		$V_NilaiMhs_list->renderRow();

		// Render list options
		$V_NilaiMhs_list->renderListOptions();
?>
	<tr <?php echo $V_NilaiMhs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$V_NilaiMhs_list->ListOptions->render("body", "left", $V_NilaiMhs_list->RowCount);
?>
<td>
 <a href="feed/nilaipermk.php?IDTahun=<?php echo $V_NilaiMhs_list->IDTahun->getViewValue() ?>&Nim=<?php echo trim($V_NilaiMhs_list->Nim->getViewValue()) ?>&Kode_Mk=<?php echo trim($V_NilaiMhs_list->Kode_MK->getViewValue()) ?>" class="btn btn-primary btn-sm" target="_blank">Syn</a>
</td>
	<?php if ($V_NilaiMhs_list->IDTahun->Visible) { // IDTahun ?>
		<td data-name="IDTahun" <?php echo $V_NilaiMhs_list->IDTahun->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_IDTahun">
<span<?php echo $V_NilaiMhs_list->IDTahun->viewAttributes() ?>><?php echo $V_NilaiMhs_list->IDTahun->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK" <?php echo $V_NilaiMhs_list->Kode_MK->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_Kode_MK">
<span<?php echo $V_NilaiMhs_list->Kode_MK->viewAttributes() ?>><?php echo $V_NilaiMhs_list->Kode_MK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $V_NilaiMhs_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_Nim">
<span<?php echo $V_NilaiMhs_list->Nim->viewAttributes() ?>><?php echo $V_NilaiMhs_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $V_NilaiMhs_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_Nama_Mhs">
<span<?php echo $V_NilaiMhs_list->Nama_Mhs->viewAttributes() ?>><?php echo $V_NilaiMhs_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->Kehadiran->Visible) { // Kehadiran ?>
		<td data-name="Kehadiran" <?php echo $V_NilaiMhs_list->Kehadiran->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_Kehadiran">
<span<?php echo $V_NilaiMhs_list->Kehadiran->viewAttributes() ?>><?php echo $V_NilaiMhs_list->Kehadiran->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->Tugas->Visible) { // Tugas ?>
		<td data-name="Tugas" <?php echo $V_NilaiMhs_list->Tugas->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_Tugas">
<span<?php echo $V_NilaiMhs_list->Tugas->viewAttributes() ?>><?php echo $V_NilaiMhs_list->Tugas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->UTS->Visible) { // UTS ?>
		<td data-name="UTS" <?php echo $V_NilaiMhs_list->UTS->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_UTS">
<span<?php echo $V_NilaiMhs_list->UTS->viewAttributes() ?>><?php echo $V_NilaiMhs_list->UTS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->UAS->Visible) { // UAS ?>
		<td data-name="UAS" <?php echo $V_NilaiMhs_list->UAS->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_UAS">
<span<?php echo $V_NilaiMhs_list->UAS->viewAttributes() ?>><?php echo $V_NilaiMhs_list->UAS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->Jumlah->Visible) { // Jumlah ?>
		<td data-name="Jumlah" <?php echo $V_NilaiMhs_list->Jumlah->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_Jumlah">
<span<?php echo $V_NilaiMhs_list->Jumlah->viewAttributes() ?>><?php echo $V_NilaiMhs_list->Jumlah->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->Nilai->Visible) { // Nilai ?>
		<td data-name="Nilai" <?php echo $V_NilaiMhs_list->Nilai->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_Nilai">
<span<?php echo $V_NilaiMhs_list->Nilai->viewAttributes() ?>><?php echo $V_NilaiMhs_list->Nilai->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->Angka->Visible) { // Angka ?>
		<td data-name="Angka" <?php echo $V_NilaiMhs_list->Angka->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_Angka">
<span<?php echo $V_NilaiMhs_list->Angka->viewAttributes() ?>><?php echo $V_NilaiMhs_list->Angka->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->id_feedmhs->Visible) { // id_feedmhs ?>
		<td data-name="id_feedmhs" <?php echo $V_NilaiMhs_list->id_feedmhs->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_id_feedmhs">
<span<?php echo $V_NilaiMhs_list->id_feedmhs->viewAttributes() ?>><?php echo $V_NilaiMhs_list->id_feedmhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($V_NilaiMhs_list->stat_feeder->Visible) { // stat_feeder ?>
		<td data-name="stat_feeder" <?php echo $V_NilaiMhs_list->stat_feeder->cellAttributes() ?>>
<span id="el<?php echo $V_NilaiMhs_list->RowCount ?>_V_NilaiMhs_stat_feeder">
<span<?php echo $V_NilaiMhs_list->stat_feeder->viewAttributes() ?>><?php echo $V_NilaiMhs_list->stat_feeder->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$V_NilaiMhs_list->ListOptions->render("body", "right", $V_NilaiMhs_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$V_NilaiMhs_list->isGridAdd())
		$V_NilaiMhs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$V_NilaiMhs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($V_NilaiMhs_list->Recordset)
	$V_NilaiMhs_list->Recordset->Close();
?>
<?php if (!$V_NilaiMhs_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$V_NilaiMhs_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $V_NilaiMhs_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $V_NilaiMhs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($V_NilaiMhs_list->TotalRecords == 0 && !$V_NilaiMhs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $V_NilaiMhs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$V_NilaiMhs_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$V_NilaiMhs_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$V_NilaiMhs_list->terminate();
?>