<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$Wali_IPS_preview = new Wali_IPS_preview();

// Run the page
$Wali_IPS_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Wali_IPS_preview->Page_Render();
?>
<?php $Wali_IPS_preview->showPageHeader(); ?>
<?php if ($Wali_IPS_preview->TotalRecords > 0) { ?>
<div class="card ew-grid Wali_IPS"><!-- .card -->
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel ew-preview-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$Wali_IPS_preview->renderListOptions();

// Render list options (header, left)
$Wali_IPS_preview->ListOptions->render("header", "left");
?>
<?php if ($Wali_IPS_preview->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($Wali_IPS->SortUrl($Wali_IPS_preview->Thn_Akademik) == "") { ?>
		<th class="<?php echo $Wali_IPS_preview->Thn_Akademik->headerCellClass() ?>"><?php echo $Wali_IPS_preview->Thn_Akademik->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $Wali_IPS_preview->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($Wali_IPS_preview->Thn_Akademik->Name) ?>" data-sort-order="<?php echo $Wali_IPS_preview->SortField == $Wali_IPS_preview->Thn_Akademik->Name && $Wali_IPS_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_IPS_preview->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_IPS_preview->SortField == $Wali_IPS_preview->Thn_Akademik->Name) { ?><?php if ($Wali_IPS_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_IPS_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_IPS_preview->Periode->Visible) { // Periode ?>
	<?php if ($Wali_IPS->SortUrl($Wali_IPS_preview->Periode) == "") { ?>
		<th class="<?php echo $Wali_IPS_preview->Periode->headerCellClass() ?>"><?php echo $Wali_IPS_preview->Periode->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $Wali_IPS_preview->Periode->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($Wali_IPS_preview->Periode->Name) ?>" data-sort-order="<?php echo $Wali_IPS_preview->SortField == $Wali_IPS_preview->Periode->Name && $Wali_IPS_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_IPS_preview->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_IPS_preview->SortField == $Wali_IPS_preview->Periode->Name) { ?><?php if ($Wali_IPS_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_IPS_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_IPS_preview->TSKS->Visible) { // TSKS ?>
	<?php if ($Wali_IPS->SortUrl($Wali_IPS_preview->TSKS) == "") { ?>
		<th class="<?php echo $Wali_IPS_preview->TSKS->headerCellClass() ?>"><?php echo $Wali_IPS_preview->TSKS->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $Wali_IPS_preview->TSKS->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($Wali_IPS_preview->TSKS->Name) ?>" data-sort-order="<?php echo $Wali_IPS_preview->SortField == $Wali_IPS_preview->TSKS->Name && $Wali_IPS_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_IPS_preview->TSKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_IPS_preview->SortField == $Wali_IPS_preview->TSKS->Name) { ?><?php if ($Wali_IPS_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_IPS_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_IPS_preview->ips->Visible) { // ips ?>
	<?php if ($Wali_IPS->SortUrl($Wali_IPS_preview->ips) == "") { ?>
		<th class="<?php echo $Wali_IPS_preview->ips->headerCellClass() ?>"><?php echo $Wali_IPS_preview->ips->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $Wali_IPS_preview->ips->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($Wali_IPS_preview->ips->Name) ?>" data-sort-order="<?php echo $Wali_IPS_preview->SortField == $Wali_IPS_preview->ips->Name && $Wali_IPS_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_IPS_preview->ips->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_IPS_preview->SortField == $Wali_IPS_preview->ips->Name) { ?><?php if ($Wali_IPS_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_IPS_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_IPS_preview->Thdr->Visible) { // Thdr ?>
	<?php if ($Wali_IPS->SortUrl($Wali_IPS_preview->Thdr) == "") { ?>
		<th class="<?php echo $Wali_IPS_preview->Thdr->headerCellClass() ?>"><?php echo $Wali_IPS_preview->Thdr->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $Wali_IPS_preview->Thdr->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($Wali_IPS_preview->Thdr->Name) ?>" data-sort-order="<?php echo $Wali_IPS_preview->SortField == $Wali_IPS_preview->Thdr->Name && $Wali_IPS_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_IPS_preview->Thdr->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_IPS_preview->SortField == $Wali_IPS_preview->Thdr->Name) { ?><?php if ($Wali_IPS_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_IPS_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$Wali_IPS_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$Wali_IPS_preview->RecCount = 0;
$Wali_IPS_preview->RowCount = 0;
while ($Wali_IPS_preview->Recordset && !$Wali_IPS_preview->Recordset->EOF) {

	// Init row class and style
	$Wali_IPS_preview->RecCount++;
	$Wali_IPS_preview->RowCount++;
	$Wali_IPS_preview->CssStyle = "";
	$Wali_IPS_preview->loadListRowValues($Wali_IPS_preview->Recordset);
	$Wali_IPS_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$Wali_IPS->RowType = ROWTYPE_PREVIEW; // Preview record
	$Wali_IPS_preview->resetAttributes();
	$Wali_IPS_preview->renderListRow();

	// Render list options
	$Wali_IPS_preview->renderListOptions();
?>
	<tr <?php echo $Wali_IPS->rowAttributes() ?>>
<?php

// Render list options (body, left)
$Wali_IPS_preview->ListOptions->render("body", "left", $Wali_IPS_preview->RowCount);
?>
<?php if ($Wali_IPS_preview->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<!-- Thn_Akademik -->
		<td<?php echo $Wali_IPS_preview->Thn_Akademik->cellAttributes() ?>>
<span<?php echo $Wali_IPS_preview->Thn_Akademik->viewAttributes() ?>><?php echo $Wali_IPS_preview->Thn_Akademik->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Wali_IPS_preview->Periode->Visible) { // Periode ?>
		<!-- Periode -->
		<td<?php echo $Wali_IPS_preview->Periode->cellAttributes() ?>>
<span<?php echo $Wali_IPS_preview->Periode->viewAttributes() ?>><?php echo $Wali_IPS_preview->Periode->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Wali_IPS_preview->TSKS->Visible) { // TSKS ?>
		<!-- TSKS -->
		<td<?php echo $Wali_IPS_preview->TSKS->cellAttributes() ?>>
<span<?php echo $Wali_IPS_preview->TSKS->viewAttributes() ?>><?php echo $Wali_IPS_preview->TSKS->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Wali_IPS_preview->ips->Visible) { // ips ?>
		<!-- ips -->
		<td<?php echo $Wali_IPS_preview->ips->cellAttributes() ?>>
<span<?php echo $Wali_IPS_preview->ips->viewAttributes() ?>><?php echo $Wali_IPS_preview->ips->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Wali_IPS_preview->Thdr->Visible) { // Thdr ?>
		<!-- Thdr -->
		<td<?php echo $Wali_IPS_preview->Thdr->cellAttributes() ?>>
<span<?php echo $Wali_IPS_preview->Thdr->viewAttributes() ?>><?php echo $Wali_IPS_preview->Thdr->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$Wali_IPS_preview->ListOptions->render("body", "right", $Wali_IPS_preview->RowCount);
?>
	</tr>
<?php
	$Wali_IPS_preview->Recordset->MoveNext();
} // while
?>
	</tbody>
<?php

	// Render aggregate row
	$Wali_IPS->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$Wali_IPS_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$Wali_IPS_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$Wali_IPS_preview->ListOptions->render("footer", "left");
?>
<?php if ($Wali_IPS_preview->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<!-- Thn_Akademik -->
		<td class="<?php echo $Wali_IPS_preview->Thn_Akademik->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($Wali_IPS_preview->Periode->Visible) { // Periode ?>
		<!-- Periode -->
		<td class="<?php echo $Wali_IPS_preview->Periode->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($Wali_IPS_preview->TSKS->Visible) { // TSKS ?>
		<!-- TSKS -->
		<td class="<?php echo $Wali_IPS_preview->TSKS->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $Wali_IPS_preview->TSKS->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($Wali_IPS_preview->ips->Visible) { // ips ?>
		<!-- ips -->
		<td class="<?php echo $Wali_IPS_preview->ips->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($Wali_IPS_preview->Thdr->Visible) { // Thdr ?>
		<!-- Thdr -->
		<td class="<?php echo $Wali_IPS_preview->Thdr->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$Wali_IPS_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php echo $Wali_IPS_preview->Pager->render() ?>
<?php } else { // No record ?>
<div class="card no-border">
<div class="ew-detail-count"><?php echo $Language->phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($Wali_IPS_preview->OtherOptions as $option)
		$option->render("body");
?>
</div>
<?php if ($Wali_IPS_preview->TotalRecords > 0) { ?>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
<?php } ?>
</div><!-- /.card -->
<?php
$Wali_IPS_preview->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php
if ($Wali_IPS_preview->Recordset)
	$Wali_IPS_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$Wali_IPS_preview->terminate();
?>