<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$Wali_JadkulMin_list = new Wali_JadkulMin_list();

// Run the page
$Wali_JadkulMin_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Wali_JadkulMin_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$Wali_JadkulMin_list->isExport()) { ?>
<script>
var fWali_JadkulMinlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fWali_JadkulMinlist = currentForm = new ew.Form("fWali_JadkulMinlist", "list");
	fWali_JadkulMinlist.formKeyCountName = '<?php echo $Wali_JadkulMin_list->FormKeyCountName ?>';
	loadjs.done("fWali_JadkulMinlist");
});
var fWali_JadkulMinlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fWali_JadkulMinlistsrch = currentSearchForm = new ew.Form("fWali_JadkulMinlistsrch");

	// Validate function for search
	fWali_JadkulMinlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fWali_JadkulMinlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fWali_JadkulMinlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fWali_JadkulMinlistsrch.lists["x_Thn_Akademik"] = <?php echo $Wali_JadkulMin_list->Thn_Akademik->Lookup->toClientList($Wali_JadkulMin_list) ?>;
	fWali_JadkulMinlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($Wali_JadkulMin_list->Thn_Akademik->lookupOptions()) ?>;
	fWali_JadkulMinlistsrch.lists["x_Periode"] = <?php echo $Wali_JadkulMin_list->Periode->Lookup->toClientList($Wali_JadkulMin_list) ?>;
	fWali_JadkulMinlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($Wali_JadkulMin_list->Periode->lookupOptions()) ?>;
	fWali_JadkulMinlistsrch.lists["x_Kelas_Akd"] = <?php echo $Wali_JadkulMin_list->Kelas_Akd->Lookup->toClientList($Wali_JadkulMin_list) ?>;
	fWali_JadkulMinlistsrch.lists["x_Kelas_Akd"].options = <?php echo JsonEncode($Wali_JadkulMin_list->Kelas_Akd->lookupOptions()) ?>;
	fWali_JadkulMinlistsrch.lists["x_Hari"] = <?php echo $Wali_JadkulMin_list->Hari->Lookup->toClientList($Wali_JadkulMin_list) ?>;
	fWali_JadkulMinlistsrch.lists["x_Hari"].options = <?php echo JsonEncode($Wali_JadkulMin_list->Hari->options(FALSE, TRUE)) ?>;

	// Filters
	fWali_JadkulMinlistsrch.filterList = <?php echo $Wali_JadkulMin_list->getFilterList() ?>;
	loadjs.done("fWali_JadkulMinlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$Wali_JadkulMin_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Wali_JadkulMin_list->TotalRecords > 0 && $Wali_JadkulMin_list->ExportOptions->visible()) { ?>
<?php $Wali_JadkulMin_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->ImportOptions->visible()) { ?>
<?php $Wali_JadkulMin_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->SearchOptions->visible()) { ?>
<?php $Wali_JadkulMin_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->FilterOptions->visible()) { ?>
<?php $Wali_JadkulMin_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$Wali_JadkulMin_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$Wali_JadkulMin_list->isExport() && !$Wali_JadkulMin->CurrentAction) { ?>
<form name="fWali_JadkulMinlistsrch" id="fWali_JadkulMinlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fWali_JadkulMinlistsrch-search-panel" class="<?php echo $Wali_JadkulMin_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="Wali_JadkulMin">
	<div class="ew-extended-search">
<?php

// Render search row
$Wali_JadkulMin->RowType = ROWTYPE_SEARCH;
$Wali_JadkulMin->resetAttributes();
$Wali_JadkulMin_list->renderRow();
?>
<?php if ($Wali_JadkulMin_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$Wali_JadkulMin_list->SearchColumnCount++;
		if (($Wali_JadkulMin_list->SearchColumnCount - 1) % $Wali_JadkulMin_list->SearchFieldsPerRow == 0) {
			$Wali_JadkulMin_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $Wali_JadkulMin_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $Wali_JadkulMin_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_Wali_JadkulMin_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Wali_JadkulMin" data-field="x_Thn_Akademik" data-value-separator="<?php echo $Wali_JadkulMin_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $Wali_JadkulMin_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $Wali_JadkulMin_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $Wali_JadkulMin_list->Thn_Akademik->Lookup->getParamTag($Wali_JadkulMin_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($Wali_JadkulMin_list->SearchColumnCount % $Wali_JadkulMin_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Periode->Visible) { // Periode ?>
	<?php
		$Wali_JadkulMin_list->SearchColumnCount++;
		if (($Wali_JadkulMin_list->SearchColumnCount - 1) % $Wali_JadkulMin_list->SearchFieldsPerRow == 0) {
			$Wali_JadkulMin_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $Wali_JadkulMin_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $Wali_JadkulMin_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_Wali_JadkulMin_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Wali_JadkulMin" data-field="x_Periode" data-value-separator="<?php echo $Wali_JadkulMin_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $Wali_JadkulMin_list->Periode->editAttributes() ?>>
			<?php echo $Wali_JadkulMin_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
<?php echo $Wali_JadkulMin_list->Periode->Lookup->getParamTag($Wali_JadkulMin_list, "p_x_Periode") ?>
</span>
	</div>
	<?php if ($Wali_JadkulMin_list->SearchColumnCount % $Wali_JadkulMin_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
	<?php
		$Wali_JadkulMin_list->SearchColumnCount++;
		if (($Wali_JadkulMin_list->SearchColumnCount - 1) % $Wali_JadkulMin_list->SearchFieldsPerRow == 0) {
			$Wali_JadkulMin_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $Wali_JadkulMin_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kelas_Akd" class="ew-cell form-group">
		<label for="x_Kelas_Akd" class="ew-search-caption ew-label"><?php echo $Wali_JadkulMin_list->Kelas_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kelas_Akd" id="z_Kelas_Akd" value="LIKE">
</span>
		<span id="el_Wali_JadkulMin_Kelas_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Wali_JadkulMin" data-field="x_Kelas_Akd" data-value-separator="<?php echo $Wali_JadkulMin_list->Kelas_Akd->displayValueSeparatorAttribute() ?>" id="x_Kelas_Akd" name="x_Kelas_Akd"<?php echo $Wali_JadkulMin_list->Kelas_Akd->editAttributes() ?>>
			<?php echo $Wali_JadkulMin_list->Kelas_Akd->selectOptionListHtml("x_Kelas_Akd") ?>
		</select>
</div>
<?php echo $Wali_JadkulMin_list->Kelas_Akd->Lookup->getParamTag($Wali_JadkulMin_list, "p_x_Kelas_Akd") ?>
</span>
	</div>
	<?php if ($Wali_JadkulMin_list->SearchColumnCount % $Wali_JadkulMin_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Hari->Visible) { // Hari ?>
	<?php
		$Wali_JadkulMin_list->SearchColumnCount++;
		if (($Wali_JadkulMin_list->SearchColumnCount - 1) % $Wali_JadkulMin_list->SearchFieldsPerRow == 0) {
			$Wali_JadkulMin_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $Wali_JadkulMin_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Hari" class="ew-cell form-group">
		<label for="x_Hari" class="ew-search-caption ew-label"><?php echo $Wali_JadkulMin_list->Hari->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Hari" id="z_Hari" value="LIKE">
</span>
		<span id="el_Wali_JadkulMin_Hari" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Wali_JadkulMin" data-field="x_Hari" data-value-separator="<?php echo $Wali_JadkulMin_list->Hari->displayValueSeparatorAttribute() ?>" id="x_Hari" name="x_Hari"<?php echo $Wali_JadkulMin_list->Hari->editAttributes() ?>>
			<?php echo $Wali_JadkulMin_list->Hari->selectOptionListHtml("x_Hari") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($Wali_JadkulMin_list->SearchColumnCount % $Wali_JadkulMin_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($Wali_JadkulMin_list->SearchColumnCount % $Wali_JadkulMin_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $Wali_JadkulMin_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($Wali_JadkulMin_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($Wali_JadkulMin_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $Wali_JadkulMin_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($Wali_JadkulMin_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($Wali_JadkulMin_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($Wali_JadkulMin_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($Wali_JadkulMin_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $Wali_JadkulMin_list->showPageHeader(); ?>
<?php
$Wali_JadkulMin_list->showMessage();
?>
<?php if ($Wali_JadkulMin_list->TotalRecords > 0 || $Wali_JadkulMin->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($Wali_JadkulMin_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> Wali_JadkulMin">
<form name="fWali_JadkulMinlist" id="fWali_JadkulMinlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="Wali_JadkulMin">
<div id="gmp_Wali_JadkulMin" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($Wali_JadkulMin_list->TotalRecords > 0 || $Wali_JadkulMin_list->isGridEdit()) { ?>
<table id="tbl_Wali_JadkulMinlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$Wali_JadkulMin->RowType = ROWTYPE_HEADER;

// Render list options
$Wali_JadkulMin_list->renderListOptions();

// Render list options (header, left)
$Wali_JadkulMin_list->ListOptions->render("header", "left");
?>
<?php if ($Wali_JadkulMin_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $Wali_JadkulMin_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Thn_Akademik" class="Wali_JadkulMin_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $Wali_JadkulMin_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Thn_Akademik) ?>', 1);"><div id="elh_Wali_JadkulMin_Thn_Akademik" class="Wali_JadkulMin_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Periode->Visible) { // Periode ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $Wali_JadkulMin_list->Periode->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Periode" class="Wali_JadkulMin_Periode"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $Wali_JadkulMin_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Periode) ?>', 1);"><div id="elh_Wali_JadkulMin_Periode" class="Wali_JadkulMin_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Kelas_Akd) == "") { ?>
		<th data-name="Kelas_Akd" class="<?php echo $Wali_JadkulMin_list->Kelas_Akd->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Kelas_Akd" class="Wali_JadkulMin_Kelas_Akd"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Kelas_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas_Akd" class="<?php echo $Wali_JadkulMin_list->Kelas_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Kelas_Akd) ?>', 1);"><div id="elh_Wali_JadkulMin_Kelas_Akd" class="Wali_JadkulMin_Kelas_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Kelas_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Kelas_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Kelas_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Prodi->Visible) { // Prodi ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Prodi) == "") { ?>
		<th data-name="Prodi" class="<?php echo $Wali_JadkulMin_list->Prodi->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Prodi" class="Wali_JadkulMin_Prodi"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Prodi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Prodi" class="<?php echo $Wali_JadkulMin_list->Prodi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Prodi) ?>', 1);"><div id="elh_Wali_JadkulMin_Prodi" class="Wali_JadkulMin_Prodi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Prodi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Prodi->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Prodi->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Nama->Visible) { // Nama ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Nama) == "") { ?>
		<th data-name="Nama" class="<?php echo $Wali_JadkulMin_list->Nama->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Nama" class="Wali_JadkulMin_Nama"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Nama->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama" class="<?php echo $Wali_JadkulMin_list->Nama->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Nama) ?>', 1);"><div id="elh_Wali_JadkulMin_Nama" class="Wali_JadkulMin_Nama">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Nama->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Nama->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Nama->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Nama_Mk_Ind) == "") { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $Wali_JadkulMin_list->Nama_Mk_Ind->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Nama_Mk_Ind" class="Wali_JadkulMin_Nama_Mk_Ind"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Nama_Mk_Ind->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $Wali_JadkulMin_list->Nama_Mk_Ind->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Nama_Mk_Ind) ?>', 1);"><div id="elh_Wali_JadkulMin_Nama_Mk_Ind" class="Wali_JadkulMin_Nama_Mk_Ind">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Nama_Mk_Ind->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Nama_Mk_Ind->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Nama_Mk_Ind->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->SKS->Visible) { // SKS ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->SKS) == "") { ?>
		<th data-name="SKS" class="<?php echo $Wali_JadkulMin_list->SKS->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_SKS" class="Wali_JadkulMin_SKS"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->SKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SKS" class="<?php echo $Wali_JadkulMin_list->SKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->SKS) ?>', 1);"><div id="elh_Wali_JadkulMin_SKS" class="Wali_JadkulMin_SKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->SKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->SKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->SKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Kelas->Visible) { // Kelas ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Kelas) == "") { ?>
		<th data-name="Kelas" class="<?php echo $Wali_JadkulMin_list->Kelas->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Kelas" class="Wali_JadkulMin_Kelas"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Kelas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas" class="<?php echo $Wali_JadkulMin_list->Kelas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Kelas) ?>', 1);"><div id="elh_Wali_JadkulMin_Kelas" class="Wali_JadkulMin_Kelas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Kelas->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Kelas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Kelas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Hari->Visible) { // Hari ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Hari) == "") { ?>
		<th data-name="Hari" class="<?php echo $Wali_JadkulMin_list->Hari->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Hari" class="Wali_JadkulMin_Hari"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Hari->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Hari" class="<?php echo $Wali_JadkulMin_list->Hari->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Hari) ?>', 1);"><div id="elh_Wali_JadkulMin_Hari" class="Wali_JadkulMin_Hari">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Hari->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Hari->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Hari->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->JM->Visible) { // JM ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->JM) == "") { ?>
		<th data-name="JM" class="<?php echo $Wali_JadkulMin_list->JM->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_JM" class="Wali_JadkulMin_JM"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->JM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JM" class="<?php echo $Wali_JadkulMin_list->JM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->JM) ?>', 1);"><div id="elh_Wali_JadkulMin_JM" class="Wali_JadkulMin_JM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->JM->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->JM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->JM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->JS->Visible) { // JS ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->JS) == "") { ?>
		<th data-name="JS" class="<?php echo $Wali_JadkulMin_list->JS->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_JS" class="Wali_JadkulMin_JS"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->JS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JS" class="<?php echo $Wali_JadkulMin_list->JS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->JS) ?>', 1);"><div id="elh_Wali_JadkulMin_JS" class="Wali_JadkulMin_JS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->JS->caption() ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->JS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->JS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Wali_JadkulMin_list->Ruang->Visible) { // Ruang ?>
	<?php if ($Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Ruang) == "") { ?>
		<th data-name="Ruang" class="<?php echo $Wali_JadkulMin_list->Ruang->headerCellClass() ?>"><div id="elh_Wali_JadkulMin_Ruang" class="Wali_JadkulMin_Ruang"><div class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Ruang->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ruang" class="<?php echo $Wali_JadkulMin_list->Ruang->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Wali_JadkulMin_list->SortUrl($Wali_JadkulMin_list->Ruang) ?>', 1);"><div id="elh_Wali_JadkulMin_Ruang" class="Wali_JadkulMin_Ruang">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Wali_JadkulMin_list->Ruang->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($Wali_JadkulMin_list->Ruang->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Wali_JadkulMin_list->Ruang->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$Wali_JadkulMin_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($Wali_JadkulMin_list->ExportAll && $Wali_JadkulMin_list->isExport()) {
	$Wali_JadkulMin_list->StopRecord = $Wali_JadkulMin_list->TotalRecords;
} else {

	// Set the last record to display
	if ($Wali_JadkulMin_list->TotalRecords > $Wali_JadkulMin_list->StartRecord + $Wali_JadkulMin_list->DisplayRecords - 1)
		$Wali_JadkulMin_list->StopRecord = $Wali_JadkulMin_list->StartRecord + $Wali_JadkulMin_list->DisplayRecords - 1;
	else
		$Wali_JadkulMin_list->StopRecord = $Wali_JadkulMin_list->TotalRecords;
}
$Wali_JadkulMin_list->RecordCount = $Wali_JadkulMin_list->StartRecord - 1;
if ($Wali_JadkulMin_list->Recordset && !$Wali_JadkulMin_list->Recordset->EOF) {
	$Wali_JadkulMin_list->Recordset->moveFirst();
	$selectLimit = $Wali_JadkulMin_list->UseSelectLimit;
	if (!$selectLimit && $Wali_JadkulMin_list->StartRecord > 1)
		$Wali_JadkulMin_list->Recordset->move($Wali_JadkulMin_list->StartRecord - 1);
} elseif (!$Wali_JadkulMin->AllowAddDeleteRow && $Wali_JadkulMin_list->StopRecord == 0) {
	$Wali_JadkulMin_list->StopRecord = $Wali_JadkulMin->GridAddRowCount;
}

// Initialize aggregate
$Wali_JadkulMin->RowType = ROWTYPE_AGGREGATEINIT;
$Wali_JadkulMin->resetAttributes();
$Wali_JadkulMin_list->renderRow();
while ($Wali_JadkulMin_list->RecordCount < $Wali_JadkulMin_list->StopRecord) {
	$Wali_JadkulMin_list->RecordCount++;
	if ($Wali_JadkulMin_list->RecordCount >= $Wali_JadkulMin_list->StartRecord) {
		$Wali_JadkulMin_list->RowCount++;

		// Set up key count
		$Wali_JadkulMin_list->KeyCount = $Wali_JadkulMin_list->RowIndex;

		// Init row class and style
		$Wali_JadkulMin->resetAttributes();
		$Wali_JadkulMin->CssClass = "";
		if ($Wali_JadkulMin_list->isGridAdd()) {
		} else {
			$Wali_JadkulMin_list->loadRowValues($Wali_JadkulMin_list->Recordset); // Load row values
		}
		$Wali_JadkulMin->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$Wali_JadkulMin->RowAttrs->merge(["data-rowindex" => $Wali_JadkulMin_list->RowCount, "id" => "r" . $Wali_JadkulMin_list->RowCount . "_Wali_JadkulMin", "data-rowtype" => $Wali_JadkulMin->RowType]);

		// Render row
		$Wali_JadkulMin_list->renderRow();

		// Render list options
		$Wali_JadkulMin_list->renderListOptions();
?>
	<tr <?php echo $Wali_JadkulMin->rowAttributes() ?>>
<?php

// Render list options (body, left)
$Wali_JadkulMin_list->ListOptions->render("body", "left", $Wali_JadkulMin_list->RowCount);
?>
	<?php if ($Wali_JadkulMin_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $Wali_JadkulMin_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Thn_Akademik">
<span<?php echo $Wali_JadkulMin_list->Thn_Akademik->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $Wali_JadkulMin_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Periode">
<span<?php echo $Wali_JadkulMin_list->Periode->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
		<td data-name="Kelas_Akd" <?php echo $Wali_JadkulMin_list->Kelas_Akd->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Kelas_Akd">
<span<?php echo $Wali_JadkulMin_list->Kelas_Akd->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Kelas_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->Prodi->Visible) { // Prodi ?>
		<td data-name="Prodi" <?php echo $Wali_JadkulMin_list->Prodi->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Prodi">
<span<?php echo $Wali_JadkulMin_list->Prodi->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Prodi->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->Nama->Visible) { // Nama ?>
		<td data-name="Nama" <?php echo $Wali_JadkulMin_list->Nama->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Nama">
<span<?php echo $Wali_JadkulMin_list->Nama->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Nama->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
		<td data-name="Nama_Mk_Ind" <?php echo $Wali_JadkulMin_list->Nama_Mk_Ind->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Nama_Mk_Ind">
<span<?php echo $Wali_JadkulMin_list->Nama_Mk_Ind->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Nama_Mk_Ind->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS" <?php echo $Wali_JadkulMin_list->SKS->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_SKS">
<span<?php echo $Wali_JadkulMin_list->SKS->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->SKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->Kelas->Visible) { // Kelas ?>
		<td data-name="Kelas" <?php echo $Wali_JadkulMin_list->Kelas->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Kelas">
<span<?php echo $Wali_JadkulMin_list->Kelas->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Kelas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->Hari->Visible) { // Hari ?>
		<td data-name="Hari" <?php echo $Wali_JadkulMin_list->Hari->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Hari">
<span<?php echo $Wali_JadkulMin_list->Hari->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Hari->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->JM->Visible) { // JM ?>
		<td data-name="JM" <?php echo $Wali_JadkulMin_list->JM->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_JM">
<span<?php echo $Wali_JadkulMin_list->JM->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->JM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->JS->Visible) { // JS ?>
		<td data-name="JS" <?php echo $Wali_JadkulMin_list->JS->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_JS">
<span<?php echo $Wali_JadkulMin_list->JS->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->JS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Wali_JadkulMin_list->Ruang->Visible) { // Ruang ?>
		<td data-name="Ruang" <?php echo $Wali_JadkulMin_list->Ruang->cellAttributes() ?>>
<span id="el<?php echo $Wali_JadkulMin_list->RowCount ?>_Wali_JadkulMin_Ruang">
<span<?php echo $Wali_JadkulMin_list->Ruang->viewAttributes() ?>><?php echo $Wali_JadkulMin_list->Ruang->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$Wali_JadkulMin_list->ListOptions->render("body", "right", $Wali_JadkulMin_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$Wali_JadkulMin_list->isGridAdd())
		$Wali_JadkulMin_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Wali_JadkulMin->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($Wali_JadkulMin_list->Recordset)
	$Wali_JadkulMin_list->Recordset->Close();
?>
<?php if (!$Wali_JadkulMin_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Wali_JadkulMin_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $Wali_JadkulMin_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $Wali_JadkulMin_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($Wali_JadkulMin_list->TotalRecords == 0 && !$Wali_JadkulMin->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $Wali_JadkulMin_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$Wali_JadkulMin_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$Wali_JadkulMin_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$Wali_JadkulMin_list->terminate();
?>