<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$baak_rcndsnhadir_list = new baak_rcndsnhadir_list();

// Run the page
$baak_rcndsnhadir_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$baak_rcndsnhadir_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$baak_rcndsnhadir_list->isExport()) { ?>
<script>
var fbaak_rcndsnhadirlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fbaak_rcndsnhadirlist = currentForm = new ew.Form("fbaak_rcndsnhadirlist", "list");
	fbaak_rcndsnhadirlist.formKeyCountName = '<?php echo $baak_rcndsnhadir_list->FormKeyCountName ?>';
	loadjs.done("fbaak_rcndsnhadirlist");
});
var fbaak_rcndsnhadirlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fbaak_rcndsnhadirlistsrch = currentSearchForm = new ew.Form("fbaak_rcndsnhadirlistsrch");

	// Validate function for search
	fbaak_rcndsnhadirlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";
		elm = this.getElements("x" + infix + "_Tanggal");
		if (elm && !ew.checkEuroDate(elm.value))
			return this.onError(elm, "<?php echo JsEncode($baak_rcndsnhadir_list->Tanggal->errorMessage()) ?>");

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fbaak_rcndsnhadirlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fbaak_rcndsnhadirlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fbaak_rcndsnhadirlistsrch.lists["x_Kode_Fak"] = <?php echo $baak_rcndsnhadir_list->Kode_Fak->Lookup->toClientList($baak_rcndsnhadir_list) ?>;
	fbaak_rcndsnhadirlistsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($baak_rcndsnhadir_list->Kode_Fak->lookupOptions()) ?>;
	fbaak_rcndsnhadirlistsrch.lists["x_Thn_Akademik"] = <?php echo $baak_rcndsnhadir_list->Thn_Akademik->Lookup->toClientList($baak_rcndsnhadir_list) ?>;
	fbaak_rcndsnhadirlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($baak_rcndsnhadir_list->Thn_Akademik->lookupOptions()) ?>;
	fbaak_rcndsnhadirlistsrch.lists["x_Periode"] = <?php echo $baak_rcndsnhadir_list->Periode->Lookup->toClientList($baak_rcndsnhadir_list) ?>;
	fbaak_rcndsnhadirlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($baak_rcndsnhadir_list->Periode->options(FALSE, TRUE)) ?>;
	fbaak_rcndsnhadirlistsrch.lists["x_Kelas_Akd"] = <?php echo $baak_rcndsnhadir_list->Kelas_Akd->Lookup->toClientList($baak_rcndsnhadir_list) ?>;
	fbaak_rcndsnhadirlistsrch.lists["x_Kelas_Akd"].options = <?php echo JsonEncode($baak_rcndsnhadir_list->Kelas_Akd->lookupOptions()) ?>;

	// Filters
	fbaak_rcndsnhadirlistsrch.filterList = <?php echo $baak_rcndsnhadir_list->getFilterList() ?>;
	loadjs.done("fbaak_rcndsnhadirlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$baak_rcndsnhadir_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($baak_rcndsnhadir_list->TotalRecords > 0 && $baak_rcndsnhadir_list->ExportOptions->visible()) { ?>
<?php $baak_rcndsnhadir_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->ImportOptions->visible()) { ?>
<?php $baak_rcndsnhadir_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->SearchOptions->visible()) { ?>
<?php $baak_rcndsnhadir_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->FilterOptions->visible()) { ?>
<?php $baak_rcndsnhadir_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$baak_rcndsnhadir_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$baak_rcndsnhadir_list->isExport() && !$baak_rcndsnhadir->CurrentAction) { ?>
<form name="fbaak_rcndsnhadirlistsrch" id="fbaak_rcndsnhadirlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fbaak_rcndsnhadirlistsrch-search-panel" class="<?php echo $baak_rcndsnhadir_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="baak_rcndsnhadir">
	<div class="ew-extended-search">
<?php

// Render search row
$baak_rcndsnhadir->RowType = ROWTYPE_SEARCH;
$baak_rcndsnhadir->resetAttributes();
$baak_rcndsnhadir_list->renderRow();
?>
<?php if ($baak_rcndsnhadir_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$baak_rcndsnhadir_list->SearchColumnCount++;
		if (($baak_rcndsnhadir_list->SearchColumnCount - 1) % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) {
			$baak_rcndsnhadir_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $baak_rcndsnhadir_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $baak_rcndsnhadir_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_baak_rcndsnhadir_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="baak_rcndsnhadir" data-field="x_Kode_Fak" data-value-separator="<?php echo $baak_rcndsnhadir_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $baak_rcndsnhadir_list->Kode_Fak->editAttributes() ?>>
			<?php echo $baak_rcndsnhadir_list->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $baak_rcndsnhadir_list->Kode_Fak->Lookup->getParamTag($baak_rcndsnhadir_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($baak_rcndsnhadir_list->SearchColumnCount % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$baak_rcndsnhadir_list->SearchColumnCount++;
		if (($baak_rcndsnhadir_list->SearchColumnCount - 1) % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) {
			$baak_rcndsnhadir_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $baak_rcndsnhadir_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $baak_rcndsnhadir_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_baak_rcndsnhadir_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="baak_rcndsnhadir" data-field="x_Thn_Akademik" data-value-separator="<?php echo $baak_rcndsnhadir_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $baak_rcndsnhadir_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $baak_rcndsnhadir_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $baak_rcndsnhadir_list->Thn_Akademik->Lookup->getParamTag($baak_rcndsnhadir_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($baak_rcndsnhadir_list->SearchColumnCount % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Periode->Visible) { // Periode ?>
	<?php
		$baak_rcndsnhadir_list->SearchColumnCount++;
		if (($baak_rcndsnhadir_list->SearchColumnCount - 1) % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) {
			$baak_rcndsnhadir_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $baak_rcndsnhadir_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $baak_rcndsnhadir_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_baak_rcndsnhadir_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="baak_rcndsnhadir" data-field="x_Periode" data-value-separator="<?php echo $baak_rcndsnhadir_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $baak_rcndsnhadir_list->Periode->editAttributes() ?>>
			<?php echo $baak_rcndsnhadir_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($baak_rcndsnhadir_list->SearchColumnCount % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
	<?php
		$baak_rcndsnhadir_list->SearchColumnCount++;
		if (($baak_rcndsnhadir_list->SearchColumnCount - 1) % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) {
			$baak_rcndsnhadir_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $baak_rcndsnhadir_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kelas_Akd" class="ew-cell form-group">
		<label for="x_Kelas_Akd" class="ew-search-caption ew-label"><?php echo $baak_rcndsnhadir_list->Kelas_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kelas_Akd" id="z_Kelas_Akd" value="LIKE">
</span>
		<span id="el_baak_rcndsnhadir_Kelas_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="baak_rcndsnhadir" data-field="x_Kelas_Akd" data-value-separator="<?php echo $baak_rcndsnhadir_list->Kelas_Akd->displayValueSeparatorAttribute() ?>" id="x_Kelas_Akd" name="x_Kelas_Akd"<?php echo $baak_rcndsnhadir_list->Kelas_Akd->editAttributes() ?>>
			<?php echo $baak_rcndsnhadir_list->Kelas_Akd->selectOptionListHtml("x_Kelas_Akd") ?>
		</select>
</div>
<?php echo $baak_rcndsnhadir_list->Kelas_Akd->Lookup->getParamTag($baak_rcndsnhadir_list, "p_x_Kelas_Akd") ?>
</span>
	</div>
	<?php if ($baak_rcndsnhadir_list->SearchColumnCount % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Tanggal->Visible) { // Tanggal ?>
	<?php
		$baak_rcndsnhadir_list->SearchColumnCount++;
		if (($baak_rcndsnhadir_list->SearchColumnCount - 1) % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) {
			$baak_rcndsnhadir_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $baak_rcndsnhadir_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Tanggal" class="ew-cell form-group">
		<label for="x_Tanggal" class="ew-search-caption ew-label"><?php echo $baak_rcndsnhadir_list->Tanggal->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("BETWEEN") ?>
<input type="hidden" name="z_Tanggal" id="z_Tanggal" value="BETWEEN">
</span>
		<span id="el_baak_rcndsnhadir_Tanggal" class="ew-search-field">
<input type="text" data-table="baak_rcndsnhadir" data-field="x_Tanggal" data-format="7" name="x_Tanggal" id="x_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($baak_rcndsnhadir_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $baak_rcndsnhadir_list->Tanggal->EditValue ?>"<?php echo $baak_rcndsnhadir_list->Tanggal->editAttributes() ?>>
<?php if (!$baak_rcndsnhadir_list->Tanggal->ReadOnly && !$baak_rcndsnhadir_list->Tanggal->Disabled && !isset($baak_rcndsnhadir_list->Tanggal->EditAttrs["readonly"]) && !isset($baak_rcndsnhadir_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbaak_rcndsnhadirlistsrch", "datetimepicker"], function() {
	ew.createDateTimePicker("fbaak_rcndsnhadirlistsrch", "x_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
		<span class="ew-search-and"><label><?php echo $Language->phrase("AND") ?></label></span>
		<span id="el2_baak_rcndsnhadir_Tanggal" class="ew-search-field2">
<input type="text" data-table="baak_rcndsnhadir" data-field="x_Tanggal" data-format="7" name="y_Tanggal" id="y_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($baak_rcndsnhadir_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $baak_rcndsnhadir_list->Tanggal->EditValue2 ?>"<?php echo $baak_rcndsnhadir_list->Tanggal->editAttributes() ?>>
<?php if (!$baak_rcndsnhadir_list->Tanggal->ReadOnly && !$baak_rcndsnhadir_list->Tanggal->Disabled && !isset($baak_rcndsnhadir_list->Tanggal->EditAttrs["readonly"]) && !isset($baak_rcndsnhadir_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbaak_rcndsnhadirlistsrch", "datetimepicker"], function() {
	ew.createDateTimePicker("fbaak_rcndsnhadirlistsrch", "y_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
	</div>
	<?php if ($baak_rcndsnhadir_list->SearchColumnCount % $baak_rcndsnhadir_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($baak_rcndsnhadir_list->SearchColumnCount % $baak_rcndsnhadir_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $baak_rcndsnhadir_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($baak_rcndsnhadir_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($baak_rcndsnhadir_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $baak_rcndsnhadir_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($baak_rcndsnhadir_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($baak_rcndsnhadir_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($baak_rcndsnhadir_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($baak_rcndsnhadir_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $baak_rcndsnhadir_list->showPageHeader(); ?>
<?php
$baak_rcndsnhadir_list->showMessage();
?>
<?php if ($baak_rcndsnhadir_list->TotalRecords > 0 || $baak_rcndsnhadir->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($baak_rcndsnhadir_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> baak_rcndsnhadir">
<form name="fbaak_rcndsnhadirlist" id="fbaak_rcndsnhadirlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="baak_rcndsnhadir">
<div id="gmp_baak_rcndsnhadir" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($baak_rcndsnhadir_list->TotalRecords > 0 || $baak_rcndsnhadir_list->isGridEdit()) { ?>
<table id="tbl_baak_rcndsnhadirlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$baak_rcndsnhadir->RowType = ROWTYPE_HEADER;

// Render list options
$baak_rcndsnhadir_list->renderListOptions();

// Render list options (header, left)
$baak_rcndsnhadir_list->ListOptions->render("header", "left");
?>
<?php if ($baak_rcndsnhadir_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $baak_rcndsnhadir_list->Kode_Fak->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Kode_Fak" class="baak_rcndsnhadir_Kode_Fak"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $baak_rcndsnhadir_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Kode_Fak) ?>', 1);"><div id="elh_baak_rcndsnhadir_Kode_Fak" class="baak_rcndsnhadir_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $baak_rcndsnhadir_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Thn_Akademik" class="baak_rcndsnhadir_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $baak_rcndsnhadir_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Thn_Akademik) ?>', 1);"><div id="elh_baak_rcndsnhadir_Thn_Akademik" class="baak_rcndsnhadir_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Periode->Visible) { // Periode ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $baak_rcndsnhadir_list->Periode->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Periode" class="baak_rcndsnhadir_Periode"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $baak_rcndsnhadir_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Periode) ?>', 1);"><div id="elh_baak_rcndsnhadir_Periode" class="baak_rcndsnhadir_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Kelas_Akd) == "") { ?>
		<th data-name="Kelas_Akd" class="<?php echo $baak_rcndsnhadir_list->Kelas_Akd->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Kelas_Akd" class="baak_rcndsnhadir_Kelas_Akd"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Kelas_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas_Akd" class="<?php echo $baak_rcndsnhadir_list->Kelas_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Kelas_Akd) ?>', 1);"><div id="elh_baak_rcndsnhadir_Kelas_Akd" class="baak_rcndsnhadir_Kelas_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Kelas_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Kelas_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Kelas_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Nama->Visible) { // Nama ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Nama) == "") { ?>
		<th data-name="Nama" class="<?php echo $baak_rcndsnhadir_list->Nama->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Nama" class="baak_rcndsnhadir_Nama"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Nama->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama" class="<?php echo $baak_rcndsnhadir_list->Nama->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Nama) ?>', 1);"><div id="elh_baak_rcndsnhadir_Nama" class="baak_rcndsnhadir_Nama">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Nama->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Nama->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Nama->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Nama_Mk_Ind) == "") { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $baak_rcndsnhadir_list->Nama_Mk_Ind->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Nama_Mk_Ind" class="baak_rcndsnhadir_Nama_Mk_Ind"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Nama_Mk_Ind->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $baak_rcndsnhadir_list->Nama_Mk_Ind->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Nama_Mk_Ind) ?>', 1);"><div id="elh_baak_rcndsnhadir_Nama_Mk_Ind" class="baak_rcndsnhadir_Nama_Mk_Ind">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Nama_Mk_Ind->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Nama_Mk_Ind->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Nama_Mk_Ind->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->SKS->Visible) { // SKS ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->SKS) == "") { ?>
		<th data-name="SKS" class="<?php echo $baak_rcndsnhadir_list->SKS->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_SKS" class="baak_rcndsnhadir_SKS"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->SKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SKS" class="<?php echo $baak_rcndsnhadir_list->SKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->SKS) ?>', 1);"><div id="elh_baak_rcndsnhadir_SKS" class="baak_rcndsnhadir_SKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->SKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->SKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->SKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Kelas->Visible) { // Kelas ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Kelas) == "") { ?>
		<th data-name="Kelas" class="<?php echo $baak_rcndsnhadir_list->Kelas->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Kelas" class="baak_rcndsnhadir_Kelas"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Kelas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas" class="<?php echo $baak_rcndsnhadir_list->Kelas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Kelas) ?>', 1);"><div id="elh_baak_rcndsnhadir_Kelas" class="baak_rcndsnhadir_Kelas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Kelas->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Kelas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Kelas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Pertemuan_ke->Visible) { // Pertemuan_ke ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Pertemuan_ke) == "") { ?>
		<th data-name="Pertemuan_ke" class="<?php echo $baak_rcndsnhadir_list->Pertemuan_ke->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Pertemuan_ke" class="baak_rcndsnhadir_Pertemuan_ke"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Pertemuan_ke->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Pertemuan_ke" class="<?php echo $baak_rcndsnhadir_list->Pertemuan_ke->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Pertemuan_ke) ?>', 1);"><div id="elh_baak_rcndsnhadir_Pertemuan_ke" class="baak_rcndsnhadir_Pertemuan_ke">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Pertemuan_ke->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Pertemuan_ke->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Pertemuan_ke->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->Tanggal->Visible) { // Tanggal ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Tanggal) == "") { ?>
		<th data-name="Tanggal" class="<?php echo $baak_rcndsnhadir_list->Tanggal->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_Tanggal" class="baak_rcndsnhadir_Tanggal"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Tanggal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tanggal" class="<?php echo $baak_rcndsnhadir_list->Tanggal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->Tanggal) ?>', 1);"><div id="elh_baak_rcndsnhadir_Tanggal" class="baak_rcndsnhadir_Tanggal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->Tanggal->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->Tanggal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->Tanggal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->JM->Visible) { // JM ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->JM) == "") { ?>
		<th data-name="JM" class="<?php echo $baak_rcndsnhadir_list->JM->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_JM" class="baak_rcndsnhadir_JM"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->JM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JM" class="<?php echo $baak_rcndsnhadir_list->JM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->JM) ?>', 1);"><div id="elh_baak_rcndsnhadir_JM" class="baak_rcndsnhadir_JM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->JM->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->JM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->JM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->JS->Visible) { // JS ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->JS) == "") { ?>
		<th data-name="JS" class="<?php echo $baak_rcndsnhadir_list->JS->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_JS" class="baak_rcndsnhadir_JS"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->JS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JS" class="<?php echo $baak_rcndsnhadir_list->JS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->JS) ?>', 1);"><div id="elh_baak_rcndsnhadir_JS" class="baak_rcndsnhadir_JS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->JS->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->JS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->JS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($baak_rcndsnhadir_list->JMLJAM->Visible) { // JMLJAM ?>
	<?php if ($baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->JMLJAM) == "") { ?>
		<th data-name="JMLJAM" class="<?php echo $baak_rcndsnhadir_list->JMLJAM->headerCellClass() ?>"><div id="elh_baak_rcndsnhadir_JMLJAM" class="baak_rcndsnhadir_JMLJAM"><div class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->JMLJAM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JMLJAM" class="<?php echo $baak_rcndsnhadir_list->JMLJAM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $baak_rcndsnhadir_list->SortUrl($baak_rcndsnhadir_list->JMLJAM) ?>', 1);"><div id="elh_baak_rcndsnhadir_JMLJAM" class="baak_rcndsnhadir_JMLJAM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $baak_rcndsnhadir_list->JMLJAM->caption() ?></span><span class="ew-table-header-sort"><?php if ($baak_rcndsnhadir_list->JMLJAM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($baak_rcndsnhadir_list->JMLJAM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$baak_rcndsnhadir_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($baak_rcndsnhadir_list->ExportAll && $baak_rcndsnhadir_list->isExport()) {
	$baak_rcndsnhadir_list->StopRecord = $baak_rcndsnhadir_list->TotalRecords;
} else {

	// Set the last record to display
	if ($baak_rcndsnhadir_list->TotalRecords > $baak_rcndsnhadir_list->StartRecord + $baak_rcndsnhadir_list->DisplayRecords - 1)
		$baak_rcndsnhadir_list->StopRecord = $baak_rcndsnhadir_list->StartRecord + $baak_rcndsnhadir_list->DisplayRecords - 1;
	else
		$baak_rcndsnhadir_list->StopRecord = $baak_rcndsnhadir_list->TotalRecords;
}
$baak_rcndsnhadir_list->RecordCount = $baak_rcndsnhadir_list->StartRecord - 1;
if ($baak_rcndsnhadir_list->Recordset && !$baak_rcndsnhadir_list->Recordset->EOF) {
	$baak_rcndsnhadir_list->Recordset->moveFirst();
	$selectLimit = $baak_rcndsnhadir_list->UseSelectLimit;
	if (!$selectLimit && $baak_rcndsnhadir_list->StartRecord > 1)
		$baak_rcndsnhadir_list->Recordset->move($baak_rcndsnhadir_list->StartRecord - 1);
} elseif (!$baak_rcndsnhadir->AllowAddDeleteRow && $baak_rcndsnhadir_list->StopRecord == 0) {
	$baak_rcndsnhadir_list->StopRecord = $baak_rcndsnhadir->GridAddRowCount;
}

// Initialize aggregate
$baak_rcndsnhadir->RowType = ROWTYPE_AGGREGATEINIT;
$baak_rcndsnhadir->resetAttributes();
$baak_rcndsnhadir_list->renderRow();
while ($baak_rcndsnhadir_list->RecordCount < $baak_rcndsnhadir_list->StopRecord) {
	$baak_rcndsnhadir_list->RecordCount++;
	if ($baak_rcndsnhadir_list->RecordCount >= $baak_rcndsnhadir_list->StartRecord) {
		$baak_rcndsnhadir_list->RowCount++;

		// Set up key count
		$baak_rcndsnhadir_list->KeyCount = $baak_rcndsnhadir_list->RowIndex;

		// Init row class and style
		$baak_rcndsnhadir->resetAttributes();
		$baak_rcndsnhadir->CssClass = "";
		if ($baak_rcndsnhadir_list->isGridAdd()) {
		} else {
			$baak_rcndsnhadir_list->loadRowValues($baak_rcndsnhadir_list->Recordset); // Load row values
		}
		$baak_rcndsnhadir->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$baak_rcndsnhadir->RowAttrs->merge(["data-rowindex" => $baak_rcndsnhadir_list->RowCount, "id" => "r" . $baak_rcndsnhadir_list->RowCount . "_baak_rcndsnhadir", "data-rowtype" => $baak_rcndsnhadir->RowType]);

		// Render row
		$baak_rcndsnhadir_list->renderRow();

		// Render list options
		$baak_rcndsnhadir_list->renderListOptions();
?>
	<tr <?php echo $baak_rcndsnhadir->rowAttributes() ?>>
<?php

// Render list options (body, left)
$baak_rcndsnhadir_list->ListOptions->render("body", "left", $baak_rcndsnhadir_list->RowCount);
?>
	<?php if ($baak_rcndsnhadir_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $baak_rcndsnhadir_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Kode_Fak">
<span<?php echo $baak_rcndsnhadir_list->Kode_Fak->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $baak_rcndsnhadir_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Thn_Akademik">
<span<?php echo $baak_rcndsnhadir_list->Thn_Akademik->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $baak_rcndsnhadir_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Periode">
<span<?php echo $baak_rcndsnhadir_list->Periode->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
		<td data-name="Kelas_Akd" <?php echo $baak_rcndsnhadir_list->Kelas_Akd->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Kelas_Akd">
<span<?php echo $baak_rcndsnhadir_list->Kelas_Akd->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Kelas_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->Nama->Visible) { // Nama ?>
		<td data-name="Nama" <?php echo $baak_rcndsnhadir_list->Nama->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Nama">
<span<?php echo $baak_rcndsnhadir_list->Nama->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Nama->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
		<td data-name="Nama_Mk_Ind" <?php echo $baak_rcndsnhadir_list->Nama_Mk_Ind->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Nama_Mk_Ind">
<span<?php echo $baak_rcndsnhadir_list->Nama_Mk_Ind->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Nama_Mk_Ind->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS" <?php echo $baak_rcndsnhadir_list->SKS->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_SKS">
<span<?php echo $baak_rcndsnhadir_list->SKS->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->SKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->Kelas->Visible) { // Kelas ?>
		<td data-name="Kelas" <?php echo $baak_rcndsnhadir_list->Kelas->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Kelas">
<span<?php echo $baak_rcndsnhadir_list->Kelas->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Kelas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->Pertemuan_ke->Visible) { // Pertemuan_ke ?>
		<td data-name="Pertemuan_ke" <?php echo $baak_rcndsnhadir_list->Pertemuan_ke->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Pertemuan_ke">
<span<?php echo $baak_rcndsnhadir_list->Pertemuan_ke->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Pertemuan_ke->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal" <?php echo $baak_rcndsnhadir_list->Tanggal->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_Tanggal">
<span<?php echo $baak_rcndsnhadir_list->Tanggal->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->Tanggal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->JM->Visible) { // JM ?>
		<td data-name="JM" <?php echo $baak_rcndsnhadir_list->JM->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_JM">
<span<?php echo $baak_rcndsnhadir_list->JM->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->JM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->JS->Visible) { // JS ?>
		<td data-name="JS" <?php echo $baak_rcndsnhadir_list->JS->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_JS">
<span<?php echo $baak_rcndsnhadir_list->JS->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->JS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($baak_rcndsnhadir_list->JMLJAM->Visible) { // JMLJAM ?>
		<td data-name="JMLJAM" <?php echo $baak_rcndsnhadir_list->JMLJAM->cellAttributes() ?>>
<span id="el<?php echo $baak_rcndsnhadir_list->RowCount ?>_baak_rcndsnhadir_JMLJAM">
<span<?php echo $baak_rcndsnhadir_list->JMLJAM->viewAttributes() ?>><?php echo $baak_rcndsnhadir_list->JMLJAM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$baak_rcndsnhadir_list->ListOptions->render("body", "right", $baak_rcndsnhadir_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$baak_rcndsnhadir_list->isGridAdd())
		$baak_rcndsnhadir_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$baak_rcndsnhadir->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($baak_rcndsnhadir_list->Recordset)
	$baak_rcndsnhadir_list->Recordset->Close();
?>
<?php if (!$baak_rcndsnhadir_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$baak_rcndsnhadir_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $baak_rcndsnhadir_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $baak_rcndsnhadir_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($baak_rcndsnhadir_list->TotalRecords == 0 && !$baak_rcndsnhadir->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $baak_rcndsnhadir_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$baak_rcndsnhadir_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$baak_rcndsnhadir_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$baak_rcndsnhadir_list->terminate();
?>