<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class AWali_edit extends AWali
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'AWali';

	// Page object name
	public $PageObjName = "AWali_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (AWali)
		if (!isset($GLOBALS["AWali"]) || get_class($GLOBALS["AWali"]) == PROJECT_NAMESPACE . "AWali") {
			$GLOBALS["AWali"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["AWali"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'AWali');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $AWali;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($AWali);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "AWaliview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Kode_Fak'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canEdit()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("AWalilist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Th_Ak->setVisibility();
		$this->Periode->setVisibility();
		$this->Kode_Fak->setVisibility();
		$this->Kelas->setVisibility();
		$this->Semester->setVisibility();
		$this->Awal_Perwalian->setVisibility();
		$this->Akhir_Perwalian->setVisibility();
		$this->Awal_Perubahan->setVisibility();
		$this->Akhir_Perubahan->setVisibility();
		$this->KunciPwl->setVisibility();
		$this->kunciujian->setVisibility();
		$this->Kuncijadwal->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Th_Ak);
		$this->setupLookupOptions($this->Kode_Fak);
		$this->setupLookupOptions($this->Kelas);

		// Check permission
		if (!$Security->canEdit()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("AWalilist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {

			// Load key values
			$loaded = TRUE;
			if (Get("Kode_Fak") !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Get("Kode_Fak"));
				$this->Kode_Fak->setOldValue($this->Kode_Fak->QueryStringValue);
			} elseif (Key(0) !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Key(0));
				$this->Kode_Fak->setOldValue($this->Kode_Fak->QueryStringValue);
			} elseif (Post("Kode_Fak") !== NULL) {
				$this->Kode_Fak->setFormValue(Post("Kode_Fak"));
				$this->Kode_Fak->setOldValue($this->Kode_Fak->FormValue);
			} elseif (Route(2) !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Route(2));
				$this->Kode_Fak->setOldValue($this->Kode_Fak->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}
			if (Get("Kelas") !== NULL) {
				$this->Kelas->setQueryStringValue(Get("Kelas"));
				$this->Kelas->setOldValue($this->Kelas->QueryStringValue);
			} elseif (Key(1) !== NULL) {
				$this->Kelas->setQueryStringValue(Key(1));
				$this->Kelas->setOldValue($this->Kelas->QueryStringValue);
			} elseif (Post("Kelas") !== NULL) {
				$this->Kelas->setFormValue(Post("Kelas"));
				$this->Kelas->setOldValue($this->Kelas->FormValue);
			} elseif (Route(3) !== NULL) {
				$this->Kelas->setQueryStringValue(Route(3));
				$this->Kelas->setOldValue($this->Kelas->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}

			// Load record
			if ($loaded)
				$loaded = $this->loadRow();
			if (!$loaded) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
				$this->terminate();
				return;
			}
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} else {
			if (Post("action") !== NULL) {
				$this->CurrentAction = Post("action"); // Get action code
				if (!$this->isShow()) // Not reload record, handle as postback
					$postBack = TRUE;

				// Load key from Form
				if ($CurrentForm->hasValue("x_Kode_Fak")) {
					$this->Kode_Fak->setFormValue($CurrentForm->getValue("x_Kode_Fak"));
				}
				if ($CurrentForm->hasValue("x_Kelas")) {
					$this->Kelas->setFormValue($CurrentForm->getValue("x_Kelas"));
				}
			} else {
				$this->CurrentAction = "show"; // Default action is display

				// Load key from QueryString / Route
				$loadByQuery = FALSE;
				if (Get("Kode_Fak") !== NULL) {
					$this->Kode_Fak->setQueryStringValue(Get("Kode_Fak"));
					$loadByQuery = TRUE;
				} elseif (Route(2) !== NULL) {
					$this->Kode_Fak->setQueryStringValue(Route(2));
					$loadByQuery = TRUE;
				} else {
					$this->Kode_Fak->CurrentValue = NULL;
				}
				if (Get("Kelas") !== NULL) {
					$this->Kelas->setQueryStringValue(Get("Kelas"));
					$loadByQuery = TRUE;
				} elseif (Route(3) !== NULL) {
					$this->Kelas->setQueryStringValue(Route(3));
					$loadByQuery = TRUE;
				} else {
					$this->Kelas->CurrentValue = NULL;
				}
			}

			// Load current record
			$loaded = $this->loadRow();
		}

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("AWalilist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "AWalilist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Th_Ak' first before field var 'x_Th_Ak'
		$val = $CurrentForm->hasValue("Th_Ak") ? $CurrentForm->getValue("Th_Ak") : $CurrentForm->getValue("x_Th_Ak");
		if (!$this->Th_Ak->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Th_Ak->Visible = FALSE; // Disable update for API request
			else
				$this->Th_Ak->setFormValue($val);
		}

		// Check field name 'Periode' first before field var 'x_Periode'
		$val = $CurrentForm->hasValue("Periode") ? $CurrentForm->getValue("Periode") : $CurrentForm->getValue("x_Periode");
		if (!$this->Periode->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Periode->Visible = FALSE; // Disable update for API request
			else
				$this->Periode->setFormValue($val);
		}

		// Check field name 'Kode_Fak' first before field var 'x_Kode_Fak'
		$val = $CurrentForm->hasValue("Kode_Fak") ? $CurrentForm->getValue("Kode_Fak") : $CurrentForm->getValue("x_Kode_Fak");
		if (!$this->Kode_Fak->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_Fak->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_Fak->setFormValue($val);
		}
		if ($CurrentForm->hasValue("o_Kode_Fak"))
			$this->Kode_Fak->setOldValue($CurrentForm->getValue("o_Kode_Fak"));

		// Check field name 'Kelas' first before field var 'x_Kelas'
		$val = $CurrentForm->hasValue("Kelas") ? $CurrentForm->getValue("Kelas") : $CurrentForm->getValue("x_Kelas");
		if (!$this->Kelas->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kelas->Visible = FALSE; // Disable update for API request
			else
				$this->Kelas->setFormValue($val);
		}
		if ($CurrentForm->hasValue("o_Kelas"))
			$this->Kelas->setOldValue($CurrentForm->getValue("o_Kelas"));

		// Check field name 'Semester' first before field var 'x_Semester'
		$val = $CurrentForm->hasValue("Semester") ? $CurrentForm->getValue("Semester") : $CurrentForm->getValue("x_Semester");
		if (!$this->Semester->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Semester->Visible = FALSE; // Disable update for API request
			else
				$this->Semester->setFormValue($val);
		}

		// Check field name 'Awal_Perwalian' first before field var 'x_Awal_Perwalian'
		$val = $CurrentForm->hasValue("Awal_Perwalian") ? $CurrentForm->getValue("Awal_Perwalian") : $CurrentForm->getValue("x_Awal_Perwalian");
		if (!$this->Awal_Perwalian->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Awal_Perwalian->Visible = FALSE; // Disable update for API request
			else
				$this->Awal_Perwalian->setFormValue($val);
			$this->Awal_Perwalian->CurrentValue = UnFormatDateTime($this->Awal_Perwalian->CurrentValue, 7);
		}

		// Check field name 'Akhir_Perwalian' first before field var 'x_Akhir_Perwalian'
		$val = $CurrentForm->hasValue("Akhir_Perwalian") ? $CurrentForm->getValue("Akhir_Perwalian") : $CurrentForm->getValue("x_Akhir_Perwalian");
		if (!$this->Akhir_Perwalian->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Akhir_Perwalian->Visible = FALSE; // Disable update for API request
			else
				$this->Akhir_Perwalian->setFormValue($val);
			$this->Akhir_Perwalian->CurrentValue = UnFormatDateTime($this->Akhir_Perwalian->CurrentValue, 7);
		}

		// Check field name 'Awal_Perubahan' first before field var 'x_Awal_Perubahan'
		$val = $CurrentForm->hasValue("Awal_Perubahan") ? $CurrentForm->getValue("Awal_Perubahan") : $CurrentForm->getValue("x_Awal_Perubahan");
		if (!$this->Awal_Perubahan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Awal_Perubahan->Visible = FALSE; // Disable update for API request
			else
				$this->Awal_Perubahan->setFormValue($val);
			$this->Awal_Perubahan->CurrentValue = UnFormatDateTime($this->Awal_Perubahan->CurrentValue, 7);
		}

		// Check field name 'Akhir_Perubahan' first before field var 'x_Akhir_Perubahan'
		$val = $CurrentForm->hasValue("Akhir_Perubahan") ? $CurrentForm->getValue("Akhir_Perubahan") : $CurrentForm->getValue("x_Akhir_Perubahan");
		if (!$this->Akhir_Perubahan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Akhir_Perubahan->Visible = FALSE; // Disable update for API request
			else
				$this->Akhir_Perubahan->setFormValue($val);
			$this->Akhir_Perubahan->CurrentValue = UnFormatDateTime($this->Akhir_Perubahan->CurrentValue, 7);
		}

		// Check field name 'KunciPwl' first before field var 'x_KunciPwl'
		$val = $CurrentForm->hasValue("KunciPwl") ? $CurrentForm->getValue("KunciPwl") : $CurrentForm->getValue("x_KunciPwl");
		if (!$this->KunciPwl->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->KunciPwl->Visible = FALSE; // Disable update for API request
			else
				$this->KunciPwl->setFormValue($val);
		}

		// Check field name 'kunciujian' first before field var 'x_kunciujian'
		$val = $CurrentForm->hasValue("kunciujian") ? $CurrentForm->getValue("kunciujian") : $CurrentForm->getValue("x_kunciujian");
		if (!$this->kunciujian->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->kunciujian->Visible = FALSE; // Disable update for API request
			else
				$this->kunciujian->setFormValue($val);
		}

		// Check field name 'Kuncijadwal' first before field var 'x_Kuncijadwal'
		$val = $CurrentForm->hasValue("Kuncijadwal") ? $CurrentForm->getValue("Kuncijadwal") : $CurrentForm->getValue("x_Kuncijadwal");
		if (!$this->Kuncijadwal->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kuncijadwal->Visible = FALSE; // Disable update for API request
			else
				$this->Kuncijadwal->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Th_Ak->CurrentValue = $this->Th_Ak->FormValue;
		$this->Periode->CurrentValue = $this->Periode->FormValue;
		$this->Kode_Fak->CurrentValue = $this->Kode_Fak->FormValue;
		$this->Kelas->CurrentValue = $this->Kelas->FormValue;
		$this->Semester->CurrentValue = $this->Semester->FormValue;
		$this->Awal_Perwalian->CurrentValue = $this->Awal_Perwalian->FormValue;
		$this->Awal_Perwalian->CurrentValue = UnFormatDateTime($this->Awal_Perwalian->CurrentValue, 7);
		$this->Akhir_Perwalian->CurrentValue = $this->Akhir_Perwalian->FormValue;
		$this->Akhir_Perwalian->CurrentValue = UnFormatDateTime($this->Akhir_Perwalian->CurrentValue, 7);
		$this->Awal_Perubahan->CurrentValue = $this->Awal_Perubahan->FormValue;
		$this->Awal_Perubahan->CurrentValue = UnFormatDateTime($this->Awal_Perubahan->CurrentValue, 7);
		$this->Akhir_Perubahan->CurrentValue = $this->Akhir_Perubahan->FormValue;
		$this->Akhir_Perubahan->CurrentValue = UnFormatDateTime($this->Akhir_Perubahan->CurrentValue, 7);
		$this->KunciPwl->CurrentValue = $this->KunciPwl->FormValue;
		$this->kunciujian->CurrentValue = $this->kunciujian->FormValue;
		$this->Kuncijadwal->CurrentValue = $this->Kuncijadwal->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Th_Ak->setDbValue($row['Th_Ak']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Kelas->setDbValue($row['Kelas']);
		$this->Semester->setDbValue($row['Semester']);
		$this->Awal_Perwalian->setDbValue($row['Awal_Perwalian']);
		$this->Akhir_Perwalian->setDbValue($row['Akhir_Perwalian']);
		$this->Awal_Perubahan->setDbValue($row['Awal_Perubahan']);
		$this->Akhir_Perubahan->setDbValue($row['Akhir_Perubahan']);
		$this->KunciPwl->setDbValue($row['KunciPwl']);
		$this->kunciujian->setDbValue($row['kunciujian']);
		$this->Kuncijadwal->setDbValue($row['Kuncijadwal']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Th_Ak'] = NULL;
		$row['Periode'] = NULL;
		$row['Kode_Fak'] = NULL;
		$row['Kelas'] = NULL;
		$row['Semester'] = NULL;
		$row['Awal_Perwalian'] = NULL;
		$row['Akhir_Perwalian'] = NULL;
		$row['Awal_Perubahan'] = NULL;
		$row['Akhir_Perubahan'] = NULL;
		$row['KunciPwl'] = NULL;
		$row['kunciujian'] = NULL;
		$row['Kuncijadwal'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Kode_Fak")) != "")
			$this->Kode_Fak->OldValue = $this->getKey("Kode_Fak"); // Kode_Fak
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kelas")) != "")
			$this->Kelas->OldValue = $this->getKey("Kelas"); // Kelas
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Th_Ak
		// Periode
		// Kode_Fak
		// Kelas
		// Semester
		// Awal_Perwalian
		// Akhir_Perwalian
		// Awal_Perubahan
		// Akhir_Perubahan
		// KunciPwl
		// kunciujian
		// Kuncijadwal

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Th_Ak
			$curVal = strval($this->Th_Ak->CurrentValue);
			if ($curVal != "") {
				$this->Th_Ak->ViewValue = $this->Th_Ak->lookupCacheOption($curVal);
				if ($this->Th_Ak->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Th_Ak->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Th_Ak->ViewValue = $this->Th_Ak->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Th_Ak->ViewValue = $this->Th_Ak->CurrentValue;
					}
				}
			} else {
				$this->Th_Ak->ViewValue = NULL;
			}
			$this->Th_Ak->ViewCustomAttributes = "";

			// Periode
			if (strval($this->Periode->CurrentValue) != "") {
				$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
			} else {
				$this->Periode->ViewValue = NULL;
			}
			$this->Periode->ViewCustomAttributes = "";

			// Kode_Fak
			$curVal = strval($this->Kode_Fak->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
				if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
					}
				}
			} else {
				$this->Kode_Fak->ViewValue = NULL;
			}
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kelas
			$curVal = strval($this->Kelas->CurrentValue);
			if ($curVal != "") {
				$this->Kelas->ViewValue = $this->Kelas->lookupCacheOption($curVal);
				if ($this->Kelas->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kelas->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Kelas->ViewValue = $this->Kelas->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kelas->ViewValue = $this->Kelas->CurrentValue;
					}
				}
			} else {
				$this->Kelas->ViewValue = NULL;
			}
			$this->Kelas->ViewCustomAttributes = "";

			// Semester
			if (strval($this->Semester->CurrentValue) != "") {
				$this->Semester->ViewValue = $this->Semester->optionCaption($this->Semester->CurrentValue);
			} else {
				$this->Semester->ViewValue = NULL;
			}
			$this->Semester->ViewCustomAttributes = "";

			// Awal_Perwalian
			$this->Awal_Perwalian->ViewValue = $this->Awal_Perwalian->CurrentValue;
			$this->Awal_Perwalian->ViewValue = FormatDateTime($this->Awal_Perwalian->ViewValue, 7);
			$this->Awal_Perwalian->ViewCustomAttributes = "";

			// Akhir_Perwalian
			$this->Akhir_Perwalian->ViewValue = $this->Akhir_Perwalian->CurrentValue;
			$this->Akhir_Perwalian->ViewValue = FormatDateTime($this->Akhir_Perwalian->ViewValue, 7);
			$this->Akhir_Perwalian->ViewCustomAttributes = "";

			// Awal_Perubahan
			$this->Awal_Perubahan->ViewValue = $this->Awal_Perubahan->CurrentValue;
			$this->Awal_Perubahan->ViewValue = FormatDateTime($this->Awal_Perubahan->ViewValue, 7);
			$this->Awal_Perubahan->ViewCustomAttributes = "";

			// Akhir_Perubahan
			$this->Akhir_Perubahan->ViewValue = $this->Akhir_Perubahan->CurrentValue;
			$this->Akhir_Perubahan->ViewValue = FormatDateTime($this->Akhir_Perubahan->ViewValue, 7);
			$this->Akhir_Perubahan->ViewCustomAttributes = "";

			// KunciPwl
			$this->KunciPwl->ViewValue = $this->KunciPwl->CurrentValue;
			$this->KunciPwl->ViewCustomAttributes = "";

			// kunciujian
			$this->kunciujian->ViewValue = $this->kunciujian->CurrentValue;
			$this->kunciujian->ViewCustomAttributes = "";

			// Kuncijadwal
			$this->Kuncijadwal->ViewValue = $this->Kuncijadwal->CurrentValue;
			$this->Kuncijadwal->ViewCustomAttributes = "";

			// Th_Ak
			$this->Th_Ak->LinkCustomAttributes = "";
			$this->Th_Ak->HrefValue = "";
			$this->Th_Ak->TooltipValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";
			$this->Periode->TooltipValue = "";

			// Kode_Fak
			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";
			$this->Kode_Fak->TooltipValue = "";

			// Kelas
			$this->Kelas->LinkCustomAttributes = "";
			$this->Kelas->HrefValue = "";
			$this->Kelas->TooltipValue = "";

			// Semester
			$this->Semester->LinkCustomAttributes = "";
			$this->Semester->HrefValue = "";
			$this->Semester->TooltipValue = "";

			// Awal_Perwalian
			$this->Awal_Perwalian->LinkCustomAttributes = "";
			$this->Awal_Perwalian->HrefValue = "";
			$this->Awal_Perwalian->TooltipValue = "";

			// Akhir_Perwalian
			$this->Akhir_Perwalian->LinkCustomAttributes = "";
			$this->Akhir_Perwalian->HrefValue = "";
			$this->Akhir_Perwalian->TooltipValue = "";

			// Awal_Perubahan
			$this->Awal_Perubahan->LinkCustomAttributes = "";
			$this->Awal_Perubahan->HrefValue = "";
			$this->Awal_Perubahan->TooltipValue = "";

			// Akhir_Perubahan
			$this->Akhir_Perubahan->LinkCustomAttributes = "";
			$this->Akhir_Perubahan->HrefValue = "";
			$this->Akhir_Perubahan->TooltipValue = "";

			// KunciPwl
			$this->KunciPwl->LinkCustomAttributes = "";
			$this->KunciPwl->HrefValue = "";
			$this->KunciPwl->TooltipValue = "";

			// kunciujian
			$this->kunciujian->LinkCustomAttributes = "";
			$this->kunciujian->HrefValue = "";
			$this->kunciujian->TooltipValue = "";

			// Kuncijadwal
			$this->Kuncijadwal->LinkCustomAttributes = "";
			$this->Kuncijadwal->HrefValue = "";
			$this->Kuncijadwal->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// Th_Ak
			$this->Th_Ak->EditAttrs["class"] = "form-control";
			$this->Th_Ak->EditCustomAttributes = "";
			$curVal = trim(strval($this->Th_Ak->CurrentValue));
			if ($curVal != "")
				$this->Th_Ak->ViewValue = $this->Th_Ak->lookupCacheOption($curVal);
			else
				$this->Th_Ak->ViewValue = $this->Th_Ak->Lookup !== NULL && is_array($this->Th_Ak->Lookup->Options) ? $curVal : NULL;
			if ($this->Th_Ak->ViewValue !== NULL) { // Load from cache
				$this->Th_Ak->EditValue = array_values($this->Th_Ak->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[TA]" . SearchString("=", $this->Th_Ak->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Th_Ak->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Th_Ak->EditValue = $arwrk;
			}

			// Periode
			$this->Periode->EditAttrs["class"] = "form-control";
			$this->Periode->EditCustomAttributes = "";
			$this->Periode->EditValue = $this->Periode->options(TRUE);

			// Kode_Fak
			$this->Kode_Fak->EditAttrs["class"] = "form-control";
			$this->Kode_Fak->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Fak->CurrentValue));
			if ($curVal != "")
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			else
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->Lookup !== NULL && is_array($this->Kode_Fak->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Fak->ViewValue !== NULL) { // Load from cache
				$this->Kode_Fak->EditValue = array_values($this->Kode_Fak->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Fak]" . SearchString("=", $this->Kode_Fak->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Fak->EditValue = $arwrk;
			}

			// Kelas
			$this->Kelas->EditAttrs["class"] = "form-control";
			$this->Kelas->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kelas->CurrentValue));
			if ($curVal != "")
				$this->Kelas->ViewValue = $this->Kelas->lookupCacheOption($curVal);
			else
				$this->Kelas->ViewValue = $this->Kelas->Lookup !== NULL && is_array($this->Kelas->Lookup->Options) ? $curVal : NULL;
			if ($this->Kelas->ViewValue !== NULL) { // Load from cache
				$this->Kelas->EditValue = array_values($this->Kelas->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kelas]" . SearchString("=", $this->Kelas->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kelas->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kelas->EditValue = $arwrk;
			}

			// Semester
			$this->Semester->EditAttrs["class"] = "form-control";
			$this->Semester->EditCustomAttributes = "";
			$this->Semester->EditValue = $this->Semester->options(TRUE);

			// Awal_Perwalian
			$this->Awal_Perwalian->EditAttrs["class"] = "form-control";
			$this->Awal_Perwalian->EditCustomAttributes = "";
			$this->Awal_Perwalian->EditValue = HtmlEncode(FormatDateTime($this->Awal_Perwalian->CurrentValue, 7));
			$this->Awal_Perwalian->PlaceHolder = RemoveHtml($this->Awal_Perwalian->caption());

			// Akhir_Perwalian
			$this->Akhir_Perwalian->EditAttrs["class"] = "form-control";
			$this->Akhir_Perwalian->EditCustomAttributes = "";
			$this->Akhir_Perwalian->EditValue = HtmlEncode(FormatDateTime($this->Akhir_Perwalian->CurrentValue, 7));
			$this->Akhir_Perwalian->PlaceHolder = RemoveHtml($this->Akhir_Perwalian->caption());

			// Awal_Perubahan
			$this->Awal_Perubahan->EditAttrs["class"] = "form-control";
			$this->Awal_Perubahan->EditCustomAttributes = "";
			$this->Awal_Perubahan->EditValue = HtmlEncode(FormatDateTime($this->Awal_Perubahan->CurrentValue, 7));
			$this->Awal_Perubahan->PlaceHolder = RemoveHtml($this->Awal_Perubahan->caption());

			// Akhir_Perubahan
			$this->Akhir_Perubahan->EditAttrs["class"] = "form-control";
			$this->Akhir_Perubahan->EditCustomAttributes = "";
			$this->Akhir_Perubahan->EditValue = HtmlEncode(FormatDateTime($this->Akhir_Perubahan->CurrentValue, 7));
			$this->Akhir_Perubahan->PlaceHolder = RemoveHtml($this->Akhir_Perubahan->caption());

			// KunciPwl
			$this->KunciPwl->EditAttrs["class"] = "form-control";
			$this->KunciPwl->EditCustomAttributes = "";
			if (!$this->KunciPwl->Raw)
				$this->KunciPwl->CurrentValue = HtmlDecode($this->KunciPwl->CurrentValue);
			$this->KunciPwl->EditValue = HtmlEncode($this->KunciPwl->CurrentValue);
			$this->KunciPwl->PlaceHolder = RemoveHtml($this->KunciPwl->caption());

			// kunciujian
			$this->kunciujian->EditAttrs["class"] = "form-control";
			$this->kunciujian->EditCustomAttributes = "";
			if (!$this->kunciujian->Raw)
				$this->kunciujian->CurrentValue = HtmlDecode($this->kunciujian->CurrentValue);
			$this->kunciujian->EditValue = HtmlEncode($this->kunciujian->CurrentValue);
			$this->kunciujian->PlaceHolder = RemoveHtml($this->kunciujian->caption());

			// Kuncijadwal
			$this->Kuncijadwal->EditAttrs["class"] = "form-control";
			$this->Kuncijadwal->EditCustomAttributes = "";
			if (!$this->Kuncijadwal->Raw)
				$this->Kuncijadwal->CurrentValue = HtmlDecode($this->Kuncijadwal->CurrentValue);
			$this->Kuncijadwal->EditValue = HtmlEncode($this->Kuncijadwal->CurrentValue);
			$this->Kuncijadwal->PlaceHolder = RemoveHtml($this->Kuncijadwal->caption());

			// Edit refer script
			// Th_Ak

			$this->Th_Ak->LinkCustomAttributes = "";
			$this->Th_Ak->HrefValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";

			// Kode_Fak
			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";

			// Kelas
			$this->Kelas->LinkCustomAttributes = "";
			$this->Kelas->HrefValue = "";

			// Semester
			$this->Semester->LinkCustomAttributes = "";
			$this->Semester->HrefValue = "";

			// Awal_Perwalian
			$this->Awal_Perwalian->LinkCustomAttributes = "";
			$this->Awal_Perwalian->HrefValue = "";

			// Akhir_Perwalian
			$this->Akhir_Perwalian->LinkCustomAttributes = "";
			$this->Akhir_Perwalian->HrefValue = "";

			// Awal_Perubahan
			$this->Awal_Perubahan->LinkCustomAttributes = "";
			$this->Awal_Perubahan->HrefValue = "";

			// Akhir_Perubahan
			$this->Akhir_Perubahan->LinkCustomAttributes = "";
			$this->Akhir_Perubahan->HrefValue = "";

			// KunciPwl
			$this->KunciPwl->LinkCustomAttributes = "";
			$this->KunciPwl->HrefValue = "";

			// kunciujian
			$this->kunciujian->LinkCustomAttributes = "";
			$this->kunciujian->HrefValue = "";

			// Kuncijadwal
			$this->Kuncijadwal->LinkCustomAttributes = "";
			$this->Kuncijadwal->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Th_Ak->Required) {
			if (!$this->Th_Ak->IsDetailKey && $this->Th_Ak->FormValue != NULL && $this->Th_Ak->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Th_Ak->caption(), $this->Th_Ak->RequiredErrorMessage));
			}
		}
		if ($this->Periode->Required) {
			if (!$this->Periode->IsDetailKey && $this->Periode->FormValue != NULL && $this->Periode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Periode->caption(), $this->Periode->RequiredErrorMessage));
			}
		}
		if ($this->Kode_Fak->Required) {
			if (!$this->Kode_Fak->IsDetailKey && $this->Kode_Fak->FormValue != NULL && $this->Kode_Fak->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_Fak->caption(), $this->Kode_Fak->RequiredErrorMessage));
			}
		}
		if ($this->Kelas->Required) {
			if (!$this->Kelas->IsDetailKey && $this->Kelas->FormValue != NULL && $this->Kelas->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kelas->caption(), $this->Kelas->RequiredErrorMessage));
			}
		}
		if ($this->Semester->Required) {
			if (!$this->Semester->IsDetailKey && $this->Semester->FormValue != NULL && $this->Semester->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Semester->caption(), $this->Semester->RequiredErrorMessage));
			}
		}
		if ($this->Awal_Perwalian->Required) {
			if (!$this->Awal_Perwalian->IsDetailKey && $this->Awal_Perwalian->FormValue != NULL && $this->Awal_Perwalian->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Awal_Perwalian->caption(), $this->Awal_Perwalian->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->Awal_Perwalian->FormValue)) {
			AddMessage($FormError, $this->Awal_Perwalian->errorMessage());
		}
		if ($this->Akhir_Perwalian->Required) {
			if (!$this->Akhir_Perwalian->IsDetailKey && $this->Akhir_Perwalian->FormValue != NULL && $this->Akhir_Perwalian->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Akhir_Perwalian->caption(), $this->Akhir_Perwalian->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->Akhir_Perwalian->FormValue)) {
			AddMessage($FormError, $this->Akhir_Perwalian->errorMessage());
		}
		if ($this->Awal_Perubahan->Required) {
			if (!$this->Awal_Perubahan->IsDetailKey && $this->Awal_Perubahan->FormValue != NULL && $this->Awal_Perubahan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Awal_Perubahan->caption(), $this->Awal_Perubahan->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->Awal_Perubahan->FormValue)) {
			AddMessage($FormError, $this->Awal_Perubahan->errorMessage());
		}
		if ($this->Akhir_Perubahan->Required) {
			if (!$this->Akhir_Perubahan->IsDetailKey && $this->Akhir_Perubahan->FormValue != NULL && $this->Akhir_Perubahan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Akhir_Perubahan->caption(), $this->Akhir_Perubahan->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->Akhir_Perubahan->FormValue)) {
			AddMessage($FormError, $this->Akhir_Perubahan->errorMessage());
		}
		if ($this->KunciPwl->Required) {
			if (!$this->KunciPwl->IsDetailKey && $this->KunciPwl->FormValue != NULL && $this->KunciPwl->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->KunciPwl->caption(), $this->KunciPwl->RequiredErrorMessage));
			}
		}
		if ($this->kunciujian->Required) {
			if (!$this->kunciujian->IsDetailKey && $this->kunciujian->FormValue != NULL && $this->kunciujian->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->kunciujian->caption(), $this->kunciujian->RequiredErrorMessage));
			}
		}
		if ($this->Kuncijadwal->Required) {
			if (!$this->Kuncijadwal->IsDetailKey && $this->Kuncijadwal->FormValue != NULL && $this->Kuncijadwal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kuncijadwal->caption(), $this->Kuncijadwal->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// Th_Ak
			$this->Th_Ak->setDbValueDef($rsnew, $this->Th_Ak->CurrentValue, NULL, $this->Th_Ak->ReadOnly);

			// Periode
			$this->Periode->setDbValueDef($rsnew, $this->Periode->CurrentValue, NULL, $this->Periode->ReadOnly);

			// Kode_Fak
			$this->Kode_Fak->setDbValueDef($rsnew, $this->Kode_Fak->CurrentValue, "", $this->Kode_Fak->ReadOnly);

			// Kelas
			$this->Kelas->setDbValueDef($rsnew, $this->Kelas->CurrentValue, "", $this->Kelas->ReadOnly);

			// Semester
			$this->Semester->setDbValueDef($rsnew, $this->Semester->CurrentValue, NULL, $this->Semester->ReadOnly);

			// Awal_Perwalian
			$this->Awal_Perwalian->setDbValueDef($rsnew, UnFormatDateTime($this->Awal_Perwalian->CurrentValue, 7), NULL, $this->Awal_Perwalian->ReadOnly);

			// Akhir_Perwalian
			$this->Akhir_Perwalian->setDbValueDef($rsnew, UnFormatDateTime($this->Akhir_Perwalian->CurrentValue, 7), NULL, $this->Akhir_Perwalian->ReadOnly);

			// Awal_Perubahan
			$this->Awal_Perubahan->setDbValueDef($rsnew, UnFormatDateTime($this->Awal_Perubahan->CurrentValue, 7), NULL, $this->Awal_Perubahan->ReadOnly);

			// Akhir_Perubahan
			$this->Akhir_Perubahan->setDbValueDef($rsnew, UnFormatDateTime($this->Akhir_Perubahan->CurrentValue, 7), NULL, $this->Akhir_Perubahan->ReadOnly);

			// KunciPwl
			$this->KunciPwl->setDbValueDef($rsnew, $this->KunciPwl->CurrentValue, NULL, $this->KunciPwl->ReadOnly);

			// kunciujian
			$this->kunciujian->setDbValueDef($rsnew, $this->kunciujian->CurrentValue, NULL, $this->kunciujian->ReadOnly);

			// Kuncijadwal
			$this->Kuncijadwal->setDbValueDef($rsnew, $this->Kuncijadwal->CurrentValue, NULL, $this->Kuncijadwal->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("AWalilist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Th_Ak":
					break;
				case "x_Periode":
					break;
				case "x_Kode_Fak":
					break;
				case "x_Kelas":
					break;
				case "x_Semester":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Th_Ak":
							break;
						case "x_Kode_Fak":
							break;
						case "x_Kelas":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>