<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for DOC_QKurikulum
 */
class DOC_QKurikulum extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Kode_Jp;
	public $Kode_Mk;
	public $Nama_Mk_Ind;
	public $SKS;
	public $Semester;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'DOC_QKurikulum';
		$this->TableName = 'DOC_QKurikulum';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[DOC_QKurikulum]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Kode_Jp
		$this->Kode_Jp = new DbField('DOC_QKurikulum', 'DOC_QKurikulum', 'x_Kode_Jp', 'Kode_Jp', '[Kode_Jp]', '[Kode_Jp]', 129, 4, -1, FALSE, '[Kode_Jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Jp->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Jp->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Jp->Nullable = FALSE; // NOT NULL field
		$this->Kode_Jp->Required = TRUE; // Required field
		$this->Kode_Jp->Sortable = TRUE; // Allow sort
		$this->Kode_Jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Jp->Lookup = new Lookup('Kode_Jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Kode_Jp","Jurusan","Program",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Jp'] = &$this->Kode_Jp;

		// Kode_Mk
		$this->Kode_Mk = new DbField('DOC_QKurikulum', 'DOC_QKurikulum', 'x_Kode_Mk', 'Kode_Mk', '[Kode_Mk]', '[Kode_Mk]', 129, 14, -1, FALSE, '[Kode_Mk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Mk->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Mk->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Mk->Nullable = FALSE; // NOT NULL field
		$this->Kode_Mk->Required = TRUE; // Required field
		$this->Kode_Mk->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Mk'] = &$this->Kode_Mk;

		// Nama_Mk_Ind
		$this->Nama_Mk_Ind = new DbField('DOC_QKurikulum', 'DOC_QKurikulum', 'x_Nama_Mk_Ind', 'Nama_Mk_Ind', '[Nama_Mk_Ind]', '[Nama_Mk_Ind]', 129, 40, -1, FALSE, '[Nama_Mk_Ind]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mk_Ind->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mk_Ind'] = &$this->Nama_Mk_Ind;

		// SKS
		$this->SKS = new DbField('DOC_QKurikulum', 'DOC_QKurikulum', 'x_SKS', 'SKS', '[SKS]', 'CAST([SKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[SKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SKS->Sortable = TRUE; // Allow sort
		$this->SKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['SKS'] = &$this->SKS;

		// Semester
		$this->Semester = new DbField('DOC_QKurikulum', 'DOC_QKurikulum', 'x_Semester', 'Semester', '[Semester]', '[Semester]', 129, 1, -1, FALSE, '[Semester]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Semester->IsPrimaryKey = TRUE; // Primary key field
		$this->Semester->Nullable = FALSE; // NOT NULL field
		$this->Semester->Required = TRUE; // Required field
		$this->Semester->Sortable = TRUE; // Allow sort
		$this->Semester->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Semester->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Semester->Lookup = new Lookup('Semester', 'DOC_QKurikulum', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Semester->OptionCount = 8;
		$this->fields['Semester'] = &$this->Semester;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "Doc_InstumenPembelajaran") {
			$detailUrl = $GLOBALS["Doc_InstumenPembelajaran"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Kode_Jp=" . urlencode($this->Kode_Jp->CurrentValue);
			$detailUrl .= "&fk_Kode_Mk=" . urlencode($this->Kode_Mk->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "DOC_QKurikulumlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[DOC_QKurikulum]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Kode_Jp', $rs))
				AddFilter($where, QuotedName('Kode_Jp', $this->Dbid) . '=' . QuotedValue($rs['Kode_Jp'], $this->Kode_Jp->DataType, $this->Dbid));
			if (array_key_exists('Kode_Mk', $rs))
				AddFilter($where, QuotedName('Kode_Mk', $this->Dbid) . '=' . QuotedValue($rs['Kode_Mk'], $this->Kode_Mk->DataType, $this->Dbid));
			if (array_key_exists('Semester', $rs))
				AddFilter($where, QuotedName('Semester', $this->Dbid) . '=' . QuotedValue($rs['Semester'], $this->Semester->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Kode_Jp->DbValue = $row['Kode_Jp'];
		$this->Kode_Mk->DbValue = $row['Kode_Mk'];
		$this->Nama_Mk_Ind->DbValue = $row['Nama_Mk_Ind'];
		$this->SKS->DbValue = $row['SKS'];
		$this->Semester->DbValue = $row['Semester'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Kode_Jp] = '@Kode_Jp@' AND [Kode_Mk] = '@Kode_Mk@' AND [Semester] = '@Semester@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Kode_Jp', $row) ? $row['Kode_Jp'] : NULL;
		else
			$val = $this->Kode_Jp->OldValue !== NULL ? $this->Kode_Jp->OldValue : $this->Kode_Jp->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Jp@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kode_Mk', $row) ? $row['Kode_Mk'] : NULL;
		else
			$val = $this->Kode_Mk->OldValue !== NULL ? $this->Kode_Mk->OldValue : $this->Kode_Mk->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Mk@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Semester', $row) ? $row['Semester'] : NULL;
		else
			$val = $this->Semester->OldValue !== NULL ? $this->Semester->OldValue : $this->Semester->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Semester@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "DOC_QKurikulumlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "DOC_QKurikulumview.php")
			return $Language->phrase("View");
		elseif ($pageName == "DOC_QKurikulumedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "DOC_QKurikulumadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "DOC_QKurikulumlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("DOC_QKurikulumview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("DOC_QKurikulumview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "DOC_QKurikulumadd.php?" . $this->getUrlParm($parm);
		else
			$url = "DOC_QKurikulumadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("DOC_QKurikulumedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("DOC_QKurikulumedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("DOC_QKurikulumadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("DOC_QKurikulumadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("DOC_QKurikulumdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Kode_Jp:" . JsonEncode($this->Kode_Jp->CurrentValue, "string");
		$json .= ",Kode_Mk:" . JsonEncode($this->Kode_Mk->CurrentValue, "string");
		$json .= ",Semester:" . JsonEncode($this->Semester->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Kode_Jp->CurrentValue != NULL) {
			$url .= "Kode_Jp=" . urlencode($this->Kode_Jp->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kode_Mk->CurrentValue != NULL) {
			$url .= "&Kode_Mk=" . urlencode($this->Kode_Mk->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Semester->CurrentValue != NULL) {
			$url .= "&Semester=" . urlencode($this->Semester->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("Kode_Jp") !== NULL)
				$arKey[] = Param("Kode_Jp");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kode_Mk") !== NULL)
				$arKey[] = Param("Kode_Mk");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Semester") !== NULL)
				$arKey[] = Param("Semester");
			elseif (IsApi() && Key(2) !== NULL)
				$arKey[] = Key(2);
			elseif (IsApi() && Route(4) !== NULL)
				$arKey[] = Route(4);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 3)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Kode_Jp->CurrentValue = $key[0];
			else
				$this->Kode_Jp->OldValue = $key[0];
			if ($setCurrent)
				$this->Kode_Mk->CurrentValue = $key[1];
			else
				$this->Kode_Mk->OldValue = $key[1];
			if ($setCurrent)
				$this->Semester->CurrentValue = $key[2];
			else
				$this->Semester->OldValue = $key[2];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Kode_Jp->setDbValue($rs->fields('Kode_Jp'));
		$this->Kode_Mk->setDbValue($rs->fields('Kode_Mk'));
		$this->Nama_Mk_Ind->setDbValue($rs->fields('Nama_Mk_Ind'));
		$this->SKS->setDbValue($rs->fields('SKS'));
		$this->Semester->setDbValue($rs->fields('Semester'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Kode_Jp
		// Kode_Mk
		// Nama_Mk_Ind
		// SKS
		// Semester
		// Kode_Jp

		$curVal = strval($this->Kode_Jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
			if ($this->Kode_Jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->Kode_Jp->ViewValue = $this->Kode_Jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_Jp->ViewValue = NULL;
		}
		$this->Kode_Jp->ViewCustomAttributes = "";

		// Kode_Mk
		$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->ViewCustomAttributes = "";

		// Nama_Mk_Ind
		$this->Nama_Mk_Ind->ViewValue = $this->Nama_Mk_Ind->CurrentValue;
		$this->Nama_Mk_Ind->ViewCustomAttributes = "";

		// SKS
		$this->SKS->ViewValue = $this->SKS->CurrentValue;
		$this->SKS->ViewValue = FormatNumber($this->SKS->ViewValue, 0, -2, -2, -2);
		$this->SKS->ViewCustomAttributes = "";

		// Semester
		if (strval($this->Semester->CurrentValue) != "") {
			$this->Semester->ViewValue = $this->Semester->optionCaption($this->Semester->CurrentValue);
		} else {
			$this->Semester->ViewValue = NULL;
		}
		$this->Semester->ViewCustomAttributes = "";

		// Kode_Jp
		$this->Kode_Jp->LinkCustomAttributes = "";
		$this->Kode_Jp->HrefValue = "";
		$this->Kode_Jp->TooltipValue = "";

		// Kode_Mk
		$this->Kode_Mk->LinkCustomAttributes = "";
		$this->Kode_Mk->HrefValue = "";
		$this->Kode_Mk->TooltipValue = "";

		// Nama_Mk_Ind
		$this->Nama_Mk_Ind->LinkCustomAttributes = "";
		$this->Nama_Mk_Ind->HrefValue = "";
		$this->Nama_Mk_Ind->TooltipValue = "";

		// SKS
		$this->SKS->LinkCustomAttributes = "";
		$this->SKS->HrefValue = "";
		$this->SKS->TooltipValue = "";

		// Semester
		$this->Semester->LinkCustomAttributes = "";
		$this->Semester->HrefValue = "";
		$this->Semester->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Kode_Jp
		$this->Kode_Jp->EditAttrs["class"] = "form-control";
		$this->Kode_Jp->EditCustomAttributes = "";

		// Kode_Mk
		$this->Kode_Mk->EditAttrs["class"] = "form-control";
		$this->Kode_Mk->EditCustomAttributes = "";
		if (!$this->Kode_Mk->Raw)
			$this->Kode_Mk->CurrentValue = HtmlDecode($this->Kode_Mk->CurrentValue);
		$this->Kode_Mk->EditValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->PlaceHolder = RemoveHtml($this->Kode_Mk->caption());

		// Nama_Mk_Ind
		$this->Nama_Mk_Ind->EditAttrs["class"] = "form-control";
		$this->Nama_Mk_Ind->EditCustomAttributes = "";
		if (!$this->Nama_Mk_Ind->Raw)
			$this->Nama_Mk_Ind->CurrentValue = HtmlDecode($this->Nama_Mk_Ind->CurrentValue);
		$this->Nama_Mk_Ind->EditValue = $this->Nama_Mk_Ind->CurrentValue;
		$this->Nama_Mk_Ind->PlaceHolder = RemoveHtml($this->Nama_Mk_Ind->caption());

		// SKS
		$this->SKS->EditAttrs["class"] = "form-control";
		$this->SKS->EditCustomAttributes = "";
		$this->SKS->EditValue = $this->SKS->CurrentValue;
		$this->SKS->PlaceHolder = RemoveHtml($this->SKS->caption());

		// Semester
		$this->Semester->EditAttrs["class"] = "form-control";
		$this->Semester->EditCustomAttributes = "";
		$this->Semester->EditValue = $this->Semester->options(TRUE);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Nama_Mk_Ind);
					$doc->exportCaption($this->SKS);
					$doc->exportCaption($this->Semester);
				} else {
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Kode_Mk);
					$doc->exportCaption($this->Nama_Mk_Ind);
					$doc->exportCaption($this->SKS);
					$doc->exportCaption($this->Semester);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Nama_Mk_Ind);
						$doc->exportField($this->SKS);
						$doc->exportField($this->Semester);
					} else {
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Kode_Mk);
						$doc->exportField($this->Nama_Mk_Ind);
						$doc->exportField($this->SKS);
						$doc->exportField($this->Semester);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>