<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for Doc_InstumenPembelajaran
 */
class Doc_InstumenPembelajaran extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $IdNo;
	public $Kode_Jp;
	public $Kode_Mk;
	public $Nama_Berkas;
	public $FileDoc;
	public $TanggalUpdate;
	public $VersiDoc;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'Doc_InstumenPembelajaran';
		$this->TableName = 'Doc_InstumenPembelajaran';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[Doc_InstumenPembelajaran]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// IdNo
		$this->IdNo = new DbField('Doc_InstumenPembelajaran', 'Doc_InstumenPembelajaran', 'x_IdNo', 'IdNo', '[IdNo]', 'CAST([IdNo] AS NVARCHAR)', 3, 4, -1, FALSE, '[IdNo]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->IdNo->IsAutoIncrement = TRUE; // Autoincrement field
		$this->IdNo->IsPrimaryKey = TRUE; // Primary key field
		$this->IdNo->Nullable = FALSE; // NOT NULL field
		$this->IdNo->Sortable = TRUE; // Allow sort
		$this->IdNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['IdNo'] = &$this->IdNo;

		// Kode_Jp
		$this->Kode_Jp = new DbField('Doc_InstumenPembelajaran', 'Doc_InstumenPembelajaran', 'x_Kode_Jp', 'Kode_Jp', '[Kode_Jp]', '[Kode_Jp]', 200, 4, -1, FALSE, '[Kode_Jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Jp->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Jp->Nullable = FALSE; // NOT NULL field
		$this->Kode_Jp->Required = TRUE; // Required field
		$this->Kode_Jp->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Jp'] = &$this->Kode_Jp;

		// Kode_Mk
		$this->Kode_Mk = new DbField('Doc_InstumenPembelajaran', 'Doc_InstumenPembelajaran', 'x_Kode_Mk', 'Kode_Mk', '[Kode_Mk]', '[Kode_Mk]', 200, 14, -1, FALSE, '[Kode_Mk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Mk->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Mk->Nullable = FALSE; // NOT NULL field
		$this->Kode_Mk->Required = TRUE; // Required field
		$this->Kode_Mk->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Mk'] = &$this->Kode_Mk;

		// Nama_Berkas
		$this->Nama_Berkas = new DbField('Doc_InstumenPembelajaran', 'Doc_InstumenPembelajaran', 'x_Nama_Berkas', 'Nama_Berkas', '[Nama_Berkas]', '[Nama_Berkas]', 200, 50, -1, FALSE, '[Nama_Berkas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Nama_Berkas->Sortable = TRUE; // Allow sort
		$this->Nama_Berkas->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Nama_Berkas->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Nama_Berkas->Lookup = new Lookup('Nama_Berkas', 'Doc_InstumenPembelajaran', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Nama_Berkas->OptionCount = 9;
		$this->fields['Nama_Berkas'] = &$this->Nama_Berkas;

		// FileDoc
		$this->FileDoc = new DbField('Doc_InstumenPembelajaran', 'Doc_InstumenPembelajaran', 'x_FileDoc', 'FileDoc', '[FileDoc]', '[FileDoc]', 200, 100, -1, TRUE, '[FileDoc]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->FileDoc->Sortable = TRUE; // Allow sort
		$this->fields['FileDoc'] = &$this->FileDoc;

		// TanggalUpdate
		$this->TanggalUpdate = new DbField('Doc_InstumenPembelajaran', 'Doc_InstumenPembelajaran', 'x_TanggalUpdate', 'TanggalUpdate', '[TanggalUpdate]', CastDateFieldForLike("[TanggalUpdate]", 7, "DB"), 135, 8, 7, FALSE, '[TanggalUpdate]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TanggalUpdate->Required = TRUE; // Required field
		$this->TanggalUpdate->Sortable = TRUE; // Allow sort
		$this->TanggalUpdate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['TanggalUpdate'] = &$this->TanggalUpdate;

		// VersiDoc
		$this->VersiDoc = new DbField('Doc_InstumenPembelajaran', 'Doc_InstumenPembelajaran', 'x_VersiDoc', 'VersiDoc', '[VersiDoc]', 'CAST([VersiDoc] AS NVARCHAR)', 3, 4, -1, FALSE, '[VersiDoc]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->VersiDoc->Required = TRUE; // Required field
		$this->VersiDoc->Sortable = TRUE; // Allow sort
		$this->VersiDoc->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->VersiDoc->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->VersiDoc->Lookup = new Lookup('VersiDoc', 'Doc_InstumenPembelajaran', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->VersiDoc->OptionCount = 5;
		$this->VersiDoc->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['VersiDoc'] = &$this->VersiDoc;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "DOC_QKurikulum") {
			if ($this->Kode_Jp->getSessionValue() != "")
				$masterFilter .= "[Kode_Jp]=" . QuotedValue($this->Kode_Jp->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Mk->getSessionValue() != "")
				$masterFilter .= " AND [Kode_Mk]=" . QuotedValue($this->Kode_Mk->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "DOC_QKurikulum") {
			if ($this->Kode_Jp->getSessionValue() != "")
				$detailFilter .= "[Kode_Jp]=" . QuotedValue($this->Kode_Jp->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Mk->getSessionValue() != "")
				$detailFilter .= " AND [Kode_Mk]=" . QuotedValue($this->Kode_Mk->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_DOC_QKurikulum()
	{
		return "[Kode_Jp]='@Kode_Jp@' AND [Kode_Mk]='@Kode_Mk@'";
	}

	// Detail filter
	public function sqlDetailFilter_DOC_QKurikulum()
	{
		return "[Kode_Jp]='@Kode_Jp@' AND [Kode_Mk]='@Kode_Mk@'";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[Doc_InstumenPembelajaran]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->IdNo->setDbValue($conn->insert_ID());
			$rs['IdNo'] = $this->IdNo->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('IdNo', $rs))
				AddFilter($where, QuotedName('IdNo', $this->Dbid) . '=' . QuotedValue($rs['IdNo'], $this->IdNo->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->IdNo->DbValue = $row['IdNo'];
		$this->Kode_Jp->DbValue = $row['Kode_Jp'];
		$this->Kode_Mk->DbValue = $row['Kode_Mk'];
		$this->Nama_Berkas->DbValue = $row['Nama_Berkas'];
		$this->FileDoc->Upload->DbValue = $row['FileDoc'];
		$this->TanggalUpdate->DbValue = $row['TanggalUpdate'];
		$this->VersiDoc->DbValue = $row['VersiDoc'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->FileDoc->OldUploadPath = 'files/instrumen/';
		$oldFiles = EmptyValue($row['FileDoc']) ? [] : [$row['FileDoc']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->FileDoc->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->FileDoc->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[IdNo] = @IdNo@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('IdNo', $row) ? $row['IdNo'] : NULL;
		else
			$val = $this->IdNo->OldValue !== NULL ? $this->IdNo->OldValue : $this->IdNo->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@IdNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "Doc_InstumenPembelajaranlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "Doc_InstumenPembelajaranview.php")
			return $Language->phrase("View");
		elseif ($pageName == "Doc_InstumenPembelajaranedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "Doc_InstumenPembelajaranadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "Doc_InstumenPembelajaranlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("Doc_InstumenPembelajaranview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("Doc_InstumenPembelajaranview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "Doc_InstumenPembelajaranadd.php?" . $this->getUrlParm($parm);
		else
			$url = "Doc_InstumenPembelajaranadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("Doc_InstumenPembelajaranedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("Doc_InstumenPembelajaranadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("Doc_InstumenPembelajarandelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "DOC_QKurikulum" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Kode_Jp=" . urlencode($this->Kode_Jp->CurrentValue);
			$url .= "&fk_Kode_Mk=" . urlencode($this->Kode_Mk->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "IdNo:" . JsonEncode($this->IdNo->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->IdNo->CurrentValue != NULL) {
			$url .= "IdNo=" . urlencode($this->IdNo->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("IdNo") !== NULL)
				$arKeys[] = Param("IdNo");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->IdNo->CurrentValue = $key;
			else
				$this->IdNo->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->IdNo->setDbValue($rs->fields('IdNo'));
		$this->Kode_Jp->setDbValue($rs->fields('Kode_Jp'));
		$this->Kode_Mk->setDbValue($rs->fields('Kode_Mk'));
		$this->Nama_Berkas->setDbValue($rs->fields('Nama_Berkas'));
		$this->FileDoc->Upload->DbValue = $rs->fields('FileDoc');
		$this->TanggalUpdate->setDbValue($rs->fields('TanggalUpdate'));
		$this->VersiDoc->setDbValue($rs->fields('VersiDoc'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// IdNo
		// Kode_Jp
		// Kode_Mk
		// Nama_Berkas
		// FileDoc
		// TanggalUpdate
		// VersiDoc
		// IdNo

		$this->IdNo->ViewValue = $this->IdNo->CurrentValue;
		$this->IdNo->ViewCustomAttributes = "";

		// Kode_Jp
		$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
		$this->Kode_Jp->ViewCustomAttributes = "";

		// Kode_Mk
		$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->ViewCustomAttributes = "";

		// Nama_Berkas
		if (strval($this->Nama_Berkas->CurrentValue) != "") {
			$this->Nama_Berkas->ViewValue = $this->Nama_Berkas->optionCaption($this->Nama_Berkas->CurrentValue);
		} else {
			$this->Nama_Berkas->ViewValue = NULL;
		}
		$this->Nama_Berkas->ViewCustomAttributes = "";

		// FileDoc
		$this->FileDoc->UploadPath = 'files/instrumen/';
		if (!EmptyValue($this->FileDoc->Upload->DbValue)) {
			$this->FileDoc->ViewValue = $this->FileDoc->Upload->DbValue;
		} else {
			$this->FileDoc->ViewValue = "";
		}
		$this->FileDoc->ViewCustomAttributes = "";

		// TanggalUpdate
		$this->TanggalUpdate->ViewValue = $this->TanggalUpdate->CurrentValue;
		$this->TanggalUpdate->ViewValue = FormatDateTime($this->TanggalUpdate->ViewValue, 7);
		$this->TanggalUpdate->ViewCustomAttributes = "";

		// VersiDoc
		if (strval($this->VersiDoc->CurrentValue) != "") {
			$this->VersiDoc->ViewValue = $this->VersiDoc->optionCaption($this->VersiDoc->CurrentValue);
		} else {
			$this->VersiDoc->ViewValue = NULL;
		}
		$this->VersiDoc->ViewCustomAttributes = "";

		// IdNo
		$this->IdNo->LinkCustomAttributes = "";
		$this->IdNo->HrefValue = "";
		$this->IdNo->TooltipValue = "";

		// Kode_Jp
		$this->Kode_Jp->LinkCustomAttributes = "";
		$this->Kode_Jp->HrefValue = "";
		$this->Kode_Jp->TooltipValue = "";

		// Kode_Mk
		$this->Kode_Mk->LinkCustomAttributes = "";
		$this->Kode_Mk->HrefValue = "";
		$this->Kode_Mk->TooltipValue = "";

		// Nama_Berkas
		$this->Nama_Berkas->LinkCustomAttributes = "";
		$this->Nama_Berkas->HrefValue = "";
		$this->Nama_Berkas->TooltipValue = "";

		// FileDoc
		$this->FileDoc->LinkCustomAttributes = "";
		$this->FileDoc->UploadPath = 'files/instrumen/';
		if (!EmptyValue($this->FileDoc->Upload->DbValue)) {
			$this->FileDoc->HrefValue = GetFileUploadUrl($this->FileDoc, $this->FileDoc->htmlDecode($this->FileDoc->Upload->DbValue)); // Add prefix/suffix
			$this->FileDoc->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->FileDoc->HrefValue = FullUrl($this->FileDoc->HrefValue, "href");
		} else {
			$this->FileDoc->HrefValue = "";
		}
		$this->FileDoc->ExportHrefValue = $this->FileDoc->UploadPath . $this->FileDoc->Upload->DbValue;
		$this->FileDoc->TooltipValue = "";

		// TanggalUpdate
		$this->TanggalUpdate->LinkCustomAttributes = "";
		$this->TanggalUpdate->HrefValue = "";
		$this->TanggalUpdate->TooltipValue = "";

		// VersiDoc
		$this->VersiDoc->LinkCustomAttributes = "";
		$this->VersiDoc->HrefValue = "";
		$this->VersiDoc->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// IdNo
		$this->IdNo->EditAttrs["class"] = "form-control";
		$this->IdNo->EditCustomAttributes = "";
		$this->IdNo->EditValue = $this->IdNo->CurrentValue;
		$this->IdNo->ViewCustomAttributes = "";

		// Kode_Jp
		$this->Kode_Jp->EditAttrs["class"] = "form-control";
		$this->Kode_Jp->EditCustomAttributes = "";
		if ($this->Kode_Jp->getSessionValue() != "") {
			$this->Kode_Jp->CurrentValue = $this->Kode_Jp->getSessionValue();
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->ViewCustomAttributes = "";
		} else {
			if (!$this->Kode_Jp->Raw)
				$this->Kode_Jp->CurrentValue = HtmlDecode($this->Kode_Jp->CurrentValue);
			$this->Kode_Jp->EditValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->PlaceHolder = RemoveHtml($this->Kode_Jp->caption());
		}

		// Kode_Mk
		$this->Kode_Mk->EditAttrs["class"] = "form-control";
		$this->Kode_Mk->EditCustomAttributes = "";
		if ($this->Kode_Mk->getSessionValue() != "") {
			$this->Kode_Mk->CurrentValue = $this->Kode_Mk->getSessionValue();
			$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
			$this->Kode_Mk->ViewCustomAttributes = "";
		} else {
			if (!$this->Kode_Mk->Raw)
				$this->Kode_Mk->CurrentValue = HtmlDecode($this->Kode_Mk->CurrentValue);
			$this->Kode_Mk->EditValue = $this->Kode_Mk->CurrentValue;
			$this->Kode_Mk->PlaceHolder = RemoveHtml($this->Kode_Mk->caption());
		}

		// Nama_Berkas
		$this->Nama_Berkas->EditAttrs["class"] = "form-control";
		$this->Nama_Berkas->EditCustomAttributes = "";
		$this->Nama_Berkas->EditValue = $this->Nama_Berkas->options(TRUE);

		// FileDoc
		$this->FileDoc->EditAttrs["class"] = "form-control";
		$this->FileDoc->EditCustomAttributes = "";
		$this->FileDoc->UploadPath = 'files/instrumen/';
		if (!EmptyValue($this->FileDoc->Upload->DbValue)) {
			$this->FileDoc->EditValue = $this->FileDoc->Upload->DbValue;
		} else {
			$this->FileDoc->EditValue = "";
		}
		if (!EmptyValue($this->FileDoc->CurrentValue))
				$this->FileDoc->Upload->FileName = $this->FileDoc->CurrentValue;

		// TanggalUpdate
		$this->TanggalUpdate->EditAttrs["class"] = "form-control";
		$this->TanggalUpdate->EditCustomAttributes = "";
		$this->TanggalUpdate->EditValue = FormatDateTime($this->TanggalUpdate->CurrentValue, 7);
		$this->TanggalUpdate->PlaceHolder = RemoveHtml($this->TanggalUpdate->caption());

		// VersiDoc
		$this->VersiDoc->EditAttrs["class"] = "form-control";
		$this->VersiDoc->EditCustomAttributes = "";
		$this->VersiDoc->EditValue = $this->VersiDoc->options(TRUE);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->IdNo);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Kode_Mk);
					$doc->exportCaption($this->Nama_Berkas);
					$doc->exportCaption($this->FileDoc);
					$doc->exportCaption($this->TanggalUpdate);
					$doc->exportCaption($this->VersiDoc);
				} else {
					$doc->exportCaption($this->IdNo);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Kode_Mk);
					$doc->exportCaption($this->Nama_Berkas);
					$doc->exportCaption($this->FileDoc);
					$doc->exportCaption($this->TanggalUpdate);
					$doc->exportCaption($this->VersiDoc);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->IdNo);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Kode_Mk);
						$doc->exportField($this->Nama_Berkas);
						$doc->exportField($this->FileDoc);
						$doc->exportField($this->TanggalUpdate);
						$doc->exportField($this->VersiDoc);
					} else {
						$doc->exportField($this->IdNo);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Kode_Mk);
						$doc->exportField($this->Nama_Berkas);
						$doc->exportField($this->FileDoc);
						$doc->exportField($this->TanggalUpdate);
						$doc->exportField($this->VersiDoc);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{
		$width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
		$height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'FileDoc') {
			$fldName = "FileDoc";
			$fileNameFld = "FileDoc";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($ar) == 1) {
			$this->IdNo->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype != "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld != "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					$downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
					if ($fileNameFld != "" && !EmptyValue($rs->fields($fileNameFld))) {
						$fileName = $rs->fields($fileNameFld);
						$pathinfo = pathinfo($fileName);
						$ext = strtolower(@$pathinfo["extension"]);
						$isPdf = SameText($ext, "pdf");
						if ($downloadPdf || !$isPdf) // Skip header if not download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					} else {
						$ext = ContentExtension($val);
						$isPdf = SameText($ext, ".pdf");
						if ($isPdf && $downloadPdf) // Add header if download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					}

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear any debug message
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>