<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for HtblNilai
 */
class HtblNilai extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $IDX;
	public $Nim;
	public $KelasAkd;
	public $Thn_Akademik;
	public $Periode;
	public $Kode_MK;
	public $kls;
	public $Kehadiran;
	public $Tugas;
	public $Quiz;
	public $UTS;
	public $UAS;
	public $Jumlah;
	public $Nilai;
	public $Angka;
	public $kunci;
	public $inp;
	public $Gujian;
	public $Minggu1;
	public $Minggu2;
	public $Minggu3;
	public $Minggu4;
	public $Minggu5;
	public $Minggu6;
	public $Minggu7;
	public $Minggu8;
	public $Minggu9;
	public $Minggu10;
	public $Minggu11;
	public $Minggu12;
	public $Minggu13;
	public $Minggu14;
	public $Minggu15;
	public $Minggu16;
	public $Persentase;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'HtblNilai';
		$this->TableName = 'HtblNilai';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[HtblNilai]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// IDX
		$this->IDX = new DbField('HtblNilai', 'HtblNilai', 'x_IDX', 'IDX', '[IDX]', 'CAST([IDX] AS NVARCHAR)', 3, 4, -1, FALSE, '[IDX]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->IDX->IsAutoIncrement = TRUE; // Autoincrement field
		$this->IDX->IsPrimaryKey = TRUE; // Primary key field
		$this->IDX->Nullable = FALSE; // NOT NULL field
		$this->IDX->Sortable = TRUE; // Allow sort
		$this->IDX->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['IDX'] = &$this->IDX;

		// Nim
		$this->Nim = new DbField('HtblNilai', 'HtblNilai', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 129, 14, -1, FALSE, '[EV__Nim]', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->Nim->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Nim->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Nim->Lookup = new Lookup('Nim', 'tblMHS', FALSE, 'Nim', ["Nim","Nama_Mhs","",""], [], [], [], [], [], [], '', '');
		$this->fields['Nim'] = &$this->Nim;

		// KelasAkd
		$this->KelasAkd = new DbField('HtblNilai', 'HtblNilai', 'x_KelasAkd', 'KelasAkd', '[KelasAkd]', '[KelasAkd]', 200, 15, -1, FALSE, '[KelasAkd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KelasAkd->Sortable = TRUE; // Allow sort
		$this->fields['KelasAkd'] = &$this->KelasAkd;

		// Thn_Akademik
		$this->Thn_Akademik = new DbField('HtblNilai', 'HtblNilai', 'x_Thn_Akademik', 'Thn_Akademik', '[Thn_Akademik]', '[Thn_Akademik]', 129, 12, -1, FALSE, '[Thn_Akademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Thn_Akademik->Sortable = TRUE; // Allow sort
		$this->fields['Thn_Akademik'] = &$this->Thn_Akademik;

		// Periode
		$this->Periode = new DbField('HtblNilai', 'HtblNilai', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 129, 3, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->fields['Periode'] = &$this->Periode;

		// Kode_MK
		$this->Kode_MK = new DbField('HtblNilai', 'HtblNilai', 'x_Kode_MK', 'Kode_MK', '[Kode_MK]', '[Kode_MK]', 129, 14, -1, FALSE, '[Kode_MK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_MK->Sortable = TRUE; // Allow sort
		$this->Kode_MK->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_MK->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_MK->Lookup = new Lookup('Kode_MK', 'tblMK', FALSE, 'Kode_MK', ["Kode_MK","Nama_Mk_Ind","SKS",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_MK'] = &$this->Kode_MK;

		// kls
		$this->kls = new DbField('HtblNilai', 'HtblNilai', 'x_kls', 'kls', '[kls]', '[kls]', 200, 4, -1, FALSE, '[kls]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kls->Sortable = TRUE; // Allow sort
		$this->fields['kls'] = &$this->kls;

		// Kehadiran
		$this->Kehadiran = new DbField('HtblNilai', 'HtblNilai', 'x_Kehadiran', 'Kehadiran', '[Kehadiran]', 'CAST([Kehadiran] AS NVARCHAR)', 5, 8, -1, FALSE, '[Kehadiran]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kehadiran->Sortable = TRUE; // Allow sort
		$this->Kehadiran->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Kehadiran'] = &$this->Kehadiran;

		// Tugas
		$this->Tugas = new DbField('HtblNilai', 'HtblNilai', 'x_Tugas', 'Tugas', '[Tugas]', 'CAST([Tugas] AS NVARCHAR)', 5, 8, -1, FALSE, '[Tugas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tugas->Sortable = TRUE; // Allow sort
		$this->Tugas->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Tugas'] = &$this->Tugas;

		// Quiz
		$this->Quiz = new DbField('HtblNilai', 'HtblNilai', 'x_Quiz', 'Quiz', '[Quiz]', 'CAST([Quiz] AS NVARCHAR)', 5, 8, -1, FALSE, '[Quiz]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Quiz->Sortable = TRUE; // Allow sort
		$this->Quiz->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Quiz'] = &$this->Quiz;

		// UTS
		$this->UTS = new DbField('HtblNilai', 'HtblNilai', 'x_UTS', 'UTS', '[UTS]', 'CAST([UTS] AS NVARCHAR)', 5, 8, -1, FALSE, '[UTS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UTS->Sortable = TRUE; // Allow sort
		$this->UTS->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['UTS'] = &$this->UTS;

		// UAS
		$this->UAS = new DbField('HtblNilai', 'HtblNilai', 'x_UAS', 'UAS', '[UAS]', 'CAST([UAS] AS NVARCHAR)', 5, 8, -1, FALSE, '[UAS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UAS->Sortable = TRUE; // Allow sort
		$this->UAS->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['UAS'] = &$this->UAS;

		// Jumlah
		$this->Jumlah = new DbField('HtblNilai', 'HtblNilai', 'x_Jumlah', 'Jumlah', '[Jumlah]', 'CAST([Jumlah] AS NVARCHAR)', 5, 8, -1, FALSE, '[Jumlah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jumlah->Sortable = TRUE; // Allow sort
		$this->Jumlah->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Jumlah'] = &$this->Jumlah;

		// Nilai
		$this->Nilai = new DbField('HtblNilai', 'HtblNilai', 'x_Nilai', 'Nilai', '[Nilai]', '[Nilai]', 129, 2, -1, FALSE, '[Nilai]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nilai->Sortable = TRUE; // Allow sort
		$this->fields['Nilai'] = &$this->Nilai;

		// Angka
		$this->Angka = new DbField('HtblNilai', 'HtblNilai', 'x_Angka', 'Angka', '[Angka]', 'CAST([Angka] AS NVARCHAR)', 5, 8, -1, FALSE, '[Angka]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Angka->Sortable = TRUE; // Allow sort
		$this->Angka->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Angka'] = &$this->Angka;

		// kunci
		$this->kunci = new DbField('HtblNilai', 'HtblNilai', 'x_kunci', 'kunci', '[kunci]', '[kunci]', 129, 35, -1, FALSE, '[kunci]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kunci->Sortable = TRUE; // Allow sort
		$this->fields['kunci'] = &$this->kunci;

		// inp
		$this->inp = new DbField('HtblNilai', 'HtblNilai', 'x_inp', 'inp', '[inp]', '[inp]', 200, 50, -1, FALSE, '[inp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->inp->Sortable = TRUE; // Allow sort
		$this->fields['inp'] = &$this->inp;

		// Gujian
		$this->Gujian = new DbField('HtblNilai', 'HtblNilai', 'x_Gujian', 'Gujian', '[Gujian]', '[Gujian]', 200, 4, -1, FALSE, '[Gujian]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Gujian->Sortable = TRUE; // Allow sort
		$this->fields['Gujian'] = &$this->Gujian;

		// Minggu1
		$this->Minggu1 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu1', 'Minggu1', '[Minggu1]', '[Minggu1]', 129, 1, -1, FALSE, '[Minggu1]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu1->Sortable = TRUE; // Allow sort
		$this->fields['Minggu1'] = &$this->Minggu1;

		// Minggu2
		$this->Minggu2 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu2', 'Minggu2', '[Minggu2]', '[Minggu2]', 129, 1, -1, FALSE, '[Minggu2]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu2->Sortable = TRUE; // Allow sort
		$this->fields['Minggu2'] = &$this->Minggu2;

		// Minggu3
		$this->Minggu3 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu3', 'Minggu3', '[Minggu3]', '[Minggu3]', 129, 1, -1, FALSE, '[Minggu3]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu3->Sortable = TRUE; // Allow sort
		$this->fields['Minggu3'] = &$this->Minggu3;

		// Minggu4
		$this->Minggu4 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu4', 'Minggu4', '[Minggu4]', '[Minggu4]', 129, 1, -1, FALSE, '[Minggu4]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu4->Sortable = TRUE; // Allow sort
		$this->fields['Minggu4'] = &$this->Minggu4;

		// Minggu5
		$this->Minggu5 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu5', 'Minggu5', '[Minggu5]', '[Minggu5]', 129, 1, -1, FALSE, '[Minggu5]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu5->Sortable = TRUE; // Allow sort
		$this->fields['Minggu5'] = &$this->Minggu5;

		// Minggu6
		$this->Minggu6 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu6', 'Minggu6', '[Minggu6]', '[Minggu6]', 129, 1, -1, FALSE, '[Minggu6]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu6->Sortable = TRUE; // Allow sort
		$this->fields['Minggu6'] = &$this->Minggu6;

		// Minggu7
		$this->Minggu7 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu7', 'Minggu7', '[Minggu7]', '[Minggu7]', 129, 1, -1, FALSE, '[Minggu7]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu7->Sortable = TRUE; // Allow sort
		$this->fields['Minggu7'] = &$this->Minggu7;

		// Minggu8
		$this->Minggu8 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu8', 'Minggu8', '[Minggu8]', '[Minggu8]', 129, 1, -1, FALSE, '[Minggu8]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu8->Sortable = TRUE; // Allow sort
		$this->fields['Minggu8'] = &$this->Minggu8;

		// Minggu9
		$this->Minggu9 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu9', 'Minggu9', '[Minggu9]', '[Minggu9]', 129, 1, -1, FALSE, '[Minggu9]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu9->Sortable = TRUE; // Allow sort
		$this->fields['Minggu9'] = &$this->Minggu9;

		// Minggu10
		$this->Minggu10 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu10', 'Minggu10', '[Minggu10]', '[Minggu10]', 129, 1, -1, FALSE, '[Minggu10]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu10->Sortable = TRUE; // Allow sort
		$this->fields['Minggu10'] = &$this->Minggu10;

		// Minggu11
		$this->Minggu11 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu11', 'Minggu11', '[Minggu11]', '[Minggu11]', 129, 1, -1, FALSE, '[Minggu11]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu11->Sortable = TRUE; // Allow sort
		$this->fields['Minggu11'] = &$this->Minggu11;

		// Minggu12
		$this->Minggu12 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu12', 'Minggu12', '[Minggu12]', '[Minggu12]', 129, 1, -1, FALSE, '[Minggu12]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu12->Sortable = TRUE; // Allow sort
		$this->fields['Minggu12'] = &$this->Minggu12;

		// Minggu13
		$this->Minggu13 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu13', 'Minggu13', '[Minggu13]', '[Minggu13]', 129, 1, -1, FALSE, '[Minggu13]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu13->Sortable = TRUE; // Allow sort
		$this->fields['Minggu13'] = &$this->Minggu13;

		// Minggu14
		$this->Minggu14 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu14', 'Minggu14', '[Minggu14]', '[Minggu14]', 129, 1, -1, FALSE, '[Minggu14]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu14->Sortable = TRUE; // Allow sort
		$this->fields['Minggu14'] = &$this->Minggu14;

		// Minggu15
		$this->Minggu15 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu15', 'Minggu15', '[Minggu15]', '[Minggu15]', 129, 1, -1, FALSE, '[Minggu15]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu15->Sortable = TRUE; // Allow sort
		$this->fields['Minggu15'] = &$this->Minggu15;

		// Minggu16
		$this->Minggu16 = new DbField('HtblNilai', 'HtblNilai', 'x_Minggu16', 'Minggu16', '[Minggu16]', '[Minggu16]', 129, 1, -1, FALSE, '[Minggu16]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Minggu16->Sortable = TRUE; // Allow sort
		$this->fields['Minggu16'] = &$this->Minggu16;

		// Persentase
		$this->Persentase = new DbField('HtblNilai', 'HtblNilai', 'x_Persentase', 'Persentase', '[Persentase]', 'CAST([Persentase] AS NVARCHAR)', 5, 8, -1, FALSE, '[Persentase]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Persentase->Sortable = TRUE; // Allow sort
		$this->Persentase->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Persentase'] = &$this->Persentase;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[HtblNilai]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT TOP 1 CONVERT(NVARCHAR(MAX),[Nim]) + '" . ValueSeparator(1, $this->Nim) . "' + CONVERT(NVARCHAR(MAX),[Nama_Mhs]) FROM [dbo].[tblMHS] [TMP_LOOKUPTABLE] WHERE [TMP_LOOKUPTABLE].[Nim] = [HtblNilai].[Nim]) AS [EV__Nim] FROM [dbo].[HtblNilai]" .
			") [TMP_TABLE]";
		return ($this->SqlSelectList != "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where != "")
			$where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
		if ($orderBy != "")
			$orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() != "")
			return TRUE;
		if ($this->Nim->AdvancedSearch->SearchValue != "" ||
			$this->Nim->AdvancedSearch->SearchValue2 != "" ||
			ContainsString($where, " " . $this->Nim->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->Nim->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->IDX->setDbValue($conn->insert_ID());
			$rs['IDX'] = $this->IDX->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('IDX', $rs))
				AddFilter($where, QuotedName('IDX', $this->Dbid) . '=' . QuotedValue($rs['IDX'], $this->IDX->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->IDX->DbValue = $row['IDX'];
		$this->Nim->DbValue = $row['Nim'];
		$this->KelasAkd->DbValue = $row['KelasAkd'];
		$this->Thn_Akademik->DbValue = $row['Thn_Akademik'];
		$this->Periode->DbValue = $row['Periode'];
		$this->Kode_MK->DbValue = $row['Kode_MK'];
		$this->kls->DbValue = $row['kls'];
		$this->Kehadiran->DbValue = $row['Kehadiran'];
		$this->Tugas->DbValue = $row['Tugas'];
		$this->Quiz->DbValue = $row['Quiz'];
		$this->UTS->DbValue = $row['UTS'];
		$this->UAS->DbValue = $row['UAS'];
		$this->Jumlah->DbValue = $row['Jumlah'];
		$this->Nilai->DbValue = $row['Nilai'];
		$this->Angka->DbValue = $row['Angka'];
		$this->kunci->DbValue = $row['kunci'];
		$this->inp->DbValue = $row['inp'];
		$this->Gujian->DbValue = $row['Gujian'];
		$this->Minggu1->DbValue = $row['Minggu1'];
		$this->Minggu2->DbValue = $row['Minggu2'];
		$this->Minggu3->DbValue = $row['Minggu3'];
		$this->Minggu4->DbValue = $row['Minggu4'];
		$this->Minggu5->DbValue = $row['Minggu5'];
		$this->Minggu6->DbValue = $row['Minggu6'];
		$this->Minggu7->DbValue = $row['Minggu7'];
		$this->Minggu8->DbValue = $row['Minggu8'];
		$this->Minggu9->DbValue = $row['Minggu9'];
		$this->Minggu10->DbValue = $row['Minggu10'];
		$this->Minggu11->DbValue = $row['Minggu11'];
		$this->Minggu12->DbValue = $row['Minggu12'];
		$this->Minggu13->DbValue = $row['Minggu13'];
		$this->Minggu14->DbValue = $row['Minggu14'];
		$this->Minggu15->DbValue = $row['Minggu15'];
		$this->Minggu16->DbValue = $row['Minggu16'];
		$this->Persentase->DbValue = $row['Persentase'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[IDX] = @IDX@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('IDX', $row) ? $row['IDX'] : NULL;
		else
			$val = $this->IDX->OldValue !== NULL ? $this->IDX->OldValue : $this->IDX->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@IDX@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "HtblNilailist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "HtblNilaiview.php")
			return $Language->phrase("View");
		elseif ($pageName == "HtblNilaiedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "HtblNilaiadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "HtblNilailist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("HtblNilaiview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("HtblNilaiview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "HtblNilaiadd.php?" . $this->getUrlParm($parm);
		else
			$url = "HtblNilaiadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("HtblNilaiedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("HtblNilaiadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("HtblNilaidelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "IDX:" . JsonEncode($this->IDX->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->IDX->CurrentValue != NULL) {
			$url .= "IDX=" . urlencode($this->IDX->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("IDX") !== NULL)
				$arKeys[] = Param("IDX");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->IDX->CurrentValue = $key;
			else
				$this->IDX->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->IDX->setDbValue($rs->fields('IDX'));
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->KelasAkd->setDbValue($rs->fields('KelasAkd'));
		$this->Thn_Akademik->setDbValue($rs->fields('Thn_Akademik'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->Kode_MK->setDbValue($rs->fields('Kode_MK'));
		$this->kls->setDbValue($rs->fields('kls'));
		$this->Kehadiran->setDbValue($rs->fields('Kehadiran'));
		$this->Tugas->setDbValue($rs->fields('Tugas'));
		$this->Quiz->setDbValue($rs->fields('Quiz'));
		$this->UTS->setDbValue($rs->fields('UTS'));
		$this->UAS->setDbValue($rs->fields('UAS'));
		$this->Jumlah->setDbValue($rs->fields('Jumlah'));
		$this->Nilai->setDbValue($rs->fields('Nilai'));
		$this->Angka->setDbValue($rs->fields('Angka'));
		$this->kunci->setDbValue($rs->fields('kunci'));
		$this->inp->setDbValue($rs->fields('inp'));
		$this->Gujian->setDbValue($rs->fields('Gujian'));
		$this->Minggu1->setDbValue($rs->fields('Minggu1'));
		$this->Minggu2->setDbValue($rs->fields('Minggu2'));
		$this->Minggu3->setDbValue($rs->fields('Minggu3'));
		$this->Minggu4->setDbValue($rs->fields('Minggu4'));
		$this->Minggu5->setDbValue($rs->fields('Minggu5'));
		$this->Minggu6->setDbValue($rs->fields('Minggu6'));
		$this->Minggu7->setDbValue($rs->fields('Minggu7'));
		$this->Minggu8->setDbValue($rs->fields('Minggu8'));
		$this->Minggu9->setDbValue($rs->fields('Minggu9'));
		$this->Minggu10->setDbValue($rs->fields('Minggu10'));
		$this->Minggu11->setDbValue($rs->fields('Minggu11'));
		$this->Minggu12->setDbValue($rs->fields('Minggu12'));
		$this->Minggu13->setDbValue($rs->fields('Minggu13'));
		$this->Minggu14->setDbValue($rs->fields('Minggu14'));
		$this->Minggu15->setDbValue($rs->fields('Minggu15'));
		$this->Minggu16->setDbValue($rs->fields('Minggu16'));
		$this->Persentase->setDbValue($rs->fields('Persentase'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// IDX
		// Nim
		// KelasAkd
		// Thn_Akademik
		// Periode
		// Kode_MK
		// kls
		// Kehadiran
		// Tugas
		// Quiz
		// UTS
		// UAS
		// Jumlah
		// Nilai
		// Angka
		// kunci
		// inp
		// Gujian
		// Minggu1
		// Minggu2
		// Minggu3
		// Minggu4
		// Minggu5
		// Minggu6
		// Minggu7
		// Minggu8
		// Minggu9
		// Minggu10
		// Minggu11
		// Minggu12
		// Minggu13
		// Minggu14
		// Minggu15
		// Minggu16
		// Persentase
		// IDX

		$this->IDX->ViewValue = $this->IDX->CurrentValue;
		$this->IDX->ViewCustomAttributes = "";

		// Nim
		if ($this->Nim->VirtualValue != "") {
			$this->Nim->ViewValue = $this->Nim->VirtualValue;
		} else {
			$curVal = strval($this->Nim->CurrentValue);
			if ($curVal != "") {
				$this->Nim->ViewValue = $this->Nim->lookupCacheOption($curVal);
				if ($this->Nim->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Nim]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Nim->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->Nim->ViewValue = $this->Nim->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Nim->ViewValue = $this->Nim->CurrentValue;
					}
				}
			} else {
				$this->Nim->ViewValue = NULL;
			}
		}
		$this->Nim->ViewCustomAttributes = "";

		// KelasAkd
		$this->KelasAkd->ViewValue = $this->KelasAkd->CurrentValue;
		$this->KelasAkd->ViewCustomAttributes = "";

		// Thn_Akademik
		$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
		$this->Thn_Akademik->ViewCustomAttributes = "";

		// Periode
		$this->Periode->ViewValue = $this->Periode->CurrentValue;
		$this->Periode->ViewCustomAttributes = "";

		// Kode_MK
		$curVal = strval($this->Kode_MK->CurrentValue);
		if ($curVal != "") {
			$this->Kode_MK->ViewValue = $this->Kode_MK->lookupCacheOption($curVal);
			if ($this->Kode_MK->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_MK->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
					$this->Kode_MK->ViewValue = $this->Kode_MK->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
				}
			}
		} else {
			$this->Kode_MK->ViewValue = NULL;
		}
		$this->Kode_MK->ViewCustomAttributes = "";

		// kls
		$this->kls->ViewValue = $this->kls->CurrentValue;
		$this->kls->ViewCustomAttributes = "";

		// Kehadiran
		$this->Kehadiran->ViewValue = $this->Kehadiran->CurrentValue;
		$this->Kehadiran->ViewValue = FormatNumber($this->Kehadiran->ViewValue, 2, -2, -2, -2);
		$this->Kehadiran->ViewCustomAttributes = "";

		// Tugas
		$this->Tugas->ViewValue = $this->Tugas->CurrentValue;
		$this->Tugas->ViewValue = FormatNumber($this->Tugas->ViewValue, 2, -2, -2, -2);
		$this->Tugas->ViewCustomAttributes = "";

		// Quiz
		$this->Quiz->ViewValue = $this->Quiz->CurrentValue;
		$this->Quiz->ViewValue = FormatNumber($this->Quiz->ViewValue, 2, -2, -2, -2);
		$this->Quiz->ViewCustomAttributes = "";

		// UTS
		$this->UTS->ViewValue = $this->UTS->CurrentValue;
		$this->UTS->ViewValue = FormatNumber($this->UTS->ViewValue, 2, -2, -2, -2);
		$this->UTS->ViewCustomAttributes = "";

		// UAS
		$this->UAS->ViewValue = $this->UAS->CurrentValue;
		$this->UAS->ViewValue = FormatNumber($this->UAS->ViewValue, 2, -2, -2, -2);
		$this->UAS->ViewCustomAttributes = "";

		// Jumlah
		$this->Jumlah->ViewValue = $this->Jumlah->CurrentValue;
		$this->Jumlah->ViewValue = FormatNumber($this->Jumlah->ViewValue, 2, -2, -2, -2);
		$this->Jumlah->ViewCustomAttributes = "";

		// Nilai
		$this->Nilai->ViewValue = $this->Nilai->CurrentValue;
		$this->Nilai->ViewCustomAttributes = "";

		// Angka
		$this->Angka->ViewValue = $this->Angka->CurrentValue;
		$this->Angka->ViewValue = FormatNumber($this->Angka->ViewValue, 2, -2, -2, -2);
		$this->Angka->ViewCustomAttributes = "";

		// kunci
		$this->kunci->ViewValue = $this->kunci->CurrentValue;
		$this->kunci->ViewCustomAttributes = "";

		// inp
		$this->inp->ViewValue = $this->inp->CurrentValue;
		$this->inp->ViewCustomAttributes = "";

		// Gujian
		$this->Gujian->ViewValue = $this->Gujian->CurrentValue;
		$this->Gujian->ViewCustomAttributes = "";

		// Minggu1
		$this->Minggu1->ViewValue = $this->Minggu1->CurrentValue;
		$this->Minggu1->ViewCustomAttributes = "";

		// Minggu2
		$this->Minggu2->ViewValue = $this->Minggu2->CurrentValue;
		$this->Minggu2->ViewCustomAttributes = "";

		// Minggu3
		$this->Minggu3->ViewValue = $this->Minggu3->CurrentValue;
		$this->Minggu3->ViewCustomAttributes = "";

		// Minggu4
		$this->Minggu4->ViewValue = $this->Minggu4->CurrentValue;
		$this->Minggu4->ViewCustomAttributes = "";

		// Minggu5
		$this->Minggu5->ViewValue = $this->Minggu5->CurrentValue;
		$this->Minggu5->ViewCustomAttributes = "";

		// Minggu6
		$this->Minggu6->ViewValue = $this->Minggu6->CurrentValue;
		$this->Minggu6->ViewCustomAttributes = "";

		// Minggu7
		$this->Minggu7->ViewValue = $this->Minggu7->CurrentValue;
		$this->Minggu7->ViewCustomAttributes = "";

		// Minggu8
		$this->Minggu8->ViewValue = $this->Minggu8->CurrentValue;
		$this->Minggu8->ViewCustomAttributes = "";

		// Minggu9
		$this->Minggu9->ViewValue = $this->Minggu9->CurrentValue;
		$this->Minggu9->ViewCustomAttributes = "";

		// Minggu10
		$this->Minggu10->ViewValue = $this->Minggu10->CurrentValue;
		$this->Minggu10->ViewCustomAttributes = "";

		// Minggu11
		$this->Minggu11->ViewValue = $this->Minggu11->CurrentValue;
		$this->Minggu11->ViewCustomAttributes = "";

		// Minggu12
		$this->Minggu12->ViewValue = $this->Minggu12->CurrentValue;
		$this->Minggu12->ViewCustomAttributes = "";

		// Minggu13
		$this->Minggu13->ViewValue = $this->Minggu13->CurrentValue;
		$this->Minggu13->ViewCustomAttributes = "";

		// Minggu14
		$this->Minggu14->ViewValue = $this->Minggu14->CurrentValue;
		$this->Minggu14->ViewCustomAttributes = "";

		// Minggu15
		$this->Minggu15->ViewValue = $this->Minggu15->CurrentValue;
		$this->Minggu15->ViewCustomAttributes = "";

		// Minggu16
		$this->Minggu16->ViewValue = $this->Minggu16->CurrentValue;
		$this->Minggu16->ViewCustomAttributes = "";

		// Persentase
		$this->Persentase->ViewValue = $this->Persentase->CurrentValue;
		$this->Persentase->ViewValue = FormatNumber($this->Persentase->ViewValue, 2, -2, -2, -2);
		$this->Persentase->ViewCustomAttributes = "";

		// IDX
		$this->IDX->LinkCustomAttributes = "";
		$this->IDX->HrefValue = "";
		$this->IDX->TooltipValue = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// KelasAkd
		$this->KelasAkd->LinkCustomAttributes = "";
		$this->KelasAkd->HrefValue = "";
		$this->KelasAkd->TooltipValue = "";

		// Thn_Akademik
		$this->Thn_Akademik->LinkCustomAttributes = "";
		$this->Thn_Akademik->HrefValue = "";
		$this->Thn_Akademik->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// Kode_MK
		$this->Kode_MK->LinkCustomAttributes = "";
		$this->Kode_MK->HrefValue = "";
		$this->Kode_MK->TooltipValue = "";

		// kls
		$this->kls->LinkCustomAttributes = "";
		$this->kls->HrefValue = "";
		$this->kls->TooltipValue = "";

		// Kehadiran
		$this->Kehadiran->LinkCustomAttributes = "";
		$this->Kehadiran->HrefValue = "";
		$this->Kehadiran->TooltipValue = "";

		// Tugas
		$this->Tugas->LinkCustomAttributes = "";
		$this->Tugas->HrefValue = "";
		$this->Tugas->TooltipValue = "";

		// Quiz
		$this->Quiz->LinkCustomAttributes = "";
		$this->Quiz->HrefValue = "";
		$this->Quiz->TooltipValue = "";

		// UTS
		$this->UTS->LinkCustomAttributes = "";
		$this->UTS->HrefValue = "";
		$this->UTS->TooltipValue = "";

		// UAS
		$this->UAS->LinkCustomAttributes = "";
		$this->UAS->HrefValue = "";
		$this->UAS->TooltipValue = "";

		// Jumlah
		$this->Jumlah->LinkCustomAttributes = "";
		$this->Jumlah->HrefValue = "";
		$this->Jumlah->TooltipValue = "";

		// Nilai
		$this->Nilai->LinkCustomAttributes = "";
		$this->Nilai->HrefValue = "";
		$this->Nilai->TooltipValue = "";

		// Angka
		$this->Angka->LinkCustomAttributes = "";
		$this->Angka->HrefValue = "";
		$this->Angka->TooltipValue = "";

		// kunci
		$this->kunci->LinkCustomAttributes = "";
		$this->kunci->HrefValue = "";
		$this->kunci->TooltipValue = "";

		// inp
		$this->inp->LinkCustomAttributes = "";
		$this->inp->HrefValue = "";
		$this->inp->TooltipValue = "";

		// Gujian
		$this->Gujian->LinkCustomAttributes = "";
		$this->Gujian->HrefValue = "";
		$this->Gujian->TooltipValue = "";

		// Minggu1
		$this->Minggu1->LinkCustomAttributes = "";
		$this->Minggu1->HrefValue = "";
		$this->Minggu1->TooltipValue = "";

		// Minggu2
		$this->Minggu2->LinkCustomAttributes = "";
		$this->Minggu2->HrefValue = "";
		$this->Minggu2->TooltipValue = "";

		// Minggu3
		$this->Minggu3->LinkCustomAttributes = "";
		$this->Minggu3->HrefValue = "";
		$this->Minggu3->TooltipValue = "";

		// Minggu4
		$this->Minggu4->LinkCustomAttributes = "";
		$this->Minggu4->HrefValue = "";
		$this->Minggu4->TooltipValue = "";

		// Minggu5
		$this->Minggu5->LinkCustomAttributes = "";
		$this->Minggu5->HrefValue = "";
		$this->Minggu5->TooltipValue = "";

		// Minggu6
		$this->Minggu6->LinkCustomAttributes = "";
		$this->Minggu6->HrefValue = "";
		$this->Minggu6->TooltipValue = "";

		// Minggu7
		$this->Minggu7->LinkCustomAttributes = "";
		$this->Minggu7->HrefValue = "";
		$this->Minggu7->TooltipValue = "";

		// Minggu8
		$this->Minggu8->LinkCustomAttributes = "";
		$this->Minggu8->HrefValue = "";
		$this->Minggu8->TooltipValue = "";

		// Minggu9
		$this->Minggu9->LinkCustomAttributes = "";
		$this->Minggu9->HrefValue = "";
		$this->Minggu9->TooltipValue = "";

		// Minggu10
		$this->Minggu10->LinkCustomAttributes = "";
		$this->Minggu10->HrefValue = "";
		$this->Minggu10->TooltipValue = "";

		// Minggu11
		$this->Minggu11->LinkCustomAttributes = "";
		$this->Minggu11->HrefValue = "";
		$this->Minggu11->TooltipValue = "";

		// Minggu12
		$this->Minggu12->LinkCustomAttributes = "";
		$this->Minggu12->HrefValue = "";
		$this->Minggu12->TooltipValue = "";

		// Minggu13
		$this->Minggu13->LinkCustomAttributes = "";
		$this->Minggu13->HrefValue = "";
		$this->Minggu13->TooltipValue = "";

		// Minggu14
		$this->Minggu14->LinkCustomAttributes = "";
		$this->Minggu14->HrefValue = "";
		$this->Minggu14->TooltipValue = "";

		// Minggu15
		$this->Minggu15->LinkCustomAttributes = "";
		$this->Minggu15->HrefValue = "";
		$this->Minggu15->TooltipValue = "";

		// Minggu16
		$this->Minggu16->LinkCustomAttributes = "";
		$this->Minggu16->HrefValue = "";
		$this->Minggu16->TooltipValue = "";

		// Persentase
		$this->Persentase->LinkCustomAttributes = "";
		$this->Persentase->HrefValue = "";
		$this->Persentase->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// IDX
		$this->IDX->EditAttrs["class"] = "form-control";
		$this->IDX->EditCustomAttributes = "";
		$this->IDX->EditValue = $this->IDX->CurrentValue;
		$this->IDX->ViewCustomAttributes = "";

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";

		// KelasAkd
		$this->KelasAkd->EditAttrs["class"] = "form-control";
		$this->KelasAkd->EditCustomAttributes = "";
		if (!$this->KelasAkd->Raw)
			$this->KelasAkd->CurrentValue = HtmlDecode($this->KelasAkd->CurrentValue);
		$this->KelasAkd->EditValue = $this->KelasAkd->CurrentValue;
		$this->KelasAkd->PlaceHolder = RemoveHtml($this->KelasAkd->caption());

		// Thn_Akademik
		$this->Thn_Akademik->EditAttrs["class"] = "form-control";
		$this->Thn_Akademik->EditCustomAttributes = "";
		if (!$this->Thn_Akademik->Raw)
			$this->Thn_Akademik->CurrentValue = HtmlDecode($this->Thn_Akademik->CurrentValue);
		$this->Thn_Akademik->EditValue = $this->Thn_Akademik->CurrentValue;
		$this->Thn_Akademik->PlaceHolder = RemoveHtml($this->Thn_Akademik->caption());

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		if (!$this->Periode->Raw)
			$this->Periode->CurrentValue = HtmlDecode($this->Periode->CurrentValue);
		$this->Periode->EditValue = $this->Periode->CurrentValue;
		$this->Periode->PlaceHolder = RemoveHtml($this->Periode->caption());

		// Kode_MK
		$this->Kode_MK->EditAttrs["class"] = "form-control";
		$this->Kode_MK->EditCustomAttributes = "";

		// kls
		$this->kls->EditAttrs["class"] = "form-control";
		$this->kls->EditCustomAttributes = "";
		if (!$this->kls->Raw)
			$this->kls->CurrentValue = HtmlDecode($this->kls->CurrentValue);
		$this->kls->EditValue = $this->kls->CurrentValue;
		$this->kls->PlaceHolder = RemoveHtml($this->kls->caption());

		// Kehadiran
		$this->Kehadiran->EditAttrs["class"] = "form-control";
		$this->Kehadiran->EditCustomAttributes = "";
		$this->Kehadiran->EditValue = $this->Kehadiran->CurrentValue;
		$this->Kehadiran->PlaceHolder = RemoveHtml($this->Kehadiran->caption());
		if (strval($this->Kehadiran->EditValue) != "" && is_numeric($this->Kehadiran->EditValue))
			$this->Kehadiran->EditValue = FormatNumber($this->Kehadiran->EditValue, -2, -2, -2, -2);
		

		// Tugas
		$this->Tugas->EditAttrs["class"] = "form-control";
		$this->Tugas->EditCustomAttributes = "";
		$this->Tugas->EditValue = $this->Tugas->CurrentValue;
		$this->Tugas->PlaceHolder = RemoveHtml($this->Tugas->caption());
		if (strval($this->Tugas->EditValue) != "" && is_numeric($this->Tugas->EditValue))
			$this->Tugas->EditValue = FormatNumber($this->Tugas->EditValue, -2, -2, -2, -2);
		

		// Quiz
		$this->Quiz->EditAttrs["class"] = "form-control";
		$this->Quiz->EditCustomAttributes = "";
		$this->Quiz->EditValue = $this->Quiz->CurrentValue;
		$this->Quiz->PlaceHolder = RemoveHtml($this->Quiz->caption());
		if (strval($this->Quiz->EditValue) != "" && is_numeric($this->Quiz->EditValue))
			$this->Quiz->EditValue = FormatNumber($this->Quiz->EditValue, -2, -2, -2, -2);
		

		// UTS
		$this->UTS->EditAttrs["class"] = "form-control";
		$this->UTS->EditCustomAttributes = "";
		$this->UTS->EditValue = $this->UTS->CurrentValue;
		$this->UTS->PlaceHolder = RemoveHtml($this->UTS->caption());
		if (strval($this->UTS->EditValue) != "" && is_numeric($this->UTS->EditValue))
			$this->UTS->EditValue = FormatNumber($this->UTS->EditValue, -2, -2, -2, -2);
		

		// UAS
		$this->UAS->EditAttrs["class"] = "form-control";
		$this->UAS->EditCustomAttributes = "";
		$this->UAS->EditValue = $this->UAS->CurrentValue;
		$this->UAS->PlaceHolder = RemoveHtml($this->UAS->caption());
		if (strval($this->UAS->EditValue) != "" && is_numeric($this->UAS->EditValue))
			$this->UAS->EditValue = FormatNumber($this->UAS->EditValue, -2, -2, -2, -2);
		

		// Jumlah
		$this->Jumlah->EditAttrs["class"] = "form-control";
		$this->Jumlah->EditCustomAttributes = "";
		$this->Jumlah->EditValue = $this->Jumlah->CurrentValue;
		$this->Jumlah->PlaceHolder = RemoveHtml($this->Jumlah->caption());
		if (strval($this->Jumlah->EditValue) != "" && is_numeric($this->Jumlah->EditValue))
			$this->Jumlah->EditValue = FormatNumber($this->Jumlah->EditValue, -2, -2, -2, -2);
		

		// Nilai
		$this->Nilai->EditAttrs["class"] = "form-control";
		$this->Nilai->EditCustomAttributes = "";
		if (!$this->Nilai->Raw)
			$this->Nilai->CurrentValue = HtmlDecode($this->Nilai->CurrentValue);
		$this->Nilai->EditValue = $this->Nilai->CurrentValue;
		$this->Nilai->PlaceHolder = RemoveHtml($this->Nilai->caption());

		// Angka
		$this->Angka->EditAttrs["class"] = "form-control";
		$this->Angka->EditCustomAttributes = "";
		$this->Angka->EditValue = $this->Angka->CurrentValue;
		$this->Angka->PlaceHolder = RemoveHtml($this->Angka->caption());
		if (strval($this->Angka->EditValue) != "" && is_numeric($this->Angka->EditValue))
			$this->Angka->EditValue = FormatNumber($this->Angka->EditValue, -2, -2, -2, -2);
		

		// kunci
		$this->kunci->EditAttrs["class"] = "form-control";
		$this->kunci->EditCustomAttributes = "";
		if (!$this->kunci->Raw)
			$this->kunci->CurrentValue = HtmlDecode($this->kunci->CurrentValue);
		$this->kunci->EditValue = $this->kunci->CurrentValue;
		$this->kunci->PlaceHolder = RemoveHtml($this->kunci->caption());

		// inp
		$this->inp->EditAttrs["class"] = "form-control";
		$this->inp->EditCustomAttributes = "";
		if (!$this->inp->Raw)
			$this->inp->CurrentValue = HtmlDecode($this->inp->CurrentValue);
		$this->inp->EditValue = $this->inp->CurrentValue;
		$this->inp->PlaceHolder = RemoveHtml($this->inp->caption());

		// Gujian
		$this->Gujian->EditAttrs["class"] = "form-control";
		$this->Gujian->EditCustomAttributes = "";
		if (!$this->Gujian->Raw)
			$this->Gujian->CurrentValue = HtmlDecode($this->Gujian->CurrentValue);
		$this->Gujian->EditValue = $this->Gujian->CurrentValue;
		$this->Gujian->PlaceHolder = RemoveHtml($this->Gujian->caption());

		// Minggu1
		$this->Minggu1->EditAttrs["class"] = "form-control";
		$this->Minggu1->EditCustomAttributes = "";
		if (!$this->Minggu1->Raw)
			$this->Minggu1->CurrentValue = HtmlDecode($this->Minggu1->CurrentValue);
		$this->Minggu1->EditValue = $this->Minggu1->CurrentValue;
		$this->Minggu1->PlaceHolder = RemoveHtml($this->Minggu1->caption());

		// Minggu2
		$this->Minggu2->EditAttrs["class"] = "form-control";
		$this->Minggu2->EditCustomAttributes = "";
		if (!$this->Minggu2->Raw)
			$this->Minggu2->CurrentValue = HtmlDecode($this->Minggu2->CurrentValue);
		$this->Minggu2->EditValue = $this->Minggu2->CurrentValue;
		$this->Minggu2->PlaceHolder = RemoveHtml($this->Minggu2->caption());

		// Minggu3
		$this->Minggu3->EditAttrs["class"] = "form-control";
		$this->Minggu3->EditCustomAttributes = "";
		if (!$this->Minggu3->Raw)
			$this->Minggu3->CurrentValue = HtmlDecode($this->Minggu3->CurrentValue);
		$this->Minggu3->EditValue = $this->Minggu3->CurrentValue;
		$this->Minggu3->PlaceHolder = RemoveHtml($this->Minggu3->caption());

		// Minggu4
		$this->Minggu4->EditAttrs["class"] = "form-control";
		$this->Minggu4->EditCustomAttributes = "";
		if (!$this->Minggu4->Raw)
			$this->Minggu4->CurrentValue = HtmlDecode($this->Minggu4->CurrentValue);
		$this->Minggu4->EditValue = $this->Minggu4->CurrentValue;
		$this->Minggu4->PlaceHolder = RemoveHtml($this->Minggu4->caption());

		// Minggu5
		$this->Minggu5->EditAttrs["class"] = "form-control";
		$this->Minggu5->EditCustomAttributes = "";
		if (!$this->Minggu5->Raw)
			$this->Minggu5->CurrentValue = HtmlDecode($this->Minggu5->CurrentValue);
		$this->Minggu5->EditValue = $this->Minggu5->CurrentValue;
		$this->Minggu5->PlaceHolder = RemoveHtml($this->Minggu5->caption());

		// Minggu6
		$this->Minggu6->EditAttrs["class"] = "form-control";
		$this->Minggu6->EditCustomAttributes = "";
		if (!$this->Minggu6->Raw)
			$this->Minggu6->CurrentValue = HtmlDecode($this->Minggu6->CurrentValue);
		$this->Minggu6->EditValue = $this->Minggu6->CurrentValue;
		$this->Minggu6->PlaceHolder = RemoveHtml($this->Minggu6->caption());

		// Minggu7
		$this->Minggu7->EditAttrs["class"] = "form-control";
		$this->Minggu7->EditCustomAttributes = "";
		if (!$this->Minggu7->Raw)
			$this->Minggu7->CurrentValue = HtmlDecode($this->Minggu7->CurrentValue);
		$this->Minggu7->EditValue = $this->Minggu7->CurrentValue;
		$this->Minggu7->PlaceHolder = RemoveHtml($this->Minggu7->caption());

		// Minggu8
		$this->Minggu8->EditAttrs["class"] = "form-control";
		$this->Minggu8->EditCustomAttributes = "";
		if (!$this->Minggu8->Raw)
			$this->Minggu8->CurrentValue = HtmlDecode($this->Minggu8->CurrentValue);
		$this->Minggu8->EditValue = $this->Minggu8->CurrentValue;
		$this->Minggu8->PlaceHolder = RemoveHtml($this->Minggu8->caption());

		// Minggu9
		$this->Minggu9->EditAttrs["class"] = "form-control";
		$this->Minggu9->EditCustomAttributes = "";
		if (!$this->Minggu9->Raw)
			$this->Minggu9->CurrentValue = HtmlDecode($this->Minggu9->CurrentValue);
		$this->Minggu9->EditValue = $this->Minggu9->CurrentValue;
		$this->Minggu9->PlaceHolder = RemoveHtml($this->Minggu9->caption());

		// Minggu10
		$this->Minggu10->EditAttrs["class"] = "form-control";
		$this->Minggu10->EditCustomAttributes = "";
		if (!$this->Minggu10->Raw)
			$this->Minggu10->CurrentValue = HtmlDecode($this->Minggu10->CurrentValue);
		$this->Minggu10->EditValue = $this->Minggu10->CurrentValue;
		$this->Minggu10->PlaceHolder = RemoveHtml($this->Minggu10->caption());

		// Minggu11
		$this->Minggu11->EditAttrs["class"] = "form-control";
		$this->Minggu11->EditCustomAttributes = "";
		if (!$this->Minggu11->Raw)
			$this->Minggu11->CurrentValue = HtmlDecode($this->Minggu11->CurrentValue);
		$this->Minggu11->EditValue = $this->Minggu11->CurrentValue;
		$this->Minggu11->PlaceHolder = RemoveHtml($this->Minggu11->caption());

		// Minggu12
		$this->Minggu12->EditAttrs["class"] = "form-control";
		$this->Minggu12->EditCustomAttributes = "";
		if (!$this->Minggu12->Raw)
			$this->Minggu12->CurrentValue = HtmlDecode($this->Minggu12->CurrentValue);
		$this->Minggu12->EditValue = $this->Minggu12->CurrentValue;
		$this->Minggu12->PlaceHolder = RemoveHtml($this->Minggu12->caption());

		// Minggu13
		$this->Minggu13->EditAttrs["class"] = "form-control";
		$this->Minggu13->EditCustomAttributes = "";
		if (!$this->Minggu13->Raw)
			$this->Minggu13->CurrentValue = HtmlDecode($this->Minggu13->CurrentValue);
		$this->Minggu13->EditValue = $this->Minggu13->CurrentValue;
		$this->Minggu13->PlaceHolder = RemoveHtml($this->Minggu13->caption());

		// Minggu14
		$this->Minggu14->EditAttrs["class"] = "form-control";
		$this->Minggu14->EditCustomAttributes = "";
		if (!$this->Minggu14->Raw)
			$this->Minggu14->CurrentValue = HtmlDecode($this->Minggu14->CurrentValue);
		$this->Minggu14->EditValue = $this->Minggu14->CurrentValue;
		$this->Minggu14->PlaceHolder = RemoveHtml($this->Minggu14->caption());

		// Minggu15
		$this->Minggu15->EditAttrs["class"] = "form-control";
		$this->Minggu15->EditCustomAttributes = "";
		if (!$this->Minggu15->Raw)
			$this->Minggu15->CurrentValue = HtmlDecode($this->Minggu15->CurrentValue);
		$this->Minggu15->EditValue = $this->Minggu15->CurrentValue;
		$this->Minggu15->PlaceHolder = RemoveHtml($this->Minggu15->caption());

		// Minggu16
		$this->Minggu16->EditAttrs["class"] = "form-control";
		$this->Minggu16->EditCustomAttributes = "";
		if (!$this->Minggu16->Raw)
			$this->Minggu16->CurrentValue = HtmlDecode($this->Minggu16->CurrentValue);
		$this->Minggu16->EditValue = $this->Minggu16->CurrentValue;
		$this->Minggu16->PlaceHolder = RemoveHtml($this->Minggu16->caption());

		// Persentase
		$this->Persentase->EditAttrs["class"] = "form-control";
		$this->Persentase->EditCustomAttributes = "";
		$this->Persentase->EditValue = $this->Persentase->CurrentValue;
		$this->Persentase->PlaceHolder = RemoveHtml($this->Persentase->caption());
		if (strval($this->Persentase->EditValue) != "" && is_numeric($this->Persentase->EditValue))
			$this->Persentase->EditValue = FormatNumber($this->Persentase->EditValue, -2, -2, -2, -2);
		

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->IDX);
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->KelasAkd);
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kode_MK);
					$doc->exportCaption($this->kls);
					$doc->exportCaption($this->Kehadiran);
					$doc->exportCaption($this->Tugas);
					$doc->exportCaption($this->Quiz);
					$doc->exportCaption($this->UTS);
					$doc->exportCaption($this->UAS);
					$doc->exportCaption($this->Jumlah);
					$doc->exportCaption($this->Nilai);
					$doc->exportCaption($this->Angka);
					$doc->exportCaption($this->kunci);
					$doc->exportCaption($this->inp);
					$doc->exportCaption($this->Gujian);
					$doc->exportCaption($this->Minggu1);
					$doc->exportCaption($this->Minggu2);
					$doc->exportCaption($this->Minggu3);
					$doc->exportCaption($this->Minggu4);
					$doc->exportCaption($this->Minggu5);
					$doc->exportCaption($this->Minggu6);
					$doc->exportCaption($this->Minggu7);
					$doc->exportCaption($this->Minggu8);
					$doc->exportCaption($this->Minggu9);
					$doc->exportCaption($this->Minggu10);
					$doc->exportCaption($this->Minggu11);
					$doc->exportCaption($this->Minggu12);
					$doc->exportCaption($this->Minggu13);
					$doc->exportCaption($this->Minggu14);
					$doc->exportCaption($this->Minggu15);
					$doc->exportCaption($this->Minggu16);
					$doc->exportCaption($this->Persentase);
				} else {
					$doc->exportCaption($this->IDX);
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->KelasAkd);
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kode_MK);
					$doc->exportCaption($this->kls);
					$doc->exportCaption($this->Kehadiran);
					$doc->exportCaption($this->Tugas);
					$doc->exportCaption($this->Quiz);
					$doc->exportCaption($this->UTS);
					$doc->exportCaption($this->UAS);
					$doc->exportCaption($this->Jumlah);
					$doc->exportCaption($this->Nilai);
					$doc->exportCaption($this->Angka);
					$doc->exportCaption($this->kunci);
					$doc->exportCaption($this->inp);
					$doc->exportCaption($this->Gujian);
					$doc->exportCaption($this->Minggu1);
					$doc->exportCaption($this->Minggu2);
					$doc->exportCaption($this->Minggu3);
					$doc->exportCaption($this->Minggu4);
					$doc->exportCaption($this->Minggu5);
					$doc->exportCaption($this->Minggu6);
					$doc->exportCaption($this->Minggu7);
					$doc->exportCaption($this->Minggu8);
					$doc->exportCaption($this->Minggu9);
					$doc->exportCaption($this->Minggu10);
					$doc->exportCaption($this->Minggu11);
					$doc->exportCaption($this->Minggu12);
					$doc->exportCaption($this->Minggu13);
					$doc->exportCaption($this->Minggu14);
					$doc->exportCaption($this->Minggu15);
					$doc->exportCaption($this->Minggu16);
					$doc->exportCaption($this->Persentase);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->IDX);
						$doc->exportField($this->Nim);
						$doc->exportField($this->KelasAkd);
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kode_MK);
						$doc->exportField($this->kls);
						$doc->exportField($this->Kehadiran);
						$doc->exportField($this->Tugas);
						$doc->exportField($this->Quiz);
						$doc->exportField($this->UTS);
						$doc->exportField($this->UAS);
						$doc->exportField($this->Jumlah);
						$doc->exportField($this->Nilai);
						$doc->exportField($this->Angka);
						$doc->exportField($this->kunci);
						$doc->exportField($this->inp);
						$doc->exportField($this->Gujian);
						$doc->exportField($this->Minggu1);
						$doc->exportField($this->Minggu2);
						$doc->exportField($this->Minggu3);
						$doc->exportField($this->Minggu4);
						$doc->exportField($this->Minggu5);
						$doc->exportField($this->Minggu6);
						$doc->exportField($this->Minggu7);
						$doc->exportField($this->Minggu8);
						$doc->exportField($this->Minggu9);
						$doc->exportField($this->Minggu10);
						$doc->exportField($this->Minggu11);
						$doc->exportField($this->Minggu12);
						$doc->exportField($this->Minggu13);
						$doc->exportField($this->Minggu14);
						$doc->exportField($this->Minggu15);
						$doc->exportField($this->Minggu16);
						$doc->exportField($this->Persentase);
					} else {
						$doc->exportField($this->IDX);
						$doc->exportField($this->Nim);
						$doc->exportField($this->KelasAkd);
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kode_MK);
						$doc->exportField($this->kls);
						$doc->exportField($this->Kehadiran);
						$doc->exportField($this->Tugas);
						$doc->exportField($this->Quiz);
						$doc->exportField($this->UTS);
						$doc->exportField($this->UAS);
						$doc->exportField($this->Jumlah);
						$doc->exportField($this->Nilai);
						$doc->exportField($this->Angka);
						$doc->exportField($this->kunci);
						$doc->exportField($this->inp);
						$doc->exportField($this->Gujian);
						$doc->exportField($this->Minggu1);
						$doc->exportField($this->Minggu2);
						$doc->exportField($this->Minggu3);
						$doc->exportField($this->Minggu4);
						$doc->exportField($this->Minggu5);
						$doc->exportField($this->Minggu6);
						$doc->exportField($this->Minggu7);
						$doc->exportField($this->Minggu8);
						$doc->exportField($this->Minggu9);
						$doc->exportField($this->Minggu10);
						$doc->exportField($this->Minggu11);
						$doc->exportField($this->Minggu12);
						$doc->exportField($this->Minggu13);
						$doc->exportField($this->Minggu14);
						$doc->exportField($this->Minggu15);
						$doc->exportField($this->Minggu16);
						$doc->exportField($this->Persentase);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>