<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class HtblNilai_list extends HtblNilai
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'HtblNilai';

	// Page object name
	public $PageObjName = "HtblNilai_list";

	// Grid form hidden field names
	public $FormName = "fHtblNilailist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (HtblNilai)
		if (!isset($GLOBALS["HtblNilai"]) || get_class($GLOBALS["HtblNilai"]) == PROJECT_NAMESPACE . "HtblNilai") {
			$GLOBALS["HtblNilai"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["HtblNilai"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "HtblNilaiadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "HtblNilaidelete.php";
		$this->MultiUpdateUrl = "HtblNilaiupdate.php";

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'HtblNilai');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option fHtblNilailistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $HtblNilai;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($HtblNilai);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0)
							$val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['IDX'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->IDX->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "15,20,30,90,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canList()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom != "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (Config("USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (Config("USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->IDX->Visible = FALSE;
		$this->Nim->setVisibility();
		$this->KelasAkd->setVisibility();
		$this->Thn_Akademik->setVisibility();
		$this->Periode->setVisibility();
		$this->Kode_MK->setVisibility();
		$this->kls->setVisibility();
		$this->Kehadiran->setVisibility();
		$this->Tugas->setVisibility();
		$this->Quiz->Visible = FALSE;
		$this->UTS->setVisibility();
		$this->UAS->setVisibility();
		$this->Jumlah->setVisibility();
		$this->Nilai->setVisibility();
		$this->Angka->setVisibility();
		$this->kunci->Visible = FALSE;
		$this->inp->Visible = FALSE;
		$this->Gujian->Visible = FALSE;
		$this->Minggu1->Visible = FALSE;
		$this->Minggu2->Visible = FALSE;
		$this->Minggu3->Visible = FALSE;
		$this->Minggu4->Visible = FALSE;
		$this->Minggu5->Visible = FALSE;
		$this->Minggu6->Visible = FALSE;
		$this->Minggu7->Visible = FALSE;
		$this->Minggu8->Visible = FALSE;
		$this->Minggu9->Visible = FALSE;
		$this->Minggu10->Visible = FALSE;
		$this->Minggu11->Visible = FALSE;
		$this->Minggu12->Visible = FALSE;
		$this->Minggu13->Visible = FALSE;
		$this->Minggu14->Visible = FALSE;
		$this->Minggu15->Visible = FALSE;
		$this->Minggu16->Visible = FALSE;
		$this->Persentase->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->Nim);
		$this->setupLookupOptions($this->Kode_MK);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->IDX->setOldValue($arKeyFlds[0]);
			if (!is_numeric($this->IDX->OldValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->IDX->AdvancedSearch->toJson(), ","); // Field IDX
		$filterList = Concat($filterList, $this->Nim->AdvancedSearch->toJson(), ","); // Field Nim
		$filterList = Concat($filterList, $this->KelasAkd->AdvancedSearch->toJson(), ","); // Field KelasAkd
		$filterList = Concat($filterList, $this->Thn_Akademik->AdvancedSearch->toJson(), ","); // Field Thn_Akademik
		$filterList = Concat($filterList, $this->Periode->AdvancedSearch->toJson(), ","); // Field Periode
		$filterList = Concat($filterList, $this->Kode_MK->AdvancedSearch->toJson(), ","); // Field Kode_MK
		$filterList = Concat($filterList, $this->kls->AdvancedSearch->toJson(), ","); // Field kls
		$filterList = Concat($filterList, $this->Kehadiran->AdvancedSearch->toJson(), ","); // Field Kehadiran
		$filterList = Concat($filterList, $this->Tugas->AdvancedSearch->toJson(), ","); // Field Tugas
		$filterList = Concat($filterList, $this->Quiz->AdvancedSearch->toJson(), ","); // Field Quiz
		$filterList = Concat($filterList, $this->UTS->AdvancedSearch->toJson(), ","); // Field UTS
		$filterList = Concat($filterList, $this->UAS->AdvancedSearch->toJson(), ","); // Field UAS
		$filterList = Concat($filterList, $this->Jumlah->AdvancedSearch->toJson(), ","); // Field Jumlah
		$filterList = Concat($filterList, $this->Nilai->AdvancedSearch->toJson(), ","); // Field Nilai
		$filterList = Concat($filterList, $this->Angka->AdvancedSearch->toJson(), ","); // Field Angka
		$filterList = Concat($filterList, $this->kunci->AdvancedSearch->toJson(), ","); // Field kunci
		$filterList = Concat($filterList, $this->inp->AdvancedSearch->toJson(), ","); // Field inp
		$filterList = Concat($filterList, $this->Gujian->AdvancedSearch->toJson(), ","); // Field Gujian
		$filterList = Concat($filterList, $this->Minggu1->AdvancedSearch->toJson(), ","); // Field Minggu1
		$filterList = Concat($filterList, $this->Minggu2->AdvancedSearch->toJson(), ","); // Field Minggu2
		$filterList = Concat($filterList, $this->Minggu3->AdvancedSearch->toJson(), ","); // Field Minggu3
		$filterList = Concat($filterList, $this->Minggu4->AdvancedSearch->toJson(), ","); // Field Minggu4
		$filterList = Concat($filterList, $this->Minggu5->AdvancedSearch->toJson(), ","); // Field Minggu5
		$filterList = Concat($filterList, $this->Minggu6->AdvancedSearch->toJson(), ","); // Field Minggu6
		$filterList = Concat($filterList, $this->Minggu7->AdvancedSearch->toJson(), ","); // Field Minggu7
		$filterList = Concat($filterList, $this->Minggu8->AdvancedSearch->toJson(), ","); // Field Minggu8
		$filterList = Concat($filterList, $this->Minggu9->AdvancedSearch->toJson(), ","); // Field Minggu9
		$filterList = Concat($filterList, $this->Minggu10->AdvancedSearch->toJson(), ","); // Field Minggu10
		$filterList = Concat($filterList, $this->Minggu11->AdvancedSearch->toJson(), ","); // Field Minggu11
		$filterList = Concat($filterList, $this->Minggu12->AdvancedSearch->toJson(), ","); // Field Minggu12
		$filterList = Concat($filterList, $this->Minggu13->AdvancedSearch->toJson(), ","); // Field Minggu13
		$filterList = Concat($filterList, $this->Minggu14->AdvancedSearch->toJson(), ","); // Field Minggu14
		$filterList = Concat($filterList, $this->Minggu15->AdvancedSearch->toJson(), ","); // Field Minggu15
		$filterList = Concat($filterList, $this->Minggu16->AdvancedSearch->toJson(), ","); // Field Minggu16
		$filterList = Concat($filterList, $this->Persentase->AdvancedSearch->toJson(), ","); // Field Persentase
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fHtblNilailistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field IDX
		$this->IDX->AdvancedSearch->SearchValue = @$filter["x_IDX"];
		$this->IDX->AdvancedSearch->SearchOperator = @$filter["z_IDX"];
		$this->IDX->AdvancedSearch->SearchCondition = @$filter["v_IDX"];
		$this->IDX->AdvancedSearch->SearchValue2 = @$filter["y_IDX"];
		$this->IDX->AdvancedSearch->SearchOperator2 = @$filter["w_IDX"];
		$this->IDX->AdvancedSearch->save();

		// Field Nim
		$this->Nim->AdvancedSearch->SearchValue = @$filter["x_Nim"];
		$this->Nim->AdvancedSearch->SearchOperator = @$filter["z_Nim"];
		$this->Nim->AdvancedSearch->SearchCondition = @$filter["v_Nim"];
		$this->Nim->AdvancedSearch->SearchValue2 = @$filter["y_Nim"];
		$this->Nim->AdvancedSearch->SearchOperator2 = @$filter["w_Nim"];
		$this->Nim->AdvancedSearch->save();

		// Field KelasAkd
		$this->KelasAkd->AdvancedSearch->SearchValue = @$filter["x_KelasAkd"];
		$this->KelasAkd->AdvancedSearch->SearchOperator = @$filter["z_KelasAkd"];
		$this->KelasAkd->AdvancedSearch->SearchCondition = @$filter["v_KelasAkd"];
		$this->KelasAkd->AdvancedSearch->SearchValue2 = @$filter["y_KelasAkd"];
		$this->KelasAkd->AdvancedSearch->SearchOperator2 = @$filter["w_KelasAkd"];
		$this->KelasAkd->AdvancedSearch->save();

		// Field Thn_Akademik
		$this->Thn_Akademik->AdvancedSearch->SearchValue = @$filter["x_Thn_Akademik"];
		$this->Thn_Akademik->AdvancedSearch->SearchOperator = @$filter["z_Thn_Akademik"];
		$this->Thn_Akademik->AdvancedSearch->SearchCondition = @$filter["v_Thn_Akademik"];
		$this->Thn_Akademik->AdvancedSearch->SearchValue2 = @$filter["y_Thn_Akademik"];
		$this->Thn_Akademik->AdvancedSearch->SearchOperator2 = @$filter["w_Thn_Akademik"];
		$this->Thn_Akademik->AdvancedSearch->save();

		// Field Periode
		$this->Periode->AdvancedSearch->SearchValue = @$filter["x_Periode"];
		$this->Periode->AdvancedSearch->SearchOperator = @$filter["z_Periode"];
		$this->Periode->AdvancedSearch->SearchCondition = @$filter["v_Periode"];
		$this->Periode->AdvancedSearch->SearchValue2 = @$filter["y_Periode"];
		$this->Periode->AdvancedSearch->SearchOperator2 = @$filter["w_Periode"];
		$this->Periode->AdvancedSearch->save();

		// Field Kode_MK
		$this->Kode_MK->AdvancedSearch->SearchValue = @$filter["x_Kode_MK"];
		$this->Kode_MK->AdvancedSearch->SearchOperator = @$filter["z_Kode_MK"];
		$this->Kode_MK->AdvancedSearch->SearchCondition = @$filter["v_Kode_MK"];
		$this->Kode_MK->AdvancedSearch->SearchValue2 = @$filter["y_Kode_MK"];
		$this->Kode_MK->AdvancedSearch->SearchOperator2 = @$filter["w_Kode_MK"];
		$this->Kode_MK->AdvancedSearch->save();

		// Field kls
		$this->kls->AdvancedSearch->SearchValue = @$filter["x_kls"];
		$this->kls->AdvancedSearch->SearchOperator = @$filter["z_kls"];
		$this->kls->AdvancedSearch->SearchCondition = @$filter["v_kls"];
		$this->kls->AdvancedSearch->SearchValue2 = @$filter["y_kls"];
		$this->kls->AdvancedSearch->SearchOperator2 = @$filter["w_kls"];
		$this->kls->AdvancedSearch->save();

		// Field Kehadiran
		$this->Kehadiran->AdvancedSearch->SearchValue = @$filter["x_Kehadiran"];
		$this->Kehadiran->AdvancedSearch->SearchOperator = @$filter["z_Kehadiran"];
		$this->Kehadiran->AdvancedSearch->SearchCondition = @$filter["v_Kehadiran"];
		$this->Kehadiran->AdvancedSearch->SearchValue2 = @$filter["y_Kehadiran"];
		$this->Kehadiran->AdvancedSearch->SearchOperator2 = @$filter["w_Kehadiran"];
		$this->Kehadiran->AdvancedSearch->save();

		// Field Tugas
		$this->Tugas->AdvancedSearch->SearchValue = @$filter["x_Tugas"];
		$this->Tugas->AdvancedSearch->SearchOperator = @$filter["z_Tugas"];
		$this->Tugas->AdvancedSearch->SearchCondition = @$filter["v_Tugas"];
		$this->Tugas->AdvancedSearch->SearchValue2 = @$filter["y_Tugas"];
		$this->Tugas->AdvancedSearch->SearchOperator2 = @$filter["w_Tugas"];
		$this->Tugas->AdvancedSearch->save();

		// Field Quiz
		$this->Quiz->AdvancedSearch->SearchValue = @$filter["x_Quiz"];
		$this->Quiz->AdvancedSearch->SearchOperator = @$filter["z_Quiz"];
		$this->Quiz->AdvancedSearch->SearchCondition = @$filter["v_Quiz"];
		$this->Quiz->AdvancedSearch->SearchValue2 = @$filter["y_Quiz"];
		$this->Quiz->AdvancedSearch->SearchOperator2 = @$filter["w_Quiz"];
		$this->Quiz->AdvancedSearch->save();

		// Field UTS
		$this->UTS->AdvancedSearch->SearchValue = @$filter["x_UTS"];
		$this->UTS->AdvancedSearch->SearchOperator = @$filter["z_UTS"];
		$this->UTS->AdvancedSearch->SearchCondition = @$filter["v_UTS"];
		$this->UTS->AdvancedSearch->SearchValue2 = @$filter["y_UTS"];
		$this->UTS->AdvancedSearch->SearchOperator2 = @$filter["w_UTS"];
		$this->UTS->AdvancedSearch->save();

		// Field UAS
		$this->UAS->AdvancedSearch->SearchValue = @$filter["x_UAS"];
		$this->UAS->AdvancedSearch->SearchOperator = @$filter["z_UAS"];
		$this->UAS->AdvancedSearch->SearchCondition = @$filter["v_UAS"];
		$this->UAS->AdvancedSearch->SearchValue2 = @$filter["y_UAS"];
		$this->UAS->AdvancedSearch->SearchOperator2 = @$filter["w_UAS"];
		$this->UAS->AdvancedSearch->save();

		// Field Jumlah
		$this->Jumlah->AdvancedSearch->SearchValue = @$filter["x_Jumlah"];
		$this->Jumlah->AdvancedSearch->SearchOperator = @$filter["z_Jumlah"];
		$this->Jumlah->AdvancedSearch->SearchCondition = @$filter["v_Jumlah"];
		$this->Jumlah->AdvancedSearch->SearchValue2 = @$filter["y_Jumlah"];
		$this->Jumlah->AdvancedSearch->SearchOperator2 = @$filter["w_Jumlah"];
		$this->Jumlah->AdvancedSearch->save();

		// Field Nilai
		$this->Nilai->AdvancedSearch->SearchValue = @$filter["x_Nilai"];
		$this->Nilai->AdvancedSearch->SearchOperator = @$filter["z_Nilai"];
		$this->Nilai->AdvancedSearch->SearchCondition = @$filter["v_Nilai"];
		$this->Nilai->AdvancedSearch->SearchValue2 = @$filter["y_Nilai"];
		$this->Nilai->AdvancedSearch->SearchOperator2 = @$filter["w_Nilai"];
		$this->Nilai->AdvancedSearch->save();

		// Field Angka
		$this->Angka->AdvancedSearch->SearchValue = @$filter["x_Angka"];
		$this->Angka->AdvancedSearch->SearchOperator = @$filter["z_Angka"];
		$this->Angka->AdvancedSearch->SearchCondition = @$filter["v_Angka"];
		$this->Angka->AdvancedSearch->SearchValue2 = @$filter["y_Angka"];
		$this->Angka->AdvancedSearch->SearchOperator2 = @$filter["w_Angka"];
		$this->Angka->AdvancedSearch->save();

		// Field kunci
		$this->kunci->AdvancedSearch->SearchValue = @$filter["x_kunci"];
		$this->kunci->AdvancedSearch->SearchOperator = @$filter["z_kunci"];
		$this->kunci->AdvancedSearch->SearchCondition = @$filter["v_kunci"];
		$this->kunci->AdvancedSearch->SearchValue2 = @$filter["y_kunci"];
		$this->kunci->AdvancedSearch->SearchOperator2 = @$filter["w_kunci"];
		$this->kunci->AdvancedSearch->save();

		// Field inp
		$this->inp->AdvancedSearch->SearchValue = @$filter["x_inp"];
		$this->inp->AdvancedSearch->SearchOperator = @$filter["z_inp"];
		$this->inp->AdvancedSearch->SearchCondition = @$filter["v_inp"];
		$this->inp->AdvancedSearch->SearchValue2 = @$filter["y_inp"];
		$this->inp->AdvancedSearch->SearchOperator2 = @$filter["w_inp"];
		$this->inp->AdvancedSearch->save();

		// Field Gujian
		$this->Gujian->AdvancedSearch->SearchValue = @$filter["x_Gujian"];
		$this->Gujian->AdvancedSearch->SearchOperator = @$filter["z_Gujian"];
		$this->Gujian->AdvancedSearch->SearchCondition = @$filter["v_Gujian"];
		$this->Gujian->AdvancedSearch->SearchValue2 = @$filter["y_Gujian"];
		$this->Gujian->AdvancedSearch->SearchOperator2 = @$filter["w_Gujian"];
		$this->Gujian->AdvancedSearch->save();

		// Field Minggu1
		$this->Minggu1->AdvancedSearch->SearchValue = @$filter["x_Minggu1"];
		$this->Minggu1->AdvancedSearch->SearchOperator = @$filter["z_Minggu1"];
		$this->Minggu1->AdvancedSearch->SearchCondition = @$filter["v_Minggu1"];
		$this->Minggu1->AdvancedSearch->SearchValue2 = @$filter["y_Minggu1"];
		$this->Minggu1->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu1"];
		$this->Minggu1->AdvancedSearch->save();

		// Field Minggu2
		$this->Minggu2->AdvancedSearch->SearchValue = @$filter["x_Minggu2"];
		$this->Minggu2->AdvancedSearch->SearchOperator = @$filter["z_Minggu2"];
		$this->Minggu2->AdvancedSearch->SearchCondition = @$filter["v_Minggu2"];
		$this->Minggu2->AdvancedSearch->SearchValue2 = @$filter["y_Minggu2"];
		$this->Minggu2->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu2"];
		$this->Minggu2->AdvancedSearch->save();

		// Field Minggu3
		$this->Minggu3->AdvancedSearch->SearchValue = @$filter["x_Minggu3"];
		$this->Minggu3->AdvancedSearch->SearchOperator = @$filter["z_Minggu3"];
		$this->Minggu3->AdvancedSearch->SearchCondition = @$filter["v_Minggu3"];
		$this->Minggu3->AdvancedSearch->SearchValue2 = @$filter["y_Minggu3"];
		$this->Minggu3->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu3"];
		$this->Minggu3->AdvancedSearch->save();

		// Field Minggu4
		$this->Minggu4->AdvancedSearch->SearchValue = @$filter["x_Minggu4"];
		$this->Minggu4->AdvancedSearch->SearchOperator = @$filter["z_Minggu4"];
		$this->Minggu4->AdvancedSearch->SearchCondition = @$filter["v_Minggu4"];
		$this->Minggu4->AdvancedSearch->SearchValue2 = @$filter["y_Minggu4"];
		$this->Minggu4->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu4"];
		$this->Minggu4->AdvancedSearch->save();

		// Field Minggu5
		$this->Minggu5->AdvancedSearch->SearchValue = @$filter["x_Minggu5"];
		$this->Minggu5->AdvancedSearch->SearchOperator = @$filter["z_Minggu5"];
		$this->Minggu5->AdvancedSearch->SearchCondition = @$filter["v_Minggu5"];
		$this->Minggu5->AdvancedSearch->SearchValue2 = @$filter["y_Minggu5"];
		$this->Minggu5->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu5"];
		$this->Minggu5->AdvancedSearch->save();

		// Field Minggu6
		$this->Minggu6->AdvancedSearch->SearchValue = @$filter["x_Minggu6"];
		$this->Minggu6->AdvancedSearch->SearchOperator = @$filter["z_Minggu6"];
		$this->Minggu6->AdvancedSearch->SearchCondition = @$filter["v_Minggu6"];
		$this->Minggu6->AdvancedSearch->SearchValue2 = @$filter["y_Minggu6"];
		$this->Minggu6->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu6"];
		$this->Minggu6->AdvancedSearch->save();

		// Field Minggu7
		$this->Minggu7->AdvancedSearch->SearchValue = @$filter["x_Minggu7"];
		$this->Minggu7->AdvancedSearch->SearchOperator = @$filter["z_Minggu7"];
		$this->Minggu7->AdvancedSearch->SearchCondition = @$filter["v_Minggu7"];
		$this->Minggu7->AdvancedSearch->SearchValue2 = @$filter["y_Minggu7"];
		$this->Minggu7->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu7"];
		$this->Minggu7->AdvancedSearch->save();

		// Field Minggu8
		$this->Minggu8->AdvancedSearch->SearchValue = @$filter["x_Minggu8"];
		$this->Minggu8->AdvancedSearch->SearchOperator = @$filter["z_Minggu8"];
		$this->Minggu8->AdvancedSearch->SearchCondition = @$filter["v_Minggu8"];
		$this->Minggu8->AdvancedSearch->SearchValue2 = @$filter["y_Minggu8"];
		$this->Minggu8->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu8"];
		$this->Minggu8->AdvancedSearch->save();

		// Field Minggu9
		$this->Minggu9->AdvancedSearch->SearchValue = @$filter["x_Minggu9"];
		$this->Minggu9->AdvancedSearch->SearchOperator = @$filter["z_Minggu9"];
		$this->Minggu9->AdvancedSearch->SearchCondition = @$filter["v_Minggu9"];
		$this->Minggu9->AdvancedSearch->SearchValue2 = @$filter["y_Minggu9"];
		$this->Minggu9->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu9"];
		$this->Minggu9->AdvancedSearch->save();

		// Field Minggu10
		$this->Minggu10->AdvancedSearch->SearchValue = @$filter["x_Minggu10"];
		$this->Minggu10->AdvancedSearch->SearchOperator = @$filter["z_Minggu10"];
		$this->Minggu10->AdvancedSearch->SearchCondition = @$filter["v_Minggu10"];
		$this->Minggu10->AdvancedSearch->SearchValue2 = @$filter["y_Minggu10"];
		$this->Minggu10->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu10"];
		$this->Minggu10->AdvancedSearch->save();

		// Field Minggu11
		$this->Minggu11->AdvancedSearch->SearchValue = @$filter["x_Minggu11"];
		$this->Minggu11->AdvancedSearch->SearchOperator = @$filter["z_Minggu11"];
		$this->Minggu11->AdvancedSearch->SearchCondition = @$filter["v_Minggu11"];
		$this->Minggu11->AdvancedSearch->SearchValue2 = @$filter["y_Minggu11"];
		$this->Minggu11->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu11"];
		$this->Minggu11->AdvancedSearch->save();

		// Field Minggu12
		$this->Minggu12->AdvancedSearch->SearchValue = @$filter["x_Minggu12"];
		$this->Minggu12->AdvancedSearch->SearchOperator = @$filter["z_Minggu12"];
		$this->Minggu12->AdvancedSearch->SearchCondition = @$filter["v_Minggu12"];
		$this->Minggu12->AdvancedSearch->SearchValue2 = @$filter["y_Minggu12"];
		$this->Minggu12->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu12"];
		$this->Minggu12->AdvancedSearch->save();

		// Field Minggu13
		$this->Minggu13->AdvancedSearch->SearchValue = @$filter["x_Minggu13"];
		$this->Minggu13->AdvancedSearch->SearchOperator = @$filter["z_Minggu13"];
		$this->Minggu13->AdvancedSearch->SearchCondition = @$filter["v_Minggu13"];
		$this->Minggu13->AdvancedSearch->SearchValue2 = @$filter["y_Minggu13"];
		$this->Minggu13->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu13"];
		$this->Minggu13->AdvancedSearch->save();

		// Field Minggu14
		$this->Minggu14->AdvancedSearch->SearchValue = @$filter["x_Minggu14"];
		$this->Minggu14->AdvancedSearch->SearchOperator = @$filter["z_Minggu14"];
		$this->Minggu14->AdvancedSearch->SearchCondition = @$filter["v_Minggu14"];
		$this->Minggu14->AdvancedSearch->SearchValue2 = @$filter["y_Minggu14"];
		$this->Minggu14->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu14"];
		$this->Minggu14->AdvancedSearch->save();

		// Field Minggu15
		$this->Minggu15->AdvancedSearch->SearchValue = @$filter["x_Minggu15"];
		$this->Minggu15->AdvancedSearch->SearchOperator = @$filter["z_Minggu15"];
		$this->Minggu15->AdvancedSearch->SearchCondition = @$filter["v_Minggu15"];
		$this->Minggu15->AdvancedSearch->SearchValue2 = @$filter["y_Minggu15"];
		$this->Minggu15->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu15"];
		$this->Minggu15->AdvancedSearch->save();

		// Field Minggu16
		$this->Minggu16->AdvancedSearch->SearchValue = @$filter["x_Minggu16"];
		$this->Minggu16->AdvancedSearch->SearchOperator = @$filter["z_Minggu16"];
		$this->Minggu16->AdvancedSearch->SearchCondition = @$filter["v_Minggu16"];
		$this->Minggu16->AdvancedSearch->SearchValue2 = @$filter["y_Minggu16"];
		$this->Minggu16->AdvancedSearch->SearchOperator2 = @$filter["w_Minggu16"];
		$this->Minggu16->AdvancedSearch->save();

		// Field Persentase
		$this->Persentase->AdvancedSearch->SearchValue = @$filter["x_Persentase"];
		$this->Persentase->AdvancedSearch->SearchOperator = @$filter["z_Persentase"];
		$this->Persentase->AdvancedSearch->SearchCondition = @$filter["v_Persentase"];
		$this->Persentase->AdvancedSearch->SearchValue2 = @$filter["y_Persentase"];
		$this->Persentase->AdvancedSearch->SearchOperator2 = @$filter["w_Persentase"];
		$this->Persentase->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->IDX, $default, FALSE); // IDX
		$this->buildSearchSql($where, $this->Nim, $default, FALSE); // Nim
		$this->buildSearchSql($where, $this->KelasAkd, $default, FALSE); // KelasAkd
		$this->buildSearchSql($where, $this->Thn_Akademik, $default, FALSE); // Thn_Akademik
		$this->buildSearchSql($where, $this->Periode, $default, FALSE); // Periode
		$this->buildSearchSql($where, $this->Kode_MK, $default, FALSE); // Kode_MK
		$this->buildSearchSql($where, $this->kls, $default, FALSE); // kls
		$this->buildSearchSql($where, $this->Kehadiran, $default, FALSE); // Kehadiran
		$this->buildSearchSql($where, $this->Tugas, $default, FALSE); // Tugas
		$this->buildSearchSql($where, $this->Quiz, $default, FALSE); // Quiz
		$this->buildSearchSql($where, $this->UTS, $default, FALSE); // UTS
		$this->buildSearchSql($where, $this->UAS, $default, FALSE); // UAS
		$this->buildSearchSql($where, $this->Jumlah, $default, FALSE); // Jumlah
		$this->buildSearchSql($where, $this->Nilai, $default, FALSE); // Nilai
		$this->buildSearchSql($where, $this->Angka, $default, FALSE); // Angka
		$this->buildSearchSql($where, $this->kunci, $default, FALSE); // kunci
		$this->buildSearchSql($where, $this->inp, $default, FALSE); // inp
		$this->buildSearchSql($where, $this->Gujian, $default, FALSE); // Gujian
		$this->buildSearchSql($where, $this->Minggu1, $default, FALSE); // Minggu1
		$this->buildSearchSql($where, $this->Minggu2, $default, FALSE); // Minggu2
		$this->buildSearchSql($where, $this->Minggu3, $default, FALSE); // Minggu3
		$this->buildSearchSql($where, $this->Minggu4, $default, FALSE); // Minggu4
		$this->buildSearchSql($where, $this->Minggu5, $default, FALSE); // Minggu5
		$this->buildSearchSql($where, $this->Minggu6, $default, FALSE); // Minggu6
		$this->buildSearchSql($where, $this->Minggu7, $default, FALSE); // Minggu7
		$this->buildSearchSql($where, $this->Minggu8, $default, FALSE); // Minggu8
		$this->buildSearchSql($where, $this->Minggu9, $default, FALSE); // Minggu9
		$this->buildSearchSql($where, $this->Minggu10, $default, FALSE); // Minggu10
		$this->buildSearchSql($where, $this->Minggu11, $default, FALSE); // Minggu11
		$this->buildSearchSql($where, $this->Minggu12, $default, FALSE); // Minggu12
		$this->buildSearchSql($where, $this->Minggu13, $default, FALSE); // Minggu13
		$this->buildSearchSql($where, $this->Minggu14, $default, FALSE); // Minggu14
		$this->buildSearchSql($where, $this->Minggu15, $default, FALSE); // Minggu15
		$this->buildSearchSql($where, $this->Minggu16, $default, FALSE); // Minggu16
		$this->buildSearchSql($where, $this->Persentase, $default, FALSE); // Persentase

		// Set up search parm
		if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->IDX->AdvancedSearch->save(); // IDX
			$this->Nim->AdvancedSearch->save(); // Nim
			$this->KelasAkd->AdvancedSearch->save(); // KelasAkd
			$this->Thn_Akademik->AdvancedSearch->save(); // Thn_Akademik
			$this->Periode->AdvancedSearch->save(); // Periode
			$this->Kode_MK->AdvancedSearch->save(); // Kode_MK
			$this->kls->AdvancedSearch->save(); // kls
			$this->Kehadiran->AdvancedSearch->save(); // Kehadiran
			$this->Tugas->AdvancedSearch->save(); // Tugas
			$this->Quiz->AdvancedSearch->save(); // Quiz
			$this->UTS->AdvancedSearch->save(); // UTS
			$this->UAS->AdvancedSearch->save(); // UAS
			$this->Jumlah->AdvancedSearch->save(); // Jumlah
			$this->Nilai->AdvancedSearch->save(); // Nilai
			$this->Angka->AdvancedSearch->save(); // Angka
			$this->kunci->AdvancedSearch->save(); // kunci
			$this->inp->AdvancedSearch->save(); // inp
			$this->Gujian->AdvancedSearch->save(); // Gujian
			$this->Minggu1->AdvancedSearch->save(); // Minggu1
			$this->Minggu2->AdvancedSearch->save(); // Minggu2
			$this->Minggu3->AdvancedSearch->save(); // Minggu3
			$this->Minggu4->AdvancedSearch->save(); // Minggu4
			$this->Minggu5->AdvancedSearch->save(); // Minggu5
			$this->Minggu6->AdvancedSearch->save(); // Minggu6
			$this->Minggu7->AdvancedSearch->save(); // Minggu7
			$this->Minggu8->AdvancedSearch->save(); // Minggu8
			$this->Minggu9->AdvancedSearch->save(); // Minggu9
			$this->Minggu10->AdvancedSearch->save(); // Minggu10
			$this->Minggu11->AdvancedSearch->save(); // Minggu11
			$this->Minggu12->AdvancedSearch->save(); // Minggu12
			$this->Minggu13->AdvancedSearch->save(); // Minggu13
			$this->Minggu14->AdvancedSearch->save(); // Minggu14
			$this->Minggu15->AdvancedSearch->save(); // Minggu15
			$this->Minggu16->AdvancedSearch->save(); // Minggu16
			$this->Persentase->AdvancedSearch->save(); // Persentase
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 || !IsMultiSearchOperator($fldOpr))
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal != "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 != "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 != "")
				$wrk = ($wrk != "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == Config("NULL_VALUE") || $fldVal == Config("NOT_NULL_VALUE"))
			return $fldVal;
		$value = $fldVal;
		if ($fld->isBoolean()) {
			if ($fldVal != "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal != "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->Nim, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->KelasAkd, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Thn_Akademik, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Periode, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kode_MK, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->kls, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Nilai, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->kunci, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->inp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Gujian, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu2, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu3, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu4, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu5, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu6, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu7, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu8, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu9, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu10, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu11, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu12, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu13, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu14, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu15, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Minggu16, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->IDX->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Nim->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->KelasAkd->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Thn_Akademik->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Periode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kode_MK->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->kls->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kehadiran->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Tugas->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Quiz->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->UTS->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->UAS->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Jumlah->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Nilai->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Angka->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->kunci->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->inp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Gujian->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu1->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu2->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu3->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu4->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu5->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu6->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu7->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu8->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu9->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu12->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu13->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu14->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu15->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Minggu16->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Persentase->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->IDX->AdvancedSearch->unsetSession();
		$this->Nim->AdvancedSearch->unsetSession();
		$this->KelasAkd->AdvancedSearch->unsetSession();
		$this->Thn_Akademik->AdvancedSearch->unsetSession();
		$this->Periode->AdvancedSearch->unsetSession();
		$this->Kode_MK->AdvancedSearch->unsetSession();
		$this->kls->AdvancedSearch->unsetSession();
		$this->Kehadiran->AdvancedSearch->unsetSession();
		$this->Tugas->AdvancedSearch->unsetSession();
		$this->Quiz->AdvancedSearch->unsetSession();
		$this->UTS->AdvancedSearch->unsetSession();
		$this->UAS->AdvancedSearch->unsetSession();
		$this->Jumlah->AdvancedSearch->unsetSession();
		$this->Nilai->AdvancedSearch->unsetSession();
		$this->Angka->AdvancedSearch->unsetSession();
		$this->kunci->AdvancedSearch->unsetSession();
		$this->inp->AdvancedSearch->unsetSession();
		$this->Gujian->AdvancedSearch->unsetSession();
		$this->Minggu1->AdvancedSearch->unsetSession();
		$this->Minggu2->AdvancedSearch->unsetSession();
		$this->Minggu3->AdvancedSearch->unsetSession();
		$this->Minggu4->AdvancedSearch->unsetSession();
		$this->Minggu5->AdvancedSearch->unsetSession();
		$this->Minggu6->AdvancedSearch->unsetSession();
		$this->Minggu7->AdvancedSearch->unsetSession();
		$this->Minggu8->AdvancedSearch->unsetSession();
		$this->Minggu9->AdvancedSearch->unsetSession();
		$this->Minggu10->AdvancedSearch->unsetSession();
		$this->Minggu11->AdvancedSearch->unsetSession();
		$this->Minggu12->AdvancedSearch->unsetSession();
		$this->Minggu13->AdvancedSearch->unsetSession();
		$this->Minggu14->AdvancedSearch->unsetSession();
		$this->Minggu15->AdvancedSearch->unsetSession();
		$this->Minggu16->AdvancedSearch->unsetSession();
		$this->Persentase->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->IDX->AdvancedSearch->load();
		$this->Nim->AdvancedSearch->load();
		$this->KelasAkd->AdvancedSearch->load();
		$this->Thn_Akademik->AdvancedSearch->load();
		$this->Periode->AdvancedSearch->load();
		$this->Kode_MK->AdvancedSearch->load();
		$this->kls->AdvancedSearch->load();
		$this->Kehadiran->AdvancedSearch->load();
		$this->Tugas->AdvancedSearch->load();
		$this->Quiz->AdvancedSearch->load();
		$this->UTS->AdvancedSearch->load();
		$this->UAS->AdvancedSearch->load();
		$this->Jumlah->AdvancedSearch->load();
		$this->Nilai->AdvancedSearch->load();
		$this->Angka->AdvancedSearch->load();
		$this->kunci->AdvancedSearch->load();
		$this->inp->AdvancedSearch->load();
		$this->Gujian->AdvancedSearch->load();
		$this->Minggu1->AdvancedSearch->load();
		$this->Minggu2->AdvancedSearch->load();
		$this->Minggu3->AdvancedSearch->load();
		$this->Minggu4->AdvancedSearch->load();
		$this->Minggu5->AdvancedSearch->load();
		$this->Minggu6->AdvancedSearch->load();
		$this->Minggu7->AdvancedSearch->load();
		$this->Minggu8->AdvancedSearch->load();
		$this->Minggu9->AdvancedSearch->load();
		$this->Minggu10->AdvancedSearch->load();
		$this->Minggu11->AdvancedSearch->load();
		$this->Minggu12->AdvancedSearch->load();
		$this->Minggu13->AdvancedSearch->load();
		$this->Minggu14->AdvancedSearch->load();
		$this->Minggu15->AdvancedSearch->load();
		$this->Minggu16->AdvancedSearch->load();
		$this->Persentase->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->Nim); // Nim
			$this->updateSort($this->KelasAkd); // KelasAkd
			$this->updateSort($this->Thn_Akademik); // Thn_Akademik
			$this->updateSort($this->Periode); // Periode
			$this->updateSort($this->Kode_MK); // Kode_MK
			$this->updateSort($this->kls); // kls
			$this->updateSort($this->Kehadiran); // Kehadiran
			$this->updateSort($this->Tugas); // Tugas
			$this->updateSort($this->UTS); // UTS
			$this->updateSort($this->UAS); // UAS
			$this->updateSort($this->Jumlah); // Jumlah
			$this->updateSort($this->Nilai); // Nilai
			$this->updateSort($this->Angka); // Angka
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->Nim->setSort("");
				$this->KelasAkd->setSort("");
				$this->Thn_Akademik->setSort("");
				$this->Periode->setSort("");
				$this->Kode_MK->setSort("");
				$this->kls->setSort("");
				$this->Kehadiran->setSort("");
				$this->Tugas->setSort("");
				$this->UTS->setSort("");
				$this->UAS->setSort("");
				$this->Jumlah->setSort("");
				$this->Nilai->setSort("");
				$this->Angka->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// "sequence"
		$item = &$this->ListOptions->add("sequence");
		$item->CssClass = "text-nowrap";
		$item->Visible = TRUE;
		$item->OnLeft = TRUE; // Always on left
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "sequence"
		$opt = $this->ListOptions["sequence"];
		$opt->Body = FormatSequenceNumber($this->RecordCount);

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->IDX->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fHtblNilailistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fHtblNilailistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.fHtblNilailist}," . $listaction->toJson(TRUE) . "));\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}

// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{

		// Load search values
		$got = FALSE;

		// IDX
		if (!$this->isAddOrEdit() && $this->IDX->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->IDX->AdvancedSearch->SearchValue != "" || $this->IDX->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Nim
		if (!$this->isAddOrEdit() && $this->Nim->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Nim->AdvancedSearch->SearchValue != "" || $this->Nim->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// KelasAkd
		if (!$this->isAddOrEdit() && $this->KelasAkd->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->KelasAkd->AdvancedSearch->SearchValue != "" || $this->KelasAkd->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Thn_Akademik
		if (!$this->isAddOrEdit() && $this->Thn_Akademik->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Thn_Akademik->AdvancedSearch->SearchValue != "" || $this->Thn_Akademik->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Periode
		if (!$this->isAddOrEdit() && $this->Periode->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Periode->AdvancedSearch->SearchValue != "" || $this->Periode->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kode_MK
		if (!$this->isAddOrEdit() && $this->Kode_MK->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kode_MK->AdvancedSearch->SearchValue != "" || $this->Kode_MK->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// kls
		if (!$this->isAddOrEdit() && $this->kls->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->kls->AdvancedSearch->SearchValue != "" || $this->kls->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kehadiran
		if (!$this->isAddOrEdit() && $this->Kehadiran->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kehadiran->AdvancedSearch->SearchValue != "" || $this->Kehadiran->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Tugas
		if (!$this->isAddOrEdit() && $this->Tugas->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Tugas->AdvancedSearch->SearchValue != "" || $this->Tugas->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Quiz
		if (!$this->isAddOrEdit() && $this->Quiz->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Quiz->AdvancedSearch->SearchValue != "" || $this->Quiz->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// UTS
		if (!$this->isAddOrEdit() && $this->UTS->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->UTS->AdvancedSearch->SearchValue != "" || $this->UTS->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// UAS
		if (!$this->isAddOrEdit() && $this->UAS->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->UAS->AdvancedSearch->SearchValue != "" || $this->UAS->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Jumlah
		if (!$this->isAddOrEdit() && $this->Jumlah->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Jumlah->AdvancedSearch->SearchValue != "" || $this->Jumlah->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Nilai
		if (!$this->isAddOrEdit() && $this->Nilai->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Nilai->AdvancedSearch->SearchValue != "" || $this->Nilai->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Angka
		if (!$this->isAddOrEdit() && $this->Angka->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Angka->AdvancedSearch->SearchValue != "" || $this->Angka->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// kunci
		if (!$this->isAddOrEdit() && $this->kunci->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->kunci->AdvancedSearch->SearchValue != "" || $this->kunci->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// inp
		if (!$this->isAddOrEdit() && $this->inp->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->inp->AdvancedSearch->SearchValue != "" || $this->inp->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Gujian
		if (!$this->isAddOrEdit() && $this->Gujian->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Gujian->AdvancedSearch->SearchValue != "" || $this->Gujian->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu1
		if (!$this->isAddOrEdit() && $this->Minggu1->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu1->AdvancedSearch->SearchValue != "" || $this->Minggu1->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu2
		if (!$this->isAddOrEdit() && $this->Minggu2->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu2->AdvancedSearch->SearchValue != "" || $this->Minggu2->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu3
		if (!$this->isAddOrEdit() && $this->Minggu3->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu3->AdvancedSearch->SearchValue != "" || $this->Minggu3->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu4
		if (!$this->isAddOrEdit() && $this->Minggu4->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu4->AdvancedSearch->SearchValue != "" || $this->Minggu4->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu5
		if (!$this->isAddOrEdit() && $this->Minggu5->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu5->AdvancedSearch->SearchValue != "" || $this->Minggu5->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu6
		if (!$this->isAddOrEdit() && $this->Minggu6->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu6->AdvancedSearch->SearchValue != "" || $this->Minggu6->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu7
		if (!$this->isAddOrEdit() && $this->Minggu7->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu7->AdvancedSearch->SearchValue != "" || $this->Minggu7->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu8
		if (!$this->isAddOrEdit() && $this->Minggu8->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu8->AdvancedSearch->SearchValue != "" || $this->Minggu8->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu9
		if (!$this->isAddOrEdit() && $this->Minggu9->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu9->AdvancedSearch->SearchValue != "" || $this->Minggu9->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu10
		if (!$this->isAddOrEdit() && $this->Minggu10->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu10->AdvancedSearch->SearchValue != "" || $this->Minggu10->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu11
		if (!$this->isAddOrEdit() && $this->Minggu11->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu11->AdvancedSearch->SearchValue != "" || $this->Minggu11->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu12
		if (!$this->isAddOrEdit() && $this->Minggu12->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu12->AdvancedSearch->SearchValue != "" || $this->Minggu12->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu13
		if (!$this->isAddOrEdit() && $this->Minggu13->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu13->AdvancedSearch->SearchValue != "" || $this->Minggu13->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu14
		if (!$this->isAddOrEdit() && $this->Minggu14->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu14->AdvancedSearch->SearchValue != "" || $this->Minggu14->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu15
		if (!$this->isAddOrEdit() && $this->Minggu15->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu15->AdvancedSearch->SearchValue != "" || $this->Minggu15->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Minggu16
		if (!$this->isAddOrEdit() && $this->Minggu16->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Minggu16->AdvancedSearch->SearchValue != "" || $this->Minggu16->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Persentase
		if (!$this->isAddOrEdit() && $this->Persentase->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Persentase->AdvancedSearch->SearchValue != "" || $this->Persentase->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}
		return $got;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->IDX->setDbValue($row['IDX']);
		$this->Nim->setDbValue($row['Nim']);
		if (array_key_exists('EV__Nim', $rs->fields)) {
			$this->Nim->VirtualValue = $rs->fields('EV__Nim'); // Set up virtual field value
		} else {
			$this->Nim->VirtualValue = ""; // Clear value
		}
		$this->KelasAkd->setDbValue($row['KelasAkd']);
		$this->Thn_Akademik->setDbValue($row['Thn_Akademik']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Kode_MK->setDbValue($row['Kode_MK']);
		$this->kls->setDbValue($row['kls']);
		$this->Kehadiran->setDbValue($row['Kehadiran']);
		$this->Tugas->setDbValue($row['Tugas']);
		$this->Quiz->setDbValue($row['Quiz']);
		$this->UTS->setDbValue($row['UTS']);
		$this->UAS->setDbValue($row['UAS']);
		$this->Jumlah->setDbValue($row['Jumlah']);
		$this->Nilai->setDbValue($row['Nilai']);
		$this->Angka->setDbValue($row['Angka']);
		$this->kunci->setDbValue($row['kunci']);
		$this->inp->setDbValue($row['inp']);
		$this->Gujian->setDbValue($row['Gujian']);
		$this->Minggu1->setDbValue($row['Minggu1']);
		$this->Minggu2->setDbValue($row['Minggu2']);
		$this->Minggu3->setDbValue($row['Minggu3']);
		$this->Minggu4->setDbValue($row['Minggu4']);
		$this->Minggu5->setDbValue($row['Minggu5']);
		$this->Minggu6->setDbValue($row['Minggu6']);
		$this->Minggu7->setDbValue($row['Minggu7']);
		$this->Minggu8->setDbValue($row['Minggu8']);
		$this->Minggu9->setDbValue($row['Minggu9']);
		$this->Minggu10->setDbValue($row['Minggu10']);
		$this->Minggu11->setDbValue($row['Minggu11']);
		$this->Minggu12->setDbValue($row['Minggu12']);
		$this->Minggu13->setDbValue($row['Minggu13']);
		$this->Minggu14->setDbValue($row['Minggu14']);
		$this->Minggu15->setDbValue($row['Minggu15']);
		$this->Minggu16->setDbValue($row['Minggu16']);
		$this->Persentase->setDbValue($row['Persentase']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['IDX'] = NULL;
		$row['Nim'] = NULL;
		$row['KelasAkd'] = NULL;
		$row['Thn_Akademik'] = NULL;
		$row['Periode'] = NULL;
		$row['Kode_MK'] = NULL;
		$row['kls'] = NULL;
		$row['Kehadiran'] = NULL;
		$row['Tugas'] = NULL;
		$row['Quiz'] = NULL;
		$row['UTS'] = NULL;
		$row['UAS'] = NULL;
		$row['Jumlah'] = NULL;
		$row['Nilai'] = NULL;
		$row['Angka'] = NULL;
		$row['kunci'] = NULL;
		$row['inp'] = NULL;
		$row['Gujian'] = NULL;
		$row['Minggu1'] = NULL;
		$row['Minggu2'] = NULL;
		$row['Minggu3'] = NULL;
		$row['Minggu4'] = NULL;
		$row['Minggu5'] = NULL;
		$row['Minggu6'] = NULL;
		$row['Minggu7'] = NULL;
		$row['Minggu8'] = NULL;
		$row['Minggu9'] = NULL;
		$row['Minggu10'] = NULL;
		$row['Minggu11'] = NULL;
		$row['Minggu12'] = NULL;
		$row['Minggu13'] = NULL;
		$row['Minggu14'] = NULL;
		$row['Minggu15'] = NULL;
		$row['Minggu16'] = NULL;
		$row['Persentase'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("IDX")) != "")
			$this->IDX->OldValue = $this->getKey("IDX"); // IDX
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->Kehadiran->FormValue == $this->Kehadiran->CurrentValue && is_numeric(ConvertToFloatString($this->Kehadiran->CurrentValue)))
			$this->Kehadiran->CurrentValue = ConvertToFloatString($this->Kehadiran->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Tugas->FormValue == $this->Tugas->CurrentValue && is_numeric(ConvertToFloatString($this->Tugas->CurrentValue)))
			$this->Tugas->CurrentValue = ConvertToFloatString($this->Tugas->CurrentValue);

		// Convert decimal values if posted back
		if ($this->UTS->FormValue == $this->UTS->CurrentValue && is_numeric(ConvertToFloatString($this->UTS->CurrentValue)))
			$this->UTS->CurrentValue = ConvertToFloatString($this->UTS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->UAS->FormValue == $this->UAS->CurrentValue && is_numeric(ConvertToFloatString($this->UAS->CurrentValue)))
			$this->UAS->CurrentValue = ConvertToFloatString($this->UAS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Jumlah->FormValue == $this->Jumlah->CurrentValue && is_numeric(ConvertToFloatString($this->Jumlah->CurrentValue)))
			$this->Jumlah->CurrentValue = ConvertToFloatString($this->Jumlah->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Angka->FormValue == $this->Angka->CurrentValue && is_numeric(ConvertToFloatString($this->Angka->CurrentValue)))
			$this->Angka->CurrentValue = ConvertToFloatString($this->Angka->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// IDX
		// Nim
		// KelasAkd
		// Thn_Akademik
		// Periode
		// Kode_MK
		// kls
		// Kehadiran
		// Tugas
		// Quiz
		// UTS
		// UAS
		// Jumlah
		// Nilai
		// Angka
		// kunci
		// inp
		// Gujian
		// Minggu1
		// Minggu2
		// Minggu3
		// Minggu4
		// Minggu5
		// Minggu6
		// Minggu7
		// Minggu8
		// Minggu9
		// Minggu10
		// Minggu11
		// Minggu12
		// Minggu13
		// Minggu14
		// Minggu15
		// Minggu16
		// Persentase

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// IDX
			$this->IDX->ViewValue = $this->IDX->CurrentValue;
			$this->IDX->ViewCustomAttributes = "";

			// Nim
			if ($this->Nim->VirtualValue != "") {
				$this->Nim->ViewValue = $this->Nim->VirtualValue;
			} else {
				$curVal = strval($this->Nim->CurrentValue);
				if ($curVal != "") {
					$this->Nim->ViewValue = $this->Nim->lookupCacheOption($curVal);
					if ($this->Nim->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[Nim]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->Nim->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->Nim->ViewValue = $this->Nim->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->Nim->ViewValue = $this->Nim->CurrentValue;
						}
					}
				} else {
					$this->Nim->ViewValue = NULL;
				}
			}
			$this->Nim->ViewCustomAttributes = "";

			// KelasAkd
			$this->KelasAkd->ViewValue = $this->KelasAkd->CurrentValue;
			$this->KelasAkd->ViewCustomAttributes = "";

			// Thn_Akademik
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
			$this->Thn_Akademik->ViewCustomAttributes = "";

			// Periode
			$this->Periode->ViewValue = $this->Periode->CurrentValue;
			$this->Periode->ViewCustomAttributes = "";

			// Kode_MK
			$curVal = strval($this->Kode_MK->CurrentValue);
			if ($curVal != "") {
				$this->Kode_MK->ViewValue = $this->Kode_MK->lookupCacheOption($curVal);
				if ($this->Kode_MK->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_MK->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$this->Kode_MK->ViewValue = $this->Kode_MK->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
					}
				}
			} else {
				$this->Kode_MK->ViewValue = NULL;
			}
			$this->Kode_MK->ViewCustomAttributes = "";

			// kls
			$this->kls->ViewValue = $this->kls->CurrentValue;
			$this->kls->ViewCustomAttributes = "";

			// Kehadiran
			$this->Kehadiran->ViewValue = $this->Kehadiran->CurrentValue;
			$this->Kehadiran->ViewValue = FormatNumber($this->Kehadiran->ViewValue, 2, -2, -2, -2);
			$this->Kehadiran->ViewCustomAttributes = "";

			// Tugas
			$this->Tugas->ViewValue = $this->Tugas->CurrentValue;
			$this->Tugas->ViewValue = FormatNumber($this->Tugas->ViewValue, 2, -2, -2, -2);
			$this->Tugas->ViewCustomAttributes = "";

			// Quiz
			$this->Quiz->ViewValue = $this->Quiz->CurrentValue;
			$this->Quiz->ViewValue = FormatNumber($this->Quiz->ViewValue, 2, -2, -2, -2);
			$this->Quiz->ViewCustomAttributes = "";

			// UTS
			$this->UTS->ViewValue = $this->UTS->CurrentValue;
			$this->UTS->ViewValue = FormatNumber($this->UTS->ViewValue, 2, -2, -2, -2);
			$this->UTS->ViewCustomAttributes = "";

			// UAS
			$this->UAS->ViewValue = $this->UAS->CurrentValue;
			$this->UAS->ViewValue = FormatNumber($this->UAS->ViewValue, 2, -2, -2, -2);
			$this->UAS->ViewCustomAttributes = "";

			// Jumlah
			$this->Jumlah->ViewValue = $this->Jumlah->CurrentValue;
			$this->Jumlah->ViewValue = FormatNumber($this->Jumlah->ViewValue, 2, -2, -2, -2);
			$this->Jumlah->ViewCustomAttributes = "";

			// Nilai
			$this->Nilai->ViewValue = $this->Nilai->CurrentValue;
			$this->Nilai->ViewCustomAttributes = "";

			// Angka
			$this->Angka->ViewValue = $this->Angka->CurrentValue;
			$this->Angka->ViewValue = FormatNumber($this->Angka->ViewValue, 2, -2, -2, -2);
			$this->Angka->ViewCustomAttributes = "";

			// kunci
			$this->kunci->ViewValue = $this->kunci->CurrentValue;
			$this->kunci->ViewCustomAttributes = "";

			// inp
			$this->inp->ViewValue = $this->inp->CurrentValue;
			$this->inp->ViewCustomAttributes = "";

			// Gujian
			$this->Gujian->ViewValue = $this->Gujian->CurrentValue;
			$this->Gujian->ViewCustomAttributes = "";

			// Minggu1
			$this->Minggu1->ViewValue = $this->Minggu1->CurrentValue;
			$this->Minggu1->ViewCustomAttributes = "";

			// Minggu2
			$this->Minggu2->ViewValue = $this->Minggu2->CurrentValue;
			$this->Minggu2->ViewCustomAttributes = "";

			// Minggu3
			$this->Minggu3->ViewValue = $this->Minggu3->CurrentValue;
			$this->Minggu3->ViewCustomAttributes = "";

			// Minggu4
			$this->Minggu4->ViewValue = $this->Minggu4->CurrentValue;
			$this->Minggu4->ViewCustomAttributes = "";

			// Minggu5
			$this->Minggu5->ViewValue = $this->Minggu5->CurrentValue;
			$this->Minggu5->ViewCustomAttributes = "";

			// Minggu6
			$this->Minggu6->ViewValue = $this->Minggu6->CurrentValue;
			$this->Minggu6->ViewCustomAttributes = "";

			// Minggu7
			$this->Minggu7->ViewValue = $this->Minggu7->CurrentValue;
			$this->Minggu7->ViewCustomAttributes = "";

			// Minggu8
			$this->Minggu8->ViewValue = $this->Minggu8->CurrentValue;
			$this->Minggu8->ViewCustomAttributes = "";

			// Minggu9
			$this->Minggu9->ViewValue = $this->Minggu9->CurrentValue;
			$this->Minggu9->ViewCustomAttributes = "";

			// Minggu10
			$this->Minggu10->ViewValue = $this->Minggu10->CurrentValue;
			$this->Minggu10->ViewCustomAttributes = "";

			// Minggu11
			$this->Minggu11->ViewValue = $this->Minggu11->CurrentValue;
			$this->Minggu11->ViewCustomAttributes = "";

			// Minggu12
			$this->Minggu12->ViewValue = $this->Minggu12->CurrentValue;
			$this->Minggu12->ViewCustomAttributes = "";

			// Minggu13
			$this->Minggu13->ViewValue = $this->Minggu13->CurrentValue;
			$this->Minggu13->ViewCustomAttributes = "";

			// Minggu14
			$this->Minggu14->ViewValue = $this->Minggu14->CurrentValue;
			$this->Minggu14->ViewCustomAttributes = "";

			// Minggu15
			$this->Minggu15->ViewValue = $this->Minggu15->CurrentValue;
			$this->Minggu15->ViewCustomAttributes = "";

			// Minggu16
			$this->Minggu16->ViewValue = $this->Minggu16->CurrentValue;
			$this->Minggu16->ViewCustomAttributes = "";

			// Persentase
			$this->Persentase->ViewValue = $this->Persentase->CurrentValue;
			$this->Persentase->ViewValue = FormatNumber($this->Persentase->ViewValue, 2, -2, -2, -2);
			$this->Persentase->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// KelasAkd
			$this->KelasAkd->LinkCustomAttributes = "";
			$this->KelasAkd->HrefValue = "";
			$this->KelasAkd->TooltipValue = "";

			// Thn_Akademik
			$this->Thn_Akademik->LinkCustomAttributes = "";
			$this->Thn_Akademik->HrefValue = "";
			$this->Thn_Akademik->TooltipValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";
			$this->Periode->TooltipValue = "";

			// Kode_MK
			$this->Kode_MK->LinkCustomAttributes = "";
			$this->Kode_MK->HrefValue = "";
			$this->Kode_MK->TooltipValue = "";

			// kls
			$this->kls->LinkCustomAttributes = "";
			$this->kls->HrefValue = "";
			$this->kls->TooltipValue = "";

			// Kehadiran
			$this->Kehadiran->LinkCustomAttributes = "";
			$this->Kehadiran->HrefValue = "";
			$this->Kehadiran->TooltipValue = "";

			// Tugas
			$this->Tugas->LinkCustomAttributes = "";
			$this->Tugas->HrefValue = "";
			$this->Tugas->TooltipValue = "";

			// UTS
			$this->UTS->LinkCustomAttributes = "";
			$this->UTS->HrefValue = "";
			$this->UTS->TooltipValue = "";

			// UAS
			$this->UAS->LinkCustomAttributes = "";
			$this->UAS->HrefValue = "";
			$this->UAS->TooltipValue = "";

			// Jumlah
			$this->Jumlah->LinkCustomAttributes = "";
			$this->Jumlah->HrefValue = "";
			$this->Jumlah->TooltipValue = "";

			// Nilai
			$this->Nilai->LinkCustomAttributes = "";
			$this->Nilai->HrefValue = "";
			$this->Nilai->TooltipValue = "";

			// Angka
			$this->Angka->LinkCustomAttributes = "";
			$this->Angka->HrefValue = "";
			$this->Angka->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			if (!$this->Nim->Raw)
				$this->Nim->AdvancedSearch->SearchValue = HtmlDecode($this->Nim->AdvancedSearch->SearchValue);
			$this->Nim->EditValue = HtmlEncode($this->Nim->AdvancedSearch->SearchValue);
			$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

			// KelasAkd
			$this->KelasAkd->EditAttrs["class"] = "form-control";
			$this->KelasAkd->EditCustomAttributes = "";
			if (!$this->KelasAkd->Raw)
				$this->KelasAkd->AdvancedSearch->SearchValue = HtmlDecode($this->KelasAkd->AdvancedSearch->SearchValue);
			$this->KelasAkd->EditValue = HtmlEncode($this->KelasAkd->AdvancedSearch->SearchValue);
			$this->KelasAkd->PlaceHolder = RemoveHtml($this->KelasAkd->caption());

			// Thn_Akademik
			$this->Thn_Akademik->EditAttrs["class"] = "form-control";
			$this->Thn_Akademik->EditCustomAttributes = "";
			if (!$this->Thn_Akademik->Raw)
				$this->Thn_Akademik->AdvancedSearch->SearchValue = HtmlDecode($this->Thn_Akademik->AdvancedSearch->SearchValue);
			$this->Thn_Akademik->EditValue = HtmlEncode($this->Thn_Akademik->AdvancedSearch->SearchValue);
			$this->Thn_Akademik->PlaceHolder = RemoveHtml($this->Thn_Akademik->caption());

			// Periode
			$this->Periode->EditAttrs["class"] = "form-control";
			$this->Periode->EditCustomAttributes = "";
			if (!$this->Periode->Raw)
				$this->Periode->AdvancedSearch->SearchValue = HtmlDecode($this->Periode->AdvancedSearch->SearchValue);
			$this->Periode->EditValue = HtmlEncode($this->Periode->AdvancedSearch->SearchValue);
			$this->Periode->PlaceHolder = RemoveHtml($this->Periode->caption());

			// Kode_MK
			$this->Kode_MK->EditAttrs["class"] = "form-control";
			$this->Kode_MK->EditCustomAttributes = "";

			// kls
			$this->kls->EditAttrs["class"] = "form-control";
			$this->kls->EditCustomAttributes = "";
			if (!$this->kls->Raw)
				$this->kls->AdvancedSearch->SearchValue = HtmlDecode($this->kls->AdvancedSearch->SearchValue);
			$this->kls->EditValue = HtmlEncode($this->kls->AdvancedSearch->SearchValue);
			$this->kls->PlaceHolder = RemoveHtml($this->kls->caption());

			// Kehadiran
			$this->Kehadiran->EditAttrs["class"] = "form-control";
			$this->Kehadiran->EditCustomAttributes = "";
			$this->Kehadiran->EditValue = HtmlEncode($this->Kehadiran->AdvancedSearch->SearchValue);
			$this->Kehadiran->PlaceHolder = RemoveHtml($this->Kehadiran->caption());
			$this->Kehadiran->EditAttrs["class"] = "form-control";
			$this->Kehadiran->EditCustomAttributes = "";
			$this->Kehadiran->EditValue2 = HtmlEncode($this->Kehadiran->AdvancedSearch->SearchValue2);
			$this->Kehadiran->PlaceHolder = RemoveHtml($this->Kehadiran->caption());

			// Tugas
			$this->Tugas->EditAttrs["class"] = "form-control";
			$this->Tugas->EditCustomAttributes = "";
			$this->Tugas->EditValue = HtmlEncode($this->Tugas->AdvancedSearch->SearchValue);
			$this->Tugas->PlaceHolder = RemoveHtml($this->Tugas->caption());

			// UTS
			$this->UTS->EditAttrs["class"] = "form-control";
			$this->UTS->EditCustomAttributes = "";
			$this->UTS->EditValue = HtmlEncode($this->UTS->AdvancedSearch->SearchValue);
			$this->UTS->PlaceHolder = RemoveHtml($this->UTS->caption());

			// UAS
			$this->UAS->EditAttrs["class"] = "form-control";
			$this->UAS->EditCustomAttributes = "";
			$this->UAS->EditValue = HtmlEncode($this->UAS->AdvancedSearch->SearchValue);
			$this->UAS->PlaceHolder = RemoveHtml($this->UAS->caption());

			// Jumlah
			$this->Jumlah->EditAttrs["class"] = "form-control";
			$this->Jumlah->EditCustomAttributes = "";
			$this->Jumlah->EditValue = HtmlEncode($this->Jumlah->AdvancedSearch->SearchValue);
			$this->Jumlah->PlaceHolder = RemoveHtml($this->Jumlah->caption());

			// Nilai
			$this->Nilai->EditAttrs["class"] = "form-control";
			$this->Nilai->EditCustomAttributes = "";
			if (!$this->Nilai->Raw)
				$this->Nilai->AdvancedSearch->SearchValue = HtmlDecode($this->Nilai->AdvancedSearch->SearchValue);
			$this->Nilai->EditValue = HtmlEncode($this->Nilai->AdvancedSearch->SearchValue);
			$this->Nilai->PlaceHolder = RemoveHtml($this->Nilai->caption());

			// Angka
			$this->Angka->EditAttrs["class"] = "form-control";
			$this->Angka->EditCustomAttributes = "";
			$this->Angka->EditValue = HtmlEncode($this->Angka->AdvancedSearch->SearchValue);
			$this->Angka->PlaceHolder = RemoveHtml($this->Angka->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return TRUE;
		if (!CheckNumber($this->Kehadiran->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->Kehadiran->errorMessage());
		}
		if (!CheckNumber($this->Kehadiran->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->Kehadiran->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->IDX->AdvancedSearch->load();
		$this->Nim->AdvancedSearch->load();
		$this->KelasAkd->AdvancedSearch->load();
		$this->Thn_Akademik->AdvancedSearch->load();
		$this->Periode->AdvancedSearch->load();
		$this->Kode_MK->AdvancedSearch->load();
		$this->kls->AdvancedSearch->load();
		$this->Kehadiran->AdvancedSearch->load();
		$this->Tugas->AdvancedSearch->load();
		$this->Quiz->AdvancedSearch->load();
		$this->UTS->AdvancedSearch->load();
		$this->UAS->AdvancedSearch->load();
		$this->Jumlah->AdvancedSearch->load();
		$this->Nilai->AdvancedSearch->load();
		$this->Angka->AdvancedSearch->load();
		$this->kunci->AdvancedSearch->load();
		$this->inp->AdvancedSearch->load();
		$this->Gujian->AdvancedSearch->load();
		$this->Minggu1->AdvancedSearch->load();
		$this->Minggu2->AdvancedSearch->load();
		$this->Minggu3->AdvancedSearch->load();
		$this->Minggu4->AdvancedSearch->load();
		$this->Minggu5->AdvancedSearch->load();
		$this->Minggu6->AdvancedSearch->load();
		$this->Minggu7->AdvancedSearch->load();
		$this->Minggu8->AdvancedSearch->load();
		$this->Minggu9->AdvancedSearch->load();
		$this->Minggu10->AdvancedSearch->load();
		$this->Minggu11->AdvancedSearch->load();
		$this->Minggu12->AdvancedSearch->load();
		$this->Minggu13->AdvancedSearch->load();
		$this->Minggu14->AdvancedSearch->load();
		$this->Minggu15->AdvancedSearch->load();
		$this->Minggu16->AdvancedSearch->load();
		$this->Persentase->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"return ew.export(document.fHtblNilailist, '" . $this->ExportExcelUrl . "', 'excel', true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"return ew.export(document.fHtblNilailist, '" . $this->ExportWordUrl . "', 'word', true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"return ew.export(document.fHtblNilailist, '" . $this->ExportPdfUrl . "', 'pdf', true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "email")) {
			$url = $custom ? ",url:'" . $this->pageUrl() . "export=email&amp;custom=1'" : "";
			return '<button id="emf_HtblNilai" class="ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" onclick="ew.emailDialogShow({lnk:\'emf_HtblNilai\', hdr:ew.language.phrase(\'ExportToEmailText\'), f:document.fHtblNilailist, sel:false' . $url . '});">' . $Language->phrase("ExportToEmail") . '</button>';
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fHtblNilailistsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecords = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecords = $rs->RecordCount();
		}
		$this->StartRecord = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
			$this->DisplayRecords = $this->TotalRecords;
			$this->StopRecord = $this->TotalRecords;
		} else { // Export one page only
			$this->setupStartRecord(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecords <= 0) {
				$this->StopRecord = $this->TotalRecords;
			} else {
				$this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRecord = 1;
			$this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!Config("DEBUG") && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (Config("DEBUG") && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Nim":
					break;
				case "x_Kode_MK":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Nim":
							break;
						case "x_Kode_MK":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>