<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for IM_Lulusan
 */
class IM_Lulusan extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $NIM;
	public $Nama_Mhs;
	public $Tmp_Lahir;
	public $Tgl_Lahir;
	public $Kode_Fak;
	public $Alamat;
	public $Telepon;
	public $_Email;
	public $Kode_jp;
	public $Jurusan;
	public $Program;
	public $Status_Akd;
	public $TaMasuk;
	public $PerMasuk;
	public $tglmasuk;
	public $Tgl_Lulus;
	public $No_Ijazah;
	public $SK;
	public $TA;
	public $per;
	public $Judul_TA;
	public $Pwl;
	public $Ijazah;
	public $Ktp;
	public $KK;
	public $xphoto;
	public $IjazahIM;
	public $TranskriptIM;
	public $Skripsi;
	public $TASkripsi;
	public $Plagiat;
	public $riwayatakademik;
	public $keuangan;
	public $pendukung;
	public $lainlain;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'IM_Lulusan';
		$this->TableName = 'IM_Lulusan';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[IM_Lulusan]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// NIM
		$this->NIM = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_NIM', 'NIM', '[NIM]', '[NIM]', 129, 14, -1, FALSE, '[NIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NIM->IsPrimaryKey = TRUE; // Primary key field
		$this->NIM->IsForeignKey = TRUE; // Foreign key field
		$this->NIM->Nullable = FALSE; // NOT NULL field
		$this->NIM->Required = TRUE; // Required field
		$this->NIM->Sortable = TRUE; // Allow sort
		$this->fields['NIM'] = &$this->NIM;

		// Nama_Mhs
		$this->Nama_Mhs = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Nama_Mhs', 'Nama_Mhs', '[Nama_Mhs]', '[Nama_Mhs]', 129, 60, -1, FALSE, '[Nama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mhs'] = &$this->Nama_Mhs;

		// Tmp_Lahir
		$this->Tmp_Lahir = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Tmp_Lahir', 'Tmp_Lahir', '[Tmp_Lahir]', '[Tmp_Lahir]', 129, 40, -1, FALSE, '[Tmp_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tmp_Lahir->Sortable = TRUE; // Allow sort
		$this->fields['Tmp_Lahir'] = &$this->Tmp_Lahir;

		// Tgl_Lahir
		$this->Tgl_Lahir = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Tgl_Lahir', 'Tgl_Lahir', '[Tgl_Lahir]', CastDateFieldForLike("[Tgl_Lahir]", 7, "DB"), 135, 8, 7, FALSE, '[Tgl_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Lahir->Sortable = TRUE; // Allow sort
		$this->Tgl_Lahir->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['Tgl_Lahir'] = &$this->Tgl_Lahir;

		// Kode_Fak
		$this->Kode_Fak = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[EV__Kode_Fak]', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->Kode_Fak->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Fak->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Fak->Lookup = new Lookup('Kode_Fak', 'tblFak', FALSE, 'Kode_Fak', ["Nama_Fak","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Alamat
		$this->Alamat = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Alamat', 'Alamat', '[Alamat]', '[Alamat]', 200, 232, -1, FALSE, '[Alamat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Alamat->Sortable = TRUE; // Allow sort
		$this->fields['Alamat'] = &$this->Alamat;

		// Telepon
		$this->Telepon = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Telepon', 'Telepon', '[Telepon]', '[Telepon]', 200, 31, -1, FALSE, '[Telepon]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Telepon->Sortable = TRUE; // Allow sort
		$this->fields['Telepon'] = &$this->Telepon;

		// Email
		$this->_Email = new DbField('IM_Lulusan', 'IM_Lulusan', 'x__Email', 'Email', '[Email]', '[Email]', 129, 50, -1, FALSE, '[Email]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Email->Sortable = TRUE; // Allow sort
		$this->fields['Email'] = &$this->_Email;

		// Kode_jp
		$this->Kode_jp = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Kode_jp', 'Kode_jp', '[Kode_jp]', '[Kode_jp]', 129, 4, -1, FALSE, '[Kode_jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_jp->Sortable = TRUE; // Allow sort
		$this->Kode_jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_jp->Lookup = new Lookup('Kode_jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Kode_Jp","Program","Jurusan",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_jp'] = &$this->Kode_jp;

		// Jurusan
		$this->Jurusan = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Jurusan', 'Jurusan', '[Jurusan]', '[Jurusan]', 129, 27, -1, FALSE, '[Jurusan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jurusan->Sortable = TRUE; // Allow sort
		$this->fields['Jurusan'] = &$this->Jurusan;

		// Program
		$this->Program = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Program', 'Program', '[Program]', '[Program]', 129, 2, -1, FALSE, '[Program]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Program->Sortable = TRUE; // Allow sort
		$this->fields['Program'] = &$this->Program;

		// Status_Akd
		$this->Status_Akd = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 200, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// TaMasuk
		$this->TaMasuk = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_TaMasuk', 'TaMasuk', '[TaMasuk]', '[TaMasuk]', 129, 9, -1, FALSE, '[TaMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->TaMasuk->Sortable = TRUE; // Allow sort
		$this->TaMasuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->TaMasuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->TaMasuk->Lookup = new Lookup('TaMasuk', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['TaMasuk'] = &$this->TaMasuk;

		// PerMasuk
		$this->PerMasuk = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_PerMasuk', 'PerMasuk', '[PerMasuk]', '[PerMasuk]', 129, 2, -1, FALSE, '[PerMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->PerMasuk->Sortable = TRUE; // Allow sort
		$this->PerMasuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->PerMasuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->PerMasuk->Lookup = new Lookup('PerMasuk', 'IM_Lulusan', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->PerMasuk->OptionCount = 3;
		$this->fields['PerMasuk'] = &$this->PerMasuk;

		// tglmasuk
		$this->tglmasuk = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_tglmasuk', 'tglmasuk', '[tglmasuk]', CastDateFieldForLike("[tglmasuk]", 7, "DB"), 135, 8, 7, FALSE, '[tglmasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tglmasuk->Sortable = TRUE; // Allow sort
		$this->tglmasuk->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['tglmasuk'] = &$this->tglmasuk;

		// Tgl_Lulus
		$this->Tgl_Lulus = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Tgl_Lulus', 'Tgl_Lulus', '[Tgl_Lulus]', CastDateFieldForLike("[Tgl_Lulus]", 7, "DB"), 135, 8, 7, FALSE, '[Tgl_Lulus]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Lulus->Sortable = TRUE; // Allow sort
		$this->Tgl_Lulus->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['Tgl_Lulus'] = &$this->Tgl_Lulus;

		// No_Ijazah
		$this->No_Ijazah = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_No_Ijazah', 'No_Ijazah', '[No_Ijazah]', '[No_Ijazah]', 129, 100, -1, FALSE, '[No_Ijazah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->No_Ijazah->Sortable = TRUE; // Allow sort
		$this->fields['No_Ijazah'] = &$this->No_Ijazah;

		// SK
		$this->SK = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_SK', 'SK', '[SK]', '[SK]', 129, 100, -1, FALSE, '[SK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SK->Sortable = TRUE; // Allow sort
		$this->fields['SK'] = &$this->SK;

		// TA
		$this->TA = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_TA', 'TA', '[TA]', '[TA]', 129, 9, -1, FALSE, '[TA]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->TA->Sortable = TRUE; // Allow sort
		$this->TA->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->TA->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->TA->Lookup = new Lookup('TA', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['TA'] = &$this->TA;

		// per
		$this->per = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_per', 'per', '[per]', '[per]', 129, 2, -1, FALSE, '[per]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->per->Sortable = TRUE; // Allow sort
		$this->per->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->per->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->per->Lookup = new Lookup('per', 'IM_Lulusan', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->per->OptionCount = 3;
		$this->fields['per'] = &$this->per;

		// Judul_TA
		$this->Judul_TA = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Judul_TA', 'Judul_TA', '[Judul_TA]', '[Judul_TA]', 200, 0, -1, FALSE, '[Judul_TA]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Judul_TA->Sortable = TRUE; // Allow sort
		$this->fields['Judul_TA'] = &$this->Judul_TA;

		// Pwl
		$this->Pwl = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Pwl', 'Pwl', '[Pwl]', 'CAST([Pwl] AS NVARCHAR)', 3, 4, -1, FALSE, '[Pwl]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pwl->Sortable = TRUE; // Allow sort
		$this->Pwl->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Pwl'] = &$this->Pwl;

		// Ijazah
		$this->Ijazah = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Ijazah', 'Ijazah', '[Ijazah]', '[Ijazah]', 200, 150, -1, FALSE, '[Ijazah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ijazah->Sortable = TRUE; // Allow sort
		$this->fields['Ijazah'] = &$this->Ijazah;

		// Ktp
		$this->Ktp = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Ktp', 'Ktp', '[Ktp]', '[Ktp]', 200, 150, -1, FALSE, '[Ktp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ktp->Sortable = TRUE; // Allow sort
		$this->fields['Ktp'] = &$this->Ktp;

		// KK
		$this->KK = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_KK', 'KK', '[KK]', '[KK]', 200, 150, -1, FALSE, '[KK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KK->Sortable = TRUE; // Allow sort
		$this->fields['KK'] = &$this->KK;

		// xphoto
		$this->xphoto = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_xphoto', 'xphoto', '[xphoto]', '[xphoto]', 200, 100, -1, FALSE, '[xphoto]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->xphoto->Sortable = TRUE; // Allow sort
		$this->fields['xphoto'] = &$this->xphoto;

		// IjazahIM
		$this->IjazahIM = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_IjazahIM', 'IjazahIM', '[IjazahIM]', '[IjazahIM]', 200, 150, -1, FALSE, '[IjazahIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IjazahIM->Sortable = TRUE; // Allow sort
		$this->fields['IjazahIM'] = &$this->IjazahIM;

		// TranskriptIM
		$this->TranskriptIM = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_TranskriptIM', 'TranskriptIM', '[TranskriptIM]', '[TranskriptIM]', 200, 150, -1, FALSE, '[TranskriptIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TranskriptIM->Sortable = TRUE; // Allow sort
		$this->fields['TranskriptIM'] = &$this->TranskriptIM;

		// Skripsi
		$this->Skripsi = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Skripsi', 'Skripsi', '[Skripsi]', '[Skripsi]', 200, 150, -1, FALSE, '[Skripsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Skripsi->Sortable = TRUE; // Allow sort
		$this->fields['Skripsi'] = &$this->Skripsi;

		// TASkripsi
		$this->TASkripsi = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_TASkripsi', 'TASkripsi', '[TASkripsi]', '[TASkripsi]', 200, 70, -1, FALSE, '[TASkripsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TASkripsi->Sortable = TRUE; // Allow sort
		$this->fields['TASkripsi'] = &$this->TASkripsi;

		// Plagiat
		$this->Plagiat = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_Plagiat', 'Plagiat', '[Plagiat]', '[Plagiat]', 200, 150, -1, FALSE, '[Plagiat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Plagiat->Sortable = TRUE; // Allow sort
		$this->fields['Plagiat'] = &$this->Plagiat;

		// riwayatakademik
		$this->riwayatakademik = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_riwayatakademik', 'riwayatakademik', '[riwayatakademik]', '[riwayatakademik]', 200, 150, -1, FALSE, '[riwayatakademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->riwayatakademik->Sortable = TRUE; // Allow sort
		$this->fields['riwayatakademik'] = &$this->riwayatakademik;

		// keuangan
		$this->keuangan = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_keuangan', 'keuangan', '[keuangan]', '[keuangan]', 200, 150, -1, FALSE, '[keuangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->keuangan->Sortable = TRUE; // Allow sort
		$this->fields['keuangan'] = &$this->keuangan;

		// pendukung
		$this->pendukung = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_pendukung', 'pendukung', '[pendukung]', '[pendukung]', 200, 150, -1, FALSE, '[pendukung]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pendukung->Sortable = TRUE; // Allow sort
		$this->fields['pendukung'] = &$this->pendukung;

		// lainlain
		$this->lainlain = new DbField('IM_Lulusan', 'IM_Lulusan', 'x_lainlain', 'lainlain', '[lainlain]', '[lainlain]', 200, 150, -1, FALSE, '[lainlain]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lainlain->Sortable = TRUE; // Allow sort
		$this->fields['lainlain'] = &$this->lainlain;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "docmhs") {
			$detailUrl = $GLOBALS["docmhs"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_NIM=" . urlencode($this->NIM->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "IM_Lulusanlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[IM_Lulusan]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT TOP 1 [Nama_Fak] FROM [dbo].[tblFak] [TMP_LOOKUPTABLE] WHERE [TMP_LOOKUPTABLE].[Kode_Fak] = [IM_Lulusan].[Kode_Fak]) AS [EV__Kode_Fak] FROM [dbo].[IM_Lulusan]" .
			") [TMP_TABLE]";
		return ($this->SqlSelectList != "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where != "")
			$where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
		if ($orderBy != "")
			$orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() != "")
			return TRUE;
		if ($this->Kode_Fak->AdvancedSearch->SearchValue != "" ||
			$this->Kode_Fak->AdvancedSearch->SearchValue2 != "" ||
			ContainsString($where, " " . $this->Kode_Fak->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->Kode_Fak->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('NIM', $rs))
				AddFilter($where, QuotedName('NIM', $this->Dbid) . '=' . QuotedValue($rs['NIM'], $this->NIM->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->NIM->DbValue = $row['NIM'];
		$this->Nama_Mhs->DbValue = $row['Nama_Mhs'];
		$this->Tmp_Lahir->DbValue = $row['Tmp_Lahir'];
		$this->Tgl_Lahir->DbValue = $row['Tgl_Lahir'];
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Alamat->DbValue = $row['Alamat'];
		$this->Telepon->DbValue = $row['Telepon'];
		$this->_Email->DbValue = $row['Email'];
		$this->Kode_jp->DbValue = $row['Kode_jp'];
		$this->Jurusan->DbValue = $row['Jurusan'];
		$this->Program->DbValue = $row['Program'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->TaMasuk->DbValue = $row['TaMasuk'];
		$this->PerMasuk->DbValue = $row['PerMasuk'];
		$this->tglmasuk->DbValue = $row['tglmasuk'];
		$this->Tgl_Lulus->DbValue = $row['Tgl_Lulus'];
		$this->No_Ijazah->DbValue = $row['No_Ijazah'];
		$this->SK->DbValue = $row['SK'];
		$this->TA->DbValue = $row['TA'];
		$this->per->DbValue = $row['per'];
		$this->Judul_TA->DbValue = $row['Judul_TA'];
		$this->Pwl->DbValue = $row['Pwl'];
		$this->Ijazah->DbValue = $row['Ijazah'];
		$this->Ktp->DbValue = $row['Ktp'];
		$this->KK->DbValue = $row['KK'];
		$this->xphoto->DbValue = $row['xphoto'];
		$this->IjazahIM->DbValue = $row['IjazahIM'];
		$this->TranskriptIM->DbValue = $row['TranskriptIM'];
		$this->Skripsi->DbValue = $row['Skripsi'];
		$this->TASkripsi->DbValue = $row['TASkripsi'];
		$this->Plagiat->DbValue = $row['Plagiat'];
		$this->riwayatakademik->DbValue = $row['riwayatakademik'];
		$this->keuangan->DbValue = $row['keuangan'];
		$this->pendukung->DbValue = $row['pendukung'];
		$this->lainlain->DbValue = $row['lainlain'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[NIM] = '@NIM@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('NIM', $row) ? $row['NIM'] : NULL;
		else
			$val = $this->NIM->OldValue !== NULL ? $this->NIM->OldValue : $this->NIM->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@NIM@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "IM_Lulusanlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "IM_Lulusanview.php")
			return $Language->phrase("View");
		elseif ($pageName == "IM_Lulusanedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "IM_Lulusanadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "IM_Lulusanlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("IM_Lulusanview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("IM_Lulusanview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "IM_Lulusanadd.php?" . $this->getUrlParm($parm);
		else
			$url = "IM_Lulusanadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("IM_Lulusanedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("IM_Lulusanedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("IM_Lulusanadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("IM_Lulusanadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("IM_Lulusandelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "NIM:" . JsonEncode($this->NIM->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->NIM->CurrentValue != NULL) {
			$url .= "NIM=" . urlencode($this->NIM->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("NIM") !== NULL)
				$arKeys[] = Param("NIM");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->NIM->CurrentValue = $key;
			else
				$this->NIM->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->NIM->setDbValue($rs->fields('NIM'));
		$this->Nama_Mhs->setDbValue($rs->fields('Nama_Mhs'));
		$this->Tmp_Lahir->setDbValue($rs->fields('Tmp_Lahir'));
		$this->Tgl_Lahir->setDbValue($rs->fields('Tgl_Lahir'));
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Alamat->setDbValue($rs->fields('Alamat'));
		$this->Telepon->setDbValue($rs->fields('Telepon'));
		$this->_Email->setDbValue($rs->fields('Email'));
		$this->Kode_jp->setDbValue($rs->fields('Kode_jp'));
		$this->Jurusan->setDbValue($rs->fields('Jurusan'));
		$this->Program->setDbValue($rs->fields('Program'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->TaMasuk->setDbValue($rs->fields('TaMasuk'));
		$this->PerMasuk->setDbValue($rs->fields('PerMasuk'));
		$this->tglmasuk->setDbValue($rs->fields('tglmasuk'));
		$this->Tgl_Lulus->setDbValue($rs->fields('Tgl_Lulus'));
		$this->No_Ijazah->setDbValue($rs->fields('No_Ijazah'));
		$this->SK->setDbValue($rs->fields('SK'));
		$this->TA->setDbValue($rs->fields('TA'));
		$this->per->setDbValue($rs->fields('per'));
		$this->Judul_TA->setDbValue($rs->fields('Judul_TA'));
		$this->Pwl->setDbValue($rs->fields('Pwl'));
		$this->Ijazah->setDbValue($rs->fields('Ijazah'));
		$this->Ktp->setDbValue($rs->fields('Ktp'));
		$this->KK->setDbValue($rs->fields('KK'));
		$this->xphoto->setDbValue($rs->fields('xphoto'));
		$this->IjazahIM->setDbValue($rs->fields('IjazahIM'));
		$this->TranskriptIM->setDbValue($rs->fields('TranskriptIM'));
		$this->Skripsi->setDbValue($rs->fields('Skripsi'));
		$this->TASkripsi->setDbValue($rs->fields('TASkripsi'));
		$this->Plagiat->setDbValue($rs->fields('Plagiat'));
		$this->riwayatakademik->setDbValue($rs->fields('riwayatakademik'));
		$this->keuangan->setDbValue($rs->fields('keuangan'));
		$this->pendukung->setDbValue($rs->fields('pendukung'));
		$this->lainlain->setDbValue($rs->fields('lainlain'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// NIM
		// Nama_Mhs
		// Tmp_Lahir
		// Tgl_Lahir
		// Kode_Fak
		// Alamat
		// Telepon
		// Email
		// Kode_jp
		// Jurusan
		// Program
		// Status_Akd
		// TaMasuk
		// PerMasuk
		// tglmasuk
		// Tgl_Lulus
		// No_Ijazah
		// SK
		// TA
		// per
		// Judul_TA
		// Pwl
		// Ijazah
		// Ktp
		// KK
		// xphoto
		// IjazahIM
		// TranskriptIM
		// Skripsi
		// TASkripsi
		// Plagiat
		// riwayatakademik
		// keuangan
		// pendukung
		// lainlain
		// NIM

		$this->NIM->ViewValue = $this->NIM->CurrentValue;
		$this->NIM->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->ViewCustomAttributes = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->ViewCustomAttributes = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
		$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 7);
		$this->Tgl_Lahir->ViewCustomAttributes = "";

		// Kode_Fak
		if ($this->Kode_Fak->VirtualValue != "") {
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->VirtualValue;
		} else {
			$curVal = strval($this->Kode_Fak->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
				if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
					}
				}
			} else {
				$this->Kode_Fak->ViewValue = NULL;
			}
		}
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Alamat
		$this->Alamat->ViewValue = $this->Alamat->CurrentValue;
		$this->Alamat->ViewCustomAttributes = "";

		// Telepon
		$this->Telepon->ViewValue = $this->Telepon->CurrentValue;
		$this->Telepon->ViewCustomAttributes = "";

		// Email
		$this->_Email->ViewValue = $this->_Email->CurrentValue;
		$this->_Email->ViewCustomAttributes = "";

		// Kode_jp
		$curVal = strval($this->Kode_jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
			if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_jp->ViewValue = NULL;
		}
		$this->Kode_jp->ViewCustomAttributes = "";

		// Jurusan
		$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->ViewCustomAttributes = "";

		// Program
		$this->Program->ViewValue = $this->Program->CurrentValue;
		$this->Program->ViewCustomAttributes = "";

		// Status_Akd
		$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
		$this->Status_Akd->ViewCustomAttributes = "";

		// TaMasuk
		$curVal = strval($this->TaMasuk->CurrentValue);
		if ($curVal != "") {
			$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
			if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
				}
			}
		} else {
			$this->TaMasuk->ViewValue = NULL;
		}
		$this->TaMasuk->ViewCustomAttributes = "";

		// PerMasuk
		if (strval($this->PerMasuk->CurrentValue) != "") {
			$this->PerMasuk->ViewValue = $this->PerMasuk->optionCaption($this->PerMasuk->CurrentValue);
		} else {
			$this->PerMasuk->ViewValue = NULL;
		}
		$this->PerMasuk->ViewCustomAttributes = "";

		// tglmasuk
		$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
		$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
		$this->tglmasuk->ViewCustomAttributes = "";

		// Tgl_Lulus
		$this->Tgl_Lulus->ViewValue = $this->Tgl_Lulus->CurrentValue;
		$this->Tgl_Lulus->ViewValue = FormatDateTime($this->Tgl_Lulus->ViewValue, 7);
		$this->Tgl_Lulus->ViewCustomAttributes = "";

		// No_Ijazah
		$this->No_Ijazah->ViewValue = $this->No_Ijazah->CurrentValue;
		$this->No_Ijazah->ViewCustomAttributes = "";

		// SK
		$this->SK->ViewValue = $this->SK->CurrentValue;
		$this->SK->ViewCustomAttributes = "";

		// TA
		$curVal = strval($this->TA->CurrentValue);
		if ($curVal != "") {
			$this->TA->ViewValue = $this->TA->lookupCacheOption($curVal);
			if ($this->TA->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->TA->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->TA->ViewValue = $this->TA->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->TA->ViewValue = $this->TA->CurrentValue;
				}
			}
		} else {
			$this->TA->ViewValue = NULL;
		}
		$this->TA->ViewCustomAttributes = "";

		// per
		if (strval($this->per->CurrentValue) != "") {
			$this->per->ViewValue = $this->per->optionCaption($this->per->CurrentValue);
		} else {
			$this->per->ViewValue = NULL;
		}
		$this->per->ViewCustomAttributes = "";

		// Judul_TA
		$this->Judul_TA->ViewValue = $this->Judul_TA->CurrentValue;
		$this->Judul_TA->ViewCustomAttributes = "";

		// Pwl
		$this->Pwl->ViewValue = $this->Pwl->CurrentValue;
		$this->Pwl->ViewValue = FormatNumber($this->Pwl->ViewValue, 0, -2, -2, -2);
		$this->Pwl->ViewCustomAttributes = "";

		// Ijazah
		$this->Ijazah->ViewValue = $this->Ijazah->CurrentValue;
		$this->Ijazah->ViewCustomAttributes = "";

		// Ktp
		$this->Ktp->ViewValue = $this->Ktp->CurrentValue;
		$this->Ktp->ViewCustomAttributes = "";

		// KK
		$this->KK->ViewValue = $this->KK->CurrentValue;
		$this->KK->ViewCustomAttributes = "";

		// xphoto
		$this->xphoto->ViewValue = $this->xphoto->CurrentValue;
		$this->xphoto->ViewCustomAttributes = "";

		// IjazahIM
		$this->IjazahIM->ViewValue = $this->IjazahIM->CurrentValue;
		$this->IjazahIM->ViewCustomAttributes = "";

		// TranskriptIM
		$this->TranskriptIM->ViewValue = $this->TranskriptIM->CurrentValue;
		$this->TranskriptIM->ViewCustomAttributes = "";

		// Skripsi
		$this->Skripsi->ViewValue = $this->Skripsi->CurrentValue;
		$this->Skripsi->ViewCustomAttributes = "";

		// TASkripsi
		$this->TASkripsi->ViewValue = $this->TASkripsi->CurrentValue;
		$this->TASkripsi->ViewCustomAttributes = "";

		// Plagiat
		$this->Plagiat->ViewValue = $this->Plagiat->CurrentValue;
		$this->Plagiat->ViewCustomAttributes = "";

		// riwayatakademik
		$this->riwayatakademik->ViewValue = $this->riwayatakademik->CurrentValue;
		$this->riwayatakademik->ViewCustomAttributes = "";

		// keuangan
		$this->keuangan->ViewValue = $this->keuangan->CurrentValue;
		$this->keuangan->ViewCustomAttributes = "";

		// pendukung
		$this->pendukung->ViewValue = $this->pendukung->CurrentValue;
		$this->pendukung->ViewCustomAttributes = "";

		// lainlain
		$this->lainlain->ViewValue = $this->lainlain->CurrentValue;
		$this->lainlain->ViewCustomAttributes = "";

		// NIM
		$this->NIM->LinkCustomAttributes = "";
		$this->NIM->HrefValue = "";
		$this->NIM->TooltipValue = "";

		// Nama_Mhs
		$this->Nama_Mhs->LinkCustomAttributes = "";
		$this->Nama_Mhs->HrefValue = "";
		$this->Nama_Mhs->TooltipValue = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->LinkCustomAttributes = "";
		$this->Tmp_Lahir->HrefValue = "";
		$this->Tmp_Lahir->TooltipValue = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->LinkCustomAttributes = "";
		$this->Tgl_Lahir->HrefValue = "";
		$this->Tgl_Lahir->TooltipValue = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Alamat
		$this->Alamat->LinkCustomAttributes = "";
		$this->Alamat->HrefValue = "";
		$this->Alamat->TooltipValue = "";

		// Telepon
		$this->Telepon->LinkCustomAttributes = "";
		$this->Telepon->HrefValue = "";
		$this->Telepon->TooltipValue = "";

		// Email
		$this->_Email->LinkCustomAttributes = "";
		$this->_Email->HrefValue = "";
		$this->_Email->TooltipValue = "";

		// Kode_jp
		$this->Kode_jp->LinkCustomAttributes = "";
		$this->Kode_jp->HrefValue = "";
		$this->Kode_jp->TooltipValue = "";

		// Jurusan
		$this->Jurusan->LinkCustomAttributes = "";
		$this->Jurusan->HrefValue = "";
		$this->Jurusan->TooltipValue = "";

		// Program
		$this->Program->LinkCustomAttributes = "";
		$this->Program->HrefValue = "";
		$this->Program->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// TaMasuk
		$this->TaMasuk->LinkCustomAttributes = "";
		$this->TaMasuk->HrefValue = "";
		$this->TaMasuk->TooltipValue = "";

		// PerMasuk
		$this->PerMasuk->LinkCustomAttributes = "";
		$this->PerMasuk->HrefValue = "";
		$this->PerMasuk->TooltipValue = "";

		// tglmasuk
		$this->tglmasuk->LinkCustomAttributes = "";
		$this->tglmasuk->HrefValue = "";
		$this->tglmasuk->TooltipValue = "";

		// Tgl_Lulus
		$this->Tgl_Lulus->LinkCustomAttributes = "";
		$this->Tgl_Lulus->HrefValue = "";
		$this->Tgl_Lulus->TooltipValue = "";

		// No_Ijazah
		$this->No_Ijazah->LinkCustomAttributes = "";
		$this->No_Ijazah->HrefValue = "";
		$this->No_Ijazah->TooltipValue = "";

		// SK
		$this->SK->LinkCustomAttributes = "";
		$this->SK->HrefValue = "";
		$this->SK->TooltipValue = "";

		// TA
		$this->TA->LinkCustomAttributes = "";
		$this->TA->HrefValue = "";
		$this->TA->TooltipValue = "";

		// per
		$this->per->LinkCustomAttributes = "";
		$this->per->HrefValue = "";
		$this->per->TooltipValue = "";

		// Judul_TA
		$this->Judul_TA->LinkCustomAttributes = "";
		$this->Judul_TA->HrefValue = "";
		$this->Judul_TA->TooltipValue = "";

		// Pwl
		$this->Pwl->LinkCustomAttributes = "";
		$this->Pwl->HrefValue = "";
		$this->Pwl->TooltipValue = "";

		// Ijazah
		$this->Ijazah->LinkCustomAttributes = "";
		if (!EmptyValue($this->Ijazah->CurrentValue)) {
			$this->Ijazah->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->Ijazah->ViewValue) && !is_array($this->Ijazah->ViewValue) ? RemoveHtml($this->Ijazah->ViewValue) : $this->Ijazah->CurrentValue); // Add prefix/suffix
			$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
		} else {
			$this->Ijazah->HrefValue = "";
		}
		$this->Ijazah->TooltipValue = "";

		// Ktp
		$this->Ktp->LinkCustomAttributes = "";
		if (!EmptyValue($this->Ktp->CurrentValue)) {
			$this->Ktp->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->Ktp->ViewValue) && !is_array($this->Ktp->ViewValue) ? RemoveHtml($this->Ktp->ViewValue) : $this->Ktp->CurrentValue); // Add prefix/suffix
			$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
		} else {
			$this->Ktp->HrefValue = "";
		}
		$this->Ktp->TooltipValue = "";

		// KK
		$this->KK->LinkCustomAttributes = "";
		if (!EmptyValue($this->KK->CurrentValue)) {
			$this->KK->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->KK->ViewValue) && !is_array($this->KK->ViewValue) ? RemoveHtml($this->KK->ViewValue) : $this->KK->CurrentValue); // Add prefix/suffix
			$this->KK->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
		} else {
			$this->KK->HrefValue = "";
		}
		$this->KK->TooltipValue = "";

		// xphoto
		$this->xphoto->LinkCustomAttributes = "";
		$this->xphoto->HrefValue = "";
		$this->xphoto->TooltipValue = "";

		// IjazahIM
		$this->IjazahIM->LinkCustomAttributes = "";
		if (!EmptyValue($this->IjazahIM->CurrentValue)) {
			$this->IjazahIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->IjazahIM->ViewValue) && !is_array($this->IjazahIM->ViewValue) ? RemoveHtml($this->IjazahIM->ViewValue) : $this->IjazahIM->CurrentValue); // Add prefix/suffix
			$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
		} else {
			$this->IjazahIM->HrefValue = "";
		}
		$this->IjazahIM->TooltipValue = "";

		// TranskriptIM
		$this->TranskriptIM->LinkCustomAttributes = "";
		if (!EmptyValue($this->TranskriptIM->CurrentValue)) {
			$this->TranskriptIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->TranskriptIM->ViewValue) && !is_array($this->TranskriptIM->ViewValue) ? RemoveHtml($this->TranskriptIM->ViewValue) : $this->TranskriptIM->CurrentValue); // Add prefix/suffix
			$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
		} else {
			$this->TranskriptIM->HrefValue = "";
		}
		$this->TranskriptIM->TooltipValue = "";

		// Skripsi
		$this->Skripsi->LinkCustomAttributes = "";
		if (!EmptyValue($this->Skripsi->CurrentValue)) {
			$this->Skripsi->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Skripsi->ViewValue) && !is_array($this->Skripsi->ViewValue) ? RemoveHtml($this->Skripsi->ViewValue) : $this->Skripsi->CurrentValue); // Add prefix/suffix
			$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
		} else {
			$this->Skripsi->HrefValue = "";
		}
		$this->Skripsi->TooltipValue = "";

		// TASkripsi
		$this->TASkripsi->LinkCustomAttributes = "";
		if (!EmptyValue($this->TASkripsi->CurrentValue)) {
			$this->TASkripsi->HrefValue = "https://akademik.stmik-im.ac.id/docs/TaSkripsi/" . (!empty($this->TASkripsi->ViewValue) && !is_array($this->TASkripsi->ViewValue) ? RemoveHtml($this->TASkripsi->ViewValue) : $this->TASkripsi->CurrentValue); // Add prefix/suffix
			$this->TASkripsi->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->TASkripsi->HrefValue = FullUrl($this->TASkripsi->HrefValue, "href");
		} else {
			$this->TASkripsi->HrefValue = "";
		}
		$this->TASkripsi->TooltipValue = "";

		// Plagiat
		$this->Plagiat->LinkCustomAttributes = "";
		if (!EmptyValue($this->Plagiat->CurrentValue)) {
			$this->Plagiat->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Plagiat->ViewValue) && !is_array($this->Plagiat->ViewValue) ? RemoveHtml($this->Plagiat->ViewValue) : $this->Plagiat->CurrentValue); // Add prefix/suffix
			$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
		} else {
			$this->Plagiat->HrefValue = "";
		}
		$this->Plagiat->TooltipValue = "";

		// riwayatakademik
		$this->riwayatakademik->LinkCustomAttributes = "";
		if (!EmptyValue($this->riwayatakademik->CurrentValue)) {
			$this->riwayatakademik->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->riwayatakademik->ViewValue) && !is_array($this->riwayatakademik->ViewValue) ? RemoveHtml($this->riwayatakademik->ViewValue) : $this->riwayatakademik->CurrentValue); // Add prefix/suffix
			$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
		} else {
			$this->riwayatakademik->HrefValue = "";
		}
		$this->riwayatakademik->TooltipValue = "";

		// keuangan
		$this->keuangan->LinkCustomAttributes = "";
		if (!EmptyValue($this->keuangan->CurrentValue)) {
			$this->keuangan->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/keu/" . (!empty($this->keuangan->ViewValue) && !is_array($this->keuangan->ViewValue) ? RemoveHtml($this->keuangan->ViewValue) : $this->keuangan->CurrentValue); // Add prefix/suffix
			$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
		} else {
			$this->keuangan->HrefValue = "";
		}
		$this->keuangan->TooltipValue = "";

		// pendukung
		$this->pendukung->LinkCustomAttributes = "";
		if (!EmptyValue($this->pendukung->CurrentValue)) {
			$this->pendukung->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/pendukung/" . (!empty($this->pendukung->ViewValue) && !is_array($this->pendukung->ViewValue) ? RemoveHtml($this->pendukung->ViewValue) : $this->pendukung->CurrentValue); // Add prefix/suffix
			$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
		} else {
			$this->pendukung->HrefValue = "";
		}
		$this->pendukung->TooltipValue = "";

		// lainlain
		$this->lainlain->LinkCustomAttributes = "";
		if (!EmptyValue($this->lainlain->CurrentValue)) {
			$this->lainlain->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/lainlain/" . (!empty($this->lainlain->ViewValue) && !is_array($this->lainlain->ViewValue) ? RemoveHtml($this->lainlain->ViewValue) : $this->lainlain->CurrentValue); // Add prefix/suffix
			$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
		} else {
			$this->lainlain->HrefValue = "";
		}
		$this->lainlain->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// NIM
		$this->NIM->EditAttrs["class"] = "form-control";
		$this->NIM->EditCustomAttributes = "";
		if (!$this->NIM->Raw)
			$this->NIM->CurrentValue = HtmlDecode($this->NIM->CurrentValue);
		$this->NIM->EditValue = $this->NIM->CurrentValue;
		$this->NIM->PlaceHolder = RemoveHtml($this->NIM->caption());

		// Nama_Mhs
		$this->Nama_Mhs->EditAttrs["class"] = "form-control";
		$this->Nama_Mhs->EditCustomAttributes = "";
		if (!$this->Nama_Mhs->Raw)
			$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
		$this->Nama_Mhs->EditValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

		// Tmp_Lahir
		$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
		$this->Tmp_Lahir->EditCustomAttributes = "";
		if (!$this->Tmp_Lahir->Raw)
			$this->Tmp_Lahir->CurrentValue = HtmlDecode($this->Tmp_Lahir->CurrentValue);
		$this->Tmp_Lahir->EditValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

		// Tgl_Lahir
		$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
		$this->Tgl_Lahir->EditCustomAttributes = "";
		$this->Tgl_Lahir->EditValue = FormatDateTime($this->Tgl_Lahir->CurrentValue, 7);
		$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";

		// Alamat
		$this->Alamat->EditAttrs["class"] = "form-control";
		$this->Alamat->EditCustomAttributes = "";
		if (!$this->Alamat->Raw)
			$this->Alamat->CurrentValue = HtmlDecode($this->Alamat->CurrentValue);
		$this->Alamat->EditValue = $this->Alamat->CurrentValue;
		$this->Alamat->PlaceHolder = RemoveHtml($this->Alamat->caption());

		// Telepon
		$this->Telepon->EditAttrs["class"] = "form-control";
		$this->Telepon->EditCustomAttributes = "";
		if (!$this->Telepon->Raw)
			$this->Telepon->CurrentValue = HtmlDecode($this->Telepon->CurrentValue);
		$this->Telepon->EditValue = $this->Telepon->CurrentValue;
		$this->Telepon->PlaceHolder = RemoveHtml($this->Telepon->caption());

		// Email
		$this->_Email->EditAttrs["class"] = "form-control";
		$this->_Email->EditCustomAttributes = "";
		if (!$this->_Email->Raw)
			$this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
		$this->_Email->EditValue = $this->_Email->CurrentValue;
		$this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

		// Kode_jp
		$this->Kode_jp->EditAttrs["class"] = "form-control";
		$this->Kode_jp->EditCustomAttributes = "";

		// Jurusan
		$this->Jurusan->EditAttrs["class"] = "form-control";
		$this->Jurusan->EditCustomAttributes = "";
		if (!$this->Jurusan->Raw)
			$this->Jurusan->CurrentValue = HtmlDecode($this->Jurusan->CurrentValue);
		$this->Jurusan->EditValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->PlaceHolder = RemoveHtml($this->Jurusan->caption());

		// Program
		$this->Program->EditAttrs["class"] = "form-control";
		$this->Program->EditCustomAttributes = "";
		if (!$this->Program->Raw)
			$this->Program->CurrentValue = HtmlDecode($this->Program->CurrentValue);
		$this->Program->EditValue = $this->Program->CurrentValue;
		$this->Program->PlaceHolder = RemoveHtml($this->Program->caption());

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";
		if (!$this->Status_Akd->Raw)
			$this->Status_Akd->CurrentValue = HtmlDecode($this->Status_Akd->CurrentValue);
		$this->Status_Akd->EditValue = $this->Status_Akd->CurrentValue;
		$this->Status_Akd->PlaceHolder = RemoveHtml($this->Status_Akd->caption());

		// TaMasuk
		$this->TaMasuk->EditAttrs["class"] = "form-control";
		$this->TaMasuk->EditCustomAttributes = "";

		// PerMasuk
		$this->PerMasuk->EditAttrs["class"] = "form-control";
		$this->PerMasuk->EditCustomAttributes = "";
		$this->PerMasuk->EditValue = $this->PerMasuk->options(TRUE);

		// tglmasuk
		$this->tglmasuk->EditAttrs["class"] = "form-control";
		$this->tglmasuk->EditCustomAttributes = "";
		$this->tglmasuk->EditValue = FormatDateTime($this->tglmasuk->CurrentValue, 7);
		$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

		// Tgl_Lulus
		$this->Tgl_Lulus->EditAttrs["class"] = "form-control";
		$this->Tgl_Lulus->EditCustomAttributes = "";
		$this->Tgl_Lulus->EditValue = FormatDateTime($this->Tgl_Lulus->CurrentValue, 7);
		$this->Tgl_Lulus->PlaceHolder = RemoveHtml($this->Tgl_Lulus->caption());

		// No_Ijazah
		$this->No_Ijazah->EditAttrs["class"] = "form-control";
		$this->No_Ijazah->EditCustomAttributes = "";
		if (!$this->No_Ijazah->Raw)
			$this->No_Ijazah->CurrentValue = HtmlDecode($this->No_Ijazah->CurrentValue);
		$this->No_Ijazah->EditValue = $this->No_Ijazah->CurrentValue;
		$this->No_Ijazah->PlaceHolder = RemoveHtml($this->No_Ijazah->caption());

		// SK
		$this->SK->EditAttrs["class"] = "form-control";
		$this->SK->EditCustomAttributes = "";
		if (!$this->SK->Raw)
			$this->SK->CurrentValue = HtmlDecode($this->SK->CurrentValue);
		$this->SK->EditValue = $this->SK->CurrentValue;
		$this->SK->PlaceHolder = RemoveHtml($this->SK->caption());

		// TA
		$this->TA->EditAttrs["class"] = "form-control";
		$this->TA->EditCustomAttributes = "";

		// per
		$this->per->EditAttrs["class"] = "form-control";
		$this->per->EditCustomAttributes = "";
		$this->per->EditValue = $this->per->options(TRUE);

		// Judul_TA
		$this->Judul_TA->EditAttrs["class"] = "form-control";
		$this->Judul_TA->EditCustomAttributes = "";
		if (!$this->Judul_TA->Raw)
			$this->Judul_TA->CurrentValue = HtmlDecode($this->Judul_TA->CurrentValue);
		$this->Judul_TA->EditValue = $this->Judul_TA->CurrentValue;
		$this->Judul_TA->PlaceHolder = RemoveHtml($this->Judul_TA->caption());

		// Pwl
		$this->Pwl->EditAttrs["class"] = "form-control";
		$this->Pwl->EditCustomAttributes = "";
		$this->Pwl->EditValue = $this->Pwl->CurrentValue;
		$this->Pwl->PlaceHolder = RemoveHtml($this->Pwl->caption());

		// Ijazah
		$this->Ijazah->EditAttrs["class"] = "form-control";
		$this->Ijazah->EditCustomAttributes = "";
		if (!$this->Ijazah->Raw)
			$this->Ijazah->CurrentValue = HtmlDecode($this->Ijazah->CurrentValue);
		$this->Ijazah->EditValue = $this->Ijazah->CurrentValue;
		$this->Ijazah->PlaceHolder = RemoveHtml($this->Ijazah->caption());

		// Ktp
		$this->Ktp->EditAttrs["class"] = "form-control";
		$this->Ktp->EditCustomAttributes = "";
		if (!$this->Ktp->Raw)
			$this->Ktp->CurrentValue = HtmlDecode($this->Ktp->CurrentValue);
		$this->Ktp->EditValue = $this->Ktp->CurrentValue;
		$this->Ktp->PlaceHolder = RemoveHtml($this->Ktp->caption());

		// KK
		$this->KK->EditAttrs["class"] = "form-control";
		$this->KK->EditCustomAttributes = "";
		if (!$this->KK->Raw)
			$this->KK->CurrentValue = HtmlDecode($this->KK->CurrentValue);
		$this->KK->EditValue = $this->KK->CurrentValue;
		$this->KK->PlaceHolder = RemoveHtml($this->KK->caption());

		// xphoto
		$this->xphoto->EditAttrs["class"] = "form-control";
		$this->xphoto->EditCustomAttributes = "";
		if (!$this->xphoto->Raw)
			$this->xphoto->CurrentValue = HtmlDecode($this->xphoto->CurrentValue);
		$this->xphoto->EditValue = $this->xphoto->CurrentValue;
		$this->xphoto->PlaceHolder = RemoveHtml($this->xphoto->caption());

		// IjazahIM
		$this->IjazahIM->EditAttrs["class"] = "form-control";
		$this->IjazahIM->EditCustomAttributes = "";
		if (!$this->IjazahIM->Raw)
			$this->IjazahIM->CurrentValue = HtmlDecode($this->IjazahIM->CurrentValue);
		$this->IjazahIM->EditValue = $this->IjazahIM->CurrentValue;
		$this->IjazahIM->PlaceHolder = RemoveHtml($this->IjazahIM->caption());

		// TranskriptIM
		$this->TranskriptIM->EditAttrs["class"] = "form-control";
		$this->TranskriptIM->EditCustomAttributes = "";
		if (!$this->TranskriptIM->Raw)
			$this->TranskriptIM->CurrentValue = HtmlDecode($this->TranskriptIM->CurrentValue);
		$this->TranskriptIM->EditValue = $this->TranskriptIM->CurrentValue;
		$this->TranskriptIM->PlaceHolder = RemoveHtml($this->TranskriptIM->caption());

		// Skripsi
		$this->Skripsi->EditAttrs["class"] = "form-control";
		$this->Skripsi->EditCustomAttributes = "";
		if (!$this->Skripsi->Raw)
			$this->Skripsi->CurrentValue = HtmlDecode($this->Skripsi->CurrentValue);
		$this->Skripsi->EditValue = $this->Skripsi->CurrentValue;
		$this->Skripsi->PlaceHolder = RemoveHtml($this->Skripsi->caption());

		// TASkripsi
		$this->TASkripsi->EditAttrs["class"] = "form-control";
		$this->TASkripsi->EditCustomAttributes = "";
		if (!$this->TASkripsi->Raw)
			$this->TASkripsi->CurrentValue = HtmlDecode($this->TASkripsi->CurrentValue);
		$this->TASkripsi->EditValue = $this->TASkripsi->CurrentValue;
		$this->TASkripsi->PlaceHolder = RemoveHtml($this->TASkripsi->caption());

		// Plagiat
		$this->Plagiat->EditAttrs["class"] = "form-control";
		$this->Plagiat->EditCustomAttributes = "";
		if (!$this->Plagiat->Raw)
			$this->Plagiat->CurrentValue = HtmlDecode($this->Plagiat->CurrentValue);
		$this->Plagiat->EditValue = $this->Plagiat->CurrentValue;
		$this->Plagiat->PlaceHolder = RemoveHtml($this->Plagiat->caption());

		// riwayatakademik
		$this->riwayatakademik->EditAttrs["class"] = "form-control";
		$this->riwayatakademik->EditCustomAttributes = "";
		if (!$this->riwayatakademik->Raw)
			$this->riwayatakademik->CurrentValue = HtmlDecode($this->riwayatakademik->CurrentValue);
		$this->riwayatakademik->EditValue = $this->riwayatakademik->CurrentValue;
		$this->riwayatakademik->PlaceHolder = RemoveHtml($this->riwayatakademik->caption());

		// keuangan
		$this->keuangan->EditAttrs["class"] = "form-control";
		$this->keuangan->EditCustomAttributes = "";
		if (!$this->keuangan->Raw)
			$this->keuangan->CurrentValue = HtmlDecode($this->keuangan->CurrentValue);
		$this->keuangan->EditValue = $this->keuangan->CurrentValue;
		$this->keuangan->PlaceHolder = RemoveHtml($this->keuangan->caption());

		// pendukung
		$this->pendukung->EditAttrs["class"] = "form-control";
		$this->pendukung->EditCustomAttributes = "";
		if (!$this->pendukung->Raw)
			$this->pendukung->CurrentValue = HtmlDecode($this->pendukung->CurrentValue);
		$this->pendukung->EditValue = $this->pendukung->CurrentValue;
		$this->pendukung->PlaceHolder = RemoveHtml($this->pendukung->caption());

		// lainlain
		$this->lainlain->EditAttrs["class"] = "form-control";
		$this->lainlain->EditCustomAttributes = "";
		if (!$this->lainlain->Raw)
			$this->lainlain->CurrentValue = HtmlDecode($this->lainlain->CurrentValue);
		$this->lainlain->EditValue = $this->lainlain->CurrentValue;
		$this->lainlain->PlaceHolder = RemoveHtml($this->lainlain->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->NIM);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Alamat);
					$doc->exportCaption($this->Telepon);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Program);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Tgl_Lulus);
					$doc->exportCaption($this->No_Ijazah);
					$doc->exportCaption($this->SK);
					$doc->exportCaption($this->TA);
					$doc->exportCaption($this->per);
					$doc->exportCaption($this->Judul_TA);
					$doc->exportCaption($this->Pwl);
					$doc->exportCaption($this->Ijazah);
					$doc->exportCaption($this->Ktp);
					$doc->exportCaption($this->KK);
					$doc->exportCaption($this->xphoto);
					$doc->exportCaption($this->IjazahIM);
					$doc->exportCaption($this->TranskriptIM);
					$doc->exportCaption($this->Skripsi);
					$doc->exportCaption($this->TASkripsi);
					$doc->exportCaption($this->Plagiat);
					$doc->exportCaption($this->riwayatakademik);
					$doc->exportCaption($this->keuangan);
					$doc->exportCaption($this->pendukung);
					$doc->exportCaption($this->lainlain);
				} else {
					$doc->exportCaption($this->NIM);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Alamat);
					$doc->exportCaption($this->Telepon);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Program);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Tgl_Lulus);
					$doc->exportCaption($this->No_Ijazah);
					$doc->exportCaption($this->SK);
					$doc->exportCaption($this->TA);
					$doc->exportCaption($this->per);
					$doc->exportCaption($this->Judul_TA);
					$doc->exportCaption($this->Pwl);
					$doc->exportCaption($this->Ijazah);
					$doc->exportCaption($this->Ktp);
					$doc->exportCaption($this->KK);
					$doc->exportCaption($this->xphoto);
					$doc->exportCaption($this->IjazahIM);
					$doc->exportCaption($this->TranskriptIM);
					$doc->exportCaption($this->Skripsi);
					$doc->exportCaption($this->TASkripsi);
					$doc->exportCaption($this->Plagiat);
					$doc->exportCaption($this->riwayatakademik);
					$doc->exportCaption($this->keuangan);
					$doc->exportCaption($this->pendukung);
					$doc->exportCaption($this->lainlain);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->NIM);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Alamat);
						$doc->exportField($this->Telepon);
						$doc->exportField($this->_Email);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Program);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Tgl_Lulus);
						$doc->exportField($this->No_Ijazah);
						$doc->exportField($this->SK);
						$doc->exportField($this->TA);
						$doc->exportField($this->per);
						$doc->exportField($this->Judul_TA);
						$doc->exportField($this->Pwl);
						$doc->exportField($this->Ijazah);
						$doc->exportField($this->Ktp);
						$doc->exportField($this->KK);
						$doc->exportField($this->xphoto);
						$doc->exportField($this->IjazahIM);
						$doc->exportField($this->TranskriptIM);
						$doc->exportField($this->Skripsi);
						$doc->exportField($this->TASkripsi);
						$doc->exportField($this->Plagiat);
						$doc->exportField($this->riwayatakademik);
						$doc->exportField($this->keuangan);
						$doc->exportField($this->pendukung);
						$doc->exportField($this->lainlain);
					} else {
						$doc->exportField($this->NIM);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Alamat);
						$doc->exportField($this->Telepon);
						$doc->exportField($this->_Email);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Program);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Tgl_Lulus);
						$doc->exportField($this->No_Ijazah);
						$doc->exportField($this->SK);
						$doc->exportField($this->TA);
						$doc->exportField($this->per);
						$doc->exportField($this->Judul_TA);
						$doc->exportField($this->Pwl);
						$doc->exportField($this->Ijazah);
						$doc->exportField($this->Ktp);
						$doc->exportField($this->KK);
						$doc->exportField($this->xphoto);
						$doc->exportField($this->IjazahIM);
						$doc->exportField($this->TranskriptIM);
						$doc->exportField($this->Skripsi);
						$doc->exportField($this->TASkripsi);
						$doc->exportField($this->Plagiat);
						$doc->exportField($this->riwayatakademik);
						$doc->exportField($this->keuangan);
						$doc->exportField($this->pendukung);
						$doc->exportField($this->lainlain);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>