<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for IM_Mhs
 */
class IM_Mhs extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Nim;
	public $Nama_Mhs;
	public $Tmp_Lahir;
	public $Tgl_Lahir;
	public $Status_Akd;
	public $Kode_Fak;
	public $Kode_jp;
	public $Jurusan;
	public $Program;
	public $TaMasuk;
	public $PerMasuk;
	public $SemesterMulai;
	public $tglmasuk;
	public $Status;
	public $StatusAkhir;
	public $SemesterKeluar_Lulus;
	public $Status_Masuk;
	public $AwalPendaftaran;
	public $Pwl;
	public $Ijazah;
	public $Ktp;
	public $KK;
	public $tandatangan;
	public $IjazahIM;
	public $TranskriptIM;
	public $Skripsi;
	public $TASkripsi;
	public $Plagiat;
	public $riwayatakademik;
	public $keuangan;
	public $pendukung;
	public $lainlain;
	public $Ferval;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'IM_Mhs';
		$this->TableName = 'IM_Mhs';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[IM_Mhs]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = TRUE; // Allow detail add
		$this->DetailEdit = TRUE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Nim
		$this->Nim = new DbField('IM_Mhs', 'IM_Mhs', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 129, 14, -1, FALSE, '[Nim]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nim->IsPrimaryKey = TRUE; // Primary key field
		$this->Nim->IsForeignKey = TRUE; // Foreign key field
		$this->Nim->Required = TRUE; // Required field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->fields['Nim'] = &$this->Nim;

		// Nama_Mhs
		$this->Nama_Mhs = new DbField('IM_Mhs', 'IM_Mhs', 'x_Nama_Mhs', 'Nama_Mhs', '[Nama_Mhs]', '[Nama_Mhs]', 129, 60, -1, FALSE, '[Nama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mhs'] = &$this->Nama_Mhs;

		// Tmp_Lahir
		$this->Tmp_Lahir = new DbField('IM_Mhs', 'IM_Mhs', 'x_Tmp_Lahir', 'Tmp_Lahir', '[Tmp_Lahir]', '[Tmp_Lahir]', 129, 40, -1, FALSE, '[Tmp_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tmp_Lahir->Sortable = TRUE; // Allow sort
		$this->fields['Tmp_Lahir'] = &$this->Tmp_Lahir;

		// Tgl_Lahir
		$this->Tgl_Lahir = new DbField('IM_Mhs', 'IM_Mhs', 'x_Tgl_Lahir', 'Tgl_Lahir', '[Tgl_Lahir]', CastDateFieldForLike("[Tgl_Lahir]", 7, "DB"), 135, 8, 7, FALSE, '[Tgl_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Lahir->Sortable = TRUE; // Allow sort
		$this->Tgl_Lahir->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['Tgl_Lahir'] = &$this->Tgl_Lahir;

		// Status_Akd
		$this->Status_Akd = new DbField('IM_Mhs', 'IM_Mhs', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 200, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->Status_Akd->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status_Akd->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status_Akd->Lookup = new Lookup('Status_Akd', 'tblkelas', FALSE, 'Kelas', ["Kelas","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// Kode_Fak
		$this->Kode_Fak = new DbField('IM_Mhs', 'IM_Mhs', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->Kode_Fak->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Fak->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Fak->Lookup = new Lookup('Kode_Fak', 'tblFak', FALSE, 'Kode_Fak', ["Nama_Fak","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Kode_jp
		$this->Kode_jp = new DbField('IM_Mhs', 'IM_Mhs', 'x_Kode_jp', 'Kode_jp', '[Kode_jp]', '[Kode_jp]', 129, 4, -1, FALSE, '[Kode_jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_jp->Sortable = TRUE; // Allow sort
		$this->Kode_jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_jp->Lookup = new Lookup('Kode_jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Program","Jurusan","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_jp'] = &$this->Kode_jp;

		// Jurusan
		$this->Jurusan = new DbField('IM_Mhs', 'IM_Mhs', 'x_Jurusan', 'Jurusan', '[Jurusan]', '[Jurusan]', 129, 27, -1, FALSE, '[Jurusan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jurusan->Sortable = TRUE; // Allow sort
		$this->fields['Jurusan'] = &$this->Jurusan;

		// Program
		$this->Program = new DbField('IM_Mhs', 'IM_Mhs', 'x_Program', 'Program', '[Program]', '[Program]', 129, 2, -1, FALSE, '[Program]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Program->Sortable = TRUE; // Allow sort
		$this->fields['Program'] = &$this->Program;

		// TaMasuk
		$this->TaMasuk = new DbField('IM_Mhs', 'IM_Mhs', 'x_TaMasuk', 'TaMasuk', '[TaMasuk]', '[TaMasuk]', 129, 9, -1, FALSE, '[TaMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->TaMasuk->Sortable = TRUE; // Allow sort
		$this->TaMasuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->TaMasuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->TaMasuk->Lookup = new Lookup('TaMasuk', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['TaMasuk'] = &$this->TaMasuk;

		// PerMasuk
		$this->PerMasuk = new DbField('IM_Mhs', 'IM_Mhs', 'x_PerMasuk', 'PerMasuk', '[PerMasuk]', '[PerMasuk]', 129, 2, -1, FALSE, '[PerMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->PerMasuk->Sortable = TRUE; // Allow sort
		$this->PerMasuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->PerMasuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->PerMasuk->Lookup = new Lookup('PerMasuk', 'IM_Mhs', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->PerMasuk->OptionCount = 3;
		$this->fields['PerMasuk'] = &$this->PerMasuk;

		// SemesterMulai
		$this->SemesterMulai = new DbField('IM_Mhs', 'IM_Mhs', 'x_SemesterMulai', 'SemesterMulai', '[SemesterMulai]', '[SemesterMulai]', 200, 50, -1, FALSE, '[SemesterMulai]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SemesterMulai->Sortable = TRUE; // Allow sort
		$this->fields['SemesterMulai'] = &$this->SemesterMulai;

		// tglmasuk
		$this->tglmasuk = new DbField('IM_Mhs', 'IM_Mhs', 'x_tglmasuk', 'tglmasuk', '[tglmasuk]', CastDateFieldForLike("[tglmasuk]", 7, "DB"), 135, 8, 7, FALSE, '[tglmasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tglmasuk->Sortable = TRUE; // Allow sort
		$this->tglmasuk->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['tglmasuk'] = &$this->tglmasuk;

		// Status
		$this->Status = new DbField('IM_Mhs', 'IM_Mhs', 'x_Status', 'Status', '[Status]', '[Status]', 129, 10, -1, FALSE, '[Status]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Status->Sortable = TRUE; // Allow sort
		$this->fields['Status'] = &$this->Status;

		// StatusAkhir
		$this->StatusAkhir = new DbField('IM_Mhs', 'IM_Mhs', 'x_StatusAkhir', 'StatusAkhir', '[StatusAkhir]', '[StatusAkhir]', 200, 50, -1, FALSE, '[StatusAkhir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->StatusAkhir->Sortable = TRUE; // Allow sort
		$this->fields['StatusAkhir'] = &$this->StatusAkhir;

		// SemesterKeluar_Lulus
		$this->SemesterKeluar_Lulus = new DbField('IM_Mhs', 'IM_Mhs', 'x_SemesterKeluar_Lulus', 'SemesterKeluar_Lulus', '[SemesterKeluar_Lulus]', '[SemesterKeluar_Lulus]', 200, 50, -1, FALSE, '[SemesterKeluar_Lulus]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SemesterKeluar_Lulus->Sortable = TRUE; // Allow sort
		$this->fields['SemesterKeluar_Lulus'] = &$this->SemesterKeluar_Lulus;

		// Status_Masuk
		$this->Status_Masuk = new DbField('IM_Mhs', 'IM_Mhs', 'x_Status_Masuk', 'Status_Masuk', '[Status_Masuk]', '[Status_Masuk]', 129, 10, -1, FALSE, '[Status_Masuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status_Masuk->Sortable = TRUE; // Allow sort
		$this->Status_Masuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status_Masuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status_Masuk->Lookup = new Lookup('Status_Masuk', 'IM_Mhs', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Status_Masuk->OptionCount = 2;
		$this->fields['Status_Masuk'] = &$this->Status_Masuk;

		// AwalPendaftaran
		$this->AwalPendaftaran = new DbField('IM_Mhs', 'IM_Mhs', 'x_AwalPendaftaran', 'AwalPendaftaran', '[AwalPendaftaran]', '[AwalPendaftaran]', 200, 50, -1, FALSE, '[AwalPendaftaran]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AwalPendaftaran->Sortable = TRUE; // Allow sort
		$this->fields['AwalPendaftaran'] = &$this->AwalPendaftaran;

		// Pwl
		$this->Pwl = new DbField('IM_Mhs', 'IM_Mhs', 'x_Pwl', 'Pwl', '[Pwl]', 'CAST([Pwl] AS NVARCHAR)', 3, 4, -1, FALSE, '[Pwl]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pwl->Sortable = TRUE; // Allow sort
		$this->Pwl->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Pwl'] = &$this->Pwl;

		// Ijazah
		$this->Ijazah = new DbField('IM_Mhs', 'IM_Mhs', 'x_Ijazah', 'Ijazah', '[Ijazah]', '[Ijazah]', 200, 150, -1, FALSE, '[Ijazah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ijazah->Sortable = TRUE; // Allow sort
		$this->fields['Ijazah'] = &$this->Ijazah;

		// Ktp
		$this->Ktp = new DbField('IM_Mhs', 'IM_Mhs', 'x_Ktp', 'Ktp', '[Ktp]', '[Ktp]', 200, 150, -1, FALSE, '[Ktp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ktp->Sortable = TRUE; // Allow sort
		$this->fields['Ktp'] = &$this->Ktp;

		// KK
		$this->KK = new DbField('IM_Mhs', 'IM_Mhs', 'x_KK', 'KK', '[KK]', '[KK]', 200, 150, -1, FALSE, '[KK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KK->Sortable = TRUE; // Allow sort
		$this->fields['KK'] = &$this->KK;

		// tandatangan
		$this->tandatangan = new DbField('IM_Mhs', 'IM_Mhs', 'x_tandatangan', 'tandatangan', '[tandatangan]', '[tandatangan]', 200, 150, -1, FALSE, '[tandatangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tandatangan->Sortable = TRUE; // Allow sort
		$this->fields['tandatangan'] = &$this->tandatangan;

		// IjazahIM
		$this->IjazahIM = new DbField('IM_Mhs', 'IM_Mhs', 'x_IjazahIM', 'IjazahIM', '[IjazahIM]', '[IjazahIM]', 200, 150, -1, FALSE, '[IjazahIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IjazahIM->Sortable = TRUE; // Allow sort
		$this->fields['IjazahIM'] = &$this->IjazahIM;

		// TranskriptIM
		$this->TranskriptIM = new DbField('IM_Mhs', 'IM_Mhs', 'x_TranskriptIM', 'TranskriptIM', '[TranskriptIM]', '[TranskriptIM]', 200, 150, -1, FALSE, '[TranskriptIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TranskriptIM->Sortable = TRUE; // Allow sort
		$this->fields['TranskriptIM'] = &$this->TranskriptIM;

		// Skripsi
		$this->Skripsi = new DbField('IM_Mhs', 'IM_Mhs', 'x_Skripsi', 'Skripsi', '[Skripsi]', '[Skripsi]', 200, 150, -1, FALSE, '[Skripsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Skripsi->Sortable = TRUE; // Allow sort
		$this->fields['Skripsi'] = &$this->Skripsi;

		// TASkripsi
		$this->TASkripsi = new DbField('IM_Mhs', 'IM_Mhs', 'x_TASkripsi', 'TASkripsi', '[TASkripsi]', '[TASkripsi]', 200, 70, -1, FALSE, '[TASkripsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TASkripsi->Sortable = TRUE; // Allow sort
		$this->fields['TASkripsi'] = &$this->TASkripsi;

		// Plagiat
		$this->Plagiat = new DbField('IM_Mhs', 'IM_Mhs', 'x_Plagiat', 'Plagiat', '[Plagiat]', '[Plagiat]', 200, 150, -1, FALSE, '[Plagiat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Plagiat->Sortable = TRUE; // Allow sort
		$this->fields['Plagiat'] = &$this->Plagiat;

		// riwayatakademik
		$this->riwayatakademik = new DbField('IM_Mhs', 'IM_Mhs', 'x_riwayatakademik', 'riwayatakademik', '[riwayatakademik]', '[riwayatakademik]', 200, 150, -1, FALSE, '[riwayatakademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->riwayatakademik->Sortable = TRUE; // Allow sort
		$this->fields['riwayatakademik'] = &$this->riwayatakademik;

		// keuangan
		$this->keuangan = new DbField('IM_Mhs', 'IM_Mhs', 'x_keuangan', 'keuangan', '[keuangan]', '[keuangan]', 200, 150, -1, FALSE, '[keuangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->keuangan->Sortable = TRUE; // Allow sort
		$this->fields['keuangan'] = &$this->keuangan;

		// pendukung
		$this->pendukung = new DbField('IM_Mhs', 'IM_Mhs', 'x_pendukung', 'pendukung', '[pendukung]', '[pendukung]', 200, 150, -1, FALSE, '[pendukung]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pendukung->Sortable = TRUE; // Allow sort
		$this->fields['pendukung'] = &$this->pendukung;

		// lainlain
		$this->lainlain = new DbField('IM_Mhs', 'IM_Mhs', 'x_lainlain', 'lainlain', '[lainlain]', '[lainlain]', 200, 150, -1, FALSE, '[lainlain]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lainlain->Sortable = TRUE; // Allow sort
		$this->fields['lainlain'] = &$this->lainlain;

		// Ferval
		$this->Ferval = new DbField('IM_Mhs', 'IM_Mhs', 'x_Ferval', 'Ferval', '[Ferval]', '[Ferval]', 200, 500, -1, FALSE, '[Ferval]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ferval->Sortable = TRUE; // Allow sort
		$this->fields['Ferval'] = &$this->Ferval;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "docmhs") {
			$detailUrl = $GLOBALS["docmhs"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "tblNilaiPerMhs") {
			$detailUrl = $GLOBALS["tblNilaiPerMhs"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "Wali_IPS") {
			$detailUrl = $GLOBALS["Wali_IPS"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "ekpt_Ferval") {
			$detailUrl = $GLOBALS["ekpt_Ferval"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "IM_Mhslist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[IM_Mhs]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Nim', $rs))
				AddFilter($where, QuotedName('Nim', $this->Dbid) . '=' . QuotedValue($rs['Nim'], $this->Nim->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Nim->DbValue = $row['Nim'];
		$this->Nama_Mhs->DbValue = $row['Nama_Mhs'];
		$this->Tmp_Lahir->DbValue = $row['Tmp_Lahir'];
		$this->Tgl_Lahir->DbValue = $row['Tgl_Lahir'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Kode_jp->DbValue = $row['Kode_jp'];
		$this->Jurusan->DbValue = $row['Jurusan'];
		$this->Program->DbValue = $row['Program'];
		$this->TaMasuk->DbValue = $row['TaMasuk'];
		$this->PerMasuk->DbValue = $row['PerMasuk'];
		$this->SemesterMulai->DbValue = $row['SemesterMulai'];
		$this->tglmasuk->DbValue = $row['tglmasuk'];
		$this->Status->DbValue = $row['Status'];
		$this->StatusAkhir->DbValue = $row['StatusAkhir'];
		$this->SemesterKeluar_Lulus->DbValue = $row['SemesterKeluar_Lulus'];
		$this->Status_Masuk->DbValue = $row['Status_Masuk'];
		$this->AwalPendaftaran->DbValue = $row['AwalPendaftaran'];
		$this->Pwl->DbValue = $row['Pwl'];
		$this->Ijazah->DbValue = $row['Ijazah'];
		$this->Ktp->DbValue = $row['Ktp'];
		$this->KK->DbValue = $row['KK'];
		$this->tandatangan->DbValue = $row['tandatangan'];
		$this->IjazahIM->DbValue = $row['IjazahIM'];
		$this->TranskriptIM->DbValue = $row['TranskriptIM'];
		$this->Skripsi->DbValue = $row['Skripsi'];
		$this->TASkripsi->DbValue = $row['TASkripsi'];
		$this->Plagiat->DbValue = $row['Plagiat'];
		$this->riwayatakademik->DbValue = $row['riwayatakademik'];
		$this->keuangan->DbValue = $row['keuangan'];
		$this->pendukung->DbValue = $row['pendukung'];
		$this->lainlain->DbValue = $row['lainlain'];
		$this->Ferval->DbValue = $row['Ferval'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Nim] = '@Nim@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Nim', $row) ? $row['Nim'] : NULL;
		else
			$val = $this->Nim->OldValue !== NULL ? $this->Nim->OldValue : $this->Nim->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Nim@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "IM_Mhslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "IM_Mhsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "IM_Mhsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "IM_Mhsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "IM_Mhslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("IM_Mhsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("IM_Mhsview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "IM_Mhsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "IM_Mhsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("IM_Mhsedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("IM_Mhsedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("IM_Mhsadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("IM_Mhsadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("IM_Mhsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Nim:" . JsonEncode($this->Nim->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Nim->CurrentValue != NULL) {
			$url .= "Nim=" . urlencode($this->Nim->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("Nim") !== NULL)
				$arKeys[] = Param("Nim");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Nim->CurrentValue = $key;
			else
				$this->Nim->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->Nama_Mhs->setDbValue($rs->fields('Nama_Mhs'));
		$this->Tmp_Lahir->setDbValue($rs->fields('Tmp_Lahir'));
		$this->Tgl_Lahir->setDbValue($rs->fields('Tgl_Lahir'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Kode_jp->setDbValue($rs->fields('Kode_jp'));
		$this->Jurusan->setDbValue($rs->fields('Jurusan'));
		$this->Program->setDbValue($rs->fields('Program'));
		$this->TaMasuk->setDbValue($rs->fields('TaMasuk'));
		$this->PerMasuk->setDbValue($rs->fields('PerMasuk'));
		$this->SemesterMulai->setDbValue($rs->fields('SemesterMulai'));
		$this->tglmasuk->setDbValue($rs->fields('tglmasuk'));
		$this->Status->setDbValue($rs->fields('Status'));
		$this->StatusAkhir->setDbValue($rs->fields('StatusAkhir'));
		$this->SemesterKeluar_Lulus->setDbValue($rs->fields('SemesterKeluar_Lulus'));
		$this->Status_Masuk->setDbValue($rs->fields('Status_Masuk'));
		$this->AwalPendaftaran->setDbValue($rs->fields('AwalPendaftaran'));
		$this->Pwl->setDbValue($rs->fields('Pwl'));
		$this->Ijazah->setDbValue($rs->fields('Ijazah'));
		$this->Ktp->setDbValue($rs->fields('Ktp'));
		$this->KK->setDbValue($rs->fields('KK'));
		$this->tandatangan->setDbValue($rs->fields('tandatangan'));
		$this->IjazahIM->setDbValue($rs->fields('IjazahIM'));
		$this->TranskriptIM->setDbValue($rs->fields('TranskriptIM'));
		$this->Skripsi->setDbValue($rs->fields('Skripsi'));
		$this->TASkripsi->setDbValue($rs->fields('TASkripsi'));
		$this->Plagiat->setDbValue($rs->fields('Plagiat'));
		$this->riwayatakademik->setDbValue($rs->fields('riwayatakademik'));
		$this->keuangan->setDbValue($rs->fields('keuangan'));
		$this->pendukung->setDbValue($rs->fields('pendukung'));
		$this->lainlain->setDbValue($rs->fields('lainlain'));
		$this->Ferval->setDbValue($rs->fields('Ferval'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Nim
		// Nama_Mhs
		// Tmp_Lahir
		// Tgl_Lahir
		// Status_Akd
		// Kode_Fak
		// Kode_jp
		// Jurusan
		// Program
		// TaMasuk
		// PerMasuk
		// SemesterMulai
		// tglmasuk
		// Status
		// StatusAkhir
		// SemesterKeluar_Lulus
		// Status_Masuk
		// AwalPendaftaran
		// Pwl
		// Ijazah
		// Ktp
		// KK
		// tandatangan
		// IjazahIM
		// TranskriptIM
		// Skripsi
		// TASkripsi
		// Plagiat
		// riwayatakademik
		// keuangan
		// pendukung
		// lainlain
		// Ferval
		// Nim

		$this->Nim->ViewValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->ViewCustomAttributes = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->ViewCustomAttributes = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
		$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 7);
		$this->Tgl_Lahir->ViewCustomAttributes = "";

		// Status_Akd
		$curVal = strval($this->Status_Akd->CurrentValue);
		if ($curVal != "") {
			$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
				}
			}
		} else {
			$this->Status_Akd->ViewValue = NULL;
		}
		$this->Status_Akd->ViewCustomAttributes = "";

		// Kode_Fak
		$curVal = strval($this->Kode_Fak->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
				}
			}
		} else {
			$this->Kode_Fak->ViewValue = NULL;
		}
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Kode_jp
		$curVal = strval($this->Kode_jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
			if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_jp->ViewValue = NULL;
		}
		$this->Kode_jp->ViewCustomAttributes = "";

		// Jurusan
		$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->ViewCustomAttributes = "";

		// Program
		$this->Program->ViewValue = $this->Program->CurrentValue;
		$this->Program->ViewCustomAttributes = "";

		// TaMasuk
		$curVal = strval($this->TaMasuk->CurrentValue);
		if ($curVal != "") {
			$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
			if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
				}
			}
		} else {
			$this->TaMasuk->ViewValue = NULL;
		}
		$this->TaMasuk->ViewCustomAttributes = "";

		// PerMasuk
		if (strval($this->PerMasuk->CurrentValue) != "") {
			$this->PerMasuk->ViewValue = $this->PerMasuk->optionCaption($this->PerMasuk->CurrentValue);
		} else {
			$this->PerMasuk->ViewValue = NULL;
		}
		$this->PerMasuk->ViewCustomAttributes = "";

		// SemesterMulai
		$this->SemesterMulai->ViewValue = $this->SemesterMulai->CurrentValue;
		$this->SemesterMulai->ViewCustomAttributes = "";

		// tglmasuk
		$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
		$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
		$this->tglmasuk->ViewCustomAttributes = "";

		// Status
		$this->Status->ViewValue = $this->Status->CurrentValue;
		$this->Status->ViewCustomAttributes = "";

		// StatusAkhir
		$this->StatusAkhir->ViewValue = $this->StatusAkhir->CurrentValue;
		$this->StatusAkhir->ViewCustomAttributes = "";

		// SemesterKeluar_Lulus
		$this->SemesterKeluar_Lulus->ViewValue = $this->SemesterKeluar_Lulus->CurrentValue;
		$this->SemesterKeluar_Lulus->ViewCustomAttributes = "";

		// Status_Masuk
		if (strval($this->Status_Masuk->CurrentValue) != "") {
			$this->Status_Masuk->ViewValue = $this->Status_Masuk->optionCaption($this->Status_Masuk->CurrentValue);
		} else {
			$this->Status_Masuk->ViewValue = NULL;
		}
		$this->Status_Masuk->ViewCustomAttributes = "";

		// AwalPendaftaran
		$this->AwalPendaftaran->ViewValue = $this->AwalPendaftaran->CurrentValue;
		$this->AwalPendaftaran->ViewCustomAttributes = "";

		// Pwl
		$this->Pwl->ViewValue = $this->Pwl->CurrentValue;
		$this->Pwl->ViewValue = FormatNumber($this->Pwl->ViewValue, 0, -2, -2, -2);
		$this->Pwl->ViewCustomAttributes = "";

		// Ijazah
		$this->Ijazah->ViewValue = $this->Ijazah->CurrentValue;
		$this->Ijazah->ViewCustomAttributes = "";

		// Ktp
		$this->Ktp->ViewValue = $this->Ktp->CurrentValue;
		$this->Ktp->ViewCustomAttributes = "";

		// KK
		$this->KK->ViewValue = $this->KK->CurrentValue;
		$this->KK->ViewCustomAttributes = "";

		// tandatangan
		$this->tandatangan->ViewValue = $this->tandatangan->CurrentValue;
		$this->tandatangan->ViewCustomAttributes = "";

		// IjazahIM
		$this->IjazahIM->ViewValue = $this->IjazahIM->CurrentValue;
		$this->IjazahIM->ViewCustomAttributes = "";

		// TranskriptIM
		$this->TranskriptIM->ViewValue = $this->TranskriptIM->CurrentValue;
		$this->TranskriptIM->ViewCustomAttributes = "";

		// Skripsi
		$this->Skripsi->ViewValue = $this->Skripsi->CurrentValue;
		$this->Skripsi->ViewCustomAttributes = "";

		// TASkripsi
		$this->TASkripsi->ViewValue = $this->TASkripsi->CurrentValue;
		$this->TASkripsi->ViewCustomAttributes = "";

		// Plagiat
		$this->Plagiat->ViewValue = $this->Plagiat->CurrentValue;
		$this->Plagiat->ViewCustomAttributes = "";

		// riwayatakademik
		$this->riwayatakademik->ViewValue = $this->riwayatakademik->CurrentValue;
		$this->riwayatakademik->ViewCustomAttributes = "";

		// keuangan
		$this->keuangan->ViewValue = $this->keuangan->CurrentValue;
		$this->keuangan->ViewCustomAttributes = "";

		// pendukung
		$this->pendukung->ViewValue = $this->pendukung->CurrentValue;
		$this->pendukung->ViewCustomAttributes = "";

		// lainlain
		$this->lainlain->ViewValue = $this->lainlain->CurrentValue;
		$this->lainlain->ViewCustomAttributes = "";

		// Ferval
		$this->Ferval->ViewValue = $this->Ferval->CurrentValue;
		$this->Ferval->ViewCustomAttributes = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// Nama_Mhs
		$this->Nama_Mhs->LinkCustomAttributes = "";
		$this->Nama_Mhs->HrefValue = "";
		$this->Nama_Mhs->TooltipValue = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->LinkCustomAttributes = "";
		$this->Tmp_Lahir->HrefValue = "";
		$this->Tmp_Lahir->TooltipValue = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->LinkCustomAttributes = "";
		$this->Tgl_Lahir->HrefValue = "";
		$this->Tgl_Lahir->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Kode_jp
		$this->Kode_jp->LinkCustomAttributes = "";
		$this->Kode_jp->HrefValue = "";
		$this->Kode_jp->TooltipValue = "";

		// Jurusan
		$this->Jurusan->LinkCustomAttributes = "";
		$this->Jurusan->HrefValue = "";
		$this->Jurusan->TooltipValue = "";

		// Program
		$this->Program->LinkCustomAttributes = "";
		$this->Program->HrefValue = "";
		$this->Program->TooltipValue = "";

		// TaMasuk
		$this->TaMasuk->LinkCustomAttributes = "";
		$this->TaMasuk->HrefValue = "";
		$this->TaMasuk->TooltipValue = "";

		// PerMasuk
		$this->PerMasuk->LinkCustomAttributes = "";
		$this->PerMasuk->HrefValue = "";
		$this->PerMasuk->TooltipValue = "";

		// SemesterMulai
		$this->SemesterMulai->LinkCustomAttributes = "";
		$this->SemesterMulai->HrefValue = "";
		$this->SemesterMulai->TooltipValue = "";

		// tglmasuk
		$this->tglmasuk->LinkCustomAttributes = "";
		$this->tglmasuk->HrefValue = "";
		$this->tglmasuk->TooltipValue = "";

		// Status
		$this->Status->LinkCustomAttributes = "";
		$this->Status->HrefValue = "";
		$this->Status->TooltipValue = "";

		// StatusAkhir
		$this->StatusAkhir->LinkCustomAttributes = "";
		$this->StatusAkhir->HrefValue = "";
		$this->StatusAkhir->TooltipValue = "";

		// SemesterKeluar_Lulus
		$this->SemesterKeluar_Lulus->LinkCustomAttributes = "";
		$this->SemesterKeluar_Lulus->HrefValue = "";
		$this->SemesterKeluar_Lulus->TooltipValue = "";

		// Status_Masuk
		$this->Status_Masuk->LinkCustomAttributes = "";
		$this->Status_Masuk->HrefValue = "";
		$this->Status_Masuk->TooltipValue = "";

		// AwalPendaftaran
		$this->AwalPendaftaran->LinkCustomAttributes = "";
		$this->AwalPendaftaran->HrefValue = "";
		$this->AwalPendaftaran->TooltipValue = "";

		// Pwl
		$this->Pwl->LinkCustomAttributes = "";
		$this->Pwl->HrefValue = "";
		$this->Pwl->TooltipValue = "";

		// Ijazah
		$this->Ijazah->LinkCustomAttributes = "";
		if (!EmptyValue($this->Ijazah->CurrentValue)) {
			$this->Ijazah->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . $this->Ijazah->CurrentValue; // Add prefix/suffix
			$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
		} else {
			$this->Ijazah->HrefValue = "";
		}
		$this->Ijazah->TooltipValue = "";

		// Ktp
		$this->Ktp->LinkCustomAttributes = "";
		if (!EmptyValue($this->Ktp->CurrentValue)) {
			$this->Ktp->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . $this->Ktp->CurrentValue; // Add prefix/suffix
			$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
		} else {
			$this->Ktp->HrefValue = "";
		}
		$this->Ktp->TooltipValue = "";

		// KK
		$this->KK->LinkCustomAttributes = "";
		if (!EmptyValue($this->KK->CurrentValue)) {
			$this->KK->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->KK->ViewValue) && !is_array($this->KK->ViewValue) ? RemoveHtml($this->KK->ViewValue) : $this->KK->CurrentValue); // Add prefix/suffix
			$this->KK->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
		} else {
			$this->KK->HrefValue = "";
		}
		$this->KK->TooltipValue = "";

		// tandatangan
		$this->tandatangan->LinkCustomAttributes = "";
		if (!EmptyValue($this->tandatangan->CurrentValue)) {
			$this->tandatangan->HrefValue = "http://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->tandatangan->ViewValue) && !is_array($this->tandatangan->ViewValue) ? RemoveHtml($this->tandatangan->ViewValue) : $this->tandatangan->CurrentValue); // Add prefix/suffix
			$this->tandatangan->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->tandatangan->HrefValue = FullUrl($this->tandatangan->HrefValue, "href");
		} else {
			$this->tandatangan->HrefValue = "";
		}
		$this->tandatangan->TooltipValue = "";

		// IjazahIM
		$this->IjazahIM->LinkCustomAttributes = "";
		if (!EmptyValue($this->IjazahIM->CurrentValue)) {
			$this->IjazahIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->IjazahIM->ViewValue) && !is_array($this->IjazahIM->ViewValue) ? RemoveHtml($this->IjazahIM->ViewValue) : $this->IjazahIM->CurrentValue); // Add prefix/suffix
			$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
		} else {
			$this->IjazahIM->HrefValue = "";
		}
		$this->IjazahIM->TooltipValue = "";

		// TranskriptIM
		$this->TranskriptIM->LinkCustomAttributes = "";
		if (!EmptyValue($this->TranskriptIM->CurrentValue)) {
			$this->TranskriptIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->TranskriptIM->ViewValue) && !is_array($this->TranskriptIM->ViewValue) ? RemoveHtml($this->TranskriptIM->ViewValue) : $this->TranskriptIM->CurrentValue); // Add prefix/suffix
			$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
		} else {
			$this->TranskriptIM->HrefValue = "";
		}
		$this->TranskriptIM->TooltipValue = "";

		// Skripsi
		$this->Skripsi->LinkCustomAttributes = "";
		if (!EmptyValue($this->Skripsi->CurrentValue)) {
			$this->Skripsi->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Skripsi->ViewValue) && !is_array($this->Skripsi->ViewValue) ? RemoveHtml($this->Skripsi->ViewValue) : $this->Skripsi->CurrentValue); // Add prefix/suffix
			$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
		} else {
			$this->Skripsi->HrefValue = "";
		}
		$this->Skripsi->TooltipValue = "";

		// TASkripsi
		$this->TASkripsi->LinkCustomAttributes = "";
		if (!EmptyValue($this->TASkripsi->CurrentValue)) {
			$this->TASkripsi->HrefValue = "https://akademik.stmik-im.ac.id/docs/TaSkripsi/" . (!empty($this->TASkripsi->ViewValue) && !is_array($this->TASkripsi->ViewValue) ? RemoveHtml($this->TASkripsi->ViewValue) : $this->TASkripsi->CurrentValue); // Add prefix/suffix
			$this->TASkripsi->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->TASkripsi->HrefValue = FullUrl($this->TASkripsi->HrefValue, "href");
		} else {
			$this->TASkripsi->HrefValue = "";
		}
		$this->TASkripsi->TooltipValue = "";

		// Plagiat
		$this->Plagiat->LinkCustomAttributes = "";
		if (!EmptyValue($this->Plagiat->CurrentValue)) {
			$this->Plagiat->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Plagiat->ViewValue) && !is_array($this->Plagiat->ViewValue) ? RemoveHtml($this->Plagiat->ViewValue) : $this->Plagiat->CurrentValue); // Add prefix/suffix
			$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
		} else {
			$this->Plagiat->HrefValue = "";
		}
		$this->Plagiat->TooltipValue = "";

		// riwayatakademik
		$this->riwayatakademik->LinkCustomAttributes = "";
		if (!EmptyValue($this->riwayatakademik->CurrentValue)) {
			$this->riwayatakademik->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->riwayatakademik->ViewValue) && !is_array($this->riwayatakademik->ViewValue) ? RemoveHtml($this->riwayatakademik->ViewValue) : $this->riwayatakademik->CurrentValue); // Add prefix/suffix
			$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
		} else {
			$this->riwayatakademik->HrefValue = "";
		}
		$this->riwayatakademik->TooltipValue = "";

		// keuangan
		$this->keuangan->LinkCustomAttributes = "";
		if (!EmptyValue($this->keuangan->CurrentValue)) {
			$this->keuangan->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/keu/" . (!empty($this->keuangan->ViewValue) && !is_array($this->keuangan->ViewValue) ? RemoveHtml($this->keuangan->ViewValue) : $this->keuangan->CurrentValue); // Add prefix/suffix
			$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
		} else {
			$this->keuangan->HrefValue = "";
		}
		$this->keuangan->TooltipValue = "";

		// pendukung
		$this->pendukung->LinkCustomAttributes = "";
		if (!EmptyValue($this->pendukung->CurrentValue)) {
			$this->pendukung->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/pendukung/" . (!empty($this->pendukung->ViewValue) && !is_array($this->pendukung->ViewValue) ? RemoveHtml($this->pendukung->ViewValue) : $this->pendukung->CurrentValue); // Add prefix/suffix
			$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
		} else {
			$this->pendukung->HrefValue = "";
		}
		$this->pendukung->TooltipValue = "";

		// lainlain
		$this->lainlain->LinkCustomAttributes = "";
		if (!EmptyValue($this->lainlain->CurrentValue)) {
			$this->lainlain->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/lainlain/" . (!empty($this->lainlain->ViewValue) && !is_array($this->lainlain->ViewValue) ? RemoveHtml($this->lainlain->ViewValue) : $this->lainlain->CurrentValue); // Add prefix/suffix
			$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
		} else {
			$this->lainlain->HrefValue = "";
		}
		$this->lainlain->TooltipValue = "";

		// Ferval
		$this->Ferval->LinkCustomAttributes = "";
		$this->Ferval->HrefValue = "";
		$this->Ferval->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";
		if (!$this->Nim->Raw)
			$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
		$this->Nim->EditValue = $this->Nim->CurrentValue;
		$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

		// Nama_Mhs
		$this->Nama_Mhs->EditAttrs["class"] = "form-control";
		$this->Nama_Mhs->EditCustomAttributes = "";
		if (!$this->Nama_Mhs->Raw)
			$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
		$this->Nama_Mhs->EditValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

		// Tmp_Lahir
		$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
		$this->Tmp_Lahir->EditCustomAttributes = "";
		if (!$this->Tmp_Lahir->Raw)
			$this->Tmp_Lahir->CurrentValue = HtmlDecode($this->Tmp_Lahir->CurrentValue);
		$this->Tmp_Lahir->EditValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

		// Tgl_Lahir
		$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
		$this->Tgl_Lahir->EditCustomAttributes = "";
		$this->Tgl_Lahir->EditValue = FormatDateTime($this->Tgl_Lahir->CurrentValue, 7);
		$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";

		// Kode_jp
		$this->Kode_jp->EditAttrs["class"] = "form-control";
		$this->Kode_jp->EditCustomAttributes = "";

		// Jurusan
		$this->Jurusan->EditAttrs["class"] = "form-control";
		$this->Jurusan->EditCustomAttributes = "";
		if (!$this->Jurusan->Raw)
			$this->Jurusan->CurrentValue = HtmlDecode($this->Jurusan->CurrentValue);
		$this->Jurusan->EditValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->PlaceHolder = RemoveHtml($this->Jurusan->caption());

		// Program
		$this->Program->EditAttrs["class"] = "form-control";
		$this->Program->EditCustomAttributes = "";
		if (!$this->Program->Raw)
			$this->Program->CurrentValue = HtmlDecode($this->Program->CurrentValue);
		$this->Program->EditValue = $this->Program->CurrentValue;
		$this->Program->PlaceHolder = RemoveHtml($this->Program->caption());

		// TaMasuk
		$this->TaMasuk->EditAttrs["class"] = "form-control";
		$this->TaMasuk->EditCustomAttributes = "";

		// PerMasuk
		$this->PerMasuk->EditAttrs["class"] = "form-control";
		$this->PerMasuk->EditCustomAttributes = "";
		$this->PerMasuk->EditValue = $this->PerMasuk->options(TRUE);

		// SemesterMulai
		$this->SemesterMulai->EditAttrs["class"] = "form-control";
		$this->SemesterMulai->EditCustomAttributes = "";
		if (!$this->SemesterMulai->Raw)
			$this->SemesterMulai->CurrentValue = HtmlDecode($this->SemesterMulai->CurrentValue);
		$this->SemesterMulai->EditValue = $this->SemesterMulai->CurrentValue;
		$this->SemesterMulai->PlaceHolder = RemoveHtml($this->SemesterMulai->caption());

		// tglmasuk
		$this->tglmasuk->EditAttrs["class"] = "form-control";
		$this->tglmasuk->EditCustomAttributes = "";
		$this->tglmasuk->EditValue = FormatDateTime($this->tglmasuk->CurrentValue, 7);
		$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

		// Status
		$this->Status->EditAttrs["class"] = "form-control";
		$this->Status->EditCustomAttributes = "";
		if (!$this->Status->Raw)
			$this->Status->CurrentValue = HtmlDecode($this->Status->CurrentValue);
		$this->Status->EditValue = $this->Status->CurrentValue;
		$this->Status->PlaceHolder = RemoveHtml($this->Status->caption());

		// StatusAkhir
		$this->StatusAkhir->EditAttrs["class"] = "form-control";
		$this->StatusAkhir->EditCustomAttributes = "";
		if (!$this->StatusAkhir->Raw)
			$this->StatusAkhir->CurrentValue = HtmlDecode($this->StatusAkhir->CurrentValue);
		$this->StatusAkhir->EditValue = $this->StatusAkhir->CurrentValue;
		$this->StatusAkhir->PlaceHolder = RemoveHtml($this->StatusAkhir->caption());

		// SemesterKeluar_Lulus
		$this->SemesterKeluar_Lulus->EditAttrs["class"] = "form-control";
		$this->SemesterKeluar_Lulus->EditCustomAttributes = "";
		if (!$this->SemesterKeluar_Lulus->Raw)
			$this->SemesterKeluar_Lulus->CurrentValue = HtmlDecode($this->SemesterKeluar_Lulus->CurrentValue);
		$this->SemesterKeluar_Lulus->EditValue = $this->SemesterKeluar_Lulus->CurrentValue;
		$this->SemesterKeluar_Lulus->PlaceHolder = RemoveHtml($this->SemesterKeluar_Lulus->caption());

		// Status_Masuk
		$this->Status_Masuk->EditAttrs["class"] = "form-control";
		$this->Status_Masuk->EditCustomAttributes = "";
		$this->Status_Masuk->EditValue = $this->Status_Masuk->options(TRUE);

		// AwalPendaftaran
		$this->AwalPendaftaran->EditAttrs["class"] = "form-control";
		$this->AwalPendaftaran->EditCustomAttributes = "";
		if (!$this->AwalPendaftaran->Raw)
			$this->AwalPendaftaran->CurrentValue = HtmlDecode($this->AwalPendaftaran->CurrentValue);
		$this->AwalPendaftaran->EditValue = $this->AwalPendaftaran->CurrentValue;
		$this->AwalPendaftaran->PlaceHolder = RemoveHtml($this->AwalPendaftaran->caption());

		// Pwl
		$this->Pwl->EditAttrs["class"] = "form-control";
		$this->Pwl->EditCustomAttributes = "";
		$this->Pwl->EditValue = $this->Pwl->CurrentValue;
		$this->Pwl->PlaceHolder = RemoveHtml($this->Pwl->caption());

		// Ijazah
		$this->Ijazah->EditAttrs["class"] = "form-control";
		$this->Ijazah->EditCustomAttributes = "";
		if (!$this->Ijazah->Raw)
			$this->Ijazah->CurrentValue = HtmlDecode($this->Ijazah->CurrentValue);
		$this->Ijazah->EditValue = $this->Ijazah->CurrentValue;
		$this->Ijazah->PlaceHolder = RemoveHtml($this->Ijazah->caption());

		// Ktp
		$this->Ktp->EditAttrs["class"] = "form-control";
		$this->Ktp->EditCustomAttributes = "";
		if (!$this->Ktp->Raw)
			$this->Ktp->CurrentValue = HtmlDecode($this->Ktp->CurrentValue);
		$this->Ktp->EditValue = $this->Ktp->CurrentValue;
		$this->Ktp->PlaceHolder = RemoveHtml($this->Ktp->caption());

		// KK
		$this->KK->EditAttrs["class"] = "form-control";
		$this->KK->EditCustomAttributes = "";
		if (!$this->KK->Raw)
			$this->KK->CurrentValue = HtmlDecode($this->KK->CurrentValue);
		$this->KK->EditValue = $this->KK->CurrentValue;
		$this->KK->PlaceHolder = RemoveHtml($this->KK->caption());

		// tandatangan
		$this->tandatangan->EditAttrs["class"] = "form-control";
		$this->tandatangan->EditCustomAttributes = "";
		if (!$this->tandatangan->Raw)
			$this->tandatangan->CurrentValue = HtmlDecode($this->tandatangan->CurrentValue);
		$this->tandatangan->EditValue = $this->tandatangan->CurrentValue;
		$this->tandatangan->PlaceHolder = RemoveHtml($this->tandatangan->caption());

		// IjazahIM
		$this->IjazahIM->EditAttrs["class"] = "form-control";
		$this->IjazahIM->EditCustomAttributes = "";
		if (!$this->IjazahIM->Raw)
			$this->IjazahIM->CurrentValue = HtmlDecode($this->IjazahIM->CurrentValue);
		$this->IjazahIM->EditValue = $this->IjazahIM->CurrentValue;
		$this->IjazahIM->PlaceHolder = RemoveHtml($this->IjazahIM->caption());

		// TranskriptIM
		$this->TranskriptIM->EditAttrs["class"] = "form-control";
		$this->TranskriptIM->EditCustomAttributes = "";
		if (!$this->TranskriptIM->Raw)
			$this->TranskriptIM->CurrentValue = HtmlDecode($this->TranskriptIM->CurrentValue);
		$this->TranskriptIM->EditValue = $this->TranskriptIM->CurrentValue;
		$this->TranskriptIM->PlaceHolder = RemoveHtml($this->TranskriptIM->caption());

		// Skripsi
		$this->Skripsi->EditAttrs["class"] = "form-control";
		$this->Skripsi->EditCustomAttributes = "";
		if (!$this->Skripsi->Raw)
			$this->Skripsi->CurrentValue = HtmlDecode($this->Skripsi->CurrentValue);
		$this->Skripsi->EditValue = $this->Skripsi->CurrentValue;
		$this->Skripsi->PlaceHolder = RemoveHtml($this->Skripsi->caption());

		// TASkripsi
		$this->TASkripsi->EditAttrs["class"] = "form-control";
		$this->TASkripsi->EditCustomAttributes = "";
		if (!$this->TASkripsi->Raw)
			$this->TASkripsi->CurrentValue = HtmlDecode($this->TASkripsi->CurrentValue);
		$this->TASkripsi->EditValue = $this->TASkripsi->CurrentValue;
		$this->TASkripsi->PlaceHolder = RemoveHtml($this->TASkripsi->caption());

		// Plagiat
		$this->Plagiat->EditAttrs["class"] = "form-control";
		$this->Plagiat->EditCustomAttributes = "";
		if (!$this->Plagiat->Raw)
			$this->Plagiat->CurrentValue = HtmlDecode($this->Plagiat->CurrentValue);
		$this->Plagiat->EditValue = $this->Plagiat->CurrentValue;
		$this->Plagiat->PlaceHolder = RemoveHtml($this->Plagiat->caption());

		// riwayatakademik
		$this->riwayatakademik->EditAttrs["class"] = "form-control";
		$this->riwayatakademik->EditCustomAttributes = "";
		if (!$this->riwayatakademik->Raw)
			$this->riwayatakademik->CurrentValue = HtmlDecode($this->riwayatakademik->CurrentValue);
		$this->riwayatakademik->EditValue = $this->riwayatakademik->CurrentValue;
		$this->riwayatakademik->PlaceHolder = RemoveHtml($this->riwayatakademik->caption());

		// keuangan
		$this->keuangan->EditAttrs["class"] = "form-control";
		$this->keuangan->EditCustomAttributes = "";
		if (!$this->keuangan->Raw)
			$this->keuangan->CurrentValue = HtmlDecode($this->keuangan->CurrentValue);
		$this->keuangan->EditValue = $this->keuangan->CurrentValue;
		$this->keuangan->PlaceHolder = RemoveHtml($this->keuangan->caption());

		// pendukung
		$this->pendukung->EditAttrs["class"] = "form-control";
		$this->pendukung->EditCustomAttributes = "";
		if (!$this->pendukung->Raw)
			$this->pendukung->CurrentValue = HtmlDecode($this->pendukung->CurrentValue);
		$this->pendukung->EditValue = $this->pendukung->CurrentValue;
		$this->pendukung->PlaceHolder = RemoveHtml($this->pendukung->caption());

		// lainlain
		$this->lainlain->EditAttrs["class"] = "form-control";
		$this->lainlain->EditCustomAttributes = "";
		if (!$this->lainlain->Raw)
			$this->lainlain->CurrentValue = HtmlDecode($this->lainlain->CurrentValue);
		$this->lainlain->EditValue = $this->lainlain->CurrentValue;
		$this->lainlain->PlaceHolder = RemoveHtml($this->lainlain->caption());

		// Ferval
		$this->Ferval->EditAttrs["class"] = "form-control";
		$this->Ferval->EditCustomAttributes = "";
		if (!$this->Ferval->Raw)
			$this->Ferval->CurrentValue = HtmlDecode($this->Ferval->CurrentValue);
		$this->Ferval->EditValue = $this->Ferval->CurrentValue;
		$this->Ferval->PlaceHolder = RemoveHtml($this->Ferval->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->SemesterMulai);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->StatusAkhir);
					$doc->exportCaption($this->SemesterKeluar_Lulus);
					$doc->exportCaption($this->Status_Masuk);
					$doc->exportCaption($this->AwalPendaftaran);
					$doc->exportCaption($this->Pwl);
					$doc->exportCaption($this->Ijazah);
					$doc->exportCaption($this->Ktp);
					$doc->exportCaption($this->KK);
					$doc->exportCaption($this->tandatangan);
					$doc->exportCaption($this->IjazahIM);
					$doc->exportCaption($this->TranskriptIM);
					$doc->exportCaption($this->Skripsi);
					$doc->exportCaption($this->TASkripsi);
					$doc->exportCaption($this->Plagiat);
					$doc->exportCaption($this->riwayatakademik);
					$doc->exportCaption($this->keuangan);
					$doc->exportCaption($this->pendukung);
					$doc->exportCaption($this->lainlain);
					$doc->exportCaption($this->Ferval);
				} else {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Program);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->SemesterMulai);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->StatusAkhir);
					$doc->exportCaption($this->SemesterKeluar_Lulus);
					$doc->exportCaption($this->Status_Masuk);
					$doc->exportCaption($this->AwalPendaftaran);
					$doc->exportCaption($this->Pwl);
					$doc->exportCaption($this->Ijazah);
					$doc->exportCaption($this->Ktp);
					$doc->exportCaption($this->KK);
					$doc->exportCaption($this->tandatangan);
					$doc->exportCaption($this->IjazahIM);
					$doc->exportCaption($this->TranskriptIM);
					$doc->exportCaption($this->Skripsi);
					$doc->exportCaption($this->TASkripsi);
					$doc->exportCaption($this->Plagiat);
					$doc->exportCaption($this->riwayatakademik);
					$doc->exportCaption($this->keuangan);
					$doc->exportCaption($this->pendukung);
					$doc->exportCaption($this->lainlain);
					$doc->exportCaption($this->Ferval);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->SemesterMulai);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Status);
						$doc->exportField($this->StatusAkhir);
						$doc->exportField($this->SemesterKeluar_Lulus);
						$doc->exportField($this->Status_Masuk);
						$doc->exportField($this->AwalPendaftaran);
						$doc->exportField($this->Pwl);
						$doc->exportField($this->Ijazah);
						$doc->exportField($this->Ktp);
						$doc->exportField($this->KK);
						$doc->exportField($this->tandatangan);
						$doc->exportField($this->IjazahIM);
						$doc->exportField($this->TranskriptIM);
						$doc->exportField($this->Skripsi);
						$doc->exportField($this->TASkripsi);
						$doc->exportField($this->Plagiat);
						$doc->exportField($this->riwayatakademik);
						$doc->exportField($this->keuangan);
						$doc->exportField($this->pendukung);
						$doc->exportField($this->lainlain);
						$doc->exportField($this->Ferval);
					} else {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Program);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->SemesterMulai);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Status);
						$doc->exportField($this->StatusAkhir);
						$doc->exportField($this->SemesterKeluar_Lulus);
						$doc->exportField($this->Status_Masuk);
						$doc->exportField($this->AwalPendaftaran);
						$doc->exportField($this->Pwl);
						$doc->exportField($this->Ijazah);
						$doc->exportField($this->Ktp);
						$doc->exportField($this->KK);
						$doc->exportField($this->tandatangan);
						$doc->exportField($this->IjazahIM);
						$doc->exportField($this->TranskriptIM);
						$doc->exportField($this->Skripsi);
						$doc->exportField($this->TASkripsi);
						$doc->exportField($this->Plagiat);
						$doc->exportField($this->riwayatakademik);
						$doc->exportField($this->keuangan);
						$doc->exportField($this->pendukung);
						$doc->exportField($this->lainlain);
						$doc->exportField($this->Ferval);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>