<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class IM_Mhs_list extends IM_Mhs
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'IM_Mhs';

	// Page object name
	public $PageObjName = "IM_Mhs_list";

	// Grid form hidden field names
	public $FormName = "fIM_Mhslist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (IM_Mhs)
		if (!isset($GLOBALS["IM_Mhs"]) || get_class($GLOBALS["IM_Mhs"]) == PROJECT_NAMESPACE . "IM_Mhs") {
			$GLOBALS["IM_Mhs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["IM_Mhs"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "IM_Mhsadd.php?" . Config("TABLE_SHOW_DETAIL") . "=";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "IM_Mhsdelete.php";
		$this->MultiUpdateUrl = "IM_Mhsupdate.php";

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'IM_Mhs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option fIM_Mhslistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $IM_Mhs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($IM_Mhs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0)
							$val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAddOrEdit())
			$this->Kode_Fak->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Jurusan->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Program->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->SemesterMulai->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->StatusAkhir->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->SemesterKeluar_Lulus->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->AwalPendaftaran->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Pwl->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Ijazah->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Ktp->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->KK->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->tandatangan->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->IjazahIM->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->TranskriptIM->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Skripsi->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->TASkripsi->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Plagiat->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->riwayatakademik->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->keuangan->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->pendukung->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->lainlain->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Ferval->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "15,20,30,90,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $docmhs_Count;
	public $tblNilaiPerMhs_Count;
	public $Wali_IPS_Count;
	public $ekpt_Ferval_Count;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canList()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom != "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (Config("USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (Config("USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->Nim->setVisibility();
		$this->Nama_Mhs->setVisibility();
		$this->Tmp_Lahir->setVisibility();
		$this->Tgl_Lahir->setVisibility();
		$this->Status_Akd->setVisibility();
		$this->Kode_Fak->setVisibility();
		$this->Kode_jp->setVisibility();
		$this->Jurusan->Visible = FALSE;
		$this->Program->Visible = FALSE;
		$this->TaMasuk->setVisibility();
		$this->PerMasuk->setVisibility();
		$this->SemesterMulai->setVisibility();
		$this->tglmasuk->setVisibility();
		$this->Status->setVisibility();
		$this->StatusAkhir->setVisibility();
		$this->SemesterKeluar_Lulus->setVisibility();
		$this->Status_Masuk->setVisibility();
		$this->AwalPendaftaran->setVisibility();
		$this->Pwl->setVisibility();
		$this->Ijazah->setVisibility();
		$this->Ktp->setVisibility();
		$this->KK->setVisibility();
		$this->tandatangan->Visible = FALSE;
		$this->IjazahIM->setVisibility();
		$this->TranskriptIM->setVisibility();
		$this->Skripsi->setVisibility();
		$this->TASkripsi->setVisibility();
		$this->Plagiat->setVisibility();
		$this->riwayatakademik->setVisibility();
		$this->keuangan->setVisibility();
		$this->pendukung->setVisibility();
		$this->lainlain->setVisibility();
		$this->Ferval->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->Status_Akd);
		$this->setupLookupOptions($this->Kode_Fak);
		$this->setupLookupOptions($this->Kode_jp);
		$this->setupLookupOptions($this->TaMasuk);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->Nim->setOldValue($arKeyFlds[0]);
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->Nim->AdvancedSearch->toJson(), ","); // Field Nim
		$filterList = Concat($filterList, $this->Nama_Mhs->AdvancedSearch->toJson(), ","); // Field Nama_Mhs
		$filterList = Concat($filterList, $this->Tmp_Lahir->AdvancedSearch->toJson(), ","); // Field Tmp_Lahir
		$filterList = Concat($filterList, $this->Tgl_Lahir->AdvancedSearch->toJson(), ","); // Field Tgl_Lahir
		$filterList = Concat($filterList, $this->Status_Akd->AdvancedSearch->toJson(), ","); // Field Status_Akd
		$filterList = Concat($filterList, $this->Kode_Fak->AdvancedSearch->toJson(), ","); // Field Kode_Fak
		$filterList = Concat($filterList, $this->Kode_jp->AdvancedSearch->toJson(), ","); // Field Kode_jp
		$filterList = Concat($filterList, $this->Jurusan->AdvancedSearch->toJson(), ","); // Field Jurusan
		$filterList = Concat($filterList, $this->Program->AdvancedSearch->toJson(), ","); // Field Program
		$filterList = Concat($filterList, $this->TaMasuk->AdvancedSearch->toJson(), ","); // Field TaMasuk
		$filterList = Concat($filterList, $this->PerMasuk->AdvancedSearch->toJson(), ","); // Field PerMasuk
		$filterList = Concat($filterList, $this->SemesterMulai->AdvancedSearch->toJson(), ","); // Field SemesterMulai
		$filterList = Concat($filterList, $this->tglmasuk->AdvancedSearch->toJson(), ","); // Field tglmasuk
		$filterList = Concat($filterList, $this->Status->AdvancedSearch->toJson(), ","); // Field Status
		$filterList = Concat($filterList, $this->StatusAkhir->AdvancedSearch->toJson(), ","); // Field StatusAkhir
		$filterList = Concat($filterList, $this->SemesterKeluar_Lulus->AdvancedSearch->toJson(), ","); // Field SemesterKeluar_Lulus
		$filterList = Concat($filterList, $this->Status_Masuk->AdvancedSearch->toJson(), ","); // Field Status_Masuk
		$filterList = Concat($filterList, $this->AwalPendaftaran->AdvancedSearch->toJson(), ","); // Field AwalPendaftaran
		$filterList = Concat($filterList, $this->Pwl->AdvancedSearch->toJson(), ","); // Field Pwl
		$filterList = Concat($filterList, $this->Ijazah->AdvancedSearch->toJson(), ","); // Field Ijazah
		$filterList = Concat($filterList, $this->Ktp->AdvancedSearch->toJson(), ","); // Field Ktp
		$filterList = Concat($filterList, $this->KK->AdvancedSearch->toJson(), ","); // Field KK
		$filterList = Concat($filterList, $this->tandatangan->AdvancedSearch->toJson(), ","); // Field tandatangan
		$filterList = Concat($filterList, $this->IjazahIM->AdvancedSearch->toJson(), ","); // Field IjazahIM
		$filterList = Concat($filterList, $this->TranskriptIM->AdvancedSearch->toJson(), ","); // Field TranskriptIM
		$filterList = Concat($filterList, $this->Skripsi->AdvancedSearch->toJson(), ","); // Field Skripsi
		$filterList = Concat($filterList, $this->TASkripsi->AdvancedSearch->toJson(), ","); // Field TASkripsi
		$filterList = Concat($filterList, $this->Plagiat->AdvancedSearch->toJson(), ","); // Field Plagiat
		$filterList = Concat($filterList, $this->riwayatakademik->AdvancedSearch->toJson(), ","); // Field riwayatakademik
		$filterList = Concat($filterList, $this->keuangan->AdvancedSearch->toJson(), ","); // Field keuangan
		$filterList = Concat($filterList, $this->pendukung->AdvancedSearch->toJson(), ","); // Field pendukung
		$filterList = Concat($filterList, $this->lainlain->AdvancedSearch->toJson(), ","); // Field lainlain
		$filterList = Concat($filterList, $this->Ferval->AdvancedSearch->toJson(), ","); // Field Ferval
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fIM_Mhslistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field Nim
		$this->Nim->AdvancedSearch->SearchValue = @$filter["x_Nim"];
		$this->Nim->AdvancedSearch->SearchOperator = @$filter["z_Nim"];
		$this->Nim->AdvancedSearch->SearchCondition = @$filter["v_Nim"];
		$this->Nim->AdvancedSearch->SearchValue2 = @$filter["y_Nim"];
		$this->Nim->AdvancedSearch->SearchOperator2 = @$filter["w_Nim"];
		$this->Nim->AdvancedSearch->save();

		// Field Nama_Mhs
		$this->Nama_Mhs->AdvancedSearch->SearchValue = @$filter["x_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->SearchOperator = @$filter["z_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->SearchCondition = @$filter["v_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->SearchValue2 = @$filter["y_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->SearchOperator2 = @$filter["w_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->save();

		// Field Tmp_Lahir
		$this->Tmp_Lahir->AdvancedSearch->SearchValue = @$filter["x_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchOperator = @$filter["z_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchCondition = @$filter["v_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchValue2 = @$filter["y_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchOperator2 = @$filter["w_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->save();

		// Field Tgl_Lahir
		$this->Tgl_Lahir->AdvancedSearch->SearchValue = @$filter["x_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchOperator = @$filter["z_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchCondition = @$filter["v_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchValue2 = @$filter["y_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchOperator2 = @$filter["w_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->save();

		// Field Status_Akd
		$this->Status_Akd->AdvancedSearch->SearchValue = @$filter["x_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->SearchOperator = @$filter["z_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->SearchCondition = @$filter["v_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->SearchValue2 = @$filter["y_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->SearchOperator2 = @$filter["w_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->save();

		// Field Kode_Fak
		$this->Kode_Fak->AdvancedSearch->SearchValue = @$filter["x_Kode_Fak"];
		$this->Kode_Fak->AdvancedSearch->SearchOperator = @$filter["z_Kode_Fak"];
		$this->Kode_Fak->AdvancedSearch->SearchCondition = @$filter["v_Kode_Fak"];
		$this->Kode_Fak->AdvancedSearch->SearchValue2 = @$filter["y_Kode_Fak"];
		$this->Kode_Fak->AdvancedSearch->SearchOperator2 = @$filter["w_Kode_Fak"];
		$this->Kode_Fak->AdvancedSearch->save();

		// Field Kode_jp
		$this->Kode_jp->AdvancedSearch->SearchValue = @$filter["x_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->SearchOperator = @$filter["z_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->SearchCondition = @$filter["v_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->SearchValue2 = @$filter["y_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->SearchOperator2 = @$filter["w_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->save();

		// Field Jurusan
		$this->Jurusan->AdvancedSearch->SearchValue = @$filter["x_Jurusan"];
		$this->Jurusan->AdvancedSearch->SearchOperator = @$filter["z_Jurusan"];
		$this->Jurusan->AdvancedSearch->SearchCondition = @$filter["v_Jurusan"];
		$this->Jurusan->AdvancedSearch->SearchValue2 = @$filter["y_Jurusan"];
		$this->Jurusan->AdvancedSearch->SearchOperator2 = @$filter["w_Jurusan"];
		$this->Jurusan->AdvancedSearch->save();

		// Field Program
		$this->Program->AdvancedSearch->SearchValue = @$filter["x_Program"];
		$this->Program->AdvancedSearch->SearchOperator = @$filter["z_Program"];
		$this->Program->AdvancedSearch->SearchCondition = @$filter["v_Program"];
		$this->Program->AdvancedSearch->SearchValue2 = @$filter["y_Program"];
		$this->Program->AdvancedSearch->SearchOperator2 = @$filter["w_Program"];
		$this->Program->AdvancedSearch->save();

		// Field TaMasuk
		$this->TaMasuk->AdvancedSearch->SearchValue = @$filter["x_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->SearchOperator = @$filter["z_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->SearchCondition = @$filter["v_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->SearchValue2 = @$filter["y_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->SearchOperator2 = @$filter["w_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->save();

		// Field PerMasuk
		$this->PerMasuk->AdvancedSearch->SearchValue = @$filter["x_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->SearchOperator = @$filter["z_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->SearchCondition = @$filter["v_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->SearchValue2 = @$filter["y_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->SearchOperator2 = @$filter["w_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->save();

		// Field SemesterMulai
		$this->SemesterMulai->AdvancedSearch->SearchValue = @$filter["x_SemesterMulai"];
		$this->SemesterMulai->AdvancedSearch->SearchOperator = @$filter["z_SemesterMulai"];
		$this->SemesterMulai->AdvancedSearch->SearchCondition = @$filter["v_SemesterMulai"];
		$this->SemesterMulai->AdvancedSearch->SearchValue2 = @$filter["y_SemesterMulai"];
		$this->SemesterMulai->AdvancedSearch->SearchOperator2 = @$filter["w_SemesterMulai"];
		$this->SemesterMulai->AdvancedSearch->save();

		// Field tglmasuk
		$this->tglmasuk->AdvancedSearch->SearchValue = @$filter["x_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->SearchOperator = @$filter["z_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->SearchCondition = @$filter["v_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->SearchValue2 = @$filter["y_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->SearchOperator2 = @$filter["w_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->save();

		// Field Status
		$this->Status->AdvancedSearch->SearchValue = @$filter["x_Status"];
		$this->Status->AdvancedSearch->SearchOperator = @$filter["z_Status"];
		$this->Status->AdvancedSearch->SearchCondition = @$filter["v_Status"];
		$this->Status->AdvancedSearch->SearchValue2 = @$filter["y_Status"];
		$this->Status->AdvancedSearch->SearchOperator2 = @$filter["w_Status"];
		$this->Status->AdvancedSearch->save();

		// Field StatusAkhir
		$this->StatusAkhir->AdvancedSearch->SearchValue = @$filter["x_StatusAkhir"];
		$this->StatusAkhir->AdvancedSearch->SearchOperator = @$filter["z_StatusAkhir"];
		$this->StatusAkhir->AdvancedSearch->SearchCondition = @$filter["v_StatusAkhir"];
		$this->StatusAkhir->AdvancedSearch->SearchValue2 = @$filter["y_StatusAkhir"];
		$this->StatusAkhir->AdvancedSearch->SearchOperator2 = @$filter["w_StatusAkhir"];
		$this->StatusAkhir->AdvancedSearch->save();

		// Field SemesterKeluar_Lulus
		$this->SemesterKeluar_Lulus->AdvancedSearch->SearchValue = @$filter["x_SemesterKeluar_Lulus"];
		$this->SemesterKeluar_Lulus->AdvancedSearch->SearchOperator = @$filter["z_SemesterKeluar_Lulus"];
		$this->SemesterKeluar_Lulus->AdvancedSearch->SearchCondition = @$filter["v_SemesterKeluar_Lulus"];
		$this->SemesterKeluar_Lulus->AdvancedSearch->SearchValue2 = @$filter["y_SemesterKeluar_Lulus"];
		$this->SemesterKeluar_Lulus->AdvancedSearch->SearchOperator2 = @$filter["w_SemesterKeluar_Lulus"];
		$this->SemesterKeluar_Lulus->AdvancedSearch->save();

		// Field Status_Masuk
		$this->Status_Masuk->AdvancedSearch->SearchValue = @$filter["x_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->SearchOperator = @$filter["z_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->SearchCondition = @$filter["v_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->SearchValue2 = @$filter["y_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->SearchOperator2 = @$filter["w_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->save();

		// Field AwalPendaftaran
		$this->AwalPendaftaran->AdvancedSearch->SearchValue = @$filter["x_AwalPendaftaran"];
		$this->AwalPendaftaran->AdvancedSearch->SearchOperator = @$filter["z_AwalPendaftaran"];
		$this->AwalPendaftaran->AdvancedSearch->SearchCondition = @$filter["v_AwalPendaftaran"];
		$this->AwalPendaftaran->AdvancedSearch->SearchValue2 = @$filter["y_AwalPendaftaran"];
		$this->AwalPendaftaran->AdvancedSearch->SearchOperator2 = @$filter["w_AwalPendaftaran"];
		$this->AwalPendaftaran->AdvancedSearch->save();

		// Field Pwl
		$this->Pwl->AdvancedSearch->SearchValue = @$filter["x_Pwl"];
		$this->Pwl->AdvancedSearch->SearchOperator = @$filter["z_Pwl"];
		$this->Pwl->AdvancedSearch->SearchCondition = @$filter["v_Pwl"];
		$this->Pwl->AdvancedSearch->SearchValue2 = @$filter["y_Pwl"];
		$this->Pwl->AdvancedSearch->SearchOperator2 = @$filter["w_Pwl"];
		$this->Pwl->AdvancedSearch->save();

		// Field Ijazah
		$this->Ijazah->AdvancedSearch->SearchValue = @$filter["x_Ijazah"];
		$this->Ijazah->AdvancedSearch->SearchOperator = @$filter["z_Ijazah"];
		$this->Ijazah->AdvancedSearch->SearchCondition = @$filter["v_Ijazah"];
		$this->Ijazah->AdvancedSearch->SearchValue2 = @$filter["y_Ijazah"];
		$this->Ijazah->AdvancedSearch->SearchOperator2 = @$filter["w_Ijazah"];
		$this->Ijazah->AdvancedSearch->save();

		// Field Ktp
		$this->Ktp->AdvancedSearch->SearchValue = @$filter["x_Ktp"];
		$this->Ktp->AdvancedSearch->SearchOperator = @$filter["z_Ktp"];
		$this->Ktp->AdvancedSearch->SearchCondition = @$filter["v_Ktp"];
		$this->Ktp->AdvancedSearch->SearchValue2 = @$filter["y_Ktp"];
		$this->Ktp->AdvancedSearch->SearchOperator2 = @$filter["w_Ktp"];
		$this->Ktp->AdvancedSearch->save();

		// Field KK
		$this->KK->AdvancedSearch->SearchValue = @$filter["x_KK"];
		$this->KK->AdvancedSearch->SearchOperator = @$filter["z_KK"];
		$this->KK->AdvancedSearch->SearchCondition = @$filter["v_KK"];
		$this->KK->AdvancedSearch->SearchValue2 = @$filter["y_KK"];
		$this->KK->AdvancedSearch->SearchOperator2 = @$filter["w_KK"];
		$this->KK->AdvancedSearch->save();

		// Field tandatangan
		$this->tandatangan->AdvancedSearch->SearchValue = @$filter["x_tandatangan"];
		$this->tandatangan->AdvancedSearch->SearchOperator = @$filter["z_tandatangan"];
		$this->tandatangan->AdvancedSearch->SearchCondition = @$filter["v_tandatangan"];
		$this->tandatangan->AdvancedSearch->SearchValue2 = @$filter["y_tandatangan"];
		$this->tandatangan->AdvancedSearch->SearchOperator2 = @$filter["w_tandatangan"];
		$this->tandatangan->AdvancedSearch->save();

		// Field IjazahIM
		$this->IjazahIM->AdvancedSearch->SearchValue = @$filter["x_IjazahIM"];
		$this->IjazahIM->AdvancedSearch->SearchOperator = @$filter["z_IjazahIM"];
		$this->IjazahIM->AdvancedSearch->SearchCondition = @$filter["v_IjazahIM"];
		$this->IjazahIM->AdvancedSearch->SearchValue2 = @$filter["y_IjazahIM"];
		$this->IjazahIM->AdvancedSearch->SearchOperator2 = @$filter["w_IjazahIM"];
		$this->IjazahIM->AdvancedSearch->save();

		// Field TranskriptIM
		$this->TranskriptIM->AdvancedSearch->SearchValue = @$filter["x_TranskriptIM"];
		$this->TranskriptIM->AdvancedSearch->SearchOperator = @$filter["z_TranskriptIM"];
		$this->TranskriptIM->AdvancedSearch->SearchCondition = @$filter["v_TranskriptIM"];
		$this->TranskriptIM->AdvancedSearch->SearchValue2 = @$filter["y_TranskriptIM"];
		$this->TranskriptIM->AdvancedSearch->SearchOperator2 = @$filter["w_TranskriptIM"];
		$this->TranskriptIM->AdvancedSearch->save();

		// Field Skripsi
		$this->Skripsi->AdvancedSearch->SearchValue = @$filter["x_Skripsi"];
		$this->Skripsi->AdvancedSearch->SearchOperator = @$filter["z_Skripsi"];
		$this->Skripsi->AdvancedSearch->SearchCondition = @$filter["v_Skripsi"];
		$this->Skripsi->AdvancedSearch->SearchValue2 = @$filter["y_Skripsi"];
		$this->Skripsi->AdvancedSearch->SearchOperator2 = @$filter["w_Skripsi"];
		$this->Skripsi->AdvancedSearch->save();

		// Field TASkripsi
		$this->TASkripsi->AdvancedSearch->SearchValue = @$filter["x_TASkripsi"];
		$this->TASkripsi->AdvancedSearch->SearchOperator = @$filter["z_TASkripsi"];
		$this->TASkripsi->AdvancedSearch->SearchCondition = @$filter["v_TASkripsi"];
		$this->TASkripsi->AdvancedSearch->SearchValue2 = @$filter["y_TASkripsi"];
		$this->TASkripsi->AdvancedSearch->SearchOperator2 = @$filter["w_TASkripsi"];
		$this->TASkripsi->AdvancedSearch->save();

		// Field Plagiat
		$this->Plagiat->AdvancedSearch->SearchValue = @$filter["x_Plagiat"];
		$this->Plagiat->AdvancedSearch->SearchOperator = @$filter["z_Plagiat"];
		$this->Plagiat->AdvancedSearch->SearchCondition = @$filter["v_Plagiat"];
		$this->Plagiat->AdvancedSearch->SearchValue2 = @$filter["y_Plagiat"];
		$this->Plagiat->AdvancedSearch->SearchOperator2 = @$filter["w_Plagiat"];
		$this->Plagiat->AdvancedSearch->save();

		// Field riwayatakademik
		$this->riwayatakademik->AdvancedSearch->SearchValue = @$filter["x_riwayatakademik"];
		$this->riwayatakademik->AdvancedSearch->SearchOperator = @$filter["z_riwayatakademik"];
		$this->riwayatakademik->AdvancedSearch->SearchCondition = @$filter["v_riwayatakademik"];
		$this->riwayatakademik->AdvancedSearch->SearchValue2 = @$filter["y_riwayatakademik"];
		$this->riwayatakademik->AdvancedSearch->SearchOperator2 = @$filter["w_riwayatakademik"];
		$this->riwayatakademik->AdvancedSearch->save();

		// Field keuangan
		$this->keuangan->AdvancedSearch->SearchValue = @$filter["x_keuangan"];
		$this->keuangan->AdvancedSearch->SearchOperator = @$filter["z_keuangan"];
		$this->keuangan->AdvancedSearch->SearchCondition = @$filter["v_keuangan"];
		$this->keuangan->AdvancedSearch->SearchValue2 = @$filter["y_keuangan"];
		$this->keuangan->AdvancedSearch->SearchOperator2 = @$filter["w_keuangan"];
		$this->keuangan->AdvancedSearch->save();

		// Field pendukung
		$this->pendukung->AdvancedSearch->SearchValue = @$filter["x_pendukung"];
		$this->pendukung->AdvancedSearch->SearchOperator = @$filter["z_pendukung"];
		$this->pendukung->AdvancedSearch->SearchCondition = @$filter["v_pendukung"];
		$this->pendukung->AdvancedSearch->SearchValue2 = @$filter["y_pendukung"];
		$this->pendukung->AdvancedSearch->SearchOperator2 = @$filter["w_pendukung"];
		$this->pendukung->AdvancedSearch->save();

		// Field lainlain
		$this->lainlain->AdvancedSearch->SearchValue = @$filter["x_lainlain"];
		$this->lainlain->AdvancedSearch->SearchOperator = @$filter["z_lainlain"];
		$this->lainlain->AdvancedSearch->SearchCondition = @$filter["v_lainlain"];
		$this->lainlain->AdvancedSearch->SearchValue2 = @$filter["y_lainlain"];
		$this->lainlain->AdvancedSearch->SearchOperator2 = @$filter["w_lainlain"];
		$this->lainlain->AdvancedSearch->save();

		// Field Ferval
		$this->Ferval->AdvancedSearch->SearchValue = @$filter["x_Ferval"];
		$this->Ferval->AdvancedSearch->SearchOperator = @$filter["z_Ferval"];
		$this->Ferval->AdvancedSearch->SearchCondition = @$filter["v_Ferval"];
		$this->Ferval->AdvancedSearch->SearchValue2 = @$filter["y_Ferval"];
		$this->Ferval->AdvancedSearch->SearchOperator2 = @$filter["w_Ferval"];
		$this->Ferval->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->Nim, $default, FALSE); // Nim
		$this->buildSearchSql($where, $this->Nama_Mhs, $default, FALSE); // Nama_Mhs
		$this->buildSearchSql($where, $this->Tmp_Lahir, $default, FALSE); // Tmp_Lahir
		$this->buildSearchSql($where, $this->Tgl_Lahir, $default, FALSE); // Tgl_Lahir
		$this->buildSearchSql($where, $this->Status_Akd, $default, FALSE); // Status_Akd
		$this->buildSearchSql($where, $this->Kode_Fak, $default, FALSE); // Kode_Fak
		$this->buildSearchSql($where, $this->Kode_jp, $default, FALSE); // Kode_jp
		$this->buildSearchSql($where, $this->Jurusan, $default, FALSE); // Jurusan
		$this->buildSearchSql($where, $this->Program, $default, FALSE); // Program
		$this->buildSearchSql($where, $this->TaMasuk, $default, FALSE); // TaMasuk
		$this->buildSearchSql($where, $this->PerMasuk, $default, FALSE); // PerMasuk
		$this->buildSearchSql($where, $this->SemesterMulai, $default, FALSE); // SemesterMulai
		$this->buildSearchSql($where, $this->tglmasuk, $default, FALSE); // tglmasuk
		$this->buildSearchSql($where, $this->Status, $default, FALSE); // Status
		$this->buildSearchSql($where, $this->StatusAkhir, $default, FALSE); // StatusAkhir
		$this->buildSearchSql($where, $this->SemesterKeluar_Lulus, $default, FALSE); // SemesterKeluar_Lulus
		$this->buildSearchSql($where, $this->Status_Masuk, $default, FALSE); // Status_Masuk
		$this->buildSearchSql($where, $this->AwalPendaftaran, $default, FALSE); // AwalPendaftaran
		$this->buildSearchSql($where, $this->Pwl, $default, FALSE); // Pwl
		$this->buildSearchSql($where, $this->Ijazah, $default, FALSE); // Ijazah
		$this->buildSearchSql($where, $this->Ktp, $default, FALSE); // Ktp
		$this->buildSearchSql($where, $this->KK, $default, FALSE); // KK
		$this->buildSearchSql($where, $this->tandatangan, $default, FALSE); // tandatangan
		$this->buildSearchSql($where, $this->IjazahIM, $default, FALSE); // IjazahIM
		$this->buildSearchSql($where, $this->TranskriptIM, $default, FALSE); // TranskriptIM
		$this->buildSearchSql($where, $this->Skripsi, $default, FALSE); // Skripsi
		$this->buildSearchSql($where, $this->TASkripsi, $default, FALSE); // TASkripsi
		$this->buildSearchSql($where, $this->Plagiat, $default, FALSE); // Plagiat
		$this->buildSearchSql($where, $this->riwayatakademik, $default, FALSE); // riwayatakademik
		$this->buildSearchSql($where, $this->keuangan, $default, FALSE); // keuangan
		$this->buildSearchSql($where, $this->pendukung, $default, FALSE); // pendukung
		$this->buildSearchSql($where, $this->lainlain, $default, FALSE); // lainlain
		$this->buildSearchSql($where, $this->Ferval, $default, FALSE); // Ferval

		// Set up search parm
		if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->Nim->AdvancedSearch->save(); // Nim
			$this->Nama_Mhs->AdvancedSearch->save(); // Nama_Mhs
			$this->Tmp_Lahir->AdvancedSearch->save(); // Tmp_Lahir
			$this->Tgl_Lahir->AdvancedSearch->save(); // Tgl_Lahir
			$this->Status_Akd->AdvancedSearch->save(); // Status_Akd
			$this->Kode_Fak->AdvancedSearch->save(); // Kode_Fak
			$this->Kode_jp->AdvancedSearch->save(); // Kode_jp
			$this->Jurusan->AdvancedSearch->save(); // Jurusan
			$this->Program->AdvancedSearch->save(); // Program
			$this->TaMasuk->AdvancedSearch->save(); // TaMasuk
			$this->PerMasuk->AdvancedSearch->save(); // PerMasuk
			$this->SemesterMulai->AdvancedSearch->save(); // SemesterMulai
			$this->tglmasuk->AdvancedSearch->save(); // tglmasuk
			$this->Status->AdvancedSearch->save(); // Status
			$this->StatusAkhir->AdvancedSearch->save(); // StatusAkhir
			$this->SemesterKeluar_Lulus->AdvancedSearch->save(); // SemesterKeluar_Lulus
			$this->Status_Masuk->AdvancedSearch->save(); // Status_Masuk
			$this->AwalPendaftaran->AdvancedSearch->save(); // AwalPendaftaran
			$this->Pwl->AdvancedSearch->save(); // Pwl
			$this->Ijazah->AdvancedSearch->save(); // Ijazah
			$this->Ktp->AdvancedSearch->save(); // Ktp
			$this->KK->AdvancedSearch->save(); // KK
			$this->tandatangan->AdvancedSearch->save(); // tandatangan
			$this->IjazahIM->AdvancedSearch->save(); // IjazahIM
			$this->TranskriptIM->AdvancedSearch->save(); // TranskriptIM
			$this->Skripsi->AdvancedSearch->save(); // Skripsi
			$this->TASkripsi->AdvancedSearch->save(); // TASkripsi
			$this->Plagiat->AdvancedSearch->save(); // Plagiat
			$this->riwayatakademik->AdvancedSearch->save(); // riwayatakademik
			$this->keuangan->AdvancedSearch->save(); // keuangan
			$this->pendukung->AdvancedSearch->save(); // pendukung
			$this->lainlain->AdvancedSearch->save(); // lainlain
			$this->Ferval->AdvancedSearch->save(); // Ferval
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 || !IsMultiSearchOperator($fldOpr))
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal != "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 != "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 != "")
				$wrk = ($wrk != "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == Config("NULL_VALUE") || $fldVal == Config("NOT_NULL_VALUE"))
			return $fldVal;
		$value = $fldVal;
		if ($fld->isBoolean()) {
			if ($fldVal != "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal != "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->Nim, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Nama_Mhs, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Tmp_Lahir, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_Akd, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kode_Fak, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kode_jp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Jurusan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Program, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TaMasuk, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PerMasuk, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SemesterMulai, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->StatusAkhir, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SemesterKeluar_Lulus, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_Masuk, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->AwalPendaftaran, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Ijazah, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Ktp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->KK, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tandatangan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->IjazahIM, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TranskriptIM, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Skripsi, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TASkripsi, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Plagiat, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->riwayatakademik, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->keuangan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pendukung, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->lainlain, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Ferval, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->Nim->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Nama_Mhs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Tmp_Lahir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Tgl_Lahir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Status_Akd->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kode_Fak->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kode_jp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Jurusan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Program->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TaMasuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PerMasuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->SemesterMulai->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->tglmasuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->StatusAkhir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->SemesterKeluar_Lulus->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Status_Masuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->AwalPendaftaran->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Pwl->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Ijazah->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Ktp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->KK->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->tandatangan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->IjazahIM->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TranskriptIM->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Skripsi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TASkripsi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Plagiat->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->riwayatakademik->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->keuangan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pendukung->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->lainlain->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Ferval->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->Nim->AdvancedSearch->unsetSession();
		$this->Nama_Mhs->AdvancedSearch->unsetSession();
		$this->Tmp_Lahir->AdvancedSearch->unsetSession();
		$this->Tgl_Lahir->AdvancedSearch->unsetSession();
		$this->Status_Akd->AdvancedSearch->unsetSession();
		$this->Kode_Fak->AdvancedSearch->unsetSession();
		$this->Kode_jp->AdvancedSearch->unsetSession();
		$this->Jurusan->AdvancedSearch->unsetSession();
		$this->Program->AdvancedSearch->unsetSession();
		$this->TaMasuk->AdvancedSearch->unsetSession();
		$this->PerMasuk->AdvancedSearch->unsetSession();
		$this->SemesterMulai->AdvancedSearch->unsetSession();
		$this->tglmasuk->AdvancedSearch->unsetSession();
		$this->Status->AdvancedSearch->unsetSession();
		$this->StatusAkhir->AdvancedSearch->unsetSession();
		$this->SemesterKeluar_Lulus->AdvancedSearch->unsetSession();
		$this->Status_Masuk->AdvancedSearch->unsetSession();
		$this->AwalPendaftaran->AdvancedSearch->unsetSession();
		$this->Pwl->AdvancedSearch->unsetSession();
		$this->Ijazah->AdvancedSearch->unsetSession();
		$this->Ktp->AdvancedSearch->unsetSession();
		$this->KK->AdvancedSearch->unsetSession();
		$this->tandatangan->AdvancedSearch->unsetSession();
		$this->IjazahIM->AdvancedSearch->unsetSession();
		$this->TranskriptIM->AdvancedSearch->unsetSession();
		$this->Skripsi->AdvancedSearch->unsetSession();
		$this->TASkripsi->AdvancedSearch->unsetSession();
		$this->Plagiat->AdvancedSearch->unsetSession();
		$this->riwayatakademik->AdvancedSearch->unsetSession();
		$this->keuangan->AdvancedSearch->unsetSession();
		$this->pendukung->AdvancedSearch->unsetSession();
		$this->lainlain->AdvancedSearch->unsetSession();
		$this->Ferval->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->Nim->AdvancedSearch->load();
		$this->Nama_Mhs->AdvancedSearch->load();
		$this->Tmp_Lahir->AdvancedSearch->load();
		$this->Tgl_Lahir->AdvancedSearch->load();
		$this->Status_Akd->AdvancedSearch->load();
		$this->Kode_Fak->AdvancedSearch->load();
		$this->Kode_jp->AdvancedSearch->load();
		$this->Jurusan->AdvancedSearch->load();
		$this->Program->AdvancedSearch->load();
		$this->TaMasuk->AdvancedSearch->load();
		$this->PerMasuk->AdvancedSearch->load();
		$this->SemesterMulai->AdvancedSearch->load();
		$this->tglmasuk->AdvancedSearch->load();
		$this->Status->AdvancedSearch->load();
		$this->StatusAkhir->AdvancedSearch->load();
		$this->SemesterKeluar_Lulus->AdvancedSearch->load();
		$this->Status_Masuk->AdvancedSearch->load();
		$this->AwalPendaftaran->AdvancedSearch->load();
		$this->Pwl->AdvancedSearch->load();
		$this->Ijazah->AdvancedSearch->load();
		$this->Ktp->AdvancedSearch->load();
		$this->KK->AdvancedSearch->load();
		$this->tandatangan->AdvancedSearch->load();
		$this->IjazahIM->AdvancedSearch->load();
		$this->TranskriptIM->AdvancedSearch->load();
		$this->Skripsi->AdvancedSearch->load();
		$this->TASkripsi->AdvancedSearch->load();
		$this->Plagiat->AdvancedSearch->load();
		$this->riwayatakademik->AdvancedSearch->load();
		$this->keuangan->AdvancedSearch->load();
		$this->pendukung->AdvancedSearch->load();
		$this->lainlain->AdvancedSearch->load();
		$this->Ferval->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->Nim); // Nim
			$this->updateSort($this->Nama_Mhs); // Nama_Mhs
			$this->updateSort($this->Tmp_Lahir); // Tmp_Lahir
			$this->updateSort($this->Tgl_Lahir); // Tgl_Lahir
			$this->updateSort($this->Status_Akd); // Status_Akd
			$this->updateSort($this->Kode_Fak); // Kode_Fak
			$this->updateSort($this->Kode_jp); // Kode_jp
			$this->updateSort($this->TaMasuk); // TaMasuk
			$this->updateSort($this->PerMasuk); // PerMasuk
			$this->updateSort($this->SemesterMulai); // SemesterMulai
			$this->updateSort($this->tglmasuk); // tglmasuk
			$this->updateSort($this->Status); // Status
			$this->updateSort($this->StatusAkhir); // StatusAkhir
			$this->updateSort($this->SemesterKeluar_Lulus); // SemesterKeluar_Lulus
			$this->updateSort($this->Status_Masuk); // Status_Masuk
			$this->updateSort($this->AwalPendaftaran); // AwalPendaftaran
			$this->updateSort($this->Pwl); // Pwl
			$this->updateSort($this->Ijazah); // Ijazah
			$this->updateSort($this->Ktp); // Ktp
			$this->updateSort($this->KK); // KK
			$this->updateSort($this->IjazahIM); // IjazahIM
			$this->updateSort($this->TranskriptIM); // TranskriptIM
			$this->updateSort($this->Skripsi); // Skripsi
			$this->updateSort($this->TASkripsi); // TASkripsi
			$this->updateSort($this->Plagiat); // Plagiat
			$this->updateSort($this->riwayatakademik); // riwayatakademik
			$this->updateSort($this->keuangan); // keuangan
			$this->updateSort($this->pendukung); // pendukung
			$this->updateSort($this->lainlain); // lainlain
			$this->updateSort($this->Ferval); // Ferval
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->Nim->setSort("");
				$this->Nama_Mhs->setSort("");
				$this->Tmp_Lahir->setSort("");
				$this->Tgl_Lahir->setSort("");
				$this->Status_Akd->setSort("");
				$this->Kode_Fak->setSort("");
				$this->Kode_jp->setSort("");
				$this->TaMasuk->setSort("");
				$this->PerMasuk->setSort("");
				$this->SemesterMulai->setSort("");
				$this->tglmasuk->setSort("");
				$this->Status->setSort("");
				$this->StatusAkhir->setSort("");
				$this->SemesterKeluar_Lulus->setSort("");
				$this->Status_Masuk->setSort("");
				$this->AwalPendaftaran->setSort("");
				$this->Pwl->setSort("");
				$this->Ijazah->setSort("");
				$this->Ktp->setSort("");
				$this->KK->setSort("");
				$this->IjazahIM->setSort("");
				$this->TranskriptIM->setSort("");
				$this->Skripsi->setSort("");
				$this->TASkripsi->setSort("");
				$this->Plagiat->setSort("");
				$this->riwayatakademik->setSort("");
				$this->keuangan->setSort("");
				$this->pendukung->setSort("");
				$this->lainlain->setSort("");
				$this->Ferval->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "detail_docmhs"
		$item = &$this->ListOptions->add("detail_docmhs");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 'docmhs') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["docmhs_grid"]))
			$GLOBALS["docmhs_grid"] = new docmhs_grid();

		// "detail_tblNilaiPerMhs"
		$item = &$this->ListOptions->add("detail_tblNilaiPerMhs");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 'tblNilaiPerMhs') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["tblNilaiPerMhs_grid"]))
			$GLOBALS["tblNilaiPerMhs_grid"] = new tblNilaiPerMhs_grid();

		// "detail_Wali_IPS"
		$item = &$this->ListOptions->add("detail_Wali_IPS");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 'Wali_IPS') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["Wali_IPS_grid"]))
			$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid();

		// "detail_ekpt_Ferval"
		$item = &$this->ListOptions->add("detail_ekpt_Ferval");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 'ekpt_Ferval') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["ekpt_Ferval_grid"]))
			$GLOBALS["ekpt_Ferval_grid"] = new ekpt_Ferval_grid();

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$item = &$this->ListOptions->add("details");
			$item->CssClass = "text-nowrap";
			$item->Visible = $this->ShowMultipleDetails;
			$item->OnLeft = TRUE;
			$item->ShowInButtonGroup = FALSE;
		}

		// Set up detail pages
		$pages = new SubPages();
		$pages->add("docmhs");
		$pages->add("tblNilaiPerMhs");
		$pages->add("Wali_IPS");
		$pages->add("ekpt_Ferval");
		$this->DetailPages = $pages;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// "sequence"
		$item = &$this->ListOptions->add("sequence");
		$item->CssClass = "text-nowrap";
		$item->Visible = TRUE;
		$item->OnLeft = TRUE; // Always on left
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "sequence"
		$opt = $this->ListOptions["sequence"];
		$opt->Body = FormatSequenceNumber($this->RecordCount);

		// "view"
		$opt = $this->ListOptions["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail_docmhs"
		$opt = $this->ListOptions["detail_docmhs"];
		if ($Security->allowList(CurrentProjectID() . 'docmhs')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("docmhs", "TblCaption");
			$body .= "&nbsp;" . str_replace("%c", $this->docmhs_Count, $Language->phrase("DetailCount"));
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("docmhslist.php?" . Config("TABLE_SHOW_MASTER") . "=IM_Mhs&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["docmhs_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'IM_Mhs')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=docmhs");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar != "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "docmhs";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}

		// "detail_tblNilaiPerMhs"
		$opt = $this->ListOptions["detail_tblNilaiPerMhs"];
		if ($Security->allowList(CurrentProjectID() . 'tblNilaiPerMhs')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("tblNilaiPerMhs", "TblCaption");
			$body .= "&nbsp;" . str_replace("%c", $this->tblNilaiPerMhs_Count, $Language->phrase("DetailCount"));
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("tblNilaiPerMhslist.php?" . Config("TABLE_SHOW_MASTER") . "=IM_Mhs&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["tblNilaiPerMhs_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'IM_Mhs')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=tblNilaiPerMhs");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar != "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "tblNilaiPerMhs";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}

		// "detail_Wali_IPS"
		$opt = $this->ListOptions["detail_Wali_IPS"];
		if ($Security->allowList(CurrentProjectID() . 'Wali_IPS')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("Wali_IPS", "TblCaption");
			$body .= "&nbsp;" . str_replace("%c", $this->Wali_IPS_Count, $Language->phrase("DetailCount"));
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("Wali_IPSlist.php?" . Config("TABLE_SHOW_MASTER") . "=IM_Mhs&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["Wali_IPS_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'IM_Mhs')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=Wali_IPS");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar != "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "Wali_IPS";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}

		// "detail_ekpt_Ferval"
		$opt = $this->ListOptions["detail_ekpt_Ferval"];
		if ($Security->allowList(CurrentProjectID() . 'ekpt_Ferval')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("ekpt_Ferval", "TblCaption");
			$body .= "&nbsp;" . str_replace("%c", $this->ekpt_Ferval_Count, $Language->phrase("DetailCount"));
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("ekpt_Fervallist.php?" . Config("TABLE_SHOW_MASTER") . "=IM_Mhs&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["ekpt_Ferval_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'IM_Mhs')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=ekpt_Ferval");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar != "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "ekpt_Ferval";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar != "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar != "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar != "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->GetCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$opt = $this->ListOptions["details"];
			$opt->Body = $body;
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->Nim->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fIM_Mhslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fIM_Mhslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.fIM_Mhslist}," . $listaction->toJson(TRUE) . "));\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{

		// Load search values
		$got = FALSE;

		// Nim
		if (!$this->isAddOrEdit() && $this->Nim->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Nim->AdvancedSearch->SearchValue != "" || $this->Nim->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Nama_Mhs
		if (!$this->isAddOrEdit() && $this->Nama_Mhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Nama_Mhs->AdvancedSearch->SearchValue != "" || $this->Nama_Mhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Tmp_Lahir
		if (!$this->isAddOrEdit() && $this->Tmp_Lahir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Tmp_Lahir->AdvancedSearch->SearchValue != "" || $this->Tmp_Lahir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Tgl_Lahir
		if (!$this->isAddOrEdit() && $this->Tgl_Lahir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Tgl_Lahir->AdvancedSearch->SearchValue != "" || $this->Tgl_Lahir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Status_Akd
		if (!$this->isAddOrEdit() && $this->Status_Akd->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Status_Akd->AdvancedSearch->SearchValue != "" || $this->Status_Akd->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kode_Fak
		if (!$this->isAddOrEdit() && $this->Kode_Fak->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kode_Fak->AdvancedSearch->SearchValue != "" || $this->Kode_Fak->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kode_jp
		if (!$this->isAddOrEdit() && $this->Kode_jp->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kode_jp->AdvancedSearch->SearchValue != "" || $this->Kode_jp->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Jurusan
		if (!$this->isAddOrEdit() && $this->Jurusan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Jurusan->AdvancedSearch->SearchValue != "" || $this->Jurusan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Program
		if (!$this->isAddOrEdit() && $this->Program->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Program->AdvancedSearch->SearchValue != "" || $this->Program->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TaMasuk
		if (!$this->isAddOrEdit() && $this->TaMasuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TaMasuk->AdvancedSearch->SearchValue != "" || $this->TaMasuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PerMasuk
		if (!$this->isAddOrEdit() && $this->PerMasuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PerMasuk->AdvancedSearch->SearchValue != "" || $this->PerMasuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// SemesterMulai
		if (!$this->isAddOrEdit() && $this->SemesterMulai->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->SemesterMulai->AdvancedSearch->SearchValue != "" || $this->SemesterMulai->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// tglmasuk
		if (!$this->isAddOrEdit() && $this->tglmasuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->tglmasuk->AdvancedSearch->SearchValue != "" || $this->tglmasuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Status
		if (!$this->isAddOrEdit() && $this->Status->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Status->AdvancedSearch->SearchValue != "" || $this->Status->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// StatusAkhir
		if (!$this->isAddOrEdit() && $this->StatusAkhir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->StatusAkhir->AdvancedSearch->SearchValue != "" || $this->StatusAkhir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// SemesterKeluar_Lulus
		if (!$this->isAddOrEdit() && $this->SemesterKeluar_Lulus->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->SemesterKeluar_Lulus->AdvancedSearch->SearchValue != "" || $this->SemesterKeluar_Lulus->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Status_Masuk
		if (!$this->isAddOrEdit() && $this->Status_Masuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Status_Masuk->AdvancedSearch->SearchValue != "" || $this->Status_Masuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// AwalPendaftaran
		if (!$this->isAddOrEdit() && $this->AwalPendaftaran->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->AwalPendaftaran->AdvancedSearch->SearchValue != "" || $this->AwalPendaftaran->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Pwl
		if (!$this->isAddOrEdit() && $this->Pwl->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Pwl->AdvancedSearch->SearchValue != "" || $this->Pwl->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Ijazah
		if (!$this->isAddOrEdit() && $this->Ijazah->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Ijazah->AdvancedSearch->SearchValue != "" || $this->Ijazah->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Ktp
		if (!$this->isAddOrEdit() && $this->Ktp->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Ktp->AdvancedSearch->SearchValue != "" || $this->Ktp->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// KK
		if (!$this->isAddOrEdit() && $this->KK->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->KK->AdvancedSearch->SearchValue != "" || $this->KK->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// tandatangan
		if (!$this->isAddOrEdit() && $this->tandatangan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->tandatangan->AdvancedSearch->SearchValue != "" || $this->tandatangan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// IjazahIM
		if (!$this->isAddOrEdit() && $this->IjazahIM->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->IjazahIM->AdvancedSearch->SearchValue != "" || $this->IjazahIM->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TranskriptIM
		if (!$this->isAddOrEdit() && $this->TranskriptIM->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TranskriptIM->AdvancedSearch->SearchValue != "" || $this->TranskriptIM->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Skripsi
		if (!$this->isAddOrEdit() && $this->Skripsi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Skripsi->AdvancedSearch->SearchValue != "" || $this->Skripsi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TASkripsi
		if (!$this->isAddOrEdit() && $this->TASkripsi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TASkripsi->AdvancedSearch->SearchValue != "" || $this->TASkripsi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Plagiat
		if (!$this->isAddOrEdit() && $this->Plagiat->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Plagiat->AdvancedSearch->SearchValue != "" || $this->Plagiat->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// riwayatakademik
		if (!$this->isAddOrEdit() && $this->riwayatakademik->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->riwayatakademik->AdvancedSearch->SearchValue != "" || $this->riwayatakademik->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// keuangan
		if (!$this->isAddOrEdit() && $this->keuangan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->keuangan->AdvancedSearch->SearchValue != "" || $this->keuangan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// pendukung
		if (!$this->isAddOrEdit() && $this->pendukung->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->pendukung->AdvancedSearch->SearchValue != "" || $this->pendukung->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// lainlain
		if (!$this->isAddOrEdit() && $this->lainlain->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->lainlain->AdvancedSearch->SearchValue != "" || $this->lainlain->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Ferval
		if (!$this->isAddOrEdit() && $this->Ferval->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Ferval->AdvancedSearch->SearchValue != "" || $this->Ferval->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}
		return $got;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Nama_Mhs->setDbValue($row['Nama_Mhs']);
		$this->Tmp_Lahir->setDbValue($row['Tmp_Lahir']);
		$this->Tgl_Lahir->setDbValue($row['Tgl_Lahir']);
		$this->Status_Akd->setDbValue($row['Status_Akd']);
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Kode_jp->setDbValue($row['Kode_jp']);
		$this->Jurusan->setDbValue($row['Jurusan']);
		$this->Program->setDbValue($row['Program']);
		$this->TaMasuk->setDbValue($row['TaMasuk']);
		$this->PerMasuk->setDbValue($row['PerMasuk']);
		$this->SemesterMulai->setDbValue($row['SemesterMulai']);
		$this->tglmasuk->setDbValue($row['tglmasuk']);
		$this->Status->setDbValue($row['Status']);
		$this->StatusAkhir->setDbValue($row['StatusAkhir']);
		$this->SemesterKeluar_Lulus->setDbValue($row['SemesterKeluar_Lulus']);
		$this->Status_Masuk->setDbValue($row['Status_Masuk']);
		$this->AwalPendaftaran->setDbValue($row['AwalPendaftaran']);
		$this->Pwl->setDbValue($row['Pwl']);
		$this->Ijazah->setDbValue($row['Ijazah']);
		$this->Ktp->setDbValue($row['Ktp']);
		$this->KK->setDbValue($row['KK']);
		$this->tandatangan->setDbValue($row['tandatangan']);
		$this->IjazahIM->setDbValue($row['IjazahIM']);
		$this->TranskriptIM->setDbValue($row['TranskriptIM']);
		$this->Skripsi->setDbValue($row['Skripsi']);
		$this->TASkripsi->setDbValue($row['TASkripsi']);
		$this->Plagiat->setDbValue($row['Plagiat']);
		$this->riwayatakademik->setDbValue($row['riwayatakademik']);
		$this->keuangan->setDbValue($row['keuangan']);
		$this->pendukung->setDbValue($row['pendukung']);
		$this->lainlain->setDbValue($row['lainlain']);
		$this->Ferval->setDbValue($row['Ferval']);
		if (!isset($GLOBALS["docmhs_grid"]))
			$GLOBALS["docmhs_grid"] = new docmhs_grid();
		$detailFilter = $GLOBALS["docmhs"]->sqlDetailFilter_IM_Mhs();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "DB"), $detailFilter);
		$GLOBALS["docmhs"]->setCurrentMasterTable("IM_Mhs");
		$detailFilter = $GLOBALS["docmhs"]->applyUserIDFilters($detailFilter);
		$this->docmhs_Count = $GLOBALS["docmhs"]->loadRecordCount($detailFilter);
		if (!isset($GLOBALS["tblNilaiPerMhs_grid"]))
			$GLOBALS["tblNilaiPerMhs_grid"] = new tblNilaiPerMhs_grid();
		$detailFilter = $GLOBALS["tblNilaiPerMhs"]->sqlDetailFilter_IM_Mhs();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "IM1"), $detailFilter);
		$GLOBALS["tblNilaiPerMhs"]->setCurrentMasterTable("IM_Mhs");
		$detailFilter = $GLOBALS["tblNilaiPerMhs"]->applyUserIDFilters($detailFilter);
		$this->tblNilaiPerMhs_Count = $GLOBALS["tblNilaiPerMhs"]->loadRecordCount($detailFilter);
		if (!isset($GLOBALS["Wali_IPS_grid"]))
			$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid();
		$detailFilter = $GLOBALS["Wali_IPS"]->sqlDetailFilter_IM_Mhs();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "DB"), $detailFilter);
		$GLOBALS["Wali_IPS"]->setCurrentMasterTable("IM_Mhs");
		$detailFilter = $GLOBALS["Wali_IPS"]->applyUserIDFilters($detailFilter);
		$this->Wali_IPS_Count = $GLOBALS["Wali_IPS"]->loadRecordCount($detailFilter);
		if (!isset($GLOBALS["ekpt_Ferval_grid"]))
			$GLOBALS["ekpt_Ferval_grid"] = new ekpt_Ferval_grid();
		$detailFilter = $GLOBALS["ekpt_Ferval"]->sqlDetailFilter_IM_Mhs();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "DB"), $detailFilter);
		$GLOBALS["ekpt_Ferval"]->setCurrentMasterTable("IM_Mhs");
		$detailFilter = $GLOBALS["ekpt_Ferval"]->applyUserIDFilters($detailFilter);
		$this->ekpt_Ferval_Count = $GLOBALS["ekpt_Ferval"]->loadRecordCount($detailFilter);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Nama_Mhs'] = NULL;
		$row['Tmp_Lahir'] = NULL;
		$row['Tgl_Lahir'] = NULL;
		$row['Status_Akd'] = NULL;
		$row['Kode_Fak'] = NULL;
		$row['Kode_jp'] = NULL;
		$row['Jurusan'] = NULL;
		$row['Program'] = NULL;
		$row['TaMasuk'] = NULL;
		$row['PerMasuk'] = NULL;
		$row['SemesterMulai'] = NULL;
		$row['tglmasuk'] = NULL;
		$row['Status'] = NULL;
		$row['StatusAkhir'] = NULL;
		$row['SemesterKeluar_Lulus'] = NULL;
		$row['Status_Masuk'] = NULL;
		$row['AwalPendaftaran'] = NULL;
		$row['Pwl'] = NULL;
		$row['Ijazah'] = NULL;
		$row['Ktp'] = NULL;
		$row['KK'] = NULL;
		$row['tandatangan'] = NULL;
		$row['IjazahIM'] = NULL;
		$row['TranskriptIM'] = NULL;
		$row['Skripsi'] = NULL;
		$row['TASkripsi'] = NULL;
		$row['Plagiat'] = NULL;
		$row['riwayatakademik'] = NULL;
		$row['keuangan'] = NULL;
		$row['pendukung'] = NULL;
		$row['lainlain'] = NULL;
		$row['Ferval'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Nama_Mhs
		// Tmp_Lahir
		// Tgl_Lahir
		// Status_Akd
		// Kode_Fak
		// Kode_jp
		// Jurusan
		// Program
		// TaMasuk
		// PerMasuk
		// SemesterMulai
		// tglmasuk
		// Status
		// StatusAkhir
		// SemesterKeluar_Lulus
		// Status_Masuk
		// AwalPendaftaran
		// Pwl
		// Ijazah
		// Ktp
		// KK
		// tandatangan
		// IjazahIM
		// TranskriptIM
		// Skripsi
		// TASkripsi
		// Plagiat
		// riwayatakademik
		// keuangan
		// pendukung
		// lainlain
		// Ferval

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
			$this->Nama_Mhs->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 7);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// Status_Akd
			$curVal = strval($this->Status_Akd->CurrentValue);
			if ($curVal != "") {
				$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
				if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
					}
				}
			} else {
				$this->Status_Akd->ViewValue = NULL;
			}
			$this->Status_Akd->ViewCustomAttributes = "";

			// Kode_Fak
			$curVal = strval($this->Kode_Fak->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
				if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
					}
				}
			} else {
				$this->Kode_Fak->ViewValue = NULL;
			}
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kode_jp
			$curVal = strval($this->Kode_jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
				if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_jp->ViewValue = NULL;
			}
			$this->Kode_jp->ViewCustomAttributes = "";

			// Jurusan
			$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
			$this->Jurusan->ViewCustomAttributes = "";

			// Program
			$this->Program->ViewValue = $this->Program->CurrentValue;
			$this->Program->ViewCustomAttributes = "";

			// TaMasuk
			$curVal = strval($this->TaMasuk->CurrentValue);
			if ($curVal != "") {
				$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
				if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
					}
				}
			} else {
				$this->TaMasuk->ViewValue = NULL;
			}
			$this->TaMasuk->ViewCustomAttributes = "";

			// PerMasuk
			if (strval($this->PerMasuk->CurrentValue) != "") {
				$this->PerMasuk->ViewValue = $this->PerMasuk->optionCaption($this->PerMasuk->CurrentValue);
			} else {
				$this->PerMasuk->ViewValue = NULL;
			}
			$this->PerMasuk->ViewCustomAttributes = "";

			// SemesterMulai
			$this->SemesterMulai->ViewValue = $this->SemesterMulai->CurrentValue;
			$this->SemesterMulai->ViewCustomAttributes = "";

			// tglmasuk
			$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
			$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
			$this->tglmasuk->ViewCustomAttributes = "";

			// Status
			$this->Status->ViewValue = $this->Status->CurrentValue;
			$this->Status->ViewCustomAttributes = "";

			// StatusAkhir
			$this->StatusAkhir->ViewValue = $this->StatusAkhir->CurrentValue;
			$this->StatusAkhir->ViewCustomAttributes = "";

			// SemesterKeluar_Lulus
			$this->SemesterKeluar_Lulus->ViewValue = $this->SemesterKeluar_Lulus->CurrentValue;
			$this->SemesterKeluar_Lulus->ViewCustomAttributes = "";

			// Status_Masuk
			if (strval($this->Status_Masuk->CurrentValue) != "") {
				$this->Status_Masuk->ViewValue = $this->Status_Masuk->optionCaption($this->Status_Masuk->CurrentValue);
			} else {
				$this->Status_Masuk->ViewValue = NULL;
			}
			$this->Status_Masuk->ViewCustomAttributes = "";

			// AwalPendaftaran
			$this->AwalPendaftaran->ViewValue = $this->AwalPendaftaran->CurrentValue;
			$this->AwalPendaftaran->ViewCustomAttributes = "";

			// Pwl
			$this->Pwl->ViewValue = $this->Pwl->CurrentValue;
			$this->Pwl->ViewValue = FormatNumber($this->Pwl->ViewValue, 0, -2, -2, -2);
			$this->Pwl->ViewCustomAttributes = "";

			// Ijazah
			$this->Ijazah->ViewValue = $this->Ijazah->CurrentValue;
			$this->Ijazah->ViewCustomAttributes = "";

			// Ktp
			$this->Ktp->ViewValue = $this->Ktp->CurrentValue;
			$this->Ktp->ViewCustomAttributes = "";

			// KK
			$this->KK->ViewValue = $this->KK->CurrentValue;
			$this->KK->ViewCustomAttributes = "";

			// tandatangan
			$this->tandatangan->ViewValue = $this->tandatangan->CurrentValue;
			$this->tandatangan->ViewCustomAttributes = "";

			// IjazahIM
			$this->IjazahIM->ViewValue = $this->IjazahIM->CurrentValue;
			$this->IjazahIM->ViewCustomAttributes = "";

			// TranskriptIM
			$this->TranskriptIM->ViewValue = $this->TranskriptIM->CurrentValue;
			$this->TranskriptIM->ViewCustomAttributes = "";

			// Skripsi
			$this->Skripsi->ViewValue = $this->Skripsi->CurrentValue;
			$this->Skripsi->ViewCustomAttributes = "";

			// TASkripsi
			$this->TASkripsi->ViewValue = $this->TASkripsi->CurrentValue;
			$this->TASkripsi->ViewCustomAttributes = "";

			// Plagiat
			$this->Plagiat->ViewValue = $this->Plagiat->CurrentValue;
			$this->Plagiat->ViewCustomAttributes = "";

			// riwayatakademik
			$this->riwayatakademik->ViewValue = $this->riwayatakademik->CurrentValue;
			$this->riwayatakademik->ViewCustomAttributes = "";

			// keuangan
			$this->keuangan->ViewValue = $this->keuangan->CurrentValue;
			$this->keuangan->ViewCustomAttributes = "";

			// pendukung
			$this->pendukung->ViewValue = $this->pendukung->CurrentValue;
			$this->pendukung->ViewCustomAttributes = "";

			// lainlain
			$this->lainlain->ViewValue = $this->lainlain->CurrentValue;
			$this->lainlain->ViewCustomAttributes = "";

			// Ferval
			$this->Ferval->ViewValue = $this->Ferval->CurrentValue;
			$this->Ferval->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";
			$this->Nama_Mhs->TooltipValue = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->LinkCustomAttributes = "";
			$this->Tmp_Lahir->HrefValue = "";
			$this->Tmp_Lahir->TooltipValue = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->LinkCustomAttributes = "";
			$this->Tgl_Lahir->HrefValue = "";
			$this->Tgl_Lahir->TooltipValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";
			$this->Status_Akd->TooltipValue = "";

			// Kode_Fak
			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";
			$this->Kode_Fak->TooltipValue = "";

			// Kode_jp
			$this->Kode_jp->LinkCustomAttributes = "";
			$this->Kode_jp->HrefValue = "";
			$this->Kode_jp->TooltipValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";
			$this->TaMasuk->TooltipValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";
			$this->PerMasuk->TooltipValue = "";

			// SemesterMulai
			$this->SemesterMulai->LinkCustomAttributes = "";
			$this->SemesterMulai->HrefValue = "";
			$this->SemesterMulai->TooltipValue = "";

			// tglmasuk
			$this->tglmasuk->LinkCustomAttributes = "";
			$this->tglmasuk->HrefValue = "";
			$this->tglmasuk->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";

			// StatusAkhir
			$this->StatusAkhir->LinkCustomAttributes = "";
			$this->StatusAkhir->HrefValue = "";
			$this->StatusAkhir->TooltipValue = "";

			// SemesterKeluar_Lulus
			$this->SemesterKeluar_Lulus->LinkCustomAttributes = "";
			$this->SemesterKeluar_Lulus->HrefValue = "";
			$this->SemesterKeluar_Lulus->TooltipValue = "";

			// Status_Masuk
			$this->Status_Masuk->LinkCustomAttributes = "";
			$this->Status_Masuk->HrefValue = "";
			$this->Status_Masuk->TooltipValue = "";

			// AwalPendaftaran
			$this->AwalPendaftaran->LinkCustomAttributes = "";
			$this->AwalPendaftaran->HrefValue = "";
			$this->AwalPendaftaran->TooltipValue = "";

			// Pwl
			$this->Pwl->LinkCustomAttributes = "";
			$this->Pwl->HrefValue = "";
			$this->Pwl->TooltipValue = "";

			// Ijazah
			$this->Ijazah->LinkCustomAttributes = "";
			if (!EmptyValue($this->Ijazah->CurrentValue)) {
				$this->Ijazah->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . $this->Ijazah->CurrentValue; // Add prefix/suffix
				$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
			} else {
				$this->Ijazah->HrefValue = "";
			}
			$this->Ijazah->TooltipValue = "";

			// Ktp
			$this->Ktp->LinkCustomAttributes = "";
			if (!EmptyValue($this->Ktp->CurrentValue)) {
				$this->Ktp->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . $this->Ktp->CurrentValue; // Add prefix/suffix
				$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
			} else {
				$this->Ktp->HrefValue = "";
			}
			$this->Ktp->TooltipValue = "";

			// KK
			$this->KK->LinkCustomAttributes = "";
			if (!EmptyValue($this->KK->CurrentValue)) {
				$this->KK->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->KK->ViewValue) && !is_array($this->KK->ViewValue) ? RemoveHtml($this->KK->ViewValue) : $this->KK->CurrentValue); // Add prefix/suffix
				$this->KK->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
			} else {
				$this->KK->HrefValue = "";
			}
			$this->KK->TooltipValue = "";

			// IjazahIM
			$this->IjazahIM->LinkCustomAttributes = "";
			if (!EmptyValue($this->IjazahIM->CurrentValue)) {
				$this->IjazahIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->IjazahIM->ViewValue) && !is_array($this->IjazahIM->ViewValue) ? RemoveHtml($this->IjazahIM->ViewValue) : $this->IjazahIM->CurrentValue); // Add prefix/suffix
				$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
			} else {
				$this->IjazahIM->HrefValue = "";
			}
			$this->IjazahIM->TooltipValue = "";

			// TranskriptIM
			$this->TranskriptIM->LinkCustomAttributes = "";
			if (!EmptyValue($this->TranskriptIM->CurrentValue)) {
				$this->TranskriptIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->TranskriptIM->ViewValue) && !is_array($this->TranskriptIM->ViewValue) ? RemoveHtml($this->TranskriptIM->ViewValue) : $this->TranskriptIM->CurrentValue); // Add prefix/suffix
				$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
			} else {
				$this->TranskriptIM->HrefValue = "";
			}
			$this->TranskriptIM->TooltipValue = "";

			// Skripsi
			$this->Skripsi->LinkCustomAttributes = "";
			if (!EmptyValue($this->Skripsi->CurrentValue)) {
				$this->Skripsi->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Skripsi->ViewValue) && !is_array($this->Skripsi->ViewValue) ? RemoveHtml($this->Skripsi->ViewValue) : $this->Skripsi->CurrentValue); // Add prefix/suffix
				$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
			} else {
				$this->Skripsi->HrefValue = "";
			}
			$this->Skripsi->TooltipValue = "";

			// TASkripsi
			$this->TASkripsi->LinkCustomAttributes = "";
			if (!EmptyValue($this->TASkripsi->CurrentValue)) {
				$this->TASkripsi->HrefValue = "https://akademik.stmik-im.ac.id/docs/TaSkripsi/" . (!empty($this->TASkripsi->ViewValue) && !is_array($this->TASkripsi->ViewValue) ? RemoveHtml($this->TASkripsi->ViewValue) : $this->TASkripsi->CurrentValue); // Add prefix/suffix
				$this->TASkripsi->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->TASkripsi->HrefValue = FullUrl($this->TASkripsi->HrefValue, "href");
			} else {
				$this->TASkripsi->HrefValue = "";
			}
			$this->TASkripsi->TooltipValue = "";

			// Plagiat
			$this->Plagiat->LinkCustomAttributes = "";
			if (!EmptyValue($this->Plagiat->CurrentValue)) {
				$this->Plagiat->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Plagiat->ViewValue) && !is_array($this->Plagiat->ViewValue) ? RemoveHtml($this->Plagiat->ViewValue) : $this->Plagiat->CurrentValue); // Add prefix/suffix
				$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
			} else {
				$this->Plagiat->HrefValue = "";
			}
			$this->Plagiat->TooltipValue = "";

			// riwayatakademik
			$this->riwayatakademik->LinkCustomAttributes = "";
			if (!EmptyValue($this->riwayatakademik->CurrentValue)) {
				$this->riwayatakademik->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->riwayatakademik->ViewValue) && !is_array($this->riwayatakademik->ViewValue) ? RemoveHtml($this->riwayatakademik->ViewValue) : $this->riwayatakademik->CurrentValue); // Add prefix/suffix
				$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
			} else {
				$this->riwayatakademik->HrefValue = "";
			}
			$this->riwayatakademik->TooltipValue = "";

			// keuangan
			$this->keuangan->LinkCustomAttributes = "";
			if (!EmptyValue($this->keuangan->CurrentValue)) {
				$this->keuangan->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/keu/" . (!empty($this->keuangan->ViewValue) && !is_array($this->keuangan->ViewValue) ? RemoveHtml($this->keuangan->ViewValue) : $this->keuangan->CurrentValue); // Add prefix/suffix
				$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
			} else {
				$this->keuangan->HrefValue = "";
			}
			$this->keuangan->TooltipValue = "";

			// pendukung
			$this->pendukung->LinkCustomAttributes = "";
			if (!EmptyValue($this->pendukung->CurrentValue)) {
				$this->pendukung->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/pendukung/" . (!empty($this->pendukung->ViewValue) && !is_array($this->pendukung->ViewValue) ? RemoveHtml($this->pendukung->ViewValue) : $this->pendukung->CurrentValue); // Add prefix/suffix
				$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
			} else {
				$this->pendukung->HrefValue = "";
			}
			$this->pendukung->TooltipValue = "";

			// lainlain
			$this->lainlain->LinkCustomAttributes = "";
			if (!EmptyValue($this->lainlain->CurrentValue)) {
				$this->lainlain->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/lainlain/" . (!empty($this->lainlain->ViewValue) && !is_array($this->lainlain->ViewValue) ? RemoveHtml($this->lainlain->ViewValue) : $this->lainlain->CurrentValue); // Add prefix/suffix
				$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
			} else {
				$this->lainlain->HrefValue = "";
			}
			$this->lainlain->TooltipValue = "";

			// Ferval
			$this->Ferval->LinkCustomAttributes = "";
			$this->Ferval->HrefValue = "";
			$this->Ferval->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			if (!$this->Nim->Raw)
				$this->Nim->AdvancedSearch->SearchValue = HtmlDecode($this->Nim->AdvancedSearch->SearchValue);
			$this->Nim->EditValue = HtmlEncode($this->Nim->AdvancedSearch->SearchValue);
			$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

			// Nama_Mhs
			$this->Nama_Mhs->EditAttrs["class"] = "form-control";
			$this->Nama_Mhs->EditCustomAttributes = "";
			if (!$this->Nama_Mhs->Raw)
				$this->Nama_Mhs->AdvancedSearch->SearchValue = HtmlDecode($this->Nama_Mhs->AdvancedSearch->SearchValue);
			$this->Nama_Mhs->EditValue = HtmlEncode($this->Nama_Mhs->AdvancedSearch->SearchValue);
			$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

			// Tmp_Lahir
			$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
			$this->Tmp_Lahir->EditCustomAttributes = "";
			if (!$this->Tmp_Lahir->Raw)
				$this->Tmp_Lahir->AdvancedSearch->SearchValue = HtmlDecode($this->Tmp_Lahir->AdvancedSearch->SearchValue);
			$this->Tmp_Lahir->EditValue = HtmlEncode($this->Tmp_Lahir->AdvancedSearch->SearchValue);
			$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

			// Tgl_Lahir
			$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
			$this->Tgl_Lahir->EditCustomAttributes = "";
			$this->Tgl_Lahir->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Tgl_Lahir->AdvancedSearch->SearchValue, 7), 7));
			$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

			// Status_Akd
			$this->Status_Akd->EditAttrs["class"] = "form-control";
			$this->Status_Akd->EditCustomAttributes = "";
			$curVal = trim(strval($this->Status_Akd->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->Status_Akd->AdvancedSearch->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			else
				$this->Status_Akd->AdvancedSearch->ViewValue = $this->Status_Akd->Lookup !== NULL && is_array($this->Status_Akd->Lookup->Options) ? $curVal : NULL;
			if ($this->Status_Akd->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Status_Akd->EditValue = array_values($this->Status_Akd->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kelas]" . SearchString("=", $this->Status_Akd->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Status_Akd->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Status_Akd->EditValue = $arwrk;
			}

			// Kode_Fak
			$this->Kode_Fak->EditAttrs["class"] = "form-control";
			$this->Kode_Fak->EditCustomAttributes = "";

			// Kode_jp
			$this->Kode_jp->EditAttrs["class"] = "form-control";
			$this->Kode_jp->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_jp->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->Kode_jp->AdvancedSearch->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
			else
				$this->Kode_jp->AdvancedSearch->ViewValue = $this->Kode_jp->Lookup !== NULL && is_array($this->Kode_jp->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_jp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Kode_jp->EditValue = array_values($this->Kode_jp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Jp]" . SearchString("=", $this->Kode_jp->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_jp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_jp->EditValue = $arwrk;
			}

			// TaMasuk
			$this->TaMasuk->EditAttrs["class"] = "form-control";
			$this->TaMasuk->EditCustomAttributes = "";
			$curVal = trim(strval($this->TaMasuk->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->TaMasuk->AdvancedSearch->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
			else
				$this->TaMasuk->AdvancedSearch->ViewValue = $this->TaMasuk->Lookup !== NULL && is_array($this->TaMasuk->Lookup->Options) ? $curVal : NULL;
			if ($this->TaMasuk->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->TaMasuk->EditValue = array_values($this->TaMasuk->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[TA]" . SearchString("=", $this->TaMasuk->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->TaMasuk->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->TaMasuk->EditValue = $arwrk;
			}

			// PerMasuk
			$this->PerMasuk->EditAttrs["class"] = "form-control";
			$this->PerMasuk->EditCustomAttributes = "";
			$this->PerMasuk->EditValue = $this->PerMasuk->options(TRUE);

			// SemesterMulai
			$this->SemesterMulai->EditAttrs["class"] = "form-control";
			$this->SemesterMulai->EditCustomAttributes = "";
			if (!$this->SemesterMulai->Raw)
				$this->SemesterMulai->AdvancedSearch->SearchValue = HtmlDecode($this->SemesterMulai->AdvancedSearch->SearchValue);
			$this->SemesterMulai->EditValue = HtmlEncode($this->SemesterMulai->AdvancedSearch->SearchValue);
			$this->SemesterMulai->PlaceHolder = RemoveHtml($this->SemesterMulai->caption());

			// tglmasuk
			$this->tglmasuk->EditAttrs["class"] = "form-control";
			$this->tglmasuk->EditCustomAttributes = "";
			$this->tglmasuk->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->tglmasuk->AdvancedSearch->SearchValue, 7), 7));
			$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			if (!$this->Status->Raw)
				$this->Status->AdvancedSearch->SearchValue = HtmlDecode($this->Status->AdvancedSearch->SearchValue);
			$this->Status->EditValue = HtmlEncode($this->Status->AdvancedSearch->SearchValue);
			$this->Status->PlaceHolder = RemoveHtml($this->Status->caption());

			// StatusAkhir
			$this->StatusAkhir->EditAttrs["class"] = "form-control";
			$this->StatusAkhir->EditCustomAttributes = "";
			if (!$this->StatusAkhir->Raw)
				$this->StatusAkhir->AdvancedSearch->SearchValue = HtmlDecode($this->StatusAkhir->AdvancedSearch->SearchValue);
			$this->StatusAkhir->EditValue = HtmlEncode($this->StatusAkhir->AdvancedSearch->SearchValue);
			$this->StatusAkhir->PlaceHolder = RemoveHtml($this->StatusAkhir->caption());

			// SemesterKeluar_Lulus
			$this->SemesterKeluar_Lulus->EditAttrs["class"] = "form-control";
			$this->SemesterKeluar_Lulus->EditCustomAttributes = "";
			if (!$this->SemesterKeluar_Lulus->Raw)
				$this->SemesterKeluar_Lulus->AdvancedSearch->SearchValue = HtmlDecode($this->SemesterKeluar_Lulus->AdvancedSearch->SearchValue);
			$this->SemesterKeluar_Lulus->EditValue = HtmlEncode($this->SemesterKeluar_Lulus->AdvancedSearch->SearchValue);
			$this->SemesterKeluar_Lulus->PlaceHolder = RemoveHtml($this->SemesterKeluar_Lulus->caption());

			// Status_Masuk
			$this->Status_Masuk->EditAttrs["class"] = "form-control";
			$this->Status_Masuk->EditCustomAttributes = "";
			$this->Status_Masuk->EditValue = $this->Status_Masuk->options(TRUE);

			// AwalPendaftaran
			$this->AwalPendaftaran->EditAttrs["class"] = "form-control";
			$this->AwalPendaftaran->EditCustomAttributes = "";
			if (!$this->AwalPendaftaran->Raw)
				$this->AwalPendaftaran->AdvancedSearch->SearchValue = HtmlDecode($this->AwalPendaftaran->AdvancedSearch->SearchValue);
			$this->AwalPendaftaran->EditValue = HtmlEncode($this->AwalPendaftaran->AdvancedSearch->SearchValue);
			$this->AwalPendaftaran->PlaceHolder = RemoveHtml($this->AwalPendaftaran->caption());

			// Pwl
			$this->Pwl->EditAttrs["class"] = "form-control";
			$this->Pwl->EditCustomAttributes = "";
			$this->Pwl->EditValue = HtmlEncode($this->Pwl->AdvancedSearch->SearchValue);
			$this->Pwl->PlaceHolder = RemoveHtml($this->Pwl->caption());

			// Ijazah
			$this->Ijazah->EditAttrs["class"] = "form-control";
			$this->Ijazah->EditCustomAttributes = "";
			if (!$this->Ijazah->Raw)
				$this->Ijazah->AdvancedSearch->SearchValue = HtmlDecode($this->Ijazah->AdvancedSearch->SearchValue);
			$this->Ijazah->EditValue = HtmlEncode($this->Ijazah->AdvancedSearch->SearchValue);
			$this->Ijazah->PlaceHolder = RemoveHtml($this->Ijazah->caption());

			// Ktp
			$this->Ktp->EditAttrs["class"] = "form-control";
			$this->Ktp->EditCustomAttributes = "";
			if (!$this->Ktp->Raw)
				$this->Ktp->AdvancedSearch->SearchValue = HtmlDecode($this->Ktp->AdvancedSearch->SearchValue);
			$this->Ktp->EditValue = HtmlEncode($this->Ktp->AdvancedSearch->SearchValue);
			$this->Ktp->PlaceHolder = RemoveHtml($this->Ktp->caption());

			// KK
			$this->KK->EditAttrs["class"] = "form-control";
			$this->KK->EditCustomAttributes = "";
			if (!$this->KK->Raw)
				$this->KK->AdvancedSearch->SearchValue = HtmlDecode($this->KK->AdvancedSearch->SearchValue);
			$this->KK->EditValue = HtmlEncode($this->KK->AdvancedSearch->SearchValue);
			$this->KK->PlaceHolder = RemoveHtml($this->KK->caption());

			// IjazahIM
			$this->IjazahIM->EditAttrs["class"] = "form-control";
			$this->IjazahIM->EditCustomAttributes = "";
			if (!$this->IjazahIM->Raw)
				$this->IjazahIM->AdvancedSearch->SearchValue = HtmlDecode($this->IjazahIM->AdvancedSearch->SearchValue);
			$this->IjazahIM->EditValue = HtmlEncode($this->IjazahIM->AdvancedSearch->SearchValue);
			$this->IjazahIM->PlaceHolder = RemoveHtml($this->IjazahIM->caption());

			// TranskriptIM
			$this->TranskriptIM->EditAttrs["class"] = "form-control";
			$this->TranskriptIM->EditCustomAttributes = "";
			if (!$this->TranskriptIM->Raw)
				$this->TranskriptIM->AdvancedSearch->SearchValue = HtmlDecode($this->TranskriptIM->AdvancedSearch->SearchValue);
			$this->TranskriptIM->EditValue = HtmlEncode($this->TranskriptIM->AdvancedSearch->SearchValue);
			$this->TranskriptIM->PlaceHolder = RemoveHtml($this->TranskriptIM->caption());

			// Skripsi
			$this->Skripsi->EditAttrs["class"] = "form-control";
			$this->Skripsi->EditCustomAttributes = "";
			if (!$this->Skripsi->Raw)
				$this->Skripsi->AdvancedSearch->SearchValue = HtmlDecode($this->Skripsi->AdvancedSearch->SearchValue);
			$this->Skripsi->EditValue = HtmlEncode($this->Skripsi->AdvancedSearch->SearchValue);
			$this->Skripsi->PlaceHolder = RemoveHtml($this->Skripsi->caption());

			// TASkripsi
			$this->TASkripsi->EditAttrs["class"] = "form-control";
			$this->TASkripsi->EditCustomAttributes = "";
			if (!$this->TASkripsi->Raw)
				$this->TASkripsi->AdvancedSearch->SearchValue = HtmlDecode($this->TASkripsi->AdvancedSearch->SearchValue);
			$this->TASkripsi->EditValue = HtmlEncode($this->TASkripsi->AdvancedSearch->SearchValue);
			$this->TASkripsi->PlaceHolder = RemoveHtml($this->TASkripsi->caption());

			// Plagiat
			$this->Plagiat->EditAttrs["class"] = "form-control";
			$this->Plagiat->EditCustomAttributes = "";
			if (!$this->Plagiat->Raw)
				$this->Plagiat->AdvancedSearch->SearchValue = HtmlDecode($this->Plagiat->AdvancedSearch->SearchValue);
			$this->Plagiat->EditValue = HtmlEncode($this->Plagiat->AdvancedSearch->SearchValue);
			$this->Plagiat->PlaceHolder = RemoveHtml($this->Plagiat->caption());

			// riwayatakademik
			$this->riwayatakademik->EditAttrs["class"] = "form-control";
			$this->riwayatakademik->EditCustomAttributes = "";
			if (!$this->riwayatakademik->Raw)
				$this->riwayatakademik->AdvancedSearch->SearchValue = HtmlDecode($this->riwayatakademik->AdvancedSearch->SearchValue);
			$this->riwayatakademik->EditValue = HtmlEncode($this->riwayatakademik->AdvancedSearch->SearchValue);
			$this->riwayatakademik->PlaceHolder = RemoveHtml($this->riwayatakademik->caption());

			// keuangan
			$this->keuangan->EditAttrs["class"] = "form-control";
			$this->keuangan->EditCustomAttributes = "";
			if (!$this->keuangan->Raw)
				$this->keuangan->AdvancedSearch->SearchValue = HtmlDecode($this->keuangan->AdvancedSearch->SearchValue);
			$this->keuangan->EditValue = HtmlEncode($this->keuangan->AdvancedSearch->SearchValue);
			$this->keuangan->PlaceHolder = RemoveHtml($this->keuangan->caption());

			// pendukung
			$this->pendukung->EditAttrs["class"] = "form-control";
			$this->pendukung->EditCustomAttributes = "";
			if (!$this->pendukung->Raw)
				$this->pendukung->AdvancedSearch->SearchValue = HtmlDecode($this->pendukung->AdvancedSearch->SearchValue);
			$this->pendukung->EditValue = HtmlEncode($this->pendukung->AdvancedSearch->SearchValue);
			$this->pendukung->PlaceHolder = RemoveHtml($this->pendukung->caption());

			// lainlain
			$this->lainlain->EditAttrs["class"] = "form-control";
			$this->lainlain->EditCustomAttributes = "";
			if (!$this->lainlain->Raw)
				$this->lainlain->AdvancedSearch->SearchValue = HtmlDecode($this->lainlain->AdvancedSearch->SearchValue);
			$this->lainlain->EditValue = HtmlEncode($this->lainlain->AdvancedSearch->SearchValue);
			$this->lainlain->PlaceHolder = RemoveHtml($this->lainlain->caption());

			// Ferval
			$this->Ferval->EditAttrs["class"] = "form-control";
			$this->Ferval->EditCustomAttributes = "";
			if (!$this->Ferval->Raw)
				$this->Ferval->AdvancedSearch->SearchValue = HtmlDecode($this->Ferval->AdvancedSearch->SearchValue);
			$this->Ferval->EditValue = HtmlEncode($this->Ferval->AdvancedSearch->SearchValue);
			$this->Ferval->PlaceHolder = RemoveHtml($this->Ferval->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->Nim->AdvancedSearch->load();
		$this->Nama_Mhs->AdvancedSearch->load();
		$this->Tmp_Lahir->AdvancedSearch->load();
		$this->Tgl_Lahir->AdvancedSearch->load();
		$this->Status_Akd->AdvancedSearch->load();
		$this->Kode_Fak->AdvancedSearch->load();
		$this->Kode_jp->AdvancedSearch->load();
		$this->Jurusan->AdvancedSearch->load();
		$this->Program->AdvancedSearch->load();
		$this->TaMasuk->AdvancedSearch->load();
		$this->PerMasuk->AdvancedSearch->load();
		$this->SemesterMulai->AdvancedSearch->load();
		$this->tglmasuk->AdvancedSearch->load();
		$this->Status->AdvancedSearch->load();
		$this->StatusAkhir->AdvancedSearch->load();
		$this->SemesterKeluar_Lulus->AdvancedSearch->load();
		$this->Status_Masuk->AdvancedSearch->load();
		$this->AwalPendaftaran->AdvancedSearch->load();
		$this->Pwl->AdvancedSearch->load();
		$this->Ijazah->AdvancedSearch->load();
		$this->Ktp->AdvancedSearch->load();
		$this->KK->AdvancedSearch->load();
		$this->tandatangan->AdvancedSearch->load();
		$this->IjazahIM->AdvancedSearch->load();
		$this->TranskriptIM->AdvancedSearch->load();
		$this->Skripsi->AdvancedSearch->load();
		$this->TASkripsi->AdvancedSearch->load();
		$this->Plagiat->AdvancedSearch->load();
		$this->riwayatakademik->AdvancedSearch->load();
		$this->keuangan->AdvancedSearch->load();
		$this->pendukung->AdvancedSearch->load();
		$this->lainlain->AdvancedSearch->load();
		$this->Ferval->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"return ew.export(document.fIM_Mhslist, '" . $this->ExportExcelUrl . "', 'excel', true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"return ew.export(document.fIM_Mhslist, '" . $this->ExportWordUrl . "', 'word', true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"return ew.export(document.fIM_Mhslist, '" . $this->ExportPdfUrl . "', 'pdf', true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "email")) {
			$url = $custom ? ",url:'" . $this->pageUrl() . "export=email&amp;custom=1'" : "";
			return '<button id="emf_IM_Mhs" class="ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" onclick="ew.emailDialogShow({lnk:\'emf_IM_Mhs\', hdr:ew.language.phrase(\'ExportToEmailText\'), f:document.fIM_Mhslist, sel:false' . $url . '});">' . $Language->phrase("ExportToEmail") . '</button>';
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fIM_Mhslistsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecords = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecords = $rs->RecordCount();
		}
		$this->StartRecord = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
			$this->DisplayRecords = $this->TotalRecords;
			$this->StopRecord = $this->TotalRecords;
		} else { // Export one page only
			$this->setupStartRecord(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecords <= 0) {
				$this->StopRecord = $this->TotalRecords;
			} else {
				$this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRecord = 1;
			$this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!Config("DEBUG") && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (Config("DEBUG") && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Status_Akd":
					break;
				case "x_Kode_Fak":
					break;
				case "x_Kode_jp":
					break;
				case "x_TaMasuk":
					break;
				case "x_PerMasuk":
					break;
				case "x_Status_Masuk":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Status_Akd":
							break;
						case "x_Kode_Fak":
							break;
						case "x_Kode_jp":
							break;
						case "x_TaMasuk":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>