<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class IM_Mhs_view extends IM_Mhs
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'IM_Mhs';

	// Page object name
	public $PageObjName = "IM_Mhs_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (IM_Mhs)
		if (!isset($GLOBALS["IM_Mhs"]) || get_class($GLOBALS["IM_Mhs"]) == PROJECT_NAMESPACE . "IM_Mhs") {
			$GLOBALS["IM_Mhs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["IM_Mhs"];
		}
		$keyUrl = "";
		if (Get("Nim") !== NULL) {
			$this->RecKey["Nim"] = Get("Nim");
			$keyUrl .= "&amp;Nim=" . urlencode($this->RecKey["Nim"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'IM_Mhs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $IM_Mhs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($IM_Mhs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "IM_Mhsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAddOrEdit())
			$this->Kode_Fak->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Jurusan->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Program->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->SemesterMulai->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->StatusAkhir->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->SemesterKeluar_Lulus->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->AwalPendaftaran->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Pwl->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Ijazah->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Ktp->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->KK->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->tandatangan->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->IjazahIM->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->TranskriptIM->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Skripsi->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->TASkripsi->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Plagiat->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->riwayatakademik->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->keuangan->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->pendukung->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->lainlain->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Ferval->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecords = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $RecKey = [];
	public $IsModal = FALSE;
	public $docmhs_Count;
	public $tblNilaiPerMhs_Count;
	public $Wali_IPS_Count;
	public $ekpt_Ferval_Count;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canView()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("IM_Mhslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->setVisibility();
		$this->Nama_Mhs->setVisibility();
		$this->Tmp_Lahir->setVisibility();
		$this->Tgl_Lahir->setVisibility();
		$this->Status_Akd->setVisibility();
		$this->Kode_Fak->setVisibility();
		$this->Kode_jp->setVisibility();
		$this->Jurusan->setVisibility();
		$this->Program->setVisibility();
		$this->TaMasuk->setVisibility();
		$this->PerMasuk->setVisibility();
		$this->SemesterMulai->setVisibility();
		$this->tglmasuk->setVisibility();
		$this->Status->setVisibility();
		$this->StatusAkhir->setVisibility();
		$this->SemesterKeluar_Lulus->setVisibility();
		$this->Status_Masuk->setVisibility();
		$this->AwalPendaftaran->setVisibility();
		$this->Pwl->setVisibility();
		$this->Ijazah->setVisibility();
		$this->Ktp->setVisibility();
		$this->KK->setVisibility();
		$this->tandatangan->setVisibility();
		$this->IjazahIM->setVisibility();
		$this->TranskriptIM->setVisibility();
		$this->Skripsi->setVisibility();
		$this->TASkripsi->setVisibility();
		$this->Plagiat->setVisibility();
		$this->riwayatakademik->setVisibility();
		$this->keuangan->setVisibility();
		$this->pendukung->setVisibility();
		$this->lainlain->setVisibility();
		$this->Ferval->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Status_Akd);
		$this->setupLookupOptions($this->Kode_Fak);
		$this->setupLookupOptions($this->Kode_jp);
		$this->setupLookupOptions($this->TaMasuk);

		// Check permission
		if (!$Security->canView()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("IM_Mhslist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("Nim") !== NULL) {
				$this->Nim->setQueryStringValue(Get("Nim"));
				$this->RecKey["Nim"] = $this->Nim->QueryStringValue;
			} elseif (IsApi() && Key(0) !== NULL) {
				$this->Nim->setQueryStringValue(Key(0));
				$this->RecKey["Nim"] = $this->Nim->QueryStringValue;
			} elseif (Post("Nim") !== NULL) {
				$this->Nim->setFormValue(Post("Nim"));
				$this->RecKey["Nim"] = $this->Nim->FormValue;
			} elseif (IsApi() && Route(2) !== NULL) {
				$this->Nim->setFormValue(Route(2));
				$this->RecKey["Nim"] = $this->Nim->FormValue;
			} else {
				$returnUrl = "IM_Mhslist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = $this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "IM_Mhslist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "IM_Mhslist.php"; // Not page request, return to list
		}
		if ($returnUrl != "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Set up detail parameters
		$this->setupDetailParms();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];
		$option = $options["detail"];
		$detailTableLink = "";
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail_docmhs"
		$item = &$option->add("detail_docmhs");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("docmhs", "TblCaption");
		$body .= "&nbsp;" . str_replace("%c", $this->docmhs_Count, $Language->phrase("DetailCount"));
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("docmhslist.php?" . Config("TABLE_SHOW_MASTER") . "=IM_Mhs&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["docmhs_grid"]))
			$GLOBALS["docmhs_grid"] = new docmhs_grid();
		if ($GLOBALS["docmhs_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'IM_Mhs')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=docmhs")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar != "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "docmhs";
		}
		if ($links != "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'docmhs');
		if ($item->Visible) {
			if ($detailTableLink != "")
				$detailTableLink .= ",";
			$detailTableLink .= "docmhs";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail_tblNilaiPerMhs"
		$item = &$option->add("detail_tblNilaiPerMhs");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("tblNilaiPerMhs", "TblCaption");
		$body .= "&nbsp;" . str_replace("%c", $this->tblNilaiPerMhs_Count, $Language->phrase("DetailCount"));
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("tblNilaiPerMhslist.php?" . Config("TABLE_SHOW_MASTER") . "=IM_Mhs&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["tblNilaiPerMhs_grid"]))
			$GLOBALS["tblNilaiPerMhs_grid"] = new tblNilaiPerMhs_grid();
		if ($GLOBALS["tblNilaiPerMhs_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'IM_Mhs')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=tblNilaiPerMhs")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar != "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "tblNilaiPerMhs";
		}
		if ($links != "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'tblNilaiPerMhs');
		if ($item->Visible) {
			if ($detailTableLink != "")
				$detailTableLink .= ",";
			$detailTableLink .= "tblNilaiPerMhs";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail_Wali_IPS"
		$item = &$option->add("detail_Wali_IPS");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("Wali_IPS", "TblCaption");
		$body .= "&nbsp;" . str_replace("%c", $this->Wali_IPS_Count, $Language->phrase("DetailCount"));
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("Wali_IPSlist.php?" . Config("TABLE_SHOW_MASTER") . "=IM_Mhs&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["Wali_IPS_grid"]))
			$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid();
		if ($GLOBALS["Wali_IPS_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'IM_Mhs')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=Wali_IPS")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar != "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "Wali_IPS";
		}
		if ($links != "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'Wali_IPS');
		if ($item->Visible) {
			if ($detailTableLink != "")
				$detailTableLink .= ",";
			$detailTableLink .= "Wali_IPS";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail_ekpt_Ferval"
		$item = &$option->add("detail_ekpt_Ferval");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("ekpt_Ferval", "TblCaption");
		$body .= "&nbsp;" . str_replace("%c", $this->ekpt_Ferval_Count, $Language->phrase("DetailCount"));
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("ekpt_Fervallist.php?" . Config("TABLE_SHOW_MASTER") . "=IM_Mhs&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["ekpt_Ferval_grid"]))
			$GLOBALS["ekpt_Ferval_grid"] = new ekpt_Ferval_grid();
		if ($GLOBALS["ekpt_Ferval_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'IM_Mhs')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=ekpt_Ferval")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar != "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "ekpt_Ferval";
		}
		if ($links != "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'ekpt_Ferval');
		if ($item->Visible) {
			if ($detailTableLink != "")
				$detailTableLink .= ",";
			$detailTableLink .= "ekpt_Ferval";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$item = &$option->add("details");
			$item->Body = $body;
		}

		// Set up detail default
		$option = $options["detail"];
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$ar = explode(",", $detailTableLink);
		$cnt = count($ar);
		$option->UseDropDownButton = ($cnt > 1);
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up action default
		$option = $options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Nama_Mhs->setDbValue($row['Nama_Mhs']);
		$this->Tmp_Lahir->setDbValue($row['Tmp_Lahir']);
		$this->Tgl_Lahir->setDbValue($row['Tgl_Lahir']);
		$this->Status_Akd->setDbValue($row['Status_Akd']);
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Kode_jp->setDbValue($row['Kode_jp']);
		$this->Jurusan->setDbValue($row['Jurusan']);
		$this->Program->setDbValue($row['Program']);
		$this->TaMasuk->setDbValue($row['TaMasuk']);
		$this->PerMasuk->setDbValue($row['PerMasuk']);
		$this->SemesterMulai->setDbValue($row['SemesterMulai']);
		$this->tglmasuk->setDbValue($row['tglmasuk']);
		$this->Status->setDbValue($row['Status']);
		$this->StatusAkhir->setDbValue($row['StatusAkhir']);
		$this->SemesterKeluar_Lulus->setDbValue($row['SemesterKeluar_Lulus']);
		$this->Status_Masuk->setDbValue($row['Status_Masuk']);
		$this->AwalPendaftaran->setDbValue($row['AwalPendaftaran']);
		$this->Pwl->setDbValue($row['Pwl']);
		$this->Ijazah->setDbValue($row['Ijazah']);
		$this->Ktp->setDbValue($row['Ktp']);
		$this->KK->setDbValue($row['KK']);
		$this->tandatangan->setDbValue($row['tandatangan']);
		$this->IjazahIM->setDbValue($row['IjazahIM']);
		$this->TranskriptIM->setDbValue($row['TranskriptIM']);
		$this->Skripsi->setDbValue($row['Skripsi']);
		$this->TASkripsi->setDbValue($row['TASkripsi']);
		$this->Plagiat->setDbValue($row['Plagiat']);
		$this->riwayatakademik->setDbValue($row['riwayatakademik']);
		$this->keuangan->setDbValue($row['keuangan']);
		$this->pendukung->setDbValue($row['pendukung']);
		$this->lainlain->setDbValue($row['lainlain']);
		$this->Ferval->setDbValue($row['Ferval']);
		if (!isset($GLOBALS["docmhs_grid"]))
			$GLOBALS["docmhs_grid"] = new docmhs_grid();
		$detailFilter = $GLOBALS["docmhs"]->sqlDetailFilter_IM_Mhs();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "DB"), $detailFilter);
		$GLOBALS["docmhs"]->setCurrentMasterTable("IM_Mhs");
		$detailFilter = $GLOBALS["docmhs"]->applyUserIDFilters($detailFilter);
		$this->docmhs_Count = $GLOBALS["docmhs"]->loadRecordCount($detailFilter);
		if (!isset($GLOBALS["tblNilaiPerMhs_grid"]))
			$GLOBALS["tblNilaiPerMhs_grid"] = new tblNilaiPerMhs_grid();
		$detailFilter = $GLOBALS["tblNilaiPerMhs"]->sqlDetailFilter_IM_Mhs();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "IM1"), $detailFilter);
		$GLOBALS["tblNilaiPerMhs"]->setCurrentMasterTable("IM_Mhs");
		$detailFilter = $GLOBALS["tblNilaiPerMhs"]->applyUserIDFilters($detailFilter);
		$this->tblNilaiPerMhs_Count = $GLOBALS["tblNilaiPerMhs"]->loadRecordCount($detailFilter);
		if (!isset($GLOBALS["Wali_IPS_grid"]))
			$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid();
		$detailFilter = $GLOBALS["Wali_IPS"]->sqlDetailFilter_IM_Mhs();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "DB"), $detailFilter);
		$GLOBALS["Wali_IPS"]->setCurrentMasterTable("IM_Mhs");
		$detailFilter = $GLOBALS["Wali_IPS"]->applyUserIDFilters($detailFilter);
		$this->Wali_IPS_Count = $GLOBALS["Wali_IPS"]->loadRecordCount($detailFilter);
		if (!isset($GLOBALS["ekpt_Ferval_grid"]))
			$GLOBALS["ekpt_Ferval_grid"] = new ekpt_Ferval_grid();
		$detailFilter = $GLOBALS["ekpt_Ferval"]->sqlDetailFilter_IM_Mhs();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "DB"), $detailFilter);
		$GLOBALS["ekpt_Ferval"]->setCurrentMasterTable("IM_Mhs");
		$detailFilter = $GLOBALS["ekpt_Ferval"]->applyUserIDFilters($detailFilter);
		$this->ekpt_Ferval_Count = $GLOBALS["ekpt_Ferval"]->loadRecordCount($detailFilter);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Nama_Mhs'] = NULL;
		$row['Tmp_Lahir'] = NULL;
		$row['Tgl_Lahir'] = NULL;
		$row['Status_Akd'] = NULL;
		$row['Kode_Fak'] = NULL;
		$row['Kode_jp'] = NULL;
		$row['Jurusan'] = NULL;
		$row['Program'] = NULL;
		$row['TaMasuk'] = NULL;
		$row['PerMasuk'] = NULL;
		$row['SemesterMulai'] = NULL;
		$row['tglmasuk'] = NULL;
		$row['Status'] = NULL;
		$row['StatusAkhir'] = NULL;
		$row['SemesterKeluar_Lulus'] = NULL;
		$row['Status_Masuk'] = NULL;
		$row['AwalPendaftaran'] = NULL;
		$row['Pwl'] = NULL;
		$row['Ijazah'] = NULL;
		$row['Ktp'] = NULL;
		$row['KK'] = NULL;
		$row['tandatangan'] = NULL;
		$row['IjazahIM'] = NULL;
		$row['TranskriptIM'] = NULL;
		$row['Skripsi'] = NULL;
		$row['TASkripsi'] = NULL;
		$row['Plagiat'] = NULL;
		$row['riwayatakademik'] = NULL;
		$row['keuangan'] = NULL;
		$row['pendukung'] = NULL;
		$row['lainlain'] = NULL;
		$row['Ferval'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Nama_Mhs
		// Tmp_Lahir
		// Tgl_Lahir
		// Status_Akd
		// Kode_Fak
		// Kode_jp
		// Jurusan
		// Program
		// TaMasuk
		// PerMasuk
		// SemesterMulai
		// tglmasuk
		// Status
		// StatusAkhir
		// SemesterKeluar_Lulus
		// Status_Masuk
		// AwalPendaftaran
		// Pwl
		// Ijazah
		// Ktp
		// KK
		// tandatangan
		// IjazahIM
		// TranskriptIM
		// Skripsi
		// TASkripsi
		// Plagiat
		// riwayatakademik
		// keuangan
		// pendukung
		// lainlain
		// Ferval

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
			$this->Nama_Mhs->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 7);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// Status_Akd
			$curVal = strval($this->Status_Akd->CurrentValue);
			if ($curVal != "") {
				$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
				if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
					}
				}
			} else {
				$this->Status_Akd->ViewValue = NULL;
			}
			$this->Status_Akd->ViewCustomAttributes = "";

			// Kode_Fak
			$curVal = strval($this->Kode_Fak->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
				if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
					}
				}
			} else {
				$this->Kode_Fak->ViewValue = NULL;
			}
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kode_jp
			$curVal = strval($this->Kode_jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
				if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_jp->ViewValue = NULL;
			}
			$this->Kode_jp->ViewCustomAttributes = "";

			// Jurusan
			$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
			$this->Jurusan->ViewCustomAttributes = "";

			// Program
			$this->Program->ViewValue = $this->Program->CurrentValue;
			$this->Program->ViewCustomAttributes = "";

			// TaMasuk
			$curVal = strval($this->TaMasuk->CurrentValue);
			if ($curVal != "") {
				$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
				if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
					}
				}
			} else {
				$this->TaMasuk->ViewValue = NULL;
			}
			$this->TaMasuk->ViewCustomAttributes = "";

			// PerMasuk
			if (strval($this->PerMasuk->CurrentValue) != "") {
				$this->PerMasuk->ViewValue = $this->PerMasuk->optionCaption($this->PerMasuk->CurrentValue);
			} else {
				$this->PerMasuk->ViewValue = NULL;
			}
			$this->PerMasuk->ViewCustomAttributes = "";

			// SemesterMulai
			$this->SemesterMulai->ViewValue = $this->SemesterMulai->CurrentValue;
			$this->SemesterMulai->ViewCustomAttributes = "";

			// tglmasuk
			$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
			$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
			$this->tglmasuk->ViewCustomAttributes = "";

			// Status
			$this->Status->ViewValue = $this->Status->CurrentValue;
			$this->Status->ViewCustomAttributes = "";

			// StatusAkhir
			$this->StatusAkhir->ViewValue = $this->StatusAkhir->CurrentValue;
			$this->StatusAkhir->ViewCustomAttributes = "";

			// SemesterKeluar_Lulus
			$this->SemesterKeluar_Lulus->ViewValue = $this->SemesterKeluar_Lulus->CurrentValue;
			$this->SemesterKeluar_Lulus->ViewCustomAttributes = "";

			// Status_Masuk
			if (strval($this->Status_Masuk->CurrentValue) != "") {
				$this->Status_Masuk->ViewValue = $this->Status_Masuk->optionCaption($this->Status_Masuk->CurrentValue);
			} else {
				$this->Status_Masuk->ViewValue = NULL;
			}
			$this->Status_Masuk->ViewCustomAttributes = "";

			// AwalPendaftaran
			$this->AwalPendaftaran->ViewValue = $this->AwalPendaftaran->CurrentValue;
			$this->AwalPendaftaran->ViewCustomAttributes = "";

			// Pwl
			$this->Pwl->ViewValue = $this->Pwl->CurrentValue;
			$this->Pwl->ViewValue = FormatNumber($this->Pwl->ViewValue, 0, -2, -2, -2);
			$this->Pwl->ViewCustomAttributes = "";

			// Ijazah
			$this->Ijazah->ViewValue = $this->Ijazah->CurrentValue;
			$this->Ijazah->ViewCustomAttributes = "";

			// Ktp
			$this->Ktp->ViewValue = $this->Ktp->CurrentValue;
			$this->Ktp->ViewCustomAttributes = "";

			// KK
			$this->KK->ViewValue = $this->KK->CurrentValue;
			$this->KK->ViewCustomAttributes = "";

			// tandatangan
			$this->tandatangan->ViewValue = $this->tandatangan->CurrentValue;
			$this->tandatangan->ViewCustomAttributes = "";

			// IjazahIM
			$this->IjazahIM->ViewValue = $this->IjazahIM->CurrentValue;
			$this->IjazahIM->ViewCustomAttributes = "";

			// TranskriptIM
			$this->TranskriptIM->ViewValue = $this->TranskriptIM->CurrentValue;
			$this->TranskriptIM->ViewCustomAttributes = "";

			// Skripsi
			$this->Skripsi->ViewValue = $this->Skripsi->CurrentValue;
			$this->Skripsi->ViewCustomAttributes = "";

			// TASkripsi
			$this->TASkripsi->ViewValue = $this->TASkripsi->CurrentValue;
			$this->TASkripsi->ViewCustomAttributes = "";

			// Plagiat
			$this->Plagiat->ViewValue = $this->Plagiat->CurrentValue;
			$this->Plagiat->ViewCustomAttributes = "";

			// riwayatakademik
			$this->riwayatakademik->ViewValue = $this->riwayatakademik->CurrentValue;
			$this->riwayatakademik->ViewCustomAttributes = "";

			// keuangan
			$this->keuangan->ViewValue = $this->keuangan->CurrentValue;
			$this->keuangan->ViewCustomAttributes = "";

			// pendukung
			$this->pendukung->ViewValue = $this->pendukung->CurrentValue;
			$this->pendukung->ViewCustomAttributes = "";

			// lainlain
			$this->lainlain->ViewValue = $this->lainlain->CurrentValue;
			$this->lainlain->ViewCustomAttributes = "";

			// Ferval
			$this->Ferval->ViewValue = $this->Ferval->CurrentValue;
			$this->Ferval->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";
			$this->Nama_Mhs->TooltipValue = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->LinkCustomAttributes = "";
			$this->Tmp_Lahir->HrefValue = "";
			$this->Tmp_Lahir->TooltipValue = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->LinkCustomAttributes = "";
			$this->Tgl_Lahir->HrefValue = "";
			$this->Tgl_Lahir->TooltipValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";
			$this->Status_Akd->TooltipValue = "";

			// Kode_Fak
			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";
			$this->Kode_Fak->TooltipValue = "";

			// Kode_jp
			$this->Kode_jp->LinkCustomAttributes = "";
			$this->Kode_jp->HrefValue = "";
			$this->Kode_jp->TooltipValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";
			$this->TaMasuk->TooltipValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";
			$this->PerMasuk->TooltipValue = "";

			// SemesterMulai
			$this->SemesterMulai->LinkCustomAttributes = "";
			$this->SemesterMulai->HrefValue = "";
			$this->SemesterMulai->TooltipValue = "";

			// tglmasuk
			$this->tglmasuk->LinkCustomAttributes = "";
			$this->tglmasuk->HrefValue = "";
			$this->tglmasuk->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";

			// StatusAkhir
			$this->StatusAkhir->LinkCustomAttributes = "";
			$this->StatusAkhir->HrefValue = "";
			$this->StatusAkhir->TooltipValue = "";

			// SemesterKeluar_Lulus
			$this->SemesterKeluar_Lulus->LinkCustomAttributes = "";
			$this->SemesterKeluar_Lulus->HrefValue = "";
			$this->SemesterKeluar_Lulus->TooltipValue = "";

			// Status_Masuk
			$this->Status_Masuk->LinkCustomAttributes = "";
			$this->Status_Masuk->HrefValue = "";
			$this->Status_Masuk->TooltipValue = "";

			// AwalPendaftaran
			$this->AwalPendaftaran->LinkCustomAttributes = "";
			$this->AwalPendaftaran->HrefValue = "";
			$this->AwalPendaftaran->TooltipValue = "";

			// Pwl
			$this->Pwl->LinkCustomAttributes = "";
			$this->Pwl->HrefValue = "";
			$this->Pwl->TooltipValue = "";

			// Ijazah
			$this->Ijazah->LinkCustomAttributes = "";
			if (!EmptyValue($this->Ijazah->CurrentValue)) {
				$this->Ijazah->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . $this->Ijazah->CurrentValue; // Add prefix/suffix
				$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
			} else {
				$this->Ijazah->HrefValue = "";
			}
			$this->Ijazah->TooltipValue = "";

			// Ktp
			$this->Ktp->LinkCustomAttributes = "";
			if (!EmptyValue($this->Ktp->CurrentValue)) {
				$this->Ktp->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . $this->Ktp->CurrentValue; // Add prefix/suffix
				$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
			} else {
				$this->Ktp->HrefValue = "";
			}
			$this->Ktp->TooltipValue = "";

			// KK
			$this->KK->LinkCustomAttributes = "";
			if (!EmptyValue($this->KK->CurrentValue)) {
				$this->KK->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->KK->ViewValue) && !is_array($this->KK->ViewValue) ? RemoveHtml($this->KK->ViewValue) : $this->KK->CurrentValue); // Add prefix/suffix
				$this->KK->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
			} else {
				$this->KK->HrefValue = "";
			}
			$this->KK->TooltipValue = "";

			// tandatangan
			$this->tandatangan->LinkCustomAttributes = "";
			if (!EmptyValue($this->tandatangan->CurrentValue)) {
				$this->tandatangan->HrefValue = "http://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->tandatangan->ViewValue) && !is_array($this->tandatangan->ViewValue) ? RemoveHtml($this->tandatangan->ViewValue) : $this->tandatangan->CurrentValue); // Add prefix/suffix
				$this->tandatangan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->tandatangan->HrefValue = FullUrl($this->tandatangan->HrefValue, "href");
			} else {
				$this->tandatangan->HrefValue = "";
			}
			$this->tandatangan->TooltipValue = "";

			// IjazahIM
			$this->IjazahIM->LinkCustomAttributes = "";
			if (!EmptyValue($this->IjazahIM->CurrentValue)) {
				$this->IjazahIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->IjazahIM->ViewValue) && !is_array($this->IjazahIM->ViewValue) ? RemoveHtml($this->IjazahIM->ViewValue) : $this->IjazahIM->CurrentValue); // Add prefix/suffix
				$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
			} else {
				$this->IjazahIM->HrefValue = "";
			}
			$this->IjazahIM->TooltipValue = "";

			// TranskriptIM
			$this->TranskriptIM->LinkCustomAttributes = "";
			if (!EmptyValue($this->TranskriptIM->CurrentValue)) {
				$this->TranskriptIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->TranskriptIM->ViewValue) && !is_array($this->TranskriptIM->ViewValue) ? RemoveHtml($this->TranskriptIM->ViewValue) : $this->TranskriptIM->CurrentValue); // Add prefix/suffix
				$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
			} else {
				$this->TranskriptIM->HrefValue = "";
			}
			$this->TranskriptIM->TooltipValue = "";

			// Skripsi
			$this->Skripsi->LinkCustomAttributes = "";
			if (!EmptyValue($this->Skripsi->CurrentValue)) {
				$this->Skripsi->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Skripsi->ViewValue) && !is_array($this->Skripsi->ViewValue) ? RemoveHtml($this->Skripsi->ViewValue) : $this->Skripsi->CurrentValue); // Add prefix/suffix
				$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
			} else {
				$this->Skripsi->HrefValue = "";
			}
			$this->Skripsi->TooltipValue = "";

			// TASkripsi
			$this->TASkripsi->LinkCustomAttributes = "";
			if (!EmptyValue($this->TASkripsi->CurrentValue)) {
				$this->TASkripsi->HrefValue = "https://akademik.stmik-im.ac.id/docs/TaSkripsi/" . (!empty($this->TASkripsi->ViewValue) && !is_array($this->TASkripsi->ViewValue) ? RemoveHtml($this->TASkripsi->ViewValue) : $this->TASkripsi->CurrentValue); // Add prefix/suffix
				$this->TASkripsi->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->TASkripsi->HrefValue = FullUrl($this->TASkripsi->HrefValue, "href");
			} else {
				$this->TASkripsi->HrefValue = "";
			}
			$this->TASkripsi->TooltipValue = "";

			// Plagiat
			$this->Plagiat->LinkCustomAttributes = "";
			if (!EmptyValue($this->Plagiat->CurrentValue)) {
				$this->Plagiat->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Plagiat->ViewValue) && !is_array($this->Plagiat->ViewValue) ? RemoveHtml($this->Plagiat->ViewValue) : $this->Plagiat->CurrentValue); // Add prefix/suffix
				$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
			} else {
				$this->Plagiat->HrefValue = "";
			}
			$this->Plagiat->TooltipValue = "";

			// riwayatakademik
			$this->riwayatakademik->LinkCustomAttributes = "";
			if (!EmptyValue($this->riwayatakademik->CurrentValue)) {
				$this->riwayatakademik->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->riwayatakademik->ViewValue) && !is_array($this->riwayatakademik->ViewValue) ? RemoveHtml($this->riwayatakademik->ViewValue) : $this->riwayatakademik->CurrentValue); // Add prefix/suffix
				$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
			} else {
				$this->riwayatakademik->HrefValue = "";
			}
			$this->riwayatakademik->TooltipValue = "";

			// keuangan
			$this->keuangan->LinkCustomAttributes = "";
			if (!EmptyValue($this->keuangan->CurrentValue)) {
				$this->keuangan->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/keu/" . (!empty($this->keuangan->ViewValue) && !is_array($this->keuangan->ViewValue) ? RemoveHtml($this->keuangan->ViewValue) : $this->keuangan->CurrentValue); // Add prefix/suffix
				$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
			} else {
				$this->keuangan->HrefValue = "";
			}
			$this->keuangan->TooltipValue = "";

			// pendukung
			$this->pendukung->LinkCustomAttributes = "";
			if (!EmptyValue($this->pendukung->CurrentValue)) {
				$this->pendukung->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/pendukung/" . (!empty($this->pendukung->ViewValue) && !is_array($this->pendukung->ViewValue) ? RemoveHtml($this->pendukung->ViewValue) : $this->pendukung->CurrentValue); // Add prefix/suffix
				$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
			} else {
				$this->pendukung->HrefValue = "";
			}
			$this->pendukung->TooltipValue = "";

			// lainlain
			$this->lainlain->LinkCustomAttributes = "";
			if (!EmptyValue($this->lainlain->CurrentValue)) {
				$this->lainlain->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/lainlain/" . (!empty($this->lainlain->ViewValue) && !is_array($this->lainlain->ViewValue) ? RemoveHtml($this->lainlain->ViewValue) : $this->lainlain->CurrentValue); // Add prefix/suffix
				$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
			} else {
				$this->lainlain->HrefValue = "";
			}
			$this->lainlain->TooltipValue = "";

			// Ferval
			$this->Ferval->LinkCustomAttributes = "";
			$this->Ferval->HrefValue = "";
			$this->Ferval->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("docmhs", $detailTblVar)) {
				if (!isset($GLOBALS["docmhs_grid"]))
					$GLOBALS["docmhs_grid"] = new docmhs_grid();
				if ($GLOBALS["docmhs_grid"]->DetailView) {
					$GLOBALS["docmhs_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["docmhs_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["docmhs_grid"]->setStartRecordNumber(1);
					$GLOBALS["docmhs_grid"]->Nim->IsDetailKey = TRUE;
					$GLOBALS["docmhs_grid"]->Nim->CurrentValue = $this->Nim->CurrentValue;
					$GLOBALS["docmhs_grid"]->Nim->setSessionValue($GLOBALS["docmhs_grid"]->Nim->CurrentValue);
				}
			}
			if (in_array("tblNilaiPerMhs", $detailTblVar)) {
				if (!isset($GLOBALS["tblNilaiPerMhs_grid"]))
					$GLOBALS["tblNilaiPerMhs_grid"] = new tblNilaiPerMhs_grid();
				if ($GLOBALS["tblNilaiPerMhs_grid"]->DetailView) {
					$GLOBALS["tblNilaiPerMhs_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["tblNilaiPerMhs_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["tblNilaiPerMhs_grid"]->setStartRecordNumber(1);
					$GLOBALS["tblNilaiPerMhs_grid"]->Nim->IsDetailKey = TRUE;
					$GLOBALS["tblNilaiPerMhs_grid"]->Nim->CurrentValue = $this->Nim->CurrentValue;
					$GLOBALS["tblNilaiPerMhs_grid"]->Nim->setSessionValue($GLOBALS["tblNilaiPerMhs_grid"]->Nim->CurrentValue);
				}
			}
			if (in_array("Wali_IPS", $detailTblVar)) {
				if (!isset($GLOBALS["Wali_IPS_grid"]))
					$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid();
				if ($GLOBALS["Wali_IPS_grid"]->DetailView) {
					$GLOBALS["Wali_IPS_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["Wali_IPS_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["Wali_IPS_grid"]->setStartRecordNumber(1);
					$GLOBALS["Wali_IPS_grid"]->Nim->IsDetailKey = TRUE;
					$GLOBALS["Wali_IPS_grid"]->Nim->CurrentValue = $this->Nim->CurrentValue;
					$GLOBALS["Wali_IPS_grid"]->Nim->setSessionValue($GLOBALS["Wali_IPS_grid"]->Nim->CurrentValue);
					$GLOBALS["Wali_IPS_grid"]->Thn_Akademik->setSessionValue(""); // Clear session key
					$GLOBALS["Wali_IPS_grid"]->Periode->setSessionValue(""); // Clear session key
				}
			}
			if (in_array("ekpt_Ferval", $detailTblVar)) {
				if (!isset($GLOBALS["ekpt_Ferval_grid"]))
					$GLOBALS["ekpt_Ferval_grid"] = new ekpt_Ferval_grid();
				if ($GLOBALS["ekpt_Ferval_grid"]->DetailView) {
					$GLOBALS["ekpt_Ferval_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["ekpt_Ferval_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["ekpt_Ferval_grid"]->setStartRecordNumber(1);
					$GLOBALS["ekpt_Ferval_grid"]->Nim->IsDetailKey = TRUE;
					$GLOBALS["ekpt_Ferval_grid"]->Nim->CurrentValue = $this->Nim->CurrentValue;
					$GLOBALS["ekpt_Ferval_grid"]->Nim->setSessionValue($GLOBALS["ekpt_Ferval_grid"]->Nim->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("IM_Mhslist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Status_Akd":
					break;
				case "x_Kode_Fak":
					break;
				case "x_Kode_jp":
					break;
				case "x_TaMasuk":
					break;
				case "x_PerMasuk":
					break;
				case "x_Status_Masuk":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Status_Akd":
							break;
						case "x_Kode_Fak":
							break;
						case "x_Kode_jp":
							break;
						case "x_TaMasuk":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
} // End class
?>