<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for IPSIPK
 */
class IPSIPK extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Thn_Akademik;
	public $Periode;
	public $Kode_jp;
	public $Status_Akd;
	public $Nim;
	public $Nama_Mhs;
	public $ThMasuk;
	public $TSKS;
	public $ips;
	public $TTSKS;
	public $IPK;
	public $Biaya;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'IPSIPK';
		$this->TableName = 'IPSIPK';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[IPSIPK]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Thn_Akademik
		$this->Thn_Akademik = new DbField('IPSIPK', 'IPSIPK', 'x_Thn_Akademik', 'Thn_Akademik', '[Thn_Akademik]', '[Thn_Akademik]', 129, 9, -1, FALSE, '[Thn_Akademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Thn_Akademik->Nullable = FALSE; // NOT NULL field
		$this->Thn_Akademik->Required = TRUE; // Required field
		$this->Thn_Akademik->Sortable = TRUE; // Allow sort
		$this->Thn_Akademik->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Thn_Akademik->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Thn_Akademik->Lookup = new Lookup('Thn_Akademik', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Thn_Akademik'] = &$this->Thn_Akademik;

		// Periode
		$this->Periode = new DbField('IPSIPK', 'IPSIPK', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 129, 2, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Periode->Nullable = FALSE; // NOT NULL field
		$this->Periode->Required = TRUE; // Required field
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->Periode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Periode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Periode->Lookup = new Lookup('Periode', 'IPSIPK', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Periode->OptionCount = 4;
		$this->fields['Periode'] = &$this->Periode;

		// Kode_jp
		$this->Kode_jp = new DbField('IPSIPK', 'IPSIPK', 'x_Kode_jp', 'Kode_jp', '[Kode_jp]', '[Kode_jp]', 129, 4, -1, FALSE, '[Kode_jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_jp->Sortable = TRUE; // Allow sort
		$this->Kode_jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_jp->Lookup = new Lookup('Kode_jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Program","Jurusan","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_jp'] = &$this->Kode_jp;

		// Status_Akd
		$this->Status_Akd = new DbField('IPSIPK', 'IPSIPK', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 200, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->Status_Akd->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status_Akd->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status_Akd->Lookup = new Lookup('Status_Akd', 'tblkelas', FALSE, 'Kelas', ["Kelas","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// Nim
		$this->Nim = new DbField('IPSIPK', 'IPSIPK', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 129, 14, -1, FALSE, '[Nim]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nim->Nullable = FALSE; // NOT NULL field
		$this->Nim->Required = TRUE; // Required field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->fields['Nim'] = &$this->Nim;

		// Nama_Mhs
		$this->Nama_Mhs = new DbField('IPSIPK', 'IPSIPK', 'x_Nama_Mhs', 'Nama_Mhs', '[Nama_Mhs]', '[Nama_Mhs]', 129, 60, -1, FALSE, '[Nama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mhs'] = &$this->Nama_Mhs;

		// ThMasuk
		$this->ThMasuk = new DbField('IPSIPK', 'IPSIPK', 'x_ThMasuk', 'ThMasuk', '[ThMasuk]', '[ThMasuk]', 129, 4, -1, FALSE, '[ThMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ThMasuk->Sortable = TRUE; // Allow sort
		$this->fields['ThMasuk'] = &$this->ThMasuk;

		// TSKS
		$this->TSKS = new DbField('IPSIPK', 'IPSIPK', 'x_TSKS', 'TSKS', '[TSKS]', 'CAST([TSKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[TSKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TSKS->Sortable = TRUE; // Allow sort
		$this->TSKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['TSKS'] = &$this->TSKS;

		// ips
		$this->ips = new DbField('IPSIPK', 'IPSIPK', 'x_ips', 'ips', '[ips]', 'CAST([ips] AS NVARCHAR)', 5, 8, -1, FALSE, '[ips]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ips->Sortable = TRUE; // Allow sort
		$this->ips->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ips'] = &$this->ips;

		// TTSKS
		$this->TTSKS = new DbField('IPSIPK', 'IPSIPK', 'x_TTSKS', 'TTSKS', '[TTSKS]', 'CAST([TTSKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[TTSKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TTSKS->Sortable = TRUE; // Allow sort
		$this->TTSKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['TTSKS'] = &$this->TTSKS;

		// IPK
		$this->IPK = new DbField('IPSIPK', 'IPSIPK', 'x_IPK', 'IPK', '[IPK]', 'CAST([IPK] AS NVARCHAR)', 5, 8, -1, FALSE, '[IPK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IPK->Sortable = TRUE; // Allow sort
		$this->IPK->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['IPK'] = &$this->IPK;

		// Biaya
		$this->Biaya = new DbField('IPSIPK', 'IPSIPK', 'x_Biaya', 'Biaya', '[Biaya]', 'CAST([Biaya] AS NVARCHAR)', 3, 4, -1, FALSE, '[Biaya]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Biaya->Nullable = FALSE; // NOT NULL field
		$this->Biaya->Required = TRUE; // Required field
		$this->Biaya->Sortable = TRUE; // Allow sort
		$this->Biaya->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Biaya'] = &$this->Biaya;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[IPSIPK]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Thn_Akademik->DbValue = $row['Thn_Akademik'];
		$this->Periode->DbValue = $row['Periode'];
		$this->Kode_jp->DbValue = $row['Kode_jp'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->Nim->DbValue = $row['Nim'];
		$this->Nama_Mhs->DbValue = $row['Nama_Mhs'];
		$this->ThMasuk->DbValue = $row['ThMasuk'];
		$this->TSKS->DbValue = $row['TSKS'];
		$this->ips->DbValue = $row['ips'];
		$this->TTSKS->DbValue = $row['TTSKS'];
		$this->IPK->DbValue = $row['IPK'];
		$this->Biaya->DbValue = $row['Biaya'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "IPSIPKlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "IPSIPKview.php")
			return $Language->phrase("View");
		elseif ($pageName == "IPSIPKedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "IPSIPKadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "IPSIPKlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("IPSIPKview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("IPSIPKview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "IPSIPKadd.php?" . $this->getUrlParm($parm);
		else
			$url = "IPSIPKadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("IPSIPKedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("IPSIPKadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("IPSIPKdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Thn_Akademik->setDbValue($rs->fields('Thn_Akademik'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->Kode_jp->setDbValue($rs->fields('Kode_jp'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->Nama_Mhs->setDbValue($rs->fields('Nama_Mhs'));
		$this->ThMasuk->setDbValue($rs->fields('ThMasuk'));
		$this->TSKS->setDbValue($rs->fields('TSKS'));
		$this->ips->setDbValue($rs->fields('ips'));
		$this->TTSKS->setDbValue($rs->fields('TTSKS'));
		$this->IPK->setDbValue($rs->fields('IPK'));
		$this->Biaya->setDbValue($rs->fields('Biaya'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Thn_Akademik
		// Periode
		// Kode_jp
		// Status_Akd
		// Nim
		// Nama_Mhs
		// ThMasuk
		// TSKS
		// ips
		// TTSKS
		// IPK
		// Biaya
		// Thn_Akademik

		$curVal = strval($this->Thn_Akademik->CurrentValue);
		if ($curVal != "") {
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->lookupCacheOption($curVal);
			if ($this->Thn_Akademik->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Thn_Akademik->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
				}
			}
		} else {
			$this->Thn_Akademik->ViewValue = NULL;
		}
		$this->Thn_Akademik->ViewCustomAttributes = "";

		// Periode
		if (strval($this->Periode->CurrentValue) != "") {
			$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
		} else {
			$this->Periode->ViewValue = NULL;
		}
		$this->Periode->ViewCustomAttributes = "";

		// Kode_jp
		$curVal = strval($this->Kode_jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
			if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_jp->ViewValue = NULL;
		}
		$this->Kode_jp->ViewCustomAttributes = "";

		// Status_Akd
		$curVal = strval($this->Status_Akd->CurrentValue);
		if ($curVal != "") {
			$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
				}
			}
		} else {
			$this->Status_Akd->ViewValue = NULL;
		}
		$this->Status_Akd->ViewCustomAttributes = "";

		// Nim
		$this->Nim->ViewValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->ViewCustomAttributes = "";

		// ThMasuk
		$this->ThMasuk->ViewValue = $this->ThMasuk->CurrentValue;
		$this->ThMasuk->ViewCustomAttributes = "";

		// TSKS
		$this->TSKS->ViewValue = $this->TSKS->CurrentValue;
		$this->TSKS->ViewValue = FormatNumber($this->TSKS->ViewValue, 0, -2, -2, -2);
		$this->TSKS->ViewCustomAttributes = "";

		// ips
		$this->ips->ViewValue = $this->ips->CurrentValue;
		$this->ips->ViewValue = FormatNumber($this->ips->ViewValue, 2, -2, -2, -2);
		$this->ips->ViewCustomAttributes = "";

		// TTSKS
		$this->TTSKS->ViewValue = $this->TTSKS->CurrentValue;
		$this->TTSKS->ViewValue = FormatNumber($this->TTSKS->ViewValue, 0, -2, -2, -2);
		$this->TTSKS->ViewCustomAttributes = "";

		// IPK
		$this->IPK->ViewValue = $this->IPK->CurrentValue;
		$this->IPK->ViewValue = FormatNumber($this->IPK->ViewValue, 2, -2, -2, -2);
		$this->IPK->ViewCustomAttributes = "";

		// Biaya
		$this->Biaya->ViewValue = $this->Biaya->CurrentValue;
		$this->Biaya->ViewValue = FormatNumber($this->Biaya->ViewValue, 0, -2, -2, -2);
		$this->Biaya->ViewCustomAttributes = "";

		// Thn_Akademik
		$this->Thn_Akademik->LinkCustomAttributes = "";
		$this->Thn_Akademik->HrefValue = "";
		$this->Thn_Akademik->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// Kode_jp
		$this->Kode_jp->LinkCustomAttributes = "";
		$this->Kode_jp->HrefValue = "";
		$this->Kode_jp->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// Nama_Mhs
		$this->Nama_Mhs->LinkCustomAttributes = "";
		$this->Nama_Mhs->HrefValue = "";
		$this->Nama_Mhs->TooltipValue = "";

		// ThMasuk
		$this->ThMasuk->LinkCustomAttributes = "";
		$this->ThMasuk->HrefValue = "";
		$this->ThMasuk->TooltipValue = "";

		// TSKS
		$this->TSKS->LinkCustomAttributes = "";
		$this->TSKS->HrefValue = "";
		$this->TSKS->TooltipValue = "";

		// ips
		$this->ips->LinkCustomAttributes = "";
		$this->ips->HrefValue = "";
		$this->ips->TooltipValue = "";

		// TTSKS
		$this->TTSKS->LinkCustomAttributes = "";
		$this->TTSKS->HrefValue = "";
		$this->TTSKS->TooltipValue = "";

		// IPK
		$this->IPK->LinkCustomAttributes = "";
		$this->IPK->HrefValue = "";
		$this->IPK->TooltipValue = "";

		// Biaya
		$this->Biaya->LinkCustomAttributes = "";
		$this->Biaya->HrefValue = "";
		$this->Biaya->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Thn_Akademik
		$this->Thn_Akademik->EditAttrs["class"] = "form-control";
		$this->Thn_Akademik->EditCustomAttributes = "";

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		$this->Periode->EditValue = $this->Periode->options(TRUE);

		// Kode_jp
		$this->Kode_jp->EditAttrs["class"] = "form-control";
		$this->Kode_jp->EditCustomAttributes = "";

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";
		if (!$this->Nim->Raw)
			$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
		$this->Nim->EditValue = $this->Nim->CurrentValue;
		$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

		// Nama_Mhs
		$this->Nama_Mhs->EditAttrs["class"] = "form-control";
		$this->Nama_Mhs->EditCustomAttributes = "";
		if (!$this->Nama_Mhs->Raw)
			$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
		$this->Nama_Mhs->EditValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

		// ThMasuk
		$this->ThMasuk->EditAttrs["class"] = "form-control";
		$this->ThMasuk->EditCustomAttributes = "";
		if (!$this->ThMasuk->Raw)
			$this->ThMasuk->CurrentValue = HtmlDecode($this->ThMasuk->CurrentValue);
		$this->ThMasuk->EditValue = $this->ThMasuk->CurrentValue;
		$this->ThMasuk->PlaceHolder = RemoveHtml($this->ThMasuk->caption());

		// TSKS
		$this->TSKS->EditAttrs["class"] = "form-control";
		$this->TSKS->EditCustomAttributes = "";
		$this->TSKS->EditValue = $this->TSKS->CurrentValue;
		$this->TSKS->PlaceHolder = RemoveHtml($this->TSKS->caption());

		// ips
		$this->ips->EditAttrs["class"] = "form-control";
		$this->ips->EditCustomAttributes = "";
		$this->ips->EditValue = $this->ips->CurrentValue;
		$this->ips->PlaceHolder = RemoveHtml($this->ips->caption());
		if (strval($this->ips->EditValue) != "" && is_numeric($this->ips->EditValue))
			$this->ips->EditValue = FormatNumber($this->ips->EditValue, -2, -2, -2, -2);
		

		// TTSKS
		$this->TTSKS->EditAttrs["class"] = "form-control";
		$this->TTSKS->EditCustomAttributes = "";
		$this->TTSKS->EditValue = $this->TTSKS->CurrentValue;
		$this->TTSKS->PlaceHolder = RemoveHtml($this->TTSKS->caption());

		// IPK
		$this->IPK->EditAttrs["class"] = "form-control";
		$this->IPK->EditCustomAttributes = "";
		$this->IPK->EditValue = $this->IPK->CurrentValue;
		$this->IPK->PlaceHolder = RemoveHtml($this->IPK->caption());
		if (strval($this->IPK->EditValue) != "" && is_numeric($this->IPK->EditValue))
			$this->IPK->EditValue = FormatNumber($this->IPK->EditValue, -2, -2, -2, -2);
		

		// Biaya
		$this->Biaya->EditAttrs["class"] = "form-control";
		$this->Biaya->EditCustomAttributes = "";
		$this->Biaya->EditValue = $this->Biaya->CurrentValue;
		$this->Biaya->PlaceHolder = RemoveHtml($this->Biaya->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->ThMasuk);
					$doc->exportCaption($this->TSKS);
					$doc->exportCaption($this->ips);
					$doc->exportCaption($this->TTSKS);
					$doc->exportCaption($this->IPK);
					$doc->exportCaption($this->Biaya);
				} else {
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->ThMasuk);
					$doc->exportCaption($this->TSKS);
					$doc->exportCaption($this->ips);
					$doc->exportCaption($this->TTSKS);
					$doc->exportCaption($this->IPK);
					$doc->exportCaption($this->Biaya);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->ThMasuk);
						$doc->exportField($this->TSKS);
						$doc->exportField($this->ips);
						$doc->exportField($this->TTSKS);
						$doc->exportField($this->IPK);
						$doc->exportField($this->Biaya);
					} else {
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->ThMasuk);
						$doc->exportField($this->TSKS);
						$doc->exportField($this->ips);
						$doc->exportField($this->TTSKS);
						$doc->exportField($this->IPK);
						$doc->exportField($this->Biaya);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>