<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class Perwalian_add extends Perwalian
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'Perwalian';

	// Page object name
	public $PageObjName = "Perwalian_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (Perwalian)
		if (!isset($GLOBALS["Perwalian"]) || get_class($GLOBALS["Perwalian"]) == PROJECT_NAMESPACE . "Perwalian") {
			$GLOBALS["Perwalian"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Perwalian"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'Perwalian');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $Perwalian;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($Perwalian);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "Perwalianview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Thn_Akademik'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Periode'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("Perwalianlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Thn_Akademik->setVisibility();
		$this->Periode->setVisibility();
		$this->Nim->setVisibility();
		$this->Sem->setVisibility();
		$this->GenapGanjil->setVisibility();
		$this->Tgl_Prw->setVisibility();
		$this->TSKSB->setVisibility();
		$this->CatatanDosenWali->setVisibility();
		$this->Keterangan->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Thn_Akademik);
		$this->setupLookupOptions($this->Nim);

		// Check permission
		if (!$Security->canAdd()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("Perwalianlist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("Thn_Akademik") !== NULL) {
				$this->Thn_Akademik->setQueryStringValue(Get("Thn_Akademik"));
				$this->setKey("Thn_Akademik", $this->Thn_Akademik->CurrentValue); // Set up key
			} else {
				$this->setKey("Thn_Akademik", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Periode") !== NULL) {
				$this->Periode->setQueryStringValue(Get("Periode"));
				$this->setKey("Periode", $this->Periode->CurrentValue); // Set up key
			} else {
				$this->setKey("Periode", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Nim") !== NULL) {
				$this->Nim->setQueryStringValue(Get("Nim"));
				$this->setKey("Nim", $this->Nim->CurrentValue); // Set up key
			} else {
				$this->setKey("Nim", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Set up detail parameters
		$this->setupDetailParms();

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("Perwalianlist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					if ($this->getCurrentDetailTable() != "") // Master/detail add
						$returnUrl = $this->getDetailUrl();
					else
						$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "Perwalianlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "Perwalianview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->Thn_Akademik->CurrentValue = NULL;
		$this->Thn_Akademik->OldValue = $this->Thn_Akademik->CurrentValue;
		$this->Periode->CurrentValue = NULL;
		$this->Periode->OldValue = $this->Periode->CurrentValue;
		$this->Nim->CurrentValue = NULL;
		$this->Nim->OldValue = $this->Nim->CurrentValue;
		$this->Sem->CurrentValue = NULL;
		$this->Sem->OldValue = $this->Sem->CurrentValue;
		$this->GenapGanjil->CurrentValue = NULL;
		$this->GenapGanjil->OldValue = $this->GenapGanjil->CurrentValue;
		$this->Tgl_Prw->CurrentValue = NULL;
		$this->Tgl_Prw->OldValue = $this->Tgl_Prw->CurrentValue;
		$this->TSKSB->CurrentValue = NULL;
		$this->TSKSB->OldValue = $this->TSKSB->CurrentValue;
		$this->CatatanDosenWali->CurrentValue = NULL;
		$this->CatatanDosenWali->OldValue = $this->CatatanDosenWali->CurrentValue;
		$this->Keterangan->CurrentValue = NULL;
		$this->Keterangan->OldValue = $this->Keterangan->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Thn_Akademik' first before field var 'x_Thn_Akademik'
		$val = $CurrentForm->hasValue("Thn_Akademik") ? $CurrentForm->getValue("Thn_Akademik") : $CurrentForm->getValue("x_Thn_Akademik");
		if (!$this->Thn_Akademik->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Thn_Akademik->Visible = FALSE; // Disable update for API request
			else
				$this->Thn_Akademik->setFormValue($val);
		}

		// Check field name 'Periode' first before field var 'x_Periode'
		$val = $CurrentForm->hasValue("Periode") ? $CurrentForm->getValue("Periode") : $CurrentForm->getValue("x_Periode");
		if (!$this->Periode->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Periode->Visible = FALSE; // Disable update for API request
			else
				$this->Periode->setFormValue($val);
		}

		// Check field name 'Nim' first before field var 'x_Nim'
		$val = $CurrentForm->hasValue("Nim") ? $CurrentForm->getValue("Nim") : $CurrentForm->getValue("x_Nim");
		if (!$this->Nim->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nim->Visible = FALSE; // Disable update for API request
			else
				$this->Nim->setFormValue($val);
		}

		// Check field name 'Sem' first before field var 'x_Sem'
		$val = $CurrentForm->hasValue("Sem") ? $CurrentForm->getValue("Sem") : $CurrentForm->getValue("x_Sem");
		if (!$this->Sem->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Sem->Visible = FALSE; // Disable update for API request
			else
				$this->Sem->setFormValue($val);
		}

		// Check field name 'GenapGanjil' first before field var 'x_GenapGanjil'
		$val = $CurrentForm->hasValue("GenapGanjil") ? $CurrentForm->getValue("GenapGanjil") : $CurrentForm->getValue("x_GenapGanjil");
		if (!$this->GenapGanjil->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->GenapGanjil->Visible = FALSE; // Disable update for API request
			else
				$this->GenapGanjil->setFormValue($val);
		}

		// Check field name 'Tgl_Prw' first before field var 'x_Tgl_Prw'
		$val = $CurrentForm->hasValue("Tgl_Prw") ? $CurrentForm->getValue("Tgl_Prw") : $CurrentForm->getValue("x_Tgl_Prw");
		if (!$this->Tgl_Prw->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tgl_Prw->Visible = FALSE; // Disable update for API request
			else
				$this->Tgl_Prw->setFormValue($val);
			$this->Tgl_Prw->CurrentValue = UnFormatDateTime($this->Tgl_Prw->CurrentValue, 7);
		}

		// Check field name 'TSKSB' first before field var 'x_TSKSB'
		$val = $CurrentForm->hasValue("TSKSB") ? $CurrentForm->getValue("TSKSB") : $CurrentForm->getValue("x_TSKSB");
		if (!$this->TSKSB->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TSKSB->Visible = FALSE; // Disable update for API request
			else
				$this->TSKSB->setFormValue($val);
		}

		// Check field name 'CatatanDosenWali' first before field var 'x_CatatanDosenWali'
		$val = $CurrentForm->hasValue("CatatanDosenWali") ? $CurrentForm->getValue("CatatanDosenWali") : $CurrentForm->getValue("x_CatatanDosenWali");
		if (!$this->CatatanDosenWali->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->CatatanDosenWali->Visible = FALSE; // Disable update for API request
			else
				$this->CatatanDosenWali->setFormValue($val);
		}

		// Check field name 'Keterangan' first before field var 'x_Keterangan'
		$val = $CurrentForm->hasValue("Keterangan") ? $CurrentForm->getValue("Keterangan") : $CurrentForm->getValue("x_Keterangan");
		if (!$this->Keterangan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Keterangan->Visible = FALSE; // Disable update for API request
			else
				$this->Keterangan->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Thn_Akademik->CurrentValue = $this->Thn_Akademik->FormValue;
		$this->Periode->CurrentValue = $this->Periode->FormValue;
		$this->Nim->CurrentValue = $this->Nim->FormValue;
		$this->Sem->CurrentValue = $this->Sem->FormValue;
		$this->GenapGanjil->CurrentValue = $this->GenapGanjil->FormValue;
		$this->Tgl_Prw->CurrentValue = $this->Tgl_Prw->FormValue;
		$this->Tgl_Prw->CurrentValue = UnFormatDateTime($this->Tgl_Prw->CurrentValue, 7);
		$this->TSKSB->CurrentValue = $this->TSKSB->FormValue;
		$this->CatatanDosenWali->CurrentValue = $this->CatatanDosenWali->FormValue;
		$this->Keterangan->CurrentValue = $this->Keterangan->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Thn_Akademik->setDbValue($row['Thn_Akademik']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Nim->setDbValue($row['Nim']);
		if (array_key_exists('EV__Nim', $rs->fields)) {
			$this->Nim->VirtualValue = $rs->fields('EV__Nim'); // Set up virtual field value
		} else {
			$this->Nim->VirtualValue = ""; // Clear value
		}
		$this->Sem->setDbValue($row['Sem']);
		$this->GenapGanjil->setDbValue($row['GenapGanjil']);
		$this->Tgl_Prw->setDbValue($row['Tgl_Prw']);
		$this->TSKSB->setDbValue($row['TSKSB']);
		$this->CatatanDosenWali->setDbValue($row['CatatanDosenWali']);
		$this->Keterangan->setDbValue($row['Keterangan']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['Thn_Akademik'] = $this->Thn_Akademik->CurrentValue;
		$row['Periode'] = $this->Periode->CurrentValue;
		$row['Nim'] = $this->Nim->CurrentValue;
		$row['Sem'] = $this->Sem->CurrentValue;
		$row['GenapGanjil'] = $this->GenapGanjil->CurrentValue;
		$row['Tgl_Prw'] = $this->Tgl_Prw->CurrentValue;
		$row['TSKSB'] = $this->TSKSB->CurrentValue;
		$row['CatatanDosenWali'] = $this->CatatanDosenWali->CurrentValue;
		$row['Keterangan'] = $this->Keterangan->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Thn_Akademik")) != "")
			$this->Thn_Akademik->OldValue = $this->getKey("Thn_Akademik"); // Thn_Akademik
		else
			$validKey = FALSE;
		if (strval($this->getKey("Periode")) != "")
			$this->Periode->OldValue = $this->getKey("Periode"); // Periode
		else
			$validKey = FALSE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Thn_Akademik
		// Periode
		// Nim
		// Sem
		// GenapGanjil
		// Tgl_Prw
		// TSKSB
		// CatatanDosenWali
		// Keterangan

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Thn_Akademik
			$curVal = strval($this->Thn_Akademik->CurrentValue);
			if ($curVal != "") {
				$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->lookupCacheOption($curVal);
				if ($this->Thn_Akademik->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Thn_Akademik->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
					}
				}
			} else {
				$this->Thn_Akademik->ViewValue = NULL;
			}
			$this->Thn_Akademik->ViewCustomAttributes = "";

			// Periode
			if (strval($this->Periode->CurrentValue) != "") {
				$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
			} else {
				$this->Periode->ViewValue = NULL;
			}
			$this->Periode->ViewCustomAttributes = "";

			// Nim
			if ($this->Nim->VirtualValue != "") {
				$this->Nim->ViewValue = $this->Nim->VirtualValue;
			} else {
				$curVal = strval($this->Nim->CurrentValue);
				if ($curVal != "") {
					$this->Nim->ViewValue = $this->Nim->lookupCacheOption($curVal);
					if ($this->Nim->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[Nim]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->Nim->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->Nim->ViewValue = $this->Nim->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->Nim->ViewValue = $this->Nim->CurrentValue;
						}
					}
				} else {
					$this->Nim->ViewValue = NULL;
				}
			}
			$this->Nim->ViewCustomAttributes = "";

			// Sem
			$this->Sem->ViewValue = $this->Sem->CurrentValue;
			$this->Sem->ViewCustomAttributes = "";

			// GenapGanjil
			$this->GenapGanjil->ViewValue = $this->GenapGanjil->CurrentValue;
			$this->GenapGanjil->ViewCustomAttributes = "";

			// Tgl_Prw
			$this->Tgl_Prw->ViewValue = $this->Tgl_Prw->CurrentValue;
			$this->Tgl_Prw->ViewValue = FormatDateTime($this->Tgl_Prw->ViewValue, 7);
			$this->Tgl_Prw->ViewCustomAttributes = "";

			// TSKSB
			$this->TSKSB->ViewValue = $this->TSKSB->CurrentValue;
			$this->TSKSB->ViewValue = FormatNumber($this->TSKSB->ViewValue, 0, -2, -2, -2);
			$this->TSKSB->ViewCustomAttributes = "";

			// CatatanDosenWali
			$this->CatatanDosenWali->ViewValue = $this->CatatanDosenWali->CurrentValue;
			$this->CatatanDosenWali->ViewCustomAttributes = "";

			// Keterangan
			$this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;
			$this->Keterangan->ViewCustomAttributes = "";

			// Thn_Akademik
			$this->Thn_Akademik->LinkCustomAttributes = "";
			$this->Thn_Akademik->HrefValue = "";
			$this->Thn_Akademik->TooltipValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";
			$this->Periode->TooltipValue = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Sem
			$this->Sem->LinkCustomAttributes = "";
			$this->Sem->HrefValue = "";
			$this->Sem->TooltipValue = "";

			// GenapGanjil
			$this->GenapGanjil->LinkCustomAttributes = "";
			$this->GenapGanjil->HrefValue = "";
			$this->GenapGanjil->TooltipValue = "";

			// Tgl_Prw
			$this->Tgl_Prw->LinkCustomAttributes = "";
			$this->Tgl_Prw->HrefValue = "";
			$this->Tgl_Prw->TooltipValue = "";

			// TSKSB
			$this->TSKSB->LinkCustomAttributes = "";
			$this->TSKSB->HrefValue = "";
			$this->TSKSB->TooltipValue = "";

			// CatatanDosenWali
			$this->CatatanDosenWali->LinkCustomAttributes = "";
			$this->CatatanDosenWali->HrefValue = "";
			$this->CatatanDosenWali->TooltipValue = "";

			// Keterangan
			$this->Keterangan->LinkCustomAttributes = "";
			$this->Keterangan->HrefValue = "";
			$this->Keterangan->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Thn_Akademik
			$this->Thn_Akademik->EditAttrs["class"] = "form-control";
			$this->Thn_Akademik->EditCustomAttributes = "";
			$curVal = trim(strval($this->Thn_Akademik->CurrentValue));
			if ($curVal != "")
				$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->lookupCacheOption($curVal);
			else
				$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->Lookup !== NULL && is_array($this->Thn_Akademik->Lookup->Options) ? $curVal : NULL;
			if ($this->Thn_Akademik->ViewValue !== NULL) { // Load from cache
				$this->Thn_Akademik->EditValue = array_values($this->Thn_Akademik->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[TA]" . SearchString("=", $this->Thn_Akademik->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Thn_Akademik->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Thn_Akademik->EditValue = $arwrk;
			}

			// Periode
			$this->Periode->EditAttrs["class"] = "form-control";
			$this->Periode->EditCustomAttributes = "";
			$this->Periode->EditValue = $this->Periode->options(TRUE);

			// Nim
			$this->Nim->EditCustomAttributes = "";
			$curVal = trim(strval($this->Nim->CurrentValue));
			if ($curVal != "")
				$this->Nim->ViewValue = $this->Nim->lookupCacheOption($curVal);
			else
				$this->Nim->ViewValue = $this->Nim->Lookup !== NULL && is_array($this->Nim->Lookup->Options) ? $curVal : NULL;
			if ($this->Nim->ViewValue !== NULL) { // Load from cache
				$this->Nim->EditValue = array_values($this->Nim->Lookup->Options);
				if ($this->Nim->ViewValue == "")
					$this->Nim->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Nim]" . SearchString("=", $this->Nim->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Nim->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->Nim->ViewValue = $this->Nim->displayValue($arwrk);
				} else {
					$this->Nim->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Nim->EditValue = $arwrk;
			}

			// Sem
			$this->Sem->EditAttrs["class"] = "form-control";
			$this->Sem->EditCustomAttributes = "";
			if (!$this->Sem->Raw)
				$this->Sem->CurrentValue = HtmlDecode($this->Sem->CurrentValue);
			$this->Sem->EditValue = HtmlEncode($this->Sem->CurrentValue);
			$this->Sem->PlaceHolder = RemoveHtml($this->Sem->caption());

			// GenapGanjil
			$this->GenapGanjil->EditAttrs["class"] = "form-control";
			$this->GenapGanjil->EditCustomAttributes = "";
			if (!$this->GenapGanjil->Raw)
				$this->GenapGanjil->CurrentValue = HtmlDecode($this->GenapGanjil->CurrentValue);
			$this->GenapGanjil->EditValue = HtmlEncode($this->GenapGanjil->CurrentValue);
			$this->GenapGanjil->PlaceHolder = RemoveHtml($this->GenapGanjil->caption());

			// Tgl_Prw
			$this->Tgl_Prw->EditAttrs["class"] = "form-control";
			$this->Tgl_Prw->EditCustomAttributes = "";
			$this->Tgl_Prw->EditValue = HtmlEncode(FormatDateTime($this->Tgl_Prw->CurrentValue, 7));
			$this->Tgl_Prw->PlaceHolder = RemoveHtml($this->Tgl_Prw->caption());

			// TSKSB
			$this->TSKSB->EditAttrs["class"] = "form-control";
			$this->TSKSB->EditCustomAttributes = "";
			$this->TSKSB->EditValue = HtmlEncode($this->TSKSB->CurrentValue);
			$this->TSKSB->PlaceHolder = RemoveHtml($this->TSKSB->caption());

			// CatatanDosenWali
			$this->CatatanDosenWali->EditAttrs["class"] = "form-control";
			$this->CatatanDosenWali->EditCustomAttributes = "";
			if (!$this->CatatanDosenWali->Raw)
				$this->CatatanDosenWali->CurrentValue = HtmlDecode($this->CatatanDosenWali->CurrentValue);
			$this->CatatanDosenWali->EditValue = HtmlEncode($this->CatatanDosenWali->CurrentValue);
			$this->CatatanDosenWali->PlaceHolder = RemoveHtml($this->CatatanDosenWali->caption());

			// Keterangan
			$this->Keterangan->EditAttrs["class"] = "form-control";
			$this->Keterangan->EditCustomAttributes = "";
			if (!$this->Keterangan->Raw)
				$this->Keterangan->CurrentValue = HtmlDecode($this->Keterangan->CurrentValue);
			$this->Keterangan->EditValue = HtmlEncode($this->Keterangan->CurrentValue);
			$this->Keterangan->PlaceHolder = RemoveHtml($this->Keterangan->caption());

			// Add refer script
			// Thn_Akademik

			$this->Thn_Akademik->LinkCustomAttributes = "";
			$this->Thn_Akademik->HrefValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";

			// Sem
			$this->Sem->LinkCustomAttributes = "";
			$this->Sem->HrefValue = "";

			// GenapGanjil
			$this->GenapGanjil->LinkCustomAttributes = "";
			$this->GenapGanjil->HrefValue = "";

			// Tgl_Prw
			$this->Tgl_Prw->LinkCustomAttributes = "";
			$this->Tgl_Prw->HrefValue = "";

			// TSKSB
			$this->TSKSB->LinkCustomAttributes = "";
			$this->TSKSB->HrefValue = "";

			// CatatanDosenWali
			$this->CatatanDosenWali->LinkCustomAttributes = "";
			$this->CatatanDosenWali->HrefValue = "";

			// Keterangan
			$this->Keterangan->LinkCustomAttributes = "";
			$this->Keterangan->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Thn_Akademik->Required) {
			if (!$this->Thn_Akademik->IsDetailKey && $this->Thn_Akademik->FormValue != NULL && $this->Thn_Akademik->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Thn_Akademik->caption(), $this->Thn_Akademik->RequiredErrorMessage));
			}
		}
		if ($this->Periode->Required) {
			if (!$this->Periode->IsDetailKey && $this->Periode->FormValue != NULL && $this->Periode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Periode->caption(), $this->Periode->RequiredErrorMessage));
			}
		}
		if ($this->Nim->Required) {
			if (!$this->Nim->IsDetailKey && $this->Nim->FormValue != NULL && $this->Nim->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nim->caption(), $this->Nim->RequiredErrorMessage));
			}
		}
		if ($this->Sem->Required) {
			if (!$this->Sem->IsDetailKey && $this->Sem->FormValue != NULL && $this->Sem->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Sem->caption(), $this->Sem->RequiredErrorMessage));
			}
		}
		if ($this->GenapGanjil->Required) {
			if (!$this->GenapGanjil->IsDetailKey && $this->GenapGanjil->FormValue != NULL && $this->GenapGanjil->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->GenapGanjil->caption(), $this->GenapGanjil->RequiredErrorMessage));
			}
		}
		if ($this->Tgl_Prw->Required) {
			if (!$this->Tgl_Prw->IsDetailKey && $this->Tgl_Prw->FormValue != NULL && $this->Tgl_Prw->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tgl_Prw->caption(), $this->Tgl_Prw->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->Tgl_Prw->FormValue)) {
			AddMessage($FormError, $this->Tgl_Prw->errorMessage());
		}
		if ($this->TSKSB->Required) {
			if (!$this->TSKSB->IsDetailKey && $this->TSKSB->FormValue != NULL && $this->TSKSB->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TSKSB->caption(), $this->TSKSB->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->TSKSB->FormValue)) {
			AddMessage($FormError, $this->TSKSB->errorMessage());
		}
		if ($this->CatatanDosenWali->Required) {
			if (!$this->CatatanDosenWali->IsDetailKey && $this->CatatanDosenWali->FormValue != NULL && $this->CatatanDosenWali->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CatatanDosenWali->caption(), $this->CatatanDosenWali->RequiredErrorMessage));
			}
		}
		if ($this->Keterangan->Required) {
			if (!$this->Keterangan->IsDetailKey && $this->Keterangan->FormValue != NULL && $this->Keterangan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Keterangan->caption(), $this->Keterangan->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("tblNilai", $detailTblVar) && $GLOBALS["tblNilai"]->DetailAdd) {
			if (!isset($GLOBALS["tblNilai_grid"]))
				$GLOBALS["tblNilai_grid"] = new tblNilai_grid(); // Get detail page object
			$GLOBALS["tblNilai_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Begin transaction
		if ($this->getCurrentDetailTable() != "")
			$conn->beginTrans();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Thn_Akademik
		$this->Thn_Akademik->setDbValueDef($rsnew, $this->Thn_Akademik->CurrentValue, "", FALSE);

		// Periode
		$this->Periode->setDbValueDef($rsnew, $this->Periode->CurrentValue, "", FALSE);

		// Nim
		$this->Nim->setDbValueDef($rsnew, $this->Nim->CurrentValue, "", FALSE);

		// Sem
		$this->Sem->setDbValueDef($rsnew, $this->Sem->CurrentValue, NULL, FALSE);

		// GenapGanjil
		$this->GenapGanjil->setDbValueDef($rsnew, $this->GenapGanjil->CurrentValue, NULL, FALSE);

		// Tgl_Prw
		$this->Tgl_Prw->setDbValueDef($rsnew, UnFormatDateTime($this->Tgl_Prw->CurrentValue, 7), NULL, FALSE);

		// TSKSB
		$this->TSKSB->setDbValueDef($rsnew, $this->TSKSB->CurrentValue, NULL, FALSE);

		// CatatanDosenWali
		$this->CatatanDosenWali->setDbValueDef($rsnew, $this->CatatanDosenWali->CurrentValue, NULL, FALSE);

		// Keterangan
		$this->Keterangan->setDbValueDef($rsnew, $this->Keterangan->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Thn_Akademik']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Periode']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Nim']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}

		// Add detail records
		if ($addRow) {
			$detailTblVar = explode(",", $this->getCurrentDetailTable());
			if (in_array("tblNilai", $detailTblVar) && $GLOBALS["tblNilai"]->DetailAdd) {
				$GLOBALS["tblNilai"]->Nim->setSessionValue($this->Nim->CurrentValue); // Set master key
				$GLOBALS["tblNilai"]->Thn_Akademik->setSessionValue($this->Thn_Akademik->CurrentValue); // Set master key
				$GLOBALS["tblNilai"]->Periode->setSessionValue($this->Periode->CurrentValue); // Set master key
				if (!isset($GLOBALS["tblNilai_grid"]))
					$GLOBALS["tblNilai_grid"] = new tblNilai_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "tblNilai"); // Load user level of detail table
				$addRow = $GLOBALS["tblNilai_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow) {
					$GLOBALS["tblNilai"]->Nim->setSessionValue(""); // Clear master key if insert failed
					$GLOBALS["tblNilai"]->Thn_Akademik->setSessionValue(""); // Clear master key if insert failed
					$GLOBALS["tblNilai"]->Periode->setSessionValue(""); // Clear master key if insert failed
				}
			}
		}

		// Commit/Rollback transaction
		if ($this->getCurrentDetailTable() != "") {
			if ($addRow) {
				$conn->commitTrans(); // Commit transaction
			} else {
				$conn->rollbackTrans(); // Rollback transaction
			}
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("tblNilai", $detailTblVar)) {
				if (!isset($GLOBALS["tblNilai_grid"]))
					$GLOBALS["tblNilai_grid"] = new tblNilai_grid();
				if ($GLOBALS["tblNilai_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["tblNilai_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["tblNilai_grid"]->CurrentMode = "add";
					$GLOBALS["tblNilai_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["tblNilai_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["tblNilai_grid"]->setStartRecordNumber(1);
					$GLOBALS["tblNilai_grid"]->Nim->IsDetailKey = TRUE;
					$GLOBALS["tblNilai_grid"]->Nim->CurrentValue = $this->Nim->CurrentValue;
					$GLOBALS["tblNilai_grid"]->Nim->setSessionValue($GLOBALS["tblNilai_grid"]->Nim->CurrentValue);
					$GLOBALS["tblNilai_grid"]->Thn_Akademik->IsDetailKey = TRUE;
					$GLOBALS["tblNilai_grid"]->Thn_Akademik->CurrentValue = $this->Thn_Akademik->CurrentValue;
					$GLOBALS["tblNilai_grid"]->Thn_Akademik->setSessionValue($GLOBALS["tblNilai_grid"]->Thn_Akademik->CurrentValue);
					$GLOBALS["tblNilai_grid"]->Periode->IsDetailKey = TRUE;
					$GLOBALS["tblNilai_grid"]->Periode->CurrentValue = $this->Periode->CurrentValue;
					$GLOBALS["tblNilai_grid"]->Periode->setSessionValue($GLOBALS["tblNilai_grid"]->Periode->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("Perwalianlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Thn_Akademik":
					break;
				case "x_Periode":
					break;
				case "x_Nim":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Thn_Akademik":
							break;
						case "x_Nim":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>