<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for QBeasiswa
 */
class QBeasiswa extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Tahun_Akademik;
	public $Periode;
	public $Kode_Fak;
	public $NoSk;
	public $IDBeasiswa;
	public $Nim;
	public $Nama_Mhs;
	public $Kode_jp;
	public $Tlp_Mhs;
	public $_Email;
	public $Status_Akd;
	public $JmlSemester;
	public $BiayaPerSemester;
	public $TSKS;
	public $Ipk;
	public $Status;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'QBeasiswa';
		$this->TableName = 'QBeasiswa';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[QBeasiswa]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Tahun_Akademik
		$this->Tahun_Akademik = new DbField('QBeasiswa', 'QBeasiswa', 'x_Tahun_Akademik', 'Tahun_Akademik', '[Tahun_Akademik]', '[Tahun_Akademik]', 200, 9, -1, FALSE, '[Tahun_Akademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Tahun_Akademik->Nullable = FALSE; // NOT NULL field
		$this->Tahun_Akademik->Required = TRUE; // Required field
		$this->Tahun_Akademik->Sortable = TRUE; // Allow sort
		$this->Tahun_Akademik->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Tahun_Akademik->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Tahun_Akademik->Lookup = new Lookup('Tahun_Akademik', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Tahun_Akademik'] = &$this->Tahun_Akademik;

		// Periode
		$this->Periode = new DbField('QBeasiswa', 'QBeasiswa', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 200, 2, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Periode->Nullable = FALSE; // NOT NULL field
		$this->Periode->Required = TRUE; // Required field
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->Periode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Periode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Periode->Lookup = new Lookup('Periode', 'QBeasiswa', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Periode->OptionCount = 3;
		$this->fields['Periode'] = &$this->Periode;

		// Kode_Fak
		$this->Kode_Fak = new DbField('QBeasiswa', 'QBeasiswa', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->Kode_Fak->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Fak->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Fak->Lookup = new Lookup('Kode_Fak', 'tblFak', FALSE, 'Kode_Fak', ["Nama_Fak","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// NoSk
		$this->NoSk = new DbField('QBeasiswa', 'QBeasiswa', 'x_NoSk', 'NoSk', '[NoSk]', '[NoSk]', 200, 50, -1, FALSE, '[NoSk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NoSk->IsPrimaryKey = TRUE; // Primary key field
		$this->NoSk->Nullable = FALSE; // NOT NULL field
		$this->NoSk->Required = TRUE; // Required field
		$this->NoSk->Sortable = TRUE; // Allow sort
		$this->fields['NoSk'] = &$this->NoSk;

		// IDBeasiswa
		$this->IDBeasiswa = new DbField('QBeasiswa', 'QBeasiswa', 'x_IDBeasiswa', 'IDBeasiswa', '[IDBeasiswa]', 'CAST([IDBeasiswa] AS NVARCHAR)', 3, 4, -1, FALSE, '[IDBeasiswa]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->IDBeasiswa->Sortable = TRUE; // Allow sort
		$this->IDBeasiswa->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->IDBeasiswa->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->IDBeasiswa->Lookup = new Lookup('IDBeasiswa', 'tblBeasiswa_Jenis', FALSE, 'IDBeasiswa', ["NamaBeasiswa","","",""], [], [], [], [], [], [], '', '');
		$this->IDBeasiswa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['IDBeasiswa'] = &$this->IDBeasiswa;

		// Nim
		$this->Nim = new DbField('QBeasiswa', 'QBeasiswa', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 200, 14, -1, FALSE, '[Nim]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nim->IsPrimaryKey = TRUE; // Primary key field
		$this->Nim->IsForeignKey = TRUE; // Foreign key field
		$this->Nim->Nullable = FALSE; // NOT NULL field
		$this->Nim->Required = TRUE; // Required field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->fields['Nim'] = &$this->Nim;

		// Nama_Mhs
		$this->Nama_Mhs = new DbField('QBeasiswa', 'QBeasiswa', 'x_Nama_Mhs', 'Nama_Mhs', '[Nama_Mhs]', '[Nama_Mhs]', 129, 60, -1, FALSE, '[Nama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mhs'] = &$this->Nama_Mhs;

		// Kode_jp
		$this->Kode_jp = new DbField('QBeasiswa', 'QBeasiswa', 'x_Kode_jp', 'Kode_jp', '[Kode_jp]', '[Kode_jp]', 129, 4, -1, FALSE, '[Kode_jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_jp->Sortable = TRUE; // Allow sort
		$this->Kode_jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_jp->Lookup = new Lookup('Kode_jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Jurusan","Program","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_jp'] = &$this->Kode_jp;

		// Tlp_Mhs
		$this->Tlp_Mhs = new DbField('QBeasiswa', 'QBeasiswa', 'x_Tlp_Mhs', 'Tlp_Mhs', '[Tlp_Mhs]', '[Tlp_Mhs]', 129, 15, -1, FALSE, '[Tlp_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tlp_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Tlp_Mhs'] = &$this->Tlp_Mhs;

		// Email
		$this->_Email = new DbField('QBeasiswa', 'QBeasiswa', 'x__Email', 'Email', '[Email]', '[Email]', 129, 50, -1, FALSE, '[Email]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Email->Sortable = TRUE; // Allow sort
		$this->fields['Email'] = &$this->_Email;

		// Status_Akd
		$this->Status_Akd = new DbField('QBeasiswa', 'QBeasiswa', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 200, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// JmlSemester
		$this->JmlSemester = new DbField('QBeasiswa', 'QBeasiswa', 'x_JmlSemester', 'JmlSemester', '[JmlSemester]', 'CAST([JmlSemester] AS NVARCHAR)', 3, 4, -1, FALSE, '[JmlSemester]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JmlSemester->Sortable = TRUE; // Allow sort
		$this->JmlSemester->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['JmlSemester'] = &$this->JmlSemester;

		// BiayaPerSemester
		$this->BiayaPerSemester = new DbField('QBeasiswa', 'QBeasiswa', 'x_BiayaPerSemester', 'BiayaPerSemester', '[BiayaPerSemester]', 'CAST([BiayaPerSemester] AS NVARCHAR)', 131, 8, -1, FALSE, '[BiayaPerSemester]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->BiayaPerSemester->Sortable = TRUE; // Allow sort
		$this->BiayaPerSemester->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['BiayaPerSemester'] = &$this->BiayaPerSemester;

		// TSKS
		$this->TSKS = new DbField('QBeasiswa', 'QBeasiswa', 'x_TSKS', 'TSKS', '[TSKS]', 'CAST([TSKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[TSKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TSKS->Sortable = TRUE; // Allow sort
		$this->TSKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['TSKS'] = &$this->TSKS;

		// Ipk
		$this->Ipk = new DbField('QBeasiswa', 'QBeasiswa', 'x_Ipk', 'Ipk', '[Ipk]', 'CAST([Ipk] AS NVARCHAR)', 4, 4, -1, FALSE, '[Ipk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ipk->Sortable = TRUE; // Allow sort
		$this->Ipk->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Ipk'] = &$this->Ipk;

		// Status
		$this->Status = new DbField('QBeasiswa', 'QBeasiswa', 'x_Status', 'Status', '[Status]', 'CAST([Status] AS NVARCHAR)', 3, 4, -1, FALSE, '[Status]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status->Sortable = TRUE; // Allow sort
		$this->Status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status->Lookup = new Lookup('Status', 'QBeasiswa', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Status->OptionCount = 2;
		$this->Status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Status'] = &$this->Status;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "Wali_IPS") {
			$detailUrl = $GLOBALS["Wali_IPS"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "QBeasiswalist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[QBeasiswa]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('NoSk', $rs))
				AddFilter($where, QuotedName('NoSk', $this->Dbid) . '=' . QuotedValue($rs['NoSk'], $this->NoSk->DataType, $this->Dbid));
			if (array_key_exists('Nim', $rs))
				AddFilter($where, QuotedName('Nim', $this->Dbid) . '=' . QuotedValue($rs['Nim'], $this->Nim->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Tahun_Akademik->DbValue = $row['Tahun_Akademik'];
		$this->Periode->DbValue = $row['Periode'];
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->NoSk->DbValue = $row['NoSk'];
		$this->IDBeasiswa->DbValue = $row['IDBeasiswa'];
		$this->Nim->DbValue = $row['Nim'];
		$this->Nama_Mhs->DbValue = $row['Nama_Mhs'];
		$this->Kode_jp->DbValue = $row['Kode_jp'];
		$this->Tlp_Mhs->DbValue = $row['Tlp_Mhs'];
		$this->_Email->DbValue = $row['Email'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->JmlSemester->DbValue = $row['JmlSemester'];
		$this->BiayaPerSemester->DbValue = $row['BiayaPerSemester'];
		$this->TSKS->DbValue = $row['TSKS'];
		$this->Ipk->DbValue = $row['Ipk'];
		$this->Status->DbValue = $row['Status'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[NoSk] = '@NoSk@' AND [Nim] = '@Nim@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('NoSk', $row) ? $row['NoSk'] : NULL;
		else
			$val = $this->NoSk->OldValue !== NULL ? $this->NoSk->OldValue : $this->NoSk->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@NoSk@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Nim', $row) ? $row['Nim'] : NULL;
		else
			$val = $this->Nim->OldValue !== NULL ? $this->Nim->OldValue : $this->Nim->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Nim@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "QBeasiswalist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "QBeasiswaview.php")
			return $Language->phrase("View");
		elseif ($pageName == "QBeasiswaedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "QBeasiswaadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "QBeasiswalist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("QBeasiswaview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("QBeasiswaview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "QBeasiswaadd.php?" . $this->getUrlParm($parm);
		else
			$url = "QBeasiswaadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("QBeasiswaedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("QBeasiswaedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("QBeasiswaadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("QBeasiswaadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("QBeasiswadelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "NoSk:" . JsonEncode($this->NoSk->CurrentValue, "string");
		$json .= ",Nim:" . JsonEncode($this->Nim->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->NoSk->CurrentValue != NULL) {
			$url .= "NoSk=" . urlencode($this->NoSk->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Nim->CurrentValue != NULL) {
			$url .= "&Nim=" . urlencode($this->Nim->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("NoSk") !== NULL)
				$arKey[] = Param("NoSk");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Nim") !== NULL)
				$arKey[] = Param("Nim");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 2)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->NoSk->CurrentValue = $key[0];
			else
				$this->NoSk->OldValue = $key[0];
			if ($setCurrent)
				$this->Nim->CurrentValue = $key[1];
			else
				$this->Nim->OldValue = $key[1];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Tahun_Akademik->setDbValue($rs->fields('Tahun_Akademik'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->NoSk->setDbValue($rs->fields('NoSk'));
		$this->IDBeasiswa->setDbValue($rs->fields('IDBeasiswa'));
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->Nama_Mhs->setDbValue($rs->fields('Nama_Mhs'));
		$this->Kode_jp->setDbValue($rs->fields('Kode_jp'));
		$this->Tlp_Mhs->setDbValue($rs->fields('Tlp_Mhs'));
		$this->_Email->setDbValue($rs->fields('Email'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->JmlSemester->setDbValue($rs->fields('JmlSemester'));
		$this->BiayaPerSemester->setDbValue($rs->fields('BiayaPerSemester'));
		$this->TSKS->setDbValue($rs->fields('TSKS'));
		$this->Ipk->setDbValue($rs->fields('Ipk'));
		$this->Status->setDbValue($rs->fields('Status'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Tahun_Akademik
		// Periode
		// Kode_Fak
		// NoSk
		// IDBeasiswa
		// Nim
		// Nama_Mhs
		// Kode_jp
		// Tlp_Mhs
		// Email
		// Status_Akd
		// JmlSemester
		// BiayaPerSemester
		// TSKS
		// Ipk
		// Status
		// Tahun_Akademik

		$curVal = strval($this->Tahun_Akademik->CurrentValue);
		if ($curVal != "") {
			$this->Tahun_Akademik->ViewValue = $this->Tahun_Akademik->lookupCacheOption($curVal);
			if ($this->Tahun_Akademik->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Tahun_Akademik->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Tahun_Akademik->ViewValue = $this->Tahun_Akademik->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Tahun_Akademik->ViewValue = $this->Tahun_Akademik->CurrentValue;
				}
			}
		} else {
			$this->Tahun_Akademik->ViewValue = NULL;
		}
		$this->Tahun_Akademik->ViewCustomAttributes = "";

		// Periode
		if (strval($this->Periode->CurrentValue) != "") {
			$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
		} else {
			$this->Periode->ViewValue = NULL;
		}
		$this->Periode->ViewCustomAttributes = "";

		// Kode_Fak
		$curVal = strval($this->Kode_Fak->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
				}
			}
		} else {
			$this->Kode_Fak->ViewValue = NULL;
		}
		$this->Kode_Fak->ViewCustomAttributes = "";

		// NoSk
		$this->NoSk->ViewValue = $this->NoSk->CurrentValue;
		$this->NoSk->ViewCustomAttributes = "";

		// IDBeasiswa
		$curVal = strval($this->IDBeasiswa->CurrentValue);
		if ($curVal != "") {
			$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->lookupCacheOption($curVal);
			if ($this->IDBeasiswa->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[IDBeasiswa]" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->IDBeasiswa->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->CurrentValue;
				}
			}
		} else {
			$this->IDBeasiswa->ViewValue = NULL;
		}
		$this->IDBeasiswa->ViewCustomAttributes = "";

		// Nim
		$this->Nim->ViewValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->ViewCustomAttributes = "";

		// Kode_jp
		$curVal = strval($this->Kode_jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
			if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_jp->ViewValue = NULL;
		}
		$this->Kode_jp->ViewCustomAttributes = "";

		// Tlp_Mhs
		$this->Tlp_Mhs->ViewValue = $this->Tlp_Mhs->CurrentValue;
		$this->Tlp_Mhs->ViewCustomAttributes = "";

		// Email
		$this->_Email->ViewValue = $this->_Email->CurrentValue;
		$this->_Email->ViewCustomAttributes = "";

		// Status_Akd
		$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
		$this->Status_Akd->ViewCustomAttributes = "";

		// JmlSemester
		$this->JmlSemester->ViewValue = $this->JmlSemester->CurrentValue;
		$this->JmlSemester->ViewValue = FormatNumber($this->JmlSemester->ViewValue, 0, -2, -2, -2);
		$this->JmlSemester->ViewCustomAttributes = "";

		// BiayaPerSemester
		$this->BiayaPerSemester->ViewValue = $this->BiayaPerSemester->CurrentValue;
		$this->BiayaPerSemester->ViewValue = FormatNumber($this->BiayaPerSemester->ViewValue, 0, -2, -2, -2);
		$this->BiayaPerSemester->ViewCustomAttributes = "";

		// TSKS
		$this->TSKS->ViewValue = $this->TSKS->CurrentValue;
		$this->TSKS->ViewValue = FormatNumber($this->TSKS->ViewValue, 0, -2, -2, -2);
		$this->TSKS->ViewCustomAttributes = "";

		// Ipk
		$this->Ipk->ViewValue = $this->Ipk->CurrentValue;
		$this->Ipk->ViewValue = FormatNumber($this->Ipk->ViewValue, 2, -2, -2, -2);
		$this->Ipk->ViewCustomAttributes = "";

		// Status
		if (strval($this->Status->CurrentValue) != "") {
			$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
		} else {
			$this->Status->ViewValue = NULL;
		}
		$this->Status->ViewCustomAttributes = "";

		// Tahun_Akademik
		$this->Tahun_Akademik->LinkCustomAttributes = "";
		$this->Tahun_Akademik->HrefValue = "";
		$this->Tahun_Akademik->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// NoSk
		$this->NoSk->LinkCustomAttributes = "";
		$this->NoSk->HrefValue = "";
		$this->NoSk->TooltipValue = "";

		// IDBeasiswa
		$this->IDBeasiswa->LinkCustomAttributes = "";
		$this->IDBeasiswa->HrefValue = "";
		$this->IDBeasiswa->TooltipValue = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// Nama_Mhs
		$this->Nama_Mhs->LinkCustomAttributes = "";
		$this->Nama_Mhs->HrefValue = "";
		$this->Nama_Mhs->TooltipValue = "";

		// Kode_jp
		$this->Kode_jp->LinkCustomAttributes = "";
		$this->Kode_jp->HrefValue = "";
		$this->Kode_jp->TooltipValue = "";

		// Tlp_Mhs
		$this->Tlp_Mhs->LinkCustomAttributes = "";
		if (!EmptyValue($this->Tlp_Mhs->CurrentValue)) {
			$this->Tlp_Mhs->HrefValue = "https://wa.me/62" . $this->Tlp_Mhs->CurrentValue; // Add prefix/suffix
			$this->Tlp_Mhs->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport())
				$this->Tlp_Mhs->HrefValue = FullUrl($this->Tlp_Mhs->HrefValue, "href");
		} else {
			$this->Tlp_Mhs->HrefValue = "";
		}
		$this->Tlp_Mhs->TooltipValue = "";

		// Email
		$this->_Email->LinkCustomAttributes = "";
		if (!EmptyValue($this->_Email->CurrentValue)) {
			$this->_Email->HrefValue = "mailto:" . $this->_Email->CurrentValue; // Add prefix/suffix
			$this->_Email->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport())
				$this->_Email->HrefValue = FullUrl($this->_Email->HrefValue, "href");
		} else {
			$this->_Email->HrefValue = "";
		}
		$this->_Email->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// JmlSemester
		$this->JmlSemester->LinkCustomAttributes = "";
		$this->JmlSemester->HrefValue = "";
		$this->JmlSemester->TooltipValue = "";

		// BiayaPerSemester
		$this->BiayaPerSemester->LinkCustomAttributes = "";
		$this->BiayaPerSemester->HrefValue = "";
		$this->BiayaPerSemester->TooltipValue = "";

		// TSKS
		$this->TSKS->LinkCustomAttributes = "";
		$this->TSKS->HrefValue = "";
		$this->TSKS->TooltipValue = "";

		// Ipk
		$this->Ipk->LinkCustomAttributes = "";
		$this->Ipk->HrefValue = "";
		$this->Ipk->TooltipValue = "";

		// Status
		$this->Status->LinkCustomAttributes = "";
		$this->Status->HrefValue = "";
		$this->Status->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Tahun_Akademik
		$this->Tahun_Akademik->EditAttrs["class"] = "form-control";
		$this->Tahun_Akademik->EditCustomAttributes = "";

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		$this->Periode->EditValue = $this->Periode->options(TRUE);

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";

		// NoSk
		$this->NoSk->EditAttrs["class"] = "form-control";
		$this->NoSk->EditCustomAttributes = "";
		if (!$this->NoSk->Raw)
			$this->NoSk->CurrentValue = HtmlDecode($this->NoSk->CurrentValue);
		$this->NoSk->EditValue = $this->NoSk->CurrentValue;
		$this->NoSk->PlaceHolder = RemoveHtml($this->NoSk->caption());

		// IDBeasiswa
		$this->IDBeasiswa->EditAttrs["class"] = "form-control";
		$this->IDBeasiswa->EditCustomAttributes = "";

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";
		if (!$this->Nim->Raw)
			$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
		$this->Nim->EditValue = $this->Nim->CurrentValue;
		$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

		// Nama_Mhs
		$this->Nama_Mhs->EditAttrs["class"] = "form-control";
		$this->Nama_Mhs->EditCustomAttributes = "";
		if (!$this->Nama_Mhs->Raw)
			$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
		$this->Nama_Mhs->EditValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

		// Kode_jp
		$this->Kode_jp->EditAttrs["class"] = "form-control";
		$this->Kode_jp->EditCustomAttributes = "";

		// Tlp_Mhs
		$this->Tlp_Mhs->EditAttrs["class"] = "form-control";
		$this->Tlp_Mhs->EditCustomAttributes = "";
		if (!$this->Tlp_Mhs->Raw)
			$this->Tlp_Mhs->CurrentValue = HtmlDecode($this->Tlp_Mhs->CurrentValue);
		$this->Tlp_Mhs->EditValue = $this->Tlp_Mhs->CurrentValue;
		$this->Tlp_Mhs->PlaceHolder = RemoveHtml($this->Tlp_Mhs->caption());

		// Email
		$this->_Email->EditAttrs["class"] = "form-control";
		$this->_Email->EditCustomAttributes = "";
		if (!$this->_Email->Raw)
			$this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
		$this->_Email->EditValue = $this->_Email->CurrentValue;
		$this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";
		if (!$this->Status_Akd->Raw)
			$this->Status_Akd->CurrentValue = HtmlDecode($this->Status_Akd->CurrentValue);
		$this->Status_Akd->EditValue = $this->Status_Akd->CurrentValue;
		$this->Status_Akd->PlaceHolder = RemoveHtml($this->Status_Akd->caption());

		// JmlSemester
		$this->JmlSemester->EditAttrs["class"] = "form-control";
		$this->JmlSemester->EditCustomAttributes = "";
		$this->JmlSemester->EditValue = $this->JmlSemester->CurrentValue;
		$this->JmlSemester->PlaceHolder = RemoveHtml($this->JmlSemester->caption());

		// BiayaPerSemester
		$this->BiayaPerSemester->EditAttrs["class"] = "form-control";
		$this->BiayaPerSemester->EditCustomAttributes = "";
		$this->BiayaPerSemester->EditValue = $this->BiayaPerSemester->CurrentValue;
		$this->BiayaPerSemester->PlaceHolder = RemoveHtml($this->BiayaPerSemester->caption());
		if (strval($this->BiayaPerSemester->EditValue) != "" && is_numeric($this->BiayaPerSemester->EditValue))
			$this->BiayaPerSemester->EditValue = FormatNumber($this->BiayaPerSemester->EditValue, -2, -2, -2, -2);
		

		// TSKS
		$this->TSKS->EditAttrs["class"] = "form-control";
		$this->TSKS->EditCustomAttributes = "";
		$this->TSKS->EditValue = $this->TSKS->CurrentValue;
		$this->TSKS->PlaceHolder = RemoveHtml($this->TSKS->caption());

		// Ipk
		$this->Ipk->EditAttrs["class"] = "form-control";
		$this->Ipk->EditCustomAttributes = "";
		$this->Ipk->EditValue = $this->Ipk->CurrentValue;
		$this->Ipk->PlaceHolder = RemoveHtml($this->Ipk->caption());
		if (strval($this->Ipk->EditValue) != "" && is_numeric($this->Ipk->EditValue))
			$this->Ipk->EditValue = FormatNumber($this->Ipk->EditValue, -2, -2, -2, -2);
		

		// Status
		$this->Status->EditAttrs["class"] = "form-control";
		$this->Status->EditCustomAttributes = "";
		$this->Status->EditValue = $this->Status->options(TRUE);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Tahun_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->NoSk);
					$doc->exportCaption($this->IDBeasiswa);
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Tlp_Mhs);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->JmlSemester);
					$doc->exportCaption($this->BiayaPerSemester);
					$doc->exportCaption($this->TSKS);
					$doc->exportCaption($this->Ipk);
					$doc->exportCaption($this->Status);
				} else {
					$doc->exportCaption($this->Tahun_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->NoSk);
					$doc->exportCaption($this->IDBeasiswa);
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Tlp_Mhs);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->JmlSemester);
					$doc->exportCaption($this->BiayaPerSemester);
					$doc->exportCaption($this->TSKS);
					$doc->exportCaption($this->Ipk);
					$doc->exportCaption($this->Status);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Tahun_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->NoSk);
						$doc->exportField($this->IDBeasiswa);
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Tlp_Mhs);
						$doc->exportField($this->_Email);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->JmlSemester);
						$doc->exportField($this->BiayaPerSemester);
						$doc->exportField($this->TSKS);
						$doc->exportField($this->Ipk);
						$doc->exportField($this->Status);
					} else {
						$doc->exportField($this->Tahun_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->NoSk);
						$doc->exportField($this->IDBeasiswa);
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Tlp_Mhs);
						$doc->exportField($this->_Email);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->JmlSemester);
						$doc->exportField($this->BiayaPerSemester);
						$doc->exportField($this->TSKS);
						$doc->exportField($this->Ipk);
						$doc->exportField($this->Status);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>