<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for QUjian_Soal
 */
class QUjian_Soal extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Thn_Akademik;
	public $Periode;
	public $Kelas_Akd;
	public $NIDN;
	public $Nama;
	public $Kode_Mk;
	public $Nama_Mk_Ind;
	public $SKS;
	public $Kelas;
	public $Tanggal;
	public $Hari;
	public $JM;
	public $Ruang;
	public $UTS_UAS;
	public $LokasiFile;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'QUjian_Soal';
		$this->TableName = 'QUjian_Soal';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[QUjian_Soal]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Thn_Akademik
		$this->Thn_Akademik = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Thn_Akademik', 'Thn_Akademik', '[Thn_Akademik]', '[Thn_Akademik]', 129, 9, -1, FALSE, '[Thn_Akademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Thn_Akademik->Nullable = FALSE; // NOT NULL field
		$this->Thn_Akademik->Required = TRUE; // Required field
		$this->Thn_Akademik->Sortable = TRUE; // Allow sort
		$this->Thn_Akademik->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Thn_Akademik->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Thn_Akademik->Lookup = new Lookup('Thn_Akademik', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Thn_Akademik'] = &$this->Thn_Akademik;

		// Periode
		$this->Periode = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 129, 3, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Periode->Nullable = FALSE; // NOT NULL field
		$this->Periode->Required = TRUE; // Required field
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->Periode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Periode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Periode->Lookup = new Lookup('Periode', 'QUjian_Soal', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Periode->OptionCount = 3;
		$this->fields['Periode'] = &$this->Periode;

		// Kelas_Akd
		$this->Kelas_Akd = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Kelas_Akd', 'Kelas_Akd', '[Kelas_Akd]', '[Kelas_Akd]', 129, 15, -1, FALSE, '[Kelas_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kelas_Akd->Nullable = FALSE; // NOT NULL field
		$this->Kelas_Akd->Required = TRUE; // Required field
		$this->Kelas_Akd->Sortable = TRUE; // Allow sort
		$this->Kelas_Akd->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kelas_Akd->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kelas_Akd->Lookup = new Lookup('Kelas_Akd', 'tblkelas', FALSE, 'Kelas', ["Kelas","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kelas_Akd'] = &$this->Kelas_Akd;

		// NIDN
		$this->NIDN = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_NIDN', 'NIDN', '[NIDN]', '[NIDN]', 200, 14, -1, FALSE, '[NIDN]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NIDN->Nullable = FALSE; // NOT NULL field
		$this->NIDN->Required = TRUE; // Required field
		$this->NIDN->Sortable = TRUE; // Allow sort
		$this->fields['NIDN'] = &$this->NIDN;

		// Nama
		$this->Nama = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Nama', 'Nama', '[Nama]', '[Nama]', 200, 40, -1, FALSE, '[Nama]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama->Sortable = TRUE; // Allow sort
		$this->fields['Nama'] = &$this->Nama;

		// Kode_Mk
		$this->Kode_Mk = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Kode_Mk', 'Kode_Mk', '[Kode_Mk]', '[Kode_Mk]', 129, 14, -1, FALSE, '[Kode_Mk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Mk->Nullable = FALSE; // NOT NULL field
		$this->Kode_Mk->Required = TRUE; // Required field
		$this->Kode_Mk->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Mk'] = &$this->Kode_Mk;

		// Nama_Mk_Ind
		$this->Nama_Mk_Ind = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Nama_Mk_Ind', 'Nama_Mk_Ind', '[Nama_Mk_Ind]', '[Nama_Mk_Ind]', 129, 40, -1, FALSE, '[Nama_Mk_Ind]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mk_Ind->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mk_Ind'] = &$this->Nama_Mk_Ind;

		// SKS
		$this->SKS = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_SKS', 'SKS', '[SKS]', 'CAST([SKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[SKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SKS->Sortable = TRUE; // Allow sort
		$this->SKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['SKS'] = &$this->SKS;

		// Kelas
		$this->Kelas = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Kelas', 'Kelas', '[Kelas]', '[Kelas]', 129, 10, -1, FALSE, '[Kelas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kelas->Nullable = FALSE; // NOT NULL field
		$this->Kelas->Required = TRUE; // Required field
		$this->Kelas->Sortable = TRUE; // Allow sort
		$this->fields['Kelas'] = &$this->Kelas;

		// Tanggal
		$this->Tanggal = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Tanggal', 'Tanggal', '[Tanggal]', CastDateFieldForLike("[Tanggal]", 7, "DB"), 135, 8, 7, FALSE, '[Tanggal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tanggal->Sortable = TRUE; // Allow sort
		$this->Tanggal->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['Tanggal'] = &$this->Tanggal;

		// Hari
		$this->Hari = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Hari', 'Hari', '[Hari]', '[Hari]', 200, 10, -1, FALSE, '[Hari]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Hari->Sortable = TRUE; // Allow sort
		$this->fields['Hari'] = &$this->Hari;

		// JM
		$this->JM = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_JM', 'JM', '[JM]', CastDateFieldForLike("[JM]", 4, "DB"), 135, 8, 4, FALSE, '[JM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JM->Sortable = TRUE; // Allow sort
		$this->JM->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['JM'] = &$this->JM;

		// Ruang
		$this->Ruang = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_Ruang', 'Ruang', '[Ruang]', '[Ruang]', 129, 20, -1, FALSE, '[Ruang]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ruang->Sortable = TRUE; // Allow sort
		$this->fields['Ruang'] = &$this->Ruang;

		// UTS_UAS
		$this->UTS_UAS = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_UTS_UAS', 'UTS_UAS', '[UTS_UAS]', '[UTS_UAS]', 200, 10, -1, FALSE, '[UTS_UAS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UTS_UAS->Sortable = TRUE; // Allow sort
		$this->fields['UTS_UAS'] = &$this->UTS_UAS;

		// LokasiFile
		$this->LokasiFile = new DbField('QUjian_Soal', 'QUjian_Soal', 'x_LokasiFile', 'LokasiFile', '[LokasiFile]', '[LokasiFile]', 200, 150, -1, TRUE, '[LokasiFile]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->LokasiFile->Sortable = TRUE; // Allow sort
		$this->fields['LokasiFile'] = &$this->LokasiFile;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[QUjian_Soal]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Thn_Akademik->DbValue = $row['Thn_Akademik'];
		$this->Periode->DbValue = $row['Periode'];
		$this->Kelas_Akd->DbValue = $row['Kelas_Akd'];
		$this->NIDN->DbValue = $row['NIDN'];
		$this->Nama->DbValue = $row['Nama'];
		$this->Kode_Mk->DbValue = $row['Kode_Mk'];
		$this->Nama_Mk_Ind->DbValue = $row['Nama_Mk_Ind'];
		$this->SKS->DbValue = $row['SKS'];
		$this->Kelas->DbValue = $row['Kelas'];
		$this->Tanggal->DbValue = $row['Tanggal'];
		$this->Hari->DbValue = $row['Hari'];
		$this->JM->DbValue = $row['JM'];
		$this->Ruang->DbValue = $row['Ruang'];
		$this->UTS_UAS->DbValue = $row['UTS_UAS'];
		$this->LokasiFile->Upload->DbValue = $row['LokasiFile'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$oldFiles = EmptyValue($row['LokasiFile']) ? [] : [$row['LokasiFile']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->LokasiFile->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->LokasiFile->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "QUjian_Soallist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "QUjian_Soalview.php")
			return $Language->phrase("View");
		elseif ($pageName == "QUjian_Soaledit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "QUjian_Soaladd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "QUjian_Soallist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("QUjian_Soalview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("QUjian_Soalview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "QUjian_Soaladd.php?" . $this->getUrlParm($parm);
		else
			$url = "QUjian_Soaladd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("QUjian_Soaledit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("QUjian_Soaladd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("QUjian_Soaldelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Thn_Akademik->setDbValue($rs->fields('Thn_Akademik'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->Kelas_Akd->setDbValue($rs->fields('Kelas_Akd'));
		$this->NIDN->setDbValue($rs->fields('NIDN'));
		$this->Nama->setDbValue($rs->fields('Nama'));
		$this->Kode_Mk->setDbValue($rs->fields('Kode_Mk'));
		$this->Nama_Mk_Ind->setDbValue($rs->fields('Nama_Mk_Ind'));
		$this->SKS->setDbValue($rs->fields('SKS'));
		$this->Kelas->setDbValue($rs->fields('Kelas'));
		$this->Tanggal->setDbValue($rs->fields('Tanggal'));
		$this->Hari->setDbValue($rs->fields('Hari'));
		$this->JM->setDbValue($rs->fields('JM'));
		$this->Ruang->setDbValue($rs->fields('Ruang'));
		$this->UTS_UAS->setDbValue($rs->fields('UTS_UAS'));
		$this->LokasiFile->Upload->DbValue = $rs->fields('LokasiFile');
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Thn_Akademik
		// Periode
		// Kelas_Akd
		// NIDN
		// Nama
		// Kode_Mk
		// Nama_Mk_Ind
		// SKS
		// Kelas
		// Tanggal
		// Hari
		// JM
		// Ruang
		// UTS_UAS
		// LokasiFile
		// Thn_Akademik

		$curVal = strval($this->Thn_Akademik->CurrentValue);
		if ($curVal != "") {
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->lookupCacheOption($curVal);
			if ($this->Thn_Akademik->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Thn_Akademik->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
				}
			}
		} else {
			$this->Thn_Akademik->ViewValue = NULL;
		}
		$this->Thn_Akademik->ViewCustomAttributes = "";

		// Periode
		if (strval($this->Periode->CurrentValue) != "") {
			$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
		} else {
			$this->Periode->ViewValue = NULL;
		}
		$this->Periode->ViewCustomAttributes = "";

		// Kelas_Akd
		$curVal = strval($this->Kelas_Akd->CurrentValue);
		if ($curVal != "") {
			$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->lookupCacheOption($curVal);
			if ($this->Kelas_Akd->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kelas_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->CurrentValue;
				}
			}
		} else {
			$this->Kelas_Akd->ViewValue = NULL;
		}
		$this->Kelas_Akd->ViewCustomAttributes = "";

		// NIDN
		$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
		$this->NIDN->ViewCustomAttributes = "";

		// Nama
		$this->Nama->ViewValue = $this->Nama->CurrentValue;
		$this->Nama->ViewCustomAttributes = "";

		// Kode_Mk
		$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->ViewCustomAttributes = "";

		// Nama_Mk_Ind
		$this->Nama_Mk_Ind->ViewValue = $this->Nama_Mk_Ind->CurrentValue;
		$this->Nama_Mk_Ind->ViewCustomAttributes = "";

		// SKS
		$this->SKS->ViewValue = $this->SKS->CurrentValue;
		$this->SKS->ViewValue = FormatNumber($this->SKS->ViewValue, 0, -2, -2, -2);
		$this->SKS->ViewCustomAttributes = "";

		// Kelas
		$this->Kelas->ViewValue = $this->Kelas->CurrentValue;
		$this->Kelas->ViewCustomAttributes = "";

		// Tanggal
		$this->Tanggal->ViewValue = $this->Tanggal->CurrentValue;
		$this->Tanggal->ViewValue = FormatDateTime($this->Tanggal->ViewValue, 7);
		$this->Tanggal->ViewCustomAttributes = "";

		// Hari
		$this->Hari->ViewValue = $this->Hari->CurrentValue;
		$this->Hari->ViewCustomAttributes = "";

		// JM
		$this->JM->ViewValue = $this->JM->CurrentValue;
		$this->JM->ViewValue = FormatDateTime($this->JM->ViewValue, 4);
		$this->JM->ViewCustomAttributes = "";

		// Ruang
		$this->Ruang->ViewValue = $this->Ruang->CurrentValue;
		$this->Ruang->ViewCustomAttributes = "";

		// UTS_UAS
		$this->UTS_UAS->ViewValue = $this->UTS_UAS->CurrentValue;
		$this->UTS_UAS->ViewCustomAttributes = "";

		// LokasiFile
		if (!EmptyValue($this->LokasiFile->Upload->DbValue)) {
			$this->LokasiFile->ViewValue = $this->LokasiFile->Upload->DbValue;
		} else {
			$this->LokasiFile->ViewValue = "";
		}
		$this->LokasiFile->ViewCustomAttributes = "";

		// Thn_Akademik
		$this->Thn_Akademik->LinkCustomAttributes = "";
		$this->Thn_Akademik->HrefValue = "";
		$this->Thn_Akademik->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// Kelas_Akd
		$this->Kelas_Akd->LinkCustomAttributes = "";
		$this->Kelas_Akd->HrefValue = "";
		$this->Kelas_Akd->TooltipValue = "";

		// NIDN
		$this->NIDN->LinkCustomAttributes = "";
		$this->NIDN->HrefValue = "";
		$this->NIDN->TooltipValue = "";

		// Nama
		$this->Nama->LinkCustomAttributes = "";
		$this->Nama->HrefValue = "";
		$this->Nama->TooltipValue = "";

		// Kode_Mk
		$this->Kode_Mk->LinkCustomAttributes = "";
		$this->Kode_Mk->HrefValue = "";
		$this->Kode_Mk->TooltipValue = "";

		// Nama_Mk_Ind
		$this->Nama_Mk_Ind->LinkCustomAttributes = "";
		$this->Nama_Mk_Ind->HrefValue = "";
		$this->Nama_Mk_Ind->TooltipValue = "";

		// SKS
		$this->SKS->LinkCustomAttributes = "";
		$this->SKS->HrefValue = "";
		$this->SKS->TooltipValue = "";

		// Kelas
		$this->Kelas->LinkCustomAttributes = "";
		$this->Kelas->HrefValue = "";
		$this->Kelas->TooltipValue = "";

		// Tanggal
		$this->Tanggal->LinkCustomAttributes = "";
		$this->Tanggal->HrefValue = "";
		$this->Tanggal->TooltipValue = "";

		// Hari
		$this->Hari->LinkCustomAttributes = "";
		$this->Hari->HrefValue = "";
		$this->Hari->TooltipValue = "";

		// JM
		$this->JM->LinkCustomAttributes = "";
		$this->JM->HrefValue = "";
		$this->JM->TooltipValue = "";

		// Ruang
		$this->Ruang->LinkCustomAttributes = "";
		$this->Ruang->HrefValue = "";
		$this->Ruang->TooltipValue = "";

		// UTS_UAS
		$this->UTS_UAS->LinkCustomAttributes = "";
		$this->UTS_UAS->HrefValue = "";
		$this->UTS_UAS->TooltipValue = "";

		// LokasiFile
		$this->LokasiFile->LinkCustomAttributes = "";
		if (!EmptyValue($this->LokasiFile->Upload->DbValue)) {
			$this->LokasiFile->HrefValue = "https://dosen.imandiri.id" . GetFileUploadUrl($this->LokasiFile, $this->LokasiFile->htmlDecode($this->LokasiFile->Upload->DbValue)); // Add prefix/suffix
			$this->LokasiFile->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->LokasiFile->HrefValue = FullUrl($this->LokasiFile->HrefValue, "href");
		} else {
			$this->LokasiFile->HrefValue = "";
		}
		$this->LokasiFile->ExportHrefValue = $this->LokasiFile->UploadPath . $this->LokasiFile->Upload->DbValue;
		$this->LokasiFile->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Thn_Akademik
		$this->Thn_Akademik->EditAttrs["class"] = "form-control";
		$this->Thn_Akademik->EditCustomAttributes = "";

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		$this->Periode->EditValue = $this->Periode->options(TRUE);

		// Kelas_Akd
		$this->Kelas_Akd->EditAttrs["class"] = "form-control";
		$this->Kelas_Akd->EditCustomAttributes = "";

		// NIDN
		$this->NIDN->EditAttrs["class"] = "form-control";
		$this->NIDN->EditCustomAttributes = "";
		if (!$this->NIDN->Raw)
			$this->NIDN->CurrentValue = HtmlDecode($this->NIDN->CurrentValue);
		$this->NIDN->EditValue = $this->NIDN->CurrentValue;
		$this->NIDN->PlaceHolder = RemoveHtml($this->NIDN->caption());

		// Nama
		$this->Nama->EditAttrs["class"] = "form-control";
		$this->Nama->EditCustomAttributes = "";
		if (!$this->Nama->Raw)
			$this->Nama->CurrentValue = HtmlDecode($this->Nama->CurrentValue);
		$this->Nama->EditValue = $this->Nama->CurrentValue;
		$this->Nama->PlaceHolder = RemoveHtml($this->Nama->caption());

		// Kode_Mk
		$this->Kode_Mk->EditAttrs["class"] = "form-control";
		$this->Kode_Mk->EditCustomAttributes = "";
		if (!$this->Kode_Mk->Raw)
			$this->Kode_Mk->CurrentValue = HtmlDecode($this->Kode_Mk->CurrentValue);
		$this->Kode_Mk->EditValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->PlaceHolder = RemoveHtml($this->Kode_Mk->caption());

		// Nama_Mk_Ind
		$this->Nama_Mk_Ind->EditAttrs["class"] = "form-control";
		$this->Nama_Mk_Ind->EditCustomAttributes = "";
		if (!$this->Nama_Mk_Ind->Raw)
			$this->Nama_Mk_Ind->CurrentValue = HtmlDecode($this->Nama_Mk_Ind->CurrentValue);
		$this->Nama_Mk_Ind->EditValue = $this->Nama_Mk_Ind->CurrentValue;
		$this->Nama_Mk_Ind->PlaceHolder = RemoveHtml($this->Nama_Mk_Ind->caption());

		// SKS
		$this->SKS->EditAttrs["class"] = "form-control";
		$this->SKS->EditCustomAttributes = "";
		$this->SKS->EditValue = $this->SKS->CurrentValue;
		$this->SKS->PlaceHolder = RemoveHtml($this->SKS->caption());

		// Kelas
		$this->Kelas->EditAttrs["class"] = "form-control";
		$this->Kelas->EditCustomAttributes = "";
		if (!$this->Kelas->Raw)
			$this->Kelas->CurrentValue = HtmlDecode($this->Kelas->CurrentValue);
		$this->Kelas->EditValue = $this->Kelas->CurrentValue;
		$this->Kelas->PlaceHolder = RemoveHtml($this->Kelas->caption());

		// Tanggal
		$this->Tanggal->EditAttrs["class"] = "form-control";
		$this->Tanggal->EditCustomAttributes = "";
		$this->Tanggal->EditValue = FormatDateTime($this->Tanggal->CurrentValue, 7);
		$this->Tanggal->PlaceHolder = RemoveHtml($this->Tanggal->caption());

		// Hari
		$this->Hari->EditAttrs["class"] = "form-control";
		$this->Hari->EditCustomAttributes = "";
		if (!$this->Hari->Raw)
			$this->Hari->CurrentValue = HtmlDecode($this->Hari->CurrentValue);
		$this->Hari->EditValue = $this->Hari->CurrentValue;
		$this->Hari->PlaceHolder = RemoveHtml($this->Hari->caption());

		// JM
		$this->JM->EditAttrs["class"] = "form-control";
		$this->JM->EditCustomAttributes = "";
		$this->JM->EditValue = FormatDateTime($this->JM->CurrentValue, 4);
		$this->JM->PlaceHolder = RemoveHtml($this->JM->caption());

		// Ruang
		$this->Ruang->EditAttrs["class"] = "form-control";
		$this->Ruang->EditCustomAttributes = "";
		if (!$this->Ruang->Raw)
			$this->Ruang->CurrentValue = HtmlDecode($this->Ruang->CurrentValue);
		$this->Ruang->EditValue = $this->Ruang->CurrentValue;
		$this->Ruang->PlaceHolder = RemoveHtml($this->Ruang->caption());

		// UTS_UAS
		$this->UTS_UAS->EditAttrs["class"] = "form-control";
		$this->UTS_UAS->EditCustomAttributes = "";
		if (!$this->UTS_UAS->Raw)
			$this->UTS_UAS->CurrentValue = HtmlDecode($this->UTS_UAS->CurrentValue);
		$this->UTS_UAS->EditValue = $this->UTS_UAS->CurrentValue;
		$this->UTS_UAS->PlaceHolder = RemoveHtml($this->UTS_UAS->caption());

		// LokasiFile
		$this->LokasiFile->EditAttrs["class"] = "form-control";
		$this->LokasiFile->EditCustomAttributes = "";
		if (!EmptyValue($this->LokasiFile->Upload->DbValue)) {
			$this->LokasiFile->EditValue = $this->LokasiFile->Upload->DbValue;
		} else {
			$this->LokasiFile->EditValue = "";
		}
		if (!EmptyValue($this->LokasiFile->CurrentValue))
				$this->LokasiFile->Upload->FileName = $this->LokasiFile->CurrentValue;

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kelas_Akd);
					$doc->exportCaption($this->NIDN);
					$doc->exportCaption($this->Nama);
					$doc->exportCaption($this->Kode_Mk);
					$doc->exportCaption($this->Nama_Mk_Ind);
					$doc->exportCaption($this->SKS);
					$doc->exportCaption($this->Kelas);
					$doc->exportCaption($this->Tanggal);
					$doc->exportCaption($this->Hari);
					$doc->exportCaption($this->JM);
					$doc->exportCaption($this->Ruang);
					$doc->exportCaption($this->UTS_UAS);
					$doc->exportCaption($this->LokasiFile);
				} else {
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kelas_Akd);
					$doc->exportCaption($this->NIDN);
					$doc->exportCaption($this->Nama);
					$doc->exportCaption($this->Kode_Mk);
					$doc->exportCaption($this->Nama_Mk_Ind);
					$doc->exportCaption($this->SKS);
					$doc->exportCaption($this->Kelas);
					$doc->exportCaption($this->Tanggal);
					$doc->exportCaption($this->Hari);
					$doc->exportCaption($this->JM);
					$doc->exportCaption($this->Ruang);
					$doc->exportCaption($this->UTS_UAS);
					$doc->exportCaption($this->LokasiFile);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kelas_Akd);
						$doc->exportField($this->NIDN);
						$doc->exportField($this->Nama);
						$doc->exportField($this->Kode_Mk);
						$doc->exportField($this->Nama_Mk_Ind);
						$doc->exportField($this->SKS);
						$doc->exportField($this->Kelas);
						$doc->exportField($this->Tanggal);
						$doc->exportField($this->Hari);
						$doc->exportField($this->JM);
						$doc->exportField($this->Ruang);
						$doc->exportField($this->UTS_UAS);
						$doc->exportField($this->LokasiFile);
					} else {
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kelas_Akd);
						$doc->exportField($this->NIDN);
						$doc->exportField($this->Nama);
						$doc->exportField($this->Kode_Mk);
						$doc->exportField($this->Nama_Mk_Ind);
						$doc->exportField($this->SKS);
						$doc->exportField($this->Kelas);
						$doc->exportField($this->Tanggal);
						$doc->exportField($this->Hari);
						$doc->exportField($this->JM);
						$doc->exportField($this->Ruang);
						$doc->exportField($this->UTS_UAS);
						$doc->exportField($this->LokasiFile);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{
		$width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
		$height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'LokasiFile') {
			$fldName = "LokasiFile";
			$fileNameFld = "LokasiFile";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($ar) == 0) {
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype != "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld != "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					$downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
					if ($fileNameFld != "" && !EmptyValue($rs->fields($fileNameFld))) {
						$fileName = $rs->fields($fileNameFld);
						$pathinfo = pathinfo($fileName);
						$ext = strtolower(@$pathinfo["extension"]);
						$isPdf = SameText($ext, "pdf");
						if ($downloadPdf || !$isPdf) // Skip header if not download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					} else {
						$ext = ContentExtension($val);
						$isPdf = SameText($ext, ".pdf");
						if ($isPdf && $downloadPdf) // Add header if download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					}

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear any debug message
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>