<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for RKP_AbsenDosen
 */
class RKP_AbsenDosen extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Thn_Akademik;
	public $Periode;
	public $Kelas_Akd;
	public $Kode_Mk;
	public $Kelas;
	public $NIDN;
	public $Pertemuan_ke;
	public $Kode_Fak;
	public $Kode_Jp;
	public $Pengganti_ke;
	public $Tanggal;
	public $JM;
	public $JS;
	public $Jenis;
	public $PokokBahasan;
	public $SubPokokBahasan;
	public $Keterangan;
	public $Referensi;
	public $BahanAjar;
	public $BahanAjar2;
	public $BahanAjar3;
	public $id_jadwal;
	public $parafdosen;
	public $parafbaak;
	public $jmlmhshadir;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'RKP_AbsenDosen';
		$this->TableName = 'RKP_AbsenDosen';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[RKP_AbsenDosen]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Thn_Akademik
		$this->Thn_Akademik = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Thn_Akademik', 'Thn_Akademik', '[Thn_Akademik]', '[Thn_Akademik]', 129, 9, -1, FALSE, '[Thn_Akademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Thn_Akademik->IsPrimaryKey = TRUE; // Primary key field
		$this->Thn_Akademik->IsForeignKey = TRUE; // Foreign key field
		$this->Thn_Akademik->Nullable = FALSE; // NOT NULL field
		$this->Thn_Akademik->Required = TRUE; // Required field
		$this->Thn_Akademik->Sortable = TRUE; // Allow sort
		$this->fields['Thn_Akademik'] = &$this->Thn_Akademik;

		// Periode
		$this->Periode = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 129, 3, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Periode->IsPrimaryKey = TRUE; // Primary key field
		$this->Periode->IsForeignKey = TRUE; // Foreign key field
		$this->Periode->Nullable = FALSE; // NOT NULL field
		$this->Periode->Required = TRUE; // Required field
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->fields['Periode'] = &$this->Periode;

		// Kelas_Akd
		$this->Kelas_Akd = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Kelas_Akd', 'Kelas_Akd', '[Kelas_Akd]', '[Kelas_Akd]', 129, 15, -1, FALSE, '[Kelas_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kelas_Akd->IsPrimaryKey = TRUE; // Primary key field
		$this->Kelas_Akd->IsForeignKey = TRUE; // Foreign key field
		$this->Kelas_Akd->Nullable = FALSE; // NOT NULL field
		$this->Kelas_Akd->Required = TRUE; // Required field
		$this->Kelas_Akd->Sortable = TRUE; // Allow sort
		$this->fields['Kelas_Akd'] = &$this->Kelas_Akd;

		// Kode_Mk
		$this->Kode_Mk = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Kode_Mk', 'Kode_Mk', '[Kode_Mk]', '[Kode_Mk]', 129, 14, -1, FALSE, '[Kode_Mk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Mk->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Mk->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Mk->Nullable = FALSE; // NOT NULL field
		$this->Kode_Mk->Required = TRUE; // Required field
		$this->Kode_Mk->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Mk'] = &$this->Kode_Mk;

		// Kelas
		$this->Kelas = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Kelas', 'Kelas', '[Kelas]', '[Kelas]', 129, 10, -1, FALSE, '[Kelas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kelas->IsPrimaryKey = TRUE; // Primary key field
		$this->Kelas->IsForeignKey = TRUE; // Foreign key field
		$this->Kelas->Nullable = FALSE; // NOT NULL field
		$this->Kelas->Required = TRUE; // Required field
		$this->Kelas->Sortable = TRUE; // Allow sort
		$this->fields['Kelas'] = &$this->Kelas;

		// NIDN
		$this->NIDN = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_NIDN', 'NIDN', '[NIDN]', '[NIDN]', 129, 14, -1, FALSE, '[NIDN]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NIDN->IsPrimaryKey = TRUE; // Primary key field
		$this->NIDN->IsForeignKey = TRUE; // Foreign key field
		$this->NIDN->Nullable = FALSE; // NOT NULL field
		$this->NIDN->Required = TRUE; // Required field
		$this->NIDN->Sortable = TRUE; // Allow sort
		$this->fields['NIDN'] = &$this->NIDN;

		// Pertemuan_ke
		$this->Pertemuan_ke = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Pertemuan_ke', 'Pertemuan_ke', '[Pertemuan_ke]', '[Pertemuan_ke]', 200, 4, -1, FALSE, '[Pertemuan_ke]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Pertemuan_ke->IsPrimaryKey = TRUE; // Primary key field
		$this->Pertemuan_ke->Nullable = FALSE; // NOT NULL field
		$this->Pertemuan_ke->Required = TRUE; // Required field
		$this->Pertemuan_ke->Sortable = TRUE; // Allow sort
		$this->Pertemuan_ke->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Pertemuan_ke->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Pertemuan_ke->Lookup = new Lookup('Pertemuan_ke', 'RKP_AbsenDosen', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Pertemuan_ke->OptionCount = 16;
		$this->fields['Pertemuan_ke'] = &$this->Pertemuan_ke;

		// Kode_Fak
		$this->Kode_Fak = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Fak->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Fak->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Fak->Nullable = FALSE; // NOT NULL field
		$this->Kode_Fak->Required = TRUE; // Required field
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Kode_Jp
		$this->Kode_Jp = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Kode_Jp', 'Kode_Jp', '[Kode_Jp]', '[Kode_Jp]', 129, 4, -1, FALSE, '[Kode_Jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Jp->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Jp->Required = TRUE; // Required field
		$this->Kode_Jp->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Jp'] = &$this->Kode_Jp;

		// Pengganti_ke
		$this->Pengganti_ke = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Pengganti_ke', 'Pengganti_ke', '[Pengganti_ke]', '[Pengganti_ke]', 200, 4, -1, FALSE, '[Pengganti_ke]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pengganti_ke->Sortable = TRUE; // Allow sort
		$this->fields['Pengganti_ke'] = &$this->Pengganti_ke;

		// Tanggal
		$this->Tanggal = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Tanggal', 'Tanggal', '[Tanggal]', CastDateFieldForLike("[Tanggal]", 7, "DB"), 135, 8, 7, FALSE, '[Tanggal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tanggal->Required = TRUE; // Required field
		$this->Tanggal->Sortable = TRUE; // Allow sort
		$this->Tanggal->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['Tanggal'] = &$this->Tanggal;

		// JM
		$this->JM = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_JM', 'JM', '[JM]', CastDateFieldForLike("[JM]", 4, "DB"), 135, 8, 4, FALSE, '[JM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JM->Required = TRUE; // Required field
		$this->JM->Sortable = TRUE; // Allow sort
		$this->JM->DefaultErrorMessage = str_replace("%s", $GLOBALS["TIME_SEPARATOR"], $Language->phrase("IncorrectTime"));
		$this->fields['JM'] = &$this->JM;

		// JS
		$this->JS = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_JS', 'JS', '[JS]', CastDateFieldForLike("[JS]", 4, "DB"), 135, 8, 4, FALSE, '[JS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JS->Sortable = TRUE; // Allow sort
		$this->JS->DefaultErrorMessage = str_replace("%s", $GLOBALS["TIME_SEPARATOR"], $Language->phrase("IncorrectTime"));
		$this->fields['JS'] = &$this->JS;

		// Jenis
		$this->Jenis = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Jenis', 'Jenis', '[Jenis]', '[Jenis]', 200, 75, -1, FALSE, '[Jenis]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->Jenis->Sortable = TRUE; // Allow sort
		$this->Jenis->Lookup = new Lookup('Jenis', 'RKP_AbsenDosen', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Jenis->OptionCount = 6;
		$this->fields['Jenis'] = &$this->Jenis;

		// PokokBahasan
		$this->PokokBahasan = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_PokokBahasan', 'PokokBahasan', '[PokokBahasan]', '[PokokBahasan]', 200, 0, -1, FALSE, '[PokokBahasan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->PokokBahasan->Sortable = TRUE; // Allow sort
		$this->fields['PokokBahasan'] = &$this->PokokBahasan;

		// SubPokokBahasan
		$this->SubPokokBahasan = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_SubPokokBahasan', 'SubPokokBahasan', '[SubPokokBahasan]', '[SubPokokBahasan]', 200, 0, -1, FALSE, '[SubPokokBahasan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->SubPokokBahasan->Sortable = TRUE; // Allow sort
		$this->fields['SubPokokBahasan'] = &$this->SubPokokBahasan;

		// Keterangan
		$this->Keterangan = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Keterangan', 'Keterangan', '[Keterangan]', '[Keterangan]', 200, 15, -1, FALSE, '[Keterangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Keterangan->Sortable = TRUE; // Allow sort
		$this->fields['Keterangan'] = &$this->Keterangan;

		// Referensi
		$this->Referensi = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_Referensi', 'Referensi', '[Referensi]', '[Referensi]', 200, 0, -1, FALSE, '[Referensi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Referensi->Sortable = TRUE; // Allow sort
		$this->fields['Referensi'] = &$this->Referensi;

		// BahanAjar
		$this->BahanAjar = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_BahanAjar', 'BahanAjar', '[BahanAjar]', '[BahanAjar]', 200, 100, -1, FALSE, '[BahanAjar]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->BahanAjar->Sortable = TRUE; // Allow sort
		$this->fields['BahanAjar'] = &$this->BahanAjar;

		// BahanAjar2
		$this->BahanAjar2 = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_BahanAjar2', 'BahanAjar2', '[BahanAjar2]', '[BahanAjar2]', 200, 100, -1, FALSE, '[BahanAjar2]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->BahanAjar2->Sortable = TRUE; // Allow sort
		$this->fields['BahanAjar2'] = &$this->BahanAjar2;

		// BahanAjar3
		$this->BahanAjar3 = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_BahanAjar3', 'BahanAjar3', '[BahanAjar3]', '[BahanAjar3]', 200, 100, -1, FALSE, '[BahanAjar3]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->BahanAjar3->Sortable = TRUE; // Allow sort
		$this->fields['BahanAjar3'] = &$this->BahanAjar3;

		// id_jadwal
		$this->id_jadwal = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_id_jadwal', 'id_jadwal', '[id_jadwal]', 'CAST([id_jadwal] AS NVARCHAR)', 20, 8, -1, FALSE, '[id_jadwal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id_jadwal->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id_jadwal->IsForeignKey = TRUE; // Foreign key field
		$this->id_jadwal->Nullable = FALSE; // NOT NULL field
		$this->id_jadwal->Sortable = TRUE; // Allow sort
		$this->id_jadwal->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_jadwal'] = &$this->id_jadwal;

		// parafdosen
		$this->parafdosen = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_parafdosen', 'parafdosen', '[parafdosen]', '[parafdosen]', 200, 100, -1, FALSE, '[parafdosen]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->parafdosen->Sortable = TRUE; // Allow sort
		$this->fields['parafdosen'] = &$this->parafdosen;

		// parafbaak
		$this->parafbaak = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_parafbaak', 'parafbaak', '[parafbaak]', '[parafbaak]', 200, 100, -1, FALSE, '[parafbaak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->parafbaak->Sortable = TRUE; // Allow sort
		$this->fields['parafbaak'] = &$this->parafbaak;

		// jmlmhshadir
		$this->jmlmhshadir = new DbField('RKP_AbsenDosen', 'RKP_AbsenDosen', 'x_jmlmhshadir', 'jmlmhshadir', '[jmlmhshadir]', 'CAST([jmlmhshadir] AS NVARCHAR)', 3, 4, -1, FALSE, '[jmlmhshadir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jmlmhshadir->Sortable = TRUE; // Allow sort
		$this->jmlmhshadir->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jmlmhshadir'] = &$this->jmlmhshadir;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "Wali_JadKul_All") {
			if ($this->Thn_Akademik->getSessionValue() != "")
				$masterFilter .= "[Thn_Akademik]=" . QuotedValue($this->Thn_Akademik->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Periode->getSessionValue() != "")
				$masterFilter .= " AND [Periode]=" . QuotedValue($this->Periode->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kelas_Akd->getSessionValue() != "")
				$masterFilter .= " AND [Kelas_Akd]=" . QuotedValue($this->Kelas_Akd->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Mk->getSessionValue() != "")
				$masterFilter .= " AND [Kode_Mk]=" . QuotedValue($this->Kode_Mk->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->NIDN->getSessionValue() != "")
				$masterFilter .= " AND [NIDN]=" . QuotedValue($this->NIDN->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kelas->getSessionValue() != "")
				$masterFilter .= " AND [Kelas]=" . QuotedValue($this->Kelas->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Fak->getSessionValue() != "")
				$masterFilter .= " AND [Kode_Fak]=" . QuotedValue($this->Kode_Fak->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "Wali_JadkulMin") {
			if ($this->Thn_Akademik->getSessionValue() != "")
				$masterFilter .= "[Thn_Akademik]=" . QuotedValue($this->Thn_Akademik->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Periode->getSessionValue() != "")
				$masterFilter .= " AND [Periode]=" . QuotedValue($this->Periode->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kelas_Akd->getSessionValue() != "")
				$masterFilter .= " AND [Kelas_Akd]=" . QuotedValue($this->Kelas_Akd->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Mk->getSessionValue() != "")
				$masterFilter .= " AND [Kode_Mk]=" . QuotedValue($this->Kode_Mk->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kelas->getSessionValue() != "")
				$masterFilter .= " AND [Kelas]=" . QuotedValue($this->Kelas->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->NIDN->getSessionValue() != "")
				$masterFilter .= " AND [NIDN]=" . QuotedValue($this->NIDN->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Jp->getSessionValue() != "")
				$masterFilter .= " AND [Kode_Jp]=" . QuotedValue($this->Kode_Jp->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "Wali_JadKul_All") {
			if ($this->Thn_Akademik->getSessionValue() != "")
				$detailFilter .= "[Thn_Akademik]=" . QuotedValue($this->Thn_Akademik->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Periode->getSessionValue() != "")
				$detailFilter .= " AND [Periode]=" . QuotedValue($this->Periode->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kelas_Akd->getSessionValue() != "")
				$detailFilter .= " AND [Kelas_Akd]=" . QuotedValue($this->Kelas_Akd->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Mk->getSessionValue() != "")
				$detailFilter .= " AND [Kode_Mk]=" . QuotedValue($this->Kode_Mk->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->NIDN->getSessionValue() != "")
				$detailFilter .= " AND [NIDN]=" . QuotedValue($this->NIDN->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kelas->getSessionValue() != "")
				$detailFilter .= " AND [Kelas]=" . QuotedValue($this->Kelas->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Fak->getSessionValue() != "")
				$detailFilter .= " AND [Kode_Fak]=" . QuotedValue($this->Kode_Fak->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "Wali_JadkulMin") {
			if ($this->Thn_Akademik->getSessionValue() != "")
				$detailFilter .= "[Thn_Akademik]=" . QuotedValue($this->Thn_Akademik->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Periode->getSessionValue() != "")
				$detailFilter .= " AND [Periode]=" . QuotedValue($this->Periode->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kelas_Akd->getSessionValue() != "")
				$detailFilter .= " AND [Kelas_Akd]=" . QuotedValue($this->Kelas_Akd->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Mk->getSessionValue() != "")
				$detailFilter .= " AND [Kode_Mk]=" . QuotedValue($this->Kode_Mk->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kelas->getSessionValue() != "")
				$detailFilter .= " AND [Kelas]=" . QuotedValue($this->Kelas->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->NIDN->getSessionValue() != "")
				$detailFilter .= " AND [NIDN]=" . QuotedValue($this->NIDN->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_Jp->getSessionValue() != "")
				$detailFilter .= " AND [Kode_Jp]=" . QuotedValue($this->Kode_Jp->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_Wali_JadKul_All()
	{
		return "[Thn_Akademik]='@Thn_Akademik@' AND [Periode]='@Periode@' AND [Kelas_Akd]='@Kelas_Akd@' AND [Kode_Mk]='@Kode_Mk@' AND [NIDN]='@NIDN@' AND [Kelas]='@Kelas@' AND [Kode_Fak]='@Kode_Fak@'";
	}

	// Detail filter
	public function sqlDetailFilter_Wali_JadKul_All()
	{
		return "[Thn_Akademik]='@Thn_Akademik@' AND [Periode]='@Periode@' AND [Kelas_Akd]='@Kelas_Akd@' AND [Kode_Mk]='@Kode_Mk@' AND [NIDN]='@NIDN@' AND [Kelas]='@Kelas@' AND [Kode_Fak]='@Kode_Fak@'";
	}

	// Master filter
	public function sqlMasterFilter_Wali_JadkulMin()
	{
		return "[Thn_Akademik]='@Thn_Akademik@' AND [Periode]='@Periode@' AND [Kelas_Akd]='@Kelas_Akd@' AND [Kode_Mk]='@Kode_Mk@' AND [Kelas]='@Kelas@' AND [NIDN]='@NIDN@' AND [Kode_Jp]='@Kode_Jp@'";
	}

	// Detail filter
	public function sqlDetailFilter_Wali_JadkulMin()
	{
		return "[Thn_Akademik]='@Thn_Akademik@' AND [Periode]='@Periode@' AND [Kelas_Akd]='@Kelas_Akd@' AND [Kode_Mk]='@Kode_Mk@' AND [Kelas]='@Kelas@' AND [NIDN]='@NIDN@' AND [Kode_Jp]='@Kode_Jp@'";
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "tblPresensiMhs") {
			$detailUrl = $GLOBALS["tblPresensiMhs"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_id_jadwal=" . urlencode($this->id_jadwal->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "RKP_AbsenDosenlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[RKP_AbsenDosen]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id_jadwal->setDbValue($conn->insert_ID());
			$rs['id_jadwal'] = $this->id_jadwal->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Thn_Akademik', $rs))
				AddFilter($where, QuotedName('Thn_Akademik', $this->Dbid) . '=' . QuotedValue($rs['Thn_Akademik'], $this->Thn_Akademik->DataType, $this->Dbid));
			if (array_key_exists('Periode', $rs))
				AddFilter($where, QuotedName('Periode', $this->Dbid) . '=' . QuotedValue($rs['Periode'], $this->Periode->DataType, $this->Dbid));
			if (array_key_exists('Kelas_Akd', $rs))
				AddFilter($where, QuotedName('Kelas_Akd', $this->Dbid) . '=' . QuotedValue($rs['Kelas_Akd'], $this->Kelas_Akd->DataType, $this->Dbid));
			if (array_key_exists('Kode_Mk', $rs))
				AddFilter($where, QuotedName('Kode_Mk', $this->Dbid) . '=' . QuotedValue($rs['Kode_Mk'], $this->Kode_Mk->DataType, $this->Dbid));
			if (array_key_exists('Kelas', $rs))
				AddFilter($where, QuotedName('Kelas', $this->Dbid) . '=' . QuotedValue($rs['Kelas'], $this->Kelas->DataType, $this->Dbid));
			if (array_key_exists('NIDN', $rs))
				AddFilter($where, QuotedName('NIDN', $this->Dbid) . '=' . QuotedValue($rs['NIDN'], $this->NIDN->DataType, $this->Dbid));
			if (array_key_exists('Pertemuan_ke', $rs))
				AddFilter($where, QuotedName('Pertemuan_ke', $this->Dbid) . '=' . QuotedValue($rs['Pertemuan_ke'], $this->Pertemuan_ke->DataType, $this->Dbid));
			if (array_key_exists('Kode_Fak', $rs))
				AddFilter($where, QuotedName('Kode_Fak', $this->Dbid) . '=' . QuotedValue($rs['Kode_Fak'], $this->Kode_Fak->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();

		// Cascade delete detail table 'tblPresensiMhs'
		if (!isset($GLOBALS["tblPresensiMhs"]))
			$GLOBALS["tblPresensiMhs"] = new tblPresensiMhs();
		$rscascade = $GLOBALS["tblPresensiMhs"]->loadRs("[id_jadwal] = " . QuotedValue($rs['id_jadwal'], DATATYPE_NUMBER, "DB"));
		$dtlrows = ($rscascade) ? $rscascade->getRows() : [];

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["tblPresensiMhs"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["tblPresensiMhs"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["tblPresensiMhs"]->Row_Deleted($dtlrow);
		}
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Thn_Akademik->DbValue = $row['Thn_Akademik'];
		$this->Periode->DbValue = $row['Periode'];
		$this->Kelas_Akd->DbValue = $row['Kelas_Akd'];
		$this->Kode_Mk->DbValue = $row['Kode_Mk'];
		$this->Kelas->DbValue = $row['Kelas'];
		$this->NIDN->DbValue = $row['NIDN'];
		$this->Pertemuan_ke->DbValue = $row['Pertemuan_ke'];
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Kode_Jp->DbValue = $row['Kode_Jp'];
		$this->Pengganti_ke->DbValue = $row['Pengganti_ke'];
		$this->Tanggal->DbValue = $row['Tanggal'];
		$this->JM->DbValue = $row['JM'];
		$this->JS->DbValue = $row['JS'];
		$this->Jenis->DbValue = $row['Jenis'];
		$this->PokokBahasan->DbValue = $row['PokokBahasan'];
		$this->SubPokokBahasan->DbValue = $row['SubPokokBahasan'];
		$this->Keterangan->DbValue = $row['Keterangan'];
		$this->Referensi->DbValue = $row['Referensi'];
		$this->BahanAjar->DbValue = $row['BahanAjar'];
		$this->BahanAjar2->DbValue = $row['BahanAjar2'];
		$this->BahanAjar3->DbValue = $row['BahanAjar3'];
		$this->id_jadwal->DbValue = $row['id_jadwal'];
		$this->parafdosen->DbValue = $row['parafdosen'];
		$this->parafbaak->DbValue = $row['parafbaak'];
		$this->jmlmhshadir->DbValue = $row['jmlmhshadir'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Thn_Akademik] = '@Thn_Akademik@' AND [Periode] = '@Periode@' AND [Kelas_Akd] = '@Kelas_Akd@' AND [Kode_Mk] = '@Kode_Mk@' AND [Kelas] = '@Kelas@' AND [NIDN] = '@NIDN@' AND [Pertemuan_ke] = '@Pertemuan_ke@' AND [Kode_Fak] = '@Kode_Fak@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Thn_Akademik', $row) ? $row['Thn_Akademik'] : NULL;
		else
			$val = $this->Thn_Akademik->OldValue !== NULL ? $this->Thn_Akademik->OldValue : $this->Thn_Akademik->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Thn_Akademik@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Periode', $row) ? $row['Periode'] : NULL;
		else
			$val = $this->Periode->OldValue !== NULL ? $this->Periode->OldValue : $this->Periode->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Periode@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kelas_Akd', $row) ? $row['Kelas_Akd'] : NULL;
		else
			$val = $this->Kelas_Akd->OldValue !== NULL ? $this->Kelas_Akd->OldValue : $this->Kelas_Akd->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kelas_Akd@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kode_Mk', $row) ? $row['Kode_Mk'] : NULL;
		else
			$val = $this->Kode_Mk->OldValue !== NULL ? $this->Kode_Mk->OldValue : $this->Kode_Mk->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Mk@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kelas', $row) ? $row['Kelas'] : NULL;
		else
			$val = $this->Kelas->OldValue !== NULL ? $this->Kelas->OldValue : $this->Kelas->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kelas@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('NIDN', $row) ? $row['NIDN'] : NULL;
		else
			$val = $this->NIDN->OldValue !== NULL ? $this->NIDN->OldValue : $this->NIDN->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@NIDN@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Pertemuan_ke', $row) ? $row['Pertemuan_ke'] : NULL;
		else
			$val = $this->Pertemuan_ke->OldValue !== NULL ? $this->Pertemuan_ke->OldValue : $this->Pertemuan_ke->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Pertemuan_ke@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kode_Fak', $row) ? $row['Kode_Fak'] : NULL;
		else
			$val = $this->Kode_Fak->OldValue !== NULL ? $this->Kode_Fak->OldValue : $this->Kode_Fak->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Fak@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "RKP_AbsenDosenlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "RKP_AbsenDosenview.php")
			return $Language->phrase("View");
		elseif ($pageName == "RKP_AbsenDosenedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "RKP_AbsenDosenadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "RKP_AbsenDosenlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("RKP_AbsenDosenview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("RKP_AbsenDosenview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "RKP_AbsenDosenadd.php?" . $this->getUrlParm($parm);
		else
			$url = "RKP_AbsenDosenadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("RKP_AbsenDosenedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("RKP_AbsenDosenedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("RKP_AbsenDosenadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("RKP_AbsenDosenadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("RKP_AbsenDosendelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "Wali_JadKul_All" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
			$url .= "&fk_Periode=" . urlencode($this->Periode->CurrentValue);
			$url .= "&fk_Kelas_Akd=" . urlencode($this->Kelas_Akd->CurrentValue);
			$url .= "&fk_Kode_Mk=" . urlencode($this->Kode_Mk->CurrentValue);
			$url .= "&fk_NIDN=" . urlencode($this->NIDN->CurrentValue);
			$url .= "&fk_Kelas=" . urlencode($this->Kelas->CurrentValue);
			$url .= "&fk_Kode_Fak=" . urlencode($this->Kode_Fak->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "Wali_JadkulMin" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
			$url .= "&fk_Periode=" . urlencode($this->Periode->CurrentValue);
			$url .= "&fk_Kelas_Akd=" . urlencode($this->Kelas_Akd->CurrentValue);
			$url .= "&fk_Kode_Mk=" . urlencode($this->Kode_Mk->CurrentValue);
			$url .= "&fk_Kelas=" . urlencode($this->Kelas->CurrentValue);
			$url .= "&fk_NIDN=" . urlencode($this->NIDN->CurrentValue);
			$url .= "&fk_Kode_Jp=" . urlencode($this->Kode_Jp->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Thn_Akademik:" . JsonEncode($this->Thn_Akademik->CurrentValue, "string");
		$json .= ",Periode:" . JsonEncode($this->Periode->CurrentValue, "string");
		$json .= ",Kelas_Akd:" . JsonEncode($this->Kelas_Akd->CurrentValue, "string");
		$json .= ",Kode_Mk:" . JsonEncode($this->Kode_Mk->CurrentValue, "string");
		$json .= ",Kelas:" . JsonEncode($this->Kelas->CurrentValue, "string");
		$json .= ",NIDN:" . JsonEncode($this->NIDN->CurrentValue, "string");
		$json .= ",Pertemuan_ke:" . JsonEncode($this->Pertemuan_ke->CurrentValue, "string");
		$json .= ",Kode_Fak:" . JsonEncode($this->Kode_Fak->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Thn_Akademik->CurrentValue != NULL) {
			$url .= "Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Periode->CurrentValue != NULL) {
			$url .= "&Periode=" . urlencode($this->Periode->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kelas_Akd->CurrentValue != NULL) {
			$url .= "&Kelas_Akd=" . urlencode($this->Kelas_Akd->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kode_Mk->CurrentValue != NULL) {
			$url .= "&Kode_Mk=" . urlencode($this->Kode_Mk->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kelas->CurrentValue != NULL) {
			$url .= "&Kelas=" . urlencode($this->Kelas->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->NIDN->CurrentValue != NULL) {
			$url .= "&NIDN=" . urlencode($this->NIDN->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Pertemuan_ke->CurrentValue != NULL) {
			$url .= "&Pertemuan_ke=" . urlencode($this->Pertemuan_ke->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kode_Fak->CurrentValue != NULL) {
			$url .= "&Kode_Fak=" . urlencode($this->Kode_Fak->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("Thn_Akademik") !== NULL)
				$arKey[] = Param("Thn_Akademik");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Periode") !== NULL)
				$arKey[] = Param("Periode");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kelas_Akd") !== NULL)
				$arKey[] = Param("Kelas_Akd");
			elseif (IsApi() && Key(2) !== NULL)
				$arKey[] = Key(2);
			elseif (IsApi() && Route(4) !== NULL)
				$arKey[] = Route(4);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kode_Mk") !== NULL)
				$arKey[] = Param("Kode_Mk");
			elseif (IsApi() && Key(3) !== NULL)
				$arKey[] = Key(3);
			elseif (IsApi() && Route(5) !== NULL)
				$arKey[] = Route(5);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kelas") !== NULL)
				$arKey[] = Param("Kelas");
			elseif (IsApi() && Key(4) !== NULL)
				$arKey[] = Key(4);
			elseif (IsApi() && Route(6) !== NULL)
				$arKey[] = Route(6);
			else
				$arKeys = NULL; // Do not setup
			if (Param("NIDN") !== NULL)
				$arKey[] = Param("NIDN");
			elseif (IsApi() && Key(5) !== NULL)
				$arKey[] = Key(5);
			elseif (IsApi() && Route(7) !== NULL)
				$arKey[] = Route(7);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Pertemuan_ke") !== NULL)
				$arKey[] = Param("Pertemuan_ke");
			elseif (IsApi() && Key(6) !== NULL)
				$arKey[] = Key(6);
			elseif (IsApi() && Route(8) !== NULL)
				$arKey[] = Route(8);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kode_Fak") !== NULL)
				$arKey[] = Param("Kode_Fak");
			elseif (IsApi() && Key(7) !== NULL)
				$arKey[] = Key(7);
			elseif (IsApi() && Route(9) !== NULL)
				$arKey[] = Route(9);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 8)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Thn_Akademik->CurrentValue = $key[0];
			else
				$this->Thn_Akademik->OldValue = $key[0];
			if ($setCurrent)
				$this->Periode->CurrentValue = $key[1];
			else
				$this->Periode->OldValue = $key[1];
			if ($setCurrent)
				$this->Kelas_Akd->CurrentValue = $key[2];
			else
				$this->Kelas_Akd->OldValue = $key[2];
			if ($setCurrent)
				$this->Kode_Mk->CurrentValue = $key[3];
			else
				$this->Kode_Mk->OldValue = $key[3];
			if ($setCurrent)
				$this->Kelas->CurrentValue = $key[4];
			else
				$this->Kelas->OldValue = $key[4];
			if ($setCurrent)
				$this->NIDN->CurrentValue = $key[5];
			else
				$this->NIDN->OldValue = $key[5];
			if ($setCurrent)
				$this->Pertemuan_ke->CurrentValue = $key[6];
			else
				$this->Pertemuan_ke->OldValue = $key[6];
			if ($setCurrent)
				$this->Kode_Fak->CurrentValue = $key[7];
			else
				$this->Kode_Fak->OldValue = $key[7];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Thn_Akademik->setDbValue($rs->fields('Thn_Akademik'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->Kelas_Akd->setDbValue($rs->fields('Kelas_Akd'));
		$this->Kode_Mk->setDbValue($rs->fields('Kode_Mk'));
		$this->Kelas->setDbValue($rs->fields('Kelas'));
		$this->NIDN->setDbValue($rs->fields('NIDN'));
		$this->Pertemuan_ke->setDbValue($rs->fields('Pertemuan_ke'));
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Kode_Jp->setDbValue($rs->fields('Kode_Jp'));
		$this->Pengganti_ke->setDbValue($rs->fields('Pengganti_ke'));
		$this->Tanggal->setDbValue($rs->fields('Tanggal'));
		$this->JM->setDbValue($rs->fields('JM'));
		$this->JS->setDbValue($rs->fields('JS'));
		$this->Jenis->setDbValue($rs->fields('Jenis'));
		$this->PokokBahasan->setDbValue($rs->fields('PokokBahasan'));
		$this->SubPokokBahasan->setDbValue($rs->fields('SubPokokBahasan'));
		$this->Keterangan->setDbValue($rs->fields('Keterangan'));
		$this->Referensi->setDbValue($rs->fields('Referensi'));
		$this->BahanAjar->setDbValue($rs->fields('BahanAjar'));
		$this->BahanAjar2->setDbValue($rs->fields('BahanAjar2'));
		$this->BahanAjar3->setDbValue($rs->fields('BahanAjar3'));
		$this->id_jadwal->setDbValue($rs->fields('id_jadwal'));
		$this->parafdosen->setDbValue($rs->fields('parafdosen'));
		$this->parafbaak->setDbValue($rs->fields('parafbaak'));
		$this->jmlmhshadir->setDbValue($rs->fields('jmlmhshadir'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Thn_Akademik
		// Periode
		// Kelas_Akd
		// Kode_Mk
		// Kelas
		// NIDN
		// Pertemuan_ke
		// Kode_Fak
		// Kode_Jp
		// Pengganti_ke
		// Tanggal
		// JM
		// JS
		// Jenis
		// PokokBahasan
		// SubPokokBahasan
		// Keterangan
		// Referensi
		// BahanAjar
		// BahanAjar2
		// BahanAjar3
		// id_jadwal
		// parafdosen
		// parafbaak
		// jmlmhshadir
		// Thn_Akademik

		$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
		$this->Thn_Akademik->ViewCustomAttributes = "";

		// Periode
		$this->Periode->ViewValue = $this->Periode->CurrentValue;
		$this->Periode->ViewCustomAttributes = "";

		// Kelas_Akd
		$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->CurrentValue;
		$this->Kelas_Akd->ViewCustomAttributes = "";

		// Kode_Mk
		$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->ViewCustomAttributes = "";

		// Kelas
		$this->Kelas->ViewValue = $this->Kelas->CurrentValue;
		$this->Kelas->ViewCustomAttributes = "";

		// NIDN
		$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
		$this->NIDN->ViewCustomAttributes = "";

		// Pertemuan_ke
		if (strval($this->Pertemuan_ke->CurrentValue) != "") {
			$this->Pertemuan_ke->ViewValue = $this->Pertemuan_ke->optionCaption($this->Pertemuan_ke->CurrentValue);
		} else {
			$this->Pertemuan_ke->ViewValue = NULL;
		}
		$this->Pertemuan_ke->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Kode_Jp
		$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
		$this->Kode_Jp->ViewCustomAttributes = "";

		// Pengganti_ke
		$this->Pengganti_ke->ViewValue = $this->Pengganti_ke->CurrentValue;
		$this->Pengganti_ke->ViewCustomAttributes = "";

		// Tanggal
		$this->Tanggal->ViewValue = $this->Tanggal->CurrentValue;
		$this->Tanggal->ViewValue = FormatDateTime($this->Tanggal->ViewValue, 7);
		$this->Tanggal->ViewCustomAttributes = "";

		// JM
		$this->JM->ViewValue = $this->JM->CurrentValue;
		$this->JM->ViewValue = FormatDateTime($this->JM->ViewValue, 4);
		$this->JM->ViewCustomAttributes = "";

		// JS
		$this->JS->ViewValue = $this->JS->CurrentValue;
		$this->JS->ViewValue = FormatDateTime($this->JS->ViewValue, 4);
		$this->JS->ViewCustomAttributes = "";

		// Jenis
		if (strval($this->Jenis->CurrentValue) != "") {
			$this->Jenis->ViewValue = new OptionValues();
			$arwrk = explode(",", strval($this->Jenis->CurrentValue));
			$cnt = count($arwrk);
			for ($ari = 0; $ari < $cnt; $ari++)
				$this->Jenis->ViewValue->add($this->Jenis->optionCaption(trim($arwrk[$ari])));
		} else {
			$this->Jenis->ViewValue = NULL;
		}
		$this->Jenis->ViewCustomAttributes = "";

		// PokokBahasan
		$this->PokokBahasan->ViewValue = $this->PokokBahasan->CurrentValue;
		if ($this->PokokBahasan->ViewValue != NULL)
			$this->PokokBahasan->ViewValue = str_replace("\n", "<br>", $this->PokokBahasan->ViewValue);
		$this->PokokBahasan->ViewCustomAttributes = "";

		// SubPokokBahasan
		$this->SubPokokBahasan->ViewValue = $this->SubPokokBahasan->CurrentValue;
		if ($this->SubPokokBahasan->ViewValue != NULL)
			$this->SubPokokBahasan->ViewValue = str_replace("\n", "<br>", $this->SubPokokBahasan->ViewValue);
		$this->SubPokokBahasan->ViewCustomAttributes = "";

		// Keterangan
		$this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;
		$this->Keterangan->ViewCustomAttributes = "";

		// Referensi
		$this->Referensi->ViewValue = $this->Referensi->CurrentValue;
		if ($this->Referensi->ViewValue != NULL)
			$this->Referensi->ViewValue = str_replace("\n", "<br>", $this->Referensi->ViewValue);
		$this->Referensi->ViewCustomAttributes = "";

		// BahanAjar
		$this->BahanAjar->ViewValue = $this->BahanAjar->CurrentValue;
		$this->BahanAjar->ViewCustomAttributes = "";

		// BahanAjar2
		$this->BahanAjar2->ViewValue = $this->BahanAjar2->CurrentValue;
		$this->BahanAjar2->ViewCustomAttributes = "";

		// BahanAjar3
		$this->BahanAjar3->ViewValue = $this->BahanAjar3->CurrentValue;
		$this->BahanAjar3->ViewCustomAttributes = "";

		// id_jadwal
		$this->id_jadwal->ViewValue = $this->id_jadwal->CurrentValue;
		$this->id_jadwal->ViewCustomAttributes = "";

		// parafdosen
		$this->parafdosen->ViewValue = $this->parafdosen->CurrentValue;
		$this->parafdosen->ViewCustomAttributes = "";

		// parafbaak
		$this->parafbaak->ViewValue = $this->parafbaak->CurrentValue;
		$this->parafbaak->ViewCustomAttributes = "";

		// jmlmhshadir
		$this->jmlmhshadir->ViewValue = $this->jmlmhshadir->CurrentValue;
		$this->jmlmhshadir->ViewValue = FormatNumber($this->jmlmhshadir->ViewValue, 0, -2, -2, -2);
		$this->jmlmhshadir->ViewCustomAttributes = "";

		// Thn_Akademik
		$this->Thn_Akademik->LinkCustomAttributes = "";
		$this->Thn_Akademik->HrefValue = "";
		$this->Thn_Akademik->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// Kelas_Akd
		$this->Kelas_Akd->LinkCustomAttributes = "";
		$this->Kelas_Akd->HrefValue = "";
		$this->Kelas_Akd->TooltipValue = "";

		// Kode_Mk
		$this->Kode_Mk->LinkCustomAttributes = "";
		$this->Kode_Mk->HrefValue = "";
		$this->Kode_Mk->TooltipValue = "";

		// Kelas
		$this->Kelas->LinkCustomAttributes = "";
		$this->Kelas->HrefValue = "";
		$this->Kelas->TooltipValue = "";

		// NIDN
		$this->NIDN->LinkCustomAttributes = "";
		$this->NIDN->HrefValue = "";
		$this->NIDN->TooltipValue = "";

		// Pertemuan_ke
		$this->Pertemuan_ke->LinkCustomAttributes = "";
		$this->Pertemuan_ke->HrefValue = "";
		$this->Pertemuan_ke->TooltipValue = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Kode_Jp
		$this->Kode_Jp->LinkCustomAttributes = "";
		$this->Kode_Jp->HrefValue = "";
		$this->Kode_Jp->TooltipValue = "";

		// Pengganti_ke
		$this->Pengganti_ke->LinkCustomAttributes = "";
		$this->Pengganti_ke->HrefValue = "";
		$this->Pengganti_ke->TooltipValue = "";

		// Tanggal
		$this->Tanggal->LinkCustomAttributes = "";
		$this->Tanggal->HrefValue = "";
		$this->Tanggal->TooltipValue = "";

		// JM
		$this->JM->LinkCustomAttributes = "";
		$this->JM->HrefValue = "";
		$this->JM->TooltipValue = "";

		// JS
		$this->JS->LinkCustomAttributes = "";
		$this->JS->HrefValue = "";
		$this->JS->TooltipValue = "";

		// Jenis
		$this->Jenis->LinkCustomAttributes = "";
		$this->Jenis->HrefValue = "";
		$this->Jenis->TooltipValue = "";

		// PokokBahasan
		$this->PokokBahasan->LinkCustomAttributes = "";
		$this->PokokBahasan->HrefValue = "";
		$this->PokokBahasan->TooltipValue = "";

		// SubPokokBahasan
		$this->SubPokokBahasan->LinkCustomAttributes = "";
		$this->SubPokokBahasan->HrefValue = "";
		$this->SubPokokBahasan->TooltipValue = "";

		// Keterangan
		$this->Keterangan->LinkCustomAttributes = "";
		$this->Keterangan->HrefValue = "";
		$this->Keterangan->TooltipValue = "";

		// Referensi
		$this->Referensi->LinkCustomAttributes = "";
		$this->Referensi->HrefValue = "";
		$this->Referensi->TooltipValue = "";

		// BahanAjar
		$this->BahanAjar->LinkCustomAttributes = "";
		$this->BahanAjar->HrefValue = "";
		$this->BahanAjar->TooltipValue = "";

		// BahanAjar2
		$this->BahanAjar2->LinkCustomAttributes = "";
		$this->BahanAjar2->HrefValue = "";
		$this->BahanAjar2->TooltipValue = "";

		// BahanAjar3
		$this->BahanAjar3->LinkCustomAttributes = "";
		$this->BahanAjar3->HrefValue = "";
		$this->BahanAjar3->TooltipValue = "";

		// id_jadwal
		$this->id_jadwal->LinkCustomAttributes = "";
		$this->id_jadwal->HrefValue = "";
		$this->id_jadwal->TooltipValue = "";

		// parafdosen
		$this->parafdosen->LinkCustomAttributes = "";
		$this->parafdosen->HrefValue = "";
		$this->parafdosen->TooltipValue = "";

		// parafbaak
		$this->parafbaak->LinkCustomAttributes = "";
		$this->parafbaak->HrefValue = "";
		$this->parafbaak->TooltipValue = "";

		// jmlmhshadir
		$this->jmlmhshadir->LinkCustomAttributes = "";
		$this->jmlmhshadir->HrefValue = "";
		$this->jmlmhshadir->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Thn_Akademik
		$this->Thn_Akademik->EditAttrs["class"] = "form-control";
		$this->Thn_Akademik->EditCustomAttributes = "";
		if (!$this->Thn_Akademik->Raw)
			$this->Thn_Akademik->CurrentValue = HtmlDecode($this->Thn_Akademik->CurrentValue);
		$this->Thn_Akademik->EditValue = $this->Thn_Akademik->CurrentValue;
		$this->Thn_Akademik->PlaceHolder = RemoveHtml($this->Thn_Akademik->caption());

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		if (!$this->Periode->Raw)
			$this->Periode->CurrentValue = HtmlDecode($this->Periode->CurrentValue);
		$this->Periode->EditValue = $this->Periode->CurrentValue;
		$this->Periode->PlaceHolder = RemoveHtml($this->Periode->caption());

		// Kelas_Akd
		$this->Kelas_Akd->EditAttrs["class"] = "form-control";
		$this->Kelas_Akd->EditCustomAttributes = "";
		if (!$this->Kelas_Akd->Raw)
			$this->Kelas_Akd->CurrentValue = HtmlDecode($this->Kelas_Akd->CurrentValue);
		$this->Kelas_Akd->EditValue = $this->Kelas_Akd->CurrentValue;
		$this->Kelas_Akd->PlaceHolder = RemoveHtml($this->Kelas_Akd->caption());

		// Kode_Mk
		$this->Kode_Mk->EditAttrs["class"] = "form-control";
		$this->Kode_Mk->EditCustomAttributes = "";
		if (!$this->Kode_Mk->Raw)
			$this->Kode_Mk->CurrentValue = HtmlDecode($this->Kode_Mk->CurrentValue);
		$this->Kode_Mk->EditValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->PlaceHolder = RemoveHtml($this->Kode_Mk->caption());

		// Kelas
		$this->Kelas->EditAttrs["class"] = "form-control";
		$this->Kelas->EditCustomAttributes = "";
		if (!$this->Kelas->Raw)
			$this->Kelas->CurrentValue = HtmlDecode($this->Kelas->CurrentValue);
		$this->Kelas->EditValue = $this->Kelas->CurrentValue;
		$this->Kelas->PlaceHolder = RemoveHtml($this->Kelas->caption());

		// NIDN
		$this->NIDN->EditAttrs["class"] = "form-control";
		$this->NIDN->EditCustomAttributes = "";
		if (!$this->NIDN->Raw)
			$this->NIDN->CurrentValue = HtmlDecode($this->NIDN->CurrentValue);
		$this->NIDN->EditValue = $this->NIDN->CurrentValue;
		$this->NIDN->PlaceHolder = RemoveHtml($this->NIDN->caption());

		// Pertemuan_ke
		$this->Pertemuan_ke->EditAttrs["class"] = "form-control";
		$this->Pertemuan_ke->EditCustomAttributes = "";
		$this->Pertemuan_ke->EditValue = $this->Pertemuan_ke->options(TRUE);

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";
		if (!$this->Kode_Fak->Raw)
			$this->Kode_Fak->CurrentValue = HtmlDecode($this->Kode_Fak->CurrentValue);
		$this->Kode_Fak->EditValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->PlaceHolder = RemoveHtml($this->Kode_Fak->caption());

		// Kode_Jp
		$this->Kode_Jp->EditAttrs["class"] = "form-control";
		$this->Kode_Jp->EditCustomAttributes = "";
		if ($this->Kode_Jp->getSessionValue() != "") {
			$this->Kode_Jp->CurrentValue = $this->Kode_Jp->getSessionValue();
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->ViewCustomAttributes = "";
		} else {
			if (!$this->Kode_Jp->Raw)
				$this->Kode_Jp->CurrentValue = HtmlDecode($this->Kode_Jp->CurrentValue);
			$this->Kode_Jp->EditValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->PlaceHolder = RemoveHtml($this->Kode_Jp->caption());
		}

		// Pengganti_ke
		$this->Pengganti_ke->EditAttrs["class"] = "form-control";
		$this->Pengganti_ke->EditCustomAttributes = "";
		if (!$this->Pengganti_ke->Raw)
			$this->Pengganti_ke->CurrentValue = HtmlDecode($this->Pengganti_ke->CurrentValue);
		$this->Pengganti_ke->EditValue = $this->Pengganti_ke->CurrentValue;
		$this->Pengganti_ke->PlaceHolder = RemoveHtml($this->Pengganti_ke->caption());

		// Tanggal
		$this->Tanggal->EditAttrs["class"] = "form-control";
		$this->Tanggal->EditCustomAttributes = "";
		$this->Tanggal->EditValue = FormatDateTime($this->Tanggal->CurrentValue, 7);
		$this->Tanggal->PlaceHolder = RemoveHtml($this->Tanggal->caption());

		// JM
		$this->JM->EditAttrs["class"] = "form-control";
		$this->JM->EditCustomAttributes = "";
		$this->JM->EditValue = FormatDateTime($this->JM->CurrentValue, 4);
		$this->JM->PlaceHolder = RemoveHtml($this->JM->caption());

		// JS
		$this->JS->EditAttrs["class"] = "form-control";
		$this->JS->EditCustomAttributes = "";
		$this->JS->EditValue = FormatDateTime($this->JS->CurrentValue, 4);
		$this->JS->PlaceHolder = RemoveHtml($this->JS->caption());

		// Jenis
		$this->Jenis->EditCustomAttributes = "";
		$this->Jenis->EditValue = $this->Jenis->options(FALSE);

		// PokokBahasan
		$this->PokokBahasan->EditAttrs["class"] = "form-control";
		$this->PokokBahasan->EditCustomAttributes = "";
		$this->PokokBahasan->EditValue = $this->PokokBahasan->CurrentValue;
		$this->PokokBahasan->PlaceHolder = RemoveHtml($this->PokokBahasan->caption());

		// SubPokokBahasan
		$this->SubPokokBahasan->EditAttrs["class"] = "form-control";
		$this->SubPokokBahasan->EditCustomAttributes = "";
		$this->SubPokokBahasan->EditValue = $this->SubPokokBahasan->CurrentValue;
		$this->SubPokokBahasan->PlaceHolder = RemoveHtml($this->SubPokokBahasan->caption());

		// Keterangan
		$this->Keterangan->EditAttrs["class"] = "form-control";
		$this->Keterangan->EditCustomAttributes = "";
		if (!$this->Keterangan->Raw)
			$this->Keterangan->CurrentValue = HtmlDecode($this->Keterangan->CurrentValue);
		$this->Keterangan->EditValue = $this->Keterangan->CurrentValue;
		$this->Keterangan->PlaceHolder = RemoveHtml($this->Keterangan->caption());

		// Referensi
		$this->Referensi->EditAttrs["class"] = "form-control";
		$this->Referensi->EditCustomAttributes = "";
		$this->Referensi->EditValue = $this->Referensi->CurrentValue;
		$this->Referensi->PlaceHolder = RemoveHtml($this->Referensi->caption());

		// BahanAjar
		$this->BahanAjar->EditAttrs["class"] = "form-control";
		$this->BahanAjar->EditCustomAttributes = "";
		if (!$this->BahanAjar->Raw)
			$this->BahanAjar->CurrentValue = HtmlDecode($this->BahanAjar->CurrentValue);
		$this->BahanAjar->EditValue = $this->BahanAjar->CurrentValue;
		$this->BahanAjar->PlaceHolder = RemoveHtml($this->BahanAjar->caption());

		// BahanAjar2
		$this->BahanAjar2->EditAttrs["class"] = "form-control";
		$this->BahanAjar2->EditCustomAttributes = "";
		if (!$this->BahanAjar2->Raw)
			$this->BahanAjar2->CurrentValue = HtmlDecode($this->BahanAjar2->CurrentValue);
		$this->BahanAjar2->EditValue = $this->BahanAjar2->CurrentValue;
		$this->BahanAjar2->PlaceHolder = RemoveHtml($this->BahanAjar2->caption());

		// BahanAjar3
		$this->BahanAjar3->EditAttrs["class"] = "form-control";
		$this->BahanAjar3->EditCustomAttributes = "";
		if (!$this->BahanAjar3->Raw)
			$this->BahanAjar3->CurrentValue = HtmlDecode($this->BahanAjar3->CurrentValue);
		$this->BahanAjar3->EditValue = $this->BahanAjar3->CurrentValue;
		$this->BahanAjar3->PlaceHolder = RemoveHtml($this->BahanAjar3->caption());

		// id_jadwal
		$this->id_jadwal->EditAttrs["class"] = "form-control";
		$this->id_jadwal->EditCustomAttributes = "";
		$this->id_jadwal->EditValue = $this->id_jadwal->CurrentValue;
		$this->id_jadwal->PlaceHolder = RemoveHtml($this->id_jadwal->caption());

		// parafdosen
		$this->parafdosen->EditAttrs["class"] = "form-control";
		$this->parafdosen->EditCustomAttributes = "";
		if (!$this->parafdosen->Raw)
			$this->parafdosen->CurrentValue = HtmlDecode($this->parafdosen->CurrentValue);
		$this->parafdosen->EditValue = $this->parafdosen->CurrentValue;
		$this->parafdosen->PlaceHolder = RemoveHtml($this->parafdosen->caption());

		// parafbaak
		$this->parafbaak->EditAttrs["class"] = "form-control";
		$this->parafbaak->EditCustomAttributes = "";
		if (!$this->parafbaak->Raw)
			$this->parafbaak->CurrentValue = HtmlDecode($this->parafbaak->CurrentValue);
		$this->parafbaak->EditValue = $this->parafbaak->CurrentValue;
		$this->parafbaak->PlaceHolder = RemoveHtml($this->parafbaak->caption());

		// jmlmhshadir
		$this->jmlmhshadir->EditAttrs["class"] = "form-control";
		$this->jmlmhshadir->EditCustomAttributes = "";
		$this->jmlmhshadir->EditValue = $this->jmlmhshadir->CurrentValue;
		$this->jmlmhshadir->PlaceHolder = RemoveHtml($this->jmlmhshadir->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Pertemuan_ke);
					$doc->exportCaption($this->Tanggal);
					$doc->exportCaption($this->JM);
					$doc->exportCaption($this->JS);
					$doc->exportCaption($this->Jenis);
					$doc->exportCaption($this->PokokBahasan);
					$doc->exportCaption($this->SubPokokBahasan);
					$doc->exportCaption($this->Referensi);
					$doc->exportCaption($this->BahanAjar);
					$doc->exportCaption($this->id_jadwal);
					$doc->exportCaption($this->parafdosen);
					$doc->exportCaption($this->parafbaak);
					$doc->exportCaption($this->jmlmhshadir);
				} else {
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kelas_Akd);
					$doc->exportCaption($this->Kode_Mk);
					$doc->exportCaption($this->Kelas);
					$doc->exportCaption($this->NIDN);
					$doc->exportCaption($this->Pertemuan_ke);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Pengganti_ke);
					$doc->exportCaption($this->Tanggal);
					$doc->exportCaption($this->JM);
					$doc->exportCaption($this->JS);
					$doc->exportCaption($this->Jenis);
					$doc->exportCaption($this->PokokBahasan);
					$doc->exportCaption($this->SubPokokBahasan);
					$doc->exportCaption($this->Keterangan);
					$doc->exportCaption($this->Referensi);
					$doc->exportCaption($this->BahanAjar);
					$doc->exportCaption($this->BahanAjar2);
					$doc->exportCaption($this->BahanAjar3);
					$doc->exportCaption($this->id_jadwal);
					$doc->exportCaption($this->parafdosen);
					$doc->exportCaption($this->parafbaak);
					$doc->exportCaption($this->jmlmhshadir);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Pertemuan_ke);
						$doc->exportField($this->Tanggal);
						$doc->exportField($this->JM);
						$doc->exportField($this->JS);
						$doc->exportField($this->Jenis);
						$doc->exportField($this->PokokBahasan);
						$doc->exportField($this->SubPokokBahasan);
						$doc->exportField($this->Referensi);
						$doc->exportField($this->BahanAjar);
						$doc->exportField($this->id_jadwal);
						$doc->exportField($this->parafdosen);
						$doc->exportField($this->parafbaak);
						$doc->exportField($this->jmlmhshadir);
					} else {
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kelas_Akd);
						$doc->exportField($this->Kode_Mk);
						$doc->exportField($this->Kelas);
						$doc->exportField($this->NIDN);
						$doc->exportField($this->Pertemuan_ke);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Pengganti_ke);
						$doc->exportField($this->Tanggal);
						$doc->exportField($this->JM);
						$doc->exportField($this->JS);
						$doc->exportField($this->Jenis);
						$doc->exportField($this->PokokBahasan);
						$doc->exportField($this->SubPokokBahasan);
						$doc->exportField($this->Keterangan);
						$doc->exportField($this->Referensi);
						$doc->exportField($this->BahanAjar);
						$doc->exportField($this->BahanAjar2);
						$doc->exportField($this->BahanAjar3);
						$doc->exportField($this->id_jadwal);
						$doc->exportField($this->parafdosen);
						$doc->exportField($this->parafbaak);
						$doc->exportField($this->jmlmhshadir);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>