<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class RKP_AbsenDosen_add extends RKP_AbsenDosen
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'RKP_AbsenDosen';

	// Page object name
	public $PageObjName = "RKP_AbsenDosen_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (RKP_AbsenDosen)
		if (!isset($GLOBALS["RKP_AbsenDosen"]) || get_class($GLOBALS["RKP_AbsenDosen"]) == PROJECT_NAMESPACE . "RKP_AbsenDosen") {
			$GLOBALS["RKP_AbsenDosen"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["RKP_AbsenDosen"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (Wali_JadkulMin)
		if (!isset($GLOBALS['Wali_JadkulMin']))
			$GLOBALS['Wali_JadkulMin'] = new Wali_JadkulMin();

		// Table object (Wali_JadKul_All)
		if (!isset($GLOBALS['Wali_JadKul_All']))
			$GLOBALS['Wali_JadKul_All'] = new Wali_JadKul_All();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'RKP_AbsenDosen');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $RKP_AbsenDosen;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($RKP_AbsenDosen);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "RKP_AbsenDosenview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Thn_Akademik'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Periode'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas_Akd'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Mk'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['NIDN'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Pertemuan_ke'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Fak'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAddOrEdit())
			$this->id_jadwal->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("RKP_AbsenDosenlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Thn_Akademik->Visible = FALSE;
		$this->Periode->Visible = FALSE;
		$this->Kelas_Akd->Visible = FALSE;
		$this->Kode_Mk->Visible = FALSE;
		$this->Kelas->Visible = FALSE;
		$this->NIDN->Visible = FALSE;
		$this->Pertemuan_ke->setVisibility();
		$this->Kode_Fak->Visible = FALSE;
		$this->Kode_Jp->Visible = FALSE;
		$this->Pengganti_ke->Visible = FALSE;
		$this->Tanggal->setVisibility();
		$this->JM->setVisibility();
		$this->JS->setVisibility();
		$this->Jenis->setVisibility();
		$this->PokokBahasan->setVisibility();
		$this->SubPokokBahasan->setVisibility();
		$this->Keterangan->Visible = FALSE;
		$this->Referensi->setVisibility();
		$this->BahanAjar->Visible = FALSE;
		$this->BahanAjar2->Visible = FALSE;
		$this->BahanAjar3->Visible = FALSE;
		$this->id_jadwal->Visible = FALSE;
		$this->parafdosen->Visible = FALSE;
		$this->parafbaak->Visible = FALSE;
		$this->jmlmhshadir->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check permission

		if (!$Security->canAdd()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("RKP_AbsenDosenlist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("Thn_Akademik") !== NULL) {
				$this->Thn_Akademik->setQueryStringValue(Get("Thn_Akademik"));
				$this->setKey("Thn_Akademik", $this->Thn_Akademik->CurrentValue); // Set up key
			} else {
				$this->setKey("Thn_Akademik", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Periode") !== NULL) {
				$this->Periode->setQueryStringValue(Get("Periode"));
				$this->setKey("Periode", $this->Periode->CurrentValue); // Set up key
			} else {
				$this->setKey("Periode", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kelas_Akd") !== NULL) {
				$this->Kelas_Akd->setQueryStringValue(Get("Kelas_Akd"));
				$this->setKey("Kelas_Akd", $this->Kelas_Akd->CurrentValue); // Set up key
			} else {
				$this->setKey("Kelas_Akd", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kode_Mk") !== NULL) {
				$this->Kode_Mk->setQueryStringValue(Get("Kode_Mk"));
				$this->setKey("Kode_Mk", $this->Kode_Mk->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_Mk", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kelas") !== NULL) {
				$this->Kelas->setQueryStringValue(Get("Kelas"));
				$this->setKey("Kelas", $this->Kelas->CurrentValue); // Set up key
			} else {
				$this->setKey("Kelas", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("NIDN") !== NULL) {
				$this->NIDN->setQueryStringValue(Get("NIDN"));
				$this->setKey("NIDN", $this->NIDN->CurrentValue); // Set up key
			} else {
				$this->setKey("NIDN", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Pertemuan_ke") !== NULL) {
				$this->Pertemuan_ke->setQueryStringValue(Get("Pertemuan_ke"));
				$this->setKey("Pertemuan_ke", $this->Pertemuan_ke->CurrentValue); // Set up key
			} else {
				$this->setKey("Pertemuan_ke", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kode_Fak") !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Get("Kode_Fak"));
				$this->setKey("Kode_Fak", $this->Kode_Fak->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_Fak", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Set up detail parameters
		$this->setupDetailParms();

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("RKP_AbsenDosenlist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					if ($this->getCurrentDetailTable() != "") // Master/detail add
						$returnUrl = $this->getDetailUrl();
					else
						$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "RKP_AbsenDosenlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "RKP_AbsenDosenview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->Thn_Akademik->CurrentValue = NULL;
		$this->Thn_Akademik->OldValue = $this->Thn_Akademik->CurrentValue;
		$this->Periode->CurrentValue = NULL;
		$this->Periode->OldValue = $this->Periode->CurrentValue;
		$this->Kelas_Akd->CurrentValue = NULL;
		$this->Kelas_Akd->OldValue = $this->Kelas_Akd->CurrentValue;
		$this->Kode_Mk->CurrentValue = NULL;
		$this->Kode_Mk->OldValue = $this->Kode_Mk->CurrentValue;
		$this->Kelas->CurrentValue = NULL;
		$this->Kelas->OldValue = $this->Kelas->CurrentValue;
		$this->NIDN->CurrentValue = NULL;
		$this->NIDN->OldValue = $this->NIDN->CurrentValue;
		$this->Pertemuan_ke->CurrentValue = NULL;
		$this->Pertemuan_ke->OldValue = $this->Pertemuan_ke->CurrentValue;
		$this->Kode_Fak->CurrentValue = NULL;
		$this->Kode_Fak->OldValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Jp->CurrentValue = NULL;
		$this->Kode_Jp->OldValue = $this->Kode_Jp->CurrentValue;
		$this->Pengganti_ke->CurrentValue = NULL;
		$this->Pengganti_ke->OldValue = $this->Pengganti_ke->CurrentValue;
		$this->Tanggal->CurrentValue = NULL;
		$this->Tanggal->OldValue = $this->Tanggal->CurrentValue;
		$this->JM->CurrentValue = NULL;
		$this->JM->OldValue = $this->JM->CurrentValue;
		$this->JS->CurrentValue = NULL;
		$this->JS->OldValue = $this->JS->CurrentValue;
		$this->Jenis->CurrentValue = NULL;
		$this->Jenis->OldValue = $this->Jenis->CurrentValue;
		$this->PokokBahasan->CurrentValue = NULL;
		$this->PokokBahasan->OldValue = $this->PokokBahasan->CurrentValue;
		$this->SubPokokBahasan->CurrentValue = NULL;
		$this->SubPokokBahasan->OldValue = $this->SubPokokBahasan->CurrentValue;
		$this->Keterangan->CurrentValue = NULL;
		$this->Keterangan->OldValue = $this->Keterangan->CurrentValue;
		$this->Referensi->CurrentValue = NULL;
		$this->Referensi->OldValue = $this->Referensi->CurrentValue;
		$this->BahanAjar->CurrentValue = NULL;
		$this->BahanAjar->OldValue = $this->BahanAjar->CurrentValue;
		$this->BahanAjar2->CurrentValue = NULL;
		$this->BahanAjar2->OldValue = $this->BahanAjar2->CurrentValue;
		$this->BahanAjar3->CurrentValue = NULL;
		$this->BahanAjar3->OldValue = $this->BahanAjar3->CurrentValue;
		$this->id_jadwal->CurrentValue = NULL;
		$this->id_jadwal->OldValue = $this->id_jadwal->CurrentValue;
		$this->parafdosen->CurrentValue = NULL;
		$this->parafdosen->OldValue = $this->parafdosen->CurrentValue;
		$this->parafbaak->CurrentValue = NULL;
		$this->parafbaak->OldValue = $this->parafbaak->CurrentValue;
		$this->jmlmhshadir->CurrentValue = NULL;
		$this->jmlmhshadir->OldValue = $this->jmlmhshadir->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Pertemuan_ke' first before field var 'x_Pertemuan_ke'
		$val = $CurrentForm->hasValue("Pertemuan_ke") ? $CurrentForm->getValue("Pertemuan_ke") : $CurrentForm->getValue("x_Pertemuan_ke");
		if (!$this->Pertemuan_ke->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Pertemuan_ke->Visible = FALSE; // Disable update for API request
			else
				$this->Pertemuan_ke->setFormValue($val);
		}

		// Check field name 'Tanggal' first before field var 'x_Tanggal'
		$val = $CurrentForm->hasValue("Tanggal") ? $CurrentForm->getValue("Tanggal") : $CurrentForm->getValue("x_Tanggal");
		if (!$this->Tanggal->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tanggal->Visible = FALSE; // Disable update for API request
			else
				$this->Tanggal->setFormValue($val);
			$this->Tanggal->CurrentValue = UnFormatDateTime($this->Tanggal->CurrentValue, 7);
		}

		// Check field name 'JM' first before field var 'x_JM'
		$val = $CurrentForm->hasValue("JM") ? $CurrentForm->getValue("JM") : $CurrentForm->getValue("x_JM");
		if (!$this->JM->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->JM->Visible = FALSE; // Disable update for API request
			else
				$this->JM->setFormValue($val);
			$this->JM->CurrentValue = UnFormatDateTime($this->JM->CurrentValue, 4);
		}

		// Check field name 'JS' first before field var 'x_JS'
		$val = $CurrentForm->hasValue("JS") ? $CurrentForm->getValue("JS") : $CurrentForm->getValue("x_JS");
		if (!$this->JS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->JS->Visible = FALSE; // Disable update for API request
			else
				$this->JS->setFormValue($val);
			$this->JS->CurrentValue = UnFormatDateTime($this->JS->CurrentValue, 4);
		}

		// Check field name 'Jenis' first before field var 'x_Jenis'
		$val = $CurrentForm->hasValue("Jenis") ? $CurrentForm->getValue("Jenis") : $CurrentForm->getValue("x_Jenis");
		if (!$this->Jenis->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Jenis->Visible = FALSE; // Disable update for API request
			else
				$this->Jenis->setFormValue($val);
		}

		// Check field name 'PokokBahasan' first before field var 'x_PokokBahasan'
		$val = $CurrentForm->hasValue("PokokBahasan") ? $CurrentForm->getValue("PokokBahasan") : $CurrentForm->getValue("x_PokokBahasan");
		if (!$this->PokokBahasan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PokokBahasan->Visible = FALSE; // Disable update for API request
			else
				$this->PokokBahasan->setFormValue($val);
		}

		// Check field name 'SubPokokBahasan' first before field var 'x_SubPokokBahasan'
		$val = $CurrentForm->hasValue("SubPokokBahasan") ? $CurrentForm->getValue("SubPokokBahasan") : $CurrentForm->getValue("x_SubPokokBahasan");
		if (!$this->SubPokokBahasan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->SubPokokBahasan->Visible = FALSE; // Disable update for API request
			else
				$this->SubPokokBahasan->setFormValue($val);
		}

		// Check field name 'Referensi' first before field var 'x_Referensi'
		$val = $CurrentForm->hasValue("Referensi") ? $CurrentForm->getValue("Referensi") : $CurrentForm->getValue("x_Referensi");
		if (!$this->Referensi->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Referensi->Visible = FALSE; // Disable update for API request
			else
				$this->Referensi->setFormValue($val);
		}

		// Check field name 'Thn_Akademik' first before field var 'x_Thn_Akademik'
		$val = $CurrentForm->hasValue("Thn_Akademik") ? $CurrentForm->getValue("Thn_Akademik") : $CurrentForm->getValue("x_Thn_Akademik");
		if (!$this->Thn_Akademik->IsDetailKey)
			$this->Thn_Akademik->setFormValue($val);

		// Check field name 'Periode' first before field var 'x_Periode'
		$val = $CurrentForm->hasValue("Periode") ? $CurrentForm->getValue("Periode") : $CurrentForm->getValue("x_Periode");
		if (!$this->Periode->IsDetailKey)
			$this->Periode->setFormValue($val);

		// Check field name 'Kelas_Akd' first before field var 'x_Kelas_Akd'
		$val = $CurrentForm->hasValue("Kelas_Akd") ? $CurrentForm->getValue("Kelas_Akd") : $CurrentForm->getValue("x_Kelas_Akd");
		if (!$this->Kelas_Akd->IsDetailKey)
			$this->Kelas_Akd->setFormValue($val);

		// Check field name 'Kode_Mk' first before field var 'x_Kode_Mk'
		$val = $CurrentForm->hasValue("Kode_Mk") ? $CurrentForm->getValue("Kode_Mk") : $CurrentForm->getValue("x_Kode_Mk");
		if (!$this->Kode_Mk->IsDetailKey)
			$this->Kode_Mk->setFormValue($val);

		// Check field name 'Kelas' first before field var 'x_Kelas'
		$val = $CurrentForm->hasValue("Kelas") ? $CurrentForm->getValue("Kelas") : $CurrentForm->getValue("x_Kelas");
		if (!$this->Kelas->IsDetailKey)
			$this->Kelas->setFormValue($val);

		// Check field name 'NIDN' first before field var 'x_NIDN'
		$val = $CurrentForm->hasValue("NIDN") ? $CurrentForm->getValue("NIDN") : $CurrentForm->getValue("x_NIDN");
		if (!$this->NIDN->IsDetailKey)
			$this->NIDN->setFormValue($val);

		// Check field name 'Kode_Fak' first before field var 'x_Kode_Fak'
		$val = $CurrentForm->hasValue("Kode_Fak") ? $CurrentForm->getValue("Kode_Fak") : $CurrentForm->getValue("x_Kode_Fak");
		if (!$this->Kode_Fak->IsDetailKey)
			$this->Kode_Fak->setFormValue($val);
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Thn_Akademik->CurrentValue = $this->Thn_Akademik->FormValue;
		$this->Periode->CurrentValue = $this->Periode->FormValue;
		$this->Kelas_Akd->CurrentValue = $this->Kelas_Akd->FormValue;
		$this->Kode_Mk->CurrentValue = $this->Kode_Mk->FormValue;
		$this->Kelas->CurrentValue = $this->Kelas->FormValue;
		$this->NIDN->CurrentValue = $this->NIDN->FormValue;
		$this->Kode_Fak->CurrentValue = $this->Kode_Fak->FormValue;
		$this->Pertemuan_ke->CurrentValue = $this->Pertemuan_ke->FormValue;
		$this->Tanggal->CurrentValue = $this->Tanggal->FormValue;
		$this->Tanggal->CurrentValue = UnFormatDateTime($this->Tanggal->CurrentValue, 7);
		$this->JM->CurrentValue = $this->JM->FormValue;
		$this->JM->CurrentValue = UnFormatDateTime($this->JM->CurrentValue, 4);
		$this->JS->CurrentValue = $this->JS->FormValue;
		$this->JS->CurrentValue = UnFormatDateTime($this->JS->CurrentValue, 4);
		$this->Jenis->CurrentValue = $this->Jenis->FormValue;
		$this->PokokBahasan->CurrentValue = $this->PokokBahasan->FormValue;
		$this->SubPokokBahasan->CurrentValue = $this->SubPokokBahasan->FormValue;
		$this->Referensi->CurrentValue = $this->Referensi->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Thn_Akademik->setDbValue($row['Thn_Akademik']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Kelas_Akd->setDbValue($row['Kelas_Akd']);
		$this->Kode_Mk->setDbValue($row['Kode_Mk']);
		$this->Kelas->setDbValue($row['Kelas']);
		$this->NIDN->setDbValue($row['NIDN']);
		$this->Pertemuan_ke->setDbValue($row['Pertemuan_ke']);
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Kode_Jp->setDbValue($row['Kode_Jp']);
		$this->Pengganti_ke->setDbValue($row['Pengganti_ke']);
		$this->Tanggal->setDbValue($row['Tanggal']);
		$this->JM->setDbValue($row['JM']);
		$this->JS->setDbValue($row['JS']);
		$this->Jenis->setDbValue($row['Jenis']);
		$this->PokokBahasan->setDbValue($row['PokokBahasan']);
		$this->SubPokokBahasan->setDbValue($row['SubPokokBahasan']);
		$this->Keterangan->setDbValue($row['Keterangan']);
		$this->Referensi->setDbValue($row['Referensi']);
		$this->BahanAjar->setDbValue($row['BahanAjar']);
		$this->BahanAjar2->setDbValue($row['BahanAjar2']);
		$this->BahanAjar3->setDbValue($row['BahanAjar3']);
		$this->id_jadwal->setDbValue($row['id_jadwal']);
		$this->parafdosen->setDbValue($row['parafdosen']);
		$this->parafbaak->setDbValue($row['parafbaak']);
		$this->jmlmhshadir->setDbValue($row['jmlmhshadir']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['Thn_Akademik'] = $this->Thn_Akademik->CurrentValue;
		$row['Periode'] = $this->Periode->CurrentValue;
		$row['Kelas_Akd'] = $this->Kelas_Akd->CurrentValue;
		$row['Kode_Mk'] = $this->Kode_Mk->CurrentValue;
		$row['Kelas'] = $this->Kelas->CurrentValue;
		$row['NIDN'] = $this->NIDN->CurrentValue;
		$row['Pertemuan_ke'] = $this->Pertemuan_ke->CurrentValue;
		$row['Kode_Fak'] = $this->Kode_Fak->CurrentValue;
		$row['Kode_Jp'] = $this->Kode_Jp->CurrentValue;
		$row['Pengganti_ke'] = $this->Pengganti_ke->CurrentValue;
		$row['Tanggal'] = $this->Tanggal->CurrentValue;
		$row['JM'] = $this->JM->CurrentValue;
		$row['JS'] = $this->JS->CurrentValue;
		$row['Jenis'] = $this->Jenis->CurrentValue;
		$row['PokokBahasan'] = $this->PokokBahasan->CurrentValue;
		$row['SubPokokBahasan'] = $this->SubPokokBahasan->CurrentValue;
		$row['Keterangan'] = $this->Keterangan->CurrentValue;
		$row['Referensi'] = $this->Referensi->CurrentValue;
		$row['BahanAjar'] = $this->BahanAjar->CurrentValue;
		$row['BahanAjar2'] = $this->BahanAjar2->CurrentValue;
		$row['BahanAjar3'] = $this->BahanAjar3->CurrentValue;
		$row['id_jadwal'] = $this->id_jadwal->CurrentValue;
		$row['parafdosen'] = $this->parafdosen->CurrentValue;
		$row['parafbaak'] = $this->parafbaak->CurrentValue;
		$row['jmlmhshadir'] = $this->jmlmhshadir->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Thn_Akademik")) != "")
			$this->Thn_Akademik->OldValue = $this->getKey("Thn_Akademik"); // Thn_Akademik
		else
			$validKey = FALSE;
		if (strval($this->getKey("Periode")) != "")
			$this->Periode->OldValue = $this->getKey("Periode"); // Periode
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kelas_Akd")) != "")
			$this->Kelas_Akd->OldValue = $this->getKey("Kelas_Akd"); // Kelas_Akd
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kode_Mk")) != "")
			$this->Kode_Mk->OldValue = $this->getKey("Kode_Mk"); // Kode_Mk
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kelas")) != "")
			$this->Kelas->OldValue = $this->getKey("Kelas"); // Kelas
		else
			$validKey = FALSE;
		if (strval($this->getKey("NIDN")) != "")
			$this->NIDN->OldValue = $this->getKey("NIDN"); // NIDN
		else
			$validKey = FALSE;
		if (strval($this->getKey("Pertemuan_ke")) != "")
			$this->Pertemuan_ke->OldValue = $this->getKey("Pertemuan_ke"); // Pertemuan_ke
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kode_Fak")) != "")
			$this->Kode_Fak->OldValue = $this->getKey("Kode_Fak"); // Kode_Fak
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Thn_Akademik
		// Periode
		// Kelas_Akd
		// Kode_Mk
		// Kelas
		// NIDN
		// Pertemuan_ke
		// Kode_Fak
		// Kode_Jp
		// Pengganti_ke
		// Tanggal
		// JM
		// JS
		// Jenis
		// PokokBahasan
		// SubPokokBahasan
		// Keterangan
		// Referensi
		// BahanAjar
		// BahanAjar2
		// BahanAjar3
		// id_jadwal
		// parafdosen
		// parafbaak
		// jmlmhshadir

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Thn_Akademik
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
			$this->Thn_Akademik->ViewCustomAttributes = "";

			// Periode
			$this->Periode->ViewValue = $this->Periode->CurrentValue;
			$this->Periode->ViewCustomAttributes = "";

			// Kelas_Akd
			$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->CurrentValue;
			$this->Kelas_Akd->ViewCustomAttributes = "";

			// Kode_Mk
			$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
			$this->Kode_Mk->ViewCustomAttributes = "";

			// Kelas
			$this->Kelas->ViewValue = $this->Kelas->CurrentValue;
			$this->Kelas->ViewCustomAttributes = "";

			// NIDN
			$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
			$this->NIDN->ViewCustomAttributes = "";

			// Pertemuan_ke
			if (strval($this->Pertemuan_ke->CurrentValue) != "") {
				$this->Pertemuan_ke->ViewValue = $this->Pertemuan_ke->optionCaption($this->Pertemuan_ke->CurrentValue);
			} else {
				$this->Pertemuan_ke->ViewValue = NULL;
			}
			$this->Pertemuan_ke->ViewCustomAttributes = "";

			// Kode_Fak
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kode_Jp
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->ViewCustomAttributes = "";

			// Pengganti_ke
			$this->Pengganti_ke->ViewValue = $this->Pengganti_ke->CurrentValue;
			$this->Pengganti_ke->ViewCustomAttributes = "";

			// Tanggal
			$this->Tanggal->ViewValue = $this->Tanggal->CurrentValue;
			$this->Tanggal->ViewValue = FormatDateTime($this->Tanggal->ViewValue, 7);
			$this->Tanggal->ViewCustomAttributes = "";

			// JM
			$this->JM->ViewValue = $this->JM->CurrentValue;
			$this->JM->ViewValue = FormatDateTime($this->JM->ViewValue, 4);
			$this->JM->ViewCustomAttributes = "";

			// JS
			$this->JS->ViewValue = $this->JS->CurrentValue;
			$this->JS->ViewValue = FormatDateTime($this->JS->ViewValue, 4);
			$this->JS->ViewCustomAttributes = "";

			// Jenis
			if (strval($this->Jenis->CurrentValue) != "") {
				$this->Jenis->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->Jenis->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->Jenis->ViewValue->add($this->Jenis->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->Jenis->ViewValue = NULL;
			}
			$this->Jenis->ViewCustomAttributes = "";

			// PokokBahasan
			$this->PokokBahasan->ViewValue = $this->PokokBahasan->CurrentValue;
			if ($this->PokokBahasan->ViewValue != NULL)
				$this->PokokBahasan->ViewValue = str_replace("\n", "<br>", $this->PokokBahasan->ViewValue);
			$this->PokokBahasan->ViewCustomAttributes = "";

			// SubPokokBahasan
			$this->SubPokokBahasan->ViewValue = $this->SubPokokBahasan->CurrentValue;
			if ($this->SubPokokBahasan->ViewValue != NULL)
				$this->SubPokokBahasan->ViewValue = str_replace("\n", "<br>", $this->SubPokokBahasan->ViewValue);
			$this->SubPokokBahasan->ViewCustomAttributes = "";

			// Keterangan
			$this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;
			$this->Keterangan->ViewCustomAttributes = "";

			// Referensi
			$this->Referensi->ViewValue = $this->Referensi->CurrentValue;
			if ($this->Referensi->ViewValue != NULL)
				$this->Referensi->ViewValue = str_replace("\n", "<br>", $this->Referensi->ViewValue);
			$this->Referensi->ViewCustomAttributes = "";

			// BahanAjar
			$this->BahanAjar->ViewValue = $this->BahanAjar->CurrentValue;
			$this->BahanAjar->ViewCustomAttributes = "";

			// BahanAjar2
			$this->BahanAjar2->ViewValue = $this->BahanAjar2->CurrentValue;
			$this->BahanAjar2->ViewCustomAttributes = "";

			// BahanAjar3
			$this->BahanAjar3->ViewValue = $this->BahanAjar3->CurrentValue;
			$this->BahanAjar3->ViewCustomAttributes = "";

			// id_jadwal
			$this->id_jadwal->ViewValue = $this->id_jadwal->CurrentValue;
			$this->id_jadwal->ViewCustomAttributes = "";

			// parafdosen
			$this->parafdosen->ViewValue = $this->parafdosen->CurrentValue;
			$this->parafdosen->ViewCustomAttributes = "";

			// parafbaak
			$this->parafbaak->ViewValue = $this->parafbaak->CurrentValue;
			$this->parafbaak->ViewCustomAttributes = "";

			// jmlmhshadir
			$this->jmlmhshadir->ViewValue = $this->jmlmhshadir->CurrentValue;
			$this->jmlmhshadir->ViewValue = FormatNumber($this->jmlmhshadir->ViewValue, 0, -2, -2, -2);
			$this->jmlmhshadir->ViewCustomAttributes = "";

			// Pertemuan_ke
			$this->Pertemuan_ke->LinkCustomAttributes = "";
			$this->Pertemuan_ke->HrefValue = "";
			$this->Pertemuan_ke->TooltipValue = "";

			// Tanggal
			$this->Tanggal->LinkCustomAttributes = "";
			$this->Tanggal->HrefValue = "";
			$this->Tanggal->TooltipValue = "";

			// JM
			$this->JM->LinkCustomAttributes = "";
			$this->JM->HrefValue = "";
			$this->JM->TooltipValue = "";

			// JS
			$this->JS->LinkCustomAttributes = "";
			$this->JS->HrefValue = "";
			$this->JS->TooltipValue = "";

			// Jenis
			$this->Jenis->LinkCustomAttributes = "";
			$this->Jenis->HrefValue = "";
			$this->Jenis->TooltipValue = "";

			// PokokBahasan
			$this->PokokBahasan->LinkCustomAttributes = "";
			$this->PokokBahasan->HrefValue = "";
			$this->PokokBahasan->TooltipValue = "";

			// SubPokokBahasan
			$this->SubPokokBahasan->LinkCustomAttributes = "";
			$this->SubPokokBahasan->HrefValue = "";
			$this->SubPokokBahasan->TooltipValue = "";

			// Referensi
			$this->Referensi->LinkCustomAttributes = "";
			$this->Referensi->HrefValue = "";
			$this->Referensi->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Pertemuan_ke
			$this->Pertemuan_ke->EditAttrs["class"] = "form-control";
			$this->Pertemuan_ke->EditCustomAttributes = "";
			$this->Pertemuan_ke->EditValue = $this->Pertemuan_ke->options(TRUE);

			// Tanggal
			$this->Tanggal->EditAttrs["class"] = "form-control";
			$this->Tanggal->EditCustomAttributes = "";
			$this->Tanggal->EditValue = HtmlEncode(FormatDateTime($this->Tanggal->CurrentValue, 7));
			$this->Tanggal->PlaceHolder = RemoveHtml($this->Tanggal->caption());

			// JM
			$this->JM->EditAttrs["class"] = "form-control";
			$this->JM->EditCustomAttributes = "";
			$this->JM->EditValue = HtmlEncode(FormatDateTime($this->JM->CurrentValue, 4));
			$this->JM->PlaceHolder = RemoveHtml($this->JM->caption());

			// JS
			$this->JS->EditAttrs["class"] = "form-control";
			$this->JS->EditCustomAttributes = "";
			$this->JS->EditValue = HtmlEncode(FormatDateTime($this->JS->CurrentValue, 4));
			$this->JS->PlaceHolder = RemoveHtml($this->JS->caption());

			// Jenis
			$this->Jenis->EditCustomAttributes = "";
			$this->Jenis->EditValue = $this->Jenis->options(FALSE);

			// PokokBahasan
			$this->PokokBahasan->EditAttrs["class"] = "form-control";
			$this->PokokBahasan->EditCustomAttributes = "";
			$this->PokokBahasan->EditValue = HtmlEncode($this->PokokBahasan->CurrentValue);
			$this->PokokBahasan->PlaceHolder = RemoveHtml($this->PokokBahasan->caption());

			// SubPokokBahasan
			$this->SubPokokBahasan->EditAttrs["class"] = "form-control";
			$this->SubPokokBahasan->EditCustomAttributes = "";
			$this->SubPokokBahasan->EditValue = HtmlEncode($this->SubPokokBahasan->CurrentValue);
			$this->SubPokokBahasan->PlaceHolder = RemoveHtml($this->SubPokokBahasan->caption());

			// Referensi
			$this->Referensi->EditAttrs["class"] = "form-control";
			$this->Referensi->EditCustomAttributes = "";
			$this->Referensi->EditValue = HtmlEncode($this->Referensi->CurrentValue);
			$this->Referensi->PlaceHolder = RemoveHtml($this->Referensi->caption());

			// Add refer script
			// Pertemuan_ke

			$this->Pertemuan_ke->LinkCustomAttributes = "";
			$this->Pertemuan_ke->HrefValue = "";

			// Tanggal
			$this->Tanggal->LinkCustomAttributes = "";
			$this->Tanggal->HrefValue = "";

			// JM
			$this->JM->LinkCustomAttributes = "";
			$this->JM->HrefValue = "";

			// JS
			$this->JS->LinkCustomAttributes = "";
			$this->JS->HrefValue = "";

			// Jenis
			$this->Jenis->LinkCustomAttributes = "";
			$this->Jenis->HrefValue = "";

			// PokokBahasan
			$this->PokokBahasan->LinkCustomAttributes = "";
			$this->PokokBahasan->HrefValue = "";

			// SubPokokBahasan
			$this->SubPokokBahasan->LinkCustomAttributes = "";
			$this->SubPokokBahasan->HrefValue = "";

			// Referensi
			$this->Referensi->LinkCustomAttributes = "";
			$this->Referensi->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Pertemuan_ke->Required) {
			if (!$this->Pertemuan_ke->IsDetailKey && $this->Pertemuan_ke->FormValue != NULL && $this->Pertemuan_ke->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Pertemuan_ke->caption(), $this->Pertemuan_ke->RequiredErrorMessage));
			}
		}
		if ($this->Tanggal->Required) {
			if (!$this->Tanggal->IsDetailKey && $this->Tanggal->FormValue != NULL && $this->Tanggal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tanggal->caption(), $this->Tanggal->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->Tanggal->FormValue)) {
			AddMessage($FormError, $this->Tanggal->errorMessage());
		}
		if ($this->JM->Required) {
			if (!$this->JM->IsDetailKey && $this->JM->FormValue != NULL && $this->JM->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->JM->caption(), $this->JM->RequiredErrorMessage));
			}
		}
		if (!CheckTime($this->JM->FormValue)) {
			AddMessage($FormError, $this->JM->errorMessage());
		}
		if ($this->JS->Required) {
			if (!$this->JS->IsDetailKey && $this->JS->FormValue != NULL && $this->JS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->JS->caption(), $this->JS->RequiredErrorMessage));
			}
		}
		if (!CheckTime($this->JS->FormValue)) {
			AddMessage($FormError, $this->JS->errorMessage());
		}
		if ($this->Jenis->Required) {
			if ($this->Jenis->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Jenis->caption(), $this->Jenis->RequiredErrorMessage));
			}
		}
		if ($this->PokokBahasan->Required) {
			if (!$this->PokokBahasan->IsDetailKey && $this->PokokBahasan->FormValue != NULL && $this->PokokBahasan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PokokBahasan->caption(), $this->PokokBahasan->RequiredErrorMessage));
			}
		}
		if ($this->SubPokokBahasan->Required) {
			if (!$this->SubPokokBahasan->IsDetailKey && $this->SubPokokBahasan->FormValue != NULL && $this->SubPokokBahasan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SubPokokBahasan->caption(), $this->SubPokokBahasan->RequiredErrorMessage));
			}
		}
		if ($this->Referensi->Required) {
			if (!$this->Referensi->IsDetailKey && $this->Referensi->FormValue != NULL && $this->Referensi->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Referensi->caption(), $this->Referensi->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("tblPresensiMhs", $detailTblVar) && $GLOBALS["tblPresensiMhs"]->DetailAdd) {
			if (!isset($GLOBALS["tblPresensiMhs_grid"]))
				$GLOBALS["tblPresensiMhs_grid"] = new tblPresensiMhs_grid(); // Get detail page object
			$GLOBALS["tblPresensiMhs_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Begin transaction
		if ($this->getCurrentDetailTable() != "")
			$conn->beginTrans();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Pertemuan_ke
		$this->Pertemuan_ke->setDbValueDef($rsnew, $this->Pertemuan_ke->CurrentValue, "", FALSE);

		// Tanggal
		$this->Tanggal->setDbValueDef($rsnew, UnFormatDateTime($this->Tanggal->CurrentValue, 7), NULL, FALSE);

		// JM
		$this->JM->setDbValueDef($rsnew, UnFormatDateTime($this->JM->CurrentValue, 4), NULL, FALSE);

		// JS
		$this->JS->setDbValueDef($rsnew, UnFormatDateTime($this->JS->CurrentValue, 4), NULL, FALSE);

		// Jenis
		$this->Jenis->setDbValueDef($rsnew, $this->Jenis->CurrentValue, NULL, FALSE);

		// PokokBahasan
		$this->PokokBahasan->setDbValueDef($rsnew, $this->PokokBahasan->CurrentValue, NULL, FALSE);

		// SubPokokBahasan
		$this->SubPokokBahasan->setDbValueDef($rsnew, $this->SubPokokBahasan->CurrentValue, NULL, FALSE);

		// Referensi
		$this->Referensi->setDbValueDef($rsnew, $this->Referensi->CurrentValue, NULL, FALSE);

		// Thn_Akademik
		if ($this->Thn_Akademik->getSessionValue() != "") {
			$rsnew['Thn_Akademik'] = $this->Thn_Akademik->getSessionValue();
		}

		// Periode
		if ($this->Periode->getSessionValue() != "") {
			$rsnew['Periode'] = $this->Periode->getSessionValue();
		}

		// Kelas_Akd
		if ($this->Kelas_Akd->getSessionValue() != "") {
			$rsnew['Kelas_Akd'] = $this->Kelas_Akd->getSessionValue();
		}

		// Kode_Mk
		if ($this->Kode_Mk->getSessionValue() != "") {
			$rsnew['Kode_Mk'] = $this->Kode_Mk->getSessionValue();
		}

		// Kelas
		if ($this->Kelas->getSessionValue() != "") {
			$rsnew['Kelas'] = $this->Kelas->getSessionValue();
		}

		// NIDN
		if ($this->NIDN->getSessionValue() != "") {
			$rsnew['NIDN'] = $this->NIDN->getSessionValue();
		}

		// Kode_Fak
		if ($this->Kode_Fak->getSessionValue() != "") {
			$rsnew['Kode_Fak'] = $this->Kode_Fak->getSessionValue();
		}

		// Kode_Jp
		if ($this->Kode_Jp->getSessionValue() != "") {
			$rsnew['Kode_Jp'] = $this->Kode_Jp->getSessionValue();
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Thn_Akademik']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Periode']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kelas_Akd']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_Mk']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kelas']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['NIDN']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Pertemuan_ke']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_Fak']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}

		// Add detail records
		if ($addRow) {
			$detailTblVar = explode(",", $this->getCurrentDetailTable());
			if (in_array("tblPresensiMhs", $detailTblVar) && $GLOBALS["tblPresensiMhs"]->DetailAdd) {
				$GLOBALS["tblPresensiMhs"]->id_jadwal->setSessionValue($this->id_jadwal->CurrentValue); // Set master key
				if (!isset($GLOBALS["tblPresensiMhs_grid"]))
					$GLOBALS["tblPresensiMhs_grid"] = new tblPresensiMhs_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "tblPresensiMhs"); // Load user level of detail table
				$addRow = $GLOBALS["tblPresensiMhs_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow) {
					$GLOBALS["tblPresensiMhs"]->id_jadwal->setSessionValue(""); // Clear master key if insert failed
				}
			}
		}

		// Commit/Rollback transaction
		if ($this->getCurrentDetailTable() != "") {
			if ($addRow) {
				$conn->commitTrans(); // Commit transaction
			} else {
				$conn->rollbackTrans(); // Rollback transaction
			}
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "Wali_JadKul_All") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Thn_Akademik", Get("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Thn_Akademik->setQueryStringValue($parm);
					$this->Thn_Akademik->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Thn_Akademik->QueryStringValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Periode", Get("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Periode->setQueryStringValue($parm);
					$this->Periode->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Periode->QueryStringValue);
					$this->Periode->setSessionValue($this->Periode->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas_Akd", Get("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kelas_Akd->setQueryStringValue($parm);
					$this->Kelas_Akd->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Kelas_Akd->QueryStringValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Mk", Get("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kode_Mk->setQueryStringValue($parm);
					$this->Kode_Mk->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Kode_Mk->QueryStringValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_NIDN", Get("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->NIDN->setQueryStringValue($parm);
					$this->NIDN->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->NIDN->QueryStringValue);
					$this->NIDN->setSessionValue($this->NIDN->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas", Get("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kelas->setQueryStringValue($parm);
					$this->Kelas->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Kelas->QueryStringValue);
					$this->Kelas->setSessionValue($this->Kelas->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Fak", Get("Kode_Fak"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kode_Fak->setQueryStringValue($parm);
					$this->Kode_Fak->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Kode_Fak->QueryStringValue);
					$this->Kode_Fak->setSessionValue($this->Kode_Fak->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "Wali_JadkulMin") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Thn_Akademik", Get("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Thn_Akademik->setQueryStringValue($parm);
					$this->Thn_Akademik->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Thn_Akademik->QueryStringValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Periode", Get("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Periode->setQueryStringValue($parm);
					$this->Periode->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Periode->QueryStringValue);
					$this->Periode->setSessionValue($this->Periode->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas_Akd", Get("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas_Akd->setQueryStringValue($parm);
					$this->Kelas_Akd->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kelas_Akd->QueryStringValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Mk", Get("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Mk->setQueryStringValue($parm);
					$this->Kode_Mk->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kode_Mk->QueryStringValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas", Get("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas->setQueryStringValue($parm);
					$this->Kelas->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kelas->QueryStringValue);
					$this->Kelas->setSessionValue($this->Kelas->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_NIDN", Get("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->NIDN->setQueryStringValue($parm);
					$this->NIDN->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->NIDN->QueryStringValue);
					$this->NIDN->setSessionValue($this->NIDN->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Jp", Get("Kode_Jp"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Jp->setQueryStringValue($parm);
					$this->Kode_Jp->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kode_Jp->QueryStringValue);
					$this->Kode_Jp->setSessionValue($this->Kode_Jp->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "Wali_JadKul_All") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Thn_Akademik", Post("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Thn_Akademik->setFormValue($parm);
					$this->Thn_Akademik->setFormValue($GLOBALS["Wali_JadKul_All"]->Thn_Akademik->FormValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Periode", Post("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Periode->setFormValue($parm);
					$this->Periode->setFormValue($GLOBALS["Wali_JadKul_All"]->Periode->FormValue);
					$this->Periode->setSessionValue($this->Periode->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas_Akd", Post("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kelas_Akd->setFormValue($parm);
					$this->Kelas_Akd->setFormValue($GLOBALS["Wali_JadKul_All"]->Kelas_Akd->FormValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Mk", Post("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kode_Mk->setFormValue($parm);
					$this->Kode_Mk->setFormValue($GLOBALS["Wali_JadKul_All"]->Kode_Mk->FormValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_NIDN", Post("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->NIDN->setFormValue($parm);
					$this->NIDN->setFormValue($GLOBALS["Wali_JadKul_All"]->NIDN->FormValue);
					$this->NIDN->setSessionValue($this->NIDN->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas", Post("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kelas->setFormValue($parm);
					$this->Kelas->setFormValue($GLOBALS["Wali_JadKul_All"]->Kelas->FormValue);
					$this->Kelas->setSessionValue($this->Kelas->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Fak", Post("Kode_Fak"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kode_Fak->setFormValue($parm);
					$this->Kode_Fak->setFormValue($GLOBALS["Wali_JadKul_All"]->Kode_Fak->FormValue);
					$this->Kode_Fak->setSessionValue($this->Kode_Fak->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "Wali_JadkulMin") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Thn_Akademik", Post("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Thn_Akademik->setFormValue($parm);
					$this->Thn_Akademik->setFormValue($GLOBALS["Wali_JadkulMin"]->Thn_Akademik->FormValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Periode", Post("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Periode->setFormValue($parm);
					$this->Periode->setFormValue($GLOBALS["Wali_JadkulMin"]->Periode->FormValue);
					$this->Periode->setSessionValue($this->Periode->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas_Akd", Post("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas_Akd->setFormValue($parm);
					$this->Kelas_Akd->setFormValue($GLOBALS["Wali_JadkulMin"]->Kelas_Akd->FormValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Mk", Post("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Mk->setFormValue($parm);
					$this->Kode_Mk->setFormValue($GLOBALS["Wali_JadkulMin"]->Kode_Mk->FormValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas", Post("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas->setFormValue($parm);
					$this->Kelas->setFormValue($GLOBALS["Wali_JadkulMin"]->Kelas->FormValue);
					$this->Kelas->setSessionValue($this->Kelas->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_NIDN", Post("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->NIDN->setFormValue($parm);
					$this->NIDN->setFormValue($GLOBALS["Wali_JadkulMin"]->NIDN->FormValue);
					$this->NIDN->setSessionValue($this->NIDN->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Jp", Post("Kode_Jp"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Jp->setFormValue($parm);
					$this->Kode_Jp->setFormValue($GLOBALS["Wali_JadkulMin"]->Kode_Jp->FormValue);
					$this->Kode_Jp->setSessionValue($this->Kode_Jp->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "Wali_JadKul_All") {
				if ($this->Thn_Akademik->CurrentValue == "")
					$this->Thn_Akademik->setSessionValue("");
				if ($this->Periode->CurrentValue == "")
					$this->Periode->setSessionValue("");
				if ($this->Kelas_Akd->CurrentValue == "")
					$this->Kelas_Akd->setSessionValue("");
				if ($this->Kode_Mk->CurrentValue == "")
					$this->Kode_Mk->setSessionValue("");
				if ($this->NIDN->CurrentValue == "")
					$this->NIDN->setSessionValue("");
				if ($this->Kelas->CurrentValue == "")
					$this->Kelas->setSessionValue("");
				if ($this->Kode_Fak->CurrentValue == "")
					$this->Kode_Fak->setSessionValue("");
			}
			if ($masterTblVar != "Wali_JadkulMin") {
				if ($this->Thn_Akademik->CurrentValue == "")
					$this->Thn_Akademik->setSessionValue("");
				if ($this->Periode->CurrentValue == "")
					$this->Periode->setSessionValue("");
				if ($this->Kelas_Akd->CurrentValue == "")
					$this->Kelas_Akd->setSessionValue("");
				if ($this->Kode_Mk->CurrentValue == "")
					$this->Kode_Mk->setSessionValue("");
				if ($this->Kelas->CurrentValue == "")
					$this->Kelas->setSessionValue("");
				if ($this->NIDN->CurrentValue == "")
					$this->NIDN->setSessionValue("");
				if ($this->Kode_Jp->CurrentValue == "")
					$this->Kode_Jp->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("tblPresensiMhs", $detailTblVar)) {
				if (!isset($GLOBALS["tblPresensiMhs_grid"]))
					$GLOBALS["tblPresensiMhs_grid"] = new tblPresensiMhs_grid();
				if ($GLOBALS["tblPresensiMhs_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["tblPresensiMhs_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["tblPresensiMhs_grid"]->CurrentMode = "add";
					$GLOBALS["tblPresensiMhs_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["tblPresensiMhs_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["tblPresensiMhs_grid"]->setStartRecordNumber(1);
					$GLOBALS["tblPresensiMhs_grid"]->id_jadwal->IsDetailKey = TRUE;
					$GLOBALS["tblPresensiMhs_grid"]->id_jadwal->CurrentValue = $this->id_jadwal->CurrentValue;
					$GLOBALS["tblPresensiMhs_grid"]->id_jadwal->setSessionValue($GLOBALS["tblPresensiMhs_grid"]->id_jadwal->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("RKP_AbsenDosenlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Pertemuan_ke":
					break;
				case "x_Jenis":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>