<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class RKP_AbsenDosen_delete extends RKP_AbsenDosen
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'RKP_AbsenDosen';

	// Page object name
	public $PageObjName = "RKP_AbsenDosen_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (RKP_AbsenDosen)
		if (!isset($GLOBALS["RKP_AbsenDosen"]) || get_class($GLOBALS["RKP_AbsenDosen"]) == PROJECT_NAMESPACE . "RKP_AbsenDosen") {
			$GLOBALS["RKP_AbsenDosen"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["RKP_AbsenDosen"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (Wali_JadkulMin)
		if (!isset($GLOBALS['Wali_JadkulMin']))
			$GLOBALS['Wali_JadkulMin'] = new Wali_JadkulMin();

		// Table object (Wali_JadKul_All)
		if (!isset($GLOBALS['Wali_JadKul_All']))
			$GLOBALS['Wali_JadKul_All'] = new Wali_JadKul_All();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'RKP_AbsenDosen');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $RKP_AbsenDosen;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($RKP_AbsenDosen);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Thn_Akademik'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Periode'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas_Akd'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Mk'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['NIDN'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Pertemuan_ke'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Fak'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAddOrEdit())
			$this->id_jadwal->Visible = FALSE;
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canDelete()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("RKP_AbsenDosenlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Thn_Akademik->Visible = FALSE;
		$this->Periode->Visible = FALSE;
		$this->Kelas_Akd->Visible = FALSE;
		$this->Kode_Mk->Visible = FALSE;
		$this->Kelas->Visible = FALSE;
		$this->NIDN->Visible = FALSE;
		$this->Pertemuan_ke->setVisibility();
		$this->Kode_Fak->Visible = FALSE;
		$this->Kode_Jp->Visible = FALSE;
		$this->Pengganti_ke->Visible = FALSE;
		$this->Tanggal->setVisibility();
		$this->JM->setVisibility();
		$this->JS->setVisibility();
		$this->Jenis->setVisibility();
		$this->PokokBahasan->Visible = FALSE;
		$this->SubPokokBahasan->Visible = FALSE;
		$this->Keterangan->Visible = FALSE;
		$this->Referensi->Visible = FALSE;
		$this->BahanAjar->Visible = FALSE;
		$this->BahanAjar2->Visible = FALSE;
		$this->BahanAjar3->Visible = FALSE;
		$this->id_jadwal->Visible = FALSE;
		$this->parafdosen->setVisibility();
		$this->parafbaak->setVisibility();
		$this->jmlmhshadir->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check permission

		if (!$Security->canDelete()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("RKP_AbsenDosenlist.php");
			return;
		}

		// Set up master/detail parameters
		$this->setupMasterParms();

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("RKP_AbsenDosenlist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("RKP_AbsenDosenlist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Thn_Akademik->setDbValue($row['Thn_Akademik']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Kelas_Akd->setDbValue($row['Kelas_Akd']);
		$this->Kode_Mk->setDbValue($row['Kode_Mk']);
		$this->Kelas->setDbValue($row['Kelas']);
		$this->NIDN->setDbValue($row['NIDN']);
		$this->Pertemuan_ke->setDbValue($row['Pertemuan_ke']);
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Kode_Jp->setDbValue($row['Kode_Jp']);
		$this->Pengganti_ke->setDbValue($row['Pengganti_ke']);
		$this->Tanggal->setDbValue($row['Tanggal']);
		$this->JM->setDbValue($row['JM']);
		$this->JS->setDbValue($row['JS']);
		$this->Jenis->setDbValue($row['Jenis']);
		$this->PokokBahasan->setDbValue($row['PokokBahasan']);
		$this->SubPokokBahasan->setDbValue($row['SubPokokBahasan']);
		$this->Keterangan->setDbValue($row['Keterangan']);
		$this->Referensi->setDbValue($row['Referensi']);
		$this->BahanAjar->setDbValue($row['BahanAjar']);
		$this->BahanAjar2->setDbValue($row['BahanAjar2']);
		$this->BahanAjar3->setDbValue($row['BahanAjar3']);
		$this->id_jadwal->setDbValue($row['id_jadwal']);
		$this->parafdosen->setDbValue($row['parafdosen']);
		$this->parafbaak->setDbValue($row['parafbaak']);
		$this->jmlmhshadir->setDbValue($row['jmlmhshadir']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Thn_Akademik'] = NULL;
		$row['Periode'] = NULL;
		$row['Kelas_Akd'] = NULL;
		$row['Kode_Mk'] = NULL;
		$row['Kelas'] = NULL;
		$row['NIDN'] = NULL;
		$row['Pertemuan_ke'] = NULL;
		$row['Kode_Fak'] = NULL;
		$row['Kode_Jp'] = NULL;
		$row['Pengganti_ke'] = NULL;
		$row['Tanggal'] = NULL;
		$row['JM'] = NULL;
		$row['JS'] = NULL;
		$row['Jenis'] = NULL;
		$row['PokokBahasan'] = NULL;
		$row['SubPokokBahasan'] = NULL;
		$row['Keterangan'] = NULL;
		$row['Referensi'] = NULL;
		$row['BahanAjar'] = NULL;
		$row['BahanAjar2'] = NULL;
		$row['BahanAjar3'] = NULL;
		$row['id_jadwal'] = NULL;
		$row['parafdosen'] = NULL;
		$row['parafbaak'] = NULL;
		$row['jmlmhshadir'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Thn_Akademik
		// Periode
		// Kelas_Akd
		// Kode_Mk
		// Kelas
		// NIDN
		// Pertemuan_ke
		// Kode_Fak
		// Kode_Jp
		// Pengganti_ke
		// Tanggal
		// JM
		// JS
		// Jenis
		// PokokBahasan
		// SubPokokBahasan
		// Keterangan
		// Referensi
		// BahanAjar
		// BahanAjar2
		// BahanAjar3
		// id_jadwal
		// parafdosen
		// parafbaak
		// jmlmhshadir

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Thn_Akademik
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
			$this->Thn_Akademik->ViewCustomAttributes = "";

			// Periode
			$this->Periode->ViewValue = $this->Periode->CurrentValue;
			$this->Periode->ViewCustomAttributes = "";

			// Kelas_Akd
			$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->CurrentValue;
			$this->Kelas_Akd->ViewCustomAttributes = "";

			// Kode_Mk
			$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
			$this->Kode_Mk->ViewCustomAttributes = "";

			// Kelas
			$this->Kelas->ViewValue = $this->Kelas->CurrentValue;
			$this->Kelas->ViewCustomAttributes = "";

			// NIDN
			$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
			$this->NIDN->ViewCustomAttributes = "";

			// Pertemuan_ke
			if (strval($this->Pertemuan_ke->CurrentValue) != "") {
				$this->Pertemuan_ke->ViewValue = $this->Pertemuan_ke->optionCaption($this->Pertemuan_ke->CurrentValue);
			} else {
				$this->Pertemuan_ke->ViewValue = NULL;
			}
			$this->Pertemuan_ke->ViewCustomAttributes = "";

			// Kode_Fak
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kode_Jp
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->ViewCustomAttributes = "";

			// Pengganti_ke
			$this->Pengganti_ke->ViewValue = $this->Pengganti_ke->CurrentValue;
			$this->Pengganti_ke->ViewCustomAttributes = "";

			// Tanggal
			$this->Tanggal->ViewValue = $this->Tanggal->CurrentValue;
			$this->Tanggal->ViewValue = FormatDateTime($this->Tanggal->ViewValue, 7);
			$this->Tanggal->ViewCustomAttributes = "";

			// JM
			$this->JM->ViewValue = $this->JM->CurrentValue;
			$this->JM->ViewValue = FormatDateTime($this->JM->ViewValue, 4);
			$this->JM->ViewCustomAttributes = "";

			// JS
			$this->JS->ViewValue = $this->JS->CurrentValue;
			$this->JS->ViewValue = FormatDateTime($this->JS->ViewValue, 4);
			$this->JS->ViewCustomAttributes = "";

			// Jenis
			if (strval($this->Jenis->CurrentValue) != "") {
				$this->Jenis->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->Jenis->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->Jenis->ViewValue->add($this->Jenis->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->Jenis->ViewValue = NULL;
			}
			$this->Jenis->ViewCustomAttributes = "";

			// PokokBahasan
			$this->PokokBahasan->ViewValue = $this->PokokBahasan->CurrentValue;
			if ($this->PokokBahasan->ViewValue != NULL)
				$this->PokokBahasan->ViewValue = str_replace("\n", "<br>", $this->PokokBahasan->ViewValue);
			$this->PokokBahasan->ViewCustomAttributes = "";

			// SubPokokBahasan
			$this->SubPokokBahasan->ViewValue = $this->SubPokokBahasan->CurrentValue;
			if ($this->SubPokokBahasan->ViewValue != NULL)
				$this->SubPokokBahasan->ViewValue = str_replace("\n", "<br>", $this->SubPokokBahasan->ViewValue);
			$this->SubPokokBahasan->ViewCustomAttributes = "";

			// Keterangan
			$this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;
			$this->Keterangan->ViewCustomAttributes = "";

			// Referensi
			$this->Referensi->ViewValue = $this->Referensi->CurrentValue;
			if ($this->Referensi->ViewValue != NULL)
				$this->Referensi->ViewValue = str_replace("\n", "<br>", $this->Referensi->ViewValue);
			$this->Referensi->ViewCustomAttributes = "";

			// BahanAjar
			$this->BahanAjar->ViewValue = $this->BahanAjar->CurrentValue;
			$this->BahanAjar->ViewCustomAttributes = "";

			// BahanAjar2
			$this->BahanAjar2->ViewValue = $this->BahanAjar2->CurrentValue;
			$this->BahanAjar2->ViewCustomAttributes = "";

			// BahanAjar3
			$this->BahanAjar3->ViewValue = $this->BahanAjar3->CurrentValue;
			$this->BahanAjar3->ViewCustomAttributes = "";

			// id_jadwal
			$this->id_jadwal->ViewValue = $this->id_jadwal->CurrentValue;
			$this->id_jadwal->ViewCustomAttributes = "";

			// parafdosen
			$this->parafdosen->ViewValue = $this->parafdosen->CurrentValue;
			$this->parafdosen->ViewCustomAttributes = "";

			// parafbaak
			$this->parafbaak->ViewValue = $this->parafbaak->CurrentValue;
			$this->parafbaak->ViewCustomAttributes = "";

			// jmlmhshadir
			$this->jmlmhshadir->ViewValue = $this->jmlmhshadir->CurrentValue;
			$this->jmlmhshadir->ViewValue = FormatNumber($this->jmlmhshadir->ViewValue, 0, -2, -2, -2);
			$this->jmlmhshadir->ViewCustomAttributes = "";

			// Pertemuan_ke
			$this->Pertemuan_ke->LinkCustomAttributes = "";
			$this->Pertemuan_ke->HrefValue = "";
			$this->Pertemuan_ke->TooltipValue = "";

			// Tanggal
			$this->Tanggal->LinkCustomAttributes = "";
			$this->Tanggal->HrefValue = "";
			$this->Tanggal->TooltipValue = "";

			// JM
			$this->JM->LinkCustomAttributes = "";
			$this->JM->HrefValue = "";
			$this->JM->TooltipValue = "";

			// JS
			$this->JS->LinkCustomAttributes = "";
			$this->JS->HrefValue = "";
			$this->JS->TooltipValue = "";

			// Jenis
			$this->Jenis->LinkCustomAttributes = "";
			$this->Jenis->HrefValue = "";
			$this->Jenis->TooltipValue = "";

			// parafdosen
			$this->parafdosen->LinkCustomAttributes = "";
			$this->parafdosen->HrefValue = "";
			$this->parafdosen->TooltipValue = "";

			// parafbaak
			$this->parafbaak->LinkCustomAttributes = "";
			$this->parafbaak->HrefValue = "";
			$this->parafbaak->TooltipValue = "";

			// jmlmhshadir
			$this->jmlmhshadir->LinkCustomAttributes = "";
			$this->jmlmhshadir->HrefValue = "";
			$this->jmlmhshadir->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Thn_Akademik'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Periode'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Kelas_Akd'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Kode_Mk'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Kelas'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['NIDN'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Pertemuan_ke'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Kode_Fak'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "Wali_JadKul_All") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Thn_Akademik", Get("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Thn_Akademik->setQueryStringValue($parm);
					$this->Thn_Akademik->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Thn_Akademik->QueryStringValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Periode", Get("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Periode->setQueryStringValue($parm);
					$this->Periode->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Periode->QueryStringValue);
					$this->Periode->setSessionValue($this->Periode->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas_Akd", Get("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kelas_Akd->setQueryStringValue($parm);
					$this->Kelas_Akd->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Kelas_Akd->QueryStringValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Mk", Get("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kode_Mk->setQueryStringValue($parm);
					$this->Kode_Mk->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Kode_Mk->QueryStringValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_NIDN", Get("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->NIDN->setQueryStringValue($parm);
					$this->NIDN->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->NIDN->QueryStringValue);
					$this->NIDN->setSessionValue($this->NIDN->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas", Get("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kelas->setQueryStringValue($parm);
					$this->Kelas->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Kelas->QueryStringValue);
					$this->Kelas->setSessionValue($this->Kelas->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Fak", Get("Kode_Fak"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kode_Fak->setQueryStringValue($parm);
					$this->Kode_Fak->setQueryStringValue($GLOBALS["Wali_JadKul_All"]->Kode_Fak->QueryStringValue);
					$this->Kode_Fak->setSessionValue($this->Kode_Fak->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "Wali_JadkulMin") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Thn_Akademik", Get("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Thn_Akademik->setQueryStringValue($parm);
					$this->Thn_Akademik->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Thn_Akademik->QueryStringValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Periode", Get("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Periode->setQueryStringValue($parm);
					$this->Periode->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Periode->QueryStringValue);
					$this->Periode->setSessionValue($this->Periode->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas_Akd", Get("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas_Akd->setQueryStringValue($parm);
					$this->Kelas_Akd->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kelas_Akd->QueryStringValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Mk", Get("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Mk->setQueryStringValue($parm);
					$this->Kode_Mk->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kode_Mk->QueryStringValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas", Get("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas->setQueryStringValue($parm);
					$this->Kelas->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kelas->QueryStringValue);
					$this->Kelas->setSessionValue($this->Kelas->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_NIDN", Get("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->NIDN->setQueryStringValue($parm);
					$this->NIDN->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->NIDN->QueryStringValue);
					$this->NIDN->setSessionValue($this->NIDN->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Jp", Get("Kode_Jp"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Jp->setQueryStringValue($parm);
					$this->Kode_Jp->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kode_Jp->QueryStringValue);
					$this->Kode_Jp->setSessionValue($this->Kode_Jp->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "Wali_JadKul_All") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Thn_Akademik", Post("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Thn_Akademik->setFormValue($parm);
					$this->Thn_Akademik->setFormValue($GLOBALS["Wali_JadKul_All"]->Thn_Akademik->FormValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Periode", Post("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Periode->setFormValue($parm);
					$this->Periode->setFormValue($GLOBALS["Wali_JadKul_All"]->Periode->FormValue);
					$this->Periode->setSessionValue($this->Periode->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas_Akd", Post("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kelas_Akd->setFormValue($parm);
					$this->Kelas_Akd->setFormValue($GLOBALS["Wali_JadKul_All"]->Kelas_Akd->FormValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Mk", Post("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kode_Mk->setFormValue($parm);
					$this->Kode_Mk->setFormValue($GLOBALS["Wali_JadKul_All"]->Kode_Mk->FormValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_NIDN", Post("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->NIDN->setFormValue($parm);
					$this->NIDN->setFormValue($GLOBALS["Wali_JadKul_All"]->NIDN->FormValue);
					$this->NIDN->setSessionValue($this->NIDN->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas", Post("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kelas->setFormValue($parm);
					$this->Kelas->setFormValue($GLOBALS["Wali_JadKul_All"]->Kelas->FormValue);
					$this->Kelas->setSessionValue($this->Kelas->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Fak", Post("Kode_Fak"))) !== NULL) {
					$GLOBALS["Wali_JadKul_All"]->Kode_Fak->setFormValue($parm);
					$this->Kode_Fak->setFormValue($GLOBALS["Wali_JadKul_All"]->Kode_Fak->FormValue);
					$this->Kode_Fak->setSessionValue($this->Kode_Fak->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "Wali_JadkulMin") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Thn_Akademik", Post("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Thn_Akademik->setFormValue($parm);
					$this->Thn_Akademik->setFormValue($GLOBALS["Wali_JadkulMin"]->Thn_Akademik->FormValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Periode", Post("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Periode->setFormValue($parm);
					$this->Periode->setFormValue($GLOBALS["Wali_JadkulMin"]->Periode->FormValue);
					$this->Periode->setSessionValue($this->Periode->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas_Akd", Post("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas_Akd->setFormValue($parm);
					$this->Kelas_Akd->setFormValue($GLOBALS["Wali_JadkulMin"]->Kelas_Akd->FormValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Mk", Post("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Mk->setFormValue($parm);
					$this->Kode_Mk->setFormValue($GLOBALS["Wali_JadkulMin"]->Kode_Mk->FormValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas", Post("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas->setFormValue($parm);
					$this->Kelas->setFormValue($GLOBALS["Wali_JadkulMin"]->Kelas->FormValue);
					$this->Kelas->setSessionValue($this->Kelas->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_NIDN", Post("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->NIDN->setFormValue($parm);
					$this->NIDN->setFormValue($GLOBALS["Wali_JadkulMin"]->NIDN->FormValue);
					$this->NIDN->setSessionValue($this->NIDN->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Jp", Post("Kode_Jp"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Jp->setFormValue($parm);
					$this->Kode_Jp->setFormValue($GLOBALS["Wali_JadkulMin"]->Kode_Jp->FormValue);
					$this->Kode_Jp->setSessionValue($this->Kode_Jp->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "Wali_JadKul_All") {
				if ($this->Thn_Akademik->CurrentValue == "")
					$this->Thn_Akademik->setSessionValue("");
				if ($this->Periode->CurrentValue == "")
					$this->Periode->setSessionValue("");
				if ($this->Kelas_Akd->CurrentValue == "")
					$this->Kelas_Akd->setSessionValue("");
				if ($this->Kode_Mk->CurrentValue == "")
					$this->Kode_Mk->setSessionValue("");
				if ($this->NIDN->CurrentValue == "")
					$this->NIDN->setSessionValue("");
				if ($this->Kelas->CurrentValue == "")
					$this->Kelas->setSessionValue("");
				if ($this->Kode_Fak->CurrentValue == "")
					$this->Kode_Fak->setSessionValue("");
			}
			if ($masterTblVar != "Wali_JadkulMin") {
				if ($this->Thn_Akademik->CurrentValue == "")
					$this->Thn_Akademik->setSessionValue("");
				if ($this->Periode->CurrentValue == "")
					$this->Periode->setSessionValue("");
				if ($this->Kelas_Akd->CurrentValue == "")
					$this->Kelas_Akd->setSessionValue("");
				if ($this->Kode_Mk->CurrentValue == "")
					$this->Kode_Mk->setSessionValue("");
				if ($this->Kelas->CurrentValue == "")
					$this->Kelas->setSessionValue("");
				if ($this->NIDN->CurrentValue == "")
					$this->NIDN->setSessionValue("");
				if ($this->Kode_Jp->CurrentValue == "")
					$this->Kode_Jp->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("RKP_AbsenDosenlist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Pertemuan_ke":
					break;
				case "x_Jenis":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>