<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class RKP_AbsenDosen_view extends RKP_AbsenDosen
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'RKP_AbsenDosen';

	// Page object name
	public $PageObjName = "RKP_AbsenDosen_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (RKP_AbsenDosen)
		if (!isset($GLOBALS["RKP_AbsenDosen"]) || get_class($GLOBALS["RKP_AbsenDosen"]) == PROJECT_NAMESPACE . "RKP_AbsenDosen") {
			$GLOBALS["RKP_AbsenDosen"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["RKP_AbsenDosen"];
		}
		$keyUrl = "";
		if (Get("Thn_Akademik") !== NULL) {
			$this->RecKey["Thn_Akademik"] = Get("Thn_Akademik");
			$keyUrl .= "&amp;Thn_Akademik=" . urlencode($this->RecKey["Thn_Akademik"]);
		}
		if (Get("Periode") !== NULL) {
			$this->RecKey["Periode"] = Get("Periode");
			$keyUrl .= "&amp;Periode=" . urlencode($this->RecKey["Periode"]);
		}
		if (Get("Kelas_Akd") !== NULL) {
			$this->RecKey["Kelas_Akd"] = Get("Kelas_Akd");
			$keyUrl .= "&amp;Kelas_Akd=" . urlencode($this->RecKey["Kelas_Akd"]);
		}
		if (Get("Kode_Mk") !== NULL) {
			$this->RecKey["Kode_Mk"] = Get("Kode_Mk");
			$keyUrl .= "&amp;Kode_Mk=" . urlencode($this->RecKey["Kode_Mk"]);
		}
		if (Get("Kelas") !== NULL) {
			$this->RecKey["Kelas"] = Get("Kelas");
			$keyUrl .= "&amp;Kelas=" . urlencode($this->RecKey["Kelas"]);
		}
		if (Get("NIDN") !== NULL) {
			$this->RecKey["NIDN"] = Get("NIDN");
			$keyUrl .= "&amp;NIDN=" . urlencode($this->RecKey["NIDN"]);
		}
		if (Get("Pertemuan_ke") !== NULL) {
			$this->RecKey["Pertemuan_ke"] = Get("Pertemuan_ke");
			$keyUrl .= "&amp;Pertemuan_ke=" . urlencode($this->RecKey["Pertemuan_ke"]);
		}
		if (Get("Kode_Fak") !== NULL) {
			$this->RecKey["Kode_Fak"] = Get("Kode_Fak");
			$keyUrl .= "&amp;Kode_Fak=" . urlencode($this->RecKey["Kode_Fak"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (Wali_JadkulMin)
		if (!isset($GLOBALS['Wali_JadkulMin']))
			$GLOBALS['Wali_JadkulMin'] = new Wali_JadkulMin();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'RKP_AbsenDosen');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $RKP_AbsenDosen;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($RKP_AbsenDosen);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "RKP_AbsenDosenview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Thn_Akademik'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Periode'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas_Akd'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Mk'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['NIDN'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Pertemuan_ke'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Fak'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecords = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $RecKey = [];
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canView()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("RKP_AbsenDosenlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Thn_Akademik->setVisibility();
		$this->Periode->setVisibility();
		$this->Kelas_Akd->setVisibility();
		$this->Kode_Mk->setVisibility();
		$this->Kelas->setVisibility();
		$this->NIDN->setVisibility();
		$this->Pertemuan_ke->setVisibility();
		$this->Kode_Fak->setVisibility();
		$this->Kode_Jp->setVisibility();
		$this->Pengganti_ke->setVisibility();
		$this->Tanggal->setVisibility();
		$this->JM->setVisibility();
		$this->JS->setVisibility();
		$this->PokokBahasan->setVisibility();
		$this->SubPokokBahasan->setVisibility();
		$this->Keterangan->setVisibility();
		$this->Referensi->setVisibility();
		$this->BahanAjar->setVisibility();
		$this->BahanAjar2->setVisibility();
		$this->BahanAjar3->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check permission

		if (!$Security->canView()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("RKP_AbsenDosenlist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;

		// Set up master/detail parameters
		$this->setupMasterParms();
		if ($this->isPageRequest()) { // Validate request
			if (Get("Thn_Akademik") !== NULL) {
				$this->Thn_Akademik->setQueryStringValue(Get("Thn_Akademik"));
				$this->RecKey["Thn_Akademik"] = $this->Thn_Akademik->QueryStringValue;
			} elseif (IsApi() && Key(0) !== NULL) {
				$this->Thn_Akademik->setQueryStringValue(Key(0));
				$this->RecKey["Thn_Akademik"] = $this->Thn_Akademik->QueryStringValue;
			} elseif (Post("Thn_Akademik") !== NULL) {
				$this->Thn_Akademik->setFormValue(Post("Thn_Akademik"));
				$this->RecKey["Thn_Akademik"] = $this->Thn_Akademik->FormValue;
			} elseif (IsApi() && Route(2) !== NULL) {
				$this->Thn_Akademik->setFormValue(Route(2));
				$this->RecKey["Thn_Akademik"] = $this->Thn_Akademik->FormValue;
			} else {
				$returnUrl = "RKP_AbsenDosenlist.php"; // Return to list
			}
			if (Get("Periode") !== NULL) {
				$this->Periode->setQueryStringValue(Get("Periode"));
				$this->RecKey["Periode"] = $this->Periode->QueryStringValue;
			} elseif (IsApi() && Key(1) !== NULL) {
				$this->Periode->setQueryStringValue(Key(1));
				$this->RecKey["Periode"] = $this->Periode->QueryStringValue;
			} elseif (Post("Periode") !== NULL) {
				$this->Periode->setFormValue(Post("Periode"));
				$this->RecKey["Periode"] = $this->Periode->FormValue;
			} elseif (IsApi() && Route(3) !== NULL) {
				$this->Periode->setFormValue(Route(3));
				$this->RecKey["Periode"] = $this->Periode->FormValue;
			} else {
				$returnUrl = "RKP_AbsenDosenlist.php"; // Return to list
			}
			if (Get("Kelas_Akd") !== NULL) {
				$this->Kelas_Akd->setQueryStringValue(Get("Kelas_Akd"));
				$this->RecKey["Kelas_Akd"] = $this->Kelas_Akd->QueryStringValue;
			} elseif (IsApi() && Key(2) !== NULL) {
				$this->Kelas_Akd->setQueryStringValue(Key(2));
				$this->RecKey["Kelas_Akd"] = $this->Kelas_Akd->QueryStringValue;
			} elseif (Post("Kelas_Akd") !== NULL) {
				$this->Kelas_Akd->setFormValue(Post("Kelas_Akd"));
				$this->RecKey["Kelas_Akd"] = $this->Kelas_Akd->FormValue;
			} elseif (IsApi() && Route(4) !== NULL) {
				$this->Kelas_Akd->setFormValue(Route(4));
				$this->RecKey["Kelas_Akd"] = $this->Kelas_Akd->FormValue;
			} else {
				$returnUrl = "RKP_AbsenDosenlist.php"; // Return to list
			}
			if (Get("Kode_Mk") !== NULL) {
				$this->Kode_Mk->setQueryStringValue(Get("Kode_Mk"));
				$this->RecKey["Kode_Mk"] = $this->Kode_Mk->QueryStringValue;
			} elseif (IsApi() && Key(3) !== NULL) {
				$this->Kode_Mk->setQueryStringValue(Key(3));
				$this->RecKey["Kode_Mk"] = $this->Kode_Mk->QueryStringValue;
			} elseif (Post("Kode_Mk") !== NULL) {
				$this->Kode_Mk->setFormValue(Post("Kode_Mk"));
				$this->RecKey["Kode_Mk"] = $this->Kode_Mk->FormValue;
			} elseif (IsApi() && Route(5) !== NULL) {
				$this->Kode_Mk->setFormValue(Route(5));
				$this->RecKey["Kode_Mk"] = $this->Kode_Mk->FormValue;
			} else {
				$returnUrl = "RKP_AbsenDosenlist.php"; // Return to list
			}
			if (Get("Kelas") !== NULL) {
				$this->Kelas->setQueryStringValue(Get("Kelas"));
				$this->RecKey["Kelas"] = $this->Kelas->QueryStringValue;
			} elseif (IsApi() && Key(4) !== NULL) {
				$this->Kelas->setQueryStringValue(Key(4));
				$this->RecKey["Kelas"] = $this->Kelas->QueryStringValue;
			} elseif (Post("Kelas") !== NULL) {
				$this->Kelas->setFormValue(Post("Kelas"));
				$this->RecKey["Kelas"] = $this->Kelas->FormValue;
			} elseif (IsApi() && Route(6) !== NULL) {
				$this->Kelas->setFormValue(Route(6));
				$this->RecKey["Kelas"] = $this->Kelas->FormValue;
			} else {
				$returnUrl = "RKP_AbsenDosenlist.php"; // Return to list
			}
			if (Get("NIDN") !== NULL) {
				$this->NIDN->setQueryStringValue(Get("NIDN"));
				$this->RecKey["NIDN"] = $this->NIDN->QueryStringValue;
			} elseif (IsApi() && Key(5) !== NULL) {
				$this->NIDN->setQueryStringValue(Key(5));
				$this->RecKey["NIDN"] = $this->NIDN->QueryStringValue;
			} elseif (Post("NIDN") !== NULL) {
				$this->NIDN->setFormValue(Post("NIDN"));
				$this->RecKey["NIDN"] = $this->NIDN->FormValue;
			} elseif (IsApi() && Route(7) !== NULL) {
				$this->NIDN->setFormValue(Route(7));
				$this->RecKey["NIDN"] = $this->NIDN->FormValue;
			} else {
				$returnUrl = "RKP_AbsenDosenlist.php"; // Return to list
			}
			if (Get("Pertemuan_ke") !== NULL) {
				$this->Pertemuan_ke->setQueryStringValue(Get("Pertemuan_ke"));
				$this->RecKey["Pertemuan_ke"] = $this->Pertemuan_ke->QueryStringValue;
			} elseif (IsApi() && Key(6) !== NULL) {
				$this->Pertemuan_ke->setQueryStringValue(Key(6));
				$this->RecKey["Pertemuan_ke"] = $this->Pertemuan_ke->QueryStringValue;
			} elseif (Post("Pertemuan_ke") !== NULL) {
				$this->Pertemuan_ke->setFormValue(Post("Pertemuan_ke"));
				$this->RecKey["Pertemuan_ke"] = $this->Pertemuan_ke->FormValue;
			} elseif (IsApi() && Route(8) !== NULL) {
				$this->Pertemuan_ke->setFormValue(Route(8));
				$this->RecKey["Pertemuan_ke"] = $this->Pertemuan_ke->FormValue;
			} else {
				$returnUrl = "RKP_AbsenDosenlist.php"; // Return to list
			}
			if (Get("Kode_Fak") !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Get("Kode_Fak"));
				$this->RecKey["Kode_Fak"] = $this->Kode_Fak->QueryStringValue;
			} elseif (IsApi() && Key(7) !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Key(7));
				$this->RecKey["Kode_Fak"] = $this->Kode_Fak->QueryStringValue;
			} elseif (Post("Kode_Fak") !== NULL) {
				$this->Kode_Fak->setFormValue(Post("Kode_Fak"));
				$this->RecKey["Kode_Fak"] = $this->Kode_Fak->FormValue;
			} elseif (IsApi() && Route(9) !== NULL) {
				$this->Kode_Fak->setFormValue(Route(9));
				$this->RecKey["Kode_Fak"] = $this->Kode_Fak->FormValue;
			} else {
				$returnUrl = "RKP_AbsenDosenlist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = $this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "RKP_AbsenDosenlist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "RKP_AbsenDosenlist.php"; // Not page request, return to list
		}
		if ($returnUrl != "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl != "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl != "" && $Security->canEdit());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl != "" && $Security->canDelete());

		// Set up action default
		$option = $options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Thn_Akademik->setDbValue($row['Thn_Akademik']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Kelas_Akd->setDbValue($row['Kelas_Akd']);
		$this->Kode_Mk->setDbValue($row['Kode_Mk']);
		$this->Kelas->setDbValue($row['Kelas']);
		$this->NIDN->setDbValue($row['NIDN']);
		$this->Pertemuan_ke->setDbValue($row['Pertemuan_ke']);
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Kode_Jp->setDbValue($row['Kode_Jp']);
		$this->Pengganti_ke->setDbValue($row['Pengganti_ke']);
		$this->Tanggal->setDbValue($row['Tanggal']);
		$this->JM->setDbValue($row['JM']);
		$this->JS->setDbValue($row['JS']);
		$this->PokokBahasan->setDbValue($row['PokokBahasan']);
		$this->SubPokokBahasan->setDbValue($row['SubPokokBahasan']);
		$this->Keterangan->setDbValue($row['Keterangan']);
		$this->Referensi->setDbValue($row['Referensi']);
		$this->BahanAjar->setDbValue($row['BahanAjar']);
		$this->BahanAjar2->setDbValue($row['BahanAjar2']);
		$this->BahanAjar3->setDbValue($row['BahanAjar3']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Thn_Akademik'] = NULL;
		$row['Periode'] = NULL;
		$row['Kelas_Akd'] = NULL;
		$row['Kode_Mk'] = NULL;
		$row['Kelas'] = NULL;
		$row['NIDN'] = NULL;
		$row['Pertemuan_ke'] = NULL;
		$row['Kode_Fak'] = NULL;
		$row['Kode_Jp'] = NULL;
		$row['Pengganti_ke'] = NULL;
		$row['Tanggal'] = NULL;
		$row['JM'] = NULL;
		$row['JS'] = NULL;
		$row['PokokBahasan'] = NULL;
		$row['SubPokokBahasan'] = NULL;
		$row['Keterangan'] = NULL;
		$row['Referensi'] = NULL;
		$row['BahanAjar'] = NULL;
		$row['BahanAjar2'] = NULL;
		$row['BahanAjar3'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Thn_Akademik
		// Periode
		// Kelas_Akd
		// Kode_Mk
		// Kelas
		// NIDN
		// Pertemuan_ke
		// Kode_Fak
		// Kode_Jp
		// Pengganti_ke
		// Tanggal
		// JM
		// JS
		// PokokBahasan
		// SubPokokBahasan
		// Keterangan
		// Referensi
		// BahanAjar
		// BahanAjar2
		// BahanAjar3

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Thn_Akademik
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
			$this->Thn_Akademik->ViewCustomAttributes = "";

			// Periode
			$this->Periode->ViewValue = $this->Periode->CurrentValue;
			$this->Periode->ViewCustomAttributes = "";

			// Kelas_Akd
			$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->CurrentValue;
			$this->Kelas_Akd->ViewCustomAttributes = "";

			// Kode_Mk
			$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
			$this->Kode_Mk->ViewCustomAttributes = "";

			// Kelas
			$this->Kelas->ViewValue = $this->Kelas->CurrentValue;
			$this->Kelas->ViewCustomAttributes = "";

			// NIDN
			$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
			$this->NIDN->ViewCustomAttributes = "";

			// Pertemuan_ke
			if (strval($this->Pertemuan_ke->CurrentValue) != "") {
				$this->Pertemuan_ke->ViewValue = $this->Pertemuan_ke->optionCaption($this->Pertemuan_ke->CurrentValue);
			} else {
				$this->Pertemuan_ke->ViewValue = NULL;
			}
			$this->Pertemuan_ke->ViewCustomAttributes = "";

			// Kode_Fak
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kode_Jp
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->ViewCustomAttributes = "";

			// Pengganti_ke
			$this->Pengganti_ke->ViewValue = $this->Pengganti_ke->CurrentValue;
			$this->Pengganti_ke->ViewCustomAttributes = "";

			// Tanggal
			$this->Tanggal->ViewValue = $this->Tanggal->CurrentValue;
			$this->Tanggal->ViewValue = FormatDateTime($this->Tanggal->ViewValue, 7);
			$this->Tanggal->ViewCustomAttributes = "";

			// JM
			$this->JM->ViewValue = $this->JM->CurrentValue;
			$this->JM->ViewValue = FormatDateTime($this->JM->ViewValue, 4);
			$this->JM->ViewCustomAttributes = "";

			// JS
			$this->JS->ViewValue = $this->JS->CurrentValue;
			$this->JS->ViewValue = FormatDateTime($this->JS->ViewValue, 4);
			$this->JS->ViewCustomAttributes = "";

			// PokokBahasan
			$this->PokokBahasan->ViewValue = $this->PokokBahasan->CurrentValue;
			$this->PokokBahasan->ViewCustomAttributes = "";

			// SubPokokBahasan
			$this->SubPokokBahasan->ViewValue = $this->SubPokokBahasan->CurrentValue;
			$this->SubPokokBahasan->ViewCustomAttributes = "";

			// Keterangan
			$this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;
			$this->Keterangan->ViewCustomAttributes = "";

			// Referensi
			$this->Referensi->ViewValue = $this->Referensi->CurrentValue;
			$this->Referensi->ViewCustomAttributes = "";

			// BahanAjar
			$this->BahanAjar->ViewValue = $this->BahanAjar->CurrentValue;
			$this->BahanAjar->ViewCustomAttributes = "";

			// BahanAjar2
			$this->BahanAjar2->ViewValue = $this->BahanAjar2->CurrentValue;
			$this->BahanAjar2->ViewCustomAttributes = "";

			// BahanAjar3
			$this->BahanAjar3->ViewValue = $this->BahanAjar3->CurrentValue;
			$this->BahanAjar3->ViewCustomAttributes = "";

			// Pertemuan_ke
			$this->Pertemuan_ke->LinkCustomAttributes = "";
			$this->Pertemuan_ke->HrefValue = "";
			$this->Pertemuan_ke->TooltipValue = "";

			// Tanggal
			$this->Tanggal->LinkCustomAttributes = "";
			$this->Tanggal->HrefValue = "";
			$this->Tanggal->TooltipValue = "";

			// JM
			$this->JM->LinkCustomAttributes = "";
			$this->JM->HrefValue = "";
			$this->JM->TooltipValue = "";

			// JS
			$this->JS->LinkCustomAttributes = "";
			$this->JS->HrefValue = "";
			$this->JS->TooltipValue = "";

			// PokokBahasan
			$this->PokokBahasan->LinkCustomAttributes = "";
			$this->PokokBahasan->HrefValue = "";
			$this->PokokBahasan->TooltipValue = "";

			// SubPokokBahasan
			$this->SubPokokBahasan->LinkCustomAttributes = "";
			$this->SubPokokBahasan->HrefValue = "";
			$this->SubPokokBahasan->TooltipValue = "";

			// Referensi
			$this->Referensi->LinkCustomAttributes = "";
			$this->Referensi->HrefValue = "";
			$this->Referensi->TooltipValue = "";

			// BahanAjar
			$this->BahanAjar->LinkCustomAttributes = "";
			$this->BahanAjar->HrefValue = "";
			$this->BahanAjar->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "Wali_JadkulMin") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Thn_Akademik", Get("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Thn_Akademik->setQueryStringValue($parm);
					$this->Thn_Akademik->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Thn_Akademik->QueryStringValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Periode", Get("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Periode->setQueryStringValue($parm);
					$this->Periode->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Periode->QueryStringValue);
					$this->Periode->setSessionValue($this->Periode->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas_Akd", Get("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas_Akd->setQueryStringValue($parm);
					$this->Kelas_Akd->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kelas_Akd->QueryStringValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Mk", Get("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Mk->setQueryStringValue($parm);
					$this->Kode_Mk->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kode_Mk->QueryStringValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas", Get("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas->setQueryStringValue($parm);
					$this->Kelas->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kelas->QueryStringValue);
					$this->Kelas->setSessionValue($this->Kelas->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_NIDN", Get("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->NIDN->setQueryStringValue($parm);
					$this->NIDN->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->NIDN->QueryStringValue);
					$this->NIDN->setSessionValue($this->NIDN->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Fak", Get("Kode_Fak"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Fak->setQueryStringValue($parm);
					$this->Kode_Fak->setQueryStringValue($GLOBALS["Wali_JadkulMin"]->Kode_Fak->QueryStringValue);
					$this->Kode_Fak->setSessionValue($this->Kode_Fak->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "Wali_JadkulMin") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Thn_Akademik", Post("Thn_Akademik"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Thn_Akademik->setFormValue($parm);
					$this->Thn_Akademik->setFormValue($GLOBALS["Wali_JadkulMin"]->Thn_Akademik->FormValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Periode", Post("Periode"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Periode->setFormValue($parm);
					$this->Periode->setFormValue($GLOBALS["Wali_JadkulMin"]->Periode->FormValue);
					$this->Periode->setSessionValue($this->Periode->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas_Akd", Post("Kelas_Akd"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas_Akd->setFormValue($parm);
					$this->Kelas_Akd->setFormValue($GLOBALS["Wali_JadkulMin"]->Kelas_Akd->FormValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Mk", Post("Kode_Mk"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Mk->setFormValue($parm);
					$this->Kode_Mk->setFormValue($GLOBALS["Wali_JadkulMin"]->Kode_Mk->FormValue);
					$this->Kode_Mk->setSessionValue($this->Kode_Mk->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas", Post("Kelas"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kelas->setFormValue($parm);
					$this->Kelas->setFormValue($GLOBALS["Wali_JadkulMin"]->Kelas->FormValue);
					$this->Kelas->setSessionValue($this->Kelas->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_NIDN", Post("NIDN"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->NIDN->setFormValue($parm);
					$this->NIDN->setFormValue($GLOBALS["Wali_JadkulMin"]->NIDN->FormValue);
					$this->NIDN->setSessionValue($this->NIDN->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Fak", Post("Kode_Fak"))) !== NULL) {
					$GLOBALS["Wali_JadkulMin"]->Kode_Fak->setFormValue($parm);
					$this->Kode_Fak->setFormValue($GLOBALS["Wali_JadkulMin"]->Kode_Fak->FormValue);
					$this->Kode_Fak->setSessionValue($this->Kode_Fak->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);
			$this->setSessionWhere($this->getDetailFilter());

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "Wali_JadkulMin") {
				if ($this->Thn_Akademik->CurrentValue == "")
					$this->Thn_Akademik->setSessionValue("");
				if ($this->Periode->CurrentValue == "")
					$this->Periode->setSessionValue("");
				if ($this->Kelas_Akd->CurrentValue == "")
					$this->Kelas_Akd->setSessionValue("");
				if ($this->Kode_Mk->CurrentValue == "")
					$this->Kode_Mk->setSessionValue("");
				if ($this->Kelas->CurrentValue == "")
					$this->Kelas->setSessionValue("");
				if ($this->NIDN->CurrentValue == "")
					$this->NIDN->setSessionValue("");
				if ($this->Kode_Fak->CurrentValue == "")
					$this->Kode_Fak->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("RKP_AbsenDosenlist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Pertemuan_ke":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
} // End class
?>