<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for TblJurusan
 */
class TblJurusan extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Kode_Jp;
	public $Kode_Fak;
	public $Jurusan;
	public $Dept;
	public $Program;
	public $GelarAkd;
	public $Singkatan_Gelar;
	public $No_Akreditas;
	public $Tgl_Akreditas;
	public $JenisSK;
	public $Kajur;
	public $NIPKAJUR;
	public $GelarinEnglish;
	public $KDJENDIK;
	public $KDPSDIK;
	public $Jenis;
	public $SingkatanPrody;
	public $Sidang;
	public $sksta;
	public $jmld;
	public $ipkta;
	public $skskp;
	public $SKSTPL;
	public $metlit;
	public $banptIjazah;
	public $Akreditasi;
	public $KNR;
	public $idprodi;
	public $MINSKS;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'TblJurusan';
		$this->TableName = 'TblJurusan';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[TblJurusan]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Kode_Jp
		$this->Kode_Jp = new DbField('TblJurusan', 'TblJurusan', 'x_Kode_Jp', 'Kode_Jp', '[Kode_Jp]', '[Kode_Jp]', 129, 4, -1, FALSE, '[Kode_Jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Jp->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Jp->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Jp->Nullable = FALSE; // NOT NULL field
		$this->Kode_Jp->Required = TRUE; // Required field
		$this->Kode_Jp->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Jp'] = &$this->Kode_Jp;

		// Kode_Fak
		$this->Kode_Fak = new DbField('TblJurusan', 'TblJurusan', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Jurusan
		$this->Jurusan = new DbField('TblJurusan', 'TblJurusan', 'x_Jurusan', 'Jurusan', '[Jurusan]', '[Jurusan]', 129, 27, -1, FALSE, '[Jurusan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jurusan->Sortable = TRUE; // Allow sort
		$this->fields['Jurusan'] = &$this->Jurusan;

		// Dept
		$this->Dept = new DbField('TblJurusan', 'TblJurusan', 'x_Dept', 'Dept', '[Dept]', '[Dept]', 129, 30, -1, FALSE, '[Dept]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Dept->Sortable = TRUE; // Allow sort
		$this->fields['Dept'] = &$this->Dept;

		// Program
		$this->Program = new DbField('TblJurusan', 'TblJurusan', 'x_Program', 'Program', '[Program]', '[Program]', 129, 2, -1, FALSE, '[Program]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Program->Sortable = TRUE; // Allow sort
		$this->fields['Program'] = &$this->Program;

		// GelarAkd
		$this->GelarAkd = new DbField('TblJurusan', 'TblJurusan', 'x_GelarAkd', 'GelarAkd', '[GelarAkd]', '[GelarAkd]', 129, 60, -1, FALSE, '[GelarAkd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->GelarAkd->Sortable = TRUE; // Allow sort
		$this->fields['GelarAkd'] = &$this->GelarAkd;

		// Singkatan_Gelar
		$this->Singkatan_Gelar = new DbField('TblJurusan', 'TblJurusan', 'x_Singkatan_Gelar', 'Singkatan_Gelar', '[Singkatan_Gelar]', '[Singkatan_Gelar]', 129, 10, -1, FALSE, '[Singkatan_Gelar]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Singkatan_Gelar->Sortable = TRUE; // Allow sort
		$this->fields['Singkatan_Gelar'] = &$this->Singkatan_Gelar;

		// No_Akreditas
		$this->No_Akreditas = new DbField('TblJurusan', 'TblJurusan', 'x_No_Akreditas', 'No_Akreditas', '[No_Akreditas]', '[No_Akreditas]', 129, 100, -1, FALSE, '[No_Akreditas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->No_Akreditas->Sortable = TRUE; // Allow sort
		$this->fields['No_Akreditas'] = &$this->No_Akreditas;

		// Tgl_Akreditas
		$this->Tgl_Akreditas = new DbField('TblJurusan', 'TblJurusan', 'x_Tgl_Akreditas', 'Tgl_Akreditas', '[Tgl_Akreditas]', CastDateFieldForLike("[Tgl_Akreditas]", 7, "DB"), 135, 8, 7, FALSE, '[Tgl_Akreditas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Akreditas->Sortable = TRUE; // Allow sort
		$this->Tgl_Akreditas->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['Tgl_Akreditas'] = &$this->Tgl_Akreditas;

		// JenisSK
		$this->JenisSK = new DbField('TblJurusan', 'TblJurusan', 'x_JenisSK', 'JenisSK', '[JenisSK]', '[JenisSK]', 129, 100, -1, FALSE, '[JenisSK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JenisSK->Sortable = TRUE; // Allow sort
		$this->fields['JenisSK'] = &$this->JenisSK;

		// Kajur
		$this->Kajur = new DbField('TblJurusan', 'TblJurusan', 'x_Kajur', 'Kajur', '[Kajur]', '[Kajur]', 129, 70, -1, FALSE, '[Kajur]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kajur->Sortable = TRUE; // Allow sort
		$this->fields['Kajur'] = &$this->Kajur;

		// NIPKAJUR
		$this->NIPKAJUR = new DbField('TblJurusan', 'TblJurusan', 'x_NIPKAJUR', 'NIPKAJUR', '[NIPKAJUR]', '[NIPKAJUR]', 129, 30, -1, FALSE, '[NIPKAJUR]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NIPKAJUR->Sortable = TRUE; // Allow sort
		$this->fields['NIPKAJUR'] = &$this->NIPKAJUR;

		// GelarinEnglish
		$this->GelarinEnglish = new DbField('TblJurusan', 'TblJurusan', 'x_GelarinEnglish', 'GelarinEnglish', '[GelarinEnglish]', '[GelarinEnglish]', 129, 60, -1, FALSE, '[GelarinEnglish]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->GelarinEnglish->Sortable = TRUE; // Allow sort
		$this->fields['GelarinEnglish'] = &$this->GelarinEnglish;

		// KDJENDIK
		$this->KDJENDIK = new DbField('TblJurusan', 'TblJurusan', 'x_KDJENDIK', 'KDJENDIK', '[KDJENDIK]', '[KDJENDIK]', 129, 1, -1, FALSE, '[KDJENDIK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KDJENDIK->Sortable = TRUE; // Allow sort
		$this->fields['KDJENDIK'] = &$this->KDJENDIK;

		// KDPSDIK
		$this->KDPSDIK = new DbField('TblJurusan', 'TblJurusan', 'x_KDPSDIK', 'KDPSDIK', '[KDPSDIK]', '[KDPSDIK]', 129, 5, -1, FALSE, '[KDPSDIK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KDPSDIK->Sortable = TRUE; // Allow sort
		$this->fields['KDPSDIK'] = &$this->KDPSDIK;

		// Jenis
		$this->Jenis = new DbField('TblJurusan', 'TblJurusan', 'x_Jenis', 'Jenis', '[Jenis]', '[Jenis]', 129, 20, -1, FALSE, '[Jenis]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jenis->Sortable = TRUE; // Allow sort
		$this->fields['Jenis'] = &$this->Jenis;

		// SingkatanPrody
		$this->SingkatanPrody = new DbField('TblJurusan', 'TblJurusan', 'x_SingkatanPrody', 'SingkatanPrody', '[SingkatanPrody]', '[SingkatanPrody]', 200, 4, -1, FALSE, '[SingkatanPrody]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SingkatanPrody->Sortable = TRUE; // Allow sort
		$this->fields['SingkatanPrody'] = &$this->SingkatanPrody;

		// Sidang
		$this->Sidang = new DbField('TblJurusan', 'TblJurusan', 'x_Sidang', 'Sidang', '[Sidang]', '[Sidang]', 200, 20, -1, FALSE, '[Sidang]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Sidang->Sortable = TRUE; // Allow sort
		$this->fields['Sidang'] = &$this->Sidang;

		// sksta
		$this->sksta = new DbField('TblJurusan', 'TblJurusan', 'x_sksta', 'sksta', '[sksta]', 'CAST([sksta] AS NVARCHAR)', 3, 4, -1, FALSE, '[sksta]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sksta->Sortable = TRUE; // Allow sort
		$this->sksta->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['sksta'] = &$this->sksta;

		// jmld
		$this->jmld = new DbField('TblJurusan', 'TblJurusan', 'x_jmld', 'jmld', '[jmld]', 'CAST([jmld] AS NVARCHAR)', 3, 4, -1, FALSE, '[jmld]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jmld->Sortable = TRUE; // Allow sort
		$this->jmld->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jmld'] = &$this->jmld;

		// ipkta
		$this->ipkta = new DbField('TblJurusan', 'TblJurusan', 'x_ipkta', 'ipkta', '[ipkta]', 'CAST([ipkta] AS NVARCHAR)', 5, 8, -1, FALSE, '[ipkta]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ipkta->Sortable = TRUE; // Allow sort
		$this->ipkta->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ipkta'] = &$this->ipkta;

		// skskp
		$this->skskp = new DbField('TblJurusan', 'TblJurusan', 'x_skskp', 'skskp', '[skskp]', 'CAST([skskp] AS NVARCHAR)', 3, 4, -1, FALSE, '[skskp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->skskp->Sortable = TRUE; // Allow sort
		$this->skskp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['skskp'] = &$this->skskp;

		// SKSTPL
		$this->SKSTPL = new DbField('TblJurusan', 'TblJurusan', 'x_SKSTPL', 'SKSTPL', '[SKSTPL]', 'CAST([SKSTPL] AS NVARCHAR)', 3, 4, -1, FALSE, '[SKSTPL]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SKSTPL->Sortable = TRUE; // Allow sort
		$this->SKSTPL->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['SKSTPL'] = &$this->SKSTPL;

		// metlit
		$this->metlit = new DbField('TblJurusan', 'TblJurusan', 'x_metlit', 'metlit', '[metlit]', '[metlit]', 200, 10, -1, FALSE, '[metlit]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->metlit->Sortable = TRUE; // Allow sort
		$this->fields['metlit'] = &$this->metlit;

		// banptIjazah
		$this->banptIjazah = new DbField('TblJurusan', 'TblJurusan', 'x_banptIjazah', 'banptIjazah', '[banptIjazah]', '[banptIjazah]', 200, 250, -1, FALSE, '[banptIjazah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->banptIjazah->Sortable = TRUE; // Allow sort
		$this->fields['banptIjazah'] = &$this->banptIjazah;

		// Akreditasi
		$this->Akreditasi = new DbField('TblJurusan', 'TblJurusan', 'x_Akreditasi', 'Akreditasi', '[Akreditasi]', '[Akreditasi]', 200, 5, -1, FALSE, '[Akreditasi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Akreditasi->Sortable = TRUE; // Allow sort
		$this->fields['Akreditasi'] = &$this->Akreditasi;

		// KNR
		$this->KNR = new DbField('TblJurusan', 'TblJurusan', 'x_KNR', 'KNR', '[KNR]', '[KNR]', 200, 70, -1, FALSE, '[KNR]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KNR->Sortable = TRUE; // Allow sort
		$this->fields['KNR'] = &$this->KNR;

		// idprodi
		$this->idprodi = new DbField('TblJurusan', 'TblJurusan', 'x_idprodi', 'idprodi', '[idprodi]', '[idprodi]', 200, 50, -1, FALSE, '[idprodi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idprodi->Sortable = TRUE; // Allow sort
		$this->fields['idprodi'] = &$this->idprodi;

		// MINSKS
		$this->MINSKS = new DbField('TblJurusan', 'TblJurusan', 'x_MINSKS', 'MINSKS', '[MINSKS]', 'CAST([MINSKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[MINSKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->MINSKS->Sortable = TRUE; // Allow sort
		$this->MINSKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['MINSKS'] = &$this->MINSKS;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "tblMk_PSmtr") {
			$detailUrl = $GLOBALS["tblMk_PSmtr"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Kode_Jp=" . urlencode($this->Kode_Jp->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "TblJurusanlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[TblJurusan]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Kode_Jp', $rs))
				AddFilter($where, QuotedName('Kode_Jp', $this->Dbid) . '=' . QuotedValue($rs['Kode_Jp'], $this->Kode_Jp->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Kode_Jp->DbValue = $row['Kode_Jp'];
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Jurusan->DbValue = $row['Jurusan'];
		$this->Dept->DbValue = $row['Dept'];
		$this->Program->DbValue = $row['Program'];
		$this->GelarAkd->DbValue = $row['GelarAkd'];
		$this->Singkatan_Gelar->DbValue = $row['Singkatan_Gelar'];
		$this->No_Akreditas->DbValue = $row['No_Akreditas'];
		$this->Tgl_Akreditas->DbValue = $row['Tgl_Akreditas'];
		$this->JenisSK->DbValue = $row['JenisSK'];
		$this->Kajur->DbValue = $row['Kajur'];
		$this->NIPKAJUR->DbValue = $row['NIPKAJUR'];
		$this->GelarinEnglish->DbValue = $row['GelarinEnglish'];
		$this->KDJENDIK->DbValue = $row['KDJENDIK'];
		$this->KDPSDIK->DbValue = $row['KDPSDIK'];
		$this->Jenis->DbValue = $row['Jenis'];
		$this->SingkatanPrody->DbValue = $row['SingkatanPrody'];
		$this->Sidang->DbValue = $row['Sidang'];
		$this->sksta->DbValue = $row['sksta'];
		$this->jmld->DbValue = $row['jmld'];
		$this->ipkta->DbValue = $row['ipkta'];
		$this->skskp->DbValue = $row['skskp'];
		$this->SKSTPL->DbValue = $row['SKSTPL'];
		$this->metlit->DbValue = $row['metlit'];
		$this->banptIjazah->DbValue = $row['banptIjazah'];
		$this->Akreditasi->DbValue = $row['Akreditasi'];
		$this->KNR->DbValue = $row['KNR'];
		$this->idprodi->DbValue = $row['idprodi'];
		$this->MINSKS->DbValue = $row['MINSKS'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Kode_Jp] = '@Kode_Jp@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Kode_Jp', $row) ? $row['Kode_Jp'] : NULL;
		else
			$val = $this->Kode_Jp->OldValue !== NULL ? $this->Kode_Jp->OldValue : $this->Kode_Jp->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Jp@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "TblJurusanlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "TblJurusanview.php")
			return $Language->phrase("View");
		elseif ($pageName == "TblJurusanedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "TblJurusanadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "TblJurusanlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("TblJurusanview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("TblJurusanview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "TblJurusanadd.php?" . $this->getUrlParm($parm);
		else
			$url = "TblJurusanadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("TblJurusanedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("TblJurusanedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("TblJurusanadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("TblJurusanadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("TblJurusandelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Kode_Jp:" . JsonEncode($this->Kode_Jp->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Kode_Jp->CurrentValue != NULL) {
			$url .= "Kode_Jp=" . urlencode($this->Kode_Jp->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("Kode_Jp") !== NULL)
				$arKeys[] = Param("Kode_Jp");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Kode_Jp->CurrentValue = $key;
			else
				$this->Kode_Jp->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Kode_Jp->setDbValue($rs->fields('Kode_Jp'));
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Jurusan->setDbValue($rs->fields('Jurusan'));
		$this->Dept->setDbValue($rs->fields('Dept'));
		$this->Program->setDbValue($rs->fields('Program'));
		$this->GelarAkd->setDbValue($rs->fields('GelarAkd'));
		$this->Singkatan_Gelar->setDbValue($rs->fields('Singkatan_Gelar'));
		$this->No_Akreditas->setDbValue($rs->fields('No_Akreditas'));
		$this->Tgl_Akreditas->setDbValue($rs->fields('Tgl_Akreditas'));
		$this->JenisSK->setDbValue($rs->fields('JenisSK'));
		$this->Kajur->setDbValue($rs->fields('Kajur'));
		$this->NIPKAJUR->setDbValue($rs->fields('NIPKAJUR'));
		$this->GelarinEnglish->setDbValue($rs->fields('GelarinEnglish'));
		$this->KDJENDIK->setDbValue($rs->fields('KDJENDIK'));
		$this->KDPSDIK->setDbValue($rs->fields('KDPSDIK'));
		$this->Jenis->setDbValue($rs->fields('Jenis'));
		$this->SingkatanPrody->setDbValue($rs->fields('SingkatanPrody'));
		$this->Sidang->setDbValue($rs->fields('Sidang'));
		$this->sksta->setDbValue($rs->fields('sksta'));
		$this->jmld->setDbValue($rs->fields('jmld'));
		$this->ipkta->setDbValue($rs->fields('ipkta'));
		$this->skskp->setDbValue($rs->fields('skskp'));
		$this->SKSTPL->setDbValue($rs->fields('SKSTPL'));
		$this->metlit->setDbValue($rs->fields('metlit'));
		$this->banptIjazah->setDbValue($rs->fields('banptIjazah'));
		$this->Akreditasi->setDbValue($rs->fields('Akreditasi'));
		$this->KNR->setDbValue($rs->fields('KNR'));
		$this->idprodi->setDbValue($rs->fields('idprodi'));
		$this->MINSKS->setDbValue($rs->fields('MINSKS'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Kode_Jp
		// Kode_Fak
		// Jurusan
		// Dept
		// Program
		// GelarAkd
		// Singkatan_Gelar
		// No_Akreditas
		// Tgl_Akreditas
		// JenisSK
		// Kajur
		// NIPKAJUR
		// GelarinEnglish
		// KDJENDIK
		// KDPSDIK
		// Jenis
		// SingkatanPrody
		// Sidang
		// sksta
		// jmld
		// ipkta
		// skskp
		// SKSTPL
		// metlit
		// banptIjazah
		// Akreditasi
		// KNR
		// idprodi
		// MINSKS
		// Kode_Jp

		$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
		$this->Kode_Jp->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Jurusan
		$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->ViewCustomAttributes = "";

		// Dept
		$this->Dept->ViewValue = $this->Dept->CurrentValue;
		$this->Dept->ViewCustomAttributes = "";

		// Program
		$this->Program->ViewValue = $this->Program->CurrentValue;
		$this->Program->ViewCustomAttributes = "";

		// GelarAkd
		$this->GelarAkd->ViewValue = $this->GelarAkd->CurrentValue;
		$this->GelarAkd->ViewCustomAttributes = "";

		// Singkatan_Gelar
		$this->Singkatan_Gelar->ViewValue = $this->Singkatan_Gelar->CurrentValue;
		$this->Singkatan_Gelar->ViewCustomAttributes = "";

		// No_Akreditas
		$this->No_Akreditas->ViewValue = $this->No_Akreditas->CurrentValue;
		$this->No_Akreditas->ViewCustomAttributes = "";

		// Tgl_Akreditas
		$this->Tgl_Akreditas->ViewValue = $this->Tgl_Akreditas->CurrentValue;
		$this->Tgl_Akreditas->ViewValue = FormatDateTime($this->Tgl_Akreditas->ViewValue, 7);
		$this->Tgl_Akreditas->ViewCustomAttributes = "";

		// JenisSK
		$this->JenisSK->ViewValue = $this->JenisSK->CurrentValue;
		$this->JenisSK->ViewCustomAttributes = "";

		// Kajur
		$this->Kajur->ViewValue = $this->Kajur->CurrentValue;
		$this->Kajur->ViewCustomAttributes = "";

		// NIPKAJUR
		$this->NIPKAJUR->ViewValue = $this->NIPKAJUR->CurrentValue;
		$this->NIPKAJUR->ViewCustomAttributes = "";

		// GelarinEnglish
		$this->GelarinEnglish->ViewValue = $this->GelarinEnglish->CurrentValue;
		$this->GelarinEnglish->ViewCustomAttributes = "";

		// KDJENDIK
		$this->KDJENDIK->ViewValue = $this->KDJENDIK->CurrentValue;
		$this->KDJENDIK->ViewCustomAttributes = "";

		// KDPSDIK
		$this->KDPSDIK->ViewValue = $this->KDPSDIK->CurrentValue;
		$this->KDPSDIK->ViewCustomAttributes = "";

		// Jenis
		$this->Jenis->ViewValue = $this->Jenis->CurrentValue;
		$this->Jenis->ViewCustomAttributes = "";

		// SingkatanPrody
		$this->SingkatanPrody->ViewValue = $this->SingkatanPrody->CurrentValue;
		$this->SingkatanPrody->ViewCustomAttributes = "";

		// Sidang
		$this->Sidang->ViewValue = $this->Sidang->CurrentValue;
		$this->Sidang->ViewCustomAttributes = "";

		// sksta
		$this->sksta->ViewValue = $this->sksta->CurrentValue;
		$this->sksta->ViewValue = FormatNumber($this->sksta->ViewValue, 0, -2, -2, -2);
		$this->sksta->ViewCustomAttributes = "";

		// jmld
		$this->jmld->ViewValue = $this->jmld->CurrentValue;
		$this->jmld->ViewValue = FormatNumber($this->jmld->ViewValue, 0, -2, -2, -2);
		$this->jmld->ViewCustomAttributes = "";

		// ipkta
		$this->ipkta->ViewValue = $this->ipkta->CurrentValue;
		$this->ipkta->ViewValue = FormatNumber($this->ipkta->ViewValue, 2, -2, -2, -2);
		$this->ipkta->ViewCustomAttributes = "";

		// skskp
		$this->skskp->ViewValue = $this->skskp->CurrentValue;
		$this->skskp->ViewValue = FormatNumber($this->skskp->ViewValue, 0, -2, -2, -2);
		$this->skskp->ViewCustomAttributes = "";

		// SKSTPL
		$this->SKSTPL->ViewValue = $this->SKSTPL->CurrentValue;
		$this->SKSTPL->ViewValue = FormatNumber($this->SKSTPL->ViewValue, 0, -2, -2, -2);
		$this->SKSTPL->ViewCustomAttributes = "";

		// metlit
		$this->metlit->ViewValue = $this->metlit->CurrentValue;
		$this->metlit->ViewCustomAttributes = "";

		// banptIjazah
		$this->banptIjazah->ViewValue = $this->banptIjazah->CurrentValue;
		$this->banptIjazah->ViewCustomAttributes = "";

		// Akreditasi
		$this->Akreditasi->ViewValue = $this->Akreditasi->CurrentValue;
		$this->Akreditasi->ViewCustomAttributes = "";

		// KNR
		$this->KNR->ViewValue = $this->KNR->CurrentValue;
		$this->KNR->ViewCustomAttributes = "";

		// idprodi
		$this->idprodi->ViewValue = $this->idprodi->CurrentValue;
		$this->idprodi->ViewCustomAttributes = "";

		// MINSKS
		$this->MINSKS->ViewValue = $this->MINSKS->CurrentValue;
		$this->MINSKS->ViewValue = FormatNumber($this->MINSKS->ViewValue, 0, -2, -2, -2);
		$this->MINSKS->ViewCustomAttributes = "";

		// Kode_Jp
		$this->Kode_Jp->LinkCustomAttributes = "";
		$this->Kode_Jp->HrefValue = "";
		$this->Kode_Jp->TooltipValue = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Jurusan
		$this->Jurusan->LinkCustomAttributes = "";
		$this->Jurusan->HrefValue = "";
		$this->Jurusan->TooltipValue = "";

		// Dept
		$this->Dept->LinkCustomAttributes = "";
		$this->Dept->HrefValue = "";
		$this->Dept->TooltipValue = "";

		// Program
		$this->Program->LinkCustomAttributes = "";
		$this->Program->HrefValue = "";
		$this->Program->TooltipValue = "";

		// GelarAkd
		$this->GelarAkd->LinkCustomAttributes = "";
		$this->GelarAkd->HrefValue = "";
		$this->GelarAkd->TooltipValue = "";

		// Singkatan_Gelar
		$this->Singkatan_Gelar->LinkCustomAttributes = "";
		$this->Singkatan_Gelar->HrefValue = "";
		$this->Singkatan_Gelar->TooltipValue = "";

		// No_Akreditas
		$this->No_Akreditas->LinkCustomAttributes = "";
		$this->No_Akreditas->HrefValue = "";
		$this->No_Akreditas->TooltipValue = "";

		// Tgl_Akreditas
		$this->Tgl_Akreditas->LinkCustomAttributes = "";
		$this->Tgl_Akreditas->HrefValue = "";
		$this->Tgl_Akreditas->TooltipValue = "";

		// JenisSK
		$this->JenisSK->LinkCustomAttributes = "";
		$this->JenisSK->HrefValue = "";
		$this->JenisSK->TooltipValue = "";

		// Kajur
		$this->Kajur->LinkCustomAttributes = "";
		$this->Kajur->HrefValue = "";
		$this->Kajur->TooltipValue = "";

		// NIPKAJUR
		$this->NIPKAJUR->LinkCustomAttributes = "";
		$this->NIPKAJUR->HrefValue = "";
		$this->NIPKAJUR->TooltipValue = "";

		// GelarinEnglish
		$this->GelarinEnglish->LinkCustomAttributes = "";
		$this->GelarinEnglish->HrefValue = "";
		$this->GelarinEnglish->TooltipValue = "";

		// KDJENDIK
		$this->KDJENDIK->LinkCustomAttributes = "";
		$this->KDJENDIK->HrefValue = "";
		$this->KDJENDIK->TooltipValue = "";

		// KDPSDIK
		$this->KDPSDIK->LinkCustomAttributes = "";
		$this->KDPSDIK->HrefValue = "";
		$this->KDPSDIK->TooltipValue = "";

		// Jenis
		$this->Jenis->LinkCustomAttributes = "";
		$this->Jenis->HrefValue = "";
		$this->Jenis->TooltipValue = "";

		// SingkatanPrody
		$this->SingkatanPrody->LinkCustomAttributes = "";
		$this->SingkatanPrody->HrefValue = "";
		$this->SingkatanPrody->TooltipValue = "";

		// Sidang
		$this->Sidang->LinkCustomAttributes = "";
		$this->Sidang->HrefValue = "";
		$this->Sidang->TooltipValue = "";

		// sksta
		$this->sksta->LinkCustomAttributes = "";
		$this->sksta->HrefValue = "";
		$this->sksta->TooltipValue = "";

		// jmld
		$this->jmld->LinkCustomAttributes = "";
		$this->jmld->HrefValue = "";
		$this->jmld->TooltipValue = "";

		// ipkta
		$this->ipkta->LinkCustomAttributes = "";
		$this->ipkta->HrefValue = "";
		$this->ipkta->TooltipValue = "";

		// skskp
		$this->skskp->LinkCustomAttributes = "";
		$this->skskp->HrefValue = "";
		$this->skskp->TooltipValue = "";

		// SKSTPL
		$this->SKSTPL->LinkCustomAttributes = "";
		$this->SKSTPL->HrefValue = "";
		$this->SKSTPL->TooltipValue = "";

		// metlit
		$this->metlit->LinkCustomAttributes = "";
		$this->metlit->HrefValue = "";
		$this->metlit->TooltipValue = "";

		// banptIjazah
		$this->banptIjazah->LinkCustomAttributes = "";
		$this->banptIjazah->HrefValue = "";
		$this->banptIjazah->TooltipValue = "";

		// Akreditasi
		$this->Akreditasi->LinkCustomAttributes = "";
		$this->Akreditasi->HrefValue = "";
		$this->Akreditasi->TooltipValue = "";

		// KNR
		$this->KNR->LinkCustomAttributes = "";
		$this->KNR->HrefValue = "";
		$this->KNR->TooltipValue = "";

		// idprodi
		$this->idprodi->LinkCustomAttributes = "";
		$this->idprodi->HrefValue = "";
		$this->idprodi->TooltipValue = "";

		// MINSKS
		$this->MINSKS->LinkCustomAttributes = "";
		$this->MINSKS->HrefValue = "";
		$this->MINSKS->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Kode_Jp
		$this->Kode_Jp->EditAttrs["class"] = "form-control";
		$this->Kode_Jp->EditCustomAttributes = "";
		$this->Kode_Jp->EditValue = $this->Kode_Jp->CurrentValue;
		$this->Kode_Jp->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";
		$this->Kode_Fak->EditValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Jurusan
		$this->Jurusan->EditAttrs["class"] = "form-control";
		$this->Jurusan->EditCustomAttributes = "";
		$this->Jurusan->EditValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->ViewCustomAttributes = "";

		// Dept
		$this->Dept->EditAttrs["class"] = "form-control";
		$this->Dept->EditCustomAttributes = "";
		$this->Dept->EditValue = $this->Dept->CurrentValue;
		$this->Dept->ViewCustomAttributes = "";

		// Program
		$this->Program->EditAttrs["class"] = "form-control";
		$this->Program->EditCustomAttributes = "";
		$this->Program->EditValue = $this->Program->CurrentValue;
		$this->Program->ViewCustomAttributes = "";

		// GelarAkd
		$this->GelarAkd->EditAttrs["class"] = "form-control";
		$this->GelarAkd->EditCustomAttributes = "";
		if (!$this->GelarAkd->Raw)
			$this->GelarAkd->CurrentValue = HtmlDecode($this->GelarAkd->CurrentValue);
		$this->GelarAkd->EditValue = $this->GelarAkd->CurrentValue;
		$this->GelarAkd->PlaceHolder = RemoveHtml($this->GelarAkd->caption());

		// Singkatan_Gelar
		$this->Singkatan_Gelar->EditAttrs["class"] = "form-control";
		$this->Singkatan_Gelar->EditCustomAttributes = "";
		if (!$this->Singkatan_Gelar->Raw)
			$this->Singkatan_Gelar->CurrentValue = HtmlDecode($this->Singkatan_Gelar->CurrentValue);
		$this->Singkatan_Gelar->EditValue = $this->Singkatan_Gelar->CurrentValue;
		$this->Singkatan_Gelar->PlaceHolder = RemoveHtml($this->Singkatan_Gelar->caption());

		// No_Akreditas
		$this->No_Akreditas->EditAttrs["class"] = "form-control";
		$this->No_Akreditas->EditCustomAttributes = "";
		if (!$this->No_Akreditas->Raw)
			$this->No_Akreditas->CurrentValue = HtmlDecode($this->No_Akreditas->CurrentValue);
		$this->No_Akreditas->EditValue = $this->No_Akreditas->CurrentValue;
		$this->No_Akreditas->PlaceHolder = RemoveHtml($this->No_Akreditas->caption());

		// Tgl_Akreditas
		$this->Tgl_Akreditas->EditAttrs["class"] = "form-control";
		$this->Tgl_Akreditas->EditCustomAttributes = "";
		$this->Tgl_Akreditas->EditValue = FormatDateTime($this->Tgl_Akreditas->CurrentValue, 7);
		$this->Tgl_Akreditas->PlaceHolder = RemoveHtml($this->Tgl_Akreditas->caption());

		// JenisSK
		$this->JenisSK->EditAttrs["class"] = "form-control";
		$this->JenisSK->EditCustomAttributes = "";
		if (!$this->JenisSK->Raw)
			$this->JenisSK->CurrentValue = HtmlDecode($this->JenisSK->CurrentValue);
		$this->JenisSK->EditValue = $this->JenisSK->CurrentValue;
		$this->JenisSK->PlaceHolder = RemoveHtml($this->JenisSK->caption());

		// Kajur
		$this->Kajur->EditAttrs["class"] = "form-control";
		$this->Kajur->EditCustomAttributes = "";
		if (!$this->Kajur->Raw)
			$this->Kajur->CurrentValue = HtmlDecode($this->Kajur->CurrentValue);
		$this->Kajur->EditValue = $this->Kajur->CurrentValue;
		$this->Kajur->PlaceHolder = RemoveHtml($this->Kajur->caption());

		// NIPKAJUR
		$this->NIPKAJUR->EditAttrs["class"] = "form-control";
		$this->NIPKAJUR->EditCustomAttributes = "";
		if (!$this->NIPKAJUR->Raw)
			$this->NIPKAJUR->CurrentValue = HtmlDecode($this->NIPKAJUR->CurrentValue);
		$this->NIPKAJUR->EditValue = $this->NIPKAJUR->CurrentValue;
		$this->NIPKAJUR->PlaceHolder = RemoveHtml($this->NIPKAJUR->caption());

		// GelarinEnglish
		$this->GelarinEnglish->EditAttrs["class"] = "form-control";
		$this->GelarinEnglish->EditCustomAttributes = "";
		if (!$this->GelarinEnglish->Raw)
			$this->GelarinEnglish->CurrentValue = HtmlDecode($this->GelarinEnglish->CurrentValue);
		$this->GelarinEnglish->EditValue = $this->GelarinEnglish->CurrentValue;
		$this->GelarinEnglish->PlaceHolder = RemoveHtml($this->GelarinEnglish->caption());

		// KDJENDIK
		$this->KDJENDIK->EditAttrs["class"] = "form-control";
		$this->KDJENDIK->EditCustomAttributes = "";
		if (!$this->KDJENDIK->Raw)
			$this->KDJENDIK->CurrentValue = HtmlDecode($this->KDJENDIK->CurrentValue);
		$this->KDJENDIK->EditValue = $this->KDJENDIK->CurrentValue;
		$this->KDJENDIK->PlaceHolder = RemoveHtml($this->KDJENDIK->caption());

		// KDPSDIK
		$this->KDPSDIK->EditAttrs["class"] = "form-control";
		$this->KDPSDIK->EditCustomAttributes = "";
		if (!$this->KDPSDIK->Raw)
			$this->KDPSDIK->CurrentValue = HtmlDecode($this->KDPSDIK->CurrentValue);
		$this->KDPSDIK->EditValue = $this->KDPSDIK->CurrentValue;
		$this->KDPSDIK->PlaceHolder = RemoveHtml($this->KDPSDIK->caption());

		// Jenis
		$this->Jenis->EditAttrs["class"] = "form-control";
		$this->Jenis->EditCustomAttributes = "";
		if (!$this->Jenis->Raw)
			$this->Jenis->CurrentValue = HtmlDecode($this->Jenis->CurrentValue);
		$this->Jenis->EditValue = $this->Jenis->CurrentValue;
		$this->Jenis->PlaceHolder = RemoveHtml($this->Jenis->caption());

		// SingkatanPrody
		$this->SingkatanPrody->EditAttrs["class"] = "form-control";
		$this->SingkatanPrody->EditCustomAttributes = "";
		if (!$this->SingkatanPrody->Raw)
			$this->SingkatanPrody->CurrentValue = HtmlDecode($this->SingkatanPrody->CurrentValue);
		$this->SingkatanPrody->EditValue = $this->SingkatanPrody->CurrentValue;
		$this->SingkatanPrody->PlaceHolder = RemoveHtml($this->SingkatanPrody->caption());

		// Sidang
		$this->Sidang->EditAttrs["class"] = "form-control";
		$this->Sidang->EditCustomAttributes = "";
		if (!$this->Sidang->Raw)
			$this->Sidang->CurrentValue = HtmlDecode($this->Sidang->CurrentValue);
		$this->Sidang->EditValue = $this->Sidang->CurrentValue;
		$this->Sidang->PlaceHolder = RemoveHtml($this->Sidang->caption());

		// sksta
		$this->sksta->EditAttrs["class"] = "form-control";
		$this->sksta->EditCustomAttributes = "";
		$this->sksta->EditValue = $this->sksta->CurrentValue;
		$this->sksta->PlaceHolder = RemoveHtml($this->sksta->caption());

		// jmld
		$this->jmld->EditAttrs["class"] = "form-control";
		$this->jmld->EditCustomAttributes = "";
		$this->jmld->EditValue = $this->jmld->CurrentValue;
		$this->jmld->PlaceHolder = RemoveHtml($this->jmld->caption());

		// ipkta
		$this->ipkta->EditAttrs["class"] = "form-control";
		$this->ipkta->EditCustomAttributes = "";
		$this->ipkta->EditValue = $this->ipkta->CurrentValue;
		$this->ipkta->PlaceHolder = RemoveHtml($this->ipkta->caption());
		if (strval($this->ipkta->EditValue) != "" && is_numeric($this->ipkta->EditValue))
			$this->ipkta->EditValue = FormatNumber($this->ipkta->EditValue, -2, -2, -2, -2);
		

		// skskp
		$this->skskp->EditAttrs["class"] = "form-control";
		$this->skskp->EditCustomAttributes = "";
		$this->skskp->EditValue = $this->skskp->CurrentValue;
		$this->skskp->PlaceHolder = RemoveHtml($this->skskp->caption());

		// SKSTPL
		$this->SKSTPL->EditAttrs["class"] = "form-control";
		$this->SKSTPL->EditCustomAttributes = "";
		$this->SKSTPL->EditValue = $this->SKSTPL->CurrentValue;
		$this->SKSTPL->PlaceHolder = RemoveHtml($this->SKSTPL->caption());

		// metlit
		$this->metlit->EditAttrs["class"] = "form-control";
		$this->metlit->EditCustomAttributes = "";
		if (!$this->metlit->Raw)
			$this->metlit->CurrentValue = HtmlDecode($this->metlit->CurrentValue);
		$this->metlit->EditValue = $this->metlit->CurrentValue;
		$this->metlit->PlaceHolder = RemoveHtml($this->metlit->caption());

		// banptIjazah
		$this->banptIjazah->EditAttrs["class"] = "form-control";
		$this->banptIjazah->EditCustomAttributes = "";
		if (!$this->banptIjazah->Raw)
			$this->banptIjazah->CurrentValue = HtmlDecode($this->banptIjazah->CurrentValue);
		$this->banptIjazah->EditValue = $this->banptIjazah->CurrentValue;
		$this->banptIjazah->PlaceHolder = RemoveHtml($this->banptIjazah->caption());

		// Akreditasi
		$this->Akreditasi->EditAttrs["class"] = "form-control";
		$this->Akreditasi->EditCustomAttributes = "";
		if (!$this->Akreditasi->Raw)
			$this->Akreditasi->CurrentValue = HtmlDecode($this->Akreditasi->CurrentValue);
		$this->Akreditasi->EditValue = $this->Akreditasi->CurrentValue;
		$this->Akreditasi->PlaceHolder = RemoveHtml($this->Akreditasi->caption());

		// KNR
		$this->KNR->EditAttrs["class"] = "form-control";
		$this->KNR->EditCustomAttributes = "";
		if (!$this->KNR->Raw)
			$this->KNR->CurrentValue = HtmlDecode($this->KNR->CurrentValue);
		$this->KNR->EditValue = $this->KNR->CurrentValue;
		$this->KNR->PlaceHolder = RemoveHtml($this->KNR->caption());

		// idprodi
		$this->idprodi->EditAttrs["class"] = "form-control";
		$this->idprodi->EditCustomAttributes = "";
		if (!$this->idprodi->Raw)
			$this->idprodi->CurrentValue = HtmlDecode($this->idprodi->CurrentValue);
		$this->idprodi->EditValue = $this->idprodi->CurrentValue;
		$this->idprodi->PlaceHolder = RemoveHtml($this->idprodi->caption());

		// MINSKS
		$this->MINSKS->EditAttrs["class"] = "form-control";
		$this->MINSKS->EditCustomAttributes = "";
		$this->MINSKS->EditValue = $this->MINSKS->CurrentValue;
		$this->MINSKS->PlaceHolder = RemoveHtml($this->MINSKS->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Dept);
					$doc->exportCaption($this->Program);
					$doc->exportCaption($this->GelarAkd);
					$doc->exportCaption($this->Singkatan_Gelar);
					$doc->exportCaption($this->No_Akreditas);
					$doc->exportCaption($this->Tgl_Akreditas);
					$doc->exportCaption($this->Kajur);
					$doc->exportCaption($this->NIPKAJUR);
					$doc->exportCaption($this->GelarinEnglish);
					$doc->exportCaption($this->KDJENDIK);
					$doc->exportCaption($this->KDPSDIK);
					$doc->exportCaption($this->Jenis);
					$doc->exportCaption($this->SingkatanPrody);
					$doc->exportCaption($this->Sidang);
					$doc->exportCaption($this->sksta);
					$doc->exportCaption($this->jmld);
					$doc->exportCaption($this->ipkta);
					$doc->exportCaption($this->skskp);
					$doc->exportCaption($this->SKSTPL);
					$doc->exportCaption($this->metlit);
					$doc->exportCaption($this->banptIjazah);
					$doc->exportCaption($this->Akreditasi);
					$doc->exportCaption($this->KNR);
					$doc->exportCaption($this->idprodi);
					$doc->exportCaption($this->MINSKS);
				} else {
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Dept);
					$doc->exportCaption($this->Program);
					$doc->exportCaption($this->GelarAkd);
					$doc->exportCaption($this->Singkatan_Gelar);
					$doc->exportCaption($this->No_Akreditas);
					$doc->exportCaption($this->Tgl_Akreditas);
					$doc->exportCaption($this->JenisSK);
					$doc->exportCaption($this->Kajur);
					$doc->exportCaption($this->NIPKAJUR);
					$doc->exportCaption($this->GelarinEnglish);
					$doc->exportCaption($this->KDJENDIK);
					$doc->exportCaption($this->KDPSDIK);
					$doc->exportCaption($this->Jenis);
					$doc->exportCaption($this->SingkatanPrody);
					$doc->exportCaption($this->Sidang);
					$doc->exportCaption($this->sksta);
					$doc->exportCaption($this->jmld);
					$doc->exportCaption($this->ipkta);
					$doc->exportCaption($this->skskp);
					$doc->exportCaption($this->SKSTPL);
					$doc->exportCaption($this->metlit);
					$doc->exportCaption($this->banptIjazah);
					$doc->exportCaption($this->Akreditasi);
					$doc->exportCaption($this->KNR);
					$doc->exportCaption($this->idprodi);
					$doc->exportCaption($this->MINSKS);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Dept);
						$doc->exportField($this->Program);
						$doc->exportField($this->GelarAkd);
						$doc->exportField($this->Singkatan_Gelar);
						$doc->exportField($this->No_Akreditas);
						$doc->exportField($this->Tgl_Akreditas);
						$doc->exportField($this->Kajur);
						$doc->exportField($this->NIPKAJUR);
						$doc->exportField($this->GelarinEnglish);
						$doc->exportField($this->KDJENDIK);
						$doc->exportField($this->KDPSDIK);
						$doc->exportField($this->Jenis);
						$doc->exportField($this->SingkatanPrody);
						$doc->exportField($this->Sidang);
						$doc->exportField($this->sksta);
						$doc->exportField($this->jmld);
						$doc->exportField($this->ipkta);
						$doc->exportField($this->skskp);
						$doc->exportField($this->SKSTPL);
						$doc->exportField($this->metlit);
						$doc->exportField($this->banptIjazah);
						$doc->exportField($this->Akreditasi);
						$doc->exportField($this->KNR);
						$doc->exportField($this->idprodi);
						$doc->exportField($this->MINSKS);
					} else {
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Dept);
						$doc->exportField($this->Program);
						$doc->exportField($this->GelarAkd);
						$doc->exportField($this->Singkatan_Gelar);
						$doc->exportField($this->No_Akreditas);
						$doc->exportField($this->Tgl_Akreditas);
						$doc->exportField($this->JenisSK);
						$doc->exportField($this->Kajur);
						$doc->exportField($this->NIPKAJUR);
						$doc->exportField($this->GelarinEnglish);
						$doc->exportField($this->KDJENDIK);
						$doc->exportField($this->KDPSDIK);
						$doc->exportField($this->Jenis);
						$doc->exportField($this->SingkatanPrody);
						$doc->exportField($this->Sidang);
						$doc->exportField($this->sksta);
						$doc->exportField($this->jmld);
						$doc->exportField($this->ipkta);
						$doc->exportField($this->skskp);
						$doc->exportField($this->SKSTPL);
						$doc->exportField($this->metlit);
						$doc->exportField($this->banptIjazah);
						$doc->exportField($this->Akreditasi);
						$doc->exportField($this->KNR);
						$doc->exportField($this->idprodi);
						$doc->exportField($this->MINSKS);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>