<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class TblJurusan_view extends TblJurusan
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'TblJurusan';

	// Page object name
	public $PageObjName = "TblJurusan_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (TblJurusan)
		if (!isset($GLOBALS["TblJurusan"]) || get_class($GLOBALS["TblJurusan"]) == PROJECT_NAMESPACE . "TblJurusan") {
			$GLOBALS["TblJurusan"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["TblJurusan"];
		}
		$keyUrl = "";
		if (Get("Kode_Jp") !== NULL) {
			$this->RecKey["Kode_Jp"] = Get("Kode_Jp");
			$keyUrl .= "&amp;Kode_Jp=" . urlencode($this->RecKey["Kode_Jp"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'TblJurusan');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $TblJurusan;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($TblJurusan);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "TblJurusanview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Kode_Jp'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecords = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $RecKey = [];
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canView()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("TblJurusanlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Kode_Jp->setVisibility();
		$this->Kode_Fak->setVisibility();
		$this->Jurusan->setVisibility();
		$this->Dept->setVisibility();
		$this->Program->setVisibility();
		$this->GelarAkd->setVisibility();
		$this->Singkatan_Gelar->setVisibility();
		$this->No_Akreditas->setVisibility();
		$this->Tgl_Akreditas->setVisibility();
		$this->JenisSK->setVisibility();
		$this->Kajur->setVisibility();
		$this->NIPKAJUR->setVisibility();
		$this->GelarinEnglish->setVisibility();
		$this->KDJENDIK->setVisibility();
		$this->KDPSDIK->setVisibility();
		$this->Jenis->setVisibility();
		$this->SingkatanPrody->setVisibility();
		$this->Sidang->setVisibility();
		$this->sksta->setVisibility();
		$this->jmld->setVisibility();
		$this->ipkta->setVisibility();
		$this->skskp->setVisibility();
		$this->SKSTPL->setVisibility();
		$this->metlit->setVisibility();
		$this->banptIjazah->setVisibility();
		$this->Akreditasi->setVisibility();
		$this->KNR->setVisibility();
		$this->idprodi->setVisibility();
		$this->MINSKS->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check permission

		if (!$Security->canView()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("TblJurusanlist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("Kode_Jp") !== NULL) {
				$this->Kode_Jp->setQueryStringValue(Get("Kode_Jp"));
				$this->RecKey["Kode_Jp"] = $this->Kode_Jp->QueryStringValue;
			} elseif (IsApi() && Key(0) !== NULL) {
				$this->Kode_Jp->setQueryStringValue(Key(0));
				$this->RecKey["Kode_Jp"] = $this->Kode_Jp->QueryStringValue;
			} elseif (Post("Kode_Jp") !== NULL) {
				$this->Kode_Jp->setFormValue(Post("Kode_Jp"));
				$this->RecKey["Kode_Jp"] = $this->Kode_Jp->FormValue;
			} elseif (IsApi() && Route(2) !== NULL) {
				$this->Kode_Jp->setFormValue(Route(2));
				$this->RecKey["Kode_Jp"] = $this->Kode_Jp->FormValue;
			} else {
				$returnUrl = "TblJurusanlist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = $this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "TblJurusanlist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "TblJurusanlist.php"; // Not page request, return to list
		}
		if ($returnUrl != "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Set up detail parameters
		$this->setupDetailParms();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl != "" && $Security->canEdit());
		$option = $options["detail"];
		$detailTableLink = "";
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail_tblMk_PSmtr"
		$item = &$option->add("detail_tblMk_PSmtr");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("tblMk_PSmtr", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("tblMk_PSmtrlist.php?" . Config("TABLE_SHOW_MASTER") . "=TblJurusan&fk_Kode_Jp=" . urlencode(strval($this->Kode_Jp->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["tblMk_PSmtr_grid"]))
			$GLOBALS["tblMk_PSmtr_grid"] = new tblMk_PSmtr_grid();
		if ($GLOBALS["tblMk_PSmtr_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'TblJurusan')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=tblMk_PSmtr")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar != "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "tblMk_PSmtr";
		}
		if ($GLOBALS["tblMk_PSmtr_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'TblJurusan')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=tblMk_PSmtr")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar != "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "tblMk_PSmtr";
		}
		if ($links != "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'tblMk_PSmtr');
		if ($item->Visible) {
			if ($detailTableLink != "")
				$detailTableLink .= ",";
			$detailTableLink .= "tblMk_PSmtr";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$item = &$option->add("details");
			$item->Body = $body;
		}

		// Set up detail default
		$option = $options["detail"];
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$ar = explode(",", $detailTableLink);
		$cnt = count($ar);
		$option->UseDropDownButton = ($cnt > 1);
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up action default
		$option = $options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Kode_Jp->setDbValue($row['Kode_Jp']);
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Jurusan->setDbValue($row['Jurusan']);
		$this->Dept->setDbValue($row['Dept']);
		$this->Program->setDbValue($row['Program']);
		$this->GelarAkd->setDbValue($row['GelarAkd']);
		$this->Singkatan_Gelar->setDbValue($row['Singkatan_Gelar']);
		$this->No_Akreditas->setDbValue($row['No_Akreditas']);
		$this->Tgl_Akreditas->setDbValue($row['Tgl_Akreditas']);
		$this->JenisSK->setDbValue($row['JenisSK']);
		$this->Kajur->setDbValue($row['Kajur']);
		$this->NIPKAJUR->setDbValue($row['NIPKAJUR']);
		$this->GelarinEnglish->setDbValue($row['GelarinEnglish']);
		$this->KDJENDIK->setDbValue($row['KDJENDIK']);
		$this->KDPSDIK->setDbValue($row['KDPSDIK']);
		$this->Jenis->setDbValue($row['Jenis']);
		$this->SingkatanPrody->setDbValue($row['SingkatanPrody']);
		$this->Sidang->setDbValue($row['Sidang']);
		$this->sksta->setDbValue($row['sksta']);
		$this->jmld->setDbValue($row['jmld']);
		$this->ipkta->setDbValue($row['ipkta']);
		$this->skskp->setDbValue($row['skskp']);
		$this->SKSTPL->setDbValue($row['SKSTPL']);
		$this->metlit->setDbValue($row['metlit']);
		$this->banptIjazah->setDbValue($row['banptIjazah']);
		$this->Akreditasi->setDbValue($row['Akreditasi']);
		$this->KNR->setDbValue($row['KNR']);
		$this->idprodi->setDbValue($row['idprodi']);
		$this->MINSKS->setDbValue($row['MINSKS']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Kode_Jp'] = NULL;
		$row['Kode_Fak'] = NULL;
		$row['Jurusan'] = NULL;
		$row['Dept'] = NULL;
		$row['Program'] = NULL;
		$row['GelarAkd'] = NULL;
		$row['Singkatan_Gelar'] = NULL;
		$row['No_Akreditas'] = NULL;
		$row['Tgl_Akreditas'] = NULL;
		$row['JenisSK'] = NULL;
		$row['Kajur'] = NULL;
		$row['NIPKAJUR'] = NULL;
		$row['GelarinEnglish'] = NULL;
		$row['KDJENDIK'] = NULL;
		$row['KDPSDIK'] = NULL;
		$row['Jenis'] = NULL;
		$row['SingkatanPrody'] = NULL;
		$row['Sidang'] = NULL;
		$row['sksta'] = NULL;
		$row['jmld'] = NULL;
		$row['ipkta'] = NULL;
		$row['skskp'] = NULL;
		$row['SKSTPL'] = NULL;
		$row['metlit'] = NULL;
		$row['banptIjazah'] = NULL;
		$row['Akreditasi'] = NULL;
		$row['KNR'] = NULL;
		$row['idprodi'] = NULL;
		$row['MINSKS'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->ipkta->FormValue == $this->ipkta->CurrentValue && is_numeric(ConvertToFloatString($this->ipkta->CurrentValue)))
			$this->ipkta->CurrentValue = ConvertToFloatString($this->ipkta->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Kode_Jp
		// Kode_Fak
		// Jurusan
		// Dept
		// Program
		// GelarAkd
		// Singkatan_Gelar
		// No_Akreditas
		// Tgl_Akreditas
		// JenisSK
		// Kajur
		// NIPKAJUR
		// GelarinEnglish
		// KDJENDIK
		// KDPSDIK
		// Jenis
		// SingkatanPrody
		// Sidang
		// sksta
		// jmld
		// ipkta
		// skskp
		// SKSTPL
		// metlit
		// banptIjazah
		// Akreditasi
		// KNR
		// idprodi
		// MINSKS

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Kode_Jp
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->ViewCustomAttributes = "";

			// Kode_Fak
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Jurusan
			$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
			$this->Jurusan->ViewCustomAttributes = "";

			// Dept
			$this->Dept->ViewValue = $this->Dept->CurrentValue;
			$this->Dept->ViewCustomAttributes = "";

			// Program
			$this->Program->ViewValue = $this->Program->CurrentValue;
			$this->Program->ViewCustomAttributes = "";

			// GelarAkd
			$this->GelarAkd->ViewValue = $this->GelarAkd->CurrentValue;
			$this->GelarAkd->ViewCustomAttributes = "";

			// Singkatan_Gelar
			$this->Singkatan_Gelar->ViewValue = $this->Singkatan_Gelar->CurrentValue;
			$this->Singkatan_Gelar->ViewCustomAttributes = "";

			// No_Akreditas
			$this->No_Akreditas->ViewValue = $this->No_Akreditas->CurrentValue;
			$this->No_Akreditas->ViewCustomAttributes = "";

			// Tgl_Akreditas
			$this->Tgl_Akreditas->ViewValue = $this->Tgl_Akreditas->CurrentValue;
			$this->Tgl_Akreditas->ViewValue = FormatDateTime($this->Tgl_Akreditas->ViewValue, 7);
			$this->Tgl_Akreditas->ViewCustomAttributes = "";

			// JenisSK
			$this->JenisSK->ViewValue = $this->JenisSK->CurrentValue;
			$this->JenisSK->ViewCustomAttributes = "";

			// Kajur
			$this->Kajur->ViewValue = $this->Kajur->CurrentValue;
			$this->Kajur->ViewCustomAttributes = "";

			// NIPKAJUR
			$this->NIPKAJUR->ViewValue = $this->NIPKAJUR->CurrentValue;
			$this->NIPKAJUR->ViewCustomAttributes = "";

			// GelarinEnglish
			$this->GelarinEnglish->ViewValue = $this->GelarinEnglish->CurrentValue;
			$this->GelarinEnglish->ViewCustomAttributes = "";

			// KDJENDIK
			$this->KDJENDIK->ViewValue = $this->KDJENDIK->CurrentValue;
			$this->KDJENDIK->ViewCustomAttributes = "";

			// KDPSDIK
			$this->KDPSDIK->ViewValue = $this->KDPSDIK->CurrentValue;
			$this->KDPSDIK->ViewCustomAttributes = "";

			// Jenis
			$this->Jenis->ViewValue = $this->Jenis->CurrentValue;
			$this->Jenis->ViewCustomAttributes = "";

			// SingkatanPrody
			$this->SingkatanPrody->ViewValue = $this->SingkatanPrody->CurrentValue;
			$this->SingkatanPrody->ViewCustomAttributes = "";

			// Sidang
			$this->Sidang->ViewValue = $this->Sidang->CurrentValue;
			$this->Sidang->ViewCustomAttributes = "";

			// sksta
			$this->sksta->ViewValue = $this->sksta->CurrentValue;
			$this->sksta->ViewValue = FormatNumber($this->sksta->ViewValue, 0, -2, -2, -2);
			$this->sksta->ViewCustomAttributes = "";

			// jmld
			$this->jmld->ViewValue = $this->jmld->CurrentValue;
			$this->jmld->ViewValue = FormatNumber($this->jmld->ViewValue, 0, -2, -2, -2);
			$this->jmld->ViewCustomAttributes = "";

			// ipkta
			$this->ipkta->ViewValue = $this->ipkta->CurrentValue;
			$this->ipkta->ViewValue = FormatNumber($this->ipkta->ViewValue, 2, -2, -2, -2);
			$this->ipkta->ViewCustomAttributes = "";

			// skskp
			$this->skskp->ViewValue = $this->skskp->CurrentValue;
			$this->skskp->ViewValue = FormatNumber($this->skskp->ViewValue, 0, -2, -2, -2);
			$this->skskp->ViewCustomAttributes = "";

			// SKSTPL
			$this->SKSTPL->ViewValue = $this->SKSTPL->CurrentValue;
			$this->SKSTPL->ViewValue = FormatNumber($this->SKSTPL->ViewValue, 0, -2, -2, -2);
			$this->SKSTPL->ViewCustomAttributes = "";

			// metlit
			$this->metlit->ViewValue = $this->metlit->CurrentValue;
			$this->metlit->ViewCustomAttributes = "";

			// banptIjazah
			$this->banptIjazah->ViewValue = $this->banptIjazah->CurrentValue;
			$this->banptIjazah->ViewCustomAttributes = "";

			// Akreditasi
			$this->Akreditasi->ViewValue = $this->Akreditasi->CurrentValue;
			$this->Akreditasi->ViewCustomAttributes = "";

			// KNR
			$this->KNR->ViewValue = $this->KNR->CurrentValue;
			$this->KNR->ViewCustomAttributes = "";

			// idprodi
			$this->idprodi->ViewValue = $this->idprodi->CurrentValue;
			$this->idprodi->ViewCustomAttributes = "";

			// MINSKS
			$this->MINSKS->ViewValue = $this->MINSKS->CurrentValue;
			$this->MINSKS->ViewValue = FormatNumber($this->MINSKS->ViewValue, 0, -2, -2, -2);
			$this->MINSKS->ViewCustomAttributes = "";

			// Kode_Jp
			$this->Kode_Jp->LinkCustomAttributes = "";
			$this->Kode_Jp->HrefValue = "";
			$this->Kode_Jp->TooltipValue = "";

			// Jurusan
			$this->Jurusan->LinkCustomAttributes = "";
			$this->Jurusan->HrefValue = "";
			$this->Jurusan->TooltipValue = "";

			// Dept
			$this->Dept->LinkCustomAttributes = "";
			$this->Dept->HrefValue = "";
			$this->Dept->TooltipValue = "";

			// Program
			$this->Program->LinkCustomAttributes = "";
			$this->Program->HrefValue = "";
			$this->Program->TooltipValue = "";

			// GelarAkd
			$this->GelarAkd->LinkCustomAttributes = "";
			$this->GelarAkd->HrefValue = "";
			$this->GelarAkd->TooltipValue = "";

			// Singkatan_Gelar
			$this->Singkatan_Gelar->LinkCustomAttributes = "";
			$this->Singkatan_Gelar->HrefValue = "";
			$this->Singkatan_Gelar->TooltipValue = "";

			// No_Akreditas
			$this->No_Akreditas->LinkCustomAttributes = "";
			$this->No_Akreditas->HrefValue = "";
			$this->No_Akreditas->TooltipValue = "";

			// Tgl_Akreditas
			$this->Tgl_Akreditas->LinkCustomAttributes = "";
			$this->Tgl_Akreditas->HrefValue = "";
			$this->Tgl_Akreditas->TooltipValue = "";

			// Kajur
			$this->Kajur->LinkCustomAttributes = "";
			$this->Kajur->HrefValue = "";
			$this->Kajur->TooltipValue = "";

			// NIPKAJUR
			$this->NIPKAJUR->LinkCustomAttributes = "";
			$this->NIPKAJUR->HrefValue = "";
			$this->NIPKAJUR->TooltipValue = "";

			// GelarinEnglish
			$this->GelarinEnglish->LinkCustomAttributes = "";
			$this->GelarinEnglish->HrefValue = "";
			$this->GelarinEnglish->TooltipValue = "";

			// KDJENDIK
			$this->KDJENDIK->LinkCustomAttributes = "";
			$this->KDJENDIK->HrefValue = "";
			$this->KDJENDIK->TooltipValue = "";

			// KDPSDIK
			$this->KDPSDIK->LinkCustomAttributes = "";
			$this->KDPSDIK->HrefValue = "";
			$this->KDPSDIK->TooltipValue = "";

			// Jenis
			$this->Jenis->LinkCustomAttributes = "";
			$this->Jenis->HrefValue = "";
			$this->Jenis->TooltipValue = "";

			// SingkatanPrody
			$this->SingkatanPrody->LinkCustomAttributes = "";
			$this->SingkatanPrody->HrefValue = "";
			$this->SingkatanPrody->TooltipValue = "";

			// Sidang
			$this->Sidang->LinkCustomAttributes = "";
			$this->Sidang->HrefValue = "";
			$this->Sidang->TooltipValue = "";

			// sksta
			$this->sksta->LinkCustomAttributes = "";
			$this->sksta->HrefValue = "";
			$this->sksta->TooltipValue = "";

			// jmld
			$this->jmld->LinkCustomAttributes = "";
			$this->jmld->HrefValue = "";
			$this->jmld->TooltipValue = "";

			// ipkta
			$this->ipkta->LinkCustomAttributes = "";
			$this->ipkta->HrefValue = "";
			$this->ipkta->TooltipValue = "";

			// skskp
			$this->skskp->LinkCustomAttributes = "";
			$this->skskp->HrefValue = "";
			$this->skskp->TooltipValue = "";

			// SKSTPL
			$this->SKSTPL->LinkCustomAttributes = "";
			$this->SKSTPL->HrefValue = "";
			$this->SKSTPL->TooltipValue = "";

			// metlit
			$this->metlit->LinkCustomAttributes = "";
			$this->metlit->HrefValue = "";
			$this->metlit->TooltipValue = "";

			// banptIjazah
			$this->banptIjazah->LinkCustomAttributes = "";
			$this->banptIjazah->HrefValue = "";
			$this->banptIjazah->TooltipValue = "";

			// Akreditasi
			$this->Akreditasi->LinkCustomAttributes = "";
			$this->Akreditasi->HrefValue = "";
			$this->Akreditasi->TooltipValue = "";

			// KNR
			$this->KNR->LinkCustomAttributes = "";
			$this->KNR->HrefValue = "";
			$this->KNR->TooltipValue = "";

			// idprodi
			$this->idprodi->LinkCustomAttributes = "";
			$this->idprodi->HrefValue = "";
			$this->idprodi->TooltipValue = "";

			// MINSKS
			$this->MINSKS->LinkCustomAttributes = "";
			$this->MINSKS->HrefValue = "";
			$this->MINSKS->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("tblMk_PSmtr", $detailTblVar)) {
				if (!isset($GLOBALS["tblMk_PSmtr_grid"]))
					$GLOBALS["tblMk_PSmtr_grid"] = new tblMk_PSmtr_grid();
				if ($GLOBALS["tblMk_PSmtr_grid"]->DetailView) {
					$GLOBALS["tblMk_PSmtr_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["tblMk_PSmtr_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["tblMk_PSmtr_grid"]->setStartRecordNumber(1);
					$GLOBALS["tblMk_PSmtr_grid"]->Kode_Jp->IsDetailKey = TRUE;
					$GLOBALS["tblMk_PSmtr_grid"]->Kode_Jp->CurrentValue = $this->Kode_Jp->CurrentValue;
					$GLOBALS["tblMk_PSmtr_grid"]->Kode_Jp->setSessionValue($GLOBALS["tblMk_PSmtr_grid"]->Kode_Jp->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("TblJurusanlist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
} // End class
?>