<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for VJadwalKuliah
 */
class VJadwalKuliah extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Thn_Akademik;
	public $Periode;
	public $Kelas_Akd;
	public $Kode_Jp;
	public $Kode_Mk;
	public $Matakuliah;
	public $Tanggal;
	public $SKS;
	public $Kelas;
	public $Hari;
	public $JM;
	public $JS;
	public $NIDN;
	public $NIDN1;
	public $Kode_Ruangan;
	public $Ruang;
	public $Kapasitas;
	public $Jenis;
	public $Kode_Fak;
	public $id_feedkelas;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'VJadwalKuliah';
		$this->TableName = 'VJadwalKuliah';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[VJadwalKuliah]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Thn_Akademik
		$this->Thn_Akademik = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Thn_Akademik', 'Thn_Akademik', '[Thn_Akademik]', '[Thn_Akademik]', 129, 9, -1, FALSE, '[Thn_Akademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Thn_Akademik->IsPrimaryKey = TRUE; // Primary key field
		$this->Thn_Akademik->IsForeignKey = TRUE; // Foreign key field
		$this->Thn_Akademik->Nullable = FALSE; // NOT NULL field
		$this->Thn_Akademik->Required = TRUE; // Required field
		$this->Thn_Akademik->Sortable = TRUE; // Allow sort
		$this->Thn_Akademik->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Thn_Akademik->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Thn_Akademik->Lookup = new Lookup('Thn_Akademik', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Thn_Akademik'] = &$this->Thn_Akademik;

		// Periode
		$this->Periode = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 129, 3, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Periode->IsPrimaryKey = TRUE; // Primary key field
		$this->Periode->IsForeignKey = TRUE; // Foreign key field
		$this->Periode->Nullable = FALSE; // NOT NULL field
		$this->Periode->Required = TRUE; // Required field
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->Periode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Periode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Periode->Lookup = new Lookup('Periode', 'VJadwalKuliah', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Periode->OptionCount = 4;
		$this->fields['Periode'] = &$this->Periode;

		// Kelas_Akd
		$this->Kelas_Akd = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Kelas_Akd', 'Kelas_Akd', '[Kelas_Akd]', '[Kelas_Akd]', 129, 15, -1, FALSE, '[Kelas_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kelas_Akd->IsPrimaryKey = TRUE; // Primary key field
		$this->Kelas_Akd->IsForeignKey = TRUE; // Foreign key field
		$this->Kelas_Akd->Nullable = FALSE; // NOT NULL field
		$this->Kelas_Akd->Required = TRUE; // Required field
		$this->Kelas_Akd->Sortable = TRUE; // Allow sort
		$this->Kelas_Akd->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kelas_Akd->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kelas_Akd->Lookup = new Lookup('Kelas_Akd', 'tblkelas', FALSE, 'Kelas', ["Kelas","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kelas_Akd'] = &$this->Kelas_Akd;

		// Kode_Jp
		$this->Kode_Jp = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Kode_Jp', 'Kode_Jp', '[Kode_Jp]', '[Kode_Jp]', 129, 4, -1, FALSE, '[Kode_Jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Jp->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Jp->Nullable = FALSE; // NOT NULL field
		$this->Kode_Jp->Required = TRUE; // Required field
		$this->Kode_Jp->Sortable = TRUE; // Allow sort
		$this->Kode_Jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Jp->Lookup = new Lookup('Kode_Jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Program","Jurusan","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Jp'] = &$this->Kode_Jp;

		// Kode_Mk
		$this->Kode_Mk = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Kode_Mk', 'Kode_Mk', '[Kode_Mk]', '[Kode_Mk]', 129, 14, -1, FALSE, '[Kode_Mk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Mk->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Mk->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Mk->Nullable = FALSE; // NOT NULL field
		$this->Kode_Mk->Required = TRUE; // Required field
		$this->Kode_Mk->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Mk'] = &$this->Kode_Mk;

		// Matakuliah
		$this->Matakuliah = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Matakuliah', 'Matakuliah', '[Matakuliah]', '[Matakuliah]', 129, 40, -1, FALSE, '[Matakuliah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Matakuliah->Sortable = TRUE; // Allow sort
		$this->fields['Matakuliah'] = &$this->Matakuliah;

		// Tanggal
		$this->Tanggal = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Tanggal', 'Tanggal', '[Tanggal]', CastDateFieldForLike("[Tanggal]", 0, "DB"), 135, 8, 0, FALSE, '[Tanggal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tanggal->Sortable = TRUE; // Allow sort
		$this->Tanggal->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['Tanggal'] = &$this->Tanggal;

		// SKS
		$this->SKS = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_SKS', 'SKS', '[SKS]', 'CAST([SKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[SKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SKS->Sortable = TRUE; // Allow sort
		$this->SKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['SKS'] = &$this->SKS;

		// Kelas
		$this->Kelas = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Kelas', 'Kelas', '[Kelas]', '[Kelas]', 129, 10, -1, FALSE, '[Kelas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kelas->IsPrimaryKey = TRUE; // Primary key field
		$this->Kelas->Nullable = FALSE; // NOT NULL field
		$this->Kelas->Required = TRUE; // Required field
		$this->Kelas->Sortable = TRUE; // Allow sort
		$this->fields['Kelas'] = &$this->Kelas;

		// Hari
		$this->Hari = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Hari', 'Hari', '[Hari]', '[Hari]', 129, 6, -1, FALSE, '[Hari]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Hari->Sortable = TRUE; // Allow sort
		$this->fields['Hari'] = &$this->Hari;

		// JM
		$this->JM = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_JM', 'JM', '[JM]', CastDateFieldForLike("[JM]", 0, "DB"), 135, 8, 0, FALSE, '[JM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JM->Sortable = TRUE; // Allow sort
		$this->JM->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['JM'] = &$this->JM;

		// JS
		$this->JS = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_JS', 'JS', '[JS]', CastDateFieldForLike("[JS]", 0, "DB"), 135, 8, 0, FALSE, '[JS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JS->Sortable = TRUE; // Allow sort
		$this->JS->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['JS'] = &$this->JS;

		// NIDN
		$this->NIDN = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_NIDN', 'NIDN', '[NIDN]', '[NIDN]', 129, 14, -1, FALSE, '[NIDN]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->NIDN->Sortable = TRUE; // Allow sort
		$this->NIDN->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->NIDN->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->NIDN->Lookup = new Lookup('NIDN', 'tblDosen', FALSE, 'NIDN', ["NIDN","Nama","",""], [], [], [], [], [], [], '', '');
		$this->fields['NIDN'] = &$this->NIDN;

		// NIDN1
		$this->NIDN1 = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_NIDN1', 'NIDN1', '[NIDN1]', '[NIDN1]', 129, 14, -1, FALSE, '[NIDN1]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->NIDN1->Sortable = TRUE; // Allow sort
		$this->NIDN1->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->NIDN1->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->NIDN1->Lookup = new Lookup('NIDN1', 'tblDosen', FALSE, 'NIDN', ["NIDN","Nama","",""], [], [], [], [], [], [], '', '');
		$this->fields['NIDN1'] = &$this->NIDN1;

		// Kode_Ruangan
		$this->Kode_Ruangan = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Kode_Ruangan', 'Kode_Ruangan', '[Kode_Ruangan]', '[Kode_Ruangan]', 129, 2, -1, FALSE, '[Kode_Ruangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Ruangan->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Ruangan'] = &$this->Kode_Ruangan;

		// Ruang
		$this->Ruang = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Ruang', 'Ruang', '[Ruang]', '[Ruang]', 129, 20, -1, FALSE, '[Ruang]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ruang->Sortable = TRUE; // Allow sort
		$this->fields['Ruang'] = &$this->Ruang;

		// Kapasitas
		$this->Kapasitas = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Kapasitas', 'Kapasitas', '[Kapasitas]', 'CAST([Kapasitas] AS NVARCHAR)', 3, 4, -1, FALSE, '[Kapasitas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kapasitas->Sortable = TRUE; // Allow sort
		$this->Kapasitas->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Kapasitas'] = &$this->Kapasitas;

		// Jenis
		$this->Jenis = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Jenis', 'Jenis', '[Jenis]', '[Jenis]', 129, 15, -1, FALSE, '[Jenis]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jenis->IsPrimaryKey = TRUE; // Primary key field
		$this->Jenis->Nullable = FALSE; // NOT NULL field
		$this->Jenis->Required = TRUE; // Required field
		$this->Jenis->Sortable = TRUE; // Allow sort
		$this->fields['Jenis'] = &$this->Jenis;

		// Kode_Fak
		$this->Kode_Fak = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// id_feedkelas
		$this->id_feedkelas = new DbField('VJadwalKuliah', 'VJadwalKuliah', 'x_id_feedkelas', 'id_feedkelas', '[id_feedkelas]', '[id_feedkelas]', 200, 50, -1, FALSE, '[id_feedkelas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_feedkelas->Sortable = TRUE; // Allow sort
		$this->fields['id_feedkelas'] = &$this->id_feedkelas;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "V_NilaiMhs") {
			$detailUrl = $GLOBALS["V_NilaiMhs"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
			$detailUrl .= "&fk_Periode=" . urlencode($this->Periode->CurrentValue);
			$detailUrl .= "&fk_Kelas_Akd=" . urlencode($this->Kelas_Akd->CurrentValue);
			$detailUrl .= "&fk_Kode_Mk=" . urlencode($this->Kode_Mk->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "VJadwalKuliahlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[VJadwalKuliah]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Thn_Akademik', $rs))
				AddFilter($where, QuotedName('Thn_Akademik', $this->Dbid) . '=' . QuotedValue($rs['Thn_Akademik'], $this->Thn_Akademik->DataType, $this->Dbid));
			if (array_key_exists('Periode', $rs))
				AddFilter($where, QuotedName('Periode', $this->Dbid) . '=' . QuotedValue($rs['Periode'], $this->Periode->DataType, $this->Dbid));
			if (array_key_exists('Kelas_Akd', $rs))
				AddFilter($where, QuotedName('Kelas_Akd', $this->Dbid) . '=' . QuotedValue($rs['Kelas_Akd'], $this->Kelas_Akd->DataType, $this->Dbid));
			if (array_key_exists('Kode_Jp', $rs))
				AddFilter($where, QuotedName('Kode_Jp', $this->Dbid) . '=' . QuotedValue($rs['Kode_Jp'], $this->Kode_Jp->DataType, $this->Dbid));
			if (array_key_exists('Kode_Mk', $rs))
				AddFilter($where, QuotedName('Kode_Mk', $this->Dbid) . '=' . QuotedValue($rs['Kode_Mk'], $this->Kode_Mk->DataType, $this->Dbid));
			if (array_key_exists('Kelas', $rs))
				AddFilter($where, QuotedName('Kelas', $this->Dbid) . '=' . QuotedValue($rs['Kelas'], $this->Kelas->DataType, $this->Dbid));
			if (array_key_exists('Jenis', $rs))
				AddFilter($where, QuotedName('Jenis', $this->Dbid) . '=' . QuotedValue($rs['Jenis'], $this->Jenis->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Thn_Akademik->DbValue = $row['Thn_Akademik'];
		$this->Periode->DbValue = $row['Periode'];
		$this->Kelas_Akd->DbValue = $row['Kelas_Akd'];
		$this->Kode_Jp->DbValue = $row['Kode_Jp'];
		$this->Kode_Mk->DbValue = $row['Kode_Mk'];
		$this->Matakuliah->DbValue = $row['Matakuliah'];
		$this->Tanggal->DbValue = $row['Tanggal'];
		$this->SKS->DbValue = $row['SKS'];
		$this->Kelas->DbValue = $row['Kelas'];
		$this->Hari->DbValue = $row['Hari'];
		$this->JM->DbValue = $row['JM'];
		$this->JS->DbValue = $row['JS'];
		$this->NIDN->DbValue = $row['NIDN'];
		$this->NIDN1->DbValue = $row['NIDN1'];
		$this->Kode_Ruangan->DbValue = $row['Kode_Ruangan'];
		$this->Ruang->DbValue = $row['Ruang'];
		$this->Kapasitas->DbValue = $row['Kapasitas'];
		$this->Jenis->DbValue = $row['Jenis'];
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->id_feedkelas->DbValue = $row['id_feedkelas'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Thn_Akademik] = '@Thn_Akademik@' AND [Periode] = '@Periode@' AND [Kelas_Akd] = '@Kelas_Akd@' AND [Kode_Jp] = '@Kode_Jp@' AND [Kode_Mk] = '@Kode_Mk@' AND [Kelas] = '@Kelas@' AND [Jenis] = '@Jenis@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Thn_Akademik', $row) ? $row['Thn_Akademik'] : NULL;
		else
			$val = $this->Thn_Akademik->OldValue !== NULL ? $this->Thn_Akademik->OldValue : $this->Thn_Akademik->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Thn_Akademik@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Periode', $row) ? $row['Periode'] : NULL;
		else
			$val = $this->Periode->OldValue !== NULL ? $this->Periode->OldValue : $this->Periode->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Periode@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kelas_Akd', $row) ? $row['Kelas_Akd'] : NULL;
		else
			$val = $this->Kelas_Akd->OldValue !== NULL ? $this->Kelas_Akd->OldValue : $this->Kelas_Akd->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kelas_Akd@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kode_Jp', $row) ? $row['Kode_Jp'] : NULL;
		else
			$val = $this->Kode_Jp->OldValue !== NULL ? $this->Kode_Jp->OldValue : $this->Kode_Jp->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Jp@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kode_Mk', $row) ? $row['Kode_Mk'] : NULL;
		else
			$val = $this->Kode_Mk->OldValue !== NULL ? $this->Kode_Mk->OldValue : $this->Kode_Mk->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Mk@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kelas', $row) ? $row['Kelas'] : NULL;
		else
			$val = $this->Kelas->OldValue !== NULL ? $this->Kelas->OldValue : $this->Kelas->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kelas@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Jenis', $row) ? $row['Jenis'] : NULL;
		else
			$val = $this->Jenis->OldValue !== NULL ? $this->Jenis->OldValue : $this->Jenis->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Jenis@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "VJadwalKuliahlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "VJadwalKuliahview.php")
			return $Language->phrase("View");
		elseif ($pageName == "VJadwalKuliahedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "VJadwalKuliahadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "VJadwalKuliahlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("VJadwalKuliahview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("VJadwalKuliahview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "VJadwalKuliahadd.php?" . $this->getUrlParm($parm);
		else
			$url = "VJadwalKuliahadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("VJadwalKuliahedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("VJadwalKuliahedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("VJadwalKuliahadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("VJadwalKuliahadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("VJadwalKuliahdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Thn_Akademik:" . JsonEncode($this->Thn_Akademik->CurrentValue, "string");
		$json .= ",Periode:" . JsonEncode($this->Periode->CurrentValue, "string");
		$json .= ",Kelas_Akd:" . JsonEncode($this->Kelas_Akd->CurrentValue, "string");
		$json .= ",Kode_Jp:" . JsonEncode($this->Kode_Jp->CurrentValue, "string");
		$json .= ",Kode_Mk:" . JsonEncode($this->Kode_Mk->CurrentValue, "string");
		$json .= ",Kelas:" . JsonEncode($this->Kelas->CurrentValue, "string");
		$json .= ",Jenis:" . JsonEncode($this->Jenis->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Thn_Akademik->CurrentValue != NULL) {
			$url .= "Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Periode->CurrentValue != NULL) {
			$url .= "&Periode=" . urlencode($this->Periode->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kelas_Akd->CurrentValue != NULL) {
			$url .= "&Kelas_Akd=" . urlencode($this->Kelas_Akd->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kode_Jp->CurrentValue != NULL) {
			$url .= "&Kode_Jp=" . urlencode($this->Kode_Jp->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kode_Mk->CurrentValue != NULL) {
			$url .= "&Kode_Mk=" . urlencode($this->Kode_Mk->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kelas->CurrentValue != NULL) {
			$url .= "&Kelas=" . urlencode($this->Kelas->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Jenis->CurrentValue != NULL) {
			$url .= "&Jenis=" . urlencode($this->Jenis->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("Thn_Akademik") !== NULL)
				$arKey[] = Param("Thn_Akademik");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Periode") !== NULL)
				$arKey[] = Param("Periode");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kelas_Akd") !== NULL)
				$arKey[] = Param("Kelas_Akd");
			elseif (IsApi() && Key(2) !== NULL)
				$arKey[] = Key(2);
			elseif (IsApi() && Route(4) !== NULL)
				$arKey[] = Route(4);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kode_Jp") !== NULL)
				$arKey[] = Param("Kode_Jp");
			elseif (IsApi() && Key(3) !== NULL)
				$arKey[] = Key(3);
			elseif (IsApi() && Route(5) !== NULL)
				$arKey[] = Route(5);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kode_Mk") !== NULL)
				$arKey[] = Param("Kode_Mk");
			elseif (IsApi() && Key(4) !== NULL)
				$arKey[] = Key(4);
			elseif (IsApi() && Route(6) !== NULL)
				$arKey[] = Route(6);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kelas") !== NULL)
				$arKey[] = Param("Kelas");
			elseif (IsApi() && Key(5) !== NULL)
				$arKey[] = Key(5);
			elseif (IsApi() && Route(7) !== NULL)
				$arKey[] = Route(7);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Jenis") !== NULL)
				$arKey[] = Param("Jenis");
			elseif (IsApi() && Key(6) !== NULL)
				$arKey[] = Key(6);
			elseif (IsApi() && Route(8) !== NULL)
				$arKey[] = Route(8);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 7)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Thn_Akademik->CurrentValue = $key[0];
			else
				$this->Thn_Akademik->OldValue = $key[0];
			if ($setCurrent)
				$this->Periode->CurrentValue = $key[1];
			else
				$this->Periode->OldValue = $key[1];
			if ($setCurrent)
				$this->Kelas_Akd->CurrentValue = $key[2];
			else
				$this->Kelas_Akd->OldValue = $key[2];
			if ($setCurrent)
				$this->Kode_Jp->CurrentValue = $key[3];
			else
				$this->Kode_Jp->OldValue = $key[3];
			if ($setCurrent)
				$this->Kode_Mk->CurrentValue = $key[4];
			else
				$this->Kode_Mk->OldValue = $key[4];
			if ($setCurrent)
				$this->Kelas->CurrentValue = $key[5];
			else
				$this->Kelas->OldValue = $key[5];
			if ($setCurrent)
				$this->Jenis->CurrentValue = $key[6];
			else
				$this->Jenis->OldValue = $key[6];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Thn_Akademik->setDbValue($rs->fields('Thn_Akademik'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->Kelas_Akd->setDbValue($rs->fields('Kelas_Akd'));
		$this->Kode_Jp->setDbValue($rs->fields('Kode_Jp'));
		$this->Kode_Mk->setDbValue($rs->fields('Kode_Mk'));
		$this->Matakuliah->setDbValue($rs->fields('Matakuliah'));
		$this->Tanggal->setDbValue($rs->fields('Tanggal'));
		$this->SKS->setDbValue($rs->fields('SKS'));
		$this->Kelas->setDbValue($rs->fields('Kelas'));
		$this->Hari->setDbValue($rs->fields('Hari'));
		$this->JM->setDbValue($rs->fields('JM'));
		$this->JS->setDbValue($rs->fields('JS'));
		$this->NIDN->setDbValue($rs->fields('NIDN'));
		$this->NIDN1->setDbValue($rs->fields('NIDN1'));
		$this->Kode_Ruangan->setDbValue($rs->fields('Kode_Ruangan'));
		$this->Ruang->setDbValue($rs->fields('Ruang'));
		$this->Kapasitas->setDbValue($rs->fields('Kapasitas'));
		$this->Jenis->setDbValue($rs->fields('Jenis'));
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->id_feedkelas->setDbValue($rs->fields('id_feedkelas'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Thn_Akademik
		// Periode
		// Kelas_Akd
		// Kode_Jp
		// Kode_Mk
		// Matakuliah
		// Tanggal
		// SKS
		// Kelas
		// Hari
		// JM
		// JS
		// NIDN
		// NIDN1
		// Kode_Ruangan
		// Ruang
		// Kapasitas
		// Jenis
		// Kode_Fak
		// id_feedkelas
		// Thn_Akademik

		$curVal = strval($this->Thn_Akademik->CurrentValue);
		if ($curVal != "") {
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->lookupCacheOption($curVal);
			if ($this->Thn_Akademik->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Thn_Akademik->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
				}
			}
		} else {
			$this->Thn_Akademik->ViewValue = NULL;
		}
		$this->Thn_Akademik->ViewCustomAttributes = "";

		// Periode
		if (strval($this->Periode->CurrentValue) != "") {
			$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
		} else {
			$this->Periode->ViewValue = NULL;
		}
		$this->Periode->ViewCustomAttributes = "";

		// Kelas_Akd
		$curVal = strval($this->Kelas_Akd->CurrentValue);
		if ($curVal != "") {
			$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->lookupCacheOption($curVal);
			if ($this->Kelas_Akd->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kelas_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->CurrentValue;
				}
			}
		} else {
			$this->Kelas_Akd->ViewValue = NULL;
		}
		$this->Kelas_Akd->ViewCustomAttributes = "";

		// Kode_Jp
		$curVal = strval($this->Kode_Jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
			if ($this->Kode_Jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->Kode_Jp->ViewValue = $this->Kode_Jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_Jp->ViewValue = NULL;
		}
		$this->Kode_Jp->ViewCustomAttributes = "";

		// Kode_Mk
		$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->ViewCustomAttributes = "";

		// Matakuliah
		$this->Matakuliah->ViewValue = $this->Matakuliah->CurrentValue;
		$this->Matakuliah->ViewCustomAttributes = "";

		// Tanggal
		$this->Tanggal->ViewValue = $this->Tanggal->CurrentValue;
		$this->Tanggal->ViewValue = FormatDateTime($this->Tanggal->ViewValue, 0);
		$this->Tanggal->ViewCustomAttributes = "";

		// SKS
		$this->SKS->ViewValue = $this->SKS->CurrentValue;
		$this->SKS->ViewValue = FormatNumber($this->SKS->ViewValue, 0, -2, -2, -2);
		$this->SKS->ViewCustomAttributes = "";

		// Kelas
		$this->Kelas->ViewValue = $this->Kelas->CurrentValue;
		$this->Kelas->ViewCustomAttributes = "";

		// Hari
		$this->Hari->ViewValue = $this->Hari->CurrentValue;
		$this->Hari->ViewCustomAttributes = "";

		// JM
		$this->JM->ViewValue = $this->JM->CurrentValue;
		$this->JM->ViewValue = FormatDateTime($this->JM->ViewValue, 0);
		$this->JM->ViewCustomAttributes = "";

		// JS
		$this->JS->ViewValue = $this->JS->CurrentValue;
		$this->JS->ViewValue = FormatDateTime($this->JS->ViewValue, 0);
		$this->JS->ViewCustomAttributes = "";

		// NIDN
		$curVal = strval($this->NIDN->CurrentValue);
		if ($curVal != "") {
			$this->NIDN->ViewValue = $this->NIDN->lookupCacheOption($curVal);
			if ($this->NIDN->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[NIDN]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->NIDN->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->NIDN->ViewValue = $this->NIDN->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
				}
			}
		} else {
			$this->NIDN->ViewValue = NULL;
		}
		$this->NIDN->ViewCustomAttributes = "";

		// NIDN1
		$curVal = strval($this->NIDN1->CurrentValue);
		if ($curVal != "") {
			$this->NIDN1->ViewValue = $this->NIDN1->lookupCacheOption($curVal);
			if ($this->NIDN1->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[NIDN]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->NIDN1->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->NIDN1->ViewValue = $this->NIDN1->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->NIDN1->ViewValue = $this->NIDN1->CurrentValue;
				}
			}
		} else {
			$this->NIDN1->ViewValue = NULL;
		}
		$this->NIDN1->ViewCustomAttributes = "";

		// Kode_Ruangan
		$this->Kode_Ruangan->ViewValue = $this->Kode_Ruangan->CurrentValue;
		$this->Kode_Ruangan->ViewCustomAttributes = "";

		// Ruang
		$this->Ruang->ViewValue = $this->Ruang->CurrentValue;
		$this->Ruang->ViewCustomAttributes = "";

		// Kapasitas
		$this->Kapasitas->ViewValue = $this->Kapasitas->CurrentValue;
		$this->Kapasitas->ViewValue = FormatNumber($this->Kapasitas->ViewValue, 0, -2, -2, -2);
		$this->Kapasitas->ViewCustomAttributes = "";

		// Jenis
		$this->Jenis->ViewValue = $this->Jenis->CurrentValue;
		$this->Jenis->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->ViewCustomAttributes = "";

		// id_feedkelas
		$this->id_feedkelas->ViewValue = $this->id_feedkelas->CurrentValue;
		$this->id_feedkelas->ViewCustomAttributes = "";

		// Thn_Akademik
		$this->Thn_Akademik->LinkCustomAttributes = "";
		$this->Thn_Akademik->HrefValue = "";
		$this->Thn_Akademik->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// Kelas_Akd
		$this->Kelas_Akd->LinkCustomAttributes = "";
		$this->Kelas_Akd->HrefValue = "";
		$this->Kelas_Akd->TooltipValue = "";

		// Kode_Jp
		$this->Kode_Jp->LinkCustomAttributes = "";
		$this->Kode_Jp->HrefValue = "";
		$this->Kode_Jp->TooltipValue = "";

		// Kode_Mk
		$this->Kode_Mk->LinkCustomAttributes = "";
		$this->Kode_Mk->HrefValue = "";
		$this->Kode_Mk->TooltipValue = "";

		// Matakuliah
		$this->Matakuliah->LinkCustomAttributes = "";
		$this->Matakuliah->HrefValue = "";
		$this->Matakuliah->TooltipValue = "";

		// Tanggal
		$this->Tanggal->LinkCustomAttributes = "";
		$this->Tanggal->HrefValue = "";
		$this->Tanggal->TooltipValue = "";

		// SKS
		$this->SKS->LinkCustomAttributes = "";
		$this->SKS->HrefValue = "";
		$this->SKS->TooltipValue = "";

		// Kelas
		$this->Kelas->LinkCustomAttributes = "";
		$this->Kelas->HrefValue = "";
		$this->Kelas->TooltipValue = "";

		// Hari
		$this->Hari->LinkCustomAttributes = "";
		$this->Hari->HrefValue = "";
		$this->Hari->TooltipValue = "";

		// JM
		$this->JM->LinkCustomAttributes = "";
		$this->JM->HrefValue = "";
		$this->JM->TooltipValue = "";

		// JS
		$this->JS->LinkCustomAttributes = "";
		$this->JS->HrefValue = "";
		$this->JS->TooltipValue = "";

		// NIDN
		$this->NIDN->LinkCustomAttributes = "";
		$this->NIDN->HrefValue = "";
		$this->NIDN->TooltipValue = "";

		// NIDN1
		$this->NIDN1->LinkCustomAttributes = "";
		$this->NIDN1->HrefValue = "";
		$this->NIDN1->TooltipValue = "";

		// Kode_Ruangan
		$this->Kode_Ruangan->LinkCustomAttributes = "";
		$this->Kode_Ruangan->HrefValue = "";
		$this->Kode_Ruangan->TooltipValue = "";

		// Ruang
		$this->Ruang->LinkCustomAttributes = "";
		$this->Ruang->HrefValue = "";
		$this->Ruang->TooltipValue = "";

		// Kapasitas
		$this->Kapasitas->LinkCustomAttributes = "";
		$this->Kapasitas->HrefValue = "";
		$this->Kapasitas->TooltipValue = "";

		// Jenis
		$this->Jenis->LinkCustomAttributes = "";
		$this->Jenis->HrefValue = "";
		$this->Jenis->TooltipValue = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// id_feedkelas
		$this->id_feedkelas->LinkCustomAttributes = "";
		$this->id_feedkelas->HrefValue = "";
		$this->id_feedkelas->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Thn_Akademik
		$this->Thn_Akademik->EditAttrs["class"] = "form-control";
		$this->Thn_Akademik->EditCustomAttributes = "";

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		$this->Periode->EditValue = $this->Periode->options(TRUE);

		// Kelas_Akd
		$this->Kelas_Akd->EditAttrs["class"] = "form-control";
		$this->Kelas_Akd->EditCustomAttributes = "";

		// Kode_Jp
		$this->Kode_Jp->EditAttrs["class"] = "form-control";
		$this->Kode_Jp->EditCustomAttributes = "";

		// Kode_Mk
		$this->Kode_Mk->EditAttrs["class"] = "form-control";
		$this->Kode_Mk->EditCustomAttributes = "";
		if (!$this->Kode_Mk->Raw)
			$this->Kode_Mk->CurrentValue = HtmlDecode($this->Kode_Mk->CurrentValue);
		$this->Kode_Mk->EditValue = $this->Kode_Mk->CurrentValue;
		$this->Kode_Mk->PlaceHolder = RemoveHtml($this->Kode_Mk->caption());

		// Matakuliah
		$this->Matakuliah->EditAttrs["class"] = "form-control";
		$this->Matakuliah->EditCustomAttributes = "";
		if (!$this->Matakuliah->Raw)
			$this->Matakuliah->CurrentValue = HtmlDecode($this->Matakuliah->CurrentValue);
		$this->Matakuliah->EditValue = $this->Matakuliah->CurrentValue;
		$this->Matakuliah->PlaceHolder = RemoveHtml($this->Matakuliah->caption());

		// Tanggal
		$this->Tanggal->EditAttrs["class"] = "form-control";
		$this->Tanggal->EditCustomAttributes = "";
		$this->Tanggal->EditValue = FormatDateTime($this->Tanggal->CurrentValue, 8);
		$this->Tanggal->PlaceHolder = RemoveHtml($this->Tanggal->caption());

		// SKS
		$this->SKS->EditAttrs["class"] = "form-control";
		$this->SKS->EditCustomAttributes = "";
		$this->SKS->EditValue = $this->SKS->CurrentValue;
		$this->SKS->PlaceHolder = RemoveHtml($this->SKS->caption());

		// Kelas
		$this->Kelas->EditAttrs["class"] = "form-control";
		$this->Kelas->EditCustomAttributes = "";
		if (!$this->Kelas->Raw)
			$this->Kelas->CurrentValue = HtmlDecode($this->Kelas->CurrentValue);
		$this->Kelas->EditValue = $this->Kelas->CurrentValue;
		$this->Kelas->PlaceHolder = RemoveHtml($this->Kelas->caption());

		// Hari
		$this->Hari->EditAttrs["class"] = "form-control";
		$this->Hari->EditCustomAttributes = "";
		if (!$this->Hari->Raw)
			$this->Hari->CurrentValue = HtmlDecode($this->Hari->CurrentValue);
		$this->Hari->EditValue = $this->Hari->CurrentValue;
		$this->Hari->PlaceHolder = RemoveHtml($this->Hari->caption());

		// JM
		$this->JM->EditAttrs["class"] = "form-control";
		$this->JM->EditCustomAttributes = "";
		$this->JM->EditValue = FormatDateTime($this->JM->CurrentValue, 8);
		$this->JM->PlaceHolder = RemoveHtml($this->JM->caption());

		// JS
		$this->JS->EditAttrs["class"] = "form-control";
		$this->JS->EditCustomAttributes = "";
		$this->JS->EditValue = FormatDateTime($this->JS->CurrentValue, 8);
		$this->JS->PlaceHolder = RemoveHtml($this->JS->caption());

		// NIDN
		$this->NIDN->EditAttrs["class"] = "form-control";
		$this->NIDN->EditCustomAttributes = "";

		// NIDN1
		$this->NIDN1->EditAttrs["class"] = "form-control";
		$this->NIDN1->EditCustomAttributes = "";

		// Kode_Ruangan
		$this->Kode_Ruangan->EditAttrs["class"] = "form-control";
		$this->Kode_Ruangan->EditCustomAttributes = "";
		if (!$this->Kode_Ruangan->Raw)
			$this->Kode_Ruangan->CurrentValue = HtmlDecode($this->Kode_Ruangan->CurrentValue);
		$this->Kode_Ruangan->EditValue = $this->Kode_Ruangan->CurrentValue;
		$this->Kode_Ruangan->PlaceHolder = RemoveHtml($this->Kode_Ruangan->caption());

		// Ruang
		$this->Ruang->EditAttrs["class"] = "form-control";
		$this->Ruang->EditCustomAttributes = "";
		if (!$this->Ruang->Raw)
			$this->Ruang->CurrentValue = HtmlDecode($this->Ruang->CurrentValue);
		$this->Ruang->EditValue = $this->Ruang->CurrentValue;
		$this->Ruang->PlaceHolder = RemoveHtml($this->Ruang->caption());

		// Kapasitas
		$this->Kapasitas->EditAttrs["class"] = "form-control";
		$this->Kapasitas->EditCustomAttributes = "";
		$this->Kapasitas->EditValue = $this->Kapasitas->CurrentValue;
		$this->Kapasitas->PlaceHolder = RemoveHtml($this->Kapasitas->caption());

		// Jenis
		$this->Jenis->EditAttrs["class"] = "form-control";
		$this->Jenis->EditCustomAttributes = "";
		if (!$this->Jenis->Raw)
			$this->Jenis->CurrentValue = HtmlDecode($this->Jenis->CurrentValue);
		$this->Jenis->EditValue = $this->Jenis->CurrentValue;
		$this->Jenis->PlaceHolder = RemoveHtml($this->Jenis->caption());

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";
		if (!$this->Kode_Fak->Raw)
			$this->Kode_Fak->CurrentValue = HtmlDecode($this->Kode_Fak->CurrentValue);
		$this->Kode_Fak->EditValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->PlaceHolder = RemoveHtml($this->Kode_Fak->caption());

		// id_feedkelas
		$this->id_feedkelas->EditAttrs["class"] = "form-control";
		$this->id_feedkelas->EditCustomAttributes = "";
		if (!$this->id_feedkelas->Raw)
			$this->id_feedkelas->CurrentValue = HtmlDecode($this->id_feedkelas->CurrentValue);
		$this->id_feedkelas->EditValue = $this->id_feedkelas->CurrentValue;
		$this->id_feedkelas->PlaceHolder = RemoveHtml($this->id_feedkelas->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kelas_Akd);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Kode_Mk);
					$doc->exportCaption($this->Matakuliah);
					$doc->exportCaption($this->Tanggal);
					$doc->exportCaption($this->SKS);
					$doc->exportCaption($this->Kelas);
					$doc->exportCaption($this->Hari);
					$doc->exportCaption($this->JM);
					$doc->exportCaption($this->JS);
					$doc->exportCaption($this->NIDN);
					$doc->exportCaption($this->NIDN1);
					$doc->exportCaption($this->Kode_Ruangan);
					$doc->exportCaption($this->Ruang);
					$doc->exportCaption($this->Kapasitas);
					$doc->exportCaption($this->Jenis);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->id_feedkelas);
				} else {
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kelas_Akd);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->Kode_Mk);
					$doc->exportCaption($this->Matakuliah);
					$doc->exportCaption($this->Tanggal);
					$doc->exportCaption($this->SKS);
					$doc->exportCaption($this->Kelas);
					$doc->exportCaption($this->Hari);
					$doc->exportCaption($this->JM);
					$doc->exportCaption($this->JS);
					$doc->exportCaption($this->NIDN);
					$doc->exportCaption($this->NIDN1);
					$doc->exportCaption($this->Kode_Ruangan);
					$doc->exportCaption($this->Ruang);
					$doc->exportCaption($this->Kapasitas);
					$doc->exportCaption($this->Jenis);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->id_feedkelas);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kelas_Akd);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Kode_Mk);
						$doc->exportField($this->Matakuliah);
						$doc->exportField($this->Tanggal);
						$doc->exportField($this->SKS);
						$doc->exportField($this->Kelas);
						$doc->exportField($this->Hari);
						$doc->exportField($this->JM);
						$doc->exportField($this->JS);
						$doc->exportField($this->NIDN);
						$doc->exportField($this->NIDN1);
						$doc->exportField($this->Kode_Ruangan);
						$doc->exportField($this->Ruang);
						$doc->exportField($this->Kapasitas);
						$doc->exportField($this->Jenis);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->id_feedkelas);
					} else {
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kelas_Akd);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->Kode_Mk);
						$doc->exportField($this->Matakuliah);
						$doc->exportField($this->Tanggal);
						$doc->exportField($this->SKS);
						$doc->exportField($this->Kelas);
						$doc->exportField($this->Hari);
						$doc->exportField($this->JM);
						$doc->exportField($this->JS);
						$doc->exportField($this->NIDN);
						$doc->exportField($this->NIDN1);
						$doc->exportField($this->Kode_Ruangan);
						$doc->exportField($this->Ruang);
						$doc->exportField($this->Kapasitas);
						$doc->exportField($this->Jenis);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->id_feedkelas);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>