<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for V_PMBMhs
 */
class V_PMBMhs extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Nopen;
	public $Nama_Mhs;
	public $Kode_jp;
	public $Prodi;
	public $Kode_Fak;
	public $Tmp_Lahir;
	public $Tgl_Lahir;
	public $Jenis_Kel;
	public $Gol_darah;
	public $Agama_Mhs;
	public $Alamat_Mhs;
	public $rt;
	public $rw;
	public $Kelurahan;
	public $id_wilayah;
	public $nama_wilayah;
	public $kewarganegaraan;
	public $Kecamatan;
	public $Kota_Mhs;
	public $Provinsi_mhs;
	public $Kodepos_Mhs;
	public $Tlp_Mhs;
	public $TlpRumah;
	public $_Email;
	public $NIK;
	public $NamaIbu;
	public $Status_Akd;
	public $ThMasuk;
	public $tglmasuk;
	public $Status_Masuk;
	public $TaMasuk;
	public $PerMasuk;
	public $Pendidikan_Akhir;
	public $Jurusan;
	public $Thn_Selesai;
	public $Kota_Pdkk;
	public $propinsi;
	public $NamaSekolahAsal;
	public $AlamatSekolahAsal;
	public $InfoDari;
	public $IdBeasiswa;
	public $NamaBeasiswa;
	public $NISS;
	public $tglDaftar;
	public $UserName;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'V_PMBMhs';
		$this->TableName = 'V_PMBMhs';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[V_PMBMhs]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Nopen
		$this->Nopen = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Nopen', 'Nopen', '[Nopen]', 'CAST([Nopen] AS NVARCHAR)', 3, 4, -1, FALSE, '[Nopen]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->Nopen->IsAutoIncrement = TRUE; // Autoincrement field
		$this->Nopen->IsPrimaryKey = TRUE; // Primary key field
		$this->Nopen->Nullable = FALSE; // NOT NULL field
		$this->Nopen->Sortable = TRUE; // Allow sort
		$this->Nopen->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Nopen'] = &$this->Nopen;

		// Nama_Mhs
		$this->Nama_Mhs = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Nama_Mhs', 'Nama_Mhs', '[Nama_Mhs]', '[Nama_Mhs]', 200, 70, -1, FALSE, '[Nama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mhs'] = &$this->Nama_Mhs;

		// Kode_jp
		$this->Kode_jp = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Kode_jp', 'Kode_jp', '[Kode_jp]', '[Kode_jp]', 129, 4, -1, FALSE, '[Kode_jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_jp->Sortable = TRUE; // Allow sort
		$this->fields['Kode_jp'] = &$this->Kode_jp;

		// Prodi
		$this->Prodi = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Prodi', 'Prodi', '[Prodi]', '[Prodi]', 200, 30, -1, FALSE, '[Prodi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Prodi->Sortable = TRUE; // Allow sort
		$this->fields['Prodi'] = &$this->Prodi;

		// Kode_Fak
		$this->Kode_Fak = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Tmp_Lahir
		$this->Tmp_Lahir = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Tmp_Lahir', 'Tmp_Lahir', '[Tmp_Lahir]', '[Tmp_Lahir]', 200, 50, -1, FALSE, '[Tmp_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tmp_Lahir->Sortable = TRUE; // Allow sort
		$this->fields['Tmp_Lahir'] = &$this->Tmp_Lahir;

		// Tgl_Lahir
		$this->Tgl_Lahir = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Tgl_Lahir', 'Tgl_Lahir', '[Tgl_Lahir]', CastDateFieldForLike("[Tgl_Lahir]", 0, "DB"), 135, 8, 0, FALSE, '[Tgl_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Lahir->Sortable = TRUE; // Allow sort
		$this->Tgl_Lahir->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['Tgl_Lahir'] = &$this->Tgl_Lahir;

		// Jenis_Kel
		$this->Jenis_Kel = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Jenis_Kel', 'Jenis_Kel', '[Jenis_Kel]', '[Jenis_Kel]', 129, 1, -1, FALSE, '[Jenis_Kel]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jenis_Kel->Sortable = TRUE; // Allow sort
		$this->fields['Jenis_Kel'] = &$this->Jenis_Kel;

		// Gol_darah
		$this->Gol_darah = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Gol_darah', 'Gol_darah', '[Gol_darah]', '[Gol_darah]', 200, 2, -1, FALSE, '[Gol_darah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Gol_darah->Sortable = TRUE; // Allow sort
		$this->fields['Gol_darah'] = &$this->Gol_darah;

		// Agama_Mhs
		$this->Agama_Mhs = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Agama_Mhs', 'Agama_Mhs', '[Agama_Mhs]', '[Agama_Mhs]', 200, 50, -1, FALSE, '[Agama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Agama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Agama_Mhs'] = &$this->Agama_Mhs;

		// Alamat_Mhs
		$this->Alamat_Mhs = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Alamat_Mhs', 'Alamat_Mhs', '[Alamat_Mhs]', '[Alamat_Mhs]', 200, 70, -1, FALSE, '[Alamat_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Alamat_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Alamat_Mhs'] = &$this->Alamat_Mhs;

		// rt
		$this->rt = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_rt', 'rt', '[rt]', '[rt]', 200, 5, -1, FALSE, '[rt]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rt->Sortable = TRUE; // Allow sort
		$this->fields['rt'] = &$this->rt;

		// rw
		$this->rw = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_rw', 'rw', '[rw]', '[rw]', 200, 5, -1, FALSE, '[rw]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rw->Sortable = TRUE; // Allow sort
		$this->fields['rw'] = &$this->rw;

		// Kelurahan
		$this->Kelurahan = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Kelurahan', 'Kelurahan', '[Kelurahan]', '[Kelurahan]', 200, 50, -1, FALSE, '[Kelurahan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kelurahan->Sortable = TRUE; // Allow sort
		$this->fields['Kelurahan'] = &$this->Kelurahan;

		// id_wilayah
		$this->id_wilayah = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_id_wilayah', 'id_wilayah', '[id_wilayah]', '[id_wilayah]', 200, 8, -1, FALSE, '[id_wilayah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_wilayah->Sortable = TRUE; // Allow sort
		$this->fields['id_wilayah'] = &$this->id_wilayah;

		// nama_wilayah
		$this->nama_wilayah = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_nama_wilayah', 'nama_wilayah', '[nama_wilayah]', '[nama_wilayah]', 200, 50, -1, FALSE, '[nama_wilayah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nama_wilayah->Sortable = TRUE; // Allow sort
		$this->fields['nama_wilayah'] = &$this->nama_wilayah;

		// kewarganegaraan
		$this->kewarganegaraan = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_kewarganegaraan', 'kewarganegaraan', '[kewarganegaraan]', '[kewarganegaraan]', 200, 2, -1, FALSE, '[kewarganegaraan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kewarganegaraan->Sortable = TRUE; // Allow sort
		$this->fields['kewarganegaraan'] = &$this->kewarganegaraan;

		// Kecamatan
		$this->Kecamatan = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Kecamatan', 'Kecamatan', '[Kecamatan]', '[Kecamatan]', 200, 50, -1, FALSE, '[Kecamatan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kecamatan->Sortable = TRUE; // Allow sort
		$this->fields['Kecamatan'] = &$this->Kecamatan;

		// Kota_Mhs
		$this->Kota_Mhs = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Kota_Mhs', 'Kota_Mhs', '[Kota_Mhs]', '[Kota_Mhs]', 200, 50, -1, FALSE, '[Kota_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kota_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Kota_Mhs'] = &$this->Kota_Mhs;

		// Provinsi_mhs
		$this->Provinsi_mhs = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Provinsi_mhs', 'Provinsi_mhs', '[Provinsi_mhs]', '[Provinsi_mhs]', 200, 50, -1, FALSE, '[Provinsi_mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Provinsi_mhs->Sortable = TRUE; // Allow sort
		$this->fields['Provinsi_mhs'] = &$this->Provinsi_mhs;

		// Kodepos_Mhs
		$this->Kodepos_Mhs = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Kodepos_Mhs', 'Kodepos_Mhs', '[Kodepos_Mhs]', '[Kodepos_Mhs]', 200, 50, -1, FALSE, '[Kodepos_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kodepos_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Kodepos_Mhs'] = &$this->Kodepos_Mhs;

		// Tlp_Mhs
		$this->Tlp_Mhs = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Tlp_Mhs', 'Tlp_Mhs', '[Tlp_Mhs]', '[Tlp_Mhs]', 200, 15, -1, FALSE, '[Tlp_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tlp_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Tlp_Mhs'] = &$this->Tlp_Mhs;

		// TlpRumah
		$this->TlpRumah = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_TlpRumah', 'TlpRumah', '[TlpRumah]', '[TlpRumah]', 200, 15, -1, FALSE, '[TlpRumah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TlpRumah->Sortable = TRUE; // Allow sort
		$this->fields['TlpRumah'] = &$this->TlpRumah;

		// Email
		$this->_Email = new DbField('V_PMBMhs', 'V_PMBMhs', 'x__Email', 'Email', '[Email]', '[Email]', 200, 50, -1, FALSE, '[Email]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Email->Sortable = TRUE; // Allow sort
		$this->fields['Email'] = &$this->_Email;

		// NIK
		$this->NIK = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_NIK', 'NIK', '[NIK]', '[NIK]', 200, 20, -1, FALSE, '[NIK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NIK->Sortable = TRUE; // Allow sort
		$this->fields['NIK'] = &$this->NIK;

		// NamaIbu
		$this->NamaIbu = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_NamaIbu', 'NamaIbu', '[NamaIbu]', '[NamaIbu]', 200, 50, -1, FALSE, '[NamaIbu]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NamaIbu->Sortable = TRUE; // Allow sort
		$this->fields['NamaIbu'] = &$this->NamaIbu;

		// Status_Akd
		$this->Status_Akd = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 200, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// ThMasuk
		$this->ThMasuk = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_ThMasuk', 'ThMasuk', '[ThMasuk]', '[ThMasuk]', 129, 4, -1, FALSE, '[ThMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ThMasuk->Sortable = TRUE; // Allow sort
		$this->fields['ThMasuk'] = &$this->ThMasuk;

		// tglmasuk
		$this->tglmasuk = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_tglmasuk', 'tglmasuk', '[tglmasuk]', CastDateFieldForLike("[tglmasuk]", 0, "DB"), 135, 8, 0, FALSE, '[tglmasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tglmasuk->Sortable = TRUE; // Allow sort
		$this->tglmasuk->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['tglmasuk'] = &$this->tglmasuk;

		// Status_Masuk
		$this->Status_Masuk = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Status_Masuk', 'Status_Masuk', '[Status_Masuk]', '[Status_Masuk]', 129, 10, -1, FALSE, '[Status_Masuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Status_Masuk->Sortable = TRUE; // Allow sort
		$this->fields['Status_Masuk'] = &$this->Status_Masuk;

		// TaMasuk
		$this->TaMasuk = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_TaMasuk', 'TaMasuk', '[TaMasuk]', '[TaMasuk]', 129, 9, -1, FALSE, '[TaMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TaMasuk->Sortable = TRUE; // Allow sort
		$this->fields['TaMasuk'] = &$this->TaMasuk;

		// PerMasuk
		$this->PerMasuk = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_PerMasuk', 'PerMasuk', '[PerMasuk]', '[PerMasuk]', 129, 2, -1, FALSE, '[PerMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PerMasuk->Sortable = TRUE; // Allow sort
		$this->fields['PerMasuk'] = &$this->PerMasuk;

		// Pendidikan_Akhir
		$this->Pendidikan_Akhir = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Pendidikan_Akhir', 'Pendidikan_Akhir', '[Pendidikan_Akhir]', '[Pendidikan_Akhir]', 200, 10, -1, FALSE, '[Pendidikan_Akhir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pendidikan_Akhir->Sortable = TRUE; // Allow sort
		$this->fields['Pendidikan_Akhir'] = &$this->Pendidikan_Akhir;

		// Jurusan
		$this->Jurusan = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Jurusan', 'Jurusan', '[Jurusan]', '[Jurusan]', 200, 30, -1, FALSE, '[Jurusan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jurusan->Sortable = TRUE; // Allow sort
		$this->fields['Jurusan'] = &$this->Jurusan;

		// Thn_Selesai
		$this->Thn_Selesai = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Thn_Selesai', 'Thn_Selesai', '[Thn_Selesai]', '[Thn_Selesai]', 129, 4, -1, FALSE, '[Thn_Selesai]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Thn_Selesai->Sortable = TRUE; // Allow sort
		$this->fields['Thn_Selesai'] = &$this->Thn_Selesai;

		// Kota_Pdkk
		$this->Kota_Pdkk = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_Kota_Pdkk', 'Kota_Pdkk', '[Kota_Pdkk]', '[Kota_Pdkk]', 200, 50, -1, FALSE, '[Kota_Pdkk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kota_Pdkk->Sortable = TRUE; // Allow sort
		$this->fields['Kota_Pdkk'] = &$this->Kota_Pdkk;

		// propinsi
		$this->propinsi = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_propinsi', 'propinsi', '[propinsi]', '[propinsi]', 200, 50, -1, FALSE, '[propinsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->propinsi->Sortable = TRUE; // Allow sort
		$this->fields['propinsi'] = &$this->propinsi;

		// NamaSekolahAsal
		$this->NamaSekolahAsal = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_NamaSekolahAsal', 'NamaSekolahAsal', '[NamaSekolahAsal]', '[NamaSekolahAsal]', 200, 50, -1, FALSE, '[NamaSekolahAsal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NamaSekolahAsal->Sortable = TRUE; // Allow sort
		$this->fields['NamaSekolahAsal'] = &$this->NamaSekolahAsal;

		// AlamatSekolahAsal
		$this->AlamatSekolahAsal = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_AlamatSekolahAsal', 'AlamatSekolahAsal', '[AlamatSekolahAsal]', '[AlamatSekolahAsal]', 200, 50, -1, FALSE, '[AlamatSekolahAsal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AlamatSekolahAsal->Sortable = TRUE; // Allow sort
		$this->fields['AlamatSekolahAsal'] = &$this->AlamatSekolahAsal;

		// InfoDari
		$this->InfoDari = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_InfoDari', 'InfoDari', '[InfoDari]', '[InfoDari]', 200, 50, -1, FALSE, '[InfoDari]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->InfoDari->Sortable = TRUE; // Allow sort
		$this->fields['InfoDari'] = &$this->InfoDari;

		// IdBeasiswa
		$this->IdBeasiswa = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_IdBeasiswa', 'IdBeasiswa', '[IdBeasiswa]', 'CAST([IdBeasiswa] AS NVARCHAR)', 3, 4, -1, FALSE, '[IdBeasiswa]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IdBeasiswa->Sortable = TRUE; // Allow sort
		$this->IdBeasiswa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['IdBeasiswa'] = &$this->IdBeasiswa;

		// NamaBeasiswa
		$this->NamaBeasiswa = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_NamaBeasiswa', 'NamaBeasiswa', '[NamaBeasiswa]', '[NamaBeasiswa]', 200, 50, -1, FALSE, '[NamaBeasiswa]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NamaBeasiswa->Sortable = TRUE; // Allow sort
		$this->fields['NamaBeasiswa'] = &$this->NamaBeasiswa;

		// NISS
		$this->NISS = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_NISS', 'NISS', '[NISS]', '[NISS]', 200, 20, -1, FALSE, '[NISS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NISS->Sortable = TRUE; // Allow sort
		$this->fields['NISS'] = &$this->NISS;

		// tglDaftar
		$this->tglDaftar = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_tglDaftar', 'tglDaftar', '[tglDaftar]', CastDateFieldForLike("[tglDaftar]", 0, "DB"), 135, 8, 0, FALSE, '[tglDaftar]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tglDaftar->Sortable = TRUE; // Allow sort
		$this->tglDaftar->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['tglDaftar'] = &$this->tglDaftar;

		// UserName
		$this->UserName = new DbField('V_PMBMhs', 'V_PMBMhs', 'x_UserName', 'UserName', '[UserName]', '[UserName]', 200, 50, -1, FALSE, '[UserName]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UserName->Sortable = TRUE; // Allow sort
		$this->fields['UserName'] = &$this->UserName;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[V_PMBMhs]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->Nopen->setDbValue($conn->insert_ID());
			$rs['Nopen'] = $this->Nopen->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Nopen', $rs))
				AddFilter($where, QuotedName('Nopen', $this->Dbid) . '=' . QuotedValue($rs['Nopen'], $this->Nopen->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Nopen->DbValue = $row['Nopen'];
		$this->Nama_Mhs->DbValue = $row['Nama_Mhs'];
		$this->Kode_jp->DbValue = $row['Kode_jp'];
		$this->Prodi->DbValue = $row['Prodi'];
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Tmp_Lahir->DbValue = $row['Tmp_Lahir'];
		$this->Tgl_Lahir->DbValue = $row['Tgl_Lahir'];
		$this->Jenis_Kel->DbValue = $row['Jenis_Kel'];
		$this->Gol_darah->DbValue = $row['Gol_darah'];
		$this->Agama_Mhs->DbValue = $row['Agama_Mhs'];
		$this->Alamat_Mhs->DbValue = $row['Alamat_Mhs'];
		$this->rt->DbValue = $row['rt'];
		$this->rw->DbValue = $row['rw'];
		$this->Kelurahan->DbValue = $row['Kelurahan'];
		$this->id_wilayah->DbValue = $row['id_wilayah'];
		$this->nama_wilayah->DbValue = $row['nama_wilayah'];
		$this->kewarganegaraan->DbValue = $row['kewarganegaraan'];
		$this->Kecamatan->DbValue = $row['Kecamatan'];
		$this->Kota_Mhs->DbValue = $row['Kota_Mhs'];
		$this->Provinsi_mhs->DbValue = $row['Provinsi_mhs'];
		$this->Kodepos_Mhs->DbValue = $row['Kodepos_Mhs'];
		$this->Tlp_Mhs->DbValue = $row['Tlp_Mhs'];
		$this->TlpRumah->DbValue = $row['TlpRumah'];
		$this->_Email->DbValue = $row['Email'];
		$this->NIK->DbValue = $row['NIK'];
		$this->NamaIbu->DbValue = $row['NamaIbu'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->ThMasuk->DbValue = $row['ThMasuk'];
		$this->tglmasuk->DbValue = $row['tglmasuk'];
		$this->Status_Masuk->DbValue = $row['Status_Masuk'];
		$this->TaMasuk->DbValue = $row['TaMasuk'];
		$this->PerMasuk->DbValue = $row['PerMasuk'];
		$this->Pendidikan_Akhir->DbValue = $row['Pendidikan_Akhir'];
		$this->Jurusan->DbValue = $row['Jurusan'];
		$this->Thn_Selesai->DbValue = $row['Thn_Selesai'];
		$this->Kota_Pdkk->DbValue = $row['Kota_Pdkk'];
		$this->propinsi->DbValue = $row['propinsi'];
		$this->NamaSekolahAsal->DbValue = $row['NamaSekolahAsal'];
		$this->AlamatSekolahAsal->DbValue = $row['AlamatSekolahAsal'];
		$this->InfoDari->DbValue = $row['InfoDari'];
		$this->IdBeasiswa->DbValue = $row['IdBeasiswa'];
		$this->NamaBeasiswa->DbValue = $row['NamaBeasiswa'];
		$this->NISS->DbValue = $row['NISS'];
		$this->tglDaftar->DbValue = $row['tglDaftar'];
		$this->UserName->DbValue = $row['UserName'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Nopen] = @Nopen@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Nopen', $row) ? $row['Nopen'] : NULL;
		else
			$val = $this->Nopen->OldValue !== NULL ? $this->Nopen->OldValue : $this->Nopen->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Nopen@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "V_PMBMhslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "V_PMBMhsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "V_PMBMhsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "V_PMBMhsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "V_PMBMhslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("V_PMBMhsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("V_PMBMhsview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "V_PMBMhsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "V_PMBMhsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("V_PMBMhsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("V_PMBMhsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("V_PMBMhsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Nopen:" . JsonEncode($this->Nopen->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Nopen->CurrentValue != NULL) {
			$url .= "Nopen=" . urlencode($this->Nopen->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("Nopen") !== NULL)
				$arKeys[] = Param("Nopen");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Nopen->CurrentValue = $key;
			else
				$this->Nopen->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Nopen->setDbValue($rs->fields('Nopen'));
		$this->Nama_Mhs->setDbValue($rs->fields('Nama_Mhs'));
		$this->Kode_jp->setDbValue($rs->fields('Kode_jp'));
		$this->Prodi->setDbValue($rs->fields('Prodi'));
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Tmp_Lahir->setDbValue($rs->fields('Tmp_Lahir'));
		$this->Tgl_Lahir->setDbValue($rs->fields('Tgl_Lahir'));
		$this->Jenis_Kel->setDbValue($rs->fields('Jenis_Kel'));
		$this->Gol_darah->setDbValue($rs->fields('Gol_darah'));
		$this->Agama_Mhs->setDbValue($rs->fields('Agama_Mhs'));
		$this->Alamat_Mhs->setDbValue($rs->fields('Alamat_Mhs'));
		$this->rt->setDbValue($rs->fields('rt'));
		$this->rw->setDbValue($rs->fields('rw'));
		$this->Kelurahan->setDbValue($rs->fields('Kelurahan'));
		$this->id_wilayah->setDbValue($rs->fields('id_wilayah'));
		$this->nama_wilayah->setDbValue($rs->fields('nama_wilayah'));
		$this->kewarganegaraan->setDbValue($rs->fields('kewarganegaraan'));
		$this->Kecamatan->setDbValue($rs->fields('Kecamatan'));
		$this->Kota_Mhs->setDbValue($rs->fields('Kota_Mhs'));
		$this->Provinsi_mhs->setDbValue($rs->fields('Provinsi_mhs'));
		$this->Kodepos_Mhs->setDbValue($rs->fields('Kodepos_Mhs'));
		$this->Tlp_Mhs->setDbValue($rs->fields('Tlp_Mhs'));
		$this->TlpRumah->setDbValue($rs->fields('TlpRumah'));
		$this->_Email->setDbValue($rs->fields('Email'));
		$this->NIK->setDbValue($rs->fields('NIK'));
		$this->NamaIbu->setDbValue($rs->fields('NamaIbu'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->ThMasuk->setDbValue($rs->fields('ThMasuk'));
		$this->tglmasuk->setDbValue($rs->fields('tglmasuk'));
		$this->Status_Masuk->setDbValue($rs->fields('Status_Masuk'));
		$this->TaMasuk->setDbValue($rs->fields('TaMasuk'));
		$this->PerMasuk->setDbValue($rs->fields('PerMasuk'));
		$this->Pendidikan_Akhir->setDbValue($rs->fields('Pendidikan_Akhir'));
		$this->Jurusan->setDbValue($rs->fields('Jurusan'));
		$this->Thn_Selesai->setDbValue($rs->fields('Thn_Selesai'));
		$this->Kota_Pdkk->setDbValue($rs->fields('Kota_Pdkk'));
		$this->propinsi->setDbValue($rs->fields('propinsi'));
		$this->NamaSekolahAsal->setDbValue($rs->fields('NamaSekolahAsal'));
		$this->AlamatSekolahAsal->setDbValue($rs->fields('AlamatSekolahAsal'));
		$this->InfoDari->setDbValue($rs->fields('InfoDari'));
		$this->IdBeasiswa->setDbValue($rs->fields('IdBeasiswa'));
		$this->NamaBeasiswa->setDbValue($rs->fields('NamaBeasiswa'));
		$this->NISS->setDbValue($rs->fields('NISS'));
		$this->tglDaftar->setDbValue($rs->fields('tglDaftar'));
		$this->UserName->setDbValue($rs->fields('UserName'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Nopen
		// Nama_Mhs
		// Kode_jp
		// Prodi
		// Kode_Fak
		// Tmp_Lahir
		// Tgl_Lahir
		// Jenis_Kel
		// Gol_darah
		// Agama_Mhs
		// Alamat_Mhs
		// rt
		// rw
		// Kelurahan
		// id_wilayah
		// nama_wilayah
		// kewarganegaraan
		// Kecamatan
		// Kota_Mhs
		// Provinsi_mhs
		// Kodepos_Mhs
		// Tlp_Mhs
		// TlpRumah
		// Email
		// NIK
		// NamaIbu
		// Status_Akd
		// ThMasuk
		// tglmasuk
		// Status_Masuk
		// TaMasuk
		// PerMasuk
		// Pendidikan_Akhir
		// Jurusan
		// Thn_Selesai
		// Kota_Pdkk
		// propinsi
		// NamaSekolahAsal
		// AlamatSekolahAsal
		// InfoDari
		// IdBeasiswa
		// NamaBeasiswa
		// NISS
		// tglDaftar
		// UserName
		// Nopen

		$this->Nopen->ViewValue = $this->Nopen->CurrentValue;
		$this->Nopen->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->ViewCustomAttributes = "";

		// Kode_jp
		$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
		$this->Kode_jp->ViewCustomAttributes = "";

		// Prodi
		$this->Prodi->ViewValue = $this->Prodi->CurrentValue;
		$this->Prodi->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->ViewCustomAttributes = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
		$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
		$this->Tgl_Lahir->ViewCustomAttributes = "";

		// Jenis_Kel
		$this->Jenis_Kel->ViewValue = $this->Jenis_Kel->CurrentValue;
		$this->Jenis_Kel->ViewCustomAttributes = "";

		// Gol_darah
		$this->Gol_darah->ViewValue = $this->Gol_darah->CurrentValue;
		$this->Gol_darah->ViewCustomAttributes = "";

		// Agama_Mhs
		$this->Agama_Mhs->ViewValue = $this->Agama_Mhs->CurrentValue;
		$this->Agama_Mhs->ViewCustomAttributes = "";

		// Alamat_Mhs
		$this->Alamat_Mhs->ViewValue = $this->Alamat_Mhs->CurrentValue;
		$this->Alamat_Mhs->ViewCustomAttributes = "";

		// rt
		$this->rt->ViewValue = $this->rt->CurrentValue;
		$this->rt->ViewCustomAttributes = "";

		// rw
		$this->rw->ViewValue = $this->rw->CurrentValue;
		$this->rw->ViewCustomAttributes = "";

		// Kelurahan
		$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
		$this->Kelurahan->ViewCustomAttributes = "";

		// id_wilayah
		$this->id_wilayah->ViewValue = $this->id_wilayah->CurrentValue;
		$this->id_wilayah->ViewCustomAttributes = "";

		// nama_wilayah
		$this->nama_wilayah->ViewValue = $this->nama_wilayah->CurrentValue;
		$this->nama_wilayah->ViewCustomAttributes = "";

		// kewarganegaraan
		$this->kewarganegaraan->ViewValue = $this->kewarganegaraan->CurrentValue;
		$this->kewarganegaraan->ViewCustomAttributes = "";

		// Kecamatan
		$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
		$this->Kecamatan->ViewCustomAttributes = "";

		// Kota_Mhs
		$this->Kota_Mhs->ViewValue = $this->Kota_Mhs->CurrentValue;
		$this->Kota_Mhs->ViewCustomAttributes = "";

		// Provinsi_mhs
		$this->Provinsi_mhs->ViewValue = $this->Provinsi_mhs->CurrentValue;
		$this->Provinsi_mhs->ViewCustomAttributes = "";

		// Kodepos_Mhs
		$this->Kodepos_Mhs->ViewValue = $this->Kodepos_Mhs->CurrentValue;
		$this->Kodepos_Mhs->ViewCustomAttributes = "";

		// Tlp_Mhs
		$this->Tlp_Mhs->ViewValue = $this->Tlp_Mhs->CurrentValue;
		$this->Tlp_Mhs->ViewCustomAttributes = "";

		// TlpRumah
		$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
		$this->TlpRumah->ViewCustomAttributes = "";

		// Email
		$this->_Email->ViewValue = $this->_Email->CurrentValue;
		$this->_Email->ViewCustomAttributes = "";

		// NIK
		$this->NIK->ViewValue = $this->NIK->CurrentValue;
		$this->NIK->ViewCustomAttributes = "";

		// NamaIbu
		$this->NamaIbu->ViewValue = $this->NamaIbu->CurrentValue;
		$this->NamaIbu->ViewCustomAttributes = "";

		// Status_Akd
		$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
		$this->Status_Akd->ViewCustomAttributes = "";

		// ThMasuk
		$this->ThMasuk->ViewValue = $this->ThMasuk->CurrentValue;
		$this->ThMasuk->ViewCustomAttributes = "";

		// tglmasuk
		$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
		$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 0);
		$this->tglmasuk->ViewCustomAttributes = "";

		// Status_Masuk
		$this->Status_Masuk->ViewValue = $this->Status_Masuk->CurrentValue;
		$this->Status_Masuk->ViewCustomAttributes = "";

		// TaMasuk
		$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
		$this->TaMasuk->ViewCustomAttributes = "";

		// PerMasuk
		$this->PerMasuk->ViewValue = $this->PerMasuk->CurrentValue;
		$this->PerMasuk->ViewCustomAttributes = "";

		// Pendidikan_Akhir
		$this->Pendidikan_Akhir->ViewValue = $this->Pendidikan_Akhir->CurrentValue;
		$this->Pendidikan_Akhir->ViewCustomAttributes = "";

		// Jurusan
		$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->ViewCustomAttributes = "";

		// Thn_Selesai
		$this->Thn_Selesai->ViewValue = $this->Thn_Selesai->CurrentValue;
		$this->Thn_Selesai->ViewCustomAttributes = "";

		// Kota_Pdkk
		$this->Kota_Pdkk->ViewValue = $this->Kota_Pdkk->CurrentValue;
		$this->Kota_Pdkk->ViewCustomAttributes = "";

		// propinsi
		$this->propinsi->ViewValue = $this->propinsi->CurrentValue;
		$this->propinsi->ViewCustomAttributes = "";

		// NamaSekolahAsal
		$this->NamaSekolahAsal->ViewValue = $this->NamaSekolahAsal->CurrentValue;
		$this->NamaSekolahAsal->ViewCustomAttributes = "";

		// AlamatSekolahAsal
		$this->AlamatSekolahAsal->ViewValue = $this->AlamatSekolahAsal->CurrentValue;
		$this->AlamatSekolahAsal->ViewCustomAttributes = "";

		// InfoDari
		$this->InfoDari->ViewValue = $this->InfoDari->CurrentValue;
		$this->InfoDari->ViewCustomAttributes = "";

		// IdBeasiswa
		$this->IdBeasiswa->ViewValue = $this->IdBeasiswa->CurrentValue;
		$this->IdBeasiswa->ViewValue = FormatNumber($this->IdBeasiswa->ViewValue, 0, -2, -2, -2);
		$this->IdBeasiswa->ViewCustomAttributes = "";

		// NamaBeasiswa
		$this->NamaBeasiswa->ViewValue = $this->NamaBeasiswa->CurrentValue;
		$this->NamaBeasiswa->ViewCustomAttributes = "";

		// NISS
		$this->NISS->ViewValue = $this->NISS->CurrentValue;
		$this->NISS->ViewCustomAttributes = "";

		// tglDaftar
		$this->tglDaftar->ViewValue = $this->tglDaftar->CurrentValue;
		$this->tglDaftar->ViewValue = FormatDateTime($this->tglDaftar->ViewValue, 0);
		$this->tglDaftar->ViewCustomAttributes = "";

		// UserName
		$this->UserName->ViewValue = $this->UserName->CurrentValue;
		$this->UserName->ViewCustomAttributes = "";

		// Nopen
		$this->Nopen->LinkCustomAttributes = "";
		$this->Nopen->HrefValue = "";
		$this->Nopen->TooltipValue = "";

		// Nama_Mhs
		$this->Nama_Mhs->LinkCustomAttributes = "";
		$this->Nama_Mhs->HrefValue = "";
		$this->Nama_Mhs->TooltipValue = "";

		// Kode_jp
		$this->Kode_jp->LinkCustomAttributes = "";
		$this->Kode_jp->HrefValue = "";
		$this->Kode_jp->TooltipValue = "";

		// Prodi
		$this->Prodi->LinkCustomAttributes = "";
		$this->Prodi->HrefValue = "";
		$this->Prodi->TooltipValue = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->LinkCustomAttributes = "";
		$this->Tmp_Lahir->HrefValue = "";
		$this->Tmp_Lahir->TooltipValue = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->LinkCustomAttributes = "";
		$this->Tgl_Lahir->HrefValue = "";
		$this->Tgl_Lahir->TooltipValue = "";

		// Jenis_Kel
		$this->Jenis_Kel->LinkCustomAttributes = "";
		$this->Jenis_Kel->HrefValue = "";
		$this->Jenis_Kel->TooltipValue = "";

		// Gol_darah
		$this->Gol_darah->LinkCustomAttributes = "";
		$this->Gol_darah->HrefValue = "";
		$this->Gol_darah->TooltipValue = "";

		// Agama_Mhs
		$this->Agama_Mhs->LinkCustomAttributes = "";
		$this->Agama_Mhs->HrefValue = "";
		$this->Agama_Mhs->TooltipValue = "";

		// Alamat_Mhs
		$this->Alamat_Mhs->LinkCustomAttributes = "";
		$this->Alamat_Mhs->HrefValue = "";
		$this->Alamat_Mhs->TooltipValue = "";

		// rt
		$this->rt->LinkCustomAttributes = "";
		$this->rt->HrefValue = "";
		$this->rt->TooltipValue = "";

		// rw
		$this->rw->LinkCustomAttributes = "";
		$this->rw->HrefValue = "";
		$this->rw->TooltipValue = "";

		// Kelurahan
		$this->Kelurahan->LinkCustomAttributes = "";
		$this->Kelurahan->HrefValue = "";
		$this->Kelurahan->TooltipValue = "";

		// id_wilayah
		$this->id_wilayah->LinkCustomAttributes = "";
		$this->id_wilayah->HrefValue = "";
		$this->id_wilayah->TooltipValue = "";

		// nama_wilayah
		$this->nama_wilayah->LinkCustomAttributes = "";
		$this->nama_wilayah->HrefValue = "";
		$this->nama_wilayah->TooltipValue = "";

		// kewarganegaraan
		$this->kewarganegaraan->LinkCustomAttributes = "";
		$this->kewarganegaraan->HrefValue = "";
		$this->kewarganegaraan->TooltipValue = "";

		// Kecamatan
		$this->Kecamatan->LinkCustomAttributes = "";
		$this->Kecamatan->HrefValue = "";
		$this->Kecamatan->TooltipValue = "";

		// Kota_Mhs
		$this->Kota_Mhs->LinkCustomAttributes = "";
		$this->Kota_Mhs->HrefValue = "";
		$this->Kota_Mhs->TooltipValue = "";

		// Provinsi_mhs
		$this->Provinsi_mhs->LinkCustomAttributes = "";
		$this->Provinsi_mhs->HrefValue = "";
		$this->Provinsi_mhs->TooltipValue = "";

		// Kodepos_Mhs
		$this->Kodepos_Mhs->LinkCustomAttributes = "";
		$this->Kodepos_Mhs->HrefValue = "";
		$this->Kodepos_Mhs->TooltipValue = "";

		// Tlp_Mhs
		$this->Tlp_Mhs->LinkCustomAttributes = "";
		$this->Tlp_Mhs->HrefValue = "";
		$this->Tlp_Mhs->TooltipValue = "";

		// TlpRumah
		$this->TlpRumah->LinkCustomAttributes = "";
		$this->TlpRumah->HrefValue = "";
		$this->TlpRumah->TooltipValue = "";

		// Email
		$this->_Email->LinkCustomAttributes = "";
		$this->_Email->HrefValue = "";
		$this->_Email->TooltipValue = "";

		// NIK
		$this->NIK->LinkCustomAttributes = "";
		$this->NIK->HrefValue = "";
		$this->NIK->TooltipValue = "";

		// NamaIbu
		$this->NamaIbu->LinkCustomAttributes = "";
		$this->NamaIbu->HrefValue = "";
		$this->NamaIbu->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// ThMasuk
		$this->ThMasuk->LinkCustomAttributes = "";
		$this->ThMasuk->HrefValue = "";
		$this->ThMasuk->TooltipValue = "";

		// tglmasuk
		$this->tglmasuk->LinkCustomAttributes = "";
		$this->tglmasuk->HrefValue = "";
		$this->tglmasuk->TooltipValue = "";

		// Status_Masuk
		$this->Status_Masuk->LinkCustomAttributes = "";
		$this->Status_Masuk->HrefValue = "";
		$this->Status_Masuk->TooltipValue = "";

		// TaMasuk
		$this->TaMasuk->LinkCustomAttributes = "";
		$this->TaMasuk->HrefValue = "";
		$this->TaMasuk->TooltipValue = "";

		// PerMasuk
		$this->PerMasuk->LinkCustomAttributes = "";
		$this->PerMasuk->HrefValue = "";
		$this->PerMasuk->TooltipValue = "";

		// Pendidikan_Akhir
		$this->Pendidikan_Akhir->LinkCustomAttributes = "";
		$this->Pendidikan_Akhir->HrefValue = "";
		$this->Pendidikan_Akhir->TooltipValue = "";

		// Jurusan
		$this->Jurusan->LinkCustomAttributes = "";
		$this->Jurusan->HrefValue = "";
		$this->Jurusan->TooltipValue = "";

		// Thn_Selesai
		$this->Thn_Selesai->LinkCustomAttributes = "";
		$this->Thn_Selesai->HrefValue = "";
		$this->Thn_Selesai->TooltipValue = "";

		// Kota_Pdkk
		$this->Kota_Pdkk->LinkCustomAttributes = "";
		$this->Kota_Pdkk->HrefValue = "";
		$this->Kota_Pdkk->TooltipValue = "";

		// propinsi
		$this->propinsi->LinkCustomAttributes = "";
		$this->propinsi->HrefValue = "";
		$this->propinsi->TooltipValue = "";

		// NamaSekolahAsal
		$this->NamaSekolahAsal->LinkCustomAttributes = "";
		$this->NamaSekolahAsal->HrefValue = "";
		$this->NamaSekolahAsal->TooltipValue = "";

		// AlamatSekolahAsal
		$this->AlamatSekolahAsal->LinkCustomAttributes = "";
		$this->AlamatSekolahAsal->HrefValue = "";
		$this->AlamatSekolahAsal->TooltipValue = "";

		// InfoDari
		$this->InfoDari->LinkCustomAttributes = "";
		$this->InfoDari->HrefValue = "";
		$this->InfoDari->TooltipValue = "";

		// IdBeasiswa
		$this->IdBeasiswa->LinkCustomAttributes = "";
		$this->IdBeasiswa->HrefValue = "";
		$this->IdBeasiswa->TooltipValue = "";

		// NamaBeasiswa
		$this->NamaBeasiswa->LinkCustomAttributes = "";
		$this->NamaBeasiswa->HrefValue = "";
		$this->NamaBeasiswa->TooltipValue = "";

		// NISS
		$this->NISS->LinkCustomAttributes = "";
		$this->NISS->HrefValue = "";
		$this->NISS->TooltipValue = "";

		// tglDaftar
		$this->tglDaftar->LinkCustomAttributes = "";
		$this->tglDaftar->HrefValue = "";
		$this->tglDaftar->TooltipValue = "";

		// UserName
		$this->UserName->LinkCustomAttributes = "";
		$this->UserName->HrefValue = "";
		$this->UserName->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Nopen
		$this->Nopen->EditAttrs["class"] = "form-control";
		$this->Nopen->EditCustomAttributes = "";
		$this->Nopen->EditValue = $this->Nopen->CurrentValue;
		$this->Nopen->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->EditAttrs["class"] = "form-control";
		$this->Nama_Mhs->EditCustomAttributes = "";
		if (!$this->Nama_Mhs->Raw)
			$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
		$this->Nama_Mhs->EditValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

		// Kode_jp
		$this->Kode_jp->EditAttrs["class"] = "form-control";
		$this->Kode_jp->EditCustomAttributes = "";
		if (!$this->Kode_jp->Raw)
			$this->Kode_jp->CurrentValue = HtmlDecode($this->Kode_jp->CurrentValue);
		$this->Kode_jp->EditValue = $this->Kode_jp->CurrentValue;
		$this->Kode_jp->PlaceHolder = RemoveHtml($this->Kode_jp->caption());

		// Prodi
		$this->Prodi->EditAttrs["class"] = "form-control";
		$this->Prodi->EditCustomAttributes = "";
		if (!$this->Prodi->Raw)
			$this->Prodi->CurrentValue = HtmlDecode($this->Prodi->CurrentValue);
		$this->Prodi->EditValue = $this->Prodi->CurrentValue;
		$this->Prodi->PlaceHolder = RemoveHtml($this->Prodi->caption());

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";
		if (!$this->Kode_Fak->Raw)
			$this->Kode_Fak->CurrentValue = HtmlDecode($this->Kode_Fak->CurrentValue);
		$this->Kode_Fak->EditValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->PlaceHolder = RemoveHtml($this->Kode_Fak->caption());

		// Tmp_Lahir
		$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
		$this->Tmp_Lahir->EditCustomAttributes = "";
		if (!$this->Tmp_Lahir->Raw)
			$this->Tmp_Lahir->CurrentValue = HtmlDecode($this->Tmp_Lahir->CurrentValue);
		$this->Tmp_Lahir->EditValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

		// Tgl_Lahir
		$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
		$this->Tgl_Lahir->EditCustomAttributes = "";
		$this->Tgl_Lahir->EditValue = FormatDateTime($this->Tgl_Lahir->CurrentValue, 8);
		$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

		// Jenis_Kel
		$this->Jenis_Kel->EditAttrs["class"] = "form-control";
		$this->Jenis_Kel->EditCustomAttributes = "";
		if (!$this->Jenis_Kel->Raw)
			$this->Jenis_Kel->CurrentValue = HtmlDecode($this->Jenis_Kel->CurrentValue);
		$this->Jenis_Kel->EditValue = $this->Jenis_Kel->CurrentValue;
		$this->Jenis_Kel->PlaceHolder = RemoveHtml($this->Jenis_Kel->caption());

		// Gol_darah
		$this->Gol_darah->EditAttrs["class"] = "form-control";
		$this->Gol_darah->EditCustomAttributes = "";
		if (!$this->Gol_darah->Raw)
			$this->Gol_darah->CurrentValue = HtmlDecode($this->Gol_darah->CurrentValue);
		$this->Gol_darah->EditValue = $this->Gol_darah->CurrentValue;
		$this->Gol_darah->PlaceHolder = RemoveHtml($this->Gol_darah->caption());

		// Agama_Mhs
		$this->Agama_Mhs->EditAttrs["class"] = "form-control";
		$this->Agama_Mhs->EditCustomAttributes = "";
		if (!$this->Agama_Mhs->Raw)
			$this->Agama_Mhs->CurrentValue = HtmlDecode($this->Agama_Mhs->CurrentValue);
		$this->Agama_Mhs->EditValue = $this->Agama_Mhs->CurrentValue;
		$this->Agama_Mhs->PlaceHolder = RemoveHtml($this->Agama_Mhs->caption());

		// Alamat_Mhs
		$this->Alamat_Mhs->EditAttrs["class"] = "form-control";
		$this->Alamat_Mhs->EditCustomAttributes = "";
		if (!$this->Alamat_Mhs->Raw)
			$this->Alamat_Mhs->CurrentValue = HtmlDecode($this->Alamat_Mhs->CurrentValue);
		$this->Alamat_Mhs->EditValue = $this->Alamat_Mhs->CurrentValue;
		$this->Alamat_Mhs->PlaceHolder = RemoveHtml($this->Alamat_Mhs->caption());

		// rt
		$this->rt->EditAttrs["class"] = "form-control";
		$this->rt->EditCustomAttributes = "";
		if (!$this->rt->Raw)
			$this->rt->CurrentValue = HtmlDecode($this->rt->CurrentValue);
		$this->rt->EditValue = $this->rt->CurrentValue;
		$this->rt->PlaceHolder = RemoveHtml($this->rt->caption());

		// rw
		$this->rw->EditAttrs["class"] = "form-control";
		$this->rw->EditCustomAttributes = "";
		if (!$this->rw->Raw)
			$this->rw->CurrentValue = HtmlDecode($this->rw->CurrentValue);
		$this->rw->EditValue = $this->rw->CurrentValue;
		$this->rw->PlaceHolder = RemoveHtml($this->rw->caption());

		// Kelurahan
		$this->Kelurahan->EditAttrs["class"] = "form-control";
		$this->Kelurahan->EditCustomAttributes = "";
		if (!$this->Kelurahan->Raw)
			$this->Kelurahan->CurrentValue = HtmlDecode($this->Kelurahan->CurrentValue);
		$this->Kelurahan->EditValue = $this->Kelurahan->CurrentValue;
		$this->Kelurahan->PlaceHolder = RemoveHtml($this->Kelurahan->caption());

		// id_wilayah
		$this->id_wilayah->EditAttrs["class"] = "form-control";
		$this->id_wilayah->EditCustomAttributes = "";
		if (!$this->id_wilayah->Raw)
			$this->id_wilayah->CurrentValue = HtmlDecode($this->id_wilayah->CurrentValue);
		$this->id_wilayah->EditValue = $this->id_wilayah->CurrentValue;
		$this->id_wilayah->PlaceHolder = RemoveHtml($this->id_wilayah->caption());

		// nama_wilayah
		$this->nama_wilayah->EditAttrs["class"] = "form-control";
		$this->nama_wilayah->EditCustomAttributes = "";
		if (!$this->nama_wilayah->Raw)
			$this->nama_wilayah->CurrentValue = HtmlDecode($this->nama_wilayah->CurrentValue);
		$this->nama_wilayah->EditValue = $this->nama_wilayah->CurrentValue;
		$this->nama_wilayah->PlaceHolder = RemoveHtml($this->nama_wilayah->caption());

		// kewarganegaraan
		$this->kewarganegaraan->EditAttrs["class"] = "form-control";
		$this->kewarganegaraan->EditCustomAttributes = "";
		if (!$this->kewarganegaraan->Raw)
			$this->kewarganegaraan->CurrentValue = HtmlDecode($this->kewarganegaraan->CurrentValue);
		$this->kewarganegaraan->EditValue = $this->kewarganegaraan->CurrentValue;
		$this->kewarganegaraan->PlaceHolder = RemoveHtml($this->kewarganegaraan->caption());

		// Kecamatan
		$this->Kecamatan->EditAttrs["class"] = "form-control";
		$this->Kecamatan->EditCustomAttributes = "";
		if (!$this->Kecamatan->Raw)
			$this->Kecamatan->CurrentValue = HtmlDecode($this->Kecamatan->CurrentValue);
		$this->Kecamatan->EditValue = $this->Kecamatan->CurrentValue;
		$this->Kecamatan->PlaceHolder = RemoveHtml($this->Kecamatan->caption());

		// Kota_Mhs
		$this->Kota_Mhs->EditAttrs["class"] = "form-control";
		$this->Kota_Mhs->EditCustomAttributes = "";
		if (!$this->Kota_Mhs->Raw)
			$this->Kota_Mhs->CurrentValue = HtmlDecode($this->Kota_Mhs->CurrentValue);
		$this->Kota_Mhs->EditValue = $this->Kota_Mhs->CurrentValue;
		$this->Kota_Mhs->PlaceHolder = RemoveHtml($this->Kota_Mhs->caption());

		// Provinsi_mhs
		$this->Provinsi_mhs->EditAttrs["class"] = "form-control";
		$this->Provinsi_mhs->EditCustomAttributes = "";
		if (!$this->Provinsi_mhs->Raw)
			$this->Provinsi_mhs->CurrentValue = HtmlDecode($this->Provinsi_mhs->CurrentValue);
		$this->Provinsi_mhs->EditValue = $this->Provinsi_mhs->CurrentValue;
		$this->Provinsi_mhs->PlaceHolder = RemoveHtml($this->Provinsi_mhs->caption());

		// Kodepos_Mhs
		$this->Kodepos_Mhs->EditAttrs["class"] = "form-control";
		$this->Kodepos_Mhs->EditCustomAttributes = "";
		if (!$this->Kodepos_Mhs->Raw)
			$this->Kodepos_Mhs->CurrentValue = HtmlDecode($this->Kodepos_Mhs->CurrentValue);
		$this->Kodepos_Mhs->EditValue = $this->Kodepos_Mhs->CurrentValue;
		$this->Kodepos_Mhs->PlaceHolder = RemoveHtml($this->Kodepos_Mhs->caption());

		// Tlp_Mhs
		$this->Tlp_Mhs->EditAttrs["class"] = "form-control";
		$this->Tlp_Mhs->EditCustomAttributes = "";
		if (!$this->Tlp_Mhs->Raw)
			$this->Tlp_Mhs->CurrentValue = HtmlDecode($this->Tlp_Mhs->CurrentValue);
		$this->Tlp_Mhs->EditValue = $this->Tlp_Mhs->CurrentValue;
		$this->Tlp_Mhs->PlaceHolder = RemoveHtml($this->Tlp_Mhs->caption());

		// TlpRumah
		$this->TlpRumah->EditAttrs["class"] = "form-control";
		$this->TlpRumah->EditCustomAttributes = "";
		if (!$this->TlpRumah->Raw)
			$this->TlpRumah->CurrentValue = HtmlDecode($this->TlpRumah->CurrentValue);
		$this->TlpRumah->EditValue = $this->TlpRumah->CurrentValue;
		$this->TlpRumah->PlaceHolder = RemoveHtml($this->TlpRumah->caption());

		// Email
		$this->_Email->EditAttrs["class"] = "form-control";
		$this->_Email->EditCustomAttributes = "";
		if (!$this->_Email->Raw)
			$this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
		$this->_Email->EditValue = $this->_Email->CurrentValue;
		$this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

		// NIK
		$this->NIK->EditAttrs["class"] = "form-control";
		$this->NIK->EditCustomAttributes = "";
		if (!$this->NIK->Raw)
			$this->NIK->CurrentValue = HtmlDecode($this->NIK->CurrentValue);
		$this->NIK->EditValue = $this->NIK->CurrentValue;
		$this->NIK->PlaceHolder = RemoveHtml($this->NIK->caption());

		// NamaIbu
		$this->NamaIbu->EditAttrs["class"] = "form-control";
		$this->NamaIbu->EditCustomAttributes = "";
		if (!$this->NamaIbu->Raw)
			$this->NamaIbu->CurrentValue = HtmlDecode($this->NamaIbu->CurrentValue);
		$this->NamaIbu->EditValue = $this->NamaIbu->CurrentValue;
		$this->NamaIbu->PlaceHolder = RemoveHtml($this->NamaIbu->caption());

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";
		if (!$this->Status_Akd->Raw)
			$this->Status_Akd->CurrentValue = HtmlDecode($this->Status_Akd->CurrentValue);
		$this->Status_Akd->EditValue = $this->Status_Akd->CurrentValue;
		$this->Status_Akd->PlaceHolder = RemoveHtml($this->Status_Akd->caption());

		// ThMasuk
		$this->ThMasuk->EditAttrs["class"] = "form-control";
		$this->ThMasuk->EditCustomAttributes = "";
		if (!$this->ThMasuk->Raw)
			$this->ThMasuk->CurrentValue = HtmlDecode($this->ThMasuk->CurrentValue);
		$this->ThMasuk->EditValue = $this->ThMasuk->CurrentValue;
		$this->ThMasuk->PlaceHolder = RemoveHtml($this->ThMasuk->caption());

		// tglmasuk
		$this->tglmasuk->EditAttrs["class"] = "form-control";
		$this->tglmasuk->EditCustomAttributes = "";
		$this->tglmasuk->EditValue = FormatDateTime($this->tglmasuk->CurrentValue, 8);
		$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

		// Status_Masuk
		$this->Status_Masuk->EditAttrs["class"] = "form-control";
		$this->Status_Masuk->EditCustomAttributes = "";
		if (!$this->Status_Masuk->Raw)
			$this->Status_Masuk->CurrentValue = HtmlDecode($this->Status_Masuk->CurrentValue);
		$this->Status_Masuk->EditValue = $this->Status_Masuk->CurrentValue;
		$this->Status_Masuk->PlaceHolder = RemoveHtml($this->Status_Masuk->caption());

		// TaMasuk
		$this->TaMasuk->EditAttrs["class"] = "form-control";
		$this->TaMasuk->EditCustomAttributes = "";
		if (!$this->TaMasuk->Raw)
			$this->TaMasuk->CurrentValue = HtmlDecode($this->TaMasuk->CurrentValue);
		$this->TaMasuk->EditValue = $this->TaMasuk->CurrentValue;
		$this->TaMasuk->PlaceHolder = RemoveHtml($this->TaMasuk->caption());

		// PerMasuk
		$this->PerMasuk->EditAttrs["class"] = "form-control";
		$this->PerMasuk->EditCustomAttributes = "";
		if (!$this->PerMasuk->Raw)
			$this->PerMasuk->CurrentValue = HtmlDecode($this->PerMasuk->CurrentValue);
		$this->PerMasuk->EditValue = $this->PerMasuk->CurrentValue;
		$this->PerMasuk->PlaceHolder = RemoveHtml($this->PerMasuk->caption());

		// Pendidikan_Akhir
		$this->Pendidikan_Akhir->EditAttrs["class"] = "form-control";
		$this->Pendidikan_Akhir->EditCustomAttributes = "";
		if (!$this->Pendidikan_Akhir->Raw)
			$this->Pendidikan_Akhir->CurrentValue = HtmlDecode($this->Pendidikan_Akhir->CurrentValue);
		$this->Pendidikan_Akhir->EditValue = $this->Pendidikan_Akhir->CurrentValue;
		$this->Pendidikan_Akhir->PlaceHolder = RemoveHtml($this->Pendidikan_Akhir->caption());

		// Jurusan
		$this->Jurusan->EditAttrs["class"] = "form-control";
		$this->Jurusan->EditCustomAttributes = "";
		if (!$this->Jurusan->Raw)
			$this->Jurusan->CurrentValue = HtmlDecode($this->Jurusan->CurrentValue);
		$this->Jurusan->EditValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->PlaceHolder = RemoveHtml($this->Jurusan->caption());

		// Thn_Selesai
		$this->Thn_Selesai->EditAttrs["class"] = "form-control";
		$this->Thn_Selesai->EditCustomAttributes = "";
		if (!$this->Thn_Selesai->Raw)
			$this->Thn_Selesai->CurrentValue = HtmlDecode($this->Thn_Selesai->CurrentValue);
		$this->Thn_Selesai->EditValue = $this->Thn_Selesai->CurrentValue;
		$this->Thn_Selesai->PlaceHolder = RemoveHtml($this->Thn_Selesai->caption());

		// Kota_Pdkk
		$this->Kota_Pdkk->EditAttrs["class"] = "form-control";
		$this->Kota_Pdkk->EditCustomAttributes = "";
		if (!$this->Kota_Pdkk->Raw)
			$this->Kota_Pdkk->CurrentValue = HtmlDecode($this->Kota_Pdkk->CurrentValue);
		$this->Kota_Pdkk->EditValue = $this->Kota_Pdkk->CurrentValue;
		$this->Kota_Pdkk->PlaceHolder = RemoveHtml($this->Kota_Pdkk->caption());

		// propinsi
		$this->propinsi->EditAttrs["class"] = "form-control";
		$this->propinsi->EditCustomAttributes = "";
		if (!$this->propinsi->Raw)
			$this->propinsi->CurrentValue = HtmlDecode($this->propinsi->CurrentValue);
		$this->propinsi->EditValue = $this->propinsi->CurrentValue;
		$this->propinsi->PlaceHolder = RemoveHtml($this->propinsi->caption());

		// NamaSekolahAsal
		$this->NamaSekolahAsal->EditAttrs["class"] = "form-control";
		$this->NamaSekolahAsal->EditCustomAttributes = "";
		if (!$this->NamaSekolahAsal->Raw)
			$this->NamaSekolahAsal->CurrentValue = HtmlDecode($this->NamaSekolahAsal->CurrentValue);
		$this->NamaSekolahAsal->EditValue = $this->NamaSekolahAsal->CurrentValue;
		$this->NamaSekolahAsal->PlaceHolder = RemoveHtml($this->NamaSekolahAsal->caption());

		// AlamatSekolahAsal
		$this->AlamatSekolahAsal->EditAttrs["class"] = "form-control";
		$this->AlamatSekolahAsal->EditCustomAttributes = "";
		if (!$this->AlamatSekolahAsal->Raw)
			$this->AlamatSekolahAsal->CurrentValue = HtmlDecode($this->AlamatSekolahAsal->CurrentValue);
		$this->AlamatSekolahAsal->EditValue = $this->AlamatSekolahAsal->CurrentValue;
		$this->AlamatSekolahAsal->PlaceHolder = RemoveHtml($this->AlamatSekolahAsal->caption());

		// InfoDari
		$this->InfoDari->EditAttrs["class"] = "form-control";
		$this->InfoDari->EditCustomAttributes = "";
		if (!$this->InfoDari->Raw)
			$this->InfoDari->CurrentValue = HtmlDecode($this->InfoDari->CurrentValue);
		$this->InfoDari->EditValue = $this->InfoDari->CurrentValue;
		$this->InfoDari->PlaceHolder = RemoveHtml($this->InfoDari->caption());

		// IdBeasiswa
		$this->IdBeasiswa->EditAttrs["class"] = "form-control";
		$this->IdBeasiswa->EditCustomAttributes = "";
		$this->IdBeasiswa->EditValue = $this->IdBeasiswa->CurrentValue;
		$this->IdBeasiswa->PlaceHolder = RemoveHtml($this->IdBeasiswa->caption());

		// NamaBeasiswa
		$this->NamaBeasiswa->EditAttrs["class"] = "form-control";
		$this->NamaBeasiswa->EditCustomAttributes = "";
		if (!$this->NamaBeasiswa->Raw)
			$this->NamaBeasiswa->CurrentValue = HtmlDecode($this->NamaBeasiswa->CurrentValue);
		$this->NamaBeasiswa->EditValue = $this->NamaBeasiswa->CurrentValue;
		$this->NamaBeasiswa->PlaceHolder = RemoveHtml($this->NamaBeasiswa->caption());

		// NISS
		$this->NISS->EditAttrs["class"] = "form-control";
		$this->NISS->EditCustomAttributes = "";
		if (!$this->NISS->Raw)
			$this->NISS->CurrentValue = HtmlDecode($this->NISS->CurrentValue);
		$this->NISS->EditValue = $this->NISS->CurrentValue;
		$this->NISS->PlaceHolder = RemoveHtml($this->NISS->caption());

		// tglDaftar
		$this->tglDaftar->EditAttrs["class"] = "form-control";
		$this->tglDaftar->EditCustomAttributes = "";
		$this->tglDaftar->EditValue = FormatDateTime($this->tglDaftar->CurrentValue, 8);
		$this->tglDaftar->PlaceHolder = RemoveHtml($this->tglDaftar->caption());

		// UserName
		$this->UserName->EditAttrs["class"] = "form-control";
		$this->UserName->EditCustomAttributes = "";
		if (!$this->UserName->Raw)
			$this->UserName->CurrentValue = HtmlDecode($this->UserName->CurrentValue);
		$this->UserName->EditValue = $this->UserName->CurrentValue;
		$this->UserName->PlaceHolder = RemoveHtml($this->UserName->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Nopen);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Prodi);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Jenis_Kel);
					$doc->exportCaption($this->Gol_darah);
					$doc->exportCaption($this->Agama_Mhs);
					$doc->exportCaption($this->Alamat_Mhs);
					$doc->exportCaption($this->rt);
					$doc->exportCaption($this->rw);
					$doc->exportCaption($this->Kelurahan);
					$doc->exportCaption($this->id_wilayah);
					$doc->exportCaption($this->nama_wilayah);
					$doc->exportCaption($this->kewarganegaraan);
					$doc->exportCaption($this->Kecamatan);
					$doc->exportCaption($this->Kota_Mhs);
					$doc->exportCaption($this->Provinsi_mhs);
					$doc->exportCaption($this->Kodepos_Mhs);
					$doc->exportCaption($this->Tlp_Mhs);
					$doc->exportCaption($this->TlpRumah);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->NIK);
					$doc->exportCaption($this->NamaIbu);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->ThMasuk);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Status_Masuk);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->Pendidikan_Akhir);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Thn_Selesai);
					$doc->exportCaption($this->Kota_Pdkk);
					$doc->exportCaption($this->propinsi);
					$doc->exportCaption($this->NamaSekolahAsal);
					$doc->exportCaption($this->AlamatSekolahAsal);
					$doc->exportCaption($this->InfoDari);
					$doc->exportCaption($this->IdBeasiswa);
					$doc->exportCaption($this->NamaBeasiswa);
					$doc->exportCaption($this->NISS);
					$doc->exportCaption($this->tglDaftar);
					$doc->exportCaption($this->UserName);
				} else {
					$doc->exportCaption($this->Nopen);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Prodi);
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Jenis_Kel);
					$doc->exportCaption($this->Gol_darah);
					$doc->exportCaption($this->Agama_Mhs);
					$doc->exportCaption($this->Alamat_Mhs);
					$doc->exportCaption($this->rt);
					$doc->exportCaption($this->rw);
					$doc->exportCaption($this->Kelurahan);
					$doc->exportCaption($this->id_wilayah);
					$doc->exportCaption($this->nama_wilayah);
					$doc->exportCaption($this->kewarganegaraan);
					$doc->exportCaption($this->Kecamatan);
					$doc->exportCaption($this->Kota_Mhs);
					$doc->exportCaption($this->Provinsi_mhs);
					$doc->exportCaption($this->Kodepos_Mhs);
					$doc->exportCaption($this->Tlp_Mhs);
					$doc->exportCaption($this->TlpRumah);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->NIK);
					$doc->exportCaption($this->NamaIbu);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->ThMasuk);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Status_Masuk);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->Pendidikan_Akhir);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Thn_Selesai);
					$doc->exportCaption($this->Kota_Pdkk);
					$doc->exportCaption($this->propinsi);
					$doc->exportCaption($this->NamaSekolahAsal);
					$doc->exportCaption($this->AlamatSekolahAsal);
					$doc->exportCaption($this->InfoDari);
					$doc->exportCaption($this->IdBeasiswa);
					$doc->exportCaption($this->NamaBeasiswa);
					$doc->exportCaption($this->NISS);
					$doc->exportCaption($this->tglDaftar);
					$doc->exportCaption($this->UserName);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Nopen);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Prodi);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Jenis_Kel);
						$doc->exportField($this->Gol_darah);
						$doc->exportField($this->Agama_Mhs);
						$doc->exportField($this->Alamat_Mhs);
						$doc->exportField($this->rt);
						$doc->exportField($this->rw);
						$doc->exportField($this->Kelurahan);
						$doc->exportField($this->id_wilayah);
						$doc->exportField($this->nama_wilayah);
						$doc->exportField($this->kewarganegaraan);
						$doc->exportField($this->Kecamatan);
						$doc->exportField($this->Kota_Mhs);
						$doc->exportField($this->Provinsi_mhs);
						$doc->exportField($this->Kodepos_Mhs);
						$doc->exportField($this->Tlp_Mhs);
						$doc->exportField($this->TlpRumah);
						$doc->exportField($this->_Email);
						$doc->exportField($this->NIK);
						$doc->exportField($this->NamaIbu);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->ThMasuk);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Status_Masuk);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->Pendidikan_Akhir);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Thn_Selesai);
						$doc->exportField($this->Kota_Pdkk);
						$doc->exportField($this->propinsi);
						$doc->exportField($this->NamaSekolahAsal);
						$doc->exportField($this->AlamatSekolahAsal);
						$doc->exportField($this->InfoDari);
						$doc->exportField($this->IdBeasiswa);
						$doc->exportField($this->NamaBeasiswa);
						$doc->exportField($this->NISS);
						$doc->exportField($this->tglDaftar);
						$doc->exportField($this->UserName);
					} else {
						$doc->exportField($this->Nopen);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Prodi);
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Jenis_Kel);
						$doc->exportField($this->Gol_darah);
						$doc->exportField($this->Agama_Mhs);
						$doc->exportField($this->Alamat_Mhs);
						$doc->exportField($this->rt);
						$doc->exportField($this->rw);
						$doc->exportField($this->Kelurahan);
						$doc->exportField($this->id_wilayah);
						$doc->exportField($this->nama_wilayah);
						$doc->exportField($this->kewarganegaraan);
						$doc->exportField($this->Kecamatan);
						$doc->exportField($this->Kota_Mhs);
						$doc->exportField($this->Provinsi_mhs);
						$doc->exportField($this->Kodepos_Mhs);
						$doc->exportField($this->Tlp_Mhs);
						$doc->exportField($this->TlpRumah);
						$doc->exportField($this->_Email);
						$doc->exportField($this->NIK);
						$doc->exportField($this->NamaIbu);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->ThMasuk);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Status_Masuk);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->Pendidikan_Akhir);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Thn_Selesai);
						$doc->exportField($this->Kota_Pdkk);
						$doc->exportField($this->propinsi);
						$doc->exportField($this->NamaSekolahAsal);
						$doc->exportField($this->AlamatSekolahAsal);
						$doc->exportField($this->InfoDari);
						$doc->exportField($this->IdBeasiswa);
						$doc->exportField($this->NamaBeasiswa);
						$doc->exportField($this->NISS);
						$doc->exportField($this->tglDaftar);
						$doc->exportField($this->UserName);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>