<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for Wali_IPS
 */
class Wali_IPS extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Nim;
	public $Thn_Akademik;
	public $Periode;
	public $TSKS;
	public $ips;
	public $Thdr;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'Wali_IPS';
		$this->TableName = 'Wali_IPS';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[Wali_IPS]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Nim
		$this->Nim = new DbField('Wali_IPS', 'Wali_IPS', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 129, 14, -1, FALSE, '[Nim]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nim->IsForeignKey = TRUE; // Foreign key field
		$this->Nim->Nullable = FALSE; // NOT NULL field
		$this->Nim->Required = TRUE; // Required field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->fields['Nim'] = &$this->Nim;

		// Thn_Akademik
		$this->Thn_Akademik = new DbField('Wali_IPS', 'Wali_IPS', 'x_Thn_Akademik', 'Thn_Akademik', '[Thn_Akademik]', '[Thn_Akademik]', 129, 9, -1, FALSE, '[Thn_Akademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Thn_Akademik->IsForeignKey = TRUE; // Foreign key field
		$this->Thn_Akademik->Nullable = FALSE; // NOT NULL field
		$this->Thn_Akademik->Required = TRUE; // Required field
		$this->Thn_Akademik->Sortable = TRUE; // Allow sort
		$this->fields['Thn_Akademik'] = &$this->Thn_Akademik;

		// Periode
		$this->Periode = new DbField('Wali_IPS', 'Wali_IPS', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 129, 2, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Periode->IsForeignKey = TRUE; // Foreign key field
		$this->Periode->Nullable = FALSE; // NOT NULL field
		$this->Periode->Required = TRUE; // Required field
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->fields['Periode'] = &$this->Periode;

		// TSKS
		$this->TSKS = new DbField('Wali_IPS', 'Wali_IPS', 'x_TSKS', 'TSKS', '[TSKS]', 'CAST([TSKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[TSKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TSKS->Sortable = TRUE; // Allow sort
		$this->TSKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['TSKS'] = &$this->TSKS;

		// ips
		$this->ips = new DbField('Wali_IPS', 'Wali_IPS', 'x_ips', 'ips', '[ips]', 'CAST([ips] AS NVARCHAR)', 131, 8, -1, FALSE, '[ips]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ips->Sortable = TRUE; // Allow sort
		$this->ips->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ips'] = &$this->ips;

		// Thdr
		$this->Thdr = new DbField('Wali_IPS', 'Wali_IPS', 'x_Thdr', 'Thdr', '[Thdr]', 'CAST([Thdr] AS NVARCHAR)', 5, 8, -1, FALSE, '[Thdr]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Thdr->Sortable = TRUE; // Allow sort
		$this->Thdr->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Thdr'] = &$this->Thdr;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "QmhsAktif") {
			if ($this->Thn_Akademik->getSessionValue() != "")
				$masterFilter .= "[Thn_Akademik]=" . QuotedValue($this->Thn_Akademik->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Periode->getSessionValue() != "")
				$masterFilter .= " AND [Periode]=" . QuotedValue($this->Periode->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Nim->getSessionValue() != "")
				$masterFilter .= " AND [Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "tblMHS") {
			if ($this->Nim->getSessionValue() != "")
				$masterFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "QBeasiswa") {
			if ($this->Nim->getSessionValue() != "")
				$masterFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "ekpt_mhsfeed") {
			if ($this->Nim->getSessionValue() != "")
				$masterFilter .= "[NimIM]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "IM_Mhs") {
			if ($this->Nim->getSessionValue() != "")
				$masterFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "QmhsAktif") {
			if ($this->Thn_Akademik->getSessionValue() != "")
				$detailFilter .= "[Thn_Akademik]=" . QuotedValue($this->Thn_Akademik->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Periode->getSessionValue() != "")
				$detailFilter .= " AND [Periode]=" . QuotedValue($this->Periode->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Nim->getSessionValue() != "")
				$detailFilter .= " AND [Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "tblMHS") {
			if ($this->Nim->getSessionValue() != "")
				$detailFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "QBeasiswa") {
			if ($this->Nim->getSessionValue() != "")
				$detailFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "ekpt_mhsfeed") {
			if ($this->Nim->getSessionValue() != "")
				$detailFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "IM_Mhs") {
			if ($this->Nim->getSessionValue() != "")
				$detailFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_QmhsAktif()
	{
		return "[Thn_Akademik]='@Thn_Akademik@' AND [Periode]='@Periode@' AND [Nim]='@Nim@'";
	}

	// Detail filter
	public function sqlDetailFilter_QmhsAktif()
	{
		return "[Thn_Akademik]='@Thn_Akademik@' AND [Periode]='@Periode@' AND [Nim]='@Nim@'";
	}

	// Master filter
	public function sqlMasterFilter_tblMHS()
	{
		return "[Nim]='@Nim@'";
	}

	// Detail filter
	public function sqlDetailFilter_tblMHS()
	{
		return "[Nim]='@Nim@'";
	}

	// Master filter
	public function sqlMasterFilter_QBeasiswa()
	{
		return "[Nim]='@Nim@'";
	}

	// Detail filter
	public function sqlDetailFilter_QBeasiswa()
	{
		return "[Nim]='@Nim@'";
	}

	// Master filter
	public function sqlMasterFilter_ekpt_mhsfeed()
	{
		return "[NimIM]='@NimIM@'";
	}

	// Detail filter
	public function sqlDetailFilter_ekpt_mhsfeed()
	{
		return "[Nim]='@Nim@'";
	}

	// Master filter
	public function sqlMasterFilter_IM_Mhs()
	{
		return "[Nim]='@Nim@'";
	}

	// Detail filter
	public function sqlDetailFilter_IM_Mhs()
	{
		return "[Nim]='@Nim@'";
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "Wali_Nilai") {
			$detailUrl = $GLOBALS["Wali_Nilai"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
			$detailUrl .= "&fk_Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
			$detailUrl .= "&fk_Periode=" . urlencode($this->Periode->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "Wali_IPSlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[Wali_IPS]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "[Thn_Akademik] ASC,[Periode] ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Nim->DbValue = $row['Nim'];
		$this->Thn_Akademik->DbValue = $row['Thn_Akademik'];
		$this->Periode->DbValue = $row['Periode'];
		$this->TSKS->DbValue = $row['TSKS'];
		$this->ips->DbValue = $row['ips'];
		$this->Thdr->DbValue = $row['Thdr'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "Wali_IPSlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "Wali_IPSview.php")
			return $Language->phrase("View");
		elseif ($pageName == "Wali_IPSedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "Wali_IPSadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "Wali_IPSlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("Wali_IPSview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("Wali_IPSview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "Wali_IPSadd.php?" . $this->getUrlParm($parm);
		else
			$url = "Wali_IPSadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("Wali_IPSedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("Wali_IPSadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("Wali_IPSdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "QmhsAktif" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
			$url .= "&fk_Periode=" . urlencode($this->Periode->CurrentValue);
			$url .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "tblMHS" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "QBeasiswa" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "ekpt_mhsfeed" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_NimIM=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "IM_Mhs" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->Thn_Akademik->setDbValue($rs->fields('Thn_Akademik'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->TSKS->setDbValue($rs->fields('TSKS'));
		$this->ips->setDbValue($rs->fields('ips'));
		$this->Thdr->setDbValue($rs->fields('Thdr'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Nim
		// Thn_Akademik
		// Periode
		// TSKS
		// ips
		// Thdr
		// Nim

		$this->Nim->ViewValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// Thn_Akademik
		$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
		$this->Thn_Akademik->ViewCustomAttributes = "";

		// Periode
		$this->Periode->ViewValue = $this->Periode->CurrentValue;
		$this->Periode->ViewCustomAttributes = "";

		// TSKS
		$this->TSKS->ViewValue = $this->TSKS->CurrentValue;
		$this->TSKS->ViewValue = FormatNumber($this->TSKS->ViewValue, 0, -2, -2, -2);
		$this->TSKS->ViewCustomAttributes = "";

		// ips
		$this->ips->ViewValue = $this->ips->CurrentValue;
		$this->ips->ViewValue = FormatNumber($this->ips->ViewValue, 2, -2, -2, -2);
		$this->ips->ViewCustomAttributes = "";

		// Thdr
		$this->Thdr->ViewValue = $this->Thdr->CurrentValue;
		$this->Thdr->ViewValue = FormatNumber($this->Thdr->ViewValue, 2, -2, -2, -2);
		$this->Thdr->ViewCustomAttributes = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// Thn_Akademik
		$this->Thn_Akademik->LinkCustomAttributes = "";
		$this->Thn_Akademik->HrefValue = "";
		$this->Thn_Akademik->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// TSKS
		$this->TSKS->LinkCustomAttributes = "";
		$this->TSKS->HrefValue = "";
		$this->TSKS->TooltipValue = "";

		// ips
		$this->ips->LinkCustomAttributes = "";
		$this->ips->HrefValue = "";
		$this->ips->TooltipValue = "";

		// Thdr
		$this->Thdr->LinkCustomAttributes = "";
		$this->Thdr->HrefValue = "";
		$this->Thdr->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";
		if ($this->Nim->getSessionValue() != "") {
			$this->Nim->CurrentValue = $this->Nim->getSessionValue();
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";
		} else {
			if (!$this->Nim->Raw)
				$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
			$this->Nim->EditValue = $this->Nim->CurrentValue;
			$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());
		}

		// Thn_Akademik
		$this->Thn_Akademik->EditAttrs["class"] = "form-control";
		$this->Thn_Akademik->EditCustomAttributes = "";
		if ($this->Thn_Akademik->getSessionValue() != "") {
			$this->Thn_Akademik->CurrentValue = $this->Thn_Akademik->getSessionValue();
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
			$this->Thn_Akademik->ViewCustomAttributes = "";
		} else {
			if (!$this->Thn_Akademik->Raw)
				$this->Thn_Akademik->CurrentValue = HtmlDecode($this->Thn_Akademik->CurrentValue);
			$this->Thn_Akademik->EditValue = $this->Thn_Akademik->CurrentValue;
			$this->Thn_Akademik->PlaceHolder = RemoveHtml($this->Thn_Akademik->caption());
		}

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		if ($this->Periode->getSessionValue() != "") {
			$this->Periode->CurrentValue = $this->Periode->getSessionValue();
			$this->Periode->ViewValue = $this->Periode->CurrentValue;
			$this->Periode->ViewCustomAttributes = "";
		} else {
			if (!$this->Periode->Raw)
				$this->Periode->CurrentValue = HtmlDecode($this->Periode->CurrentValue);
			$this->Periode->EditValue = $this->Periode->CurrentValue;
			$this->Periode->PlaceHolder = RemoveHtml($this->Periode->caption());
		}

		// TSKS
		$this->TSKS->EditAttrs["class"] = "form-control";
		$this->TSKS->EditCustomAttributes = "";
		$this->TSKS->EditValue = $this->TSKS->CurrentValue;
		$this->TSKS->PlaceHolder = RemoveHtml($this->TSKS->caption());

		// ips
		$this->ips->EditAttrs["class"] = "form-control";
		$this->ips->EditCustomAttributes = "";
		$this->ips->EditValue = $this->ips->CurrentValue;
		$this->ips->PlaceHolder = RemoveHtml($this->ips->caption());
		if (strval($this->ips->EditValue) != "" && is_numeric($this->ips->EditValue))
			$this->ips->EditValue = FormatNumber($this->ips->EditValue, -2, -2, -2, -2);
		

		// Thdr
		$this->Thdr->EditAttrs["class"] = "form-control";
		$this->Thdr->EditCustomAttributes = "";
		$this->Thdr->EditValue = $this->Thdr->CurrentValue;
		$this->Thdr->PlaceHolder = RemoveHtml($this->Thdr->caption());
		if (strval($this->Thdr->EditValue) != "" && is_numeric($this->Thdr->EditValue))
			$this->Thdr->EditValue = FormatNumber($this->Thdr->EditValue, -2, -2, -2, -2);
		

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->TSKS->CurrentValue))
				$this->TSKS->Total += $this->TSKS->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->TSKS->CurrentValue = $this->TSKS->Total;
			$this->TSKS->ViewValue = $this->TSKS->CurrentValue;
			$this->TSKS->ViewValue = FormatNumber($this->TSKS->ViewValue, 0, -2, -2, -2);
			$this->TSKS->ViewCustomAttributes = "";
			$this->TSKS->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->TSKS);
					$doc->exportCaption($this->ips);
					$doc->exportCaption($this->Thdr);
				} else {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->TSKS);
					$doc->exportCaption($this->ips);
					$doc->exportCaption($this->Thdr);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->TSKS);
						$doc->exportField($this->ips);
						$doc->exportField($this->Thdr);
					} else {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->TSKS);
						$doc->exportField($this->ips);
						$doc->exportField($this->Thdr);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->Nim, '');
				$doc->exportAggregate($this->Thn_Akademik, '');
				$doc->exportAggregate($this->Periode, '');
				$doc->exportAggregate($this->TSKS, 'TOTAL');
				$doc->exportAggregate($this->ips, '');
				$doc->exportAggregate($this->Thdr, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>