<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for docmhs
 */
class docmhs extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Nim;
	public $Ijazah;
	public $Ktp;
	public $KK;
	public $tandatangan;
	public $IjazahIM;
	public $TranskriptIM;
	public $Skripsi;
	public $Plagiat;
	public $riwayatakademik;
	public $keuangan;
	public $pendukung;
	public $lainlain;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'docmhs';
		$this->TableName = 'docmhs';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[docmhs]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Nim
		$this->Nim = new DbField('docmhs', 'docmhs', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 200, 14, -1, FALSE, '[Nim]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nim->IsPrimaryKey = TRUE; // Primary key field
		$this->Nim->IsForeignKey = TRUE; // Foreign key field
		$this->Nim->Nullable = FALSE; // NOT NULL field
		$this->Nim->Required = TRUE; // Required field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->fields['Nim'] = &$this->Nim;

		// Ijazah
		$this->Ijazah = new DbField('docmhs', 'docmhs', 'x_Ijazah', 'Ijazah', '[Ijazah]', '[Ijazah]', 200, 150, -1, TRUE, '[Ijazah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->Ijazah->Sortable = TRUE; // Allow sort
		$this->fields['Ijazah'] = &$this->Ijazah;

		// Ktp
		$this->Ktp = new DbField('docmhs', 'docmhs', 'x_Ktp', 'Ktp', '[Ktp]', '[Ktp]', 200, 150, -1, TRUE, '[Ktp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->Ktp->Sortable = TRUE; // Allow sort
		$this->fields['Ktp'] = &$this->Ktp;

		// KK
		$this->KK = new DbField('docmhs', 'docmhs', 'x_KK', 'KK', '[KK]', '[KK]', 200, 150, -1, TRUE, '[KK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->KK->Sortable = TRUE; // Allow sort
		$this->fields['KK'] = &$this->KK;

		// tandatangan
		$this->tandatangan = new DbField('docmhs', 'docmhs', 'x_tandatangan', 'tandatangan', '[tandatangan]', '[tandatangan]', 200, 150, -1, TRUE, '[tandatangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->tandatangan->Sortable = TRUE; // Allow sort
		$this->fields['tandatangan'] = &$this->tandatangan;

		// IjazahIM
		$this->IjazahIM = new DbField('docmhs', 'docmhs', 'x_IjazahIM', 'IjazahIM', '[IjazahIM]', '[IjazahIM]', 200, 150, -1, TRUE, '[IjazahIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->IjazahIM->Sortable = TRUE; // Allow sort
		$this->fields['IjazahIM'] = &$this->IjazahIM;

		// TranskriptIM
		$this->TranskriptIM = new DbField('docmhs', 'docmhs', 'x_TranskriptIM', 'TranskriptIM', '[TranskriptIM]', '[TranskriptIM]', 200, 150, -1, TRUE, '[TranskriptIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->TranskriptIM->Sortable = TRUE; // Allow sort
		$this->fields['TranskriptIM'] = &$this->TranskriptIM;

		// Skripsi
		$this->Skripsi = new DbField('docmhs', 'docmhs', 'x_Skripsi', 'Skripsi', '[Skripsi]', '[Skripsi]', 200, 150, -1, TRUE, '[Skripsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->Skripsi->Sortable = TRUE; // Allow sort
		$this->fields['Skripsi'] = &$this->Skripsi;

		// Plagiat
		$this->Plagiat = new DbField('docmhs', 'docmhs', 'x_Plagiat', 'Plagiat', '[Plagiat]', '[Plagiat]', 200, 150, -1, TRUE, '[Plagiat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->Plagiat->Sortable = TRUE; // Allow sort
		$this->fields['Plagiat'] = &$this->Plagiat;

		// riwayatakademik
		$this->riwayatakademik = new DbField('docmhs', 'docmhs', 'x_riwayatakademik', 'riwayatakademik', '[riwayatakademik]', '[riwayatakademik]', 200, 150, -1, TRUE, '[riwayatakademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->riwayatakademik->Sortable = TRUE; // Allow sort
		$this->fields['riwayatakademik'] = &$this->riwayatakademik;

		// keuangan
		$this->keuangan = new DbField('docmhs', 'docmhs', 'x_keuangan', 'keuangan', '[keuangan]', '[keuangan]', 200, 150, -1, TRUE, '[keuangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->keuangan->Sortable = TRUE; // Allow sort
		$this->fields['keuangan'] = &$this->keuangan;

		// pendukung
		$this->pendukung = new DbField('docmhs', 'docmhs', 'x_pendukung', 'pendukung', '[pendukung]', '[pendukung]', 200, 150, -1, TRUE, '[pendukung]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->pendukung->Sortable = TRUE; // Allow sort
		$this->fields['pendukung'] = &$this->pendukung;

		// lainlain
		$this->lainlain = new DbField('docmhs', 'docmhs', 'x_lainlain', 'lainlain', '[lainlain]', '[lainlain]', 200, 150, -1, TRUE, '[lainlain]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->lainlain->Sortable = TRUE; // Allow sort
		$this->fields['lainlain'] = &$this->lainlain;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "ekpt_mhsfeed") {
			if ($this->Nim->getSessionValue() != "")
				$masterFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "IM_Lulusan") {
			if ($this->Nim->getSessionValue() != "")
				$masterFilter .= "[NIM]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "IM_Mhs") {
			if ($this->Nim->getSessionValue() != "")
				$masterFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "ekpt_mhsfeed") {
			if ($this->Nim->getSessionValue() != "")
				$detailFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "IM_Lulusan") {
			if ($this->Nim->getSessionValue() != "")
				$detailFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "IM_Mhs") {
			if ($this->Nim->getSessionValue() != "")
				$detailFilter .= "[Nim]=" . QuotedValue($this->Nim->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_ekpt_mhsfeed()
	{
		return "[Nim]='@Nim@'";
	}

	// Detail filter
	public function sqlDetailFilter_ekpt_mhsfeed()
	{
		return "[Nim]='@Nim@'";
	}

	// Master filter
	public function sqlMasterFilter_IM_Lulusan()
	{
		return "[NIM]='@NIM@'";
	}

	// Detail filter
	public function sqlDetailFilter_IM_Lulusan()
	{
		return "[Nim]='@Nim@'";
	}

	// Master filter
	public function sqlMasterFilter_IM_Mhs()
	{
		return "[Nim]='@Nim@'";
	}

	// Detail filter
	public function sqlDetailFilter_IM_Mhs()
	{
		return "[Nim]='@Nim@'";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[docmhs]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Nim', $rs))
				AddFilter($where, QuotedName('Nim', $this->Dbid) . '=' . QuotedValue($rs['Nim'], $this->Nim->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Nim->DbValue = $row['Nim'];
		$this->Ijazah->Upload->DbValue = $row['Ijazah'];
		$this->Ktp->Upload->DbValue = $row['Ktp'];
		$this->KK->Upload->DbValue = $row['KK'];
		$this->tandatangan->Upload->DbValue = $row['tandatangan'];
		$this->IjazahIM->Upload->DbValue = $row['IjazahIM'];
		$this->TranskriptIM->Upload->DbValue = $row['TranskriptIM'];
		$this->Skripsi->Upload->DbValue = $row['Skripsi'];
		$this->Plagiat->Upload->DbValue = $row['Plagiat'];
		$this->riwayatakademik->Upload->DbValue = $row['riwayatakademik'];
		$this->keuangan->Upload->DbValue = $row['keuangan'];
		$this->pendukung->Upload->DbValue = $row['pendukung'];
		$this->lainlain->Upload->DbValue = $row['lainlain'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->Ijazah->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$oldFiles = EmptyValue($row['Ijazah']) ? [] : [$row['Ijazah']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->Ijazah->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->Ijazah->oldPhysicalUploadPath() . $oldFile);
		}
		$this->Ktp->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$oldFiles = EmptyValue($row['Ktp']) ? [] : [$row['Ktp']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->Ktp->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->Ktp->oldPhysicalUploadPath() . $oldFile);
		}
		$this->KK->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$oldFiles = EmptyValue($row['KK']) ? [] : [$row['KK']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->KK->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->KK->oldPhysicalUploadPath() . $oldFile);
		}
		$this->tandatangan->OldUploadPath = '../../../../D:/www/im/mhs/views/uploads/';
		$oldFiles = EmptyValue($row['tandatangan']) ? [] : [$row['tandatangan']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->tandatangan->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->tandatangan->oldPhysicalUploadPath() . $oldFile);
		}
		$this->IjazahIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$oldFiles = EmptyValue($row['IjazahIM']) ? [] : [$row['IjazahIM']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->IjazahIM->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->IjazahIM->oldPhysicalUploadPath() . $oldFile);
		}
		$this->TranskriptIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$oldFiles = EmptyValue($row['TranskriptIM']) ? [] : [$row['TranskriptIM']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->TranskriptIM->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->TranskriptIM->oldPhysicalUploadPath() . $oldFile);
		}
		$this->Skripsi->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$oldFiles = EmptyValue($row['Skripsi']) ? [] : [$row['Skripsi']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->Skripsi->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->Skripsi->oldPhysicalUploadPath() . $oldFile);
		}
		$this->Plagiat->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$oldFiles = EmptyValue($row['Plagiat']) ? [] : [$row['Plagiat']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->Plagiat->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->Plagiat->oldPhysicalUploadPath() . $oldFile);
		}
		$this->riwayatakademik->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$oldFiles = EmptyValue($row['riwayatakademik']) ? [] : [$row['riwayatakademik']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->riwayatakademik->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->riwayatakademik->oldPhysicalUploadPath() . $oldFile);
		}
		$this->keuangan->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
		$oldFiles = EmptyValue($row['keuangan']) ? [] : [$row['keuangan']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->keuangan->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->keuangan->oldPhysicalUploadPath() . $oldFile);
		}
		$this->pendukung->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
		$oldFiles = EmptyValue($row['pendukung']) ? [] : [$row['pendukung']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->pendukung->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->pendukung->oldPhysicalUploadPath() . $oldFile);
		}
		$this->lainlain->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
		$oldFiles = EmptyValue($row['lainlain']) ? [] : [$row['lainlain']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->lainlain->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->lainlain->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Nim] = '@Nim@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Nim', $row) ? $row['Nim'] : NULL;
		else
			$val = $this->Nim->OldValue !== NULL ? $this->Nim->OldValue : $this->Nim->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Nim@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "docmhslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "docmhsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "docmhsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "docmhsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "docmhslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("docmhsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("docmhsview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "docmhsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "docmhsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("docmhsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("docmhsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("docmhsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "ekpt_mhsfeed" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "IM_Lulusan" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_NIM=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "IM_Mhs" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Nim:" . JsonEncode($this->Nim->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Nim->CurrentValue != NULL) {
			$url .= "Nim=" . urlencode($this->Nim->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("Nim") !== NULL)
				$arKeys[] = Param("Nim");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Nim->CurrentValue = $key;
			else
				$this->Nim->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->Ijazah->Upload->DbValue = $rs->fields('Ijazah');
		$this->Ktp->Upload->DbValue = $rs->fields('Ktp');
		$this->KK->Upload->DbValue = $rs->fields('KK');
		$this->tandatangan->Upload->DbValue = $rs->fields('tandatangan');
		$this->IjazahIM->Upload->DbValue = $rs->fields('IjazahIM');
		$this->TranskriptIM->Upload->DbValue = $rs->fields('TranskriptIM');
		$this->Skripsi->Upload->DbValue = $rs->fields('Skripsi');
		$this->Plagiat->Upload->DbValue = $rs->fields('Plagiat');
		$this->riwayatakademik->Upload->DbValue = $rs->fields('riwayatakademik');
		$this->keuangan->Upload->DbValue = $rs->fields('keuangan');
		$this->pendukung->Upload->DbValue = $rs->fields('pendukung');
		$this->lainlain->Upload->DbValue = $rs->fields('lainlain');
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Nim
		// Ijazah
		// Ktp
		// KK
		// tandatangan
		// IjazahIM
		// TranskriptIM
		// Skripsi
		// Plagiat
		// riwayatakademik
		// keuangan
		// pendukung
		// lainlain
		// Nim

		$this->Nim->ViewValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// Ijazah
		$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
			$this->Ijazah->ViewValue = $this->Ijazah->Upload->DbValue;
		} else {
			$this->Ijazah->ViewValue = "";
		}
		$this->Ijazah->ViewCustomAttributes = "";

		// Ktp
		$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->Ktp->Upload->DbValue)) {
			$this->Ktp->ViewValue = $this->Ktp->Upload->DbValue;
		} else {
			$this->Ktp->ViewValue = "";
		}
		$this->Ktp->ViewCustomAttributes = "";

		// KK
		$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->KK->Upload->DbValue)) {
			$this->KK->ViewValue = $this->KK->Upload->DbValue;
		} else {
			$this->KK->ViewValue = "";
		}
		$this->KK->ViewCustomAttributes = "";

		// tandatangan
		$this->tandatangan->UploadPath = '../../../../D:/www/im/mhs/views/uploads/';
		if (!EmptyValue($this->tandatangan->Upload->DbValue)) {
			$this->tandatangan->ViewValue = $this->tandatangan->Upload->DbValue;
		} else {
			$this->tandatangan->ViewValue = "";
		}
		$this->tandatangan->ViewCustomAttributes = "";

		// IjazahIM
		$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
			$this->IjazahIM->ViewValue = $this->IjazahIM->Upload->DbValue;
		} else {
			$this->IjazahIM->ViewValue = "";
		}
		$this->IjazahIM->ViewCustomAttributes = "";

		// TranskriptIM
		$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
			$this->TranskriptIM->ViewValue = $this->TranskriptIM->Upload->DbValue;
		} else {
			$this->TranskriptIM->ViewValue = "";
		}
		$this->TranskriptIM->ViewCustomAttributes = "";

		// Skripsi
		$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
			$this->Skripsi->ViewValue = $this->Skripsi->Upload->DbValue;
		} else {
			$this->Skripsi->ViewValue = "";
		}
		$this->Skripsi->ViewCustomAttributes = "";

		// Plagiat
		$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
			$this->Plagiat->ViewValue = $this->Plagiat->Upload->DbValue;
		} else {
			$this->Plagiat->ViewValue = "";
		}
		$this->Plagiat->ViewCustomAttributes = "";

		// riwayatakademik
		$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
			$this->riwayatakademik->ViewValue = $this->riwayatakademik->Upload->DbValue;
		} else {
			$this->riwayatakademik->ViewValue = "";
		}
		$this->riwayatakademik->ViewCustomAttributes = "";

		// keuangan
		$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
		if (!EmptyValue($this->keuangan->Upload->DbValue)) {
			$this->keuangan->ViewValue = $this->keuangan->Upload->DbValue;
		} else {
			$this->keuangan->ViewValue = "";
		}
		$this->keuangan->ViewCustomAttributes = "";

		// pendukung
		$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
		if (!EmptyValue($this->pendukung->Upload->DbValue)) {
			$this->pendukung->ViewValue = $this->pendukung->Upload->DbValue;
		} else {
			$this->pendukung->ViewValue = "";
		}
		$this->pendukung->ViewCustomAttributes = "";

		// lainlain
		$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
		if (!EmptyValue($this->lainlain->Upload->DbValue)) {
			$this->lainlain->ViewValue = $this->lainlain->Upload->DbValue;
		} else {
			$this->lainlain->ViewValue = "";
		}
		$this->lainlain->ViewCustomAttributes = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// Ijazah
		$this->Ijazah->LinkCustomAttributes = "";
		$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
			$this->Ijazah->HrefValue = GetFileUploadUrl($this->Ijazah, $this->Ijazah->htmlDecode($this->Ijazah->Upload->DbValue)); // Add prefix/suffix
			$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
		} else {
			$this->Ijazah->HrefValue = "";
		}
		$this->Ijazah->ExportHrefValue = $this->Ijazah->UploadPath . $this->Ijazah->Upload->DbValue;
		$this->Ijazah->TooltipValue = "";

		// Ktp
		$this->Ktp->LinkCustomAttributes = "";
		$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->Ktp->Upload->DbValue)) {
			$this->Ktp->HrefValue = GetFileUploadUrl($this->Ktp, $this->Ktp->htmlDecode($this->Ktp->Upload->DbValue)); // Add prefix/suffix
			$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
		} else {
			$this->Ktp->HrefValue = "";
		}
		$this->Ktp->ExportHrefValue = $this->Ktp->UploadPath . $this->Ktp->Upload->DbValue;
		$this->Ktp->TooltipValue = "";

		// KK
		$this->KK->LinkCustomAttributes = "";
		$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->KK->Upload->DbValue)) {
			$this->KK->HrefValue = GetFileUploadUrl($this->KK, $this->KK->htmlDecode($this->KK->Upload->DbValue)); // Add prefix/suffix
			$this->KK->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
		} else {
			$this->KK->HrefValue = "";
		}
		$this->KK->ExportHrefValue = $this->KK->UploadPath . $this->KK->Upload->DbValue;
		$this->KK->TooltipValue = "";

		// tandatangan
		$this->tandatangan->LinkCustomAttributes = "";
		$this->tandatangan->UploadPath = '../../../../D:/www/im/mhs/views/uploads/';
		if (!EmptyValue($this->tandatangan->Upload->DbValue)) {
			$this->tandatangan->HrefValue = GetFileUploadUrl($this->tandatangan, $this->tandatangan->htmlDecode($this->tandatangan->Upload->DbValue)); // Add prefix/suffix
			$this->tandatangan->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->tandatangan->HrefValue = FullUrl($this->tandatangan->HrefValue, "href");
		} else {
			$this->tandatangan->HrefValue = "";
		}
		$this->tandatangan->ExportHrefValue = $this->tandatangan->UploadPath . $this->tandatangan->Upload->DbValue;
		$this->tandatangan->TooltipValue = "";

		// IjazahIM
		$this->IjazahIM->LinkCustomAttributes = "";
		$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
			$this->IjazahIM->HrefValue = GetFileUploadUrl($this->IjazahIM, $this->IjazahIM->htmlDecode($this->IjazahIM->Upload->DbValue)); // Add prefix/suffix
			$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
		} else {
			$this->IjazahIM->HrefValue = "";
		}
		$this->IjazahIM->ExportHrefValue = $this->IjazahIM->UploadPath . $this->IjazahIM->Upload->DbValue;
		$this->IjazahIM->TooltipValue = "";

		// TranskriptIM
		$this->TranskriptIM->LinkCustomAttributes = "";
		$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
			$this->TranskriptIM->HrefValue = GetFileUploadUrl($this->TranskriptIM, $this->TranskriptIM->htmlDecode($this->TranskriptIM->Upload->DbValue)); // Add prefix/suffix
			$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
		} else {
			$this->TranskriptIM->HrefValue = "";
		}
		$this->TranskriptIM->ExportHrefValue = $this->TranskriptIM->UploadPath . $this->TranskriptIM->Upload->DbValue;
		$this->TranskriptIM->TooltipValue = "";

		// Skripsi
		$this->Skripsi->LinkCustomAttributes = "";
		$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
			$this->Skripsi->HrefValue = GetFileUploadUrl($this->Skripsi, $this->Skripsi->htmlDecode($this->Skripsi->Upload->DbValue)); // Add prefix/suffix
			$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
		} else {
			$this->Skripsi->HrefValue = "";
		}
		$this->Skripsi->ExportHrefValue = $this->Skripsi->UploadPath . $this->Skripsi->Upload->DbValue;
		$this->Skripsi->TooltipValue = "";

		// Plagiat
		$this->Plagiat->LinkCustomAttributes = "";
		$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
			$this->Plagiat->HrefValue = GetFileUploadUrl($this->Plagiat, $this->Plagiat->htmlDecode($this->Plagiat->Upload->DbValue)); // Add prefix/suffix
			$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
		} else {
			$this->Plagiat->HrefValue = "";
		}
		$this->Plagiat->ExportHrefValue = $this->Plagiat->UploadPath . $this->Plagiat->Upload->DbValue;
		$this->Plagiat->TooltipValue = "";

		// riwayatakademik
		$this->riwayatakademik->LinkCustomAttributes = "";
		$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
			$this->riwayatakademik->HrefValue = GetFileUploadUrl($this->riwayatakademik, $this->riwayatakademik->htmlDecode($this->riwayatakademik->Upload->DbValue)); // Add prefix/suffix
			$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
		} else {
			$this->riwayatakademik->HrefValue = "";
		}
		$this->riwayatakademik->ExportHrefValue = $this->riwayatakademik->UploadPath . $this->riwayatakademik->Upload->DbValue;
		$this->riwayatakademik->TooltipValue = "";

		// keuangan
		$this->keuangan->LinkCustomAttributes = "";
		$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
		if (!EmptyValue($this->keuangan->Upload->DbValue)) {
			$this->keuangan->HrefValue = GetFileUploadUrl($this->keuangan, $this->keuangan->htmlDecode($this->keuangan->Upload->DbValue)); // Add prefix/suffix
			$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
		} else {
			$this->keuangan->HrefValue = "";
		}
		$this->keuangan->ExportHrefValue = $this->keuangan->UploadPath . $this->keuangan->Upload->DbValue;
		$this->keuangan->TooltipValue = "";

		// pendukung
		$this->pendukung->LinkCustomAttributes = "";
		$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
		if (!EmptyValue($this->pendukung->Upload->DbValue)) {
			$this->pendukung->HrefValue = GetFileUploadUrl($this->pendukung, $this->pendukung->htmlDecode($this->pendukung->Upload->DbValue)); // Add prefix/suffix
			$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
		} else {
			$this->pendukung->HrefValue = "";
		}
		$this->pendukung->ExportHrefValue = $this->pendukung->UploadPath . $this->pendukung->Upload->DbValue;
		$this->pendukung->TooltipValue = "";

		// lainlain
		$this->lainlain->LinkCustomAttributes = "";
		$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
		if (!EmptyValue($this->lainlain->Upload->DbValue)) {
			$this->lainlain->HrefValue = GetFileUploadUrl($this->lainlain, $this->lainlain->htmlDecode($this->lainlain->Upload->DbValue)); // Add prefix/suffix
			$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
		} else {
			$this->lainlain->HrefValue = "";
		}
		$this->lainlain->ExportHrefValue = $this->lainlain->UploadPath . $this->lainlain->Upload->DbValue;
		$this->lainlain->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";
		if (!$this->Nim->Raw)
			$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
		$this->Nim->EditValue = $this->Nim->CurrentValue;
		$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

		// Ijazah
		$this->Ijazah->EditAttrs["class"] = "form-control";
		$this->Ijazah->EditCustomAttributes = "";
		$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
			$this->Ijazah->EditValue = $this->Ijazah->Upload->DbValue;
		} else {
			$this->Ijazah->EditValue = "";
		}
		if (!EmptyValue($this->Ijazah->CurrentValue))
				$this->Ijazah->Upload->FileName = $this->Ijazah->CurrentValue;

		// Ktp
		$this->Ktp->EditAttrs["class"] = "form-control";
		$this->Ktp->EditCustomAttributes = "";
		$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->Ktp->Upload->DbValue)) {
			$this->Ktp->EditValue = $this->Ktp->Upload->DbValue;
		} else {
			$this->Ktp->EditValue = "";
		}
		if (!EmptyValue($this->Ktp->CurrentValue))
				$this->Ktp->Upload->FileName = $this->Ktp->CurrentValue;

		// KK
		$this->KK->EditAttrs["class"] = "form-control";
		$this->KK->EditCustomAttributes = "";
		$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		if (!EmptyValue($this->KK->Upload->DbValue)) {
			$this->KK->EditValue = $this->KK->Upload->DbValue;
		} else {
			$this->KK->EditValue = "";
		}
		if (!EmptyValue($this->KK->CurrentValue))
				$this->KK->Upload->FileName = $this->KK->CurrentValue;

		// tandatangan
		$this->tandatangan->EditAttrs["class"] = "form-control";
		$this->tandatangan->EditCustomAttributes = "";
		$this->tandatangan->UploadPath = '../../../../D:/www/im/mhs/views/uploads/';
		if (!EmptyValue($this->tandatangan->Upload->DbValue)) {
			$this->tandatangan->EditValue = $this->tandatangan->Upload->DbValue;
		} else {
			$this->tandatangan->EditValue = "";
		}
		if (!EmptyValue($this->tandatangan->CurrentValue))
				$this->tandatangan->Upload->FileName = $this->tandatangan->CurrentValue;

		// IjazahIM
		$this->IjazahIM->EditAttrs["class"] = "form-control";
		$this->IjazahIM->EditCustomAttributes = "";
		$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
			$this->IjazahIM->EditValue = $this->IjazahIM->Upload->DbValue;
		} else {
			$this->IjazahIM->EditValue = "";
		}
		if (!EmptyValue($this->IjazahIM->CurrentValue))
				$this->IjazahIM->Upload->FileName = $this->IjazahIM->CurrentValue;

		// TranskriptIM
		$this->TranskriptIM->EditAttrs["class"] = "form-control";
		$this->TranskriptIM->EditCustomAttributes = "";
		$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
			$this->TranskriptIM->EditValue = $this->TranskriptIM->Upload->DbValue;
		} else {
			$this->TranskriptIM->EditValue = "";
		}
		if (!EmptyValue($this->TranskriptIM->CurrentValue))
				$this->TranskriptIM->Upload->FileName = $this->TranskriptIM->CurrentValue;

		// Skripsi
		$this->Skripsi->EditAttrs["class"] = "form-control";
		$this->Skripsi->EditCustomAttributes = "";
		$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
			$this->Skripsi->EditValue = $this->Skripsi->Upload->DbValue;
		} else {
			$this->Skripsi->EditValue = "";
		}
		if (!EmptyValue($this->Skripsi->CurrentValue))
				$this->Skripsi->Upload->FileName = $this->Skripsi->CurrentValue;

		// Plagiat
		$this->Plagiat->EditAttrs["class"] = "form-control";
		$this->Plagiat->EditCustomAttributes = "";
		$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
			$this->Plagiat->EditValue = $this->Plagiat->Upload->DbValue;
		} else {
			$this->Plagiat->EditValue = "";
		}
		if (!EmptyValue($this->Plagiat->CurrentValue))
				$this->Plagiat->Upload->FileName = $this->Plagiat->CurrentValue;

		// riwayatakademik
		$this->riwayatakademik->EditAttrs["class"] = "form-control";
		$this->riwayatakademik->EditCustomAttributes = "";
		$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
			$this->riwayatakademik->EditValue = $this->riwayatakademik->Upload->DbValue;
		} else {
			$this->riwayatakademik->EditValue = "";
		}
		if (!EmptyValue($this->riwayatakademik->CurrentValue))
				$this->riwayatakademik->Upload->FileName = $this->riwayatakademik->CurrentValue;

		// keuangan
		$this->keuangan->EditAttrs["class"] = "form-control";
		$this->keuangan->EditCustomAttributes = "";
		$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
		if (!EmptyValue($this->keuangan->Upload->DbValue)) {
			$this->keuangan->EditValue = $this->keuangan->Upload->DbValue;
		} else {
			$this->keuangan->EditValue = "";
		}
		if (!EmptyValue($this->keuangan->CurrentValue))
				$this->keuangan->Upload->FileName = $this->keuangan->CurrentValue;

		// pendukung
		$this->pendukung->EditAttrs["class"] = "form-control";
		$this->pendukung->EditCustomAttributes = "";
		$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
		if (!EmptyValue($this->pendukung->Upload->DbValue)) {
			$this->pendukung->EditValue = $this->pendukung->Upload->DbValue;
		} else {
			$this->pendukung->EditValue = "";
		}
		if (!EmptyValue($this->pendukung->CurrentValue))
				$this->pendukung->Upload->FileName = $this->pendukung->CurrentValue;

		// lainlain
		$this->lainlain->EditAttrs["class"] = "form-control";
		$this->lainlain->EditCustomAttributes = "";
		$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
		if (!EmptyValue($this->lainlain->Upload->DbValue)) {
			$this->lainlain->EditValue = $this->lainlain->Upload->DbValue;
		} else {
			$this->lainlain->EditValue = "";
		}
		if (!EmptyValue($this->lainlain->CurrentValue))
				$this->lainlain->Upload->FileName = $this->lainlain->CurrentValue;

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Ijazah);
					$doc->exportCaption($this->Ktp);
					$doc->exportCaption($this->KK);
					$doc->exportCaption($this->tandatangan);
					$doc->exportCaption($this->IjazahIM);
					$doc->exportCaption($this->TranskriptIM);
					$doc->exportCaption($this->Skripsi);
					$doc->exportCaption($this->Plagiat);
					$doc->exportCaption($this->riwayatakademik);
					$doc->exportCaption($this->keuangan);
					$doc->exportCaption($this->pendukung);
					$doc->exportCaption($this->lainlain);
				} else {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Ijazah);
					$doc->exportCaption($this->Ktp);
					$doc->exportCaption($this->KK);
					$doc->exportCaption($this->tandatangan);
					$doc->exportCaption($this->IjazahIM);
					$doc->exportCaption($this->TranskriptIM);
					$doc->exportCaption($this->Skripsi);
					$doc->exportCaption($this->Plagiat);
					$doc->exportCaption($this->riwayatakademik);
					$doc->exportCaption($this->keuangan);
					$doc->exportCaption($this->pendukung);
					$doc->exportCaption($this->lainlain);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Ijazah);
						$doc->exportField($this->Ktp);
						$doc->exportField($this->KK);
						$doc->exportField($this->tandatangan);
						$doc->exportField($this->IjazahIM);
						$doc->exportField($this->TranskriptIM);
						$doc->exportField($this->Skripsi);
						$doc->exportField($this->Plagiat);
						$doc->exportField($this->riwayatakademik);
						$doc->exportField($this->keuangan);
						$doc->exportField($this->pendukung);
						$doc->exportField($this->lainlain);
					} else {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Ijazah);
						$doc->exportField($this->Ktp);
						$doc->exportField($this->KK);
						$doc->exportField($this->tandatangan);
						$doc->exportField($this->IjazahIM);
						$doc->exportField($this->TranskriptIM);
						$doc->exportField($this->Skripsi);
						$doc->exportField($this->Plagiat);
						$doc->exportField($this->riwayatakademik);
						$doc->exportField($this->keuangan);
						$doc->exportField($this->pendukung);
						$doc->exportField($this->lainlain);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{
		$width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
		$height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'Ijazah') {
			$fldName = "Ijazah";
			$fileNameFld = "Ijazah";
		} elseif ($fldparm == 'Ktp') {
			$fldName = "Ktp";
			$fileNameFld = "Ktp";
		} elseif ($fldparm == 'KK') {
			$fldName = "KK";
			$fileNameFld = "KK";
		} elseif ($fldparm == 'tandatangan') {
			$fldName = "tandatangan";
			$fileNameFld = "tandatangan";
		} elseif ($fldparm == 'IjazahIM') {
			$fldName = "IjazahIM";
			$fileNameFld = "IjazahIM";
		} elseif ($fldparm == 'TranskriptIM') {
			$fldName = "TranskriptIM";
			$fileNameFld = "TranskriptIM";
		} elseif ($fldparm == 'Skripsi') {
			$fldName = "Skripsi";
			$fileNameFld = "Skripsi";
		} elseif ($fldparm == 'Plagiat') {
			$fldName = "Plagiat";
			$fileNameFld = "Plagiat";
		} elseif ($fldparm == 'riwayatakademik') {
			$fldName = "riwayatakademik";
			$fileNameFld = "riwayatakademik";
		} elseif ($fldparm == 'keuangan') {
			$fldName = "keuangan";
			$fileNameFld = "keuangan";
		} elseif ($fldparm == 'pendukung') {
			$fldName = "pendukung";
			$fileNameFld = "pendukung";
		} elseif ($fldparm == 'lainlain') {
			$fldName = "lainlain";
			$fileNameFld = "lainlain";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($ar) == 1) {
			$this->Nim->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype != "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld != "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					$downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
					if ($fileNameFld != "" && !EmptyValue($rs->fields($fileNameFld))) {
						$fileName = $rs->fields($fileNameFld);
						$pathinfo = pathinfo($fileName);
						$ext = strtolower(@$pathinfo["extension"]);
						$isPdf = SameText($ext, "pdf");
						if ($downloadPdf || !$isPdf) // Skip header if not download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					} else {
						$ext = ContentExtension($val);
						$isPdf = SameText($ext, ".pdf");
						if ($isPdf && $downloadPdf) // Add header if download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					}

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear any debug message
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>